/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import org.ovirt.engine.sdk4.internal.containers.OpenStackNetworkContainer;
import org.ovirt.engine.sdk4.types.OpenStackNetwork;
import org.ovirt.engine.sdk4.types.OpenStackNetworkProvider;

public class OpenStackNetworkBuilder {
    private String comment;
    private String description;
    private String href;
    private String id;
    private String name;
    private OpenStackNetworkProvider openstackNetworkProvider;
    
    public OpenStackNetworkBuilder comment(String newComment) {
        comment = newComment;
        return this;
    }
    
    
    public OpenStackNetworkBuilder description(String newDescription) {
        description = newDescription;
        return this;
    }
    
    
    public OpenStackNetworkBuilder href(String newHref) {
        href = newHref;
        return this;
    }
    
    
    public OpenStackNetworkBuilder id(String newId) {
        id = newId;
        return this;
    }
    
    
    public OpenStackNetworkBuilder name(String newName) {
        name = newName;
        return this;
    }
    
    
    public OpenStackNetworkBuilder openstackNetworkProvider(OpenStackNetworkProvider newOpenstackNetworkProvider) {
        openstackNetworkProvider = newOpenstackNetworkProvider;
        return this;
    }
    
    public OpenStackNetworkBuilder openstackNetworkProvider(OpenStackNetworkProviderBuilder newOpenstackNetworkProvider) {
        if (newOpenstackNetworkProvider == null) {
            openstackNetworkProvider = null;
        }
        else {
            openstackNetworkProvider = newOpenstackNetworkProvider.build();
        }
        return this;
    }
    
    
    public OpenStackNetwork build() {
        OpenStackNetworkContainer container = new OpenStackNetworkContainer();
        container.comment(comment);
        container.description(description);
        container.href(href);
        container.id(id);
        container.name(name);
        container.openstackNetworkProvider(openstackNetworkProvider);
        return container;
    }
}
