/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.internal.containers.NfsProfileDetailContainer;
import org.ovirt.engine.sdk4.types.NfsProfileDetail;
import org.ovirt.engine.sdk4.types.ProfileDetail;

public class NfsProfileDetailBuilder {
    private String nfsServerIp;
    private List<ProfileDetail> profileDetails;
    
    public NfsProfileDetailBuilder nfsServerIp(String newNfsServerIp) {
        nfsServerIp = newNfsServerIp;
        return this;
    }
    
    
    public NfsProfileDetailBuilder profileDetails(List<ProfileDetail> newProfileDetails) {
        if (newProfileDetails != null) {
            if (profileDetails == null) {
                profileDetails = new ArrayList<>(newProfileDetails);
            }
            else {
                profileDetails.addAll(newProfileDetails);
            }
        }
        return this;
    }
    
    public NfsProfileDetailBuilder profileDetails(ProfileDetail... newProfileDetails) {
        if (newProfileDetails != null) {
            if (profileDetails == null) {
                profileDetails = new ArrayList<>(newProfileDetails.length);
            }
            Collections.addAll(profileDetails, newProfileDetails);
        }
        return this;
    }
    
    public NfsProfileDetailBuilder profileDetails(ProfileDetailBuilder... newProfileDetails) {
        if (newProfileDetails != null) {
            if (profileDetails == null) {
                profileDetails = new ArrayList<>(newProfileDetails.length);
            }
            for (ProfileDetailBuilder builder : newProfileDetails) {
                profileDetails.add(builder.build());
            }
        }
        return this;
    }
    
    
    public NfsProfileDetail build() {
        NfsProfileDetailContainer container = new NfsProfileDetailContainer();
        container.nfsServerIp(nfsServerIp);
        container.profileDetails(profileDetails);
        return container;
    }
}
