/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import org.ovirt.engine.sdk4.internal.containers.ImageContainer;
import org.ovirt.engine.sdk4.types.Image;
import org.ovirt.engine.sdk4.types.StorageDomain;

public class ImageBuilder {
    private String comment;
    private String description;
    private String href;
    private String id;
    private String name;
    private StorageDomain storageDomain;
    
    public ImageBuilder comment(String newComment) {
        comment = newComment;
        return this;
    }
    
    
    public ImageBuilder description(String newDescription) {
        description = newDescription;
        return this;
    }
    
    
    public ImageBuilder href(String newHref) {
        href = newHref;
        return this;
    }
    
    
    public ImageBuilder id(String newId) {
        id = newId;
        return this;
    }
    
    
    public ImageBuilder name(String newName) {
        name = newName;
        return this;
    }
    
    
    public ImageBuilder storageDomain(StorageDomain newStorageDomain) {
        storageDomain = newStorageDomain;
        return this;
    }
    
    public ImageBuilder storageDomain(StorageDomainBuilder newStorageDomain) {
        if (newStorageDomain == null) {
            storageDomain = null;
        }
        else {
            storageDomain = newStorageDomain.build();
        }
        return this;
    }
    
    
    public Image build() {
        ImageContainer container = new ImageContainer();
        container.comment(comment);
        container.description(description);
        container.href(href);
        container.id(id);
        container.name(name);
        container.storageDomain(storageDomain);
        return container;
    }
}
