/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.Boolean;
import org.ovirt.engine.sdk4.internal.containers.AffinityRuleContainer;
import org.ovirt.engine.sdk4.types.AffinityRule;

public class AffinityRuleBuilder {
    private Boolean enabled;
    private Boolean enforcing;
    private Boolean positive;
    
    public AffinityRuleBuilder enabled(boolean newEnabled) {
        enabled = Boolean.valueOf(newEnabled);
        return this;
    }
    
    public AffinityRuleBuilder enabled(Boolean newEnabled) {
        enabled = newEnabled;
        return this;
    }
    
    
    public AffinityRuleBuilder enforcing(boolean newEnforcing) {
        enforcing = Boolean.valueOf(newEnforcing);
        return this;
    }
    
    public AffinityRuleBuilder enforcing(Boolean newEnforcing) {
        enforcing = newEnforcing;
        return this;
    }
    
    
    public AffinityRuleBuilder positive(boolean newPositive) {
        positive = Boolean.valueOf(newPositive);
        return this;
    }
    
    public AffinityRuleBuilder positive(Boolean newPositive) {
        positive = newPositive;
        return this;
    }
    
    
    public AffinityRule build() {
        AffinityRuleContainer container = new AffinityRuleContainer();
        container.enabled(enabled);
        container.enforcing(enforcing);
        container.positive(positive);
        return container;
    }
}
