/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.VlanContainer;
import org.ovirt.engine.sdk4.types.Vlan;

public class XmlVlanReader {
    public static Vlan readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        VlanContainer object = new VlanContainer();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "id": {
                    object.id(new BigInteger(image));
                    continue block6;
                }
            }
        }
        reader.next();
        while (reader.forward()) {
            reader.skip();
        }
        reader.next();
        return object;
    }

    public static Iterator<Vlan> iterateMany(final XmlReader reader) {
        return new Iterator<Vlan>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Vlan next() {
                Vlan next = XmlVlanReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Vlan> readMany(XmlReader reader) {
        ArrayList<Vlan> list = new ArrayList<Vlan>();
        Iterator<Vlan> iterator = XmlVlanReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void readLink(XmlReader reader, VlanContainer object) {
        String rel = null;
        String href = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrVal = reader.getAttributeValue(i);
            switch (attrName) {
                case "href": {
                    href = attrVal;
                    continue block8;
                }
                case "rel": {
                    rel = attrVal;
                    continue block8;
                }
                default: {
                    reader.skip();
                }
            }
        }
        reader.skip();
    }
}

