/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.VersionContainer;
import org.ovirt.engine.sdk4.types.Version;

public class XmlVersionReader {
    public static Version readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        VersionContainer object = new VersionContainer();
        block30: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block30;
                }
                case "id": {
                    object.id(image);
                    continue block30;
                }
            }
        }
        reader.next();
        block31: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "build": {
                    object.build(reader.readInteger());
                    continue block31;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block31;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block31;
                }
                case "full_version": {
                    object.fullVersion(reader.readString());
                    continue block31;
                }
                case "major": {
                    object.major(reader.readInteger());
                    continue block31;
                }
                case "minor": {
                    object.minor(reader.readInteger());
                    continue block31;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block31;
                }
                case "revision": {
                    object.revision(reader.readInteger());
                    continue block31;
                }
                case "link": {
                    XmlVersionReader.readLink(reader, object);
                    continue block31;
                }
            }
            reader.skip();
        }
        reader.next();
        return object;
    }

    public static Iterator<Version> iterateMany(final XmlReader reader) {
        return new Iterator<Version>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Version next() {
                Version next = XmlVersionReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Version> readMany(XmlReader reader) {
        ArrayList<Version> list = new ArrayList<Version>();
        Iterator<Version> iterator = XmlVersionReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void readLink(XmlReader reader, VersionContainer object) {
        String rel = null;
        String href = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrVal = reader.getAttributeValue(i);
            switch (attrName) {
                case "href": {
                    href = attrVal;
                    continue block8;
                }
                case "rel": {
                    rel = attrVal;
                    continue block8;
                }
                default: {
                    reader.skip();
                }
            }
        }
        reader.skip();
    }
}

