/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.KsmContainer;
import org.ovirt.engine.sdk4.types.Ksm;

public class XmlKsmReader {
    public static Ksm readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        KsmContainer object = new KsmContainer();
        reader.next();
        block10: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "enabled": {
                    object.enabled(reader.readBoolean());
                    continue block10;
                }
                case "merge_across_nodes": {
                    object.mergeAcrossNodes(reader.readBoolean());
                    continue block10;
                }
                case "link": {
                    XmlKsmReader.readLink(reader, object);
                    continue block10;
                }
            }
            reader.skip();
        }
        reader.next();
        return object;
    }

    public static Iterator<Ksm> iterateMany(final XmlReader reader) {
        return new Iterator<Ksm>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Ksm next() {
                Ksm next = XmlKsmReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Ksm> readMany(XmlReader reader) {
        ArrayList<Ksm> list = new ArrayList<Ksm>();
        Iterator<Ksm> iterator = XmlKsmReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void readLink(XmlReader reader, KsmContainer object) {
        String rel = null;
        String href = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrVal = reader.getAttributeValue(i);
            switch (attrName) {
                case "href": {
                    href = attrVal;
                    continue block8;
                }
                case "rel": {
                    rel = attrVal;
                    continue block8;
                }
                default: {
                    reader.skip();
                }
            }
        }
        reader.skip();
    }
}

