/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.internal.containers.VmPlacementPolicyContainer;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.VmAffinity;
import org.ovirt.engine.sdk4.types.VmPlacementPolicy;

public class VmPlacementPolicyBuilder {
    private VmAffinity affinity;
    private List<Host> hosts;

    public VmPlacementPolicyBuilder affinity(VmAffinity newAffinity) {
        this.affinity = newAffinity;
        return this;
    }

    public VmPlacementPolicyBuilder hosts(List<Host> newHosts) {
        if (newHosts != null) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<Host>(newHosts);
            } else {
                this.hosts.addAll(newHosts);
            }
        }
        return this;
    }

    public VmPlacementPolicyBuilder hosts(Host ... newHosts) {
        if (newHosts != null) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<Host>(newHosts.length);
            }
            Collections.addAll(this.hosts, newHosts);
        }
        return this;
    }

    public VmPlacementPolicyBuilder hosts(HostBuilder ... newHosts) {
        if (newHosts != null) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<Host>(newHosts.length);
            }
            for (HostBuilder builder : newHosts) {
                this.hosts.add(builder.build());
            }
        }
        return this;
    }

    public VmPlacementPolicy build() {
        VmPlacementPolicyContainer container = new VmPlacementPolicyContainer();
        container.affinity(this.affinity);
        container.hosts(this.hosts);
        return container;
    }
}

