/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.internal.containers.DnsContainer;
import org.ovirt.engine.sdk4.types.Dns;
import org.ovirt.engine.sdk4.types.Host;

public class DnsBuilder {
    private List<Host> searchDomains;
    private List<Host> servers;

    public DnsBuilder searchDomains(List<Host> newSearchDomains) {
        if (newSearchDomains != null) {
            if (this.searchDomains == null) {
                this.searchDomains = new ArrayList<Host>(newSearchDomains);
            } else {
                this.searchDomains.addAll(newSearchDomains);
            }
        }
        return this;
    }

    public DnsBuilder searchDomains(Host ... newSearchDomains) {
        if (newSearchDomains != null) {
            if (this.searchDomains == null) {
                this.searchDomains = new ArrayList<Host>(newSearchDomains.length);
            }
            Collections.addAll(this.searchDomains, newSearchDomains);
        }
        return this;
    }

    public DnsBuilder searchDomains(HostBuilder ... newSearchDomains) {
        if (newSearchDomains != null) {
            if (this.searchDomains == null) {
                this.searchDomains = new ArrayList<Host>(newSearchDomains.length);
            }
            for (HostBuilder builder : newSearchDomains) {
                this.searchDomains.add(builder.build());
            }
        }
        return this;
    }

    public DnsBuilder servers(List<Host> newServers) {
        if (newServers != null) {
            if (this.servers == null) {
                this.servers = new ArrayList<Host>(newServers);
            } else {
                this.servers.addAll(newServers);
            }
        }
        return this;
    }

    public DnsBuilder servers(Host ... newServers) {
        if (newServers != null) {
            if (this.servers == null) {
                this.servers = new ArrayList<Host>(newServers.length);
            }
            Collections.addAll(this.servers, newServers);
        }
        return this;
    }

    public DnsBuilder servers(HostBuilder ... newServers) {
        if (newServers != null) {
            if (this.servers == null) {
                this.servers = new ArrayList<Host>(newServers.length);
            }
            for (HostBuilder builder : newServers) {
                this.servers.add(builder.build());
            }
        }
        return this;
    }

    public Dns build() {
        DnsContainer container = new DnsContainer();
        container.searchDomains(this.searchDomains);
        container.servers(this.servers);
        return container;
    }
}

