--
-- This file is part of TALER
-- Copyright (C) 2025 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

-- @file merchant-0015.sql
-- @brief Tables for statistics
-- @author Christian Grothoff


BEGIN;

-- Check patch versioning is in place.
SELECT _v.register_patch('merchant-0015', NULL, NULL);

SET search_path TO merchant;

ALTER TABLE merchant_kyc
  ADD last_rule_gen INT8 NOT NULL DEFAULT (0);

COMMENT ON COLUMN merchant_kyc.last_rule_gen
  IS 'Row ID from the exchange identifying the last decision change to KYC rules on this account. To be used when long-polling to ask for changes. 0 if no custom decisions were taken for the account';

COMMIT;
