/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file exchangedb/pg_lookup_aml_file_number.h
 * @brief implementation of the lookup_aml_file_number function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_LOOKUP_AML_FILE_NUMBER_H
#define PG_LOOKUP_AML_FILE_NUMBER_H

#include "taler/taler_util.h"
#include "taler/taler_json_lib.h"
#include "taler/taler_exchangedb_plugin.h"


/**
 * Lookup AML file number by the payto address.
 *
 * @param cls closure
 * @param h_payto account for which to find the row ID
 * @param[out] kyc_target_row set to row in the kyc_targets table for @a h_payto
 * @param[out] is_wallet set to true if this account is for a wallet
 * @return database transaction status
 */
enum GNUNET_DB_QueryStatus
TEH_PG_lookup_aml_file_number (
  void *cls,
  const struct TALER_NormalizedPaytoHashP *h_payto,
  uint64_t *kyc_target_row,
  bool *is_wallet);


#endif
