/*
 * Decompiled with CFR 0.152.
 */
package qalbum;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import gnu.text.Path;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Date;

public class ImageInfo {
    Metadata metadata;
    Directory exifDirectory;
    int width;
    int height;
    Path filename;
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifDirectory;
    static /* synthetic */ Class class$com$drew$metadata$jpeg$JpegDirectory;

    public static ImageInfo readMetadata(Object object) throws Throwable {
        Path path = Path.valueOf((Object)object);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(path.openInputStream());
        Metadata metadata = JpegMetadataReader.readMetadata((InputStream)bufferedInputStream);
        Directory directory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ImageInfo.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        Directory directory2 = metadata.getDirectory(class$com$drew$metadata$jpeg$JpegDirectory == null ? (class$com$drew$metadata$jpeg$JpegDirectory = ImageInfo.class$("com.drew.metadata.jpeg.JpegDirectory")) : class$com$drew$metadata$jpeg$JpegDirectory);
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.metadata = metadata;
        imageInfo.exifDirectory = directory;
        imageInfo.width = directory2.getInt(3);
        imageInfo.height = directory2.getInt(1);
        imageInfo.filename = path;
        return imageInfo;
    }

    public String getExifString(int n) {
        return this.exifDirectory.getString(n);
    }

    public String getExifDescription(int n) {
        return this.getDescription(n, this.exifDirectory);
    }

    public String getDescription(int n, Directory directory) {
        try {
            return directory.getDescription(n);
        }
        catch (Throwable throwable) {
            return this.getExifString(n);
        }
    }

    public void appendExifString(String string, int n, StringBuffer stringBuffer) {
        String string2 = this.getDescription(n, this.exifDirectory);
        if (string2 == null) {
            return;
        }
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append('\n');
    }

    public double exifDouble(int n) {
        try {
            return this.exifDirectory.getDouble(n);
        }
        catch (Throwable throwable) {
            return 0.0;
        }
    }

    public static String readCommonValues(String string) throws Throwable {
        return ImageInfo.readMetadata(string).getCommonValues();
    }

    public String getCommonValues() {
        double d = 0.0;
        double d2 = 0.0;
        float f = 0.0f;
        try {
            int n = this.exifDirectory.getInt(41488);
            switch (n) {
                case 1: {
                    d = 25.4;
                    break;
                }
                case 2: {
                    d = 25.4;
                    break;
                }
                case 3: {
                    d = 10.0;
                    break;
                }
                case 4: {
                    d = 1.0;
                    break;
                }
                case 5: {
                    d = 0.001;
                    break;
                }
                default: {
                    d = 0.0;
                }
            }
            d2 = this.exifDirectory.getDouble(41486);
            f = (float)((double)((int)((double)(100 * this.width) * d / d2 + 0.5)) / 100.0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("File name:     ");
        stringBuffer.append(this.filename);
        stringBuffer.append('\n');
        stringBuffer.append("File size:     ");
        stringBuffer.append(this.filename.getContentLength());
        stringBuffer.append(" bytes\n");
        stringBuffer.append("File date:     ");
        stringBuffer.append(new Date(this.filename.getLastModified()));
        stringBuffer.append('\n');
        this.appendExifString("Camera make:   ", 271, stringBuffer);
        this.appendExifString("Camera model:  ", 272, stringBuffer);
        this.appendExifString("Date/Time:     ", 306, stringBuffer);
        stringBuffer.append("Resolution:    ");
        stringBuffer.append(this.width);
        stringBuffer.append(" x ");
        stringBuffer.append(this.height);
        stringBuffer.append('\n');
        double d3 = this.exifDouble(37386);
        String string = this.getExifDescription(37386);
        if (d3 != 0.0 && string != null) {
            stringBuffer.append("Focal length:  ");
            stringBuffer.append(string);
            if (f > 0.0f) {
                stringBuffer.append(" (35mm equivalent: ");
                stringBuffer.append((int)(d3 / (double)f * 35.0 + 0.5));
                stringBuffer.append("mm)");
            }
            stringBuffer.append('\n');
        }
        if (f > 0.0f) {
            stringBuffer.append("CCD width:     ");
            stringBuffer.append(f);
            stringBuffer.append("mm\n");
        }
        if (this.exifDirectory.containsTag(37377)) {
            this.appendExifString("Shutter speed: ", 37377, stringBuffer);
        } else {
            this.appendExifString("Exposure time: ", 33434, stringBuffer);
        }
        this.appendExifString("Aperture:      ", 33437, stringBuffer);
        this.appendExifString("ISO equiv.:    ", 34855, stringBuffer);
        this.appendExifString("Metering mode: ", 37383, stringBuffer);
        this.appendExifString("Exposure:      ", 34850, stringBuffer);
        this.appendExifString("JPG quality:   ", 37122, stringBuffer);
        return stringBuffer.toString();
    }

    public String toString() {
        return "ImageInfo[" + this.filename + "]";
    }

    public static void main(String[] stringArray) throws Throwable {
        for (int i = 0; i < stringArray.length; ++i) {
            System.err.print(ImageInfo.readCommonValues(stringArray[i]));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

