/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.lists.CharBuffer;
import gnu.mapping.OutPort;
import gnu.text.QueueReader;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextPane;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import kawa.ReplDocument;
import kawa.ReplEditorKit;

public class ReplPane
extends JTextPane
implements KeyListener {
    ReplDocument document;
    public static final String ViewableElementName = "Viewable";
    public static final String PaintableElementName = "Paintable";
    public static final Object ViewableAttribute = new String("Viewable");
    public static final Object PaintableAttribute = new String("Paintable");

    public ReplPane(ReplDocument document) {
        super(document);
        this.document = document;
        document.pane = this;
        ++document.paneCount;
        this.addKeyListener(this);
        this.addFocusListener(document);
        EditorKit kit = this.getEditorKit();
        this.setCaretPosition(document.outputMark);
    }

    protected EditorKit createDefaultEditorKit() {
        return new ReplEditorKit(this);
    }

    public void removeNotify() {
        super.removeNotify();
        if (--this.document.paneCount == 0) {
            this.document.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enter() {
        int pos = this.getCaretPosition();
        CharBuffer b = this.document.content.buffer;
        int len = b.length() - 1;
        this.document.endMark = -1;
        if (pos >= this.document.outputMark) {
            int lineAfterCaret = b.indexOf(10, pos);
            if (lineAfterCaret == len) {
                if (len > this.document.outputMark && b.charAt(len - 1) == '\n') {
                    --lineAfterCaret;
                } else {
                    this.document.insertString(len, "\n", null);
                }
            }
            this.document.endMark = lineAfterCaret;
            QueueReader queueReader = this.document.in_r;
            synchronized (queueReader) {
                this.document.in_r.notifyAll();
            }
            if (pos <= lineAfterCaret) {
                this.setCaretPosition(lineAfterCaret + 1);
            }
        } else {
            int lineBefore = pos == 0 ? 0 : 1 + b.lastIndexOf(10, pos - 1);
            Element el = this.document.getCharacterElement(lineBefore);
            int lineAfter = b.indexOf(10, pos);
            if (el.getAttributes().isEqual(ReplDocument.promptStyle)) {
                lineBefore = el.getEndOffset();
            }
            String str = lineAfter < 0 ? b.substring(lineBefore, len) + '\n' : b.substring(lineBefore, lineAfter + 1);
            this.setCaretPosition(this.document.outputMark);
            this.document.write(str, ReplDocument.inputStyle);
            if (this.document.in_r != null) {
                this.document.in_r.append(str, 0, str.length());
            }
        }
    }

    public MutableAttributeSet getInputAttributes() {
        return ReplDocument.inputStyle;
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 10) {
            this.enter();
            e.consume();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public OutPort getStdout() {
        return this.document.out_stream;
    }

    public OutPort getStderr() {
        return this.document.err_stream;
    }
}

