package taldir

import (
	"log"
)

type LogLevel int

const (
	LogError LogLevel = iota
	LogWarning
	LogInfo
	LogDebug
)

var LoglevelStringMap = map[LogLevel]string{
	LogDebug:   "DEBUG",
	LogError:   "ERROR",
	LogWarning: "WARN",
	LogInfo:    "INFO",
}

type TaldirLogger struct {
	// Internal logger
	InternalLogger *log.Logger

	// Loglevel
	logLevel LogLevel
}

func (l *TaldirLogger) Logf(loglevel LogLevel, fmt string, args ...any) {
	if loglevel > l.logLevel {
		return
	}
	l.InternalLogger.SetPrefix("taler-directory - " + LoglevelStringMap[loglevel] + " ")
	l.InternalLogger.Printf(fmt, args...)
}
