/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ColorPatternPanel;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LayersTab
extends PreferencePanel {
    private Map<Layer, ColorPatternPanel.Info> layerMap;
    private Map<String, ColorPatternPanel.Info> transAndSpecialMap;
    private Map<User.ColorPrefType, String> nameTypeSpecialMap;
    private Map<Technology, Color[]> colorMapMap;
    private ColorPatternPanel colorAndPatternPanel;
    private JComboBox sortCombo;
    private Layer defaultArtworkLayer;
    private static final String DEFAULT_ARTWORK = "Special: DEFAULT ARTWORK";
    private JComboBox layerName;
    private JLabel layerTechName;
    private JLabel layerTechName1;
    private JPanel layers;
    private JComboBox technology;

    public LayersTab(PreferencesFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        JPanel sortForm = new JPanel();
        sortForm.setLayout(new GridBagLayout());
        JLabel sortLabel = new JLabel();
        sortLabel.setText("Layers sorted by: ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        sortForm.add((Component)sortLabel, gridBagConstraints);
        this.sortCombo = new JComboBox();
        for (Layer.LayerSortingType s : Layer.LayerSortingType.values()) {
            this.sortCombo.addItem(s);
        }
        this.setSorting();
        this.sortCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayersTab.this.sortingSelected(true);
            }
        });
        sortForm.add((Component)this.sortCombo, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layers.add((Component)sortForm, gridBagConstraints);
        this.colorAndPatternPanel = new ColorPatternPanel(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.anchor = 18;
        this.layers.add((Component)this.colorAndPatternPanel, gbc);
        this.layerMap = new HashMap<Layer, ColorPatternPanel.Info>();
        this.transAndSpecialMap = new HashMap<String, ColorPatternPanel.Info>();
        this.nameTypeSpecialMap = new HashMap<User.ColorPrefType, String>();
        this.colorMapMap = new HashMap<Technology, Color[]>();
        this.layerName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayersTab.this.layerSelected();
            }
        });
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            this.technology.addItem(tech.getTechName());
        }
        this.technology.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayersTab.this.setTechnology();
            }
        });
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.layers;
    }

    @Override
    public String getName() {
        return "Layers";
    }

    @Override
    public void init() {
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            Iterator<Layer> lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Layer layer = lIt.next();
                if (!(tech instanceof Artwork)) continue;
                assert (layer.getName().equals("Graphics"));
                this.defaultArtworkLayer = layer;
            }
        }
        this.nameTypeSpecialMap.put(User.ColorPrefType.BACKGROUND, "Special: BACKGROUND");
        this.nameTypeSpecialMap.put(User.ColorPrefType.GRID, "Special: GRID");
        this.nameTypeSpecialMap.put(User.ColorPrefType.MEASUREMENT, "Special: MEASUREMENT");
        this.nameTypeSpecialMap.put(User.ColorPrefType.HIGHLIGHT, "Special: HIGHLIGHT");
        this.nameTypeSpecialMap.put(User.ColorPrefType.NODE_HIGHLIGHT, "Special: NODE HIGHLIGHT");
        this.nameTypeSpecialMap.put(User.ColorPrefType.MOUSEOVER_HIGHLIGHT, "Special: MOUSE-OVER HIGHLIGHT");
        this.nameTypeSpecialMap.put(User.ColorPrefType.PORT_HIGHLIGHT, "Special: PORT HIGHLIGHT");
        this.nameTypeSpecialMap.put(User.ColorPrefType.TEXT, "Special: TEXT");
        this.nameTypeSpecialMap.put(User.ColorPrefType.INSTANCE, "Special: INSTANCE OUTLINES");
        this.nameTypeSpecialMap.put(User.ColorPrefType.DOWNINPLACEBORDER, "Special: DOWN-IN-PLACE BORDER");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_BACKGROUND, "Special: WAVEFORM BACKGROUND");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_FOREGROUND, "Special: WAVEFORM FOREGROUND");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_STIMULI, "Special: WAVEFORM STIMULI");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_OFF_STRENGTH, "Special: WAVEFORM OFF STRENGTH");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_NODE_STRENGTH, "Special: WAVEFORM NODE (WEAK) STRENGTH");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_GATE_STRENGTH, "Special: WAVEFORM GATE STRENGTH");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_POWER_STRENGTH, "Special: WAVEFORM POWER STRENGTH");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_CROSS_LOW, "Special: WAVEFORM CROSSPROBE LOW");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_CROSS_HIGH, "Special: WAVEFORM CROSSPROBE HIGH");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_CROSS_UNDEF, "Special: WAVEFORM CROSSPROBE UNDEFINED");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_CROSS_FLOAT, "Special: WAVEFORM CROSSPROBE FLOATING");
        try {
            Class<?> j3DUtilsClass = Resources.get3DClass("utils.J3DUtils");
            if (j3DUtilsClass != null) {
                Method setMethod = j3DUtilsClass.getDeclaredMethod("get3DColorsInTab", Map.class);
                setMethod.invoke(j3DUtilsClass, this.nameTypeSpecialMap);
            }
        }
        catch (Exception e) {
            System.out.println("Error calling 3D plugin method get3DColorsInTab");
            e.printStackTrace();
        }
        this.cacheLayerInfo(false);
        this.technology.setSelectedItem(Technology.getCurrent().getTechName());
        this.setSorting();
    }

    public void cacheLayerInfo(boolean redraw) {
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            List<Layer> list = tech.getLayersSortedByUserPreference();
            for (Layer layer : list) {
                ColorPatternPanel.Info li = new ColorPatternPanel.Info(layer.getGraphics());
                this.layerMap.put(layer, li);
            }
            Color[] map = tech.getTransparentLayerColors();
            this.colorMapMap.put(tech, map);
        }
        for (Map.Entry<User.ColorPrefType, String> e : this.nameTypeSpecialMap.entrySet()) {
            User.ColorPrefType type = e.getKey();
            String title = e.getValue();
            this.transAndSpecialMap.put(title, new ColorPatternPanel.Info(type));
        }
        if (redraw) {
            this.layerSelected();
        }
    }

    private void setTechnology() {
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        Color[] map = this.colorMapMap.get(tech);
        this.colorAndPatternPanel.setColorMap(map);
        this.layerName.removeAllItems();
        Layer.LayerSortingType sortType = Layer.LayerSortingType.findType(this.sortCombo.getSelectedItem().toString());
        List<Layer> list = tech.getLayersSortedByRule(sortType);
        for (Layer layer : list) {
            this.layerName.addItem(layer.getName());
        }
        ArrayList<String> specialList = new ArrayList<String>();
        specialList.add(DEFAULT_ARTWORK);
        for (String name : this.transAndSpecialMap.keySet()) {
            specialList.add(name);
        }
        Collections.sort(specialList, TextUtils.STRING_NUMBER_ORDER);
        for (String name : specialList) {
            this.layerName.addItem(name);
        }
        this.layerSelected();
    }

    private void setSorting() {
        String userName;
        String sortingName = this.sortCombo.getSelectedItem().toString();
        if (!sortingName.equals(userName = User.getLayersSorting())) {
            this.sortCombo.setSelectedItem((Object)Layer.LayerSortingType.findType(userName));
        }
    }

    private boolean sortingSelected(boolean onlyChangeLayerList) {
        boolean changed;
        String sortingName = this.sortCombo.getSelectedItem().toString();
        if (onlyChangeLayerList) {
            this.setTechnology();
            return false;
        }
        boolean bl = changed = sortingName != User.getLayersSorting();
        if (changed) {
            User.setLayersSorting(sortingName);
        }
        return changed;
    }

    private void layerSelected() {
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        String name = (String)this.layerName.getSelectedItem();
        if (name == null) {
            return;
        }
        ColorPatternPanel.Info li = this.transAndSpecialMap.get(name);
        Layer layer = null;
        if (li == null) {
            layer = name.equals(DEFAULT_ARTWORK) ? this.defaultArtworkLayer : tech.findLayer(name);
            li = this.layerMap.get(layer);
        }
        if (li == null) {
            return;
        }
        this.colorAndPatternPanel.setColorPattern(li);
        Object otherLayers = null;
        if (li.transparentLayer > 0 && layer != null) {
            Iterator<Layer> it = tech.getLayers();
            while (it.hasNext()) {
                ColorPatternPanel.Info oLi;
                Layer oLayer = it.next();
                if (oLayer == layer || (oLi = this.layerMap.get(oLayer)) == null || oLi.transparentLayer != li.transparentLayer) continue;
                if (otherLayers == null) {
                    otherLayers = oLayer.getName();
                    continue;
                }
                otherLayers = (String)otherLayers + ", " + oLayer.getName();
            }
        }
        this.colorAndPatternPanel.setOtherTransparentLayerNames((String)otherLayers);
    }

    @Override
    public void term() {
        boolean changed = false;
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            Iterator<Layer> lIt = tech.getLayers();
            while (lIt.hasNext()) {
                EGraphics graphics;
                Layer layer = lIt.next();
                ColorPatternPanel.Info li = this.layerMap.get(layer);
                EGraphics newGraphics = li.updateGraphics(graphics = layer.getGraphics());
                if (newGraphics == graphics) continue;
                changed = true;
                layer.setGraphics(newGraphics);
            }
            Color[] origMap = tech.getTransparentLayerColors();
            boolean mapChanged = false;
            Color[] map = this.colorMapMap.get(tech);
            for (int i = 0; i < map.length; ++i) {
                if (map[i].getRGB() == origMap[i].getRGB()) continue;
                mapChanged = true;
            }
            if (!mapChanged) continue;
            tech.setColorMapFromLayers(map);
        }
        for (Map.Entry<User.ColorPrefType, String> e : this.nameTypeSpecialMap.entrySet()) {
            User.ColorPrefType type = e.getKey();
            String title = e.getValue();
            int c = this.specialMapColor(title, User.getColor(type));
            if (c < 0) continue;
            User.setColor(type, c);
            changed = true;
        }
        if (changed) {
            WindowFrame.repaintAllWindows();
        }
        if (changed = this.sortingSelected(false)) {
            PreferencesFrame.updateLayersSortingTabs();
        }
    }

    @Override
    public boolean resetThis() {
        for (Layer layer : this.layerMap.keySet()) {
            ColorPatternPanel.Info cpi = this.layerMap.get(layer);
            int factoryColor = -1;
            if (cpi.graphics != null) {
                EGraphics factoryGraphics = cpi.graphics;
                factoryGraphics = layer.getFactoryGraphics();
                cpi.useStippleDisplay = factoryGraphics.isPatternedOnDisplay();
                cpi.useStipplePrinter = factoryGraphics.isPatternedOnPrinter();
                cpi.outlinePatternDisplay = factoryGraphics.getOutlined();
                cpi.transparentLayer = factoryGraphics.getTransparentLayer();
                cpi.pattern = factoryGraphics.getPattern();
                cpi.opacity = factoryGraphics.getOpacity();
                factoryColor = factoryGraphics.getColor().getRGB();
            } else {
                factoryColor = cpi.theColor.getFactoryDefaultColor().getRGB();
            }
            cpi.red = factoryColor >> 16 & 0xFF;
            cpi.green = factoryColor >> 8 & 0xFF;
            cpi.blue = factoryColor & 0xFF;
        }
        for (User.ColorPrefType type : this.nameTypeSpecialMap.keySet()) {
            String name = this.nameTypeSpecialMap.get((Object)type);
            ColorPatternPanel.Info cpi = this.transAndSpecialMap.get(name);
            int factoryColor = type.getFactoryDefaultColor().getRGB() & 0xFFFFFF;
            cpi.red = factoryColor >> 16 & 0xFF;
            cpi.green = factoryColor >> 8 & 0xFF;
            cpi.blue = factoryColor & 0xFF;
        }
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            Color[] map = tech.getFactoryTransparentLayerColors();
            this.colorMapMap.put(tech, map);
        }
        this.colorAndPatternPanel.setColorPattern(null);
        this.setTechnology();
        if (!User.getFactoryLayersSorting().equals(User.getLayersSorting())) {
            User.setLayersSorting(User.getFactoryLayersSorting());
        }
        this.setSorting();
        return false;
    }

    @Override
    public void reset() {
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Color[] transColors;
            boolean reload;
            Technology tech = it.next();
            Color[] transColorsFactory = tech.getFactoryTransparentLayerColors();
            boolean bl = reload = transColorsFactory.length != (transColors = tech.getTransparentLayerColors()).length;
            if (!reload) {
                for (int i = 0; i < transColors.length; ++i) {
                    if (transColorsFactory[i].getRGB() == transColors[i].getRGB()) continue;
                    reload = true;
                }
            }
            if (reload) {
                tech.setColorMapFromLayers(transColorsFactory);
            }
            Iterator<Layer> lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Layer layer = lIt.next();
                layer.setGraphics(layer.getFactoryGraphics());
            }
        }
        LayerVisibility.factoryReset();
        for (User.ColorPrefType type : this.nameTypeSpecialMap.keySet()) {
            String name = this.nameTypeSpecialMap.get((Object)type);
            ColorPatternPanel.Info cpi = this.transAndSpecialMap.get(name);
            int factory = cpi.theColor.getFactoryDefaultColor().getRGB() & 0xFFFFFF;
            if (factory == User.getColor(cpi.theColor)) continue;
            User.setColor(type, factory);
        }
        if (!User.getFactoryLayersSorting().equals(User.getLayersSorting())) {
            User.setLayersSorting(User.getFactoryLayersSorting());
        }
    }

    public int specialMapColor(String title, int curColor) {
        ColorPatternPanel.Info li = this.transAndSpecialMap.get(title);
        if (li == null) {
            return -1;
        }
        int newColor = li.red << 16 | li.green << 8 | li.blue;
        if (newColor != curColor) {
            return newColor;
        }
        return -1;
    }

    private void initComponents() {
        this.layers = new JPanel();
        this.layerName = new JComboBox();
        this.layerTechName = new JLabel();
        this.technology = new JComboBox();
        this.layerTechName1 = new JLabel();
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LayersTab.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.layers.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layers.add((Component)this.layerName, gridBagConstraints);
        this.layerTechName.setText("Layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layers.add((Component)this.layerTechName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layers.add((Component)this.technology, gridBagConstraints);
        this.layerTechName1.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layers.add((Component)this.layerTechName1, gridBagConstraints);
        this.getContentPane().add((Component)this.layers, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

