/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.metrics;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.routing.metrics.RoutingMetric;
import java.awt.geom.RectangularShape;
import java.util.Iterator;

public class HalfPerimeterWireLengthMetric
extends RoutingMetric<Double> {
    @Override
    public Double calculate(Cell cell) {
        return null;
    }

    @Override
    public Double calculate(Network net) {
        double localMinY;
        double localMinX;
        double localMaxY;
        double localMaxX;
        ERectangle rect;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        Iterator<ArcInst> arcs = net.getArcs();
        while (arcs.hasNext()) {
            ArcInst ai = arcs.next();
            rect = ai.getBounds();
            localMaxX = ((RectangularShape)rect).getMaxX();
            localMaxY = ((RectangularShape)rect).getMaxY();
            localMinX = ((RectangularShape)rect).getMinX();
            localMinY = ((RectangularShape)rect).getMinY();
            if (localMaxX > maxX) {
                maxX = localMaxX;
            }
            if (localMaxY > maxY) {
                maxY = localMaxY;
            }
            if (localMinX < minX) {
                minX = localMinX;
            }
            if (!(localMinY < minY)) continue;
            minY = localMinY;
        }
        Iterator<NodeInst> nodes = net.getNodes();
        while (nodes.hasNext()) {
            NodeInst node = nodes.next();
            rect = node.getBounds();
            localMaxX = ((RectangularShape)rect).getMaxX();
            localMaxY = ((RectangularShape)rect).getMaxY();
            localMinX = ((RectangularShape)rect).getMinX();
            localMinY = ((RectangularShape)rect).getMinY();
            if (localMaxX > maxX) {
                maxX = localMaxX;
            }
            if (localMaxY > maxY) {
                maxY = localMaxY;
            }
            if (localMinX < minX) {
                minX = localMinX;
            }
            if (!(localMinY < minY)) continue;
            minY = localMinY;
        }
        double result = maxX - minX + (maxY - minY);
        return result;
    }
}

