/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.MutableInteger;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EDIFEquiv {
    private HashMap<Object, NodeEquivalence> equivsByNodeProto = new HashMap();
    private HashMap<Object, NodeEquivalence> equivsByExternal = new HashMap();
    private HashMap<String, VariableEquivalence> exportByVariable = new HashMap();
    private HashMap<String, VariableEquivalence> exportFromVariable = new HashMap();
    private HashMap<String, FigureGroupEquivalence> exportByFigureGroup = new HashMap();
    private HashMap<String, FigureGroupEquivalence> exportFromFigureGroup = new HashMap();
    private HashMap<String, GlobalEquivalence> exportByGlobal = new HashMap();
    private HashMap<String, GlobalEquivalence> exportFromGlobal = new HashMap();
    private static final Pattern portsPat = Pattern.compile("(.+?)\\{(.+?)\\}(.+?)\\{(.+?)\\}");

    public NodeEquivalence getNodeEquivalence(NodeInst ni) {
        NodeProto np = ni.getProto();
        PrimitiveNode.Function func = np.getFunction();
        PortCharacteristic exportType = null;
        if (!ni.isCellInstance()) {
            func = ni.getFunction();
            if (np == Schematics.tech().offpageNode) {
                Iterator<PortProto> it = ni.getParent().getPorts();
                while (it.hasNext()) {
                    Export e = (Export)it.next();
                    if (e.getOriginalPort().getNodeInst() != ni) continue;
                    exportType = e.getCharacteristic();
                    break;
                }
            }
        }
        return this.equivsByNodeProto.get(this.getElectricKey(np, func, exportType));
    }

    public VariableEquivalence getElectricVariableEquivalence(String varName) {
        VariableEquivalence ve = this.exportByVariable.get(varName);
        return ve;
    }

    public VariableEquivalence getExternalVariableEquivalence(String varName) {
        VariableEquivalence ve = this.exportFromVariable.get(varName);
        return ve;
    }

    public FigureGroupEquivalence getElectricFigureGroupEquivalence(String fgName) {
        FigureGroupEquivalence fge = this.exportByFigureGroup.get(fgName);
        return fge;
    }

    public FigureGroupEquivalence getExternalFigureGroupEquivalence(String fgName) {
        FigureGroupEquivalence fge = this.exportFromFigureGroup.get(fgName);
        return fge;
    }

    public GlobalEquivalence getElectricGlobalEquivalence(String gName) {
        GlobalEquivalence ge = this.exportByGlobal.get(gName);
        return ge;
    }

    public GlobalEquivalence getExternalGlobalEquivalence(String gName) {
        GlobalEquivalence ge = this.exportFromGlobal.get(gName);
        return ge;
    }

    public NodeEquivalence getNodeEquivalence(String extLib, String extCell, String extView) {
        Object key = this.getExternalKey(extLib, extCell, extView);
        return this.equivsByExternal.get(key);
    }

    public List<NodeEquivalence> getNodeEquivs() {
        return new ArrayList<NodeEquivalence>(this.equivsByExternal.values());
    }

    public Point2D translatePortConnection(Point2D connPoint, PortInst pi) {
        NodeInst ni = pi.getNodeInst();
        NodeEquivalence equiv = this.getNodeEquivalence(ni);
        if (equiv == null) {
            return connPoint;
        }
        PortEquivalence pe = equiv.getPortEquivElec(pi.getPortProto().getName());
        if (pe == null) {
            return connPoint;
        }
        FixpTransform af2 = ni.getOrient().concatenate(Orientation.fromAngle(-equiv.rotation * 10)).pureRotate();
        return pe.translateElecToExt(connPoint, af2);
    }

    public Point2D translatePortConnection(Point2D connPoint, String externalLib, String externalCell, String externalView, String externalPort, String orientation) {
        NodeEquivalence equiv = this.getNodeEquivalence(externalLib, externalCell, externalView);
        if (equiv == null) {
            return connPoint;
        }
        PortEquivalence pe = equiv.getPortEquivExt(externalPort);
        if (pe == null) {
            return connPoint;
        }
        int angle = 0;
        boolean mirroredAboutXAxis = false;
        boolean mirroredAboutYAxis = false;
        if (orientation.indexOf("R90") != -1) {
            angle = 900;
        }
        if (orientation.indexOf("R180") != -1) {
            angle = 1800;
        }
        if (orientation.indexOf("R270") != -1) {
            angle = 2700;
        }
        if (orientation.indexOf("MX") != -1) {
            mirroredAboutXAxis = true;
        }
        if (orientation.indexOf("MY") != -1) {
            mirroredAboutYAxis = true;
        }
        Orientation orient = Orientation.fromJava(angle, mirroredAboutYAxis, mirroredAboutXAxis);
        orient = orient.concatenate(Orientation.fromAngle(equiv.rotation * 10));
        FixpTransform af2 = orient.pureRotate();
        Point2D ret = pe.translateExtToElec(connPoint, af2);
        if (equiv.xOffset != 0.0 || equiv.yOffset != 0.0) {
            ret = new Point2D.Double(ret.getX() + equiv.xOffset, ret.getY() + equiv.yOffset);
        }
        return ret;
    }

    private Object getElectricKey(NodeProto np, PrimitiveNode.Function func, PortCharacteristic portType) {
        if (func == null) {
            func = PrimitiveNode.Function.UNKNOWN;
        }
        if (portType == null) {
            portType = PortCharacteristic.UNKNOWN;
        }
        return np.getName() + " " + func.toString() + " " + portType.getName();
    }

    private Object getExternalKey(String externalLib, String externalCell, String externalView) {
        return externalLib + " " + externalCell + " " + externalView;
    }

    private void addNodeEquiv(NodeProto np, PrimitiveNode.Function func, PortCharacteristic exportType, int rot, String extLib, String extCell, String extView, List<Port> elecPorts, List<Port> extPorts) {
        ArrayList<PortEquivalence> portEquivs = new ArrayList<PortEquivalence>();
        if (elecPorts.size() != extPorts.size()) {
            System.out.println("Error, port lists differ in size!");
            return;
        }
        for (int i = 0; i < elecPorts.size(); ++i) {
            PortEquivalence pe = new PortEquivalence(elecPorts.get(i), extPorts.get(i));
            portEquivs.add(pe);
        }
        NodeEquivalence equiv = new NodeEquivalence(np, func, exportType, extLib, extCell, extView, rot, portEquivs);
        this.equivsByExternal.put(this.getExternalKey(extLib, extCell, extView), equiv);
        this.equivsByNodeProto.put(this.getElectricKey(np, func, exportType), equiv);
    }

    public EDIFEquiv(String configurationFile) {
        String file = configurationFile;
        if (file.length() == 0) {
            System.out.println("No EDIF configuration information being used");
            return;
        }
        File fd = new File(file);
        if (!fd.exists()) {
            System.out.println("Error: EDIF configuration file not found: " + fd.getAbsolutePath());
            return;
        }
        System.out.println("Using EDIF configuration file: " + fd.getAbsolutePath());
        try {
            FileReader reader = new FileReader(fd);
            BufferedReader bufReader = new BufferedReader(reader);
            String line = "";
            int lineno = 1;
            while ((line = bufReader.readLine()) != null) {
                this.readLine(line, lineno);
                ++lineno;
            }
            bufReader.close();
        }
        catch (IOException e) {
            System.out.println("Error reading EDIF config file (" + fd.getAbsolutePath() + "): " + e.getMessage());
            return;
        }
    }

    private boolean readLine(String line, int lineno) {
        boolean keyC;
        if ((line = line.trim()).equals("")) {
            return true;
        }
        if (line.startsWith("#")) {
            return true;
        }
        if (line.startsWith("V")) {
            String[] parts = line.split("\\s+");
            String append = "";
            double scale = TextUtils.atof(parts[3]);
            if (parts.length == 5) {
                append = parts[4];
            }
            VariableEquivalence ve = new VariableEquivalence(parts[1], parts[2], scale, append);
            this.exportByVariable.put(parts[1], ve);
            this.exportFromVariable.put(parts[2], ve);
            return true;
        }
        if (line.startsWith("F")) {
            String[] parts = line.split("\\s+");
            FigureGroupEquivalence fge = new FigureGroupEquivalence(parts[1], parts[2]);
            this.exportByFigureGroup.put(parts[1], fge);
            this.exportFromFigureGroup.put(parts[2], fge);
            return true;
        }
        if (line.startsWith("G")) {
            String[] parts = line.split("\\s+");
            GlobalEquivalence ge = new GlobalEquivalence(parts[1], parts[2]);
            this.exportByGlobal.put(parts[1], ge);
            this.exportFromGlobal.put(parts[2], ge);
            return true;
        }
        Matcher mat = portsPat.matcher(line);
        if (!mat.find()) {
            System.out.println("Wrong number of curly brackets for ports on line " + lineno);
            return false;
        }
        String elec = mat.group(1).trim();
        String elec_ports = mat.group(2).trim();
        String ext = mat.group(3).trim();
        String ext_ports = mat.group(4).trim();
        Comparable<PrimitiveNode> np = null;
        PrimitiveNode.Function func = null;
        PortCharacteristic portType = null;
        int rot = 0;
        String[] parts = elec.split("\\s+");
        if (parts.length < 1) {
            System.out.println("No Electric arguments on line " + lineno);
            return false;
        }
        boolean keyE = parts[0].equalsIgnoreCase("E");
        boolean keyP = parts[0].equalsIgnoreCase("P");
        boolean bl = keyC = parts[0].equalsIgnoreCase("C");
        if (keyP && parts.length != 5) {
            System.out.println("Wrong number of arguments for Electric Primitive, expected 'P tech node func rot' on line " + lineno);
            return false;
        }
        if (keyE && parts.length != 6) {
            System.out.println("Wrong number of arguments for Electric Primitive, expected 'E tech node func rot porttype' on line " + lineno);
            return false;
        }
        if (keyC && parts.length != 5) {
            System.out.println("Wrong number of arguments for Electric cell, expected 'C lib cell view rot' on line " + lineno);
            return false;
        }
        if (keyP || keyE) {
            np = null;
            Technology tech = Technology.findTechnology(parts[1]);
            if (tech == null) {
                System.out.println("Could not find Technology " + parts[1] + " on line " + lineno);
                return false;
            }
            np = tech.findNodeProto(parts[2]);
            if (np == null) {
                System.out.println("Could not find " + parts[2] + " in technology " + parts[1] + " on line " + lineno);
                return false;
            }
            for (PrimitiveNode.Function function : PrimitiveNode.Function.getFunctions()) {
                if (!parts[3].equals(function.getName()) && !parts[3].equals(function.getShortName()) && !parts[3].equals(function.getConstantName())) continue;
                func = function;
                break;
            }
            if (func == null) {
                System.out.println("Could not find Function " + parts[3] + " on line " + lineno);
                return false;
            }
            try {
                rot = Integer.parseInt(parts[4]);
            }
            catch (NumberFormatException e) {
                System.out.println("Rotation " + parts[4] + " is not an integer on line " + lineno);
            }
            if (keyE && (portType = PortCharacteristic.findCharacteristic(parts[5])) == null) {
                System.out.println("Unable to find Export type " + parts[5] + " on line " + lineno);
                return false;
            }
        } else if (keyC) {
            Library lib = Library.findLibrary(parts[1]);
            if (lib == null) {
                System.out.println("Could not find Library " + parts[1] + " on line " + lineno);
                return false;
            }
            np = lib.findNodeProto(parts[2] + "{" + parts[3] + "}");
            if (np == null) {
                System.out.println("Could not find Cell " + parts[2] + ", view " + parts[3] + " in library " + parts[1] + " on line " + lineno);
                return false;
            }
            func = PrimitiveNode.Function.UNKNOWN;
            try {
                rot = Integer.parseInt(parts[4]);
            }
            catch (NumberFormatException e) {
                System.out.println("Rotation " + parts[4] + " is not an integer on line " + lineno);
            }
        } else {
            System.out.println("Unrecognized key " + parts[0] + ", expected 'P', 'C', or 'E' on line " + lineno);
            return false;
        }
        if ((parts = ext.split("\\s+")).length != 3) {
            System.out.println("Wrong number of arguments for external lib, expected 'lib name view' on line " + lineno);
            return false;
        }
        String extlib = parts[0];
        String extname = parts[1];
        String extview = parts[2];
        List<Port> elecPorts = this.parsePortsList(elec_ports, lineno);
        List<Port> extPorts = this.parsePortsList(ext_ports, lineno);
        if (elecPorts.size() != extPorts.size()) {
            System.out.println("Port lists are not the same size on line " + lineno);
            return false;
        }
        this.addNodeEquiv((NodeProto)((Object)np), func, portType, rot, extlib, extname, extview, elecPorts, extPorts);
        return true;
    }

    private List<Port> parsePortsList(String portsList, int lineno) {
        String portDef;
        Port port;
        boolean opened = false;
        ArrayList<Port> ports = new ArrayList<Port>();
        int i = 0;
        int last = 0;
        for (i = 0; i < portsList.length(); ++i) {
            char c = portsList.charAt(i);
            if (c == '(') {
                if (opened) {
                    System.out.println("Unmatched open parenthesis in ports list on line " + lineno);
                    return ports;
                }
                opened = true;
                continue;
            }
            if (c == ')') {
                if (!opened) {
                    System.out.println("Unmatched close parenthesis in ports list on line " + lineno);
                    return ports;
                }
                opened = false;
                continue;
            }
            if (c != ',' || opened) continue;
            String portDef2 = portsList.substring(last, i);
            last = i + 1;
            Port port2 = this.parsePort(portDef2, lineno);
            if (port2 == null) continue;
            ports.add(port2);
        }
        if (last < i && (port = this.parsePort(portDef = portsList.substring(last, i), lineno)) != null) {
            ports.add(port);
        }
        return ports;
    }

    private Port parsePort(String port, int lineno) {
        boolean ignorePort = false;
        if (port.trim().equals("NA")) {
            return new Port("NA", new Point2D.Double(0.0, 0.0), true);
        }
        String[] fields = port.split("[(),]");
        if (fields.length != 3) {
            System.out.println("Expected port format portname(x,y), but got " + port + " on line " + lineno);
            return null;
        }
        double x = 0.0;
        double y = 0.0;
        try {
            x = Double.parseDouble(fields[1]);
            y = Double.parseDouble(fields[2]);
        }
        catch (NumberFormatException e) {
            System.out.println("Could not convert port coordinate to number: " + port + ", on line " + lineno);
            return null;
        }
        String name = fields[0].trim();
        if (name.equals("NA")) {
            ignorePort = true;
        }
        if (name.equals("\\NA")) {
            name = "NA";
        }
        return new Port(fields[0].trim(), new Point2D.Double(x, y), ignorePort);
    }

    public void print() {
        for (NodeEquivalence ne : this.equivsByNodeProto.values()) {
            System.out.println(ne.toString());
        }
    }

    public static void mainTest() {
        EDIFEquiv eq = new EDIFEquiv(IOTool.getEDIFConfigurationFile());
        eq.print();
    }

    public static class NodeEquivalence {
        public final NodeProto np;
        public final PrimitiveNode.Function function;
        public final PortCharacteristic exortedType;
        public final String externalLib;
        public final String externalCell;
        public final String externalView;
        public final List<PortEquivalence> portEquivs;
        public final int rotation;
        public final double xOffset;
        public final double yOffset;

        private NodeEquivalence(NodeProto np, PrimitiveNode.Function func, PortCharacteristic exportedType, String externalLib, String externalCell, String externalView, int rotation, List<PortEquivalence> portEquivs) {
            this.np = np;
            this.function = func;
            this.exortedType = exportedType;
            this.externalLib = externalLib;
            this.externalCell = externalCell;
            this.externalView = externalView;
            this.rotation = rotation;
            this.portEquivs = portEquivs;
            double bestXOff = 0.0;
            double bestYOff = 0.0;
            if (rotation == 0) {
                MutableInteger xCount;
                HashMap<Double, MutableInteger> xMap = new HashMap<Double, MutableInteger>();
                HashMap<Double, MutableInteger> yMap = new HashMap<Double, MutableInteger>();
                for (PortEquivalence portEquivalence : portEquivs) {
                    Double diffX = portEquivalence.getElecPort().loc.getX() - portEquivalence.getExtPort().loc.getX();
                    xCount = (MutableInteger)xMap.get(diffX);
                    if (xCount == null) {
                        xCount = new MutableInteger(0);
                        xMap.put(diffX, xCount);
                    }
                    xCount.increment();
                    Double diffY = portEquivalence.getElecPort().loc.getY() - portEquivalence.getExtPort().loc.getY();
                    MutableInteger yCount = (MutableInteger)yMap.get(diffY);
                    if (yCount == null) {
                        yCount = new MutableInteger(0);
                        yMap.put(diffY, yCount);
                    }
                    yCount.increment();
                }
                int bestXInc = 0;
                for (Double diffX : xMap.keySet()) {
                    xCount = (MutableInteger)xMap.get(diffX);
                    if (xCount.intValue() <= bestXInc) continue;
                    bestXInc = xCount.intValue();
                    bestXOff = diffX;
                }
                boolean bl = false;
                for (Double diffY : yMap.keySet()) {
                    int n;
                    MutableInteger yCount = (MutableInteger)yMap.get(diffY);
                    if (yCount.intValue() <= n) continue;
                    n = yCount.intValue();
                    bestYOff = diffY;
                }
            }
            this.xOffset = bestXOff;
            this.yOffset = bestYOff;
        }

        public PortEquivalence getPortEquivElec(String elecPortName) {
            for (PortEquivalence pe : this.portEquivs) {
                if (!pe.getElecPort().name.equals(elecPortName)) continue;
                return pe;
            }
            return null;
        }

        public PortEquivalence getPortEquivExt(String extPortName) {
            for (PortEquivalence pe : this.portEquivs) {
                if (!pe.getExtPort().name.equals(extPortName)) continue;
                return pe;
            }
            return null;
        }

        public List<Port> getExtPorts() {
            ArrayList<Port> extPorts = new ArrayList<Port>();
            for (PortEquivalence pe : this.portEquivs) {
                extPorts.add(pe.getExtPort());
            }
            return extPorts;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("NodeEquivalence Elec: " + this.np.describe(false) + ", func: " + this.function + "\n");
            buf.append("  Ext: " + this.externalLib + " " + this.externalCell + " " + this.externalView + "\n");
            for (PortEquivalence pe : this.portEquivs) {
                buf.append(pe.toString() + "\n");
            }
            return buf.toString();
        }
    }

    public static class VariableEquivalence {
        public final String elecVarName;
        public final String externVarName;
        public final double scale;
        public final String appendElecOutput;

        private VariableEquivalence(String elecVarName, String externVarName, double scale, String appendElecOutput) {
            this.elecVarName = elecVarName;
            this.externVarName = externVarName;
            this.scale = scale;
            this.appendElecOutput = appendElecOutput;
        }
    }

    public static class FigureGroupEquivalence {
        public final String elecFGName;
        public final String externFGName;

        private FigureGroupEquivalence(String elecFGName, String externFGName) {
            this.elecFGName = elecFGName;
            this.externFGName = externFGName;
        }
    }

    public static class GlobalEquivalence {
        public final String elecGName;
        public final String externGName;

        private GlobalEquivalence(String elecGName, String externGName) {
            this.elecGName = elecGName;
            this.externGName = externGName;
        }
    }

    public static class PortEquivalence {
        private final Port elecPort;
        private final Port extPort;

        private PortEquivalence(Port elecPort, Port extPort) {
            this.elecPort = elecPort;
            this.extPort = extPort;
        }

        public Port getElecPort() {
            return this.elecPort;
        }

        public Port getExtPort() {
            return this.extPort;
        }

        public Point2D translateElecToExt(Point2D point, FixpTransform niPureRotation) {
            Point2D elecPoint = new Point2D.Double(this.elecPort.loc.getX(), this.elecPort.loc.getY());
            Point2D extPoint = new Point2D.Double(this.extPort.loc.getX(), this.extPort.loc.getY());
            if (niPureRotation != null) {
                elecPoint = niPureRotation.transform(this.elecPort.loc, elecPoint);
                extPoint = niPureRotation.transform(this.extPort.loc, extPoint);
            }
            return new Point2D.Double(point.getX() - (elecPoint.getX() - extPoint.getX()), point.getY() - (elecPoint.getY() - extPoint.getY()));
        }

        public Point2D translateExtToElec(Point2D point, FixpTransform niPureRotation) {
            Point2D elecPoint = new Point2D.Double(this.elecPort.loc.getX(), this.elecPort.loc.getY());
            Point2D extPoint = new Point2D.Double(this.extPort.loc.getX(), this.extPort.loc.getY());
            if (niPureRotation != null) {
                elecPoint = niPureRotation.transform(this.elecPort.loc, elecPoint);
                extPoint = niPureRotation.transform(this.extPort.loc, extPoint);
            }
            return new Point2D.Double(point.getX() - (elecPoint.getX() - extPoint.getX()), point.getY() - (elecPoint.getY() - extPoint.getY()));
        }

        public String toString() {
            return "PortEquiv Elec{ " + this.elecPort + " } - Ext{ " + this.extPort + " }";
        }
    }

    public static class Port {
        public final String name;
        public final Point2D loc;
        public final boolean ignorePort;

        private Port(String name, Point2D loc, boolean ignorePort) {
            this.name = name;
            this.loc = loc;
            this.ignorePort = ignorePort;
        }

        public String toString() {
            return this.name + "(" + this.loc.getX() + "," + this.loc.getY() + ")" + (this.ignorePort ? "[ignored]" : "");
        }
    }
}

