/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input.verilog;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.simulation.BusSample;
import com.sun.electric.tool.simulation.DigitalSample;
import com.sun.electric.tool.simulation.MutableSignal;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.util.TextUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VerilogOut
extends Input<Stimuli> {
    private String lastLine = null;
    private int linePos;
    private int lineLen;

    public VerilogOut() {
        super(null);
    }

    @Override
    protected Stimuli processInput(URL fileURL, Cell cell, Stimuli sd) throws IOException {
        sd.setNetDelimiter(" ");
        if (this.openTextInput(fileURL)) {
            return sd;
        }
        VerilogOut.startProgressDialog("Verilog output", fileURL.getFile());
        this.readVerilogFile(cell, sd);
        VerilogOut.stopProgressDialog();
        this.closeInput();
        return sd;
    }

    private void readVerilogFile(Cell cell, Stimuli sd) throws IOException {
        String keyword;
        SignalCollection sc = Stimuli.newSignalCollection(sd, "SIGNALS");
        HashMap<String, Signal[]> busMembers = new HashMap<String, Signal[]>();
        double timeScale = 1.0;
        Object currentScope = "";
        int curLevel = 0;
        int numSignals = 0;
        HashMap<String, Object> symbolTable = new HashMap<String, Object>();
        ArrayList<MutableSignal<DigitalSample>> curArray = null;
        while ((keyword = this.getNextKeyword()) != null) {
            String currentLine;
            int i;
            Signal sig;
            if (keyword.equals("$date") || keyword.equals("$version")) {
                this.parseToEnd();
                continue;
            }
            if (keyword.equals("$timescale")) {
                String units = this.getNextKeyword();
                timeScale = TextUtils.atof(units);
                if (units.endsWith("ms")) {
                    timeScale /= 1000.0;
                } else if (units.endsWith("us")) {
                    timeScale /= 1000000.0;
                } else if (units.endsWith("ns")) {
                    timeScale /= 1.0E9;
                } else if (units.endsWith("ps")) {
                    timeScale /= 1.0E12;
                } else if (units.endsWith("fs")) {
                    timeScale /= 1.0E15;
                }
                this.parseToEnd();
                continue;
            }
            if (keyword.equals("$scope")) {
                String scope = this.getNextKeyword();
                if (scope == null) break;
                if (scope.equals("module") || scope.equals("task") || scope.equals("function")) {
                    sd.makeBusSignals(curArray, sc);
                    curArray = new ArrayList<MutableSignal<DigitalSample>>();
                    String scopeName = this.getNextKeyword();
                    if (scopeName == null) break;
                    if (((String)currentScope).length() > 0) {
                        currentScope = (String)currentScope + ".";
                    }
                    currentScope = (String)currentScope + scopeName;
                    ++curLevel;
                }
                this.parseToEnd();
                continue;
            }
            if (keyword.equals("$upscope")) {
                if (curLevel <= 0 || ((String)currentScope).length() == 0) {
                    System.out.println("Unbalanced $upscope on line " + this.lineReader.getLineNumber());
                    continue;
                }
                sd.makeBusSignals(curArray, sc);
                curArray = new ArrayList();
                int dotPos = ((String)currentScope).lastIndexOf(46);
                if (dotPos >= 0) {
                    currentScope = ((String)currentScope).substring(0, dotPos);
                    --curLevel;
                }
                this.parseToEnd();
                continue;
            }
            if (keyword.equals("$var")) {
                String index;
                String signalName;
                String varName = this.getNextKeyword();
                if (varName == null) break;
                if (!varName.equals("wire") && !varName.equals("reg") && !varName.equals("supply0") && !varName.equals("supply1") && !varName.equals("parameter") && !varName.equals("trireg") && !varName.equals("in") && !varName.equals("out") && !varName.equals("inout")) continue;
                String widthText = this.getNextKeyword();
                if (widthText == null) break;
                int width = TextUtils.atoi(widthText);
                String symbol = this.getNextKeyword();
                if (symbol == null || (signalName = this.getNextKeyword()) == null || (index = this.getNextKeyword()) == null) break;
                if (index.equals("$end")) {
                    index = "";
                } else {
                    this.parseToEnd();
                }
                ++numSignals;
                sig = null;
                if (width <= 1) {
                    sig = DigitalSample.createSignal(sc, sd, signalName + index, (String)currentScope);
                    if (index.length() > 0) {
                        curArray.add((MutableSignal<DigitalSample>)sig);
                    }
                    this.addSignalToHashMap(sig, symbol, symbolTable);
                } else {
                    Signal[] subsigs = new Signal[width];
                    for (i = 0; i < width; ++i) {
                        subsigs[i] = DigitalSample.createSignal(sc, sd, signalName + "[" + i + "]", (String)currentScope);
                    }
                    sig = BusSample.createSignal(sc, sd, signalName + "[0:" + (width - 1) + "]", (String)currentScope, true, subsigs);
                    busMembers.put(symbol, subsigs);
                }
                ++numSignals;
                continue;
            }
            if (keyword.equals("$enddefinitions")) {
                this.parseToEnd();
                System.out.println("Found " + numSignals + " signal names");
                continue;
            }
            if (!keyword.equals("$dumpvars")) continue;
            double curTime = 0.0;
            while ((currentLine = this.getLineAndUpdateProgress()) != null) {
                char chr = currentLine.charAt(0);
                String restOfLine = currentLine.substring(1);
                if (chr == '0' || chr == '1' || chr == 'x' || chr == 'X' || chr == 'z' || chr == 'Z') {
                    Object entry = symbolTable.get(restOfLine);
                    if (entry == null) {
                        System.out.println("Unknown symbol '" + restOfLine + "' on line " + this.lineReader.getLineNumber());
                        continue;
                    }
                    if (entry instanceof List) {
                        entry = ((List)entry).get(0);
                    }
                    sig = (MutableSignal<DigitalSample>)entry;
                    DigitalSample ds = null;
                    switch (chr) {
                        case '0': {
                            ds = DigitalSample.getSample(DigitalSample.Value.LOW, DigitalSample.Strength.LARGE_CAPACITANCE);
                            break;
                        }
                        case '1': {
                            ds = DigitalSample.getSample(DigitalSample.Value.HIGH, DigitalSample.Strength.LARGE_CAPACITANCE);
                            break;
                        }
                        case 'X': 
                        case 'x': {
                            ds = DigitalSample.getSample(DigitalSample.Value.X, DigitalSample.Strength.LARGE_CAPACITANCE);
                            break;
                        }
                        case 'Z': 
                        case 'z': {
                            ds = DigitalSample.getSample(DigitalSample.Value.Z, DigitalSample.Strength.HIGH_IMPEDANCE);
                        }
                    }
                    ((MutableSignal)sig).addSample(curTime, ds);
                    continue;
                }
                if (chr == '$') {
                    if (restOfLine.equals("end") || restOfLine.equals("dumpon") || restOfLine.equals("dumpoff") || restOfLine.equals("dumpall")) continue;
                    System.out.println("Unknown directive on line " + this.lineReader.getLineNumber() + ": " + currentLine);
                    continue;
                }
                if (chr == '#') {
                    curTime = TextUtils.atof(restOfLine) * timeScale;
                    continue;
                }
                if (chr == 'b') {
                    int spacePos = restOfLine.indexOf(32);
                    if (spacePos < 0) {
                        System.out.println("Bus has missing signal name on line " + this.lineReader.getLineNumber() + ": " + currentLine);
                        continue;
                    }
                    String symName = restOfLine.substring(spacePos + 1);
                    Signal[] members = (Signal[])busMembers.get(symName);
                    for (i = 0; i < members.length; ++i) {
                        Signal subSig = members[i];
                        char bit = restOfLine.charAt(i++);
                        DigitalSample ds = null;
                        switch (bit) {
                            case '0': {
                                ds = DigitalSample.getSample(DigitalSample.Value.LOW, DigitalSample.Strength.LARGE_CAPACITANCE);
                                break;
                            }
                            case '1': {
                                ds = DigitalSample.getSample(DigitalSample.Value.HIGH, DigitalSample.Strength.LARGE_CAPACITANCE);
                                break;
                            }
                            case 'X': 
                            case 'x': {
                                ds = DigitalSample.getSample(DigitalSample.Value.X, DigitalSample.Strength.LARGE_CAPACITANCE);
                                break;
                            }
                            case 'Z': 
                            case 'z': {
                                ds = DigitalSample.getSample(DigitalSample.Value.Z, DigitalSample.Strength.HIGH_IMPEDANCE);
                            }
                        }
                        ((MutableSignal)subSig).addSample(curTime, ds);
                    }
                    continue;
                }
                System.out.println("Unknown stimulus on line " + this.lineReader.getLineNumber() + ": " + currentLine);
            }
        }
    }

    private void addSignalToHashMap(Signal<?> sig, String symbol, Map<String, Object> symbolTable) {
        Object entry = symbolTable.get(symbol);
        if (entry == null) {
            symbolTable.put(symbol, sig);
        } else if (entry instanceof Signal) {
            ArrayList manySigs = new ArrayList();
            manySigs.add((Signal)entry);
            manySigs.add(sig);
            symbolTable.put(symbol, manySigs);
        } else if (entry instanceof List) {
            ((List)entry).add(sig);
        }
    }

    private void parseToEnd() throws IOException {
        String keyword;
        while ((keyword = this.getNextKeyword()) != null && !keyword.equals("$end")) {
        }
    }

    private String getNextKeyword() throws IOException {
        String keyword = null;
        do {
            if (this.lastLine == null) {
                this.lastLine = this.getLineAndUpdateProgress();
                if (this.lastLine == null) break;
                this.lineLen = this.lastLine.length();
                this.linePos = 0;
            }
            if (this.linePos < this.lineLen) {
                char ch = this.lastLine.charAt(this.linePos);
                if (ch == ' ' || ch == '\t') {
                    ++this.linePos;
                } else {
                    int startOfKeyword = this.linePos++;
                    while (this.linePos < this.lineLen && this.lastLine.charAt(this.linePos) != ' ') {
                        ++this.linePos;
                    }
                    keyword = this.lastLine.substring(startOfKeyword, this.linePos);
                }
            }
            if (this.linePos < this.lineLen) continue;
            this.lastLine = null;
        } while (keyword == null);
        return keyword;
    }
}

