/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.tool.user.tests.AbstractTest;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class CommonSignalAnalysisTest
extends AbstractTest {
    private String name;
    private String vlFile;
    private String libFile;
    private static boolean csaTestChecked = false;
    private static Class<?> csaTestClass = null;
    private static Method csaTestInputMethod;

    public CommonSignalAnalysisTest(String name) {
        super(name);
    }

    public CommonSignalAnalysisTest(String name, String vlFile, String libFile) {
        super(name);
        this.name = name;
        this.vlFile = vlFile;
        this.libFile = libFile;
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new CommonSignalAnalysisTest("det_msff_12x_testvalue", "test.vL", "u1.lib"));
        list.add(new CommonSignalAnalysisTest("gate_basic_fourflops", "fourflops.vS", "u1.lib"));
        list.add(new CommonSignalAnalysisTest("gate_basic_load", "test.vL", "sc2_l.lib"));
        list.add(new CommonSignalAnalysisTest("gate_inv_2x_25ff_hiR", "test.vL", "u1.lib"));
        list.add(new CommonSignalAnalysisTest("gate_inv_16x_25ff_hiR", "test.vL", "u1.lib"));
        list.add(new CommonSignalAnalysisTest("net_ckt_6ps_25ff_loR", "test.vL", "sc2_l.lib"));
        list.add(new CommonSignalAnalysisTest("net_dir_const_transfunction", "test.vL", "sc2_l.lib"));
        list.add(new CommonSignalAnalysisTest("net_dir_non_const_transfunction", "test.vL", "sc2_l.lib"));
        return list;
    }

    public static String getOutputDirectory() {
        return null;
    }

    public Boolean det_msff_12x_testvalue() {
        return this.doIt();
    }

    public Boolean gate_basic_fourflops() {
        return this.doIt();
    }

    public Boolean gate_basic_load() {
        return this.doIt();
    }

    public Boolean gate_instNetList() {
        return this.doIt();
    }

    public Boolean gate_inv_2x_25ff_hiR() {
        return this.doIt();
    }

    public Boolean gate_inv_2x_25ff_loR() {
        return this.doIt();
    }

    public Boolean gate_inv_16x_25ff_hiR() {
        return this.doIt();
    }

    public Boolean gate_inv_16x_25ff_loR() {
        return this.doIt();
    }

    public Boolean gate_inv_16x_100ff_hiR() {
        return this.doIt();
    }

    public Boolean gate_inv_16x_100ff_loR() {
        return this.doIt();
    }

    public Boolean gate_inv_16x_100ff_superhiR() {
        return this.doIt();
    }

    public Boolean net_ckt_6ps_25ff_loR() {
        return this.doIt();
    }

    public Boolean net_dir_const_transfunction() {
        return this.doIt();
    }

    public Boolean net_dir_non_const_transfunction() {
        return this.doIt();
    }

    public Boolean stat_fsdseql_16_testvalue() {
        return this.doIt();
    }

    public Boolean doIt() {
        if (!CommonSignalAnalysisTest.hasCSA()) {
            return false;
        }
        String testParameter = this.createMessageOutput();
        String path = CommonSignalAnalysisTest.workingDir(this.getRegressionPath(), testParameter) + this.getFunctionName();
        String fileNameVerilog = path + "/" + this.vlFile;
        String fileNameLib = path + "/" + this.libFile;
        Boolean good = Boolean.FALSE;
        try {
            Object obj = csaTestInputMethod.invoke(csaTestClass, fileNameLib, fileNameVerilog, this.name);
            if (obj instanceof Boolean) {
                good = (Boolean)obj;
            }
        }
        catch (Exception e) {
            System.out.println("Unable to run the CSA test module (" + this.name + ")");
            e.printStackTrace(System.out);
            good = Boolean.FALSE;
        }
        return good;
    }

    public static boolean hasCSA() {
        if (!csaTestChecked) {
            csaTestChecked = true;
            try {
                csaTestClass = Class.forName("com.sun.electric.plugins.csa.api.CsaDashInterface");
            }
            catch (ClassNotFoundException e) {
                csaTestClass = null;
                return false;
            }
            try {
                csaTestInputMethod = csaTestClass.getMethod("csa_regression", String.class, String.class, String.class);
            }
            catch (NoSuchMethodException e) {
                csaTestClass = null;
                return false;
            }
        }
        return csaTestClass != null;
    }
}

