/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.Orientation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class DEF
extends Output {
    private DEFPreferences localPrefs;

    private DEF(DEFPreferences hp) {
        this.localPrefs = hp;
    }

    public static class DEFPreferences
    extends Output.OutputPreferences {
        private DEF out;
        private double scaleFactor;
        private Technology tech;

        public DEFPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath, EditingPreferences ep) {
            Network net3;
            NodeInst ni3;
            this.out = new DEF(this);
            this.tech = cell.getTechnology();
            if (this.out.openTextOutputStream(filePath)) {
                return this.out.finishWrite();
            }
            this.out.printWriter.println("VERSION 5.6 ;");
            this.out.printWriter.println("DIVIDERCHAR \"/\" ;");
            this.out.printWriter.println("BUSBITCHARS \"[]\" ;");
            this.out.printWriter.println();
            this.out.printWriter.println("DESIGN " + cell.getName() + " ;");
            double nanometersPerUnit = cell.getTechnology().getScale();
            this.scaleFactor = nanometersPerUnit * 100.0;
            this.out.printWriter.println();
            this.out.printWriter.println("UNITS DISTANCE MICRONS " + TextUtils.formatDouble(this.scaleFactor) + " ;");
            if (this.includeDateAndVersionInOutput) {
                Date now = new Date();
                this.out.printWriter.println();
                this.out.printWriter.println("HISTORY written by the Electric VLSI Design System, version " + Version.getVersion() + " on " + TextUtils.formatDate(now) + " ;");
            }
            if (IOTool.isUseCopyrightMessage()) {
                String str = IOTool.getCopyrightMessage();
                int start = 0;
                while (start < str.length()) {
                    int endPos = str.indexOf(10, start);
                    if (endPos < 0) {
                        endPos = str.length();
                    }
                    String oneLine = str.substring(start, endPos).replaceAll(";", ",");
                    this.out.printWriter.println("HISTORY " + oneLine + " ;");
                    start = endPos + 1;
                }
            }
            ERectangle cellBounds = cell.getBounds();
            this.out.printWriter.println();
            this.out.printWriter.println("DIEAREA ( " + this.convertToDEF(cellBounds.getMinX()) + " " + this.convertToDEF(cellBounds.getMinY()) + " ) ( " + this.convertToDEF(cellBounds.getMaxX()) + " " + this.convertToDEF(cellBounds.getMaxY()) + " ) ;");
            HashMap<NodeInst, String> contactNodes = new HashMap<NodeInst, String>();
            TreeMap<String, NodeInst> contactExamples = new TreeMap<String, NodeInst>();
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                PrimitiveNode np;
                PrimitiveNode.Function fun;
                NodeInst ni2 = it.next();
                if (ni2.isCellInstance() || (fun = (np = (PrimitiveNode)ni2.getProto()).getFunction()).isPin() || !fun.isContact() && fun != PrimitiveNode.Function.CONNECT && fun != PrimitiveNode.Function.SUBSTRATE && fun != PrimitiveNode.Function.WELL) continue;
                String cName = np.getName();
                if (np.getTechnology() != this.tech) {
                    cName = cName + "_TECH-" + np.getTechnology().getTechName();
                }
                if (ni2.getXSize() != np.getDefWidth(ep) || ni2.getYSize() != np.getDefHeight(ep)) {
                    cName = cName + "_SIZE-" + TextUtils.formatDouble(ni2.getXSize()) + "x" + TextUtils.formatDouble(ni2.getYSize());
                }
                if (ni2.getOrient() != Orientation.IDENT) {
                    cName = cName + "_ORIENT-" + ni2.getOrient().toString();
                }
                contactNodes.put(ni2, cName);
                contactExamples.put(cName, ni2);
            }
            if (contactExamples.size() > 0) {
                this.out.printWriter.println();
                this.out.printWriter.println("VIAS " + contactExamples.size() + " ;");
                for (String cName : contactExamples.keySet()) {
                    this.out.printWriter.println("- " + cName);
                    ni3 = (NodeInst)contactExamples.get(cName);
                    Poly[] polys = ni3.getProto().getTechnology().getShapeOfNode(ni3);
                    FixpTransform trans = ni3.rotateOut();
                    for (Poly poly : polys) {
                        poly.transform(trans);
                        Layer layer = poly.getLayer();
                        String layerName = this.getLayerName(layer);
                        if (layerName == null) {
                            System.out.println("ERROR: Cannot determine DEF layer for " + layer.getName() + " on node " + ni3.describe(false));
                            continue;
                        }
                        FixpRectangle bound = poly.getBounds2D();
                        double lX = bound.getMinX() - ni3.getAnchorCenterX();
                        double hX = bound.getMaxX() - ni3.getAnchorCenterX();
                        double lY = bound.getMinY() - ni3.getAnchorCenterY();
                        double hY = bound.getMaxY() - ni3.getAnchorCenterY();
                        this.out.printWriter.println("  + RECT " + layerName + " ( " + this.convertToDEF(lX) + " " + this.convertToDEF(lY) + " ) ( " + this.convertToDEF(hX) + " " + this.convertToDEF(hY) + " )");
                    }
                    this.out.printWriter.println("  ;");
                }
                this.out.printWriter.println("END VIAS");
            }
            ArrayList<NodeInst> cellInstances = new ArrayList<NodeInst>();
            Iterator<NodeInst> it2 = cell.getNodes();
            while (it2.hasNext()) {
                ni3 = it2.next();
                if (!ni3.isCellInstance()) continue;
                cellInstances.add(ni3);
            }
            if (cellInstances.size() > 0) {
                this.out.printWriter.println();
                this.out.printWriter.println("COMPONENTS " + cellInstances.size() + " ;");
                for (NodeInst ni3 : cellInstances) {
                    String orientation = null;
                    if (ni3.getOrient() == Orientation.IDENT) {
                        orientation = "N";
                    }
                    if (ni3.getOrient() == Orientation.R) {
                        orientation = "W";
                    }
                    if (ni3.getOrient() == Orientation.RR) {
                        orientation = "S";
                    }
                    if (ni3.getOrient() == Orientation.RRR) {
                        orientation = "E";
                    }
                    if (ni3.getOrient() == Orientation.Y) {
                        orientation = "FS";
                    }
                    if (ni3.getOrient() == Orientation.YR) {
                        orientation = "FW";
                    }
                    if (ni3.getOrient() == Orientation.YRR) {
                        orientation = "FN";
                    }
                    if (ni3.getOrient() == Orientation.YRRR) {
                        orientation = "FE";
                    }
                    if (ni3.getOrient() == Orientation.X) {
                        orientation = "FN";
                    }
                    if (ni3.getOrient() == Orientation.XR) {
                        orientation = "FE";
                    }
                    if (ni3.getOrient() == Orientation.XRR) {
                        orientation = "FS";
                    }
                    if (ni3.getOrient() == Orientation.XRRR) {
                        orientation = "FW";
                    }
                    if (ni3.getOrient() == Orientation.XY) {
                        orientation = "S";
                    }
                    if (ni3.getOrient() == Orientation.XYR) {
                        orientation = "E";
                    }
                    if (ni3.getOrient() == Orientation.XYRR) {
                        orientation = "N";
                    }
                    if (ni3.getOrient() == Orientation.XYRRR) {
                        orientation = "W";
                    }
                    if (orientation == null) {
                        System.out.println("ERROR: Cannot handle nonmanhattan instance: " + ni3.describe(false));
                        continue;
                    }
                    double nx = ni3.getAnchorCenterX();
                    double ny = ni3.getAnchorCenterY();
                    double width = ni3.getXSize();
                    double height = ni3.getYSize();
                    if (orientation.equals("FN")) {
                        nx -= width;
                    }
                    if (orientation.equals("FS")) {
                        ny -= height;
                    }
                    if (orientation.equals("FW")) {
                        nx -= height;
                        ny -= width;
                    }
                    if (orientation.equals("S")) {
                        ny -= height;
                        nx -= width;
                    }
                    if (orientation.equals("E")) {
                        ny -= width;
                    }
                    if (orientation.equals("W")) {
                        nx -= height;
                    }
                    this.out.printWriter.println("- " + ni3.getName() + " " + ni3.getProto().getName() + " + PLACED ( " + this.convertToDEF(nx) + " " + this.convertToDEF(ny) + " ) " + orientation + " ;");
                }
                this.out.printWriter.println("END COMPONENTS");
            }
            Netlist nl = cell.getNetlist();
            if (cell.getNumPorts() > 0) {
                this.out.printWriter.println();
                this.out.printWriter.println("PINS " + cell.getNumPorts() + " ;");
                Iterator<Export> it3 = cell.getExports();
                while (it3.hasNext()) {
                    Export e = it3.next();
                    String direction = "INPUT";
                    if (e.getCharacteristic() == PortCharacteristic.OUT) {
                        direction = "OUTPUT";
                    }
                    if (e.getCharacteristic() == PortCharacteristic.BIDIR) {
                        direction = "INOUT";
                    }
                    net3 = nl.getNetwork(e, 0);
                    this.out.printWriter.print("- " + e.getName() + " + NET " + net3.getName() + " + DIRECTION " + direction);
                    if (e.getCharacteristic() == PortCharacteristic.GND) {
                        this.out.printWriter.print(" + USE GROUND");
                    }
                    if (e.getCharacteristic() == PortCharacteristic.PWR) {
                        this.out.printWriter.print(" + USE POWER");
                    }
                    if (e.getCharacteristic().isClock()) {
                        this.out.printWriter.print(" + USE CLOCK");
                    }
                    this.out.printWriter.println();
                    this.out.printWriter.print(" ");
                    PortOriginal fp = new PortOriginal(e.getOriginalPort());
                    FixpTransform trans = fp.getTransformToTop();
                    NodeInst ni4 = fp.getBottomNodeInst();
                    PrimitiveNode pnp = (PrimitiveNode)ni4.getProto();
                    Poly[] polys = pnp.getTechnology().getShapeOfNode(ni4);
                    if (polys.length == 0) {
                        polys = new Poly[]{new Poly(ni4.getAnchorCenterX(), ni4.getAnchorCenterY(), ni4.getXSize(), ni4.getYSize())};
                        polys[0].setLayer(pnp.getLayerIterator().next());
                    }
                    for (int i = 0; i < polys.length; ++i) {
                        Poly poly = polys[i];
                        Layer layer = poly.getLayer();
                        String layerName = null;
                        if (layer.getFunction().isMetal()) {
                            layerName = layer.getName();
                        }
                        if (layer.getFunction().isPoly()) {
                            layerName = "POLY" + layer.getFunction().getLevel();
                        }
                        if (layerName == null) continue;
                        poly.transform(trans);
                        FixpRectangle rect = poly.getBounds2D();
                        this.out.printWriter.print(" + LAYER " + layerName + " ( " + this.convertToDEF(-rect.getWidth() / 2.0) + " " + this.convertToDEF(-rect.getHeight() / 2.0) + " ) ( " + this.convertToDEF(rect.getWidth() / 2.0) + " " + this.convertToDEF(rect.getHeight() / 2.0) + " )");
                    }
                    EPoint ctr = e.getPoly().getCenter();
                    this.out.printWriter.println(" + PLACED ( " + this.convertToDEF(ctr.getX()) + " " + this.convertToDEF(ctr.getY()) + " ) N ;");
                }
                this.out.printWriter.println("END PINS");
            }
            HashMap<Network, ArrayList<NodeInst>> nodesOnNets = new HashMap<Network, ArrayList<NodeInst>>();
            Iterator<NodeInst> it4 = cell.getNodes();
            while (it4.hasNext()) {
                NodeInst ni5 = it4.next();
                Iterator<PortInst> pit = ni5.getPortInsts();
                if (!pit.hasNext()) continue;
                PortInst pi = pit.next();
                Network net2 = nl.getNetwork(pi);
                ArrayList<NodeInst> niList = (ArrayList<NodeInst>)nodesOnNets.get(net2);
                if (niList == null) {
                    niList = new ArrayList<NodeInst>();
                    nodesOnNets.put(net2, niList);
                }
                niList.add(ni5);
            }
            TreeMap<Network, List<Object>> portsOnNets = new TreeMap<Network, List<Object>>();
            Iterator<Network> it5 = nl.getNetworks();
            while (it5.hasNext()) {
                NodeInst ni6;
                net3 = it5.next();
                List niList = (List)nodesOnNets.get(net3);
                if (niList != null && niList.size() == 1 && (ni6 = (NodeInst)niList.get(0)).getProto().getFunction() == PrimitiveNode.Function.NODE) {
                    ArrayList<PortInst> portList = new ArrayList<PortInst>(1);
                    portList.add(ni6.getOnlyPortInst());
                    portsOnNets.put(net3, portList);
                    continue;
                }
                portsOnNets.put(net3, net3.getPortsList());
            }
            if (portsOnNets.size() > 0) {
                this.out.printWriter.println();
                this.out.printWriter.println("SPECIALNETS " + portsOnNets.size() + " ;");
                for (Network net3 : portsOnNets.keySet()) {
                    List branches = (List)portsOnNets.get(net3);
                    String safeName = net3.getName().replaceAll("@", "-");
                    this.out.printWriter.print("- " + safeName);
                    Iterator<Export> eIt = net3.getExports();
                    while (eIt.hasNext()) {
                        Export e = eIt.next();
                        this.out.printWriter.print(" ( PIN " + e.getName() + " )");
                    }
                    HashSet<PortInst> portsSeen = new HashSet<PortInst>();
                    for (PortInst pi : branches) {
                        if (!pi.getNodeInst().isCellInstance() || portsSeen.contains(pi)) continue;
                        portsSeen.add(pi);
                        this.out.printWriter.print(" ( " + pi.getNodeInst().getName() + " " + pi.getPortProto().getName() + " )");
                    }
                    this.out.printWriter.println();
                    List niList = (List)nodesOnNets.get(net3);
                    if (niList != null) {
                        for (NodeInst ni7 : niList) {
                            if (ni7.isCellInstance()) continue;
                            PrimitiveNode.Function fun = ni7.getFunction();
                            String name = (String)contactNodes.get(ni7);
                            if (name != null) {
                                this.out.printWriter.println("  + FIXED M1 0 ( " + this.convertToDEF(ni7.getAnchorCenterX()) + " " + this.convertToDEF(ni7.getAnchorCenterY()) + " ) " + name);
                                continue;
                            }
                            if (fun.isPin()) continue;
                            Poly[] polys = ni7.getProto().getTechnology().getShapeOfNode(ni7);
                            FixpTransform trans = ni7.rotateOut();
                            for (Poly poly : polys) {
                                double wid;
                                double y2;
                                double x2;
                                double y1;
                                double x1;
                                if (poly.getLayer().getTechnology() == Generic.tech()) continue;
                                poly.transform(trans);
                                String layerName = this.getLayerName(poly.getLayer());
                                if (layerName == null) {
                                    System.out.println("ERROR: Cannot determine DEF layer for " + poly.getLayer().getName() + " on node " + ni7.describe(false));
                                    continue;
                                }
                                FixpRectangle bound = poly.getBounds2D();
                                if (bound.getWidth() > bound.getHeight()) {
                                    x1 = bound.getMinX();
                                    y1 = bound.getCenterY();
                                    x2 = bound.getMaxX();
                                    y2 = bound.getCenterY();
                                    wid = bound.getHeight();
                                } else {
                                    x1 = bound.getCenterX();
                                    y1 = bound.getMinY();
                                    x2 = bound.getCenterX();
                                    y2 = bound.getMaxY();
                                    wid = bound.getWidth();
                                }
                                long evenWid = Math.round(TextUtils.convertDistance(wid * this.scaleFactor, this.tech, TextUtils.UnitScale.MICRO));
                                if (evenWid % 2L != 0L) {
                                    --evenWid;
                                }
                                long x1Int = Math.round(TextUtils.convertDistance(x1 * this.scaleFactor, this.tech, TextUtils.UnitScale.MICRO));
                                long y1Int = Math.round(TextUtils.convertDistance(y1 * this.scaleFactor, this.tech, TextUtils.UnitScale.MICRO));
                                long x2Int = Math.round(TextUtils.convertDistance(x2 * this.scaleFactor, this.tech, TextUtils.UnitScale.MICRO));
                                long y2Int = Math.round(TextUtils.convertDistance(y2 * this.scaleFactor, this.tech, TextUtils.UnitScale.MICRO));
                                if (x1Int == x2Int && y1Int == y2Int) continue;
                                this.out.printWriter.println("  + FIXED " + layerName + " " + evenWid + " ( " + x1Int + " " + y1Int + " ) ( " + x2Int + " " + y2Int + " )");
                            }
                        }
                    }
                    Iterator<ArcInst> it6 = net3.getArcs();
                    while (it6.hasNext()) {
                        Poly[] polys;
                        ArcInst ai = it6.next();
                        for (Poly poly : polys = ai.getProto().getTechnology().getShapeOfArc(ai)) {
                            double wid;
                            double y2;
                            double x2;
                            double y1;
                            double x1;
                            if (poly.getLayer().getTechnology() == Generic.tech()) continue;
                            String layerName = this.getLayerName(poly.getLayer());
                            if (layerName == null) {
                                System.out.println("ERROR: Cannot determine DEF layer for " + poly.getLayer().getName() + " on arc " + ai.describe(false));
                                continue;
                            }
                            FixpRectangle bound = poly.getBounds2D();
                            if (bound.getWidth() > bound.getHeight()) {
                                x1 = bound.getMinX();
                                y1 = bound.getCenterY();
                                x2 = bound.getMaxX();
                                y2 = bound.getCenterY();
                                wid = bound.getHeight();
                            } else {
                                x1 = bound.getCenterX();
                                y1 = bound.getMinY();
                                x2 = bound.getCenterX();
                                y2 = bound.getMaxY();
                                wid = bound.getWidth();
                            }
                            long evenWid = Math.round(TextUtils.convertDistance(wid * this.scaleFactor, this.tech, TextUtils.UnitScale.MICRO));
                            if (evenWid % 2L != 0L) {
                                --evenWid;
                            }
                            long x1Int = Math.round(TextUtils.convertDistance(x1 * this.scaleFactor, this.tech, TextUtils.UnitScale.MICRO));
                            long y1Int = Math.round(TextUtils.convertDistance(y1 * this.scaleFactor, this.tech, TextUtils.UnitScale.MICRO));
                            long x2Int = Math.round(TextUtils.convertDistance(x2 * this.scaleFactor, this.tech, TextUtils.UnitScale.MICRO));
                            long y2Int = Math.round(TextUtils.convertDistance(y2 * this.scaleFactor, this.tech, TextUtils.UnitScale.MICRO));
                            if (x1Int == x2Int && y1Int == y2Int) continue;
                            this.out.printWriter.println("  + FIXED " + layerName + " " + evenWid + " ( " + x1Int + " " + y1Int + " ) ( " + x2Int + " " + y2Int + " )");
                        }
                    }
                    this.out.printWriter.println(" ;");
                }
                this.out.printWriter.println("END SPECIALNETS");
            }
            this.out.printWriter.println();
            this.out.printWriter.println("END DESIGN");
            if (this.out.closeTextOutputStream()) {
                return this.out.finishWrite();
            }
            System.out.println(filePath + " written");
            return this.out.finishWrite();
        }

        private String getLayerName(Layer layer) {
            String layerName = null;
            Layer.Function fun = layer.getFunction();
            if (fun.isMetal()) {
                layerName = layer.getName();
            }
            if (fun.isContact()) {
                layerName = "VIA" + fun.getLevel();
            }
            if (fun.isPoly()) {
                layerName = "POLY";
                if (fun.getLevel() > 0) {
                    layerName = layerName + fun.getLevel();
                }
            }
            if (fun.isDiff()) {
                layerName = "DIFF";
            }
            if (fun == Layer.Function.WELL) {
                layerName = "WELL";
            }
            if (fun == Layer.Function.WELLN) {
                layerName = "NWEL";
            }
            if (fun == Layer.Function.WELLP) {
                layerName = "PWEL";
            }
            if (fun == Layer.Function.SUBSTRATE) {
                layerName = "SUB";
            }
            if (fun == Layer.Function.IMPLANT) {
                layerName = "SUB";
            }
            if (fun == Layer.Function.IMPLANTN) {
                layerName = "NP";
            }
            if (fun == Layer.Function.IMPLANTP) {
                layerName = "PP";
            }
            return layerName;
        }

        private String convertToDEF(double v) {
            return TextUtils.formatDouble(TextUtils.convertDistance(v *= this.scaleFactor, this.tech, TextUtils.UnitScale.MICRO));
        }
    }
}

