/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.ChainNode;
import com.sun.electric.tool.simulation.test.ChainNodeDuplicate;
import com.sun.electric.tool.simulation.test.ChipNode;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.Logger;
import com.sun.electric.tool.simulation.test.MyTreeNode;
import com.sun.electric.tool.simulation.test.SubchainNode;
import com.sun.electric.tool.simulation.test.TestNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class XMLIO {
    public static final String READ_ACCESS_STRING = "R";
    public static final String WRITE_ACCESS_STRING = "W";
    public static final String NO_ACCESS_STRING = "-";
    public static final String SHADOW_ACCESS_STRING = "S";
    public static final String UNKNOWN_ACCESS_STRING = "?";
    public static final String UNPREDICTABLE_ACCESS_STRING = "U";
    public static final String DUAL_PORTED_SHADOW_ACCESS_STRING = "D";
    public static final String CLEARS_HI_STRING = "H";
    public static final String CLEARS_LO_STRING = "L";
    public static final String CLEARS_NOT_STRING = "-";
    public static final String CLEARS_UNKNOWN_STRING = "?";
    protected static final String SCAN_CHAIN_DATA_NETS = "scanChainDataNets";

    public static TestNode read(String filename) throws IOException, SAXException, ParserConfigurationException, Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(true);
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        XMLEntityResolver er = new XMLEntityResolver();
        db.setEntityResolver(er);
        db.setErrorHandler(er);
        Document doc = db.parse(filename);
        Element root2 = doc.getDocumentElement();
        Element element = (Element)root2.getElementsByTagName("system").item(0);
        TestNode system = XMLIO.readSystem(element, null);
        Logger.logInit("Read XML file " + filename + ", system=" + system);
        return system;
    }

    private static TestNode readSystem(Element element, TestNode parentNode) throws Exception {
        TestNode newNode = XMLIO.createTreeNode(element, parentNode);
        if (newNode == null) {
            return newNode;
        }
        if (parentNode != null) {
            parentNode.addChild(newNode);
        }
        NodeList children2 = element.getChildNodes();
        for (int ind = 0; ind < children2.getLength(); ++ind) {
            Node childElement = children2.item(ind);
            if (childElement.getNodeType() != 1) continue;
            XMLIO.readSystem((Element)childElement, newNode);
        }
        return newNode;
    }

    protected static TestNode createTreeNode(Element element, TestNode parentNode) throws Exception {
        if (element == null) {
            System.err.println("Warning null element");
            return null;
        }
        TestNode newNode = null;
        String tagName = element.getNodeName();
        if (tagName.equals("system")) {
            String comment2 = XMLIO.getField(element, "comment");
            if (comment2 == null || comment2.length() < 1) {
                comment2 = "System Top Level";
            }
            newNode = new TestNode("System", comment2);
        } else if (tagName.equals("chip")) {
            String name = element.getAttribute("name").trim();
            int lenIR = Integer.parseInt(element.getAttribute("lengthIR"));
            String comment3 = XMLIO.getField(element, "comment");
            newNode = new ChipNode(name, lenIR, comment3);
        } else if (tagName.equals("chain")) {
            newNode = XMLIO.processChain(element);
        } else if (tagName.equals("subchain")) {
            String name = element.getAttribute("name").trim();
            String pin = element.getAttribute("pin");
            int length = XMLIO.parseLength(element);
            String comment4 = XMLIO.getField(element, "comment");
            String dataNet = element.getAttribute("dataNet");
            String dataNetBar = element.getAttribute("dataNet2");
            newNode = new SubchainNode(name, length, pin, comment4, dataNet, dataNetBar);
        } else if (tagName.equals("duplicatechain")) {
            newNode = XMLIO.processDuplicateChain(element, parentNode);
        } else if (tagName.equals("forloop")) {
            newNode = XMLIO.processForLoop(element, parentNode);
        } else if (tagName.equals("comment")) {
            newNode = null;
        } else if (tagName.equals("scandatanets")) {
            String comment5 = XMLIO.getField(element, "comment");
            newNode = new TestNode(SCAN_CHAIN_DATA_NETS, comment5);
        } else if (tagName.equals("datachain")) {
            newNode = XMLIO.processChain(element);
        } else if (tagName.equals("datanet")) {
            String comment6 = XMLIO.getField(element, "comment");
            String name = element.getAttribute("name").trim();
            String dataNet = element.getAttribute("net");
            String dataNet2 = element.getAttribute("net2");
            newNode = new SubchainNode(name, 1, "", comment6, dataNet, dataNet2);
        } else {
            Infrastructure.fatal("Unrecognized tag name " + tagName + " in XML file\nparent node: " + parentNode);
        }
        if (newNode != null) {
            XMLIO.setAccess(element, parentNode, newNode);
            XMLIO.setClearBehavior(element, parentNode, newNode);
        }
        return newNode;
    }

    private static TestNode processChain(Element element) {
        String name = element.getAttribute("name").trim();
        String opcode = element.getAttribute("opcode").trim();
        int length = XMLIO.parseLength(element);
        String comment2 = XMLIO.getField(element, "comment");
        return new ChainNode(name, opcode, length, comment2);
    }

    private static TestNode processDuplicateChain(Element element, TestNode parentNode) {
        String name = element.getAttribute("name").trim();
        String opcode = element.getAttribute("opcode").trim();
        String reference = element.getAttribute("sameas").trim();
        TestNode pp = parentNode;
        while (!(parentNode instanceof ChipNode)) {
            parentNode = (TestNode)parentNode.getParent();
        }
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            MyTreeNode node = parentNode.getChildAt(i);
            if (!(node instanceof ChainNode) || !node.getName().equals(reference)) continue;
            return new ChainNodeDuplicate(name, opcode, (ChainNode)node);
        }
        Infrastructure.fatal("Could not find reference chain " + reference + " in XML file\nparent node: " + pp + " for duplicate chain: " + name);
        return null;
    }

    private static TestNode processForLoop(Element element, TestNode parentNode) throws Exception {
        int start = Integer.parseInt(element.getAttribute("initial"));
        int end = Integer.parseInt(element.getAttribute("final"));
        int increment = Integer.parseInt(element.getAttribute("increment"));
        if (end >= start && increment > 0) {
            for (int ind = start; ind <= end; ind += increment) {
                XMLIO.addForLoopChildren(element, parentNode, ind);
            }
        } else if (end <= start && increment < 0) {
            for (int ind = start; ind >= end; ind += increment) {
                XMLIO.addForLoopChildren(element, parentNode, ind);
            }
        } else {
            Infrastructure.fatal("Infinite <forloop> tag specified. Bad tag, bad!\n  parent='" + parentNode + "'\n  element='" + element + "'");
        }
        return null;
    }

    private static void addForLoopChildren(Element element, TestNode parentNode, int ind) throws Exception {
        NodeList children2 = element.getChildNodes();
        for (int i = 0; i < children2.getLength(); ++i) {
            TestNode childNode;
            Node childElement = children2.item(i);
            if (childElement.getNodeType() != 1 || (childNode = XMLIO.readSystem((Element)childElement, parentNode)) == null) continue;
            String name = childNode.getName() + Integer.toString(ind);
            childNode.setName(name);
        }
    }

    private static int parseLength(Element e) {
        int length = -1;
        try {
            String lengthS = e.getAttribute("length");
            length = Integer.parseInt(lengthS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return length;
    }

    private static String getField(Node n, String field2) {
        NodeList children2 = n.getChildNodes();
        boolean found = false;
        String ret = null;
        for (int i = 0; i < children2.getLength(); ++i) {
            Node childNode = children2.item(i);
            if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals(field2)) continue;
            if (found) {
                Infrastructure.fatal("getField: node '" + n + "' has more than one child named " + field2);
                continue;
            }
            found = true;
            ret = childNode.getFirstChild().getNodeValue();
        }
        return ret;
    }

    private static void setAccess(Element element, TestNode parentNode, TestNode newNode) {
        boolean usesDualPortedShadow;
        boolean usesShadow;
        boolean writeable;
        boolean readable;
        boolean unpredictable;
        String access = element.getAttribute("access").trim().toUpperCase();
        if (access.length() == 0) {
            unpredictable = parentNode.isUnpredictable();
            readable = parentNode.isReadable();
            writeable = parentNode.isWriteable();
            usesShadow = parentNode.usesShadow();
            usesDualPortedShadow = parentNode.usesDualPortedShadow();
        } else if (access.equals("?")) {
            writeable = true;
            readable = true;
            usesDualPortedShadow = false;
            usesShadow = false;
            unpredictable = false;
        } else if (access.equals("-")) {
            usesDualPortedShadow = false;
            usesShadow = false;
            writeable = false;
            readable = false;
            unpredictable = false;
        } else if (access.equals(UNPREDICTABLE_ACCESS_STRING)) {
            unpredictable = true;
            usesDualPortedShadow = false;
            usesShadow = false;
            writeable = false;
            readable = false;
        } else {
            int goodLength = 0;
            unpredictable = false;
            boolean bl = readable = access.indexOf(READ_ACCESS_STRING) >= 0;
            if (readable) {
                goodLength += READ_ACCESS_STRING.length();
            }
            boolean bl2 = writeable = access.indexOf(WRITE_ACCESS_STRING) >= 0;
            if (writeable) {
                goodLength += WRITE_ACCESS_STRING.length();
            }
            boolean bl3 = usesShadow = access.indexOf(SHADOW_ACCESS_STRING) >= 0;
            if (usesShadow) {
                goodLength += SHADOW_ACCESS_STRING.length();
            }
            boolean bl4 = usesDualPortedShadow = access.indexOf(DUAL_PORTED_SHADOW_ACCESS_STRING) >= 0;
            if (usesDualPortedShadow) {
                goodLength += DUAL_PORTED_SHADOW_ACCESS_STRING.length();
            }
            if (usesShadow && usesDualPortedShadow) {
                Infrastructure.fatal("Bad access string '" + element.getAttribute("access") + "' in XML file." + "\nCannot have S and D specified at the same time." + "\nerror node: '" + newNode + "'\nparent node: '" + parentNode + "'");
            }
            if (access.length() != goodLength) {
                Infrastructure.fatal("Bad access string '" + element.getAttribute("access") + "' in XML file." + "\nAllowed values are " + "?, U, -, R, W, RW, RWS, or RWD.\nerror node: '" + newNode + "'\nparent node: '" + parentNode + "'");
            }
        }
        newNode.setUnpredictable(unpredictable);
        newNode.setReadable(readable);
        newNode.setWriteable(writeable);
        newNode.setUsesShadow(usesShadow);
        newNode.setUsesDualPortedShadow(usesDualPortedShadow);
    }

    private static void setClearBehavior(Element element, TestNode parentNode, TestNode newNode) {
        int clearBehavior = 3;
        String clears = element.getAttribute("clears").trim().toUpperCase();
        if (clears.length() == 0) {
            clearBehavior = parentNode.getClearBehavior();
        } else if (clears.equals(CLEARS_LO_STRING)) {
            clearBehavior = 1;
        } else if (clears.equals(CLEARS_HI_STRING)) {
            clearBehavior = 2;
        } else if (clears.equals("-")) {
            clearBehavior = 0;
        } else if (clears.equals("?")) {
            clearBehavior = 3;
        } else {
            Infrastructure.fatal("Bad clears string '" + element.getAttribute("clears") + "' in XML file." + "\nAllowed values are ?, -, L, or H." + "\nerror node: " + newNode + "\nparent node: " + parentNode);
        }
        newNode.setClearBehavior(clearBehavior);
    }

    private static class XMLEntityResolver
    extends DefaultHandler {
        private XMLEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            InputStream inputStream = null;
            try {
                URL fileURL = this.getClass().getResource("ChainG.dtd");
                URLConnection urlCon = fileURL.openConnection();
                inputStream = urlCon.getInputStream();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return new InputSource(inputStream);
        }

        @Override
        public void fatalError(SAXParseException e) {
            System.out.println("Parser Fatal Error on line " + e.getLineNumber() + ", column " + e.getColumnNumber() + ". Check Validation rules in ChainG.dtd");
            e.printStackTrace();
            System.exit(1);
        }

        @Override
        public void warning(SAXParseException e) {
            System.out.println("Parser Warning");
            e.printStackTrace();
        }

        @Override
        public void error(SAXParseException e) {
            System.out.println("Parser Error on line " + e.getLineNumber() + ", column " + e.getColumnNumber() + ". Check Validation rules in ChainG.dtd");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

