/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellTree;
import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.network.NetCell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.Topology;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.collections.ArrayIterator;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.MutableInteger;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class Cell
extends ElectricObject
implements NodeProto,
Comparable<Cell> {
    private static final boolean USE_WEAK_REFERENCES = false;
    private static final boolean LAZY_TOPOLOGY = true;
    public static final Variable.Key CHARACTERISTIC_SPACING = Variable.newKey("FACET_characteristic_spacing");
    public static final Variable.Key CELL_TEXT_KEY = Variable.newKey("FACET_message");
    public static final Variable.Key MULTIPAGE_COUNT_KEY = Variable.newKey("CELL_page_count");
    public static final Variable.Key TEXT_CELL_FONT_NAME = Variable.newKey("CELL_text_font");
    public static final Variable.Key TEXT_CELL_FONT_SIZE = Variable.newKey("CELL_text_size");
    private static final int[] NULL_INT_ARRAY = new int[0];
    private static final Export[] NULL_EXPORT_ARRAY = new Export[0];
    public static final int WANTNEXPAND = 2;
    public static final int NPLOCKED = 0x100000;
    public static final int NPILOCKED = 0x200000;
    public static final int INCELLLIBRARY = 0x400000;
    public static final int TECEDITCELL = 0x800000;
    private static final int MULTIPAGE = 0x7E000000;
    private static final Rectangle2D CENTERRECT = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private final EDatabase database;
    private ImmutableCell d;
    private CellGroup cellGroup;
    private Library lib;
    private Technology tech;
    Cell newestVersion;
    private Export[] chronExports = new Export[2];
    private Export[] exports = NULL_EXPORT_ARRAY;
    private Reference<Topology> topologyRef;
    private Topology strongTopology;
    private final BitSet expandedNodes = new BitSet();
    private int[] cellUsages = NULL_INT_ARRAY;
    private int tempInt;
    private boolean expandStatusModified;
    CellTree tree;
    boolean cellTreeFresh;
    CellBackup backup;
    boolean cellBackupFresh;
    private boolean cellContentsFresh;
    private boolean revisionDateFresh;
    private Reference<NetCell> netCellRef;
    private static boolean allowCirDep = false;

    Cell(EDatabase database, ImmutableCell d) {
        this.database = database;
        this.d = d;
        this.lib = database.getLib(d.getLibId());
        assert (this.lib != null);
        if (d.techId != null) {
            this.tech = database.getTech(d.techId);
        }
        this.setTopologyRef(this.strongTopology);
        this.setNetCellRef(null);
    }

    private Object writeReplace() {
        return new CellKey(this);
    }

    public static Cell makeInstance(Library lib, String name) {
        return Cell.makeInstance(EditingPreferences.getInstance(), lib, name);
    }

    public static Cell makeInstance(EditingPreferences ep, Library lib, String name) {
        PrimitiveNode cellCenterProto;
        NodeInst cellCenter;
        Cell cell = Cell.newInstance(lib, name);
        if (ep.isPlaceCellCenter() && (cellCenter = NodeInst.newInstance(cellCenterProto = Generic.tech().cellCenterNode, ep, new Point2D.Double(0.0, 0.0), cellCenterProto.getDefWidth(ep), cellCenterProto.getDefHeight(ep), cell)) != null) {
            cellCenter.setVisInside();
            cellCenter.setHardSelect();
        }
        return cell;
    }

    public static Cell newInstance(Library lib, String name) {
        lib.checkChanging();
        EDatabase database = lib.getDatabase();
        CellName cellName = CellName.parseName(name);
        if (cellName == null) {
            return null;
        }
        String protoName = cellName.getName();
        String original = null;
        for (int i = 0; i < protoName.length(); ++i) {
            char chr = protoName.charAt(i);
            if (!TextUtils.isBadCellNameCharacter(chr)) continue;
            if (original == null) {
                original = protoName;
            }
            protoName = protoName.substring(0, i) + '_' + protoName.substring(i + 1);
        }
        if (original != null) {
            System.out.println("Cell name changed from '" + original + "' to '" + protoName + "'");
            cellName = CellName.newName(protoName, cellName.getView(), cellName.getVersion());
        }
        cellName = Cell.makeUnique(lib, cellName);
        Date creationDate = new Date();
        CellId cellId = lib.getId().newCellId(cellName);
        Cell cell = new Cell(lib.getDatabase(), ImmutableCell.newInstance(cellId, creationDate.getTime()));
        database.addCell(cell);
        lib.addCell(cell);
        cell.lowLevelLinkCellName();
        database.unfreshSnapshot();
        Constraints.getCurrent().newObject(cell);
        return cell;
    }

    private void lowLevelLinkCellName() {
        Iterator<Cell> it = this.getViewsTail();
        while (it.hasNext()) {
            Cell c = it.next();
            if (!c.getName().equals(this.getName())) continue;
            this.cellGroup = c.cellGroup;
        }
        if (this.cellGroup == null) {
            this.cellGroup = new CellGroup(this.lib);
        }
        this.cellGroup.add(this);
    }

    public void kill() {
        if (!this.isLinked()) {
            System.out.println("Cell already killed");
            return;
        }
        this.checkChanging();
        ArrayList<NodeInst> nodesToKill = new ArrayList<NodeInst>();
        Iterator<NodeInst> it = this.getInstancesOf();
        while (it.hasNext()) {
            nodesToKill.add(it.next());
        }
        for (NodeInst ni : nodesToKill) {
            ni.kill();
        }
        assert (!this.getUsagesOf().hasNext());
        this.lib.removeCell(this);
        this.cellGroup.remove(this);
        this.database.removeCell(this.getId());
        this.database.unfreshSnapshot();
        Constraints.getCurrent().killObject(this);
    }

    public static Cell copyNodeProto(Cell fromCell, Library toLib, String toName, boolean useExisting) {
        return Cell.copyNodeProto(fromCell, toLib, toName, useExisting, null);
    }

    public static Cell copyNodeProto(Cell fromCell, Library toLib, String toName, boolean useExisting, Map<String, Map<String, String>> cellNamesToUse) {
        if (fromCell == null) {
            return null;
        }
        if (toLib == null) {
            return null;
        }
        for (int i = 0; i < toName.length(); ++i) {
            char ch = toName.charAt(i);
            if (ch > ' ' && ch != ':' && ch < '\u007f') continue;
            System.out.println("invalid name of new cell");
            return null;
        }
        Library destLib = toLib;
        if (toLib == fromCell.getLibrary()) {
            destLib = null;
        }
        HashMap<NodeInst, NodeProto> nodePrototypes = new HashMap<NodeInst, NodeProto>();
        if (destLib != null) {
            Iterator<NodeInst> it = fromCell.getNodes();
            while (it.hasNext()) {
                String newCellName;
                Map<String, String> libToNameMap;
                NodeInst ni = it.next();
                if (!ni.isCellInstance()) continue;
                Cell niProto = (Cell)ni.getProto();
                boolean maySubstitute = useExisting;
                if (!maySubstitute && niProto.isIcon() && niProto.isIconOf(fromCell)) {
                    maySubstitute = true;
                }
                if (!maySubstitute) continue;
                String oldCellName = niProto.getName();
                if (cellNamesToUse != null && (libToNameMap = cellNamesToUse.get(oldCellName)) != null && (newCellName = libToNameMap.get(niProto.getLibrary().getName())) != null) {
                    oldCellName = newCellName;
                }
                Cell lnt = null;
                Iterator<Cell> cIt = toLib.getCells();
                while (cIt.hasNext() && (!(lnt = cIt.next()).getName().equals(oldCellName) || lnt.getView() != niProto.getView())) {
                    lnt = null;
                }
                if (lnt == null) continue;
                boolean validPorts = true;
                Iterator<PortInst> pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = pIt.next();
                    PortProto pp = pi.getPortProto();
                    PortProto ppt = lnt.findPortProto(pp.getName());
                    if (ppt != null) continue;
                    System.out.println("Cannot use subcell " + lnt.noLibDescribe() + " in " + destLib + ": exports don't match");
                    validPorts = false;
                    break;
                }
                if (!validPorts) continue;
                nodePrototypes.put(ni, lnt);
            }
        }
        return Cell.copyNodeProtoUsingMapping(fromCell, toLib, toName, nodePrototypes);
    }

    public static Cell copyNodeProtoUsingMapping(Cell fromCell, Library toLib, String toName, Map<NodeInst, NodeProto> nodePrototypes) {
        NodeInst ni;
        Cell newCell;
        String cellName = toName;
        if (toName.indexOf(123) < 0 && fromCell.getView() != View.UNKNOWN) {
            cellName = toName + fromCell.getView().getAbbreviationExtension();
        }
        if ((newCell = Cell.newInstance(toLib, cellName)) == null) {
            return null;
        }
        newCell.lowLevelSetUserbits(fromCell.lowLevelGetUserbits());
        HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
        Iterator<Serializable> it = fromCell.getNodes();
        while (it.hasNext()) {
            ni = it.next();
            NodeProto lnt = nodePrototypes.get(ni);
            if (lnt == null) {
                lnt = ni.getProto();
            }
            ImmutableNodeInst n = ni.getD();
            NodeInst toNi = NodeInst.newInstance(newCell, lnt, n.name.toString(), n.nameDescriptor, n.anchor, n.size, n.orient, n.flags, n.techBits, n.protoDescriptor, null);
            if (toNi == null) {
                return null;
            }
            newNodes.put(ni, toNi);
            toNi.copyTextDescriptorFrom(ni, NodeInst.NODE_PROTO);
            toNi.copyTextDescriptorFrom(ni, NodeInst.NODE_NAME);
            toNi.copyStateBits(ni);
        }
        it = fromCell.getNodes();
        while (it.hasNext()) {
            Variable var;
            ni = it.next();
            NodeInst toNi = (NodeInst)newNodes.get(ni);
            toNi.copyVarsFrom(ni);
            if (!newCell.isIcon() || (var = toNi.getVar(Schematics.SCHEM_FUNCTION)) == null || !fromCell.getName().equals(var.getObject())) continue;
            toNi.addVar(var.withObject(newCell.getName()));
        }
        it = fromCell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            PortInst[] opi = new PortInst[2];
            EPoint[] oLoc = new EPoint[2];
            for (int i = 0; i < 2; ++i) {
                opi[i] = null;
                NodeInst ono = (NodeInst)newNodes.get(ai.getPortInst(i).getNodeInst());
                PortProto pp = ai.getPortInst(i).getPortProto();
                if (!ono.isCellInstance()) {
                    opi[i] = ono.findPortInstFromProto(pp);
                } else {
                    PortProto ppt = ono.getProto().findPortProto(pp.getName());
                    if (ppt != null) {
                        opi[i] = ono.findPortInstFromProto(ppt);
                    }
                }
                if (opi[i] == null) {
                    System.out.println("Error: no port for " + ai.getProto() + " arc on " + ono.getProto());
                }
                oLoc[i] = ai.getLocation(i);
                Poly poly = opi[i].getPoly();
                if (poly.isInside(oLoc[i])) continue;
                oLoc[i] = poly.getCenter();
            }
            if (opi[0] == null || opi[1] == null) {
                return null;
            }
            ImmutableArcInst a = ai.getD();
            ArcInst toAi = ArcInst.newInstanceNoCheck(newCell, ai.getProto(), a.name.toString(), a.nameDescriptor, opi[1], opi[0], oLoc[1], oLoc[0], a.getGridExtendOverMin(), a.getAngle(), a.flags);
            if (toAi == null) {
                return null;
            }
            toAi.copyPropertiesFrom(ai);
        }
        it = fromCell.getExports();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            NodeInst ni2 = (NodeInst)newNodes.get(pp.getOriginalPort().getNodeInst());
            PortInst pi = ni2.findPortInst(pp.getOriginalPort().getPortProto().getName());
            if (pi == null) {
                System.out.println("Error: no port on " + pp.getOriginalPort().getNodeInst().getProto());
                return null;
            }
            ImmutableExport e = pp.getD();
            ExportId exportId = newCell.getId().newPortId(e.exportId.getExternalId());
            Export ppt = Export.newInstanceNoIcon(newCell, exportId, e.name.toString(), e.nameDescriptor, pi, e.alwaysDrawn, e.bodyOnly, e.characteristic, null);
            if (ppt == null) {
                return null;
            }
            ppt.copyVarsFrom(pp);
        }
        it = fromCell.getParametersAndVariables();
        while (it.hasNext()) {
            Variable fromVar = (Variable)it.next();
            if (newCell.isParam(fromVar.getKey())) {
                newCell.setTextDescriptor(fromVar.getKey(), fromVar.getTextDescriptor());
                continue;
            }
            if (fromVar.getTextDescriptor().isParam()) {
                newCell.getCellGroup().addParam(fromVar);
                newCell.setTextDescriptor(fromVar.getKey(), fromVar.getTextDescriptor());
                continue;
            }
            newCell.addVar(fromVar);
        }
        newCell.lowLevelSetCreationDate(fromCell.getCreationDate());
        newCell.lowLevelSetRevisionDate(fromCell.getRevisionDate());
        return newCell;
    }

    public void replaceSubcellsByExisting(EditingPreferences ep) {
        HashMap<NodeInst, Cell> nodePrototypes = new HashMap<NodeInst, Cell>();
        Iterator<NodeInst> it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (!ni.isCellInstance()) continue;
            Cell niProto = (Cell)ni.getProto();
            if (niProto.lib == this.lib) continue;
            Cell lnt = null;
            Iterator<Cell> cIt = this.lib.getCells();
            while (cIt.hasNext() && (!(lnt = cIt.next()).getName().equals(niProto.getName()) || lnt.getView() != niProto.getView())) {
                lnt = null;
            }
            if (lnt == null) continue;
            boolean validPorts = true;
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                PortProto pp = pi.getPortProto();
                PortProto ppt = lnt.findPortProto(pp.getName());
                if (ppt != null) continue;
                System.out.println("Cannot use subcell " + lnt.noLibDescribe() + " in " + this.lib + ": exports don't match");
                validPorts = false;
                break;
            }
            if (!validPorts) continue;
            nodePrototypes.put(ni, lnt);
        }
        for (Map.Entry e : nodePrototypes.entrySet()) {
            NodeInst ni = (NodeInst)e.getKey();
            Cell newProto = (Cell)e.getValue();
            ni.replace(newProto, ep, false, false, false);
        }
    }

    public IdMapper rename(String newName, String newGroupName) {
        return this.rename(CellName.parseName(newName + ";" + this.getVersion() + this.getView().getAbbreviationExtension()), newGroupName);
    }

    private IdMapper rename(CellName cellName, String newGroupName) {
        this.checkChanging();
        assert (this.isLinked());
        if (cellName == null) {
            return null;
        }
        if (this.getCellName().equals(cellName)) {
            return null;
        }
        cellName = Cell.makeUnique(this.lib, cellName);
        Snapshot oldSnapshot = this.database.backup();
        CellId newCellId = this.lib.getId().newCellId(cellName);
        IdMapper idMapper = IdMapper.renameCell(oldSnapshot, this.d.cellId, newCellId);
        Snapshot newSnapshot = oldSnapshot.withRenamedIds(idMapper, this.d.cellId, newGroupName);
        this.database.lowLevelSetCanUndoing(true);
        this.database.undo(newSnapshot);
        this.database.lowLevelSetCanUndoing(false);
        Constraints.getCurrent().renameIds(idMapper);
        this.lib.setChanged();
        return idMapper;
    }

    private static CellName makeUnique(Library lib, CellName cellName) {
        String protoName = cellName.getName();
        View view = cellName.getView();
        int version = cellName.getVersion();
        int greatestVersion = 0;
        boolean conflict = version <= 0;
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell c = it.next();
            if (!c.getName().equals(protoName) || c.getView() != view) continue;
            if (c.getVersion() == version) {
                conflict = true;
            }
            if (c.getVersion() <= greatestVersion) continue;
            greatestVersion = c.getVersion();
        }
        if (conflict) {
            if (version > 0) {
                System.out.println("Already have cell " + cellName + " with version " + version + ", generating a new version");
            }
            int newVersion = greatestVersion + 1;
            cellName = CellName.newName(protoName, view, newVersion);
        }
        return cellName;
    }

    public int lowLevelGetUserbits() {
        return this.getD().flags;
    }

    public void lowLevelSetUserbits(int userBits) {
        this.setD(this.getD().withFlags(userBits));
    }

    public CellTree tree() {
        if (this.cellTreeFresh) {
            return this.tree;
        }
        this.checkChanging();
        return this.doTree();
    }

    public CellBackup backup() {
        if (this.cellBackupFresh) {
            return this.backup;
        }
        this.checkChanging();
        return this.doBackup();
    }

    public Topology getTopology() {
        Topology topology = this.topologyRef.get();
        if (topology != null) {
            return topology;
        }
        return this.createTopology();
    }

    private synchronized Topology createTopology() {
        assert (this.strongTopology == null);
        Topology topology = new Topology(this, this.backup != null);
        this.setTopologyRef(topology);
        return topology;
    }

    private void setTopologyRef(Topology topology) {
        this.topologyRef = new SoftReference<Topology>(topology);
    }

    public Topology getTopologyOptional() {
        return this.topologyRef.get();
    }

    private CellTree doTree() {
        CellBackup top = this.backup();
        CellTree[] subTrees = new CellTree[this.cellUsages.length];
        for (int i = 0; i < this.cellUsages.length; ++i) {
            if (this.cellUsages[i] == 0) continue;
            CellId subCellId = this.getId().getUsageIn((int)i).protoId;
            subTrees[i] = this.database.getCell(subCellId).tree();
        }
        this.tree = this.tree.with(top, subTrees, this.getTechPool());
        this.cellTreeFresh = true;
        return this.tree;
    }

    private CellBackup doBackup() {
        TechPool techPool = this.getTechPool();
        if (this.backup == null) {
            this.getTechnology();
            this.backup = CellBackup.newInstance(this.getD().withoutVariables(), techPool);
            this.tree = CellTree.newInstance(this.backup.cellRevision.d, techPool).with(this.backup, CellTree.NULL_ARRAY, techPool);
            assert (!(this.cellTreeFresh || this.cellBackupFresh || this.cellContentsFresh || this.revisionDateFresh));
        }
        ImmutableNodeInst[] nodes = null;
        ImmutableArcInst[] arcs = null;
        ImmutableExport[] exports = null;
        if (!this.cellContentsFresh) {
            Topology topology = this.getTopologyOptional();
            nodes = topology != null ? topology.backupNodes(this.backup.cellRevision.nodes) : null;
            arcs = topology != null ? topology.backupArcs(this.backup.cellRevision.arcs) : null;
            exports = this.backupExports();
        }
        this.backup = this.backup.with(this.getD(), nodes, arcs, exports, techPool);
        this.cellBackupFresh = true;
        this.cellContentsFresh = true;
        this.strongTopology = null;
        if (this.backup.modified) {
            this.lib.setChanged();
        }
        return this.backup;
    }

    private ImmutableExport[] backupExports() {
        ImmutableExport[] newExports = new ImmutableExport[this.exports.length];
        ImmutableExport.Iterable oldExports = this.backup.cellRevision.exports;
        boolean changed = this.exports.length != oldExports.size();
        for (int i = 0; i < this.exports.length; ++i) {
            Export e = this.exports[i];
            ImmutableExport d = e.getD();
            changed = changed || oldExports.get(i) != d;
            newExports[i] = d;
        }
        return changed ? newExports : null;
    }

    void recover(CellTree newTree) {
        this.update(true, newTree, null);
    }

    void undo(CellTree newTree, BitSet exportsModified, BitSet boundsModified) {
        if (this.backup == null) {
            this.recover(newTree);
            return;
        }
        assert (this.cellBackupFresh);
        if (this.backup != newTree.top) {
            this.update(false, newTree, exportsModified);
        } else {
            if (exportsModified != null || boundsModified != null) {
                this.checkUndoing();
                Topology topology = this.getTopologyOptional();
                if (topology != null) {
                    topology.updateSubCells(exportsModified, boundsModified);
                }
            }
            this.cellTreeFresh = true;
            this.tree = newTree;
        }
    }

    private void update(boolean full, CellTree newTree, BitSet exportsModified) {
        this.checkUndoing();
        this.unfreshRTree();
        CellBackup newBackup = newTree.top;
        CellRevision newRevision = newBackup.cellRevision;
        this.d = newRevision.d;
        this.lib = this.database.getLib(newRevision.d.getLibId());
        this.tech = this.database.getTech(newRevision.d.techId);
        this.cellUsages = newRevision.getInstCounts();
        Topology topology = this.getTopologyOptional();
        if (topology != null) {
            if (topology.updateNodes(full, newRevision, exportsModified, this.expandedNodes)) {
                this.expandStatusModified = true;
            }
            topology.updateArcs(newRevision);
        }
        this.exports = new Export[newRevision.exports.size()];
        for (int i = 0; i < newRevision.exports.size(); ++i) {
            Export e;
            ImmutableExport d = newRevision.exports.get(i);
            int chronIndex = d.exportId.getChronIndex();
            if (this.chronExports.length <= chronIndex) {
                Export[] newChronExports = new Export[Math.max(chronIndex + 1, this.chronExports.length * 2)];
                System.arraycopy(this.chronExports, 0, newChronExports, 0, this.chronExports.length);
                this.chronExports = newChronExports;
            }
            if ((e = this.chronExports[chronIndex]) != null) {
                e.setDInUndo(d);
            } else {
                this.chronExports[chronIndex] = e = new Export(d, this);
            }
            e.setPortIndex(i);
            this.exports[i] = e;
        }
        int exportCount = 0;
        for (int i = 0; i < this.chronExports.length; ++i) {
            Export e = this.chronExports[i];
            if (e == null) continue;
            int portIndex = e.getPortIndex();
            if (portIndex >= this.exports.length || e != this.exports[portIndex]) {
                e.setPortIndex(-1);
                this.chronExports[i] = null;
                continue;
            }
            ++exportCount;
        }
        assert (exportCount == this.exports.length);
        this.tree = newTree;
        this.backup = newBackup;
        this.cellTreeFresh = true;
        this.cellBackupFresh = true;
        this.cellContentsFresh = true;
        this.strongTopology = null;
        this.revisionDateFresh = true;
    }

    public double getDefWidth() {
        return this.getBounds().getWidth();
    }

    @Override
    public double getDefWidth(EditingPreferences ep) {
        return this.getBounds().getWidth();
    }

    public double getDefHeight() {
        return this.getBounds().getHeight();
    }

    @Override
    public double getDefHeight(EditingPreferences ep) {
        return this.getBounds().getHeight();
    }

    @Override
    public EPoint getDefSize(EditingPreferences ep) {
        return EPoint.ORIGIN;
    }

    @Override
    public SizeOffset getProtoSizeOffset() {
        return SizeOffset.ZERO_OFFSET;
    }

    public Iterator<Geometric> searchIterator(Rectangle2D bounds) {
        return this.searchIterator(bounds, true);
    }

    public Iterator<Geometric> searchIterator(Rectangle2D bounds, boolean includeEdges) {
        return this.getTopology().searchIterator(bounds, includeEdges);
    }

    public ERectangle getBounds() {
        return this.tree().getBounds();
    }

    public Rectangle2D findEssentialBounds() {
        return this.getTopology().findEssentialBounds();
    }

    public boolean alreadyCellCenter() {
        Iterator<NodeInst> it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (!Generic.isCellCenter(ni)) continue;
            return true;
        }
        return false;
    }

    public void adjustReferencePoint(double cX, double cY) {
        NodeInst ni;
        this.checkChanging();
        if (cX == 0.0 && cY == 0.0) {
            return;
        }
        Iterator<Geometric> it = this.getNodes();
        while (it.hasNext()) {
            ni = it.next();
            if (Generic.isCellCenter(ni)) continue;
            ni.move(-cX, -cY);
        }
        it = this.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            ai.modify(-cX, -cY, -cX, -cY);
        }
        it = this.getInstancesOf();
        while (it.hasNext()) {
            ni = (NodeInst)it.next();
            FixpTransform trans = ni.getOrient().pureRotate();
            Point2D.Double in = new Point2D.Double(cX, cY);
            trans.transform(in, in);
            ni.move(((Point2D)in).getX(), ((Point2D)in).getY());
        }
        Job.getUserInterface().adjustReferencePoint(this, cX, cY);
    }

    public synchronized Iterator<NodeInst> getNodes() {
        return this.getTopology().getNodes();
    }

    public synchronized Iterator<Nodable> getNodables() {
        return this.getTopology().getNodables();
    }

    public int getNumNodes() {
        Topology topology = this.getTopologyOptional();
        return topology != null ? topology.getNumNodes() : this.backup().cellRevision.nodes.size();
    }

    public final NodeInst getNode(int nodeIndex) {
        return this.getTopology().getNode(nodeIndex);
    }

    public NodeInst getNodeById(int nodeId) {
        return this.getTopology().getNodeById(nodeId);
    }

    public boolean isExpanded(int nodeId) {
        return this.expandedNodes.get(nodeId);
    }

    public BitSet lowLevelExpandedNodes() {
        return this.expandedNodes;
    }

    public void setExpanded(int nodeId, boolean value2) {
        ImmutableNodeInst n = this.backup().cellRevision.getNodeById(nodeId);
        if (n == null) {
            return;
        }
        if (!(n.protoId instanceof CellId) || ((CellId)n.protoId).isIcon()) {
            return;
        }
        boolean oldValue = this.expandedNodes.get(nodeId);
        if (oldValue == value2) {
            return;
        }
        this.expandedNodes.set(nodeId, value2);
        this.expandStatusModified = true;
    }

    void expand(BitSet subCells) {
        int nodeId = subCells.nextSetBit(0);
        while (nodeId >= 0) {
            this.setExpanded(nodeId, true);
            nodeId = subCells.nextSetBit(nodeId + 1);
        }
    }

    public PortInst getPortInst(int nodeId, PortProtoId portProtoId) {
        return this.getTopology().getPortInst(nodeId, portProtoId);
    }

    public synchronized Iterator<CellUsage> getUsagesIn() {
        return new Iterator<CellUsage>(){
            private int i = 0;
            CellUsage nextU = this.findNext();

            @Override
            public boolean hasNext() {
                return this.nextU != null;
            }

            @Override
            public CellUsage next() {
                if (this.nextU == null) {
                    throw new NoSuchElementException();
                }
                CellUsage u = this.nextU;
                this.nextU = this.findNext();
                return u;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private CellUsage findNext() {
                while (this.i < Cell.this.cellUsages.length) {
                    if (Cell.this.cellUsages[this.i] != 0) {
                        return Cell.this.getId().getUsageIn(this.i++);
                    }
                    ++this.i;
                }
                return null;
            }
        };
    }

    public int getNumUsagesIn() {
        int numUsages = 0;
        for (int i = 0; i < this.cellUsages.length; ++i) {
            if (this.cellUsages[i] == 0) continue;
            ++numUsages;
        }
        return numUsages;
    }

    public NodeInst findNode(String name) {
        return this.getTopology().findNode(name);
    }

    public void killNodes(Set<NodeInst> killedNodes) {
        if (killedNodes.isEmpty()) {
            return;
        }
        for (NodeInst ni : killedNodes) {
            if (ni.getParent() == this) continue;
            throw new IllegalArgumentException("parent");
        }
        HashSet<ArcInst> arcsToKill = new HashSet<ArcInst>();
        Iterator<ArcInst> it = this.getArcs();
        while (it.hasNext()) {
            ArcInst ai = it.next();
            if (!killedNodes.contains(ai.getTailPortInst().getNodeInst()) && !killedNodes.contains(ai.getHeadPortInst().getNodeInst())) continue;
            arcsToKill.add(ai);
        }
        HashSet<Export> exportsToKill = new HashSet<Export>();
        Iterator<Export> it2 = this.getExports();
        while (it2.hasNext()) {
            Export export = it2.next();
            if (!killedNodes.contains(export.getOriginalPort().getNodeInst())) continue;
            exportsToKill.add(export);
        }
        for (ArcInst ai : arcsToKill) {
            ai.kill();
        }
        this.killExports(exportsToKill);
        for (NodeInst ni : killedNodes) {
            if (!ni.isLinked()) continue;
            this.removeNode(ni);
            Constraints.getCurrent().killObject(ni);
        }
    }

    public static void setAllowCircularLibraryDependences(boolean val) {
        allowCirDep = val;
    }

    /*
     * WARNING - void declaration
     */
    public void addNodes(Collection<ImmutableNodeInst> nodes) {
        this.checkChanging();
        EPoint newCellCenterAnchor = null;
        BitSet nodeIds = new BitSet();
        HashSet<Name> names = new HashSet<Name>();
        Iterator<NodeInst> it = this.getNodes();
        while (it.hasNext()) {
            ImmutableNodeInst n = it.next().getD();
            names.add(n.name);
            if (nodeIds.get(n.nodeId)) {
                throw new IllegalArgumentException("Duplicated");
            }
            nodeIds.set(n.nodeId);
        }
        HashMap<CellId, MutableInteger> subCellIds = new HashMap<CellId, MutableInteger>();
        ArrayList<NodeInst> newNodes = new ArrayList<NodeInst>();
        for (ImmutableNodeInst n : nodes) {
            Library.LibraryDependency libDep;
            Cell cell;
            if (n.protoId instanceof CellId) {
                void var10_14;
                CellId subCellId = (CellId)n.protoId;
                MutableInteger mutableInteger = (MutableInteger)subCellIds.get(subCellId);
                if (mutableInteger == null) {
                    MutableInteger mutableInteger2 = new MutableInteger(0);
                    subCellIds.put(subCellId, mutableInteger2);
                }
                var10_14.increment();
            }
            if (ImmutableNodeInst.isCellCenter(n.protoId)) {
                if (this.alreadyCellCenter() || newCellCenterAnchor != null) {
                    System.out.println("Can only be one cell-center in " + this + ": new one ignored");
                    throw new IllegalArgumentException();
                }
                newCellCenterAnchor = n.anchor;
            }
            if (!names.add(n.name)) {
                System.out.println(this + " already has NodeInst with name \"" + n.name + "\"");
                throw new IllegalArgumentException();
            }
            NodeInst ni = NodeInst.lowLevelNewInstance(this.getTopology(), n);
            newNodes.add(ni);
            assert (ni.checkAndRepair(true, null, null) == 0);
            if (!ni.isCellInstance() || (cell = (Cell)ni.getProto()).getLibrary() == this.getLibrary() || (libDep = this.getLibrary().addReferencedLib(cell.getLibrary())) == null) continue;
            if (!allowCirDep) {
                System.out.println("ERROR: " + this.libDescribe() + " cannot instantiate " + cell.libDescribe() + " because it would create a circular library dependence: ");
                System.out.println(libDep.toString());
                throw new IllegalArgumentException();
            }
            System.out.println("WARNING: " + this.libDescribe() + " instantiates " + cell.libDescribe() + " which causes a circular library dependence: ");
            System.out.println(libDep.toString());
        }
        for (CellId cellId : subCellIds.keySet()) {
            Cell subCell = this.getDatabase().getCell(cellId);
            if (Cell.isInstantiationRecursive(subCell, this)) {
                System.out.println("Cannot create instance of " + subCell + " in " + this + " because it would be a recursive case");
                throw new IllegalArgumentException();
            }
            subCell.getTechnology();
        }
        Collections.sort(newNodes);
        Topology topology = this.getTopology();
        int newNumNodes = topology.getNumNodes() + newNodes.size();
        this.setTopologyModified();
        topology.addNodes(newNodes);
        for (NodeInst nodeInst : newNodes) {
            Constraints.getCurrent().newObject(nodeInst);
        }
        for (Map.Entry entry : subCellIds.entrySet()) {
            CellUsage u = this.getId().getUsageIn((CellId)entry.getKey());
            if (this.cellUsages.length <= u.indexInParent) {
                int[] newCellUsages = new int[u.indexInParent + 1];
                System.arraycopy(this.cellUsages, 0, newCellUsages, 0, this.cellUsages.length);
                this.cellUsages = newCellUsages;
            }
            int n = u.indexInParent;
            this.cellUsages[n] = this.cellUsages[n] + ((MutableInteger)entry.getValue()).intValue();
        }
        if (newCellCenterAnchor != null) {
            this.adjustReferencePoint(newCellCenterAnchor.getX(), newCellCenterAnchor.getY());
        }
        assert (!this.cellContentsFresh && !this.cellBackupFresh && this.strongTopology == topology);
        assert (topology.getNumNodes() == newNumNodes);
    }

    public NodeInst addNode(ImmutableNodeInst n) {
        Library.LibraryDependency libDep;
        Cell instProto;
        this.checkChanging();
        if (n.protoId instanceof CellId) {
            Cell subCell = this.getDatabase().getCell((CellId)n.protoId);
            if (Cell.isInstantiationRecursive(subCell, this)) {
                System.out.println("Cannot create instance of " + subCell + " in " + this + " because it would be a recursive case");
                return null;
            }
            subCell.getTechnology();
        }
        if (ImmutableNodeInst.isCellCenter(n.protoId) && this.alreadyCellCenter()) {
            System.out.println("Can only be one cell-center in " + this + ": new one ignored");
            return null;
        }
        if (this.findNode(n.name.toString()) != null) {
            System.out.println(this + " already has NodeInst with name \"" + n.name + "\"");
            return null;
        }
        NodeInst ni = NodeInst.lowLevelNewInstance(this.getTopology(), n);
        assert (ni.checkAndRepair(true, null, null) == 0);
        if (ni.isCellInstance() && (instProto = (Cell)ni.getProto()).getLibrary() != this.getLibrary() && (libDep = this.getLibrary().addReferencedLib(instProto.getLibrary())) != null) {
            if (!allowCirDep) {
                System.out.println("ERROR: " + this.libDescribe() + " cannot instantiate " + instProto.libDescribe() + " because it would create a circular library dependence: ");
                System.out.println(libDep.toString());
                return null;
            }
            System.out.println("WARNING: " + this.libDescribe() + " instantiates " + instProto.libDescribe() + " which causes a circular library dependence: ");
            System.out.println(libDep.toString());
        }
        this.setTopologyModified();
        int nodeId = this.getTopology().addNode(ni);
        if (ni.isCellInstance()) {
            Cell subCell = (Cell)ni.getProto();
            this.expandedNodes.set(nodeId, subCell.isWantExpanded());
            this.expandStatusModified = true;
            CellUsage u = this.getId().getUsageIn(subCell.getId());
            if (this.cellUsages.length <= u.indexInParent) {
                int[] newCellUsages = new int[u.indexInParent + 1];
                System.arraycopy(this.cellUsages, 0, newCellUsages, 0, this.cellUsages.length);
                this.cellUsages = newCellUsages;
            }
            int n2 = u.indexInParent;
            this.cellUsages[n2] = this.cellUsages[n2] + 1;
        }
        Constraints.getCurrent().newObject(ni);
        if (ImmutableNodeInst.isCellCenter(n.protoId)) {
            this.adjustReferencePoint(n.anchor.getX(), n.anchor.getY());
        }
        return ni;
    }

    private void removeNode(NodeInst ni) {
        this.checkChanging();
        assert (ni.isLinked());
        this.getTopology().removeNode(ni);
        if (ni.isCellInstance()) {
            Cell subCell = (Cell)ni.getProto();
            CellUsage u = this.getId().getUsageIn(subCell.getId());
            int n = u.indexInParent;
            this.cellUsages[n] = this.cellUsages[n] - 1;
            if (this.cellUsages[u.indexInParent] <= 0) {
                assert (this.cellUsages[u.indexInParent] == 0);
                this.getLibrary().removeReferencedLib(((Cell)ni.getProto()).getLibrary());
            }
        }
        this.setTopologyModified();
    }

    public synchronized Iterator<ArcInst> getArcs() {
        return this.getTopology().getArcs();
    }

    public int getNumArcs() {
        Topology topology = this.getTopologyOptional();
        return topology != null ? topology.getNumArcs() : this.backup().cellRevision.arcs.size();
    }

    public final ArcInst getArc(int arcIndex) {
        return this.getTopology().getArc(arcIndex);
    }

    public ArcInst getArcById(int arcId) {
        return this.getTopology().getArcById(arcId);
    }

    public ArcInst findArc(String name) {
        return this.getTopology().findArc(name);
    }

    public void killArcs(Set<ArcInst> killedArcs) {
        if (killedArcs.isEmpty()) {
            return;
        }
        for (ArcInst ai : killedArcs) {
            if (ai.getParent() == this) continue;
            throw new IllegalArgumentException("parent");
        }
        for (int arcIndex = this.getNumArcs() - 1; arcIndex >= 0; --arcIndex) {
            ArcInst ai;
            ai = this.getArc(arcIndex);
            if (!killedArcs.contains(ai)) continue;
            ai.kill();
        }
    }

    public void addExports(Collection<ImmutableExport> exports) {
        ImmutableExport[] a = exports.toArray(new ImmutableExport[exports.size()]);
        Arrays.sort(a, ImmutableExport.NAME_ORDER);
        for (ImmutableExport e : a) {
            this.addExport(e);
        }
    }

    public Export addExport(ImmutableExport e) {
        if (e.exportId.parentId != this.getId() || this.getExportChron(e.exportId.chronIndex) != null || e.nameDescriptor == null || this.getPortInst(e.originalNodeId, e.originalPortId) == null) {
            throw new IllegalArgumentException();
        }
        this.checkChanging();
        this.setContentsModified();
        Export export = new Export(e, this);
        int portIndex = -this.searchExport(export.getName()) - 1;
        if (portIndex < 0) {
            throw new IllegalArgumentException("Duplicate Export name " + export.getName());
        }
        assert (portIndex >= 0);
        export.setPortIndex(portIndex);
        int chronIndex = export.getId().getChronIndex();
        if (this.chronExports.length <= chronIndex) {
            Export[] newChronExports = new Export[Math.max(chronIndex + 1, this.chronExports.length * 2)];
            System.arraycopy(this.chronExports, 0, newChronExports, 0, this.chronExports.length);
            this.chronExports = newChronExports;
        }
        this.chronExports[chronIndex] = export;
        Export[] newExports = new Export[this.exports.length + 1];
        System.arraycopy(this.exports, 0, newExports, 0, portIndex);
        newExports[portIndex] = export;
        for (int i = portIndex; i < this.exports.length; ++i) {
            Export ex = this.exports[i];
            ex.setPortIndex(i + 1);
            newExports[i + 1] = ex;
        }
        this.exports = newExports;
        if (this.getId().numUsagesOf() != 0) {
            int i;
            int[] pattern = new int[this.exports.length];
            for (i = 0; i < portIndex; ++i) {
                pattern[i] = i;
            }
            pattern[portIndex] = -1;
            for (i = portIndex + 1; i < this.exports.length; ++i) {
                pattern[i] = i - 1;
            }
            this.updatePortInsts(pattern);
        }
        export.getOriginalPort().getNodeInst().redoGeometric();
        Constraints.getCurrent().newObject(export);
        return export;
    }

    void removeExport(Export export) {
        int i;
        this.checkChanging();
        this.setContentsModified();
        int portIndex = export.getPortIndex();
        Export[] newExports = this.exports.length > 1 ? new Export[this.exports.length - 1] : NULL_EXPORT_ARRAY;
        System.arraycopy(this.exports, 0, newExports, 0, portIndex);
        for (int i2 = portIndex; i2 < newExports.length; ++i2) {
            Export e = this.exports[i2 + 1];
            e.setPortIndex(i2);
            newExports[i2] = e;
        }
        this.exports = newExports;
        this.chronExports[export.getId().getChronIndex()] = null;
        export.setPortIndex(-1);
        if (this.getId().numUsagesOf() == 0) {
            return;
        }
        int[] pattern = new int[this.exports.length];
        for (i = 0; i < portIndex; ++i) {
            pattern[i] = i;
        }
        for (i = portIndex; i < this.exports.length; ++i) {
            pattern[i] = i + 1;
        }
        this.updatePortInsts(pattern);
    }

    void moveExport(int oldPortIndex, String newName) {
        int i;
        Export e;
        int i2;
        Export export = this.exports[oldPortIndex];
        int newPortIndex = -this.searchExport(newName) - 1;
        if (newPortIndex < 0) {
            return;
        }
        if (newPortIndex > oldPortIndex) {
            --newPortIndex;
        }
        if (newPortIndex == oldPortIndex) {
            return;
        }
        if (newPortIndex > oldPortIndex) {
            for (i2 = oldPortIndex; i2 < newPortIndex; ++i2) {
                e = this.exports[i2 + 1];
                e.setPortIndex(i2);
                this.exports[i2] = e;
            }
        } else {
            for (i2 = oldPortIndex; i2 > newPortIndex; --i2) {
                e = this.exports[i2 - 1];
                e.setPortIndex(i2);
                this.exports[i2] = e;
            }
        }
        export.setPortIndex(newPortIndex);
        this.exports[newPortIndex] = export;
        if (this.getId().numUsagesOf() == 0) {
            return;
        }
        int[] pattern = new int[this.exports.length];
        for (i = 0; i < pattern.length; ++i) {
            pattern[i] = i;
        }
        pattern[newPortIndex] = oldPortIndex;
        if (newPortIndex > oldPortIndex) {
            for (i = oldPortIndex; i < newPortIndex; ++i) {
                pattern[i] = i + 1;
            }
        } else {
            for (i = oldPortIndex; i > newPortIndex; --i) {
                pattern[i] = i - 1;
            }
        }
        this.updatePortInsts(pattern);
    }

    public void updatePortInsts(int[] pattern) {
        Iterator<CellUsage> it = this.getUsagesOf();
        while (it.hasNext()) {
            CellUsage cu = it.next();
            Cell parentCell = cu.getParent(this.database);
            Topology topology = parentCell.getTopologyOptional();
            if (topology == null) continue;
            topology.updatePortInsts(this, pattern);
        }
    }

    public void killExports(Set<Export> killedExports) {
        this.checkChanging();
        if (killedExports.isEmpty()) {
            return;
        }
        for (Export export : killedExports) {
            if (export.getParent() == this) continue;
            throw new IllegalArgumentException("parent");
        }
        Export[] killedExportsArray = killedExports.toArray(new Export[killedExports.size()]);
        Iterator<CellUsage> uit = this.getUsagesOf();
        while (uit.hasNext()) {
            CellUsage u = uit.next();
            Cell higherCell = this.database.getCell(u.parentId);
            ArrayList<ArcInst> arcsToKill = new ArrayList<ArcInst>();
            Iterator<ArcInst> ait = higherCell.getArcs();
            while (ait.hasNext()) {
                ArcInst ai = ait.next();
                PortInst tail = ai.getTailPortInst();
                PortInst head2 = ai.getHeadPortInst();
                if ((tail.getNodeInst().getProto() != this || !killedExports.contains(tail.getPortProto())) && (head2.getNodeInst().getProto() != this || !killedExports.contains(head2.getPortProto()))) continue;
                arcsToKill.add(ai);
            }
            HashSet<Export> higherExportsToKill = null;
            for (Export higherExport : higherCell.exports) {
                PortInst pi = higherExport.getOriginalPort();
                if (pi.getNodeInst().getProto() != this) continue;
                Export lowerExport = (Export)pi.getPortProto();
                assert (lowerExport.getParent() == this);
                if (!killedExports.contains(lowerExport)) continue;
                if (higherExportsToKill == null) {
                    higherExportsToKill = new HashSet<Export>();
                }
                higherExportsToKill.add(higherExport);
            }
            Iterator<NodeInst> it = higherCell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (ni.getProto() != this) continue;
                for (Export e : killedExportsArray) {
                    ni.findPortInstFromProto(e).delVars();
                }
            }
            for (ArcInst ai : arcsToKill) {
                ai.kill();
            }
            if (higherExportsToKill == null) continue;
            higherCell.killExports(higherExportsToKill);
        }
        for (Export e : killedExports) {
            assert (e.isLinked());
            NodeInst originalNode = e.getOriginalPort().getNodeInst();
            originalNode.redoGeometric();
            this.removeExport(e);
            Constraints.getCurrent().killObject(e);
        }
    }

    void recursivelyChangeAllPorts(Set<Export> changedExports) {
        Iterator<CellUsage> cit = this.getUsagesOf();
        while (cit.hasNext()) {
            CellUsage u = cit.next();
            Cell higherCell = this.database.getCell(u.parentId);
            HashSet<Export> changedHigherExports = null;
            for (Export higherExport : higherCell.exports) {
                PortInst pi = higherExport.getOriginalPort();
                if (pi.getNodeInst().getProto() != this) continue;
                Export lowerExport = (Export)pi.getPortProto();
                assert (lowerExport.getParent() == this);
                if (!changedExports.contains(lowerExport)) continue;
                if (changedHigherExports == null) {
                    changedHigherExports = new HashSet<Export>();
                }
                changedHigherExports.add(higherExport);
                higherExport.copyStateBits(lowerExport);
            }
            if (changedHigherExports == null) continue;
            higherCell.recursivelyChangeAllPorts(changedHigherExports);
        }
    }

    @Override
    public PortProto findPortProto(String name) {
        if (name == null) {
            return null;
        }
        return this.findPortProto(Name.findName(name));
    }

    @Override
    public PortProto findPortProto(Name name) {
        if (name == null) {
            return null;
        }
        int portIndex = this.searchExport(name.toString());
        if (portIndex >= 0) {
            return this.exports[portIndex];
        }
        return null;
    }

    @Override
    public Iterator<PortProto> getPorts() {
        return ArrayIterator.iterator((PortProto[])this.exports);
    }

    public Iterator<Export> getExports() {
        return ArrayIterator.iterator(this.exports);
    }

    @Override
    public int getNumPorts() {
        return this.exports.length;
    }

    @Override
    public Export getPort(int portIndex) {
        return this.exports[portIndex];
    }

    @Override
    public Export getPort(PortProtoId portProtoId) {
        if (portProtoId.getParentId() != this.getId()) {
            throw new IllegalArgumentException();
        }
        return this.getExportChron(portProtoId.getChronIndex());
    }

    public Export getExportChron(int chronIndex) {
        return chronIndex < this.chronExports.length ? this.chronExports[chronIndex] : null;
    }

    public Export findExport(String name) {
        return (Export)this.findPortProto(name);
    }

    public Export findExport(Name name) {
        return (Export)this.findPortProto(name);
    }

    private int searchExport(String name) {
        int low = 0;
        int high = this.exports.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Export e = this.exports[mid];
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(e.getName(), name);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public CellName getCellName() {
        return this.getD().cellId.cellName;
    }

    @Override
    public String getName() {
        return this.getCellName().getName();
    }

    @Override
    public String describe(boolean withQuotes) {
        String name = "";
        if (this.lib != Library.getCurrent()) {
            name = name + this.lib.getName() + ":";
        }
        name = name + this.noLibDescribe();
        return withQuotes ? "'" + name + "'" : name;
    }

    @Override
    public String libDescribe() {
        return this.lib.getName() + ":" + this.noLibDescribe();
    }

    @Override
    public String noLibDescribe() {
        String name = this.getName();
        if (this.getNewestVersion() != this) {
            name = name + ";" + this.getVersion();
        }
        name = name + this.getView().getAbbreviationExtension();
        return name;
    }

    public static NodeProto findNodeProto(String line) {
        Comparable<PrimitiveNode> np;
        String withoutPrefix;
        Technology tech = Technology.getCurrent();
        Library lib = Library.getCurrent();
        boolean saidtech = false;
        boolean saidlib = false;
        int colon2 = line.indexOf(58);
        if (colon2 == -1) {
            withoutPrefix = line;
        } else {
            Library l;
            String prefix = line.substring(0, colon2);
            Technology t = Technology.findTechnology(prefix);
            if (t != null) {
                tech = t;
                saidtech = true;
            }
            if ((l = Library.findLibrary(prefix)) != null) {
                lib = l;
                saidlib = true;
            }
            withoutPrefix = line.substring(colon2 + 1);
        }
        if (!saidlib && (np = tech.findNodeProto(withoutPrefix)) != null) {
            return np;
        }
        if (!saidtech && lib != null && (np = lib.findNodeProto(withoutPrefix)) != null) {
            return np;
        }
        return null;
    }

    public String[] getTextViewContents() {
        Variable var = this.getVar(CELL_TEXT_KEY);
        if (var == null) {
            return null;
        }
        Object obj = var.getObject();
        if (!(obj instanceof String[])) {
            return null;
        }
        return (String[])obj;
    }

    public void setTextViewContents(String[] strings, EditingPreferences ep) {
        this.checkChanging();
        this.newVar(CELL_TEXT_KEY, (Object)strings, ep);
    }

    public Variable getParameter(Variable.Key key) {
        return key instanceof Variable.AttrKey ? this.getD().getParameter((Variable.AttrKey)key) : null;
    }

    public Iterator<Variable> getParameters() {
        return this.getD().getParameters();
    }

    public boolean hasParameters() {
        return this.getNumParameters() > 0;
    }

    public int getNumParameters() {
        return this.getD().getNumParameters();
    }

    public Variable getParameter(int paramIndex) {
        return this.getD().getParameter(paramIndex);
    }

    @Override
    public boolean isParam(Variable.Key varKey) {
        return varKey instanceof Variable.AttrKey && this.getD().getParameter((Variable.AttrKey)varKey) != null;
    }

    private void addParam(Variable var) {
        NodeInst ni;
        Iterator<NodeInst> it;
        assert (var.getTextDescriptor().isParam() && var.isInherit());
        if (this.isIcon()) {
            it = this.getInstancesOf();
            while (it.hasNext()) {
                ni = it.next();
                if (ni.isParam(var.getKey())) continue;
                ni.delVar(var.getKey());
            }
        }
        this.setD(this.getD().withoutVariable(var.getKey()).withParam(var));
        if (this.isIcon()) {
            it = this.getInstancesOf();
            while (it.hasNext()) {
                ni = it.next();
                Variable instParam = ni.getParameter(var.getKey());
                if (instParam == null) continue;
                ni.setTextDescriptor(var.getKey(), instParam.getTextDescriptor().withUnit(var.getUnit()));
            }
        }
    }

    private void delParam(Variable.AttrKey key) {
        assert (this.isParam(key));
        if (this.isIcon()) {
            Iterator<NodeInst> it = this.getInstancesOf();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                ni.delParameter(key);
            }
        }
        this.setD(this.getD().withoutParam(key));
    }

    private void renameParam(Variable.AttrKey key, Variable.AttrKey newName) {
        assert (this.isParam(key));
        Variable oldParam = this.getParameter(key);
        this.addParam(Variable.newInstance(newName, oldParam.getObject(), oldParam.getTextDescriptor()));
        if (this.isIcon()) {
            Iterator<NodeInst> it = this.getInstancesOf();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (!ni.isDefinedParameter(key)) continue;
                Variable param2 = ni.getParameter(key);
                ni.addParameter(Variable.newInstance(newName, param2.getObject(), param2.getTextDescriptor()));
                ni.delParameter(key);
            }
        }
        this.delParam(key);
    }

    private void setParams(Cell paramOwner) {
        Iterator<Variable> it = this.getParameters();
        while (it.hasNext()) {
            this.delParam((Variable.AttrKey)it.next().getKey());
        }
        it = paramOwner.getParameters();
        while (it.hasNext()) {
            Variable param2 = it.next();
            this.addParam(param2);
        }
    }

    public Poly[] getAllText(boolean hardToSelect, EditWindow0 wnd) {
        return this.getDisplayableVariables(CENTERRECT, wnd, false, false);
    }

    public Rectangle2D getRelativeTextBounds(EditWindow0 wnd) {
        Rectangle2D bounds = null;
        Iterator<ElectricObject> it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            bounds = this.accumulateTextBoundsOnObject(ni, bounds, wnd);
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                bounds = this.accumulateTextBoundsOnObject(pi, bounds, wnd);
            }
        }
        it = this.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            bounds = this.accumulateTextBoundsOnObject(ai, bounds, wnd);
        }
        it = this.getExports();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            bounds = this.accumulateTextBoundsOnObject(pp, bounds, wnd);
        }
        bounds = this.accumulateTextBoundsOnObject(this, bounds, wnd);
        return bounds;
    }

    private Rectangle2D accumulateTextBoundsOnObject(ElectricObject eObj, Rectangle2D bounds, EditWindow0 wnd) {
        Rectangle2D objBounds = eObj.getTextBounds(wnd);
        if (objBounds == null) {
            return bounds;
        }
        if (bounds == null) {
            return objBounds;
        }
        Rectangle2D.union(bounds, objBounds, bounds);
        return bounds;
    }

    public Name getBasename() {
        return this.getCellName().getBasename();
    }

    public int getUniqueNameIndex(String prefix, String suffix, Class<?> cls, int startingIndex) {
        int uniqueIndex;
        block4: {
            int suffixLen;
            int prefixLen;
            block5: {
                block3: {
                    prefixLen = prefix.length();
                    suffixLen = suffix.length();
                    uniqueIndex = startingIndex;
                    if (cls != Export.class) break block3;
                    Iterator<Export> it = this.getExports();
                    while (it.hasNext()) {
                        int indexVal;
                        String restOfName;
                        Export pp = it.next();
                        String name = pp.getName();
                        if (!name.startsWith(prefix) || !name.endsWith(suffix) || !TextUtils.isANumber(restOfName = name.substring(prefixLen, name.length() - suffixLen)) || (indexVal = TextUtils.atoi(restOfName)) < uniqueIndex) continue;
                        uniqueIndex = indexVal + 1;
                    }
                    break block4;
                }
                if (cls != NodeInst.class) break block5;
                Iterator<NodeInst> it = this.getNodes();
                while (it.hasNext()) {
                    int indexVal;
                    String restOfName;
                    NodeInst ni = it.next();
                    String name = ni.getName();
                    if (!name.startsWith(prefix) || !name.endsWith(suffix) || !TextUtils.isANumber(restOfName = name.substring(prefixLen, name.length() - suffixLen)) || (indexVal = TextUtils.atoi(restOfName)) < uniqueIndex) continue;
                    uniqueIndex = indexVal + 1;
                }
                break block4;
            }
            if (cls != ArcInst.class) break block4;
            Iterator<ArcInst> it = this.getArcs();
            while (it.hasNext()) {
                int indexVal;
                String restOfName;
                ArcInst ai = it.next();
                String name = ai.getName();
                if (!name.startsWith(prefix) || !name.endsWith(suffix) || !TextUtils.isANumber(restOfName = name.substring(prefixLen, name.length() - suffixLen)) || (indexVal = TextUtils.atoi(restOfName)) < uniqueIndex) continue;
                uniqueIndex = indexVal + 1;
            }
        }
        return uniqueIndex;
    }

    public boolean isUniqueName(String name, Class<?> cls, ElectricObject exclude) {
        return this.isUniqueName(Name.findName(name), cls, exclude);
    }

    public boolean isUniqueName(Name name, Class<?> cls, ElectricObject exclude) {
        if (cls == Export.class) {
            Export e = this.findExport(name);
            return e == null || exclude == e;
        }
        if (cls == NodeInst.class) {
            NodeInst ni = this.findNode(name.toString());
            return ni == null || exclude == ni;
        }
        if (cls == ArcInst.class) {
            ArcInst ai = this.findArc(name.toString());
            return ai == null || exclude == ai;
        }
        return true;
    }

    @Override
    public boolean isDeprecatedVariable(Variable.Key key) {
        String name = key.getName();
        if (name.equals("NET_last_good_ncc") || name.equals("NET_last_good_ncc_facet") || name.equals("SIM_window_signal_order") || name.equals("SIM_window_signalorder")) {
            return true;
        }
        return super.isDeprecatedVariable(key);
    }

    public Point2D newVarOffset() {
        int numVars = 0;
        double xPosSum = 0.0;
        double yPosBot = 0.0;
        double tallest = 0.0;
        Iterator<Variable> it = this.getParametersAndVariables();
        while (it.hasNext()) {
            Variable eVar = it.next();
            if (!eVar.isDisplay()) continue;
            xPosSum += eVar.getXOff();
            if (eVar.getYOff() < yPosBot) {
                yPosBot = eVar.getYOff();
            }
            if (!eVar.getSize().isAbsolute()) {
                tallest = Math.max(tallest, eVar.getSize().getSize());
            }
            ++numVars;
        }
        if (numVars == 0) {
            return new Point2D.Double(0.0, 0.0);
        }
        if (tallest == 0.0) {
            tallest = 1.0;
        }
        return new Point2D.Double(xPosSum / (double)numVars, yPosBot - tallest);
    }

    @Override
    public String toString() {
        return "cell " + this.describe(true);
    }

    @Override
    public ImmutableCell getD() {
        return this.d;
    }

    private void setD(ImmutableCell newD) {
        assert (this.isLinked());
        this.checkChanging();
        ImmutableCell oldD = this.getD();
        if (newD == oldD) {
            return;
        }
        this.d = newD;
        this.unfreshBackup();
        Constraints.getCurrent().modifyCell(this, oldD);
    }

    @Override
    public void addVar(Variable var) {
        if (var.getTextDescriptor().isParam() || this.isParam(var.getKey())) {
            throw new IllegalArgumentException("Parameters should be added by CellGroup.addParam");
        }
        this.setD(this.getD().withVariable(var));
    }

    @Override
    public void delVar(Variable.Key key) {
        if (this.isParam(key)) {
            throw new IllegalArgumentException("Parameters should be deleted by CellGroup.delParam");
        }
        this.setD(this.getD().withoutVariable(key));
    }

    @Override
    public Variable getParameterOrVariable(Variable.Key key) {
        Variable param2;
        this.checkExamine();
        if (key instanceof Variable.AttrKey && (param2 = this.getParameter(key)) != null) {
            return param2;
        }
        return this.getVar(key);
    }

    @Override
    public Iterator<Variable> getParametersAndVariables() {
        if (this.getNumParameters() == 0) {
            return this.getVariables();
        }
        ArrayList<Variable> allVars = new ArrayList<Variable>();
        Iterator<Variable> it = this.getParameters();
        while (it.hasNext()) {
            allVars.add(it.next());
        }
        it = this.getVariables();
        while (it.hasNext()) {
            allVars.add(it.next());
        }
        return allVars.iterator();
    }

    @Override
    public void setTextDescriptor(Variable.Key varKey, TextDescriptor td) {
        Variable param2 = this.getParameter(varKey);
        if (param2 != null) {
            td = td.withParam(true).withInherit(true).withUnit(param2.getUnit());
            this.addParam(param2.withTextDescriptor(td));
            return;
        }
        Variable var = this.getVar(varKey);
        if (var != null) {
            this.addVar(var.withTextDescriptor(td.withParam(false)));
        }
    }

    @Override
    public CellId getId() {
        return this.d.cellId;
    }

    public static Cell inCurrentThread(CellId cellId) {
        return EDatabase.currentDatabase().getCell(cellId);
    }

    public Iterator<CellUsage> getUsagesOf() {
        return new Iterator<CellUsage>(){
            int i;
            CellUsage nextU = this.findNext();

            @Override
            public boolean hasNext() {
                return this.nextU != null;
            }

            @Override
            public CellUsage next() {
                if (this.nextU == null) {
                    throw new NoSuchElementException();
                }
                CellUsage u = this.nextU;
                this.nextU = this.findNext();
                return u;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private CellUsage findNext() {
                CellId cellId = Cell.this.getId();
                while (this.i < cellId.numUsagesOf()) {
                    CellUsage u;
                    Cell parent;
                    if ((parent = (u = cellId.getUsageOf(this.i++)).getParent(Cell.this.database)) == null || u.indexInParent >= parent.cellUsages.length || parent.cellUsages[u.indexInParent] <= 0) continue;
                    return u;
                }
                return null;
            }
        };
    }

    public Iterator<NodeInst> getInstancesOf() {
        return new NodeInstsIterator();
    }

    public static boolean isInstantiationRecursive(Cell toInstantiate, Cell parent) {
        if (toInstantiate == parent) {
            return true;
        }
        if (parent.isIcon()) {
            return true;
        }
        if (toInstantiate.isIconOf(parent)) {
            assert (toInstantiate.isIcon());
            assert (parent.isSchematic());
            return false;
        }
        return parent.isAChildOf(toInstantiate);
    }

    public boolean isAChildOf(Cell parent) {
        return this.getIsAChildOf(parent, new HashMap<Cell, Cell>());
    }

    private boolean getIsAChildOf(Cell parent, Map<Cell, Cell> checkedParents) {
        Cell c;
        if (parent.isIcon() && (c = parent.contentsView()) != null && c != parent && this.getIsAChildOf(c, checkedParents)) {
            return true;
        }
        if (checkedParents.get(parent) != null) {
            return false;
        }
        checkedParents.put(parent, parent);
        Cell contentView = this.contentsView();
        if (contentView == null) {
            contentView = this;
        }
        Cell iconView = this.iconView();
        Iterator<NodeInst> it = parent.getNodes();
        while (it.hasNext()) {
            Cell c2;
            NodeInst ni = it.next();
            if (!ni.isCellInstance() || (c2 = (Cell)ni.getProto()).isIconOf(parent)) continue;
            if (c2 == contentView) {
                return true;
            }
            if (c2 == iconView) {
                return true;
            }
            if (!this.getIsAChildOf(c2, checkedParents)) continue;
            return true;
        }
        return false;
    }

    public boolean isInUse(String action, boolean quiet, boolean sameCellGroupAlso) {
        String parents = this.isInUse(sameCellGroupAlso);
        if (parents != null) {
            if (!quiet) {
                Job.getUserInterface().showErrorMessage("Cannot " + action + " " + this + " because it is used in " + parents, action + " failed");
            }
            return true;
        }
        if (this.isSchematic() && this == this.getNewestVersion()) {
            for (Cell cell : this.getCellsInGroup()) {
                if (!cell.isIcon() || (parents = cell.isInUse(false)) == null) continue;
                if (!quiet) {
                    Job.getUserInterface().showErrorMessage("Cannot " + action + " " + this + " because icon " + cell + " is used in " + parents, action + " failed");
                }
                return true;
            }
        }
        return false;
    }

    private String isInUse(boolean sameCellGroupAlso) {
        String parents = null;
        Iterator<CellUsage> it = this.getUsagesOf();
        while (it.hasNext()) {
            CellUsage u = it.next();
            Cell parent = u.getParent(this.database);
            if (!sameCellGroupAlso && parent.getCellGroup() == this.getCellGroup()) continue;
            if (parents == null) {
                parents = parent.describe(true);
                continue;
            }
            parents = parents + ", " + parent.describe(true);
        }
        return parents;
    }

    public Cell makeNewVersion() {
        Cell newVersion = Cell.copyNodeProto(this, this.lib, this.noLibDescribe(), false);
        return newVersion;
    }

    public int getVersion() {
        return this.getCellName().getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumVersions() {
        int count2 = 0;
        String protoName = this.getName();
        View view = this.getView();
        TreeMap<CellName, Cell> treeMap = this.lib.cells;
        synchronized (treeMap) {
            Cell c;
            Iterator<Cell> it = this.getVersionsTail();
            while (it.hasNext() && (c = it.next()).getName().equals(protoName) && c.getView() == view) {
                ++count2;
            }
        }
        return count2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Cell> getVersions() {
        ArrayList<Cell> versions = new ArrayList<Cell>();
        String protoName = this.getName();
        View view = this.getView();
        TreeMap<CellName, Cell> treeMap = this.lib.cells;
        synchronized (treeMap) {
            Cell c;
            Iterator<Cell> it = this.getVersionsTail();
            while (it.hasNext() && (c = it.next()).getName().equals(protoName) && c.getView() == view) {
                versions.add(c);
            }
        }
        return versions.iterator();
    }

    public Cell getNewestVersion() {
        return this.newestVersion;
    }

    private Iterator<Cell> getVersionsTail() {
        return this.lib.getCellsTail(this.newestVersion.getCellName());
    }

    private Iterator<Cell> getViewsTail() {
        CellName cn = CellName.parseName(this.getName());
        return this.lib.getCellsTail(cn);
    }

    public CellGroup getCellGroup() {
        if (!this.isLinked()) {
            throw new IllegalStateException();
        }
        assert (this.cellGroup != null);
        return this.cellGroup;
    }

    public List<Cell> getCellsInGroup() {
        if (!this.isLinked()) {
            throw new IllegalStateException();
        }
        return new ArrayList<Cell>(this.cellGroup.cells);
    }

    public Cell getMainSchematicInGroup() {
        if (!this.isLinked()) {
            throw new IllegalStateException();
        }
        return this.cellGroup.getMainSchematics();
    }

    public void joinGroup(Cell otherCell) {
        this.setCellGroup(otherCell.getCellGroup());
    }

    public void setCellGroup(CellGroup cellGroup) {
        Cell cell;
        if (!this.isLinked()) {
            return;
        }
        if (cellGroup == null) {
            cellGroup = new CellGroup(this.lib);
        }
        this.checkChanging();
        if (cellGroup == this.cellGroup) {
            return;
        }
        this.database.unfreshSnapshot();
        this.lib.setChanged();
        String protoName = this.getName();
        Iterator<Cell> it = this.getViewsTail();
        while (it.hasNext() && (cell = it.next()).getName().equals(protoName)) {
            cell.cellGroup.remove(cell);
            cellGroup.add(cell);
        }
    }

    public View getView() {
        return this.getCellName().getView();
    }

    public IdMapper setView(View newView) {
        return this.rename(CellName.newName(this.getName(), newView, this.getVersion()), null);
    }

    public boolean isIcon() {
        return this.getId().isIcon();
    }

    public boolean isIconOf(Cell cell) {
        return this.isIcon() && this.cellGroup == cell.cellGroup && cell.isSchematic();
    }

    public boolean isSchematic() {
        return this.getId().isSchematic();
    }

    public boolean busNamesAllowed() {
        return this.getD().busNamesAllowed();
    }

    public boolean isLayout() {
        View w = this.getView();
        return w == View.LAYOUT || w == View.LAYOUTCOMP || w == View.LAYOUTSKEL;
    }

    public int getNumMultiPages() {
        if (!this.isMultiPage()) {
            return 1;
        }
        ERectangle bounds = this.getBounds();
        int numPages = (int)(((RectangularShape)bounds).getHeight() / 1000.0) + 1;
        Integer storedCount = this.getVarValue(MULTIPAGE_COUNT_KEY, Integer.class);
        if (storedCount != null && storedCount > numPages) {
            numPages = storedCount;
        }
        return numPages;
    }

    public Cell contentsView() {
        if (!this.isIcon() && this.getView() != View.LAYOUTSKEL) {
            return null;
        }
        List<Cell> cellsInGroup = this.getCellsInGroup();
        for (Cell cellInGroup : cellsInGroup) {
            if (!cellInGroup.isSchematic()) continue;
            return cellInGroup;
        }
        for (Cell cellInGroup : cellsInGroup) {
            if (cellInGroup.getView() != View.LAYOUT) continue;
            return cellInGroup;
        }
        for (Cell cellInGroup : cellsInGroup) {
            if (cellInGroup.getView() != View.UNKNOWN) continue;
            return cellInGroup;
        }
        return null;
    }

    public Cell iconView() {
        if (!this.isSchematic()) {
            return null;
        }
        for (Cell cellInGroup : this.getCellsInGroup()) {
            if (!cellInGroup.isIcon()) continue;
            return cellInGroup;
        }
        return null;
    }

    public Cell otherView(View view) {
        Cell otherViewCell = null;
        for (Cell cellInGroup : this.getCellsInGroup()) {
            if (cellInGroup.getView() != view) continue;
            otherViewCell = cellInGroup.getNewestVersion();
            if (!cellInGroup.getName().equals(this.getName())) continue;
            return otherViewCell;
        }
        return otherViewCell;
    }

    public Netlist getNetlist() {
        return this.getNetlist(Netlist.ShortResistors.NO);
    }

    public Netlist getNetlist(Netlist.ShortResistors shortResistors) {
        NetCell netCell = this.netCellRef.get();
        if (netCell == null) {
            netCell = NetCell.newInstance(this);
            this.setNetCellRef(netCell);
        }
        return netCell.getNetlist(shortResistors);
    }

    private void setNetCellRef(NetCell netCell) {
        this.netCellRef = new SoftReference<NetCell>(netCell);
    }

    public Date getCreationDate() {
        return new Date(this.getD().creationDate);
    }

    public void lowLevelSetCreationDate(Date creationDate) {
        this.setD(this.getD().withCreationDate(creationDate.getTime()));
    }

    public Date getRevisionDate() {
        return new Date(this.getD().revisionDate);
    }

    public void lowLevelSetRevisionDate(Date revisionDate) {
        this.lowLevelSetRevisionDate(revisionDate.getTime());
    }

    public void lowLevelMadeRevision(long revisionDate, String userName, CellRevision oldRevision) {
        this.backup();
        if (!this.isModified() || this.backup.cellRevision == oldRevision || this.revisionDateFresh) {
            return;
        }
        this.lowLevelSetRevisionDate(revisionDate);
    }

    private void lowLevelSetRevisionDate(long revisionDate) {
        this.backup = this.backup().withRevisionDate(revisionDate);
        this.d = this.backup.cellRevision.d;
        this.revisionDateFresh = true;
        this.unfreshCellTree();
        this.database.unfreshSnapshot();
    }

    public void checkCellDates() {
        HashSet<Cell> cellsChecked = new HashSet<Cell>();
        this.checkCellDate(this.getRevisionDate(), cellsChecked);
    }

    private void checkCellDate(Date rev_time, Set<Cell> cellsChecked) {
        Iterator<NodeInst> it = this.getNodes();
        while (it.hasNext()) {
            Cell contentsCell;
            Cell subCell;
            NodeInst ni = it.next();
            if (!ni.isCellInstance() || (subCell = (Cell)ni.getProto()).isIconOf(this)) continue;
            if (!cellsChecked.contains(subCell)) {
                subCell.checkCellDate(rev_time, cellsChecked);
            }
            if ((contentsCell = subCell.contentsView()) == null || cellsChecked.contains(contentsCell)) continue;
            contentsCell.checkCellDate(rev_time, cellsChecked);
        }
        cellsChecked.add(this);
        if (!this.getRevisionDate().after(rev_time)) {
            return;
        }
        System.out.println("WARNING: sub-cell " + this + " has been edited since the last revision to the current cell");
    }

    private int getFlags() {
        return this.d.flags;
    }

    private boolean isFlag(int mask) {
        return (this.getFlags() & mask) != 0;
    }

    private void setFlag(int mask, boolean value2) {
        this.lowLevelSetUserbits(value2 ? this.getFlags() | mask : this.getFlags() & ~mask);
    }

    public void setWantExpanded() {
        this.setFlag(2, true);
    }

    public void clearWantExpanded() {
        this.setFlag(2, false);
    }

    public boolean isWantExpanded() {
        return this.isFlag(2) || this.isIcon();
    }

    @Override
    public PrimitiveNode.Function getFunction() {
        return PrimitiveNode.Function.UNKNOWN;
    }

    public void setAllLocked() {
        this.setFlag(0x100000, true);
    }

    public void clearAllLocked() {
        this.setFlag(0x100000, false);
    }

    public boolean isAllLocked() {
        return this.isFlag(0x100000);
    }

    public void setInstancesLocked() {
        this.setFlag(0x200000, true);
    }

    public void clearInstancesLocked() {
        this.setFlag(0x200000, false);
    }

    public boolean isInstancesLocked() {
        return this.isFlag(0x200000);
    }

    public void setInCellLibrary() {
        this.setFlag(0x400000, true);
    }

    public void setInTechnologyLibrary() {
        this.setFlag(0x800000, true);
    }

    public void clearInTechnologyLibrary() {
        this.setFlag(0x800000, false);
    }

    public boolean isInTechnologyLibrary() {
        return this.isFlag(0x800000);
    }

    void clearModified() {
        if (this.isModified()) {
            this.backup = this.backup().withoutModified();
            this.unfreshCellTree();
            this.database.unfreshSnapshot();
        }
        assert (this.cellBackupFresh);
        this.revisionDateFresh = true;
    }

    public boolean isModified() {
        return !this.cellBackupFresh || this.backup.modified;
    }

    public void setTopologyModified() {
        this.strongTopology = this.getTopology();
        this.setContentsModified();
    }

    public void setContentsModified() {
        this.cellContentsFresh = false;
        this.unfreshBackup();
    }

    private void unfreshCellTree() {
        Iterator<Object> it;
        if (!this.cellTreeFresh) {
            return;
        }
        this.unfreshRTree();
        Topology topology = this.getTopologyOptional();
        if (topology != null) {
            it = topology.getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                if (!ni.isCellInstance()) continue;
                ni.redoGeometric();
            }
        }
        this.cellTreeFresh = false;
        it = this.getUsagesOf();
        while (it.hasNext()) {
            CellUsage cu = (CellUsage)it.next();
            Cell cell = this.database.getCell(cu.parentId);
            cell.unfreshCellTree();
        }
    }

    private void unfreshBackup() {
        this.cellBackupFresh = false;
        this.revisionDateFresh = false;
        this.unfreshCellTree();
        this.database.unfreshSnapshot();
    }

    public void unfreshRTree() {
        Topology topology = this.getTopologyOptional();
        if (topology != null) {
            topology.unfreshRTree();
        }
    }

    public void loadExpandStatus() {
        String cellName = this.noLibDescribe().replace('/', ':');
        String cellKey = "E" + cellName;
        boolean useWantExpanded = false;
        boolean mostExpanded = false;
        Preferences libPrefs = Pref.getLibraryPreferences(this.getId().libId);
        if (libPrefs.get(cellKey, null) == null) {
            useWantExpanded = true;
        } else {
            mostExpanded = libPrefs.getBoolean(cellKey, false);
        }
        Preferences cellPrefs = null;
        try {
            if (libPrefs.nodeExists(cellName)) {
                cellPrefs = libPrefs.node(cellName);
            }
        }
        catch (BackingStoreException e) {
            ActivityLogger.logException(e);
        }
        Iterator<NodeInst> it = this.getNodes();
        while (it.hasNext()) {
            boolean expanded;
            NodeInst ni = it.next();
            if (!ni.isCellInstance()) continue;
            boolean bl = expanded = useWantExpanded ? ((Cell)ni.getProto()).isWantExpanded() : mostExpanded;
            if (cellPrefs != null) {
                String nodeName = "E" + ni.getName();
                expanded = cellPrefs.getBoolean(nodeName, expanded);
            }
            this.setExpanded(ni.getNodeId(), expanded);
        }
        this.expandStatusModified = false;
    }

    void saveExpandStatus() throws BackingStoreException {
        if (!this.expandStatusModified) {
            return;
        }
        if (Job.getDebug()) {
            System.err.println("Save expanded status of " + this);
        }
        int num = 0;
        int expanded = 0;
        int diff2 = 0;
        Iterator<NodeInst> it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (!ni.isCellInstance()) continue;
            ++num;
            boolean isExpanded = this.isExpanded(ni.getNodeId());
            if (isExpanded) {
                ++expanded;
            }
            if (isExpanded == ((Cell)ni.getProto()).isWantExpanded()) continue;
            ++diff2;
        }
        String cellName = this.noLibDescribe().replace('/', ':');
        String cellKey = "E" + cellName;
        boolean useWantExpanded = false;
        boolean mostExpanded = false;
        Preferences libPrefs = Pref.getLibraryPreferences(this.getId().libId);
        if (diff2 <= expanded && diff2 <= num - expanded) {
            useWantExpanded = true;
            libPrefs.remove(cellKey);
        } else {
            if (num - expanded < expanded) {
                diff2 = num - expanded;
                mostExpanded = true;
            } else {
                diff2 = expanded;
            }
            libPrefs.putBoolean(cellKey, mostExpanded);
        }
        if (diff2 == 0) {
            if (libPrefs.nodeExists(cellName)) {
                libPrefs.node(cellName).removeNode();
            }
        } else {
            Preferences cellPrefs = libPrefs.node(cellName);
            cellPrefs.clear();
            cellPrefs.put("CELL", cellName);
            Iterator<NodeInst> it2 = this.getNodes();
            while (it2.hasNext()) {
                boolean defaultExpanded;
                NodeInst ni = it2.next();
                if (!ni.isCellInstance()) continue;
                boolean bl = defaultExpanded = useWantExpanded ? ((Cell)ni.getProto()).isWantExpanded() : mostExpanded;
                boolean isExpanded = this.isExpanded(ni.getNodeId());
                if (isExpanded == defaultExpanded) continue;
                String nodeName = "E" + ni.getName();
                cellPrefs.putBoolean(nodeName, isExpanded);
            }
        }
        this.expandStatusModified = false;
    }

    public void setMultiPage(boolean multi) {
        this.setFlag(0x7E000000, multi);
    }

    public boolean isMultiPage() {
        return this.isFlag(0x7E000000);
    }

    @Override
    public boolean isLinked() {
        this.database.checkExamine();
        return this.database.getCell(this.getId()) == this;
    }

    @Override
    public EDatabase getDatabase() {
        return this.database;
    }

    public int checkAndRepair(boolean repair, ErrorLogger errorLogger, EditingPreferences ep) {
        int errorCount = 0;
        ArrayList<Geometric> list2 = new ArrayList<Geometric>();
        Iterator<ElectricObject> it = this.getArcs();
        while (it.hasNext()) {
            ArcInst ai = it.next();
            errorCount += ai.checkAndRepair(repair, list2, errorLogger);
            this.checkName(ai.getNameKey(), ai, errorLogger);
        }
        it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            errorCount += ni.checkAndRepair(repair, list2, errorLogger);
            this.checkName(ni.getNameKey(), ni, errorLogger);
        }
        it = this.getExports();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            this.checkName(e, errorLogger);
        }
        if (repair && list2.size() > 0) {
            CircuitChangeJobs.eraseObjectsInList(this, list2, false, null, ep);
        }
        if (this.isSchematic() && this.getNewestVersion() == this && this.getMainSchematicInGroup() != this) {
            String mainSchemMsg = "Extraneous schematic cell " + this.describe(false);
            mainSchemMsg = mainSchemMsg + " in cell group " + this.lib.getName() + ":" + this.getCellGroup().getName();
            System.out.println(mainSchemMsg);
            if (errorLogger != null) {
                errorLogger.logWarning(mainSchemMsg, this, 1);
            }
        }
        for (Cell cell : this.cellGroup.cells) {
            Variable var = cell.getParameterOrVariable(NccCellAnnotations.NCC_ANNOTATION_KEY);
            if (var == null || !var.isInherit()) continue;
            String nccMsg = "Cleaned up NCC annotations in cell " + cell.describe(false);
            if (repair) {
                if (this.isParam(var.getKey())) {
                    this.getCellGroup().delParam((Variable.AttrKey)var.getKey());
                }
                cell.addVar(var.withInherit(false).withParam(false).withInterior(true));
                nccMsg = nccMsg + " (REPAIRED)";
            }
            System.out.println(nccMsg);
            if (errorLogger == null) continue;
            errorLogger.logWarning(nccMsg, cell, 1);
        }
        return errorCount;
    }

    private void checkName(Name name, Geometric geom, ErrorLogger errorLogger) {
        if (name.isTempname()) {
            return;
        }
        String s = name.toString();
        if (s.indexOf(60) >= 0 && s.indexOf(62) >= 0) {
            String msg = "Name " + s + " contains angle brackets. They are not considered as array chars";
            System.out.println(msg);
            if (errorLogger != null) {
                errorLogger.logWarning(msg, geom, this, null, 1);
            }
        }
    }

    private void checkName(Export e, ErrorLogger errorLogger) {
        String s = e.getName();
        if (s.indexOf(60) >= 0 && s.indexOf(62) >= 0) {
            String msg = "Name " + s + " contains angle brackets. They are not considered as array chars";
            System.out.println(msg);
            if (errorLogger != null) {
                errorLogger.logWarning(msg, e, this, null, 1);
            }
        }
    }

    @Override
    protected void check() {
        CellRevision cellRevision;
        boolean originalCellContentsFresh = this.cellContentsFresh;
        CellId cellId = this.getD().cellId;
        super.check();
        assert (this.database.getCell(cellId) == this);
        assert (this.database.getLib(this.getD().getLibId()) == this.lib);
        if (this.getD().techId != null ? !$assertionsDisabled && this.tech != this.database.getTech(this.getD().techId) : !$assertionsDisabled && this.tech != null) {
            throw new AssertionError();
        }
        assert (this.getCellName() != null);
        assert (this.getVersion() > 0);
        if (this.cellTreeFresh) {
            assert (this.cellBackupFresh);
            assert (this.backup == this.tree.top);
            for (CellTree subCellTree : this.tree.getSubTrees()) {
                if (subCellTree == null) continue;
                Cell subCell = this.database.getCell(subCellTree.top.cellRevision.d.cellId);
                assert (subCell.cellTreeFresh);
                assert (subCell.tree == subCellTree);
            }
        }
        CellRevision cellRevision2 = cellRevision = this.backup != null ? this.backup.cellRevision : null;
        if (this.cellBackupFresh) {
            assert (cellRevision.d == this.getD());
            assert (this.cellContentsFresh);
        }
        if (this.cellContentsFresh) {
            assert (cellRevision.exports.size() == this.exports.length);
            assert (this.strongTopology == null);
        }
        for (int portIndex = 0; portIndex < this.exports.length; ++portIndex) {
            Export e = this.exports[portIndex];
            assert (e.getParent() == this);
            assert (e.getPortIndex() == portIndex);
            assert (this.chronExports[e.getId().getChronIndex()] == e);
            if (this.cellContentsFresh) assert (cellRevision.exports.get(portIndex) == e.getD());
            if (portIndex > 0) assert (TextUtils.STRING_NUMBER_ORDER.compare(this.exports[portIndex - 1].getName(), e.getName()) < 0);
            assert (e.getOriginalPort() == this.getPortInst(e.getD().originalNodeId, e.getD().originalPortId));
        }
        for (int chronIndex = 0; chronIndex < this.chronExports.length; ++chronIndex) {
            Export e = this.chronExports[chronIndex];
            if (e == null) continue;
            assert (e.getId() == cellId.getPortId(chronIndex));
            assert (e == this.exports[e.getPortIndex()]);
        }
        assert (this.cellContentsFresh == originalCellContentsFresh);
        Topology topology = this.getTopologyOptional();
        assert (this.cellContentsFresh == originalCellContentsFresh);
        if (topology != null) {
            topology.check(this.cellUsages);
            CellRevision cellRevision3 = cellRevision = this.backup != null ? this.backup.cellRevision : null;
            if (this.cellContentsFresh) {
                assert (cellRevision.arcs.size() == topology.getNumArcs());
                for (int arcIndex = 0; arcIndex < topology.getNumArcs(); ++arcIndex) {
                    ArcInst ai = topology.getArc(arcIndex);
                    ImmutableArcInst a = ai.getD();
                    assert (cellRevision.arcs.get(arcIndex) == a);
                }
                assert (cellRevision.nodes.size() == topology.getNumNodes());
                for (int nodeIndex = 0; nodeIndex < topology.getNumNodes(); ++nodeIndex) {
                    NodeInst ni = topology.getNode(nodeIndex);
                    ImmutableNodeInst n = ni.getD();
                    assert (cellRevision.nodes.get(nodeIndex) == n);
                }
            }
        }
        assert (this.cellGroup.containsCell(this));
    }

    public boolean objInCell(ElectricObject eObj) {
        block4: {
            block5: {
                block3: {
                    if (!(eObj instanceof NodeInst)) break block3;
                    Iterator<NodeInst> it = this.getNodes();
                    while (it.hasNext()) {
                        if (it.next() != eObj) continue;
                        return true;
                    }
                    break block4;
                }
                if (!(eObj instanceof ArcInst)) break block5;
                Iterator<ArcInst> it = this.getArcs();
                while (it.hasNext()) {
                    if (it.next() != eObj) continue;
                    return true;
                }
                break block4;
            }
            if (!(eObj instanceof PortInst)) break block4;
            NodeInst ni = ((PortInst)eObj).getNodeInst();
            Iterator<NodeInst> it = this.getNodes();
            while (it.hasNext()) {
                if (it.next() != ni) continue;
                return true;
            }
        }
        return false;
    }

    public final int getCellIndex() {
        return this.getId().cellIndex;
    }

    public void setTempInt(int tempInt) {
        this.checkChanging();
        this.tempInt = tempInt;
    }

    public int getTempInt() {
        return this.tempInt;
    }

    @Override
    public Cell whichCell() {
        return this;
    }

    public Library getLibrary() {
        return this.lib;
    }

    @Override
    public Technology getTechnology() {
        if (this.tech == null) {
            NodeProto[] nodeProtos = null;
            ArcProto[] arcProtos = null;
            if (this.backup == null && this.getTopologyOptional() == null) {
                nodeProtos = new NodeProto[]{};
                arcProtos = new ArcProto[]{};
            }
            this.setTechnology(Technology.whatTechnology(this, nodeProtos, 0, 0, arcProtos));
        }
        return this.tech;
    }

    public void setTechnology(Technology tech) {
        TechId techId = null;
        if (tech != null && this.database.getTech(techId = tech.getId()) != tech) {
            throw new IllegalArgumentException("tech");
        }
        this.setD(this.getD().withTechId(techId));
        this.tech = tech;
    }

    public Cell getEquivalent() {
        return this.isIcon() ? this.getMainSchematicInGroup() : this;
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        Iterator<Serializable> i;
        boolean found;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cell toCompare = (Cell)obj;
        HashSet<Serializable> noCheckAgain = new HashSet<Serializable>();
        Iterator<Serializable> it = this.getNodes();
        while (it.hasNext()) {
            found = false;
            NodeInst node = it.next();
            i = toCompare.getNodes();
            while (i.hasNext()) {
                NodeInst n = i.next();
                if (noCheckAgain.contains(n) || !node.compare(n, buffer)) continue;
                found = true;
                noCheckAgain.add(n);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding node '").append(node).append("' found in '").append(toCompare).append("'\n");
            }
            return false;
        }
        if (this.getNumNodes() != toCompare.getNumNodes()) {
            if (buffer != null) {
                buffer.append("Cell '").append(toCompare.libDescribe()).append("' has more nodes than '").append(this).append("'\n");
            }
            return false;
        }
        it = this.getArcs();
        while (it.hasNext()) {
            found = false;
            ArcInst arc = (ArcInst)it.next();
            i = toCompare.getArcs();
            while (i.hasNext()) {
                ArcInst a = (ArcInst)i.next();
                if (noCheckAgain.contains(a) || !arc.compare(a, buffer)) continue;
                found = true;
                noCheckAgain.add(a);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding arc '").append(arc).append("' found in other cell\n");
            }
            return false;
        }
        if (this.getNumArcs() != toCompare.getNumArcs()) {
            if (buffer != null) {
                buffer.append("Cell '").append(toCompare.libDescribe()).append("' has more arcs than '").append(this).append("'\n");
            }
            return false;
        }
        noCheckAgain.clear();
        it = this.getExports();
        while (it.hasNext()) {
            found = false;
            Export port = (Export)it.next();
            i = toCompare.getExports();
            while (i.hasNext()) {
                Export p = (Export)i.next();
                if (noCheckAgain.contains(p) || !port.compare(p, buffer)) continue;
                found = true;
                noCheckAgain.add(p);
                break;
            }
            if (found) continue;
            return false;
        }
        if (this.getNumPorts() != toCompare.getNumPorts()) {
            if (buffer != null) {
                buffer.append("Cell '").append(toCompare.libDescribe()).append("' has more pors than '").append(this).append("'\n");
            }
            return false;
        }
        if (this.getNumParameters() != toCompare.getNumParameters()) {
            if (buffer != null) {
                buffer.append("Cell '").append(toCompare).append("' has more parameters than '").append(this).append("'\n");
            }
            return false;
        }
        Iterator<Variable> it1 = this.getParameters();
        Iterator<Variable> it2 = toCompare.getParameters();
        while (it1.hasNext()) {
            Variable param2;
            Variable param1 = it1.next();
            if (param1.compare(param2 = it2.next(), buffer)) continue;
            if (buffer != null) {
                buffer.append("No corresponding parameter '").append(param1).append("' found in other cell\n");
            }
            return false;
        }
        noCheckAgain.clear();
        it = this.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            boolean found2 = false;
            i = toCompare.getVariables();
            while (i.hasNext()) {
                Variable v = (Variable)i.next();
                if (noCheckAgain.contains(v) || !var.compare(v, buffer)) continue;
                found2 = true;
                noCheckAgain.add(v);
                break;
            }
            if (found2) continue;
            if (buffer != null) {
                buffer.append("No corresponding variable '").append(var).append("' found in other cell\n");
            }
            return false;
        }
        if (this.getNumVariables() != toCompare.getNumVariables()) {
            if (buffer != null) {
                buffer.append("Cell '").append(toCompare).append("' has more variables than '").append(this).append("'\n");
            }
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Cell that) {
        int cmp;
        if (this.lib != that.lib && (cmp = this.lib.compareTo(that.lib)) != 0) {
            return cmp;
        }
        return this.getCellName().compareTo(that.getCellName());
    }

    public boolean getZValues(double[] array) {
        boolean foundValue = false;
        Iterator<Geometric> it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.isCellInstance()) {
                Cell nCell = (Cell)ni.getProto();
                if (!nCell.getZValues(array)) continue;
                foundValue = true;
                continue;
            }
            PrimitiveNode np = (PrimitiveNode)ni.getProto();
            if (!np.getZValues(array)) continue;
            foundValue = true;
        }
        it = this.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            ArcProto ap = ai.getProto();
            if (!ap.getZValues(array)) continue;
            foundValue = true;
        }
        return foundValue;
    }

    public boolean findReferenceInCell(Library elib, Set<Cell> set) {
        if (this.lib == elib) {
            return true;
        }
        int initial = set.size();
        Iterator<CellUsage> it = this.getUsagesIn();
        while (it.hasNext()) {
            CellUsage cu = it.next();
            Cell nCell = cu.getProto(this.database);
            if (nCell.getLibrary() == elib) {
                set.add(this);
                continue;
            }
            nCell.findReferenceInCell(elib, set);
        }
        return set.size() != initial;
    }

    private class NodeInstsIterator
    implements Iterator<NodeInst> {
        private Iterator<CellUsage> uit;
        private Cell cell;
        private int i;
        private int n;
        private NodeInst ni;

        NodeInstsIterator() {
            this.uit = Cell.this.getUsagesOf();
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.ni != null;
        }

        @Override
        public NodeInst next() {
            NodeInst ni = this.ni;
            if (ni == null) {
                throw new NoSuchElementException();
            }
            this.findNext();
            return ni;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("NodeInstsIterator.remove()");
        }

        private void findNext() {
            while (true) {
                if (this.i < this.n) {
                    this.ni = this.cell.getNode(this.i++);
                    if (this.ni.getProto() != Cell.this) continue;
                    return;
                }
                if (!this.uit.hasNext()) {
                    this.ni = null;
                    return;
                }
                CellUsage u = this.uit.next();
                this.cell = u.getParent(Cell.this.database);
                if (this.cell == null) continue;
                this.i = 0;
                this.n = this.cell.getNumNodes();
            }
        }
    }

    public static class FrameDescription {
        public static final double MULTIPAGESEPARATION = 1000.0;
        private static final double FRAMESCALE = 18.0;
        private static final double HASCHXSIZE = 153.0;
        private static final double HASCHYSIZE = 99.0;
        private static final double ASCHXSIZE = 198.0;
        private static final double ASCHYSIZE = 153.0;
        private static final double BSCHXSIZE = 306.0;
        private static final double BSCHYSIZE = 198.0;
        private static final double CSCHXSIZE = 432.0;
        private static final double CSCHYSIZE = 306.0;
        private static final double DSCHXSIZE = 648.0;
        private static final double DSCHYSIZE = 432.0;
        private static final double ESCHXSIZE = 864.0;
        private static final double ESCHYSIZE = 648.0;
        private static final double FRAMEWID = 2.6999999999999997;
        private static final double XLOGOBOX = 36.0;
        private static final double YLOGOBOX = 18.0;
        private Cell cell;
        private List<Point2D> lineFromEnd;
        private List<Point2D> lineToEnd;
        private List<Point2D> textPoint;
        private List<Double> textSize;
        private List<Point2D> textBox;
        private List<String> textMessage;
        private int pageNo;

        public FrameDescription(Cell cell, int pageNo) {
            this.cell = cell;
            this.pageNo = pageNo;
            this.lineFromEnd = new ArrayList<Point2D>();
            this.lineToEnd = new ArrayList<Point2D>();
            this.textPoint = new ArrayList<Point2D>();
            this.textSize = new ArrayList<Double>();
            this.textBox = new ArrayList<Point2D>();
            this.textMessage = new ArrayList<String>();
            this.loadFrame();
        }

        public void showFrameLine(Point2D from2, Point2D to2) {
        }

        public void showFrameText(Point2D ctr, double size2, double maxWid, double maxHei, String string2) {
        }

        public void renderFrame() {
            int i;
            double offY = 0.0;
            if (this.cell.isMultiPage()) {
                offY = (double)this.pageNo * 1000.0;
            }
            for (i = 0; i < this.lineFromEnd.size(); ++i) {
                Point2D from2 = this.lineFromEnd.get(i);
                Point2D to2 = this.lineToEnd.get(i);
                if (offY != 0.0) {
                    from2 = new Point2D.Double(from2.getX(), from2.getY() + offY);
                    to2 = new Point2D.Double(to2.getX(), to2.getY() + offY);
                }
                this.showFrameLine(from2, to2);
            }
            for (i = 0; i < this.textPoint.size(); ++i) {
                Point2D at = this.textPoint.get(i);
                if (offY != 0.0) {
                    at = new Point2D.Double(at.getX(), at.getY() + offY);
                }
                double size2 = this.textSize.get(i);
                Point2D box = this.textBox.get(i);
                double width = box.getX();
                double height = box.getY();
                String msg = this.textMessage.get(i);
                this.showFrameText(at, size2, width, height, msg);
            }
        }

        public static int getCellFrameInfo(Cell cell, Dimension d) {
            String frameInfo = cell.getVarValue(User.FRAME_SIZE, String.class);
            if (frameInfo == null) {
                return 2;
            }
            if (frameInfo.length() == 0) {
                return 2;
            }
            int retval = 0;
            char chr = frameInfo.charAt(0);
            double wid = 0.0;
            double hei = 0.0;
            if (chr == 'x') {
                wid = 38.7;
                hei = 20.7;
                retval = 1;
            } else {
                switch (chr) {
                    case 'h': {
                        wid = 153.0;
                        hei = 99.0;
                        break;
                    }
                    case 'a': {
                        wid = 198.0;
                        hei = 153.0;
                        break;
                    }
                    case 'b': {
                        wid = 306.0;
                        hei = 198.0;
                        break;
                    }
                    case 'c': {
                        wid = 432.0;
                        hei = 306.0;
                        break;
                    }
                    case 'd': {
                        wid = 648.0;
                        hei = 432.0;
                        break;
                    }
                    case 'e': {
                        wid = 864.0;
                        hei = 648.0;
                    }
                }
            }
            if (frameInfo.indexOf("v") >= 0) {
                d.setSize(hei, wid);
            } else {
                d.setSize(wid, hei);
            }
            return retval;
        }

        private void loadFrame() {
            Dimension d = new Dimension();
            int frameFactor = FrameDescription.getCellFrameInfo(this.cell, d);
            if (frameFactor == 2) {
                return;
            }
            String frameInfo = this.cell.getVarValue(User.FRAME_SIZE, String.class);
            if (frameInfo == null) {
                return;
            }
            double schXSize = d.getWidth();
            double schYSize = d.getHeight();
            boolean drawTitleBox = true;
            int xSections = 8;
            int ySections = 4;
            if (frameFactor == 1) {
                ySections = 0;
                xSections = 0;
            } else {
                if (frameInfo.indexOf("v") >= 0) {
                    xSections = 4;
                    ySections = 8;
                }
                if (frameInfo.indexOf("n") >= 0) {
                    drawTitleBox = false;
                }
            }
            double xLogoBox = 36.0;
            double yLogoBox = 18.0;
            double frameWid = 2.6999999999999997;
            if (xSections > 0) {
                char chr;
                int i;
                double xSecSize = (schXSize - frameWid * 2.0) / (double)xSections;
                double ySecSize = (schYSize - frameWid * 2.0) / (double)ySections;
                Point2D.Double point0 = new Point2D.Double(-schXSize / 2.0, -schYSize / 2.0);
                Point2D.Double point1 = new Point2D.Double(-schXSize / 2.0, schYSize / 2.0);
                Point2D.Double point2 = new Point2D.Double(schXSize / 2.0, schYSize / 2.0);
                Point2D.Double point3 = new Point2D.Double(schXSize / 2.0, -schYSize / 2.0);
                this.addLine(point0, point1);
                this.addLine(point1, point2);
                this.addLine(point2, point3);
                this.addLine(point3, point0);
                point0 = new Point2D.Double(-schXSize / 2.0 + frameWid, -schYSize / 2.0 + frameWid);
                point1 = new Point2D.Double(-schXSize / 2.0 + frameWid, schYSize / 2.0 - frameWid);
                point2 = new Point2D.Double(schXSize / 2.0 - frameWid, schYSize / 2.0 - frameWid);
                point3 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid);
                this.addLine(point0, point1);
                this.addLine(point1, point2);
                this.addLine(point2, point3);
                this.addLine(point3, point0);
                for (i = 0; i < xSections; ++i) {
                    double x2 = (double)i * xSecSize - (schXSize / 2.0 - frameWid);
                    if (i > 0) {
                        point0 = new Point2D.Double(x2, schYSize / 2.0 - frameWid);
                        point1 = new Point2D.Double(x2, schYSize / 2.0 - frameWid / 2.0);
                        this.addLine(point0, point1);
                        point0 = new Point2D.Double(x2, -schYSize / 2.0 + frameWid);
                        point1 = new Point2D.Double(x2, -schYSize / 2.0 + frameWid / 2.0);
                        this.addLine(point0, point1);
                    }
                    chr = (char)(49 + xSections - i - 1);
                    point0 = new Point2D.Double(x2 + xSecSize / 2.0, schYSize / 2.0 - frameWid / 2.0);
                    this.addText(point0, frameWid, 0.0, 0.0, String.valueOf(chr));
                    point0 = new Point2D.Double(x2 + xSecSize / 2.0, -schYSize / 2.0 + frameWid / 2.0);
                    this.addText(point0, frameWid, 0.0, 0.0, String.valueOf(chr));
                }
                for (i = 0; i < ySections; ++i) {
                    double y = (double)i * ySecSize - (schYSize / 2.0 - frameWid);
                    if (i > 0) {
                        point0 = new Point2D.Double(schXSize / 2.0 - frameWid, y);
                        point1 = new Point2D.Double(schXSize / 2.0 - frameWid / 2.0, y);
                        this.addLine(point0, point1);
                        point0 = new Point2D.Double(-schXSize / 2.0 + frameWid, y);
                        point1 = new Point2D.Double(-schXSize / 2.0 + frameWid / 2.0, y);
                        this.addLine(point0, point1);
                    }
                    chr = (char)(65 + i);
                    point0 = new Point2D.Double(schXSize / 2.0 - frameWid / 2.0, y + ySecSize / 2.0);
                    this.addText(point0, frameWid, 0.0, 0.0, String.valueOf(chr));
                    point0 = new Point2D.Double(-schXSize / 2.0 + frameWid / 2.0, y + ySecSize / 2.0);
                    this.addText(point0, frameWid, 0.0, 0.0, String.valueOf(chr));
                }
            }
            if (drawTitleBox) {
                String companyName;
                String lastChangeByName;
                String designerName;
                Point2D.Double point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox);
                Point2D.Double point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox);
                Point2D.Double point2 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid);
                Point2D.Double point3 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid);
                this.addLine(point0, point1);
                this.addLine(point1, point2);
                this.addLine(point2, point3);
                this.addLine(point3, point0);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 2.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 2.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 4.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 4.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 6.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 6.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 8.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 8.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 10.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 10.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 12.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 12.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 13.5 / 15.0);
                this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 3.0 / 15.0, "Cell: " + this.cell.describe(false) + (this.cell.isMultiPage() ? " Page " + (this.pageNo + 1) : ""));
                String projectName = this.cell.getLibrary().getVarValue(User.FRAME_PROJECT_NAME, String.class, User.getFrameProjectName());
                if (projectName.length() > 0) {
                    point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 11.0 / 15.0);
                    this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 2.0 / 15.0, "Project: " + projectName);
                }
                if ((designerName = this.cell.getVarValue(User.FRAME_DESIGNER_NAME, String.class)) == null) {
                    designerName = this.cell.getLibrary().getVarValue(User.FRAME_DESIGNER_NAME, String.class, User.getFrameDesignerName());
                }
                if (designerName.length() > 0) {
                    point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 9.0 / 15.0);
                    this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 2.0 / 15.0, "Designer: " + designerName);
                }
                if ((lastChangeByName = this.cell.getVarValue(User.FRAME_LAST_CHANGED_BY, String.class)) != null) {
                    point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 7.0 / 15.0);
                    this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 2.0 / 15.0, "Last Changed By: " + lastChangeByName);
                }
                if ((companyName = this.cell.getLibrary().getVarValue(User.FRAME_COMPANY_NAME, String.class, User.getFrameCompanyName())).length() > 0) {
                    point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 5.0 / 15.0);
                    this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 2.0 / 15.0, "Company: " + companyName);
                }
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 3.0 / 15.0);
                this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 2.0 / 15.0, "Created: " + TextUtils.formatDate(this.cell.getCreationDate()));
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 1.0 / 15.0);
                this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 2.0 / 15.0, "Revised: " + TextUtils.formatDate(this.cell.getRevisionDate()));
            }
        }

        private void addLine(Point2D from2, Point2D to2) {
            this.lineFromEnd.add(from2);
            this.lineToEnd.add(to2);
        }

        private void addText(Point2D at, double size2, double width, double height, String msg) {
            this.textPoint.add(at);
            this.textSize.add(new Double(size2));
            this.textBox.add(new Point2D.Double(width, height));
            this.textMessage.add(msg);
        }
    }

    private static class CellKey
    extends EObjectInputStream.Key<Cell> {
        public CellKey() {
        }

        private CellKey(Cell cell) {
            super(cell);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, Cell cell) throws IOException {
            CellId cellId = cell.getId();
            if (cell.getDatabase() != out.getDatabase() || !cell.isLinked()) {
                throw new NotSerializableException(cell + " not linked");
            }
            out.writeObject(cellId);
        }

        @Override
        public Cell readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            CellId cellId = (CellId)in.readObject();
            Cell cell = cellId.inDatabase(in.getDatabase());
            if (cell == null) {
                throw new InvalidObjectException(cellId + " not linked");
            }
            return cell;
        }
    }

    public static class CellGroup {
        private final Library lib;
        private TreeSet<Cell> cells;
        private Cell mainSchematic;
        private CellName groupName;

        private CellGroup(Library lib) {
            this.lib = lib;
            this.cells = new TreeSet();
        }

        CellGroup(TreeSet<Cell> cells) {
            this.lib = cells.first().getLibrary();
            this.cells = cells;
            this.setMainSchematics(true);
            for (Cell cell : cells) {
                assert (cell.getLibrary() == this.lib);
                cell.cellGroup = this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(Cell cell) {
            this.lib.checkChanging();
            Cell paramOwner = this.getParameterOwner();
            TreeSet<Cell> treeSet = this.cells;
            synchronized (treeSet) {
                if (!this.cells.contains(cell)) {
                    this.cells.add(cell);
                }
                this.setMainSchematics(false);
            }
            cell.cellGroup = this;
            if (cell.getD().paramsAllowed() && paramOwner != null) {
                cell.setParams(paramOwner);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(Cell f2) {
            this.lib.checkChanging();
            TreeSet<Cell> treeSet = this.cells;
            synchronized (treeSet) {
                this.cells.remove(f2);
                this.setMainSchematics(false);
            }
            f2.cellGroup = null;
        }

        public Iterator<Cell> getCells() {
            return this.cells.iterator();
        }

        public int getNumCells() {
            return this.cells.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Cell> getCellsSortedByView() {
            TreeSet<Cell> treeSet = this.cells;
            synchronized (treeSet) {
                ArrayList<Cell> sortedList = new ArrayList<Cell>(this.cells);
                Collections.sort(sortedList, new TextUtils.CellsByView());
                return sortedList;
            }
        }

        public Cell getMainSchematics() {
            return this.mainSchematic;
        }

        public Cell getParameterOwner() {
            if (this.mainSchematic != null) {
                return this.mainSchematic;
            }
            for (Cell cell : this.cells) {
                if (!cell.isIcon()) continue;
                return cell;
            }
            return null;
        }

        public void addParam(Variable param2) {
            for (Cell cell : this.cells) {
                if (!cell.isIcon() && !cell.isSchematic()) continue;
                Point2D offset = cell.newVarOffset();
                cell.addParam(param2.withOff(offset.getX(), offset.getY()));
            }
        }

        public void delParam(Variable.AttrKey key) {
            for (Cell cell : this.cells) {
                if (!cell.isIcon() && !cell.isSchematic()) continue;
                cell.delParam(key);
            }
        }

        public void renameParam(Variable.AttrKey key, Variable.AttrKey newName) {
            if (newName == key) {
                return;
            }
            for (Cell cell : this.cells) {
                if (!cell.isIcon() && !cell.isSchematic()) continue;
                cell.renameParam(key, newName);
            }
        }

        public void updateParam(Variable.AttrKey key, Object value2, AbstractTextDescriptor.Unit unit) {
            assert (this.cells.iterator().next().isParam(key));
            for (Cell cell : this.cells) {
                if (!cell.isIcon() && !cell.isSchematic()) continue;
                Variable oldParam = cell.getParameter(key);
                cell.addParam(oldParam.withObject(value2).withUnit(unit));
            }
        }

        public void updateParamText(Variable.AttrKey key, String text2) {
            assert (this.cells.iterator().next().isParam(key));
            for (Cell cell : this.cells) {
                if (!cell.isIcon() && !cell.isSchematic()) continue;
                Variable oldParam = cell.getParameter(key);
                cell.addParam(oldParam.withText(text2));
            }
        }

        public boolean containsCell(Cell cell) {
            return cell != null && this.cells.contains(cell);
        }

        public String toString() {
            return "CellGroup " + this.getName();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CellGroup && this.groupName != null) {
                CellGroup that = (CellGroup)obj;
                return this.lib == that.lib && this.groupName.equals(that.groupName);
            }
            return this == obj;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + (this.groupName != null ? this.groupName.hashCode() : 0);
            return hash;
        }

        public String getName() {
            return this.groupName != null ? this.groupName.getName() : null;
        }

        public EDatabase getDatabase() {
            return this.lib.getDatabase();
        }

        void check() {
            for (Cell cell : this.cells) {
                assert (this.lib.cells.get(cell.getCellName()) == cell);
                assert (cell.cellGroup == this);
                assert (((Cell)cell).d.groupName.equals(this.groupName));
            }
            if (this.mainSchematic != null) {
                assert (this.containsCell(this.mainSchematic));
                assert (this.mainSchematic.getNewestVersion() == this.mainSchematic);
            }
        }

        private void setMainSchematics(boolean undo2) {
            if (this.cells.isEmpty()) {
                this.groupName = null;
                this.mainSchematic = null;
                return;
            }
            ArrayList<CellName> cellNames = new ArrayList<CellName>();
            Cell mainSchematic = null;
            for (Cell cell : this.cells) {
                if (cell.isSchematic() && mainSchematic == null) {
                    mainSchematic = cell;
                }
                cellNames.add(cell.getCellName());
            }
            this.groupName = Snapshot.makeCellGroupName(cellNames);
            this.mainSchematic = mainSchematic;
            for (Cell cell : this.cells) {
                if (undo2) {
                    assert (((Cell)cell).d.groupName.equals(this.groupName));
                    continue;
                }
                cell.setD(cell.d.withGroupName(this.groupName));
            }
        }
    }
}

