/* electric_field.h -- This file is part of Archimedes release 0.0.2.
   Archimedes is a simulator for Submicron 2D Silicon/GaAs
   Devices. It implements the Monte Carlo method
   for the simulation of the semiclassical Boltzmann equation for both
   electrons and holes. It also includes the quantum effects by means 
   of effective potential method.

   Copyright (C) 2004, 2005 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
   USA.  */


// ######################################################
// Created on 10 Mar.2004, Siracusa, J.M.Sellier
// Last modif. : 05 Oct.2004, Siracusa, J.M.Sellier
// ######################################################

// Computation of the electrostatic potential,
// i.e. resolution of the 2D Poisson equation,
// by means of the computation of the stationary 
// solution of a pseudo-transient Poisson equation.
// For more information see the manual of 
// GNU/Archimedes release 0.0.1.

void 
Electric_Field(void)
{
 register int i,j,k;

 real factor,kappa,deltat,rho;

 PoissonBCs();
// ===============================
 factor=0.9;
 kappa=(epsMATERIAL)/Q;
 deltat=factor*0.5/kappa/(1./(dx*dx)+1./(dy*dy));
// calcolo del potenziale "stazionario"
 for(i=1;i<=POISSONITMAX;i++){
   PoissonBCs();
   for(j=0;j<=ny+2;j++)
     for(k=0;k<=nx+2;k++)
       PSI[k][j]=u2d[k][j][0];
   for(k=2;k<=ny;k++)
     for(j=2;j<=nx;j++){
       rho=(u2d[j][k][1]-N_D[j][k]-h2d[j][k][1]+N_H[j][k]);
       u2d[j][k][0]=PSI[j][k]-deltat*rho+deltat*kappa*
             ((PSI[j+1][k]-2.0*PSI[j][k]+PSI[j-1][k])/(dx*dx)
             +(PSI[j][k+1]-2.0*PSI[j][k]+PSI[j][k-1])/(dy*dy));
     }
 }

// ===============================
 PoissonBCs();
// We save the classical potential
   for(j=0;j<=ny+1;j++)
     for(i=0;i<=nx+1;i++)
       PSI[i][j]=u2d[i][j][0];

 if(Quantum_Flag==1){
   printf("Computation of Quantum Effects\n");
// We take in account the Quantum Effects
   quantum_effective_potential();
   PoissonBCs();
  }

// Computation of the X-component of the electric Field
// ====================================================
  for(k=1;k<=ny+1;k++)
   for(j=2;j<=nx;j++)
    E[j][k][0]=-0.5*(u2d[j+1][k][0]-u2d[j-1][k][0])/dx;
  for(k=1;k<=ny+1;k++){
    E[1][k][0]=E[2][k][0];
    E[nx+1][k][0]=E[nx][k][0];
  }

// Computation of the Y-component of the electric Field
// ====================================================
  for(k=2;k<=ny;k++)
   for(j=1;j<=nx+1;j++)
    E[j][k][1]=-0.5*(u2d[j][k+1][0]-u2d[j][k-1][0])/dy;
  for(j=1;j<=nx+1;j++){
    E[j][1][1]=E[j][2][1];
    E[j][ny+1][1]=E[j][ny][1];
  }
}

// ==============================================================
