/* G Calendar
 * Copyright (C) 1998 Cesar Miquel and Shawn T. Amundson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include "gtkcalendar.h"

gint
delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  return TRUE;
}

void destroy (GtkWidget *widget, gpointer data)
{
  gtk_main_quit ();
}

void cb_close (GtkWidget *widget, gpointer data)
{
  gtk_widget_destroy(GTK_WIDGET(data));
}

void
month_changed (GtkWidget *widget, gpointer data)
{
}

void
day_selected_double_click (GtkWidget *widget, gpointer data)
{
  GtkCalendar *cal;
  cal = GTK_CALENDAR(widget);

  printf("Double Clicked %d\n", cal->selected_day);
}

int
main(int argc, char *argv[])
{
  GtkWidget *window, *calendar, *vbox, *buttonbox, *button;
  GtkWidget *frame, *canvas;
  GtkCalendarDisplayOptions display_flags;
 
  gtk_init (&argc, &argv);

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_signal_connect(GTK_OBJECT(window), "delete_event",
          GTK_SIGNAL_FUNC(delete_event), NULL);
  gtk_signal_connect(GTK_OBJECT(window), "destroy",
          GTK_SIGNAL_FUNC(destroy), NULL);

  gtk_container_border_width(GTK_CONTAINER(window), 4);
  vbox = gtk_vbox_new(0,4);
  gtk_container_add(GTK_CONTAINER(window), vbox);
  
  /* Frame for calendar */
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start(GTK_BOX(vbox), frame, 0, 0, 0);

  /* Calendar */
  calendar = gtk_calendar_new ();
  display_flags = GTK_CALENDAR_SHOW_DAY_NAMES | GTK_CALENDAR_SHOW_HEADING;
  gtk_calendar_display_options ( GTK_CALENDAR(calendar), display_flags);
  gtk_calendar_select_month ( GTK_CALENDAR(calendar), 11, 1998);
  gtk_calendar_mark_day ( GTK_CALENDAR(calendar), 19);	

  gtk_container_add(GTK_CONTAINER(frame), calendar);		
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
  gtk_signal_connect (GTK_OBJECT (calendar), "month_changed", 
		      GTK_SIGNAL_FUNC (month_changed), canvas);
  gtk_signal_connect (GTK_OBJECT (calendar), "day_selected_double_click", 
		      GTK_SIGNAL_FUNC (day_selected_double_click), canvas);

  /* Close button */
  buttonbox =  gtk_hbutton_box_new();
  gtk_box_pack_start(GTK_BOX(vbox), buttonbox, 0, 0, 0);
  gtk_button_box_set_layout(GTK_BUTTON_BOX(buttonbox), GTK_BUTTONBOX_END);
  button = gtk_button_new_with_label ("Close");
  gtk_box_pack_end(GTK_BOX(buttonbox), button, 0, 0, 0);
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
          GTK_SIGNAL_FUNC(cb_close), (gpointer)window);

  gtk_widget_show_all (window);
                                  
  gtk_main ();

  return 0;              
}

