#	Font Mapper
var font_mapper = func(family, weight) {
	if( weight == "bold" ){
		return "LiberationFonts/LiberationSans-Bold.ttf";
	} else {
		return "LiberationFonts/LiberationSans-Regular.ttf";
	}
};

var instrument_path	=	"Aircraft/do228/Models/Instruments/EFI-890R/canvas/";
	

#	Property Setup for all instruments (PFDs, MFDs, NDs, ED)
var volts = {
	pfd: [
		props.globals.initNode("systems/electrical/outputs/pfd-disp[0]", 0.0, "DOUBLE"),
		props.globals.initNode("systems/electrical/outputs/pfd-disp[1]", 0.0, "DOUBLE"),
	],
	mfd: [
		props.globals.initNode("systems/electrical/outputs/mfd-disp[0]", 0.0, "DOUBLE"),
		props.globals.initNode("systems/electrical/outputs/mfd-disp[1]", 0.0, "DOUBLE"),
	],
};


var wind_from	=	props.globals.getNode("environment/wind-from-heading-deg");
var wind_spd	=	props.globals.getNode("environment/wind-speed-kt");

var base = props.globals.initNode("/instrumentation/efi-890r");

var hdg_bug		=	props.globals.getNode("autopilot/settings/heading-bug-deg");

var nav_brg_src_txt = [ "NAV1", "NAV2", "ADF1", "ADF2", "FMS1" ];
var nav_brg_src	=	[	# 0 = NAV1, 1 = NAV2, 2 = ADF1, 3 = ADF2, 4 = FMS1
				base.initNode("nav-source[0]", 0, "INT"),
				base.initNode("nav-source[1]", 1, "INT"),
				base.initNode("nav-source[2]", 2, "INT"),
				base.initNode("nav-source[3]", 3, "INT"),
			];
var bearing_deg	=	[
				props.globals.getNode("instrumentation/nav[0]/heading-deg", 1),
				props.globals.getNode("instrumentation/nav[1]/heading-deg", 1),
				props.globals.getNode("instrumentation/adf[0]/indicated-bearing-deg"),
				props.globals.getNode("instrumentation/adf[1]/indicated-bearing-deg"),
				props.globals.getNode("autopilot/route-manager/bearing-deg", 1),
			];
var in_range 	=	[
				props.globals.getNode("instrumentation/nav[0]/in-range", 1),
				props.globals.getNode("instrumentation/nav[1]/in-range", 1),
				props.globals.getNode("instrumentation/adf[0]/in-range", 1),
				props.globals.getNode("instrumentation/adf[1]/in-range", 1),
				props.globals.getNode("autopilot/route-manager/active", 1),
			];
var radial_deg	=	[
				props.globals.getNode("instrumentation/nav[0]/radials/selected-deg", 1),
				props.globals.getNode("instrumentation/nav[1]/radials/selected-deg", 1),
				props.globals.getNode("instrumentation/adf[0]/rotation-deg"),
				props.globals.getNode("instrumentation/adf[1]/rotation-deg"),
				props.globals.getNode("autopilot/route-manager/bearing-deg", 1),
				];
var deflection_norm =	[
				props.globals.getNode("instrumentation/nav[0]/heading-needle-deflection-norm", 1),
				props.globals.getNode("instrumentation/nav[1]/heading-needle-deflection-norm", 1),
				];


#	Display Unit Status
var du_status = [ 0, 0, 0, 0 ];	# 0 = OFF; 1 = TEST; 2 = ON

setlistener( volts.pfd[0], func () {
	if( volts.pfd[0].getDoubleValue() > 10 and du_status[0] == 0 ){
		du_status[0] = 1;
		settimer( func() { du_status[0] = 2; }, 5 * rand() );
	} else if( volts.pfd[0].getDoubleValue() <= 10 and du_status[0] > 0 ){
		du_status[0] = 0;
	}
});
setlistener( volts.pfd[1], func () {
	if( volts.pfd[1].getDoubleValue() > 10 and du_status[3] == 0 ){
		du_status[3] = 1;
		settimer( func() { du_status[3] = 2; }, 5 * rand() );
	} else if( volts.pfd[1].getDoubleValue() <= 10 and du_status[3] > 0 ){
		du_status[3] = 0;
	}
});

setlistener( volts.mfd[0], func () {
	if( volts.mfd[1].getDoubleValue() > 10 and du_status[1] == 0 ){
		du_status[1] = 1;
		settimer( func() { du_status[1] = 2; }, 5 * rand() );
	} else if( volts.mfd[1].getDoubleValue() <= 10 and du_status[1] > 0 ){
		du_status[1] = 0;
	}
});
setlistener( volts.mfd[1], func () {
	if( volts.mfd[1].getDoubleValue() > 10 and du_status[2] == 0 ){
		du_status[2] = 1;
		settimer( func() { du_status[2] = 2; }, 5 * rand() );
	} else if( volts.mfd[1].getDoubleValue() <= 10 and du_status[2] > 0 ){
		du_status[2] = 0;
	}
});


#	EFIS Data Btn to display switches mapper
var arpt = [
	props.globals.getNode("instrumentation/efis[0]/inputs/arpt", 1),
	props.globals.getNode("instrumentation/efis[1]/inputs/arpt", 1),
];
var vord = [
	props.globals.getNode("instrumentation/efis[0]/inputs/VORD", 1),
	props.globals.getNode("instrumentation/efis[1]/inputs/VORD", 1),
];
var ndb = [
	props.globals.getNode("instrumentation/efis[0]/inputs/NDB", 1),
	props.globals.getNode("instrumentation/efis[1]/inputs/NDB", 1),
];
var data_btn = [
	props.globals.initNode("instrumentation/efis[0]/inputs/data-btn", 0, "INT"),
	props.globals.initNode("instrumentation/efis[1]/inputs/data-btn", 0, "INT"),
];

var translate_data_btn = func( i ){
	var data_v = data_btn[ i ].getIntValue();
	if( data_v == 1 ){
		arpt[ i ].setBoolValue( 0 );
		vord[ i ].setBoolValue( 0 );
		ndb[ i  ].setBoolValue( 1 );
	}else if( data_v == 2 ){
		arpt[ i ].setBoolValue( 1 );
		vord[ i ].setBoolValue( 0 );
		ndb[ i  ].setBoolValue( 0 );
	}else if( data_v == 3 ){
		arpt[ i ].setBoolValue( 1 );
		vord[ i ].setBoolValue( 1 );
		ndb[ i  ].setBoolValue( 1 );
	}else{
		arpt[ i ].setBoolValue( 0 );
		vord[ i ].setBoolValue( 0 );
		ndb[ i  ].setBoolValue( 0 );
	}
}
setlistener( data_btn[0], func { translate_data_btn(0) } );
setlistener( data_btn[1], func { translate_data_btn(1) } );
