# This file should be loaded in the aircraft set file like so:
# <nasal>
#    <radar>
#       <file>Aircraft/Instruments-3d/RDR-160/RDR160.nas</file>
#    </radar>
#</nasal>
#
#
    var r_rng =props.globals.initNode("instrumentation/radar/range",10,"DOUBLE");
    
    var set_range=func(rng){
        var Rng = r_rng.getValue();
        if(rng==1){
            Rng=Rng*2;
            if(Rng >160)Rng=160;
        }elsif(rng==-1){
            Rng=Rng*0.5;
            if(Rng <10)Rng=10;
        }
        r_rng.setValue(Rng);
    };


###	Canvas Radar RDR-2000
#		started 2023 Bea Wolf
var rdr2000 = nil;
var rdr2000_display = nil;
var rdr2000_pages = [];

var modes = [ "OFF", "STBY", "TEST", "ON", "LOG" ];

var radar		= props.globals.initNode("/instrumentation/radar");

var tilt		= radar.initNode("tilt", 0, "INT");
var mode		= radar.initNode("mode", 0, "INT");

var volt_prop	= props.globals.initNode("/systems/electrical/outputs/radar-receiver", 0.0, "DOUBLE");

var instr_dir	= "Aircraft/Cessna-208B/Models/FlightDeck/Instruments/rdr-2000/";

var canvas_rdr2000_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationMono-Regular.ttf";
		};

		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
		 
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var volts = volt_prop.getDoubleValue();
		if ( volts > 9 and mode.getIntValue() > 0 ) {
			rdr2000_pages[ 0 ].page.show();
			rdr2000_pages[ 0 ].update();
		} else {
			rdr2000_pages[ 0 ].page.hide();
		}
	},
};
	
	
var canvas_rdr2000_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_rdr2000_main , canvas_rdr2000_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [ "tilt_annun", "mode_annun", "test_pattern", "range_grid", "range_indicators" ];
	},
	update: func() {
		var t = tilt.getIntValue();
		if( t < 0 ){
			me["tilt_annun"].setText( sprintf("D%3.1f", -t ) );
		} else {
			me["tilt_annun"].setText( sprintf("U%3.1f", t ) );
		}
		
		var m = mode.getIntValue();
		me["mode_annun"].setText( modes[ m ] );
		if( m == 2 ){
			me["test_pattern"].show();
		} else {
			me["test_pattern"].hide();
		}
		if( m < 2 ){
			me["range_grid"].hide();
			me["range_indicators"].hide();
		} else {
			me["range_grid"].show();
			me["range_indicators"].show();
		}
			
	}
	
};

var rdr2000_update = maketimer(0.2, func() { canvas_rdr2000_base.update() } );
rdr2000_update.simulatedTime = 1;

var ls = setlistener("sim/signals/fdm-initialized", func {
	rdr2000_display = canvas.new({
		"name": "RDR-2000",
		"size": [512, 384],
		"view": [512, 384],
		"mipmapping": 1
	});
	rdr2000_display.addPlacement({"node": "rdr2000.display"});
	
	append( rdr2000_pages, canvas_rdr2000_main.new( rdr2000_display.createGroup(), instr_dir~"rdr-2000.svg" ) );
	
	rdr2000_update.start();
	
	removelistener(ls);
});
