package zed.rainxch.githubstore.feature.apps.presentation

import zed.rainxch.githubstore.core.data.local.db.entities.InstalledApp

sealed interface AppsAction {
    data object OnNavigateBackClick : AppsAction
    data class OnSearchChange(val query: String) : AppsAction
    data class OnOpenApp(val app: InstalledApp) : AppsAction
    data class OnUpdateApp(val app: InstalledApp) : AppsAction
    data class OnCancelUpdate(val packageName: String) : AppsAction
    data object OnUpdateAll : AppsAction
    data object OnCancelUpdateAll : AppsAction
    data object OnCheckAllForUpdates : AppsAction
    data class OnNavigateToRepo(val repoId: Long) : AppsAction
}