package zed.rainxch.githubstore.core.domain.repository

import kotlinx.coroutines.flow.Flow
import zed.rainxch.githubstore.core.data.local.db.entities.FavoriteRepo

interface FavoritesRepository {
    fun getAllFavorites(): Flow<List<FavoriteRepo>>
    fun isFavorite(repoId: Long): Flow<Boolean>
    suspend fun isFavoriteSync(repoId: Long): Boolean
    
    suspend fun addFavorite(repo: FavoriteRepo)
    suspend fun removeFavorite(repoId: Long)
    suspend fun toggleFavorite(repo: FavoriteRepo)
    
    suspend fun updateFavoriteInstallStatus(repoId: Long, installed: Boolean, packageName: String?)
    suspend fun syncFavoriteVersions()
}