/*
 * This file is part of Grocy Android.
 *
 * Grocy Android is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Grocy Android is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Grocy Android. If not, see http://www.gnu.org/licenses/.
 *
 * Copyright (c) 2020-2024 by Patrick Zedler and Dominic Zedler
 * Copyright (c) 2024-2026 by Patrick Zedler
 */

package xyz.zedler.patrick.grocy.model;

import androidx.annotation.NonNull;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import java.util.List;

@Entity(tableName = "stored_purchase_table")
public class StoredPurchase extends GroupedListItem {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "id")
    private int id;

    @ColumnInfo(name = "pending_product_id")
    private int pendingProductId;

    @ColumnInfo(name = "amount")
    private String amount;

    @ColumnInfo(name = "price")
    private String price;

    @ColumnInfo(name = "purchased_date")
    private String purchasedDate;

    @ColumnInfo(name = "best_before_date")
    private String bestBeforeDate;

    @ColumnInfo(name = "shopping_location_id")
    private String storeId;

    @ColumnInfo(name = "location_id")
    private String locationId;

    public StoredPurchase() {
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getPendingProductId() {
        return pendingProductId;
    }

    public void setPendingProductId(int pendingProductId) {
        this.pendingProductId = pendingProductId;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public String getPurchasedDate() {
        return purchasedDate;
    }

    public void setPurchasedDate(String purchasedDate) {
        this.purchasedDate = purchasedDate;
    }

    public String getBestBeforeDate() {
        return bestBeforeDate;
    }

    public void setBestBeforeDate(String bestBeforeDate) {
        this.bestBeforeDate = bestBeforeDate;
    }

    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getLocationId() {
        return locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public static StoredPurchase getFromId(List<StoredPurchase> storedPurchases, int id) {
        for (StoredPurchase storedPurchase : storedPurchases) {
            if (storedPurchase.getId() == id) {
                return storedPurchase;
            }
        }
        return null;
    }

    @NonNull
    @Override
    public String toString() {
        return "StoredPurchase(" + pendingProductId + ')';
    }
}
