package xyz.lepisma.harp.screens.reminders

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.material3.ElevatedCard
import androidx.compose.material3.HorizontalDivider
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.dp
import xyz.lepisma.harp.data.Reminder

@Composable
fun ReminderCard(reminder: Reminder) {
    ElevatedCard(modifier = Modifier
        .fillMaxWidth()
        .padding(vertical = 8.dp)
    ) {
        Column(
            modifier = Modifier
                .padding(14.dp)
        ) {
            Column(
                modifier = Modifier.padding(bottom = 10.dp)
            ) {
                Text(
                    text = reminder.title,
                    style = MaterialTheme.typography.titleLarge
                )
            }
        }
    }
}

@Composable
fun RemindersView(reminders: List<Reminder>) {
    Text(
        "Total ${reminders.size} reminders displayed",
        style = MaterialTheme.typography.labelMedium,
        modifier = Modifier.padding(vertical = 8.dp)
    )

    val (activeReminders, inactiveReminders) = reminders.partition { r ->
        val sActive = r.scheduledStamp?.isActive ?: false
        val dActive = r.deadlineStamp?.isActive ?: false
        val stActive = r.stamp?.isActive ?: false
        sActive || dActive || stActive
    }

    LazyColumn {
        items(activeReminders) {
            ReminderCard(it)
        }

        if (inactiveReminders.isNotEmpty()) {
            item {
                HorizontalDivider(Modifier.padding(vertical = 8.dp))
                Text(
                    "Inactive Reminders",
                    modifier = Modifier.padding(vertical = 12.dp),
                    fontWeight = FontWeight.Bold
                )
            }

            items(inactiveReminders) {
                ReminderCard(it)
            }
        }
    }
}