package xyz.lepisma.harp.screens.journals

import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.material3.DropdownMenuItem
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.ExposedDropdownMenuBox
import androidx.compose.material3.ExposedDropdownMenuDefaults
import androidx.compose.material3.MenuAnchorType
import androidx.compose.material3.Text
import androidx.compose.material3.TextField
import androidx.compose.material3.TextFieldDefaults
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import xyz.lepisma.harp.data.Journal

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun JournalSelector(
    journals: List<Journal>,
    onChange: (Int) -> Unit,
    selectedIdx: Int = 0,
    label: String = "Selected Journal",
    modifier: Modifier = Modifier
) {
    var selectorExpanded by remember { mutableStateOf(false) }

    ExposedDropdownMenuBox(
        expanded = selectorExpanded,
        onExpandedChange = { selectorExpanded = !selectorExpanded },
        modifier = modifier
    ) {
        TextField(
            value = journals[selectedIdx].name,
            onValueChange = { },
            readOnly = true,
            label = { Text(label) },
            trailingIcon = { ExposedDropdownMenuDefaults.TrailingIcon(selectorExpanded) },
            colors = TextFieldDefaults.colors(
                focusedContainerColor = Color.Transparent,
                unfocusedContainerColor = Color.Transparent,
                disabledContainerColor = Color.Transparent,
            ),
            modifier = Modifier
                .fillMaxWidth()
                .menuAnchor(MenuAnchorType.PrimaryEditable, true)
        )

        ExposedDropdownMenu(
            expanded = selectorExpanded,
            onDismissRequest = { selectorExpanded = false }
        ) {
            journals.forEachIndexed { idx, journal ->
                DropdownMenuItem(
                    text = { Text(journal.name) },
                    onClick = {
                        selectorExpanded = false
                        onChange(idx)
                    }
                )
            }
        }
    }
}