package xyz.lepisma.harp.screens.home

import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material3.Icon
import androidx.compose.material3.IconButton
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.font.FontStyle
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.dp
import compose.icons.FontAwesomeIcons
import compose.icons.fontawesomeicons.Solid
import compose.icons.fontawesomeicons.solid.InfoCircle
import harp.app.generated.resources.Res
import harp.app.generated.resources.logo
import org.jetbrains.compose.resources.painterResource
import xyz.lepisma.harp.BuildConfig

@Composable
fun HarpTitle(appVersion: String = "v${BuildConfig.APP_VERSION}") {
    var showDialog by remember { mutableStateOf(false) }

    Row(verticalAlignment = Alignment.Companion.CenterVertically) {
        Icon(
            painter = painterResource(Res.drawable.logo),
            contentDescription = "Logo",
            modifier = Modifier.size(30.dp)
        )

        Text(
            text = "harp",
            style = MaterialTheme.typography.displayMedium,
            color = MaterialTheme.colorScheme.outline,
            fontStyle = FontStyle.Italic,
            fontWeight = FontWeight.Bold,
            modifier = Modifier.padding(start = 10.dp)
        )

        Spacer(Modifier.weight(1f))

        IconButton(onClick = { showDialog = true }) {
            Icon(
                imageVector = FontAwesomeIcons.Solid.InfoCircle,
                modifier = Modifier.size(16.dp),
                contentDescription = "About",
                tint = MaterialTheme.colorScheme.outline
            )
        }
    }

    if (showDialog) {
        AboutDialog(appVersion, { showDialog = false })
    }
}