package xyz.lepisma.harp.screens

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.dp
import kotlinx.datetime.format.Padding

enum class AdmonitionType {
    NOTE,
    INFO,
    TIP,
    WARNING,
    ERROR
}

@Composable
fun Admonition(
    type: AdmonitionType,
    title: String? = null,
    modifier: Modifier = Modifier,
    content: @Composable () -> Unit
) {
    val bg: androidx.compose.ui.graphics.Color
    val border: androidx.compose.ui.graphics.Color
    val icon: String

    when (type) {
        AdmonitionType.NOTE -> {
            bg = MaterialTheme.colorScheme.surfaceVariant
            border = MaterialTheme.colorScheme.outline
            icon = "📝"
        }
        AdmonitionType.INFO -> {
            bg = MaterialTheme.colorScheme.primary.copy(alpha = 0.15f)
            border = MaterialTheme.colorScheme.primary
            icon = "ℹ️"
        }
        AdmonitionType.TIP -> {
            bg = MaterialTheme.colorScheme.secondary.copy(alpha = 0.15f)
            border = MaterialTheme.colorScheme.secondary
            icon = "💡"
        }
        AdmonitionType.WARNING -> {
            bg = MaterialTheme.colorScheme.error.copy(alpha = 0.25f)
            border = MaterialTheme.colorScheme.tertiary
            icon = "⚠️"
        }
        AdmonitionType.ERROR -> {
            bg = MaterialTheme.colorScheme.error.copy(alpha = 0.35f)
            border = MaterialTheme.colorScheme.error
            icon = "⛔"
        }
    }

    Surface(
        shape = RoundedCornerShape(8.dp),
        tonalElevation = 2.dp,
        border = BorderStroke(1.dp, border),
        modifier = modifier
            .fillMaxWidth()
            .padding(vertical = 8.dp)
    ) {
        Column(
            Modifier
                .background(bg)
                .padding(16.dp)
        ) {
            if (title == null) {
                Row {
                    Text(
                        "$icon ",
                        style = MaterialTheme.typography.titleMedium,
                        fontWeight = FontWeight.Bold,
                        modifier = Modifier.padding(end = 4.dp)
                    )
                    content()
                }
            } else {
                Text(
                    "$icon $title",
                    style = MaterialTheme.typography.titleMedium,
                    fontWeight = FontWeight.Bold
                )
                Spacer(Modifier.height(4.dp))
                content()
            }
        }
    }
}
