package xyz.lepisma.harp.data

import xyz.lepisma.orgmode.OrgSection

data class Metadata(
    val sources: List<Source>,
    val metrics: List<Metric>
)

fun parseMetadata(section: OrgSection): Metadata {
    val metricsSection = section.body.find { chunk ->
        chunk is OrgSection && orgLineToString(chunk.heading.title).trim() == "Metrics"
    } as OrgSection?

    val metrics: List<Metric> = if (metricsSection == null) {
        emptyList()
    } else {
        metricsSection.body.filter { chunk ->
            chunk is OrgSection && chunk.heading.level.level == 3
        }.mapNotNull {
            parseMetric(it as OrgSection)
        }
    }

    // TODO: Parse sources too
    val sources: List<Source> = emptyList()

    return Metadata(metrics = metrics, sources = sources)
}