package xyz.lepisma.harp.data

import xyz.lepisma.orgmode.OrgSection

data class Journal(
    val name: String,
    val entries: List<JournalEntry>
)

fun Journal.formatString(): String {
    val entryTexts = this.entries.map { it.formatString() }

    return """
        |** ${this.name}
        |${entryTexts.joinToString("\n\n")}
    """.trimMargin()
}

/**
 * Parse a journal from org section with name of the journal
 */
fun parseJournal(section: OrgSection): Journal? {
    val name = orgLineToString(section.heading.title).trim()

    // The format also enforces a certain nesting structure
    if (section.heading.level.level != 2) {
        return null
    }

    val entries = section.body
        .filter { it is OrgSection }
        .mapNotNull { parseJournalEntry(it as OrgSection) }
        .sortedBy { entry -> entry.datetime }
        .reversed()

    return Journal(
        name = name,
        entries = entries
    )
}