package xyz.lepisma.harp.data

import android.provider.DocumentsContract
import androidx.core.net.toUri
import androidx.documentfile.provider.DocumentFile
import io.github.vinceglb.filekit.PlatformFile
import io.github.vinceglb.filekit.path

lateinit var appContext: android.content.Context

actual fun createFile(root: PlatformFile, fileName: String): FileUnderDir.UnderRoot? {
    val rootDir = DocumentFile.fromTreeUri(appContext, root.path.toUri())
        ?: return null

    val file = rootDir.createFile("application/octet-stream", fileName)
        ?: return null

    val id = DocumentsContract.getDocumentId(file.uri)
    return FileUnderDir.UnderRoot(
        root = root,
        filePath = PlatformFile(file.uri),
        documentId = id
    )
}

actual fun resolveFileUnderDir(
    root: PlatformFile,
    documentId: String
): PlatformFile? {
    val rootDir = DocumentFile.fromTreeUri(appContext, root.path.toUri())
        ?: return null

    val fileUri = DocumentsContract.buildDocumentUriUsingTree(rootDir.uri, documentId)
    return PlatformFile(fileUri)
}

actual fun PlatformFile.resolveUriSubpath(sub: String): PlatformFile? {
    val rootDir = DocumentFile.fromTreeUri(appContext, this.path.toUri())
        ?: return null

    val subPath = rootDir.findFile(sub)
        ?: return null
    return PlatformFile(subPath.uri)
}