package xyz.lepisma.harp.screens.home

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material3.AlertDialog
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalUriHandler
import androidx.compose.ui.unit.dp
import compose.icons.FontAwesomeIcons
import compose.icons.fontawesomeicons.Regular
import compose.icons.fontawesomeicons.Solid
import compose.icons.fontawesomeicons.regular.Envelope
import compose.icons.fontawesomeicons.regular.MoneyBillAlt
import compose.icons.fontawesomeicons.solid.Code
import compose.icons.fontawesomeicons.solid.Globe

@Composable
fun AboutDialog(appVersion: String, onDismiss: () -> Unit) {
    val uri = LocalUriHandler.current

    AlertDialog(
        onDismissRequest = onDismiss,
        confirmButton = {
            TextButton(onClick = onDismiss) {
                Text("Close")
            }
        },
        title = { Text("About harp") },
        text = {
            Column {
                Text("Harp is a privacy centric on-device Personal Health Record (PHR) application based on Org Mode files.")
                Spacer(Modifier.Companion.size(8.dp))
                Text("Version: ${appVersion}, GPL-v3")
                Spacer(Modifier.Companion.size(8.dp))

                Row(
                    verticalAlignment = Alignment.Companion.CenterVertically
                ) {
                    Icon(
                        imageVector = FontAwesomeIcons.Solid.Globe,
                        modifier = Modifier.Companion.size(12.dp),
                        contentDescription = "Website",
                        tint = MaterialTheme.colorScheme.outline
                    )
                    Text(
                        "Project Website",
                        color = MaterialTheme.colorScheme.primary,
                        modifier = Modifier.Companion.clickable {
                            uri.openUri("https://docs.lepisma.xyz/harp")
                        }
                            .padding(start = 6.dp)
                    )
                }

                Row(
                    verticalAlignment = Alignment.Companion.CenterVertically
                ) {
                    Icon(
                        imageVector = FontAwesomeIcons.Solid.Code,
                        modifier = Modifier.Companion.size(12.dp),
                        contentDescription = "Code",
                        tint = MaterialTheme.colorScheme.outline
                    )
                    Text(
                        "Source Code",
                        color = MaterialTheme.colorScheme.primary,
                        modifier = Modifier.Companion.clickable {
                            uri.openUri("https://git.sr.ht/~lepisma/harp-kmp")
                        }
                            .padding(start = 6.dp)
                    )
                }

                Row(
                    verticalAlignment = Alignment.Companion.CenterVertically
                ) {
                    Icon(
                        imageVector = FontAwesomeIcons.Regular.Envelope,
                        modifier = Modifier.Companion.size(12.dp),
                        contentDescription = "Email",
                        tint = MaterialTheme.colorScheme.outline
                    )
                    Text(
                        "Contact",
                        color = MaterialTheme.colorScheme.primary,
                        modifier = Modifier.Companion.clickable {
                            uri.openUri("mailto:abhinav@lepisma.xyz")
                        }
                            .padding(start = 6.dp)
                    )
                }

                Row(
                    verticalAlignment = Alignment.Companion.CenterVertically
                ) {
                    Icon(
                        imageVector = FontAwesomeIcons.Regular.MoneyBillAlt,
                        modifier = Modifier.Companion.size(12.dp),
                        contentDescription = "Support",
                        tint = MaterialTheme.colorScheme.outline
                    )
                    Text(
                        "Support Development",
                        color = MaterialTheme.colorScheme.primary,
                        modifier = Modifier.Companion.clickable {
                            uri.openUri("https://lepisma.xyz/wiki/support")
                        }
                            .padding(start = 6.dp)
                    )
                }
            }
        }
    )
}