package xyz.lepisma.harp.screens.documents

import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import xyz.lepisma.harp.data.Document
import xyz.lepisma.harp.viewmodel.ProfileViewModel

@Composable
fun DocumentsView(documents: List<Document>, viewModel: ProfileViewModel) {
    val selectedTags by viewModel.selectedTags.collectAsState()

    val selectedItems = if (selectedTags.isEmpty()) {
        documents
    } else {
        documents.filter { document ->
            document.tags.any { selectedTags.contains(it) }
        }
    }

    Text(
        "This section contains documents and other file based attachments",
        style = MaterialTheme.typography.bodyMedium,
        modifier = Modifier.padding(vertical = 8.dp)
    )

    Text(
        "Total ${selectedItems.size} of ${documents.size} entries displayed",
        style = MaterialTheme.typography.labelMedium,
        modifier = Modifier.padding(vertical = 8.dp)
    )

    LazyColumn(modifier = Modifier.fillMaxSize()) {
        items(selectedItems) { document ->
            DocumentCard(document, viewModel)
        }
    }
}