package xyz.lepisma.harp.screens

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.ElevatedCard
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import kotlinx.datetime.LocalDate
import kotlinx.datetime.LocalDateTime
import kotlinx.datetime.LocalTime
import kotlinx.datetime.Month

@Composable
fun DTSTampView(datetime: LocalDateTime) {
    Column {
        DateCard(datetime.date)

        val time = datetime.time
        if (!(time.hour == 0 && time.minute == 0 && time.second == 0)) {
            TimeCard(time, modifier = Modifier.padding(top = 8.dp))
        }
    }
}

@Composable
private fun DateCard(date: LocalDate, modifier: Modifier = Modifier.Companion) {
    val monthColor = when (date.month) {
        Month.JANUARY -> MaterialTheme.colorScheme.primary
        Month.FEBRUARY -> MaterialTheme.colorScheme.secondary
        Month.MARCH -> MaterialTheme.colorScheme.tertiary
        Month.APRIL -> MaterialTheme.colorScheme.primaryContainer
        Month.MAY -> MaterialTheme.colorScheme.secondaryContainer
        Month.JUNE -> MaterialTheme.colorScheme.tertiaryContainer
        Month.JULY -> MaterialTheme.colorScheme.errorContainer
        Month.AUGUST -> MaterialTheme.colorScheme.primary
        Month.SEPTEMBER -> MaterialTheme.colorScheme.secondary
        Month.OCTOBER -> MaterialTheme.colorScheme.tertiary
        Month.NOVEMBER -> MaterialTheme.colorScheme.primaryContainer
        Month.DECEMBER -> MaterialTheme.colorScheme.secondaryContainer
    }

    val monthTextColor = when (date.month) {
        Month.JANUARY -> MaterialTheme.colorScheme.onPrimary
        Month.FEBRUARY -> MaterialTheme.colorScheme.onSecondary
        Month.MARCH -> MaterialTheme.colorScheme.onTertiary
        Month.APRIL -> MaterialTheme.colorScheme.onPrimaryContainer
        Month.MAY -> MaterialTheme.colorScheme.onSecondaryContainer
        Month.JUNE -> MaterialTheme.colorScheme.onTertiaryContainer
        Month.JULY -> MaterialTheme.colorScheme.onErrorContainer
        Month.AUGUST -> MaterialTheme.colorScheme.onPrimary
        Month.SEPTEMBER -> MaterialTheme.colorScheme.onSecondary
        Month.OCTOBER -> MaterialTheme.colorScheme.onTertiary
        Month.NOVEMBER -> MaterialTheme.colorScheme.onPrimaryContainer
        Month.DECEMBER -> MaterialTheme.colorScheme.onSecondaryContainer
    }

    ElevatedCard(
        modifier = modifier
            .width(64.dp),
        shape = RoundedCornerShape(6.dp)
    ) {
        Column(
            horizontalAlignment = Alignment.Companion.CenterHorizontally,
            modifier = Modifier.Companion
                .background(MaterialTheme.colorScheme.surfaceVariant)
        ) {
            Text(
                date.month.name.substring(0, 3),
                style = MaterialTheme.typography.labelMedium,
                color = monthTextColor,
                textAlign = TextAlign.Companion.Center,
                modifier = Modifier.Companion
                    .fillMaxWidth()
                    .background(MaterialTheme.colorScheme.primary)
                    .background(
                        color = monthColor,
                        shape = RoundedCornerShape(topStart = 6.dp, topEnd = 6.dp)
                    )
                    .padding(vertical = 2.dp)
            )

            Text(
                date.day.toString(),
                style = MaterialTheme.typography.headlineMedium,
                modifier = Modifier.Companion.padding(vertical = 2.dp)
            )

            Text(
                date.year.toString(),
                style = MaterialTheme.typography.labelSmall,
                color = MaterialTheme.colorScheme.outline,
                modifier = Modifier.Companion.padding(bottom = 2.dp)
            )
        }
    }
}

@Composable
private fun TimeCard(time: LocalTime, modifier: Modifier = Modifier.Companion) {
    ElevatedCard(
        modifier = modifier
            .width(64.dp),
        shape = androidx.compose.foundation.shape.RoundedCornerShape(6.dp)
    ) {
        Column(
            horizontalAlignment = Alignment.Companion.CenterHorizontally,
            modifier = Modifier.Companion
                .background(MaterialTheme.colorScheme.surfaceVariant)
        ) {
            Text(
                "TIME",
                style = MaterialTheme.typography.labelSmall,
                color = MaterialTheme.colorScheme.onPrimary,
                textAlign = TextAlign.Companion.Center,
                modifier = Modifier.Companion
                    .fillMaxWidth()
                    .background(MaterialTheme.colorScheme.primary)
                    .padding(vertical = 2.dp)
            )

            Text(
                time.toString(),
                style = MaterialTheme.typography.titleMedium,
                modifier = Modifier.Companion.padding(top = 4.dp, bottom = 2.dp)
            )
        }
    }
}