package xyz.lepisma.harp.data

import xyz.lepisma.orgmode.OrgSection

/**
 * A metric definition
 */
data class Metric(
    val id: String,
    val name: String,
    val unit: String,
    val tags: List<String>,
    val range: Pair<Float?, Float?>,
    val healthyRange: Pair<Float?, Float?>
)

// Range strings are hyphen separated numbers that could also be null
fun parseRangeString(text: String): Pair<Float?, Float?> {
    val splits = text.split("-")
    if (splits.size != 2) {
        return null to null
    }

    return splits[0].toFloatOrNull() to splits[1].toFloatOrNull()
}

fun parseMetric(section: OrgSection): Metric? {
    val props = section.heading.properties?.map

    if (props == null) {
        return null
    }

    val tagIdLine = props["TAG_ID"]
    if (tagIdLine == null) {
        return null
    }

    val unitLine = props["UNIT"]
    if (unitLine == null) {
        return null
    }

    val rangeLine = props["RANGE"]
    val healthyRangeLine = props["HEALTHY_RANGE"]

    return Metric(
        id = orgLineToString(tagIdLine).trim(),
        name = orgLineToString(section.heading.title).trim(),
        unit = orgLineToString(unitLine).trim(),
        tags = section.heading.tags?.tags ?: emptyList(),
        range = if (rangeLine == null) {
            null to null
        } else {
            parseRangeString(orgLineToString(rangeLine).trim())
        },
        healthyRange = if (healthyRangeLine == null) {
            null to null
        } else {
            parseRangeString(orgLineToString(healthyRangeLine).trim())
        }
    )
}