package xyz.lepisma.harp

import androidx.compose.foundation.isSystemInDarkTheme
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.darkColorScheme
import androidx.compose.material3.lightColorScheme
import androidx.compose.runtime.Composable
import androidx.compose.runtime.CompositionLocalProvider
import androidx.compose.runtime.remember
import cafe.adriel.voyager.navigator.Navigator
import cafe.adriel.voyager.transitions.SlideTransition
import org.jetbrains.compose.ui.tooling.preview.Preview
import xyz.lepisma.harp.data.RecentProfiles
import xyz.lepisma.harp.screens.home.HomeScreen

@Composable
@Preview
fun HarpApp() {
    val dark = isSystemInDarkTheme()

    MaterialTheme(
        colorScheme = if (dark) darkColorScheme() else lightColorScheme()
    ) {
        CompositionLocalProvider(
            LocalRecentProfiles provides remember { RecentProfiles() }
        ) {
            Navigator(HomeScreen) { navigator ->
                SlideTransition(navigator)
            }
        }
    }
}