TERMUX_PKG_HOMEPAGE=https://www.mpfr.org/
TERMUX_PKG_DESCRIPTION="C library for multiple-precision floating-point computations with correct rounding"
TERMUX_PKG_LICENSE="LGPL-3.0"
TERMUX_PKG_MAINTAINER="@termux"
TERMUX_PKG_VERSION=4.2.1
_MAIN_VERSION=${TERMUX_PKG_VERSION%-p*}
TERMUX_PKG_SRCURL=https://mirrors.kernel.org/gnu/mpfr/mpfr-${_MAIN_VERSION}.tar.xz
TERMUX_PKG_SHA256=277807353a6726978996945af13e52829e3abd7a9a5b7fb2793894e18f1fcbb2
TERMUX_PKG_AUTO_UPDATE=false
TERMUX_PKG_DEPENDS="libgmp"
TERMUX_PKG_BREAKS="libmpfr-dev"
TERMUX_PKG_REPLACES="libmpfr-dev"
TERMUX_PKG_EXTRA_CONFIGURE_ARGS="ac_cv_header_locale_h=no"

termux_step_post_get_source() {
	if ! [[ $TERMUX_PKG_VERSION = *-p* ]]; then
		return 0
	fi
	local _PATCH_VERSION=${TERMUX_PKG_VERSION#*-p}

	declare -A PATCH_CHECKSUMS

	PATCH_CHECKSUMS[01]=2e465c31689e780a93b24bf2959917443fb882da85b7f1ef23ae53d3de614aa4
	PATCH_CHECKSUMS[02]=e1ef3d4dab999f4e0ad5ee046c3a2823d3a9395fb8092c3dcb85d3fe29994b52
	PATCH_CHECKSUMS[03]=a906f9ed8e4a7230980322a0154702664164690614e5ff55ae7049c3fae55584
	PATCH_CHECKSUMS[04]=ece14ee57596dc2e4f67d2e857c5c6b23d76b20183a50a8b6759b640df001b78
	PATCH_CHECKSUMS[05]=c4144564097a1be89c9cc2e7ee255c9fe59eb1b94a17c9d4a08169223e705ac1
	PATCH_CHECKSUMS[06]=70456748a8072265ba103d93ba94e9f93ae64565e6a5742194c56030086540fa
	PATCH_CHECKSUMS[07]=472386aa5f8c51fbdf60154c19268ce2212be03e1c2f9004c1673b6c270508f6
	PATCH_CHECKSUMS[08]=6ecd3bd2edf178f4ede4be612964d1b2d0a0bb10ad6f8c51d1a8011fff87d5ea
	PATCH_CHECKSUMS[09]=3e9aed5bcea95d34d0bd179a61cd7acb712c89c9a745535f18f0ef619833ba3b

	for PATCH_NUM in $(seq -f '%02g' ${_PATCH_VERSION}); do
		PATCHFILE=$TERMUX_PKG_CACHEDIR/mpfr-${_MAIN_VERSION}-patch${PATCH_NUM}.patch
		termux_download \
			"https://www.mpfr.org/mpfr-${_MAIN_VERSION}/patch${PATCH_NUM}" \
			$PATCHFILE \
			${PATCH_CHECKSUMS[$PATCH_NUM]}
		patch -p1 -i $PATCHFILE
	done
	unset PATCH_CHECKSUMS PATCHFILE PATCH_NUM
}
