"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addNode = addNode;
function addNode(fn) {
  process.on('exit', function () {
    return fn();
  });

  /**
   * on the following events,
   * the process will not end if there are
   * event-handlers attached,
   * therefore we have to call process.exit()
   */
  process.on('beforeExit', function () {
    return fn().then(function () {
      return process.exit();
    });
  });
  // catches ctrl+c event
  process.on('SIGINT', function () {
    return fn().then(function () {
      return process.exit();
    });
  });
  // catches uncaught exceptions
  process.on('uncaughtException', function (err) {
    return fn().then(function () {
      console.trace(err);
      process.exit(101);
    });
  });
}