import { r as __toESM, t as __commonJSMin } from "./chunk.js";
import { createRequire } from "node:module";
const BUFFER_SIZE = 2147483616, BUFFER_ALIGN = 4294967296, DATA_POINTER_POS_32 = 536870902, { max: max$1, min: min$1 } = Math, INCLUDE_COMMENTS_SKIP_OPTIONS = {
	includeComments: !0,
	skip: 0
};
let tokens = null, comments = null, tokensWithComments = null, tsEslintParse = null;
function initTokens() {
	tsEslintParse === null && (tsEslintParse = createRequire(import.meta.url)("./ts_eslint.cjs").parse), {tokens, comments} = tsEslintParse(sourceText, {
		sourceType: "module",
		tokens: !0,
		comment: !0,
		jsx: !0
	});
}
function initTokensWithComments() {
	let commentsLength = comments.length;
	if (commentsLength === 0) {
		tokensWithComments = tokens;
		return;
	}
	let tokensLength = tokens.length;
	if (tokensLength === 0) {
		tokensWithComments = comments;
		return;
	}
	tokensWithComments = [];
	let tokenIndex = 0, commentIndex = 0, token = tokens[0], comment = comments[0], tokenStart = token.range[0], commentStart = comment.range[0];
	for (; commentStart < tokenStart;) {
		if (tokensWithComments.push(comment), ++commentIndex === commentsLength) {
			tokensWithComments.push(...tokens.slice(tokenIndex));
			return;
		}
		comment = comments[commentIndex], commentStart = comment.range[0];
	}
	for (;;) {
		do {
			if (tokensWithComments.push(token), ++tokenIndex === tokensLength) {
				tokensWithComments.push(...comments.slice(commentIndex));
				return;
			}
			token = tokens[tokenIndex], tokenStart = token.range[0];
		} while (tokenStart < commentStart);
		do {
			if (tokensWithComments.push(comment), ++commentIndex === commentsLength) {
				tokensWithComments.push(...tokens.slice(tokenIndex));
				return;
			}
			comment = comments[commentIndex], commentStart = comment.range[0];
		} while (commentStart < tokenStart);
	}
}
function resetTokens() {
	tokens = null, comments = null, tokensWithComments = null;
}
function getTokens(node, countOptions, afterCount) {
	tokens === null && initTokens();
	let count = typeof countOptions == "object" && countOptions ? countOptions.count : null, beforeCount = typeof countOptions == "number" ? countOptions : 0;
	afterCount = (typeof countOptions == "number" || countOptions === void 0) && typeof afterCount == "number" ? afterCount : 0;
	let filter = typeof countOptions == "function" ? countOptions : typeof countOptions == "object" && countOptions ? countOptions.filter : null, includeComments = typeof countOptions == "object" && !!countOptions && "includeComments" in countOptions && countOptions.includeComments, tokenList = null;
	includeComments ? (tokensWithComments === null && initTokensWithComments(), tokenList = tokensWithComments) : tokenList = tokens;
	let { range } = node, rangeStart = range[0], rangeEnd = range[1], tokensLength = tokenList.length, sliceStart = tokensLength;
	for (let lo = 0; lo < sliceStart;) {
		let mid = lo + sliceStart >> 1;
		tokenList[mid].range[0] < rangeStart ? lo = mid + 1 : sliceStart = mid;
	}
	let sliceEnd = tokensLength;
	for (let lo = sliceStart; lo < sliceEnd;) {
		let mid = lo + sliceEnd >> 1;
		tokenList[mid].range[0] < rangeEnd ? lo = mid + 1 : sliceEnd = mid;
	}
	if (sliceStart = max$1(0, sliceStart - beforeCount), sliceEnd = min$1(sliceEnd + afterCount, tokensLength), typeof filter != "function") return tokenList.slice(sliceStart, min$1(sliceStart + (count ?? sliceEnd), sliceEnd));
	let allTokens = [];
	if (typeof count != "number") {
		for (let i = sliceStart; i < sliceEnd; i++) {
			let token = tokenList[i];
			filter(token) && allTokens.push(token);
		}
		return allTokens;
	}
	for (let i = sliceStart; i < sliceEnd && count > 0; i++) {
		let token = tokenList[i];
		filter(token) && (allTokens.push(token), count--);
	}
	return allTokens;
}
function getFirstToken(node, skipOptions) {
	tokens === null && initTokens();
	let skip = typeof skipOptions == "number" ? skipOptions : typeof skipOptions == "object" && skipOptions ? skipOptions.skip : null, filter = typeof skipOptions == "function" ? skipOptions : typeof skipOptions == "object" && skipOptions ? skipOptions.filter : null, includeComments = typeof skipOptions == "object" && !!skipOptions && "includeComments" in skipOptions && skipOptions.includeComments, tokenList = null;
	includeComments ? (tokensWithComments === null && initTokensWithComments(), tokenList = tokensWithComments) : tokenList = tokens;
	let { range } = node, rangeStart = range[0], rangeEnd = range[1], tokensLength = tokenList.length, startIndex = tokensLength;
	for (let lo = 0; lo < startIndex;) {
		let mid = lo + startIndex >> 1;
		tokenList[mid].range[0] < rangeStart ? lo = mid + 1 : startIndex = mid;
	}
	if (typeof filter != "function") {
		let skipTo = startIndex + (skip ?? 0);
		if (skipTo >= tokensLength) return null;
		let token = tokenList[skipTo];
		return token.range[0] >= rangeEnd ? null : token;
	}
	if (typeof skip != "number") for (let i = startIndex; i < tokensLength; i++) {
		let token = tokenList[i];
		if (token.range[0] >= rangeEnd) return null;
		if (filter(token)) return token;
	}
	else for (let i = startIndex; i < tokensLength; i++) {
		let token = tokenList[i];
		if (token.range[0] >= rangeEnd) return null;
		if (filter(token)) {
			if (skip <= 0) return token;
			skip--;
		}
	}
	return null;
}
function getFirstTokens(node, countOptions) {
	tokens === null && initTokens();
	let count = typeof countOptions == "number" ? countOptions : typeof countOptions == "object" && countOptions ? countOptions.count : null, filter = typeof countOptions == "function" ? countOptions : typeof countOptions == "object" && countOptions ? countOptions.filter : null, includeComments = typeof countOptions == "object" && !!countOptions && "includeComments" in countOptions && countOptions.includeComments, tokenList = null;
	includeComments ? (tokensWithComments === null && initTokensWithComments(), tokenList = tokensWithComments) : tokenList = tokens;
	let { range } = node, rangeStart = range[0], rangeEnd = range[1], tokensLength = tokenList.length, sliceStart = tokensLength;
	for (let lo = 0; lo < sliceStart;) {
		let mid = lo + sliceStart >> 1;
		tokenList[mid].range[0] < rangeStart ? lo = mid + 1 : sliceStart = mid;
	}
	let sliceEnd = tokensLength;
	for (let lo = sliceStart; lo < sliceEnd;) {
		let mid = lo + sliceEnd >> 1;
		tokenList[mid].range[0] < rangeEnd ? lo = mid + 1 : sliceEnd = mid;
	}
	if (typeof filter != "function") return typeof count == "number" ? tokenList.slice(sliceStart, min$1(sliceStart + count, sliceEnd)) : tokenList.slice(sliceStart, sliceEnd);
	let firstTokens = [];
	if (typeof count != "number") for (let i = sliceStart; i < sliceEnd; i++) {
		let token = tokenList[i];
		filter(token) && firstTokens.push(token);
	}
	else for (let i = sliceStart; i < sliceEnd && firstTokens.length < count; i++) {
		let token = tokenList[i];
		filter(token) && firstTokens.push(token);
	}
	return firstTokens;
}
function getLastToken(node, skipOptions) {
	tokens === null && initTokens();
	let skip = typeof skipOptions == "number" ? skipOptions : typeof skipOptions == "object" && skipOptions ? skipOptions.skip : null, filter = typeof skipOptions == "function" ? skipOptions : typeof skipOptions == "object" && skipOptions ? skipOptions.filter : null, includeComments = typeof skipOptions == "object" && !!skipOptions && "includeComments" in skipOptions && skipOptions.includeComments, tokenList = null;
	includeComments ? (tokensWithComments === null && initTokensWithComments(), tokenList = tokensWithComments) : tokenList = tokens;
	let { range } = node, rangeStart = range[0], rangeEnd = range[1], tokensLength = tokenList.length, lastTokenIndex = 0;
	for (let hi = tokensLength; lastTokenIndex < hi;) {
		let mid = lastTokenIndex + hi >> 1;
		tokenList[mid].range[0] < rangeEnd ? lastTokenIndex = mid + 1 : hi = mid;
	}
	if (lastTokenIndex--, typeof filter != "function") {
		let skipTo = lastTokenIndex - (skip ?? 0);
		if (skipTo < 0) return null;
		let token = tokenList[skipTo];
		return token.range[0] < rangeStart ? null : token;
	}
	if (typeof skip != "number") for (let i = lastTokenIndex; i >= 0; i--) {
		let token = tokenList[i];
		if (token.range[0] < rangeStart) return null;
		if (filter(token)) return token;
	}
	else for (let i = lastTokenIndex; i >= 0; i--) {
		let token = tokenList[i];
		if (token.range[0] < rangeStart) return null;
		if (filter(token)) {
			if (skip <= 0) return token;
			skip--;
		}
	}
	return null;
}
function getLastTokens(node, countOptions) {
	tokens === null && initTokens();
	let count = typeof countOptions == "number" ? countOptions : typeof countOptions == "object" && countOptions ? countOptions.count : null, filter = typeof countOptions == "function" ? countOptions : typeof countOptions == "object" && countOptions ? countOptions.filter : null, includeComments = typeof countOptions == "object" && !!countOptions && "includeComments" in countOptions && countOptions.includeComments, tokenList = null;
	includeComments ? (tokensWithComments === null && initTokensWithComments(), tokenList = tokensWithComments) : tokenList = tokens;
	let { range } = node, rangeStart = range[0], rangeEnd = range[1], tokensLength = tokenList.length, sliceStart = tokensLength;
	for (let lo = 0; lo < sliceStart;) {
		let mid = lo + sliceStart >> 1;
		tokenList[mid].range[0] < rangeStart ? lo = mid + 1 : sliceStart = mid;
	}
	let sliceEnd = tokensLength;
	for (let lo = sliceStart; lo < sliceEnd;) {
		let mid = lo + sliceEnd >> 1;
		tokenList[mid].range[0] < rangeEnd ? lo = mid + 1 : sliceEnd = mid;
	}
	if (typeof filter != "function") return typeof count == "number" ? tokenList.slice(max$1(sliceStart, sliceEnd - count), sliceEnd) : tokenList.slice(sliceStart, sliceEnd);
	let lastTokens = [];
	if (typeof count != "number") for (let i = sliceStart; i < sliceEnd; i++) {
		let token = tokenList[i];
		filter(token) && lastTokens.push(token);
	}
	else for (let i = sliceEnd - 1; i >= sliceStart && lastTokens.length < count; i--) {
		let token = tokenList[i];
		filter(token) && lastTokens.unshift(token);
	}
	return lastTokens;
}
function getTokenBefore(nodeOrToken, skipOptions) {
	tokens === null && initTokens();
	let skip = typeof skipOptions == "number" ? skipOptions : typeof skipOptions == "object" && skipOptions ? skipOptions.skip : null, filter = typeof skipOptions == "function" ? skipOptions : typeof skipOptions == "object" && skipOptions ? skipOptions.filter : null, includeComments = typeof skipOptions == "object" && !!skipOptions && "includeComments" in skipOptions && skipOptions.includeComments, tokenList = null;
	includeComments ? (tokensWithComments === null && initTokensWithComments(), tokenList = tokensWithComments) : tokenList = tokens;
	let nodeStart = nodeOrToken.range[0], beforeIndex = 0, hi = tokenList.length;
	for (; beforeIndex < hi;) {
		let mid = beforeIndex + hi >> 1;
		tokenList[mid].range[0] < nodeStart ? beforeIndex = mid + 1 : hi = mid;
	}
	if (beforeIndex--, typeof filter != "function") {
		let skipTo = beforeIndex - (skip ?? 0);
		return skipTo < 0 ? null : tokenList[skipTo];
	}
	if (typeof skip != "number") for (; beforeIndex >= 0;) {
		let token = tokenList[beforeIndex];
		if (filter(token)) return token;
		beforeIndex--;
	}
	else for (; beforeIndex >= 0;) {
		let token = tokenList[beforeIndex];
		if (filter(token)) {
			if (skip <= 0) return token;
			skip--;
		}
		beforeIndex--;
	}
	return null;
}
function getTokenOrCommentBefore(nodeOrToken, skip) {
	return INCLUDE_COMMENTS_SKIP_OPTIONS.skip = skip, getTokenBefore(nodeOrToken, INCLUDE_COMMENTS_SKIP_OPTIONS);
}
function getTokensBefore(nodeOrToken, countOptions) {
	tokens === null && initTokens();
	let count = typeof countOptions == "number" ? max$1(0, countOptions) : typeof countOptions == "object" && countOptions ? countOptions.count : null, filter = typeof countOptions == "function" ? countOptions : typeof countOptions == "object" && countOptions ? countOptions.filter : null, includeComments = typeof countOptions == "object" && !!countOptions && "includeComments" in countOptions && countOptions.includeComments, tokenList = null;
	includeComments ? (tokensWithComments === null && initTokensWithComments(), tokenList = tokensWithComments) : tokenList = tokens;
	let targetStart = nodeOrToken.range[0], sliceEnd = 0, hi = tokenList.length;
	for (; sliceEnd < hi;) {
		let mid = sliceEnd + hi >> 1;
		tokenList[mid].range[0] < targetStart ? sliceEnd = mid + 1 : hi = mid;
	}
	if (typeof filter != "function") return typeof count == "number" ? tokenList.slice(sliceEnd - count, sliceEnd) : tokenList.slice(0, sliceEnd);
	let tokensBefore = [];
	if (typeof count != "number") for (let i = 0; i < sliceEnd; i++) {
		let token = tokenList[i];
		filter(token) && tokensBefore.push(token);
	}
	else for (let i = sliceEnd - 1; i >= 0 && tokensBefore.length < count; i--) {
		let token = tokenList[i];
		filter(token) && tokensBefore.unshift(token);
	}
	return tokensBefore;
}
function getTokenAfter(nodeOrToken, skipOptions) {
	tokens === null && initTokens();
	let skip = typeof skipOptions == "number" ? skipOptions : typeof skipOptions == "object" && skipOptions ? skipOptions.skip : null, filter = typeof skipOptions == "function" ? skipOptions : typeof skipOptions == "object" && skipOptions ? skipOptions.filter : null, includeComments = typeof skipOptions == "object" && !!skipOptions && "includeComments" in skipOptions && skipOptions.includeComments, tokenList = null;
	includeComments ? (tokensWithComments === null && initTokensWithComments(), tokenList = tokensWithComments) : tokenList = tokens;
	let { range } = nodeOrToken, rangeEnd = range[1], tokensLength = tokenList.length, startIndex = tokensLength;
	for (let lo = 0; lo < startIndex;) {
		let mid = lo + startIndex >> 1;
		tokenList[mid].range[0] < rangeEnd ? lo = mid + 1 : startIndex = mid;
	}
	if (typeof filter != "function") {
		let skipTo = startIndex + (skip ?? 0);
		return skipTo >= tokensLength ? null : tokenList[skipTo];
	}
	if (typeof skip != "number") for (let i = startIndex; i < tokensLength; i++) {
		let token = tokenList[i];
		if (filter(token)) return token;
	}
	else for (let i = startIndex; i < tokensLength; i++) {
		let token = tokenList[i];
		if (filter(token)) {
			if (skip <= 0) return token;
			skip--;
		}
	}
	return null;
}
function getTokenOrCommentAfter(nodeOrToken, skip) {
	return INCLUDE_COMMENTS_SKIP_OPTIONS.skip = skip, getTokenAfter(nodeOrToken, INCLUDE_COMMENTS_SKIP_OPTIONS);
}
function getTokensAfter(nodeOrToken, countOptions) {
	tokens === null && initTokens();
	let count = typeof countOptions == "number" ? countOptions : typeof countOptions == "object" && countOptions ? countOptions.count : null, filter = typeof countOptions == "function" ? countOptions : typeof countOptions == "object" && countOptions ? countOptions.filter : null, includeComments = typeof countOptions == "object" && !!countOptions && "includeComments" in countOptions && countOptions.includeComments, tokenList;
	includeComments ? (tokensWithComments === null && initTokensWithComments(), tokenList = tokensWithComments) : tokenList = tokens;
	let rangeEnd = nodeOrToken.range[1], sliceStart = tokenList.length;
	for (let lo = 0; lo < sliceStart;) {
		let mid = lo + sliceStart >> 1;
		tokenList[mid].range[0] < rangeEnd ? lo = mid + 1 : sliceStart = mid;
	}
	if (typeof filter != "function") return typeof count == "number" ? tokenList.slice(sliceStart, sliceStart + count) : tokenList.slice(sliceStart);
	let tokenListAfter = [];
	if (typeof count != "number") for (let i = sliceStart; i < tokenList.length; i++) {
		let token = tokenList[i];
		filter(token) && tokenListAfter.push(token);
	}
	else for (let i = sliceStart; i < tokenList.length && tokenListAfter.length < count; i++) {
		let token = tokenList[i];
		filter(token) && tokenListAfter.push(token);
	}
	return tokenListAfter;
}
function getTokensBetween(left, right, countOptions) {
	tokens === null && initTokens();
	let count = typeof countOptions == "object" && countOptions ? countOptions.count : null, padding = typeof countOptions == "number" ? countOptions : 0, filter = typeof countOptions == "function" ? countOptions : typeof countOptions == "object" && countOptions ? countOptions.filter : null, includeComments = typeof countOptions == "object" && !!countOptions && "includeComments" in countOptions && countOptions.includeComments, tokenList;
	includeComments ? (tokensWithComments === null && initTokensWithComments(), tokenList = tokensWithComments) : tokenList = tokens;
	let rangeStart = left.range[1], rangeEnd = right.range[0], tokensLength = tokenList.length, sliceStart = tokensLength;
	for (let lo = 0; lo < sliceStart;) {
		let mid = lo + sliceStart >> 1;
		tokenList[mid].range[0] < rangeStart ? lo = mid + 1 : sliceStart = mid;
	}
	let sliceEnd = tokensLength;
	for (let lo = sliceStart; lo < sliceEnd;) {
		let mid = lo + sliceEnd >> 1;
		tokenList[mid].range[0] < rangeEnd ? lo = mid + 1 : sliceEnd = mid;
	}
	if (sliceStart = max$1(0, sliceStart - padding), sliceEnd += padding, typeof filter != "function") return typeof count == "number" ? tokenList.slice(sliceStart, min$1(sliceStart + count, sliceEnd)) : tokenList.slice(sliceStart, sliceEnd);
	let tokensBetween = [];
	if (typeof count != "number") for (let i = sliceStart; i < sliceEnd; i++) {
		let token = tokenList[i];
		filter(token) && tokensBetween.push(token);
	}
	else for (let i = sliceStart; i < sliceEnd && tokensBetween.length < count; i++) {
		let token = tokenList[i];
		filter(token) && tokensBetween.push(token);
	}
	return tokensBetween;
}
function getFirstTokenBetween(left, right, skipOptions) {
	tokens === null && initTokens();
	let skip = typeof skipOptions == "number" ? skipOptions : typeof skipOptions == "object" && skipOptions ? skipOptions.skip : null, filter = typeof skipOptions == "function" ? skipOptions : typeof skipOptions == "object" && skipOptions ? skipOptions.filter : null, includeComments = typeof skipOptions == "object" && !!skipOptions && "includeComments" in skipOptions && skipOptions.includeComments, tokenList = null;
	includeComments ? (tokensWithComments === null && initTokensWithComments(), tokenList = tokensWithComments) : tokenList = tokens;
	let rangeStart = left.range[1], rangeEnd = right.range[0], tokensLength = tokenList.length, firstTokenIndex = tokensLength;
	for (let lo = 0; lo < firstTokenIndex;) {
		let mid = lo + firstTokenIndex >> 1;
		tokenList[mid].range[0] < rangeStart ? lo = mid + 1 : firstTokenIndex = mid;
	}
	if (typeof filter != "function") {
		let skipTo = firstTokenIndex + (skip ?? 0);
		if (skipTo >= tokensLength) return null;
		let token = tokenList[skipTo];
		return token.range[0] >= rangeEnd ? null : token;
	}
	if (typeof skip != "number") for (let i = firstTokenIndex; i < tokensLength; i++) {
		let token = tokenList[i];
		if (token.range[0] >= rangeEnd) return null;
		if (filter(token)) return token;
	}
	else for (let i = firstTokenIndex; i < tokensLength; i++) {
		let token = tokenList[i];
		if (token.range[0] >= rangeEnd) return null;
		if (filter(token)) {
			if (skip <= 0) return token;
			skip--;
		}
	}
	return null;
}
function getFirstTokensBetween(left, right, countOptions) {
	tokens === null && initTokens();
	let count = typeof countOptions == "number" ? countOptions : typeof countOptions == "object" && countOptions ? countOptions.count : null, filter = typeof countOptions == "function" ? countOptions : typeof countOptions == "object" && countOptions ? countOptions.filter : null, includeComments = typeof countOptions == "object" && !!countOptions && "includeComments" in countOptions && countOptions.includeComments, tokenList = null;
	includeComments ? (tokensWithComments === null && initTokensWithComments(), tokenList = tokensWithComments) : tokenList = tokens;
	let rangeStart = left.range[1], rangeEnd = right.range[0], tokensLength = tokenList.length, sliceStart = tokensLength;
	for (let lo = 0; lo < sliceStart;) {
		let mid = lo + sliceStart >> 1;
		tokenList[mid].range[0] < rangeStart ? lo = mid + 1 : sliceStart = mid;
	}
	let sliceEnd = tokensLength;
	for (let lo = sliceStart; lo < sliceEnd;) {
		let mid = lo + sliceEnd >> 1;
		tokenList[mid].range[0] < rangeEnd ? lo = mid + 1 : sliceEnd = mid;
	}
	if (typeof filter != "function") return typeof count == "number" ? tokenList.slice(sliceStart, min$1(sliceStart + count, sliceEnd)) : tokenList.slice(sliceStart, sliceEnd);
	let firstTokens = [];
	if (typeof count != "number") for (let i = sliceStart; i < sliceEnd; i++) {
		let token = tokenList[i];
		filter(token) && firstTokens.push(token);
	}
	else for (let i = sliceStart; i < sliceEnd && firstTokens.length < count; i++) {
		let token = tokenList[i];
		filter(token) && firstTokens.push(token);
	}
	return firstTokens;
}
function getLastTokenBetween(left, right, skipOptions) {
	tokens === null && initTokens();
	let skip = typeof skipOptions == "number" ? skipOptions : typeof skipOptions == "object" && skipOptions ? skipOptions.skip : null, filter = typeof skipOptions == "function" ? skipOptions : typeof skipOptions == "object" && skipOptions ? skipOptions.filter : null, includeComments = typeof skipOptions == "object" && !!skipOptions && "includeComments" in skipOptions && skipOptions.includeComments, tokenList = null;
	includeComments ? (tokensWithComments === null && initTokensWithComments(), tokenList = tokensWithComments) : tokenList = tokens;
	let rangeStart = left.range[1], rangeEnd = right.range[0], lastTokenIndex = -1;
	for (let lo = 0, hi = tokenList.length - 1; lo <= hi;) {
		let mid = lo + hi >> 1;
		tokenList[mid].range[0] < rangeEnd ? (lastTokenIndex = mid, lo = mid + 1) : hi = mid - 1;
	}
	if (typeof filter != "function") {
		let skipTo = lastTokenIndex - (skip ?? 0);
		if (skipTo < 0) return null;
		let token = tokenList[skipTo];
		return token.range[0] < rangeStart ? null : token;
	}
	if (typeof skip != "number") for (let i = lastTokenIndex; i >= 0; i--) {
		let token = tokenList[i];
		if (token.range[0] < rangeStart) return null;
		if (filter(token)) return token;
	}
	else for (let i = lastTokenIndex; i >= 0; i--) {
		let token = tokenList[i];
		if (token.range[0] < rangeStart) return null;
		if (filter(token)) {
			if (skip <= 0) return token;
			skip--;
		}
	}
	return null;
}
function getLastTokensBetween(left, right, countOptions) {
	tokens === null && initTokens();
	let count = typeof countOptions == "number" ? countOptions : typeof countOptions == "object" && countOptions ? countOptions.count : null, filter = typeof countOptions == "function" ? countOptions : typeof countOptions == "object" && countOptions ? countOptions.filter : null, includeComments = typeof countOptions == "object" && !!countOptions && "includeComments" in countOptions && countOptions.includeComments, tokenList = null;
	includeComments ? (tokensWithComments === null && initTokensWithComments(), tokenList = tokensWithComments) : tokenList = tokens;
	let rangeStart = left.range[1], rangeEnd = right.range[0], tokensLength = tokenList.length, sliceStart = tokensLength;
	for (let lo = 0; lo < sliceStart;) {
		let mid = lo + sliceStart >> 1;
		tokenList[mid].range[0] < rangeStart ? lo = mid + 1 : sliceStart = mid;
	}
	let sliceEnd = tokensLength;
	for (let lo = sliceStart; lo < sliceEnd;) {
		let mid = lo + sliceEnd >> 1;
		tokenList[mid].range[0] < rangeEnd ? lo = mid + 1 : sliceEnd = mid;
	}
	if (typeof filter != "function") return typeof count == "number" ? tokenList.slice(max$1(sliceStart, sliceEnd - count), sliceEnd) : tokenList.slice(sliceStart, sliceEnd);
	let tokensBetween = [];
	if (typeof count != "number") for (let i = sliceStart; i < sliceEnd; i++) {
		let token = tokenList[i];
		filter(token) && tokensBetween.push(token);
	}
	else for (let i = sliceEnd - 1; i >= sliceStart && tokensBetween.length < count; i--) {
		let token = tokenList[i];
		filter(token) && tokensBetween.unshift(token);
	}
	return tokensBetween;
}
function getTokenByRangeStart(index$1, rangeOptions) {
	tokens === null && initTokens();
	let includeComments = typeof rangeOptions == "object" && !!rangeOptions && "includeComments" in rangeOptions && rangeOptions.includeComments, tokenList = null;
	includeComments ? (tokensWithComments === null && initTokensWithComments(), tokenList = tokensWithComments) : tokenList = tokens;
	for (let lo = 0, hi = tokenList.length; lo < hi;) {
		let mid = lo + hi >> 1, tokenStart = tokenList[mid].range[0];
		if (tokenStart === index$1) return tokenList[mid];
		tokenStart < index$1 ? lo = mid + 1 : hi = mid;
	}
	return null;
}
const JSX_WHITESPACE_REGEXP = /\s/u;
function isSpaceBetween(first, second) {
	tokensWithComments === null && (tokens === null && initTokens(), initTokensWithComments());
	let range1 = first.range, range2 = second.range, rangeStart = range1[0], rangeEnd = range2[0];
	rangeStart < rangeEnd ? rangeStart = range1[1] : (rangeEnd = rangeStart, rangeStart = range2[1]);
	let tokensWithCommentsLength = tokensWithComments.length, tokenBetweenIndex = tokensWithCommentsLength;
	for (let lo = 0; lo < tokenBetweenIndex;) {
		let mid = lo + tokenBetweenIndex >> 1;
		tokensWithComments[mid].range[0] < rangeStart ? lo = mid + 1 : tokenBetweenIndex = mid;
	}
	for (let lastTokenEnd = rangeStart; tokenBetweenIndex < tokensWithCommentsLength; tokenBetweenIndex++) {
		let { range } = tokensWithComments[tokenBetweenIndex], tokenStart = range[0];
		if (tokenStart > rangeEnd) break;
		if (tokenStart !== lastTokenEnd) return !0;
		lastTokenEnd = range[1];
	}
	return !1;
}
function isSpaceBetweenTokens(first, second) {
	tokensWithComments === null && (tokens === null && initTokens(), initTokensWithComments());
	let range1 = first.range, range2 = second.range, rangeStart = range1[0], rangeEnd = range2[0];
	rangeStart < rangeEnd ? rangeStart = range1[1] : (rangeEnd = rangeStart, rangeStart = range2[1]);
	let tokensWithCommentsLength = tokensWithComments.length, tokenBetweenIndex = tokensWithCommentsLength;
	for (let lo = 0; lo < tokenBetweenIndex;) {
		let mid = lo + tokenBetweenIndex >> 1;
		tokensWithComments[mid].range[0] < rangeStart ? lo = mid + 1 : tokenBetweenIndex = mid;
	}
	for (let lastTokenEnd = rangeStart; tokenBetweenIndex < tokensWithCommentsLength; tokenBetweenIndex++) {
		let token = tokensWithComments[tokenBetweenIndex], { range } = token, tokenStart = range[0];
		if (tokenStart > rangeEnd) break;
		if (tokenStart !== lastTokenEnd || token.type === "JSXText" && JSX_WHITESPACE_REGEXP.test(token.value)) return !0;
		lastTokenEnd = range[1];
	}
	return !1;
}
let uint8, uint32, float64, sourceText$1, sourceIsAscii, sourceByteLen$1, astId = 0, parent = null, getLoc;
const textDecoder$1 = new TextDecoder("utf-8", { ignoreBOM: !0 }), decodeStr = textDecoder$1.decode.bind(textDecoder$1), { fromCodePoint } = String, NodeProto = Object.create(null, { loc: {
	get() {
		return getLoc(this);
	},
	enumerable: !0
} });
function deserializeProgramOnly(buffer$1, sourceText$2, sourceByteLen$2, getLoc$1) {
	return deserializeWith(buffer$1, sourceText$2, sourceByteLen$2, getLoc$1, deserializeProgram);
}
function deserializeWith(buffer$1, sourceTextInput, sourceByteLenInput, getLocInput, deserialize) {
	return uint8 = buffer$1, uint32 = buffer$1.uint32, float64 = buffer$1.float64, sourceText$1 = sourceTextInput, sourceByteLen$1 = sourceByteLenInput, sourceIsAscii = sourceText$1.length === sourceByteLen$1, getLoc = getLocInput, deserialize(uint32[536870902]);
}
function resetBuffer() {
	uint8 = uint32 = float64 = sourceText$1 = void 0, astId++;
}
function deserializeProgram(pos) {
	let localAstId = astId, end = deserializeU32(pos + 4), program = parent = {
		__proto__: NodeProto,
		type: "Program",
		body: null,
		sourceType: deserializeModuleKind(pos + 125),
		hashbang: null,
		get comments() {
			if (localAstId !== astId) throw Error("Comments are only accessible while linting the file");
			let comments$1 = deserializeVecComment(pos + 24);
			return Object.defineProperty(this, "comments", { value: comments$1 }), comments$1;
		},
		get tokens() {
			return tokens === null && initTokens(), tokens;
		},
		start: 0,
		end,
		range: [0, end],
		parent: null
	};
	program.hashbang = deserializeOptionHashbang(pos + 48);
	let body = program.body = deserializeVecDirective(pos + 72);
	body.push(...deserializeVecStatement(pos + 96));
	{
		let start;
		if (body.length > 0) {
			let first = body[0];
			if (start = first.start, first.type === "ExportNamedDeclaration" || first.type === "ExportDefaultDeclaration") {
				let { declaration } = first;
				if (declaration !== null && declaration.type === "ClassDeclaration" && declaration.decorators.length > 0) {
					let decoratorStart = declaration.decorators[0].start;
					decoratorStart < start && (start = decoratorStart);
				}
			}
		} else start = end;
		program.start = program.range[0] = start;
	}
	return parent = null, program;
}
function deserializeExpression(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxBooleanLiteral(pos + 8);
		case 1: return deserializeBoxNullLiteral(pos + 8);
		case 2: return deserializeBoxNumericLiteral(pos + 8);
		case 3: return deserializeBoxBigIntLiteral(pos + 8);
		case 4: return deserializeBoxRegExpLiteral(pos + 8);
		case 5: return deserializeBoxStringLiteral(pos + 8);
		case 6: return deserializeBoxTemplateLiteral(pos + 8);
		case 7: return deserializeBoxIdentifierReference(pos + 8);
		case 8: return deserializeBoxMetaProperty(pos + 8);
		case 9: return deserializeBoxSuper(pos + 8);
		case 10: return deserializeBoxArrayExpression(pos + 8);
		case 11: return deserializeBoxArrowFunctionExpression(pos + 8);
		case 12: return deserializeBoxAssignmentExpression(pos + 8);
		case 13: return deserializeBoxAwaitExpression(pos + 8);
		case 14: return deserializeBoxBinaryExpression(pos + 8);
		case 15: return deserializeBoxCallExpression(pos + 8);
		case 16: return deserializeBoxChainExpression(pos + 8);
		case 17: return deserializeBoxClass(pos + 8);
		case 18: return deserializeBoxConditionalExpression(pos + 8);
		case 19: return deserializeBoxFunction(pos + 8);
		case 20: return deserializeBoxImportExpression(pos + 8);
		case 21: return deserializeBoxLogicalExpression(pos + 8);
		case 22: return deserializeBoxNewExpression(pos + 8);
		case 23: return deserializeBoxObjectExpression(pos + 8);
		case 24: return deserializeBoxParenthesizedExpression(pos + 8);
		case 25: return deserializeBoxSequenceExpression(pos + 8);
		case 26: return deserializeBoxTaggedTemplateExpression(pos + 8);
		case 27: return deserializeBoxThisExpression(pos + 8);
		case 28: return deserializeBoxUnaryExpression(pos + 8);
		case 29: return deserializeBoxUpdateExpression(pos + 8);
		case 30: return deserializeBoxYieldExpression(pos + 8);
		case 31: return deserializeBoxPrivateInExpression(pos + 8);
		case 32: return deserializeBoxJSXElement(pos + 8);
		case 33: return deserializeBoxJSXFragment(pos + 8);
		case 34: return deserializeBoxTSAsExpression(pos + 8);
		case 35: return deserializeBoxTSSatisfiesExpression(pos + 8);
		case 36: return deserializeBoxTSTypeAssertion(pos + 8);
		case 37: return deserializeBoxTSNonNullExpression(pos + 8);
		case 38: return deserializeBoxTSInstantiationExpression(pos + 8);
		case 39: return deserializeBoxV8IntrinsicExpression(pos + 8);
		case 48: return deserializeBoxComputedMemberExpression(pos + 8);
		case 49: return deserializeBoxStaticMemberExpression(pos + 8);
		case 50: return deserializeBoxPrivateFieldExpression(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for Expression`);
	}
}
function deserializeIdentifierName(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "Identifier",
		decorators: null,
		name: deserializeStr(pos + 8),
		optional: null,
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.decorators = [], node.optional = !1, parent = previousParent, node;
}
function deserializeIdentifierReference(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "Identifier",
		decorators: null,
		name: deserializeStr(pos + 8),
		optional: null,
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.decorators = [], node.optional = !1, parent = previousParent, node;
}
function deserializeBindingIdentifier(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "Identifier",
		decorators: null,
		name: deserializeStr(pos + 8),
		optional: null,
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.decorators = [], node.optional = !1, parent = previousParent, node;
}
function deserializeLabelIdentifier(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "Identifier",
		decorators: null,
		name: deserializeStr(pos + 8),
		optional: null,
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.decorators = [], node.optional = !1, parent = previousParent, node;
}
function deserializeThisExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "ThisExpression",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeArrayExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ArrayExpression",
		elements: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.elements = deserializeVecArrayExpressionElement(pos + 8), parent = previousParent, node;
}
function deserializeArrayExpressionElement(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxBooleanLiteral(pos + 8);
		case 1: return deserializeBoxNullLiteral(pos + 8);
		case 2: return deserializeBoxNumericLiteral(pos + 8);
		case 3: return deserializeBoxBigIntLiteral(pos + 8);
		case 4: return deserializeBoxRegExpLiteral(pos + 8);
		case 5: return deserializeBoxStringLiteral(pos + 8);
		case 6: return deserializeBoxTemplateLiteral(pos + 8);
		case 7: return deserializeBoxIdentifierReference(pos + 8);
		case 8: return deserializeBoxMetaProperty(pos + 8);
		case 9: return deserializeBoxSuper(pos + 8);
		case 10: return deserializeBoxArrayExpression(pos + 8);
		case 11: return deserializeBoxArrowFunctionExpression(pos + 8);
		case 12: return deserializeBoxAssignmentExpression(pos + 8);
		case 13: return deserializeBoxAwaitExpression(pos + 8);
		case 14: return deserializeBoxBinaryExpression(pos + 8);
		case 15: return deserializeBoxCallExpression(pos + 8);
		case 16: return deserializeBoxChainExpression(pos + 8);
		case 17: return deserializeBoxClass(pos + 8);
		case 18: return deserializeBoxConditionalExpression(pos + 8);
		case 19: return deserializeBoxFunction(pos + 8);
		case 20: return deserializeBoxImportExpression(pos + 8);
		case 21: return deserializeBoxLogicalExpression(pos + 8);
		case 22: return deserializeBoxNewExpression(pos + 8);
		case 23: return deserializeBoxObjectExpression(pos + 8);
		case 24: return deserializeBoxParenthesizedExpression(pos + 8);
		case 25: return deserializeBoxSequenceExpression(pos + 8);
		case 26: return deserializeBoxTaggedTemplateExpression(pos + 8);
		case 27: return deserializeBoxThisExpression(pos + 8);
		case 28: return deserializeBoxUnaryExpression(pos + 8);
		case 29: return deserializeBoxUpdateExpression(pos + 8);
		case 30: return deserializeBoxYieldExpression(pos + 8);
		case 31: return deserializeBoxPrivateInExpression(pos + 8);
		case 32: return deserializeBoxJSXElement(pos + 8);
		case 33: return deserializeBoxJSXFragment(pos + 8);
		case 34: return deserializeBoxTSAsExpression(pos + 8);
		case 35: return deserializeBoxTSSatisfiesExpression(pos + 8);
		case 36: return deserializeBoxTSTypeAssertion(pos + 8);
		case 37: return deserializeBoxTSNonNullExpression(pos + 8);
		case 38: return deserializeBoxTSInstantiationExpression(pos + 8);
		case 39: return deserializeBoxV8IntrinsicExpression(pos + 8);
		case 48: return deserializeBoxComputedMemberExpression(pos + 8);
		case 49: return deserializeBoxStaticMemberExpression(pos + 8);
		case 50: return deserializeBoxPrivateFieldExpression(pos + 8);
		case 64: return deserializeBoxSpreadElement(pos + 8);
		case 65: return deserializeElision(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for ArrayExpressionElement`);
	}
}
function deserializeElision(pos) {
	return null;
}
function deserializeObjectExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ObjectExpression",
		properties: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.properties = deserializeVecObjectPropertyKind(pos + 8), parent = previousParent, node;
}
function deserializeObjectPropertyKind(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxObjectProperty(pos + 8);
		case 1: return deserializeBoxSpreadElement(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for ObjectPropertyKind`);
	}
}
function deserializeObjectProperty(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "Property",
		kind: deserializePropertyKind(pos + 40),
		key: null,
		value: null,
		method: deserializeBool(pos + 41),
		shorthand: deserializeBool(pos + 42),
		computed: deserializeBool(pos + 43),
		optional: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.key = deserializePropertyKey(pos + 8), node.value = deserializeExpression(pos + 24), node.optional = !1, parent = previousParent, node;
}
function deserializePropertyKey(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxBooleanLiteral(pos + 8);
		case 1: return deserializeBoxNullLiteral(pos + 8);
		case 2: return deserializeBoxNumericLiteral(pos + 8);
		case 3: return deserializeBoxBigIntLiteral(pos + 8);
		case 4: return deserializeBoxRegExpLiteral(pos + 8);
		case 5: return deserializeBoxStringLiteral(pos + 8);
		case 6: return deserializeBoxTemplateLiteral(pos + 8);
		case 7: return deserializeBoxIdentifierReference(pos + 8);
		case 8: return deserializeBoxMetaProperty(pos + 8);
		case 9: return deserializeBoxSuper(pos + 8);
		case 10: return deserializeBoxArrayExpression(pos + 8);
		case 11: return deserializeBoxArrowFunctionExpression(pos + 8);
		case 12: return deserializeBoxAssignmentExpression(pos + 8);
		case 13: return deserializeBoxAwaitExpression(pos + 8);
		case 14: return deserializeBoxBinaryExpression(pos + 8);
		case 15: return deserializeBoxCallExpression(pos + 8);
		case 16: return deserializeBoxChainExpression(pos + 8);
		case 17: return deserializeBoxClass(pos + 8);
		case 18: return deserializeBoxConditionalExpression(pos + 8);
		case 19: return deserializeBoxFunction(pos + 8);
		case 20: return deserializeBoxImportExpression(pos + 8);
		case 21: return deserializeBoxLogicalExpression(pos + 8);
		case 22: return deserializeBoxNewExpression(pos + 8);
		case 23: return deserializeBoxObjectExpression(pos + 8);
		case 24: return deserializeBoxParenthesizedExpression(pos + 8);
		case 25: return deserializeBoxSequenceExpression(pos + 8);
		case 26: return deserializeBoxTaggedTemplateExpression(pos + 8);
		case 27: return deserializeBoxThisExpression(pos + 8);
		case 28: return deserializeBoxUnaryExpression(pos + 8);
		case 29: return deserializeBoxUpdateExpression(pos + 8);
		case 30: return deserializeBoxYieldExpression(pos + 8);
		case 31: return deserializeBoxPrivateInExpression(pos + 8);
		case 32: return deserializeBoxJSXElement(pos + 8);
		case 33: return deserializeBoxJSXFragment(pos + 8);
		case 34: return deserializeBoxTSAsExpression(pos + 8);
		case 35: return deserializeBoxTSSatisfiesExpression(pos + 8);
		case 36: return deserializeBoxTSTypeAssertion(pos + 8);
		case 37: return deserializeBoxTSNonNullExpression(pos + 8);
		case 38: return deserializeBoxTSInstantiationExpression(pos + 8);
		case 39: return deserializeBoxV8IntrinsicExpression(pos + 8);
		case 48: return deserializeBoxComputedMemberExpression(pos + 8);
		case 49: return deserializeBoxStaticMemberExpression(pos + 8);
		case 50: return deserializeBoxPrivateFieldExpression(pos + 8);
		case 64: return deserializeBoxIdentifierName(pos + 8);
		case 65: return deserializeBoxPrivateIdentifier(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for PropertyKey`);
	}
}
function deserializePropertyKind(pos) {
	switch (uint8[pos]) {
		case 0: return "init";
		case 1: return "get";
		case 2: return "set";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for PropertyKind`);
	}
}
function deserializeTemplateLiteral(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TemplateLiteral",
		quasis: null,
		expressions: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.quasis = deserializeVecTemplateElement(pos + 8), node.expressions = deserializeVecExpression(pos + 32), parent = previousParent, node;
}
function deserializeTaggedTemplateExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TaggedTemplateExpression",
		tag: null,
		typeArguments: null,
		quasi: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.tag = deserializeExpression(pos + 8), node.typeArguments = deserializeOptionBoxTSTypeParameterInstantiation(pos + 24), node.quasi = deserializeTemplateLiteral(pos + 32), parent = previousParent, node;
}
function deserializeTemplateElement(pos) {
	let tail = deserializeBool(pos + 40), start = deserializeU32(pos) - 1, end = deserializeU32(pos + 4) + 2 - tail, value = deserializeTemplateElementValue(pos + 8);
	return value.cooked !== null && deserializeBool(pos + 41) && (value.cooked = value.cooked.replace(/\uFFFD(.{4})/g, (_, hex) => String.fromCodePoint(parseInt(hex, 16)))), {
		__proto__: NodeProto,
		type: "TemplateElement",
		value,
		tail,
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeTemplateElementValue(pos) {
	return {
		raw: deserializeStr(pos),
		cooked: deserializeOptionStr(pos + 16)
	};
}
function deserializeComputedMemberExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "MemberExpression",
		object: null,
		property: null,
		optional: deserializeBool(pos + 40),
		computed: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.object = deserializeExpression(pos + 8), node.property = deserializeExpression(pos + 24), node.computed = !0, parent = previousParent, node;
}
function deserializeStaticMemberExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "MemberExpression",
		object: null,
		property: null,
		optional: deserializeBool(pos + 48),
		computed: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.object = deserializeExpression(pos + 8), node.property = deserializeIdentifierName(pos + 24), node.computed = !1, parent = previousParent, node;
}
function deserializePrivateFieldExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "MemberExpression",
		object: null,
		property: null,
		optional: deserializeBool(pos + 48),
		computed: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.object = deserializeExpression(pos + 8), node.property = deserializePrivateIdentifier(pos + 24), node.computed = !1, parent = previousParent, node;
}
function deserializeCallExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "CallExpression",
		callee: null,
		typeArguments: null,
		arguments: null,
		optional: deserializeBool(pos + 56),
		start,
		end,
		range: [start, end],
		parent
	};
	return node.callee = deserializeExpression(pos + 8), node.typeArguments = deserializeOptionBoxTSTypeParameterInstantiation(pos + 24), node.arguments = deserializeVecArgument(pos + 32), parent = previousParent, node;
}
function deserializeNewExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "NewExpression",
		callee: null,
		typeArguments: null,
		arguments: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.callee = deserializeExpression(pos + 8), node.typeArguments = deserializeOptionBoxTSTypeParameterInstantiation(pos + 24), node.arguments = deserializeVecArgument(pos + 32), parent = previousParent, node;
}
function deserializeMetaProperty(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "MetaProperty",
		meta: null,
		property: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.meta = deserializeIdentifierName(pos + 8), node.property = deserializeIdentifierName(pos + 32), parent = previousParent, node;
}
function deserializeSpreadElement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "SpreadElement",
		argument: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.argument = deserializeExpression(pos + 8), parent = previousParent, node;
}
function deserializeArgument(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxBooleanLiteral(pos + 8);
		case 1: return deserializeBoxNullLiteral(pos + 8);
		case 2: return deserializeBoxNumericLiteral(pos + 8);
		case 3: return deserializeBoxBigIntLiteral(pos + 8);
		case 4: return deserializeBoxRegExpLiteral(pos + 8);
		case 5: return deserializeBoxStringLiteral(pos + 8);
		case 6: return deserializeBoxTemplateLiteral(pos + 8);
		case 7: return deserializeBoxIdentifierReference(pos + 8);
		case 8: return deserializeBoxMetaProperty(pos + 8);
		case 9: return deserializeBoxSuper(pos + 8);
		case 10: return deserializeBoxArrayExpression(pos + 8);
		case 11: return deserializeBoxArrowFunctionExpression(pos + 8);
		case 12: return deserializeBoxAssignmentExpression(pos + 8);
		case 13: return deserializeBoxAwaitExpression(pos + 8);
		case 14: return deserializeBoxBinaryExpression(pos + 8);
		case 15: return deserializeBoxCallExpression(pos + 8);
		case 16: return deserializeBoxChainExpression(pos + 8);
		case 17: return deserializeBoxClass(pos + 8);
		case 18: return deserializeBoxConditionalExpression(pos + 8);
		case 19: return deserializeBoxFunction(pos + 8);
		case 20: return deserializeBoxImportExpression(pos + 8);
		case 21: return deserializeBoxLogicalExpression(pos + 8);
		case 22: return deserializeBoxNewExpression(pos + 8);
		case 23: return deserializeBoxObjectExpression(pos + 8);
		case 24: return deserializeBoxParenthesizedExpression(pos + 8);
		case 25: return deserializeBoxSequenceExpression(pos + 8);
		case 26: return deserializeBoxTaggedTemplateExpression(pos + 8);
		case 27: return deserializeBoxThisExpression(pos + 8);
		case 28: return deserializeBoxUnaryExpression(pos + 8);
		case 29: return deserializeBoxUpdateExpression(pos + 8);
		case 30: return deserializeBoxYieldExpression(pos + 8);
		case 31: return deserializeBoxPrivateInExpression(pos + 8);
		case 32: return deserializeBoxJSXElement(pos + 8);
		case 33: return deserializeBoxJSXFragment(pos + 8);
		case 34: return deserializeBoxTSAsExpression(pos + 8);
		case 35: return deserializeBoxTSSatisfiesExpression(pos + 8);
		case 36: return deserializeBoxTSTypeAssertion(pos + 8);
		case 37: return deserializeBoxTSNonNullExpression(pos + 8);
		case 38: return deserializeBoxTSInstantiationExpression(pos + 8);
		case 39: return deserializeBoxV8IntrinsicExpression(pos + 8);
		case 48: return deserializeBoxComputedMemberExpression(pos + 8);
		case 49: return deserializeBoxStaticMemberExpression(pos + 8);
		case 50: return deserializeBoxPrivateFieldExpression(pos + 8);
		case 64: return deserializeBoxSpreadElement(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for Argument`);
	}
}
function deserializeUpdateExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "UpdateExpression",
		operator: deserializeUpdateOperator(pos + 24),
		prefix: deserializeBool(pos + 25),
		argument: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.argument = deserializeSimpleAssignmentTarget(pos + 8), parent = previousParent, node;
}
function deserializeUnaryExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "UnaryExpression",
		operator: deserializeUnaryOperator(pos + 24),
		argument: null,
		prefix: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.argument = deserializeExpression(pos + 8), node.prefix = !0, parent = previousParent, node;
}
function deserializeBinaryExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "BinaryExpression",
		left: null,
		operator: deserializeBinaryOperator(pos + 40),
		right: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.left = deserializeExpression(pos + 8), node.right = deserializeExpression(pos + 24), parent = previousParent, node;
}
function deserializePrivateInExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "BinaryExpression",
		left: null,
		operator: null,
		right: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.left = deserializePrivateIdentifier(pos + 8), node.operator = "in", node.right = deserializeExpression(pos + 32), parent = previousParent, node;
}
function deserializeLogicalExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "LogicalExpression",
		left: null,
		operator: deserializeLogicalOperator(pos + 40),
		right: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.left = deserializeExpression(pos + 8), node.right = deserializeExpression(pos + 24), parent = previousParent, node;
}
function deserializeConditionalExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ConditionalExpression",
		test: null,
		consequent: null,
		alternate: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.test = deserializeExpression(pos + 8), node.consequent = deserializeExpression(pos + 24), node.alternate = deserializeExpression(pos + 40), parent = previousParent, node;
}
function deserializeAssignmentExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "AssignmentExpression",
		operator: deserializeAssignmentOperator(pos + 40),
		left: null,
		right: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.left = deserializeAssignmentTarget(pos + 8), node.right = deserializeExpression(pos + 24), parent = previousParent, node;
}
function deserializeAssignmentTarget(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxIdentifierReference(pos + 8);
		case 1: return deserializeBoxTSAsExpression(pos + 8);
		case 2: return deserializeBoxTSSatisfiesExpression(pos + 8);
		case 3: return deserializeBoxTSNonNullExpression(pos + 8);
		case 4: return deserializeBoxTSTypeAssertion(pos + 8);
		case 8: return deserializeBoxArrayAssignmentTarget(pos + 8);
		case 9: return deserializeBoxObjectAssignmentTarget(pos + 8);
		case 48: return deserializeBoxComputedMemberExpression(pos + 8);
		case 49: return deserializeBoxStaticMemberExpression(pos + 8);
		case 50: return deserializeBoxPrivateFieldExpression(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for AssignmentTarget`);
	}
}
function deserializeSimpleAssignmentTarget(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxIdentifierReference(pos + 8);
		case 1: return deserializeBoxTSAsExpression(pos + 8);
		case 2: return deserializeBoxTSSatisfiesExpression(pos + 8);
		case 3: return deserializeBoxTSNonNullExpression(pos + 8);
		case 4: return deserializeBoxTSTypeAssertion(pos + 8);
		case 48: return deserializeBoxComputedMemberExpression(pos + 8);
		case 49: return deserializeBoxStaticMemberExpression(pos + 8);
		case 50: return deserializeBoxPrivateFieldExpression(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for SimpleAssignmentTarget`);
	}
}
function deserializeArrayAssignmentTarget(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ArrayPattern",
		decorators: null,
		elements: null,
		optional: null,
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	}, elements = deserializeVecOptionAssignmentTargetMaybeDefault(pos + 8), rest = deserializeOptionBoxAssignmentTargetRest(pos + 32);
	return rest !== null && elements.push(rest), node.decorators = [], node.elements = elements, node.optional = !1, parent = previousParent, node;
}
function deserializeObjectAssignmentTarget(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ObjectPattern",
		decorators: null,
		properties: null,
		optional: null,
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	}, properties = deserializeVecAssignmentTargetProperty(pos + 8), rest = deserializeOptionBoxAssignmentTargetRest(pos + 32);
	return rest !== null && properties.push(rest), node.decorators = [], node.properties = properties, node.optional = !1, parent = previousParent, node;
}
function deserializeAssignmentTargetRest(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "RestElement",
		decorators: null,
		argument: null,
		optional: null,
		typeAnnotation: null,
		value: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.decorators = [], node.argument = deserializeAssignmentTarget(pos + 8), node.optional = !1, parent = previousParent, node;
}
function deserializeAssignmentTargetMaybeDefault(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxIdentifierReference(pos + 8);
		case 1: return deserializeBoxTSAsExpression(pos + 8);
		case 2: return deserializeBoxTSSatisfiesExpression(pos + 8);
		case 3: return deserializeBoxTSNonNullExpression(pos + 8);
		case 4: return deserializeBoxTSTypeAssertion(pos + 8);
		case 8: return deserializeBoxArrayAssignmentTarget(pos + 8);
		case 9: return deserializeBoxObjectAssignmentTarget(pos + 8);
		case 16: return deserializeBoxAssignmentTargetWithDefault(pos + 8);
		case 48: return deserializeBoxComputedMemberExpression(pos + 8);
		case 49: return deserializeBoxStaticMemberExpression(pos + 8);
		case 50: return deserializeBoxPrivateFieldExpression(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for AssignmentTargetMaybeDefault`);
	}
}
function deserializeAssignmentTargetWithDefault(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "AssignmentPattern",
		decorators: null,
		left: null,
		right: null,
		optional: null,
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.decorators = [], node.left = deserializeAssignmentTarget(pos + 8), node.right = deserializeExpression(pos + 24), node.optional = !1, parent = previousParent, node;
}
function deserializeAssignmentTargetProperty(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxAssignmentTargetPropertyIdentifier(pos + 8);
		case 1: return deserializeBoxAssignmentTargetPropertyProperty(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for AssignmentTargetProperty`);
	}
}
function deserializeAssignmentTargetPropertyIdentifier(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "Property",
		kind: null,
		key: null,
		value: null,
		method: null,
		shorthand: null,
		computed: null,
		optional: null,
		start,
		end,
		range: [start, end],
		parent
	}, key = deserializeIdentifierReference(pos + 8), keyStart, keyEnd, value = {
		__proto__: NodeProto,
		type: "Identifier",
		decorators: [],
		name: key.name,
		optional: !1,
		typeAnnotation: null,
		start: keyStart = key.start,
		end: keyEnd = key.end,
		range: [keyStart, keyEnd],
		parent
	}, init = deserializeOptionExpression(pos + 40);
	if (init !== null) {
		let left = value;
		value = {
			__proto__: NodeProto,
			type: "AssignmentPattern",
			decorators: [],
			left,
			right: init,
			optional: !1,
			typeAnnotation: null,
			start,
			end,
			range: [start, end],
			parent
		}, left.parent = value, init.parent = value;
	}
	return node.kind = "init", node.key = key, node.value = value, node.method = !1, node.shorthand = !0, node.computed = !1, node.optional = !1, parent = previousParent, node;
}
function deserializeAssignmentTargetPropertyProperty(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "Property",
		kind: null,
		key: null,
		value: null,
		method: null,
		shorthand: null,
		computed: deserializeBool(pos + 40),
		optional: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.kind = "init", node.key = deserializePropertyKey(pos + 8), node.value = deserializeAssignmentTargetMaybeDefault(pos + 24), node.method = !1, node.shorthand = !1, node.optional = !1, parent = previousParent, node;
}
function deserializeSequenceExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "SequenceExpression",
		expressions: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.expressions = deserializeVecExpression(pos + 8), parent = previousParent, node;
}
function deserializeSuper(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "Super",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeAwaitExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "AwaitExpression",
		argument: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.argument = deserializeExpression(pos + 8), parent = previousParent, node;
}
function deserializeChainExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ChainExpression",
		expression: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.expression = deserializeChainElement(pos + 8), parent = previousParent, node;
}
function deserializeChainElement(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxCallExpression(pos + 8);
		case 1: return deserializeBoxTSNonNullExpression(pos + 8);
		case 48: return deserializeBoxComputedMemberExpression(pos + 8);
		case 49: return deserializeBoxStaticMemberExpression(pos + 8);
		case 50: return deserializeBoxPrivateFieldExpression(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for ChainElement`);
	}
}
function deserializeParenthesizedExpression(pos) {
	let node;
	return node = deserializeExpression(pos + 8), node;
}
function deserializeStatement(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxBlockStatement(pos + 8);
		case 1: return deserializeBoxBreakStatement(pos + 8);
		case 2: return deserializeBoxContinueStatement(pos + 8);
		case 3: return deserializeBoxDebuggerStatement(pos + 8);
		case 4: return deserializeBoxDoWhileStatement(pos + 8);
		case 5: return deserializeBoxEmptyStatement(pos + 8);
		case 6: return deserializeBoxExpressionStatement(pos + 8);
		case 7: return deserializeBoxForInStatement(pos + 8);
		case 8: return deserializeBoxForOfStatement(pos + 8);
		case 9: return deserializeBoxForStatement(pos + 8);
		case 10: return deserializeBoxIfStatement(pos + 8);
		case 11: return deserializeBoxLabeledStatement(pos + 8);
		case 12: return deserializeBoxReturnStatement(pos + 8);
		case 13: return deserializeBoxSwitchStatement(pos + 8);
		case 14: return deserializeBoxThrowStatement(pos + 8);
		case 15: return deserializeBoxTryStatement(pos + 8);
		case 16: return deserializeBoxWhileStatement(pos + 8);
		case 17: return deserializeBoxWithStatement(pos + 8);
		case 32: return deserializeBoxVariableDeclaration(pos + 8);
		case 33: return deserializeBoxFunction(pos + 8);
		case 34: return deserializeBoxClass(pos + 8);
		case 35: return deserializeBoxTSTypeAliasDeclaration(pos + 8);
		case 36: return deserializeBoxTSInterfaceDeclaration(pos + 8);
		case 37: return deserializeBoxTSEnumDeclaration(pos + 8);
		case 38: return deserializeBoxTSModuleDeclaration(pos + 8);
		case 39: return deserializeBoxTSGlobalDeclaration(pos + 8);
		case 40: return deserializeBoxTSImportEqualsDeclaration(pos + 8);
		case 64: return deserializeBoxImportDeclaration(pos + 8);
		case 65: return deserializeBoxExportAllDeclaration(pos + 8);
		case 66: return deserializeBoxExportDefaultDeclaration(pos + 8);
		case 67: return deserializeBoxExportNamedDeclaration(pos + 8);
		case 68: return deserializeBoxTSExportAssignment(pos + 8);
		case 69: return deserializeBoxTSNamespaceExportDeclaration(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for Statement`);
	}
}
function deserializeDirective(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ExpressionStatement",
		expression: null,
		directive: deserializeStr(pos + 56),
		start,
		end,
		range: [start, end],
		parent
	};
	return node.expression = deserializeStringLiteral(pos + 8), parent = previousParent, node;
}
function deserializeHashbang(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "Hashbang",
		value: deserializeStr(pos + 8),
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeBlockStatement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "BlockStatement",
		body: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.body = deserializeVecStatement(pos + 8), parent = previousParent, node;
}
function deserializeDeclaration(pos) {
	switch (uint8[pos]) {
		case 32: return deserializeBoxVariableDeclaration(pos + 8);
		case 33: return deserializeBoxFunction(pos + 8);
		case 34: return deserializeBoxClass(pos + 8);
		case 35: return deserializeBoxTSTypeAliasDeclaration(pos + 8);
		case 36: return deserializeBoxTSInterfaceDeclaration(pos + 8);
		case 37: return deserializeBoxTSEnumDeclaration(pos + 8);
		case 38: return deserializeBoxTSModuleDeclaration(pos + 8);
		case 39: return deserializeBoxTSGlobalDeclaration(pos + 8);
		case 40: return deserializeBoxTSImportEqualsDeclaration(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for Declaration`);
	}
}
function deserializeVariableDeclaration(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "VariableDeclaration",
		kind: deserializeVariableDeclarationKind(pos + 32),
		declarations: null,
		declare: deserializeBool(pos + 33),
		start,
		end,
		range: [start, end],
		parent
	};
	return node.declarations = deserializeVecVariableDeclarator(pos + 8), parent = previousParent, node;
}
function deserializeVariableDeclarationKind(pos) {
	switch (uint8[pos]) {
		case 0: return "var";
		case 1: return "let";
		case 2: return "const";
		case 3: return "using";
		case 4: return "await using";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for VariableDeclarationKind`);
	}
}
function deserializeVariableDeclarator(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "VariableDeclarator",
		id: null,
		init: null,
		definite: deserializeBool(pos + 57),
		start,
		end,
		range: [start, end],
		parent
	};
	return node.id = deserializeBindingPattern(pos + 8), node.init = deserializeOptionExpression(pos + 40), parent = previousParent, node;
}
function deserializeEmptyStatement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "EmptyStatement",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeExpressionStatement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ExpressionStatement",
		expression: null,
		directive: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.expression = deserializeExpression(pos + 8), parent = previousParent, node;
}
function deserializeIfStatement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "IfStatement",
		test: null,
		consequent: null,
		alternate: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.test = deserializeExpression(pos + 8), node.consequent = deserializeStatement(pos + 24), node.alternate = deserializeOptionStatement(pos + 40), parent = previousParent, node;
}
function deserializeDoWhileStatement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "DoWhileStatement",
		body: null,
		test: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.body = deserializeStatement(pos + 8), node.test = deserializeExpression(pos + 24), parent = previousParent, node;
}
function deserializeWhileStatement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "WhileStatement",
		test: null,
		body: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.test = deserializeExpression(pos + 8), node.body = deserializeStatement(pos + 24), parent = previousParent, node;
}
function deserializeForStatement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ForStatement",
		init: null,
		test: null,
		update: null,
		body: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.init = deserializeOptionForStatementInit(pos + 8), node.test = deserializeOptionExpression(pos + 24), node.update = deserializeOptionExpression(pos + 40), node.body = deserializeStatement(pos + 56), parent = previousParent, node;
}
function deserializeForStatementInit(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxBooleanLiteral(pos + 8);
		case 1: return deserializeBoxNullLiteral(pos + 8);
		case 2: return deserializeBoxNumericLiteral(pos + 8);
		case 3: return deserializeBoxBigIntLiteral(pos + 8);
		case 4: return deserializeBoxRegExpLiteral(pos + 8);
		case 5: return deserializeBoxStringLiteral(pos + 8);
		case 6: return deserializeBoxTemplateLiteral(pos + 8);
		case 7: return deserializeBoxIdentifierReference(pos + 8);
		case 8: return deserializeBoxMetaProperty(pos + 8);
		case 9: return deserializeBoxSuper(pos + 8);
		case 10: return deserializeBoxArrayExpression(pos + 8);
		case 11: return deserializeBoxArrowFunctionExpression(pos + 8);
		case 12: return deserializeBoxAssignmentExpression(pos + 8);
		case 13: return deserializeBoxAwaitExpression(pos + 8);
		case 14: return deserializeBoxBinaryExpression(pos + 8);
		case 15: return deserializeBoxCallExpression(pos + 8);
		case 16: return deserializeBoxChainExpression(pos + 8);
		case 17: return deserializeBoxClass(pos + 8);
		case 18: return deserializeBoxConditionalExpression(pos + 8);
		case 19: return deserializeBoxFunction(pos + 8);
		case 20: return deserializeBoxImportExpression(pos + 8);
		case 21: return deserializeBoxLogicalExpression(pos + 8);
		case 22: return deserializeBoxNewExpression(pos + 8);
		case 23: return deserializeBoxObjectExpression(pos + 8);
		case 24: return deserializeBoxParenthesizedExpression(pos + 8);
		case 25: return deserializeBoxSequenceExpression(pos + 8);
		case 26: return deserializeBoxTaggedTemplateExpression(pos + 8);
		case 27: return deserializeBoxThisExpression(pos + 8);
		case 28: return deserializeBoxUnaryExpression(pos + 8);
		case 29: return deserializeBoxUpdateExpression(pos + 8);
		case 30: return deserializeBoxYieldExpression(pos + 8);
		case 31: return deserializeBoxPrivateInExpression(pos + 8);
		case 32: return deserializeBoxJSXElement(pos + 8);
		case 33: return deserializeBoxJSXFragment(pos + 8);
		case 34: return deserializeBoxTSAsExpression(pos + 8);
		case 35: return deserializeBoxTSSatisfiesExpression(pos + 8);
		case 36: return deserializeBoxTSTypeAssertion(pos + 8);
		case 37: return deserializeBoxTSNonNullExpression(pos + 8);
		case 38: return deserializeBoxTSInstantiationExpression(pos + 8);
		case 39: return deserializeBoxV8IntrinsicExpression(pos + 8);
		case 48: return deserializeBoxComputedMemberExpression(pos + 8);
		case 49: return deserializeBoxStaticMemberExpression(pos + 8);
		case 50: return deserializeBoxPrivateFieldExpression(pos + 8);
		case 64: return deserializeBoxVariableDeclaration(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for ForStatementInit`);
	}
}
function deserializeForInStatement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ForInStatement",
		left: null,
		right: null,
		body: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.left = deserializeForStatementLeft(pos + 8), node.right = deserializeExpression(pos + 24), node.body = deserializeStatement(pos + 40), parent = previousParent, node;
}
function deserializeForStatementLeft(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxIdentifierReference(pos + 8);
		case 1: return deserializeBoxTSAsExpression(pos + 8);
		case 2: return deserializeBoxTSSatisfiesExpression(pos + 8);
		case 3: return deserializeBoxTSNonNullExpression(pos + 8);
		case 4: return deserializeBoxTSTypeAssertion(pos + 8);
		case 8: return deserializeBoxArrayAssignmentTarget(pos + 8);
		case 9: return deserializeBoxObjectAssignmentTarget(pos + 8);
		case 16: return deserializeBoxVariableDeclaration(pos + 8);
		case 48: return deserializeBoxComputedMemberExpression(pos + 8);
		case 49: return deserializeBoxStaticMemberExpression(pos + 8);
		case 50: return deserializeBoxPrivateFieldExpression(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for ForStatementLeft`);
	}
}
function deserializeForOfStatement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ForOfStatement",
		await: deserializeBool(pos + 60),
		left: null,
		right: null,
		body: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.left = deserializeForStatementLeft(pos + 8), node.right = deserializeExpression(pos + 24), node.body = deserializeStatement(pos + 40), parent = previousParent, node;
}
function deserializeContinueStatement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ContinueStatement",
		label: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.label = deserializeOptionLabelIdentifier(pos + 8), parent = previousParent, node;
}
function deserializeBreakStatement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "BreakStatement",
		label: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.label = deserializeOptionLabelIdentifier(pos + 8), parent = previousParent, node;
}
function deserializeReturnStatement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ReturnStatement",
		argument: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.argument = deserializeOptionExpression(pos + 8), parent = previousParent, node;
}
function deserializeWithStatement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "WithStatement",
		object: null,
		body: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.object = deserializeExpression(pos + 8), node.body = deserializeStatement(pos + 24), parent = previousParent, node;
}
function deserializeSwitchStatement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "SwitchStatement",
		discriminant: null,
		cases: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.discriminant = deserializeExpression(pos + 8), node.cases = deserializeVecSwitchCase(pos + 24), parent = previousParent, node;
}
function deserializeSwitchCase(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "SwitchCase",
		test: null,
		consequent: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.test = deserializeOptionExpression(pos + 8), node.consequent = deserializeVecStatement(pos + 24), parent = previousParent, node;
}
function deserializeLabeledStatement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "LabeledStatement",
		label: null,
		body: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.label = deserializeLabelIdentifier(pos + 8), node.body = deserializeStatement(pos + 32), parent = previousParent, node;
}
function deserializeThrowStatement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ThrowStatement",
		argument: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.argument = deserializeExpression(pos + 8), parent = previousParent, node;
}
function deserializeTryStatement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TryStatement",
		block: null,
		handler: null,
		finalizer: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.block = deserializeBoxBlockStatement(pos + 8), node.handler = deserializeOptionBoxCatchClause(pos + 16), node.finalizer = deserializeOptionBoxBlockStatement(pos + 24), parent = previousParent, node;
}
function deserializeCatchClause(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "CatchClause",
		param: null,
		body: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.param = deserializeOptionCatchParameter(pos + 8), node.body = deserializeBoxBlockStatement(pos + 48), parent = previousParent, node;
}
function deserializeCatchParameter(pos) {
	return deserializeBindingPattern(pos + 8);
}
function deserializeDebuggerStatement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "DebuggerStatement",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeBindingPattern(pos) {
	let pattern = deserializeBindingPatternKind(pos);
	{
		let previousParent = parent;
		parent = pattern, pattern.optional = deserializeBool(pos + 24), pattern.typeAnnotation = deserializeOptionBoxTSTypeAnnotation(pos + 16), parent = previousParent;
	}
	return pattern;
}
function deserializeBindingPatternKind(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxBindingIdentifier(pos + 8);
		case 1: return deserializeBoxObjectPattern(pos + 8);
		case 2: return deserializeBoxArrayPattern(pos + 8);
		case 3: return deserializeBoxAssignmentPattern(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for BindingPatternKind`);
	}
}
function deserializeAssignmentPattern(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "AssignmentPattern",
		decorators: null,
		left: null,
		right: null,
		optional: null,
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.decorators = [], node.left = deserializeBindingPattern(pos + 8), node.right = deserializeExpression(pos + 40), node.optional = !1, parent = previousParent, node;
}
function deserializeObjectPattern(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ObjectPattern",
		decorators: null,
		properties: null,
		optional: null,
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	}, properties = deserializeVecBindingProperty(pos + 8), rest = deserializeOptionBoxBindingRestElement(pos + 32);
	return rest !== null && properties.push(rest), node.decorators = [], node.properties = properties, node.optional = !1, parent = previousParent, node;
}
function deserializeBindingProperty(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "Property",
		kind: null,
		key: null,
		value: null,
		method: null,
		shorthand: deserializeBool(pos + 56),
		computed: deserializeBool(pos + 57),
		optional: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.kind = "init", node.key = deserializePropertyKey(pos + 8), node.value = deserializeBindingPattern(pos + 24), node.method = !1, node.optional = !1, parent = previousParent, node;
}
function deserializeArrayPattern(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ArrayPattern",
		decorators: null,
		elements: null,
		optional: null,
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	}, elements = deserializeVecOptionBindingPattern(pos + 8), rest = deserializeOptionBoxBindingRestElement(pos + 32);
	return rest !== null && elements.push(rest), node.decorators = [], node.elements = elements, node.optional = !1, parent = previousParent, node;
}
function deserializeBindingRestElement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "RestElement",
		decorators: null,
		argument: null,
		optional: null,
		typeAnnotation: null,
		value: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.decorators = [], node.argument = deserializeBindingPattern(pos + 8), node.optional = !1, parent = previousParent, node;
}
function deserializeFunction(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: deserializeFunctionType(pos + 84),
		id: null,
		generator: deserializeBool(pos + 85),
		async: deserializeBool(pos + 86),
		declare: deserializeBool(pos + 87),
		typeParameters: null,
		params: null,
		returnType: null,
		body: null,
		expression: null,
		start,
		end,
		range: [start, end],
		parent
	}, params = deserializeBoxFormalParameters(pos + 56);
	{
		let thisParam = deserializeOptionBoxTSThisParameter(pos + 48);
		thisParam !== null && params.unshift(thisParam);
	}
	return node.id = deserializeOptionBindingIdentifier(pos + 8), node.typeParameters = deserializeOptionBoxTSTypeParameterDeclaration(pos + 40), node.params = params, node.returnType = deserializeOptionBoxTSTypeAnnotation(pos + 64), node.body = deserializeOptionBoxFunctionBody(pos + 72), node.expression = !1, parent = previousParent, node;
}
function deserializeFunctionType(pos) {
	switch (uint8[pos]) {
		case 0: return "FunctionDeclaration";
		case 1: return "FunctionExpression";
		case 2: return "TSDeclareFunction";
		case 3: return "TSEmptyBodyFunctionExpression";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for FunctionType`);
	}
}
function deserializeFormalParameters(pos) {
	let params = deserializeVecFormalParameter(pos + 8);
	if (uint32[pos + 32 >> 2] !== 0 && uint32[pos + 36 >> 2] !== 0) {
		pos = uint32[pos + 32 >> 2];
		let start, end, previousParent = parent, rest = parent = {
			__proto__: NodeProto,
			type: "RestElement",
			decorators: [],
			argument: null,
			optional: deserializeBool(pos + 32),
			typeAnnotation: null,
			value: null,
			start: start = deserializeU32(pos),
			end: end = deserializeU32(pos + 4),
			range: [start, end],
			parent
		};
		rest.argument = deserializeBindingPatternKind(pos + 8), rest.typeAnnotation = deserializeOptionBoxTSTypeAnnotation(pos + 24), params.push(rest), parent = previousParent;
	}
	return params;
}
function deserializeFormalParameter(pos) {
	let param;
	{
		let accessibility = deserializeOptionTSAccessibility(pos + 64), readonly = deserializeBool(pos + 65), override = deserializeBool(pos + 66), previousParent = parent;
		if (accessibility === null && !readonly && !override) param = parent = deserializeBindingPatternKind(pos + 32), param.decorators = deserializeVecDecorator(pos + 8), param.optional = deserializeBool(pos + 56), param.typeAnnotation = deserializeOptionBoxTSTypeAnnotation(pos + 48);
		else {
			let start, end;
			param = parent = {
				__proto__: NodeProto,
				type: "TSParameterProperty",
				accessibility,
				decorators: null,
				override,
				parameter: null,
				readonly,
				static: !1,
				start: start = deserializeU32(pos),
				end: end = deserializeU32(pos + 4),
				range: [start, end],
				parent
			}, param.decorators = deserializeVecDecorator(pos + 8), param.parameter = deserializeBindingPattern(pos + 32);
		}
		parent = previousParent;
	}
	return param;
}
function deserializeFunctionBody(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "BlockStatement",
		body: null,
		start,
		end,
		range: [start, end],
		parent
	}, body = deserializeVecDirective(pos + 8);
	return body.push(...deserializeVecStatement(pos + 32)), node.body = body, parent = previousParent, node;
}
function deserializeArrowFunctionExpression(pos) {
	let expression = deserializeBool(pos + 44), start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ArrowFunctionExpression",
		expression,
		async: deserializeBool(pos + 45),
		typeParameters: null,
		params: null,
		returnType: null,
		body: null,
		id: null,
		generator: null,
		start,
		end,
		range: [start, end],
		parent
	}, body = deserializeBoxFunctionBody(pos + 32);
	return expression === !0 && (body = body.body[0].expression, body.parent = parent), node.typeParameters = deserializeOptionBoxTSTypeParameterDeclaration(pos + 8), node.params = deserializeBoxFormalParameters(pos + 16), node.returnType = deserializeOptionBoxTSTypeAnnotation(pos + 24), node.body = body, node.generator = !1, parent = previousParent, node;
}
function deserializeYieldExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "YieldExpression",
		delegate: deserializeBool(pos + 24),
		argument: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.argument = deserializeOptionExpression(pos + 8), parent = previousParent, node;
}
function deserializeClass(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: deserializeClassType(pos + 132),
		decorators: null,
		id: null,
		typeParameters: null,
		superClass: null,
		superTypeArguments: null,
		implements: null,
		body: null,
		abstract: deserializeBool(pos + 133),
		declare: deserializeBool(pos + 134),
		start,
		end,
		range: [start, end],
		parent
	};
	return node.decorators = deserializeVecDecorator(pos + 8), node.id = deserializeOptionBindingIdentifier(pos + 32), node.typeParameters = deserializeOptionBoxTSTypeParameterDeclaration(pos + 64), node.superClass = deserializeOptionExpression(pos + 72), node.superTypeArguments = deserializeOptionBoxTSTypeParameterInstantiation(pos + 88), node.implements = deserializeVecTSClassImplements(pos + 96), node.body = deserializeBoxClassBody(pos + 120), parent = previousParent, node;
}
function deserializeClassType(pos) {
	switch (uint8[pos]) {
		case 0: return "ClassDeclaration";
		case 1: return "ClassExpression";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for ClassType`);
	}
}
function deserializeClassBody(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ClassBody",
		body: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.body = deserializeVecClassElement(pos + 8), parent = previousParent, node;
}
function deserializeClassElement(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxStaticBlock(pos + 8);
		case 1: return deserializeBoxMethodDefinition(pos + 8);
		case 2: return deserializeBoxPropertyDefinition(pos + 8);
		case 3: return deserializeBoxAccessorProperty(pos + 8);
		case 4: return deserializeBoxTSIndexSignature(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for ClassElement`);
	}
}
function deserializeMethodDefinition(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: deserializeMethodDefinitionType(pos + 56),
		decorators: null,
		key: null,
		value: null,
		kind: deserializeMethodDefinitionKind(pos + 57),
		computed: deserializeBool(pos + 58),
		static: deserializeBool(pos + 59),
		override: deserializeBool(pos + 60),
		optional: deserializeBool(pos + 61),
		accessibility: deserializeOptionTSAccessibility(pos + 62),
		start,
		end,
		range: [start, end],
		parent
	};
	return node.decorators = deserializeVecDecorator(pos + 8), node.key = deserializePropertyKey(pos + 32), node.value = deserializeBoxFunction(pos + 48), parent = previousParent, node;
}
function deserializeMethodDefinitionType(pos) {
	switch (uint8[pos]) {
		case 0: return "MethodDefinition";
		case 1: return "TSAbstractMethodDefinition";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for MethodDefinitionType`);
	}
}
function deserializePropertyDefinition(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: deserializePropertyDefinitionType(pos + 72),
		decorators: null,
		key: null,
		typeAnnotation: null,
		value: null,
		computed: deserializeBool(pos + 73),
		static: deserializeBool(pos + 74),
		declare: deserializeBool(pos + 75),
		override: deserializeBool(pos + 76),
		optional: deserializeBool(pos + 77),
		definite: deserializeBool(pos + 78),
		readonly: deserializeBool(pos + 79),
		accessibility: deserializeOptionTSAccessibility(pos + 80),
		start,
		end,
		range: [start, end],
		parent
	};
	return node.decorators = deserializeVecDecorator(pos + 8), node.key = deserializePropertyKey(pos + 32), node.typeAnnotation = deserializeOptionBoxTSTypeAnnotation(pos + 48), node.value = deserializeOptionExpression(pos + 56), parent = previousParent, node;
}
function deserializePropertyDefinitionType(pos) {
	switch (uint8[pos]) {
		case 0: return "PropertyDefinition";
		case 1: return "TSAbstractPropertyDefinition";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for PropertyDefinitionType`);
	}
}
function deserializeMethodDefinitionKind(pos) {
	switch (uint8[pos]) {
		case 0: return "constructor";
		case 1: return "method";
		case 2: return "get";
		case 3: return "set";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for MethodDefinitionKind`);
	}
}
function deserializePrivateIdentifier(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "PrivateIdentifier",
		name: deserializeStr(pos + 8),
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeStaticBlock(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "StaticBlock",
		body: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.body = deserializeVecStatement(pos + 8), parent = previousParent, node;
}
function deserializeAccessorPropertyType(pos) {
	switch (uint8[pos]) {
		case 0: return "AccessorProperty";
		case 1: return "TSAbstractAccessorProperty";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for AccessorPropertyType`);
	}
}
function deserializeAccessorProperty(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: deserializeAccessorPropertyType(pos + 72),
		decorators: null,
		key: null,
		typeAnnotation: null,
		value: null,
		computed: deserializeBool(pos + 73),
		static: deserializeBool(pos + 74),
		override: deserializeBool(pos + 75),
		definite: deserializeBool(pos + 76),
		accessibility: deserializeOptionTSAccessibility(pos + 77),
		declare: null,
		optional: null,
		readonly: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.decorators = deserializeVecDecorator(pos + 8), node.key = deserializePropertyKey(pos + 32), node.typeAnnotation = deserializeOptionBoxTSTypeAnnotation(pos + 48), node.value = deserializeOptionExpression(pos + 56), node.declare = !1, node.optional = !1, node.readonly = !1, parent = previousParent, node;
}
function deserializeImportExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ImportExpression",
		source: null,
		options: null,
		phase: deserializeOptionImportPhase(pos + 40),
		start,
		end,
		range: [start, end],
		parent
	};
	return node.source = deserializeExpression(pos + 8), node.options = deserializeOptionExpression(pos + 24), parent = previousParent, node;
}
function deserializeImportDeclaration(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ImportDeclaration",
		specifiers: null,
		source: null,
		phase: deserializeOptionImportPhase(pos + 88),
		attributes: null,
		importKind: deserializeImportOrExportKind(pos + 89),
		start,
		end,
		range: [start, end],
		parent
	}, specifiers = deserializeOptionVecImportDeclarationSpecifier(pos + 8);
	specifiers === null && (specifiers = []);
	let withClause = deserializeOptionBoxWithClause(pos + 80);
	return node.specifiers = specifiers, node.source = deserializeStringLiteral(pos + 32), node.attributes = withClause === null ? [] : withClause.attributes, parent = previousParent, node;
}
function deserializeImportPhase(pos) {
	switch (uint8[pos]) {
		case 0: return "source";
		case 1: return "defer";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for ImportPhase`);
	}
}
function deserializeImportDeclarationSpecifier(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxImportSpecifier(pos + 8);
		case 1: return deserializeBoxImportDefaultSpecifier(pos + 8);
		case 2: return deserializeBoxImportNamespaceSpecifier(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for ImportDeclarationSpecifier`);
	}
}
function deserializeImportSpecifier(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ImportSpecifier",
		imported: null,
		local: null,
		importKind: deserializeImportOrExportKind(pos + 96),
		start,
		end,
		range: [start, end],
		parent
	};
	return node.imported = deserializeModuleExportName(pos + 8), node.local = deserializeBindingIdentifier(pos + 64), parent = previousParent, node;
}
function deserializeImportDefaultSpecifier(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ImportDefaultSpecifier",
		local: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.local = deserializeBindingIdentifier(pos + 8), parent = previousParent, node;
}
function deserializeImportNamespaceSpecifier(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ImportNamespaceSpecifier",
		local: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.local = deserializeBindingIdentifier(pos + 8), parent = previousParent, node;
}
function deserializeWithClause(pos) {
	return { attributes: deserializeVecImportAttribute(pos + 8) };
}
function deserializeImportAttribute(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ImportAttribute",
		key: null,
		value: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.key = deserializeImportAttributeKey(pos + 8), node.value = deserializeStringLiteral(pos + 64), parent = previousParent, node;
}
function deserializeImportAttributeKey(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeIdentifierName(pos + 8);
		case 1: return deserializeStringLiteral(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for ImportAttributeKey`);
	}
}
function deserializeExportNamedDeclaration(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ExportNamedDeclaration",
		declaration: null,
		specifiers: null,
		source: null,
		exportKind: deserializeImportOrExportKind(pos + 104),
		attributes: null,
		start,
		end,
		range: [start, end],
		parent
	}, withClause = deserializeOptionBoxWithClause(pos + 96);
	return node.declaration = deserializeOptionDeclaration(pos + 8), node.specifiers = deserializeVecExportSpecifier(pos + 24), node.source = deserializeOptionStringLiteral(pos + 48), node.attributes = withClause === null ? [] : withClause.attributes, parent = previousParent, node;
}
function deserializeExportDefaultDeclaration(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ExportDefaultDeclaration",
		declaration: null,
		exportKind: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.declaration = deserializeExportDefaultDeclarationKind(pos + 8), node.exportKind = "value", parent = previousParent, node;
}
function deserializeExportAllDeclaration(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ExportAllDeclaration",
		exported: null,
		source: null,
		attributes: null,
		exportKind: deserializeImportOrExportKind(pos + 120),
		start,
		end,
		range: [start, end],
		parent
	}, withClause = deserializeOptionBoxWithClause(pos + 112);
	return node.exported = deserializeOptionModuleExportName(pos + 8), node.source = deserializeStringLiteral(pos + 64), node.attributes = withClause === null ? [] : withClause.attributes, parent = previousParent, node;
}
function deserializeExportSpecifier(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "ExportSpecifier",
		local: null,
		exported: null,
		exportKind: deserializeImportOrExportKind(pos + 120),
		start,
		end,
		range: [start, end],
		parent
	};
	return node.local = deserializeModuleExportName(pos + 8), node.exported = deserializeModuleExportName(pos + 64), parent = previousParent, node;
}
function deserializeExportDefaultDeclarationKind(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxBooleanLiteral(pos + 8);
		case 1: return deserializeBoxNullLiteral(pos + 8);
		case 2: return deserializeBoxNumericLiteral(pos + 8);
		case 3: return deserializeBoxBigIntLiteral(pos + 8);
		case 4: return deserializeBoxRegExpLiteral(pos + 8);
		case 5: return deserializeBoxStringLiteral(pos + 8);
		case 6: return deserializeBoxTemplateLiteral(pos + 8);
		case 7: return deserializeBoxIdentifierReference(pos + 8);
		case 8: return deserializeBoxMetaProperty(pos + 8);
		case 9: return deserializeBoxSuper(pos + 8);
		case 10: return deserializeBoxArrayExpression(pos + 8);
		case 11: return deserializeBoxArrowFunctionExpression(pos + 8);
		case 12: return deserializeBoxAssignmentExpression(pos + 8);
		case 13: return deserializeBoxAwaitExpression(pos + 8);
		case 14: return deserializeBoxBinaryExpression(pos + 8);
		case 15: return deserializeBoxCallExpression(pos + 8);
		case 16: return deserializeBoxChainExpression(pos + 8);
		case 17: return deserializeBoxClass(pos + 8);
		case 18: return deserializeBoxConditionalExpression(pos + 8);
		case 19: return deserializeBoxFunction(pos + 8);
		case 20: return deserializeBoxImportExpression(pos + 8);
		case 21: return deserializeBoxLogicalExpression(pos + 8);
		case 22: return deserializeBoxNewExpression(pos + 8);
		case 23: return deserializeBoxObjectExpression(pos + 8);
		case 24: return deserializeBoxParenthesizedExpression(pos + 8);
		case 25: return deserializeBoxSequenceExpression(pos + 8);
		case 26: return deserializeBoxTaggedTemplateExpression(pos + 8);
		case 27: return deserializeBoxThisExpression(pos + 8);
		case 28: return deserializeBoxUnaryExpression(pos + 8);
		case 29: return deserializeBoxUpdateExpression(pos + 8);
		case 30: return deserializeBoxYieldExpression(pos + 8);
		case 31: return deserializeBoxPrivateInExpression(pos + 8);
		case 32: return deserializeBoxJSXElement(pos + 8);
		case 33: return deserializeBoxJSXFragment(pos + 8);
		case 34: return deserializeBoxTSAsExpression(pos + 8);
		case 35: return deserializeBoxTSSatisfiesExpression(pos + 8);
		case 36: return deserializeBoxTSTypeAssertion(pos + 8);
		case 37: return deserializeBoxTSNonNullExpression(pos + 8);
		case 38: return deserializeBoxTSInstantiationExpression(pos + 8);
		case 39: return deserializeBoxV8IntrinsicExpression(pos + 8);
		case 48: return deserializeBoxComputedMemberExpression(pos + 8);
		case 49: return deserializeBoxStaticMemberExpression(pos + 8);
		case 50: return deserializeBoxPrivateFieldExpression(pos + 8);
		case 64: return deserializeBoxFunction(pos + 8);
		case 65: return deserializeBoxClass(pos + 8);
		case 66: return deserializeBoxTSInterfaceDeclaration(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for ExportDefaultDeclarationKind`);
	}
}
function deserializeModuleExportName(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeIdentifierName(pos + 8);
		case 1: return deserializeIdentifierReference(pos + 8);
		case 2: return deserializeStringLiteral(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for ModuleExportName`);
	}
}
function deserializeV8IntrinsicExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "V8IntrinsicExpression",
		name: null,
		arguments: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.name = deserializeIdentifierName(pos + 8), node.arguments = deserializeVecArgument(pos + 32), parent = previousParent, node;
}
function deserializeBooleanLiteral(pos) {
	let value = deserializeBool(pos + 8), start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "Literal",
		value,
		raw: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.raw = start === 0 && end === 0 ? null : value + "", parent = previousParent, node;
}
function deserializeNullLiteral(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "Literal",
		value: null,
		raw: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.raw = start === 0 && end === 0 ? null : "null", parent = previousParent, node;
}
function deserializeNumericLiteral(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "Literal",
		value: deserializeF64(pos + 8),
		raw: deserializeOptionStr(pos + 16),
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeStringLiteral(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "Literal",
		value: null,
		raw: deserializeOptionStr(pos + 24),
		start,
		end,
		range: [start, end],
		parent
	}, value = deserializeStr(pos + 8);
	return deserializeBool(pos + 40) && (value = value.replace(/\uFFFD(.{4})/g, (_, hex) => String.fromCodePoint(parseInt(hex, 16)))), node.value = value, parent = previousParent, node;
}
function deserializeBigIntLiteral(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "Literal",
		value: null,
		raw: deserializeOptionStr(pos + 24),
		bigint: null,
		start,
		end,
		range: [start, end],
		parent
	}, bigint = deserializeStr(pos + 8);
	return node.value = BigInt(bigint), node.bigint = bigint, parent = previousParent, node;
}
function deserializeRegExpLiteral(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "Literal",
		value: null,
		raw: deserializeOptionStr(pos + 40),
		regex: null,
		start,
		end,
		range: [start, end],
		parent
	}, regex = deserializeRegExp(pos + 8), value = null;
	try {
		value = new RegExp(regex.pattern, regex.flags);
	} catch {}
	return node.value = value, node.regex = regex, parent = previousParent, node;
}
function deserializeRegExp(pos) {
	return {
		pattern: deserializeStr(pos),
		flags: deserializeRegExpFlags(pos + 24)
	};
}
function deserializeRegExpFlags(pos) {
	let flagBits = deserializeU8(pos), flags = "";
	return flagBits & 64 && (flags += "d"), flagBits & 1 && (flags += "g"), flagBits & 2 && (flags += "i"), flagBits & 4 && (flags += "m"), flagBits & 8 && (flags += "s"), flagBits & 16 && (flags += "u"), flagBits & 128 && (flags += "v"), flagBits & 32 && (flags += "y"), flags;
}
function deserializeJSXElement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "JSXElement",
		openingElement: null,
		children: null,
		closingElement: null,
		start,
		end,
		range: [start, end],
		parent
	}, closingElement = deserializeOptionBoxJSXClosingElement(pos + 40), openingElement = deserializeBoxJSXOpeningElement(pos + 8);
	return closingElement === null && (openingElement.selfClosing = !0), node.openingElement = openingElement, node.children = deserializeVecJSXChild(pos + 16), node.closingElement = closingElement, parent = previousParent, node;
}
function deserializeJSXOpeningElement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "JSXOpeningElement",
		name: null,
		typeArguments: null,
		attributes: null,
		selfClosing: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.name = deserializeJSXElementName(pos + 8), node.typeArguments = deserializeOptionBoxTSTypeParameterInstantiation(pos + 24), node.attributes = deserializeVecJSXAttributeItem(pos + 32), node.selfClosing = !1, parent = previousParent, node;
}
function deserializeJSXClosingElement(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "JSXClosingElement",
		name: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.name = deserializeJSXElementName(pos + 8), parent = previousParent, node;
}
function deserializeJSXFragment(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "JSXFragment",
		openingFragment: null,
		children: null,
		closingFragment: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.openingFragment = deserializeJSXOpeningFragment(pos + 8), node.children = deserializeVecJSXChild(pos + 16), node.closingFragment = deserializeJSXClosingFragment(pos + 40), parent = previousParent, node;
}
function deserializeJSXOpeningFragment(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "JSXOpeningFragment",
		start,
		end,
		range: [start, end],
		parent
	};
	return parent = previousParent, node;
}
function deserializeJSXClosingFragment(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "JSXClosingFragment",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeJSXElementName(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxJSXIdentifier(pos + 8);
		case 1:
			let ident = deserializeBoxIdentifierReference(pos + 8);
			return {
				__proto__: NodeProto,
				type: "JSXIdentifier",
				name: ident.name,
				start: ident.start,
				end: ident.end,
				range: ident.range,
				parent
			};
		case 2: return deserializeBoxJSXNamespacedName(pos + 8);
		case 3: return deserializeBoxJSXMemberExpression(pos + 8);
		case 4:
			let thisExpr = deserializeBoxThisExpression(pos + 8);
			return {
				__proto__: NodeProto,
				type: "JSXIdentifier",
				name: "this",
				start: thisExpr.start,
				end: thisExpr.end,
				range: thisExpr.range,
				parent
			};
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for JSXElementName`);
	}
}
function deserializeJSXNamespacedName(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "JSXNamespacedName",
		namespace: null,
		name: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.namespace = deserializeJSXIdentifier(pos + 8), node.name = deserializeJSXIdentifier(pos + 32), parent = previousParent, node;
}
function deserializeJSXMemberExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "JSXMemberExpression",
		object: null,
		property: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.object = deserializeJSXMemberExpressionObject(pos + 8), node.property = deserializeJSXIdentifier(pos + 24), parent = previousParent, node;
}
function deserializeJSXMemberExpressionObject(pos) {
	switch (uint8[pos]) {
		case 0:
			let ident = deserializeBoxIdentifierReference(pos + 8);
			return {
				__proto__: NodeProto,
				type: "JSXIdentifier",
				name: ident.name,
				start: ident.start,
				end: ident.end,
				range: ident.range,
				parent
			};
		case 1: return deserializeBoxJSXMemberExpression(pos + 8);
		case 2:
			let thisExpr = deserializeBoxThisExpression(pos + 8);
			return {
				__proto__: NodeProto,
				type: "JSXIdentifier",
				name: "this",
				start: thisExpr.start,
				end: thisExpr.end,
				range: thisExpr.range,
				parent
			};
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for JSXMemberExpressionObject`);
	}
}
function deserializeJSXExpressionContainer(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "JSXExpressionContainer",
		expression: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.expression = deserializeJSXExpression(pos + 8), parent = previousParent, node;
}
function deserializeJSXExpression(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxBooleanLiteral(pos + 8);
		case 1: return deserializeBoxNullLiteral(pos + 8);
		case 2: return deserializeBoxNumericLiteral(pos + 8);
		case 3: return deserializeBoxBigIntLiteral(pos + 8);
		case 4: return deserializeBoxRegExpLiteral(pos + 8);
		case 5: return deserializeBoxStringLiteral(pos + 8);
		case 6: return deserializeBoxTemplateLiteral(pos + 8);
		case 7: return deserializeBoxIdentifierReference(pos + 8);
		case 8: return deserializeBoxMetaProperty(pos + 8);
		case 9: return deserializeBoxSuper(pos + 8);
		case 10: return deserializeBoxArrayExpression(pos + 8);
		case 11: return deserializeBoxArrowFunctionExpression(pos + 8);
		case 12: return deserializeBoxAssignmentExpression(pos + 8);
		case 13: return deserializeBoxAwaitExpression(pos + 8);
		case 14: return deserializeBoxBinaryExpression(pos + 8);
		case 15: return deserializeBoxCallExpression(pos + 8);
		case 16: return deserializeBoxChainExpression(pos + 8);
		case 17: return deserializeBoxClass(pos + 8);
		case 18: return deserializeBoxConditionalExpression(pos + 8);
		case 19: return deserializeBoxFunction(pos + 8);
		case 20: return deserializeBoxImportExpression(pos + 8);
		case 21: return deserializeBoxLogicalExpression(pos + 8);
		case 22: return deserializeBoxNewExpression(pos + 8);
		case 23: return deserializeBoxObjectExpression(pos + 8);
		case 24: return deserializeBoxParenthesizedExpression(pos + 8);
		case 25: return deserializeBoxSequenceExpression(pos + 8);
		case 26: return deserializeBoxTaggedTemplateExpression(pos + 8);
		case 27: return deserializeBoxThisExpression(pos + 8);
		case 28: return deserializeBoxUnaryExpression(pos + 8);
		case 29: return deserializeBoxUpdateExpression(pos + 8);
		case 30: return deserializeBoxYieldExpression(pos + 8);
		case 31: return deserializeBoxPrivateInExpression(pos + 8);
		case 32: return deserializeBoxJSXElement(pos + 8);
		case 33: return deserializeBoxJSXFragment(pos + 8);
		case 34: return deserializeBoxTSAsExpression(pos + 8);
		case 35: return deserializeBoxTSSatisfiesExpression(pos + 8);
		case 36: return deserializeBoxTSTypeAssertion(pos + 8);
		case 37: return deserializeBoxTSNonNullExpression(pos + 8);
		case 38: return deserializeBoxTSInstantiationExpression(pos + 8);
		case 39: return deserializeBoxV8IntrinsicExpression(pos + 8);
		case 48: return deserializeBoxComputedMemberExpression(pos + 8);
		case 49: return deserializeBoxStaticMemberExpression(pos + 8);
		case 50: return deserializeBoxPrivateFieldExpression(pos + 8);
		case 64: return deserializeJSXEmptyExpression(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for JSXExpression`);
	}
}
function deserializeJSXEmptyExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "JSXEmptyExpression",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeJSXAttributeItem(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxJSXAttribute(pos + 8);
		case 1: return deserializeBoxJSXSpreadAttribute(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for JSXAttributeItem`);
	}
}
function deserializeJSXAttribute(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "JSXAttribute",
		name: null,
		value: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.name = deserializeJSXAttributeName(pos + 8), node.value = deserializeOptionJSXAttributeValue(pos + 24), parent = previousParent, node;
}
function deserializeJSXSpreadAttribute(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "JSXSpreadAttribute",
		argument: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.argument = deserializeExpression(pos + 8), parent = previousParent, node;
}
function deserializeJSXAttributeName(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxJSXIdentifier(pos + 8);
		case 1: return deserializeBoxJSXNamespacedName(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for JSXAttributeName`);
	}
}
function deserializeJSXAttributeValue(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxStringLiteral(pos + 8);
		case 1: return deserializeBoxJSXExpressionContainer(pos + 8);
		case 2: return deserializeBoxJSXElement(pos + 8);
		case 3: return deserializeBoxJSXFragment(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for JSXAttributeValue`);
	}
}
function deserializeJSXIdentifier(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "JSXIdentifier",
		name: deserializeStr(pos + 8),
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeJSXChild(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxJSXText(pos + 8);
		case 1: return deserializeBoxJSXElement(pos + 8);
		case 2: return deserializeBoxJSXFragment(pos + 8);
		case 3: return deserializeBoxJSXExpressionContainer(pos + 8);
		case 4: return deserializeBoxJSXSpreadChild(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for JSXChild`);
	}
}
function deserializeJSXSpreadChild(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "JSXSpreadChild",
		expression: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.expression = deserializeExpression(pos + 8), parent = previousParent, node;
}
function deserializeJSXText(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "JSXText",
		value: deserializeStr(pos + 8),
		raw: deserializeOptionStr(pos + 24),
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeTSThisParameter(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "Identifier",
		decorators: null,
		name: null,
		optional: null,
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.decorators = [], node.name = "this", node.optional = !1, node.typeAnnotation = deserializeOptionBoxTSTypeAnnotation(pos + 16), parent = previousParent, node;
}
function deserializeTSEnumDeclaration(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSEnumDeclaration",
		id: null,
		body: null,
		const: deserializeBool(pos + 76),
		declare: deserializeBool(pos + 77),
		start,
		end,
		range: [start, end],
		parent
	};
	return node.id = deserializeBindingIdentifier(pos + 8), node.body = deserializeTSEnumBody(pos + 40), parent = previousParent, node;
}
function deserializeTSEnumBody(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSEnumBody",
		members: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.members = deserializeVecTSEnumMember(pos + 8), parent = previousParent, node;
}
function deserializeTSEnumMember(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSEnumMember",
		id: null,
		initializer: null,
		computed: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.id = deserializeTSEnumMemberName(pos + 8), node.initializer = deserializeOptionExpression(pos + 24), node.computed = deserializeU8(pos + 8) > 1, parent = previousParent, node;
}
function deserializeTSEnumMemberName(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxIdentifierName(pos + 8);
		case 1: return deserializeBoxStringLiteral(pos + 8);
		case 2: return deserializeBoxStringLiteral(pos + 8);
		case 3: return deserializeBoxTemplateLiteral(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for TSEnumMemberName`);
	}
}
function deserializeTSTypeAnnotation(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSTypeAnnotation",
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.typeAnnotation = deserializeTSType(pos + 8), parent = previousParent, node;
}
function deserializeTSLiteralType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSLiteralType",
		literal: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.literal = deserializeTSLiteral(pos + 8), parent = previousParent, node;
}
function deserializeTSLiteral(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxBooleanLiteral(pos + 8);
		case 1: return deserializeBoxNumericLiteral(pos + 8);
		case 2: return deserializeBoxBigIntLiteral(pos + 8);
		case 3: return deserializeBoxStringLiteral(pos + 8);
		case 4: return deserializeBoxTemplateLiteral(pos + 8);
		case 5: return deserializeBoxUnaryExpression(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for TSLiteral`);
	}
}
function deserializeTSType(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxTSAnyKeyword(pos + 8);
		case 1: return deserializeBoxTSBigIntKeyword(pos + 8);
		case 2: return deserializeBoxTSBooleanKeyword(pos + 8);
		case 3: return deserializeBoxTSIntrinsicKeyword(pos + 8);
		case 4: return deserializeBoxTSNeverKeyword(pos + 8);
		case 5: return deserializeBoxTSNullKeyword(pos + 8);
		case 6: return deserializeBoxTSNumberKeyword(pos + 8);
		case 7: return deserializeBoxTSObjectKeyword(pos + 8);
		case 8: return deserializeBoxTSStringKeyword(pos + 8);
		case 9: return deserializeBoxTSSymbolKeyword(pos + 8);
		case 10: return deserializeBoxTSThisType(pos + 8);
		case 11: return deserializeBoxTSUndefinedKeyword(pos + 8);
		case 12: return deserializeBoxTSUnknownKeyword(pos + 8);
		case 13: return deserializeBoxTSVoidKeyword(pos + 8);
		case 14: return deserializeBoxTSArrayType(pos + 8);
		case 15: return deserializeBoxTSConditionalType(pos + 8);
		case 16: return deserializeBoxTSConstructorType(pos + 8);
		case 17: return deserializeBoxTSFunctionType(pos + 8);
		case 18: return deserializeBoxTSImportType(pos + 8);
		case 19: return deserializeBoxTSIndexedAccessType(pos + 8);
		case 20: return deserializeBoxTSInferType(pos + 8);
		case 21: return deserializeBoxTSIntersectionType(pos + 8);
		case 22: return deserializeBoxTSLiteralType(pos + 8);
		case 23: return deserializeBoxTSMappedType(pos + 8);
		case 24: return deserializeBoxTSNamedTupleMember(pos + 8);
		case 26: return deserializeBoxTSTemplateLiteralType(pos + 8);
		case 27: return deserializeBoxTSTupleType(pos + 8);
		case 28: return deserializeBoxTSTypeLiteral(pos + 8);
		case 29: return deserializeBoxTSTypeOperator(pos + 8);
		case 30: return deserializeBoxTSTypePredicate(pos + 8);
		case 31: return deserializeBoxTSTypeQuery(pos + 8);
		case 32: return deserializeBoxTSTypeReference(pos + 8);
		case 33: return deserializeBoxTSUnionType(pos + 8);
		case 34: return deserializeBoxTSParenthesizedType(pos + 8);
		case 35: return deserializeBoxJSDocNullableType(pos + 8);
		case 36: return deserializeBoxJSDocNonNullableType(pos + 8);
		case 37: return deserializeBoxJSDocUnknownType(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for TSType`);
	}
}
function deserializeTSConditionalType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSConditionalType",
		checkType: null,
		extendsType: null,
		trueType: null,
		falseType: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.checkType = deserializeTSType(pos + 8), node.extendsType = deserializeTSType(pos + 24), node.trueType = deserializeTSType(pos + 40), node.falseType = deserializeTSType(pos + 56), parent = previousParent, node;
}
function deserializeTSUnionType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSUnionType",
		types: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.types = deserializeVecTSType(pos + 8), parent = previousParent, node;
}
function deserializeTSIntersectionType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSIntersectionType",
		types: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.types = deserializeVecTSType(pos + 8), parent = previousParent, node;
}
function deserializeTSParenthesizedType(pos) {
	let node;
	return node = deserializeTSType(pos + 8), node;
}
function deserializeTSTypeOperator(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSTypeOperator",
		operator: deserializeTSTypeOperatorOperator(pos + 24),
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.typeAnnotation = deserializeTSType(pos + 8), parent = previousParent, node;
}
function deserializeTSTypeOperatorOperator(pos) {
	switch (uint8[pos]) {
		case 0: return "keyof";
		case 1: return "unique";
		case 2: return "readonly";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for TSTypeOperatorOperator`);
	}
}
function deserializeTSArrayType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSArrayType",
		elementType: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.elementType = deserializeTSType(pos + 8), parent = previousParent, node;
}
function deserializeTSIndexedAccessType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSIndexedAccessType",
		objectType: null,
		indexType: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.objectType = deserializeTSType(pos + 8), node.indexType = deserializeTSType(pos + 24), parent = previousParent, node;
}
function deserializeTSTupleType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSTupleType",
		elementTypes: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.elementTypes = deserializeVecTSTupleElement(pos + 8), parent = previousParent, node;
}
function deserializeTSNamedTupleMember(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSNamedTupleMember",
		label: null,
		elementType: null,
		optional: deserializeBool(pos + 48),
		start,
		end,
		range: [start, end],
		parent
	};
	return node.label = deserializeIdentifierName(pos + 8), node.elementType = deserializeTSTupleElement(pos + 32), parent = previousParent, node;
}
function deserializeTSOptionalType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSOptionalType",
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.typeAnnotation = deserializeTSType(pos + 8), parent = previousParent, node;
}
function deserializeTSRestType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSRestType",
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.typeAnnotation = deserializeTSType(pos + 8), parent = previousParent, node;
}
function deserializeTSTupleElement(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxTSAnyKeyword(pos + 8);
		case 1: return deserializeBoxTSBigIntKeyword(pos + 8);
		case 2: return deserializeBoxTSBooleanKeyword(pos + 8);
		case 3: return deserializeBoxTSIntrinsicKeyword(pos + 8);
		case 4: return deserializeBoxTSNeverKeyword(pos + 8);
		case 5: return deserializeBoxTSNullKeyword(pos + 8);
		case 6: return deserializeBoxTSNumberKeyword(pos + 8);
		case 7: return deserializeBoxTSObjectKeyword(pos + 8);
		case 8: return deserializeBoxTSStringKeyword(pos + 8);
		case 9: return deserializeBoxTSSymbolKeyword(pos + 8);
		case 10: return deserializeBoxTSThisType(pos + 8);
		case 11: return deserializeBoxTSUndefinedKeyword(pos + 8);
		case 12: return deserializeBoxTSUnknownKeyword(pos + 8);
		case 13: return deserializeBoxTSVoidKeyword(pos + 8);
		case 14: return deserializeBoxTSArrayType(pos + 8);
		case 15: return deserializeBoxTSConditionalType(pos + 8);
		case 16: return deserializeBoxTSConstructorType(pos + 8);
		case 17: return deserializeBoxTSFunctionType(pos + 8);
		case 18: return deserializeBoxTSImportType(pos + 8);
		case 19: return deserializeBoxTSIndexedAccessType(pos + 8);
		case 20: return deserializeBoxTSInferType(pos + 8);
		case 21: return deserializeBoxTSIntersectionType(pos + 8);
		case 22: return deserializeBoxTSLiteralType(pos + 8);
		case 23: return deserializeBoxTSMappedType(pos + 8);
		case 24: return deserializeBoxTSNamedTupleMember(pos + 8);
		case 26: return deserializeBoxTSTemplateLiteralType(pos + 8);
		case 27: return deserializeBoxTSTupleType(pos + 8);
		case 28: return deserializeBoxTSTypeLiteral(pos + 8);
		case 29: return deserializeBoxTSTypeOperator(pos + 8);
		case 30: return deserializeBoxTSTypePredicate(pos + 8);
		case 31: return deserializeBoxTSTypeQuery(pos + 8);
		case 32: return deserializeBoxTSTypeReference(pos + 8);
		case 33: return deserializeBoxTSUnionType(pos + 8);
		case 34: return deserializeBoxTSParenthesizedType(pos + 8);
		case 35: return deserializeBoxJSDocNullableType(pos + 8);
		case 36: return deserializeBoxJSDocNonNullableType(pos + 8);
		case 37: return deserializeBoxJSDocUnknownType(pos + 8);
		case 64: return deserializeBoxTSOptionalType(pos + 8);
		case 65: return deserializeBoxTSRestType(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for TSTupleElement`);
	}
}
function deserializeTSAnyKeyword(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "TSAnyKeyword",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeTSStringKeyword(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "TSStringKeyword",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeTSBooleanKeyword(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "TSBooleanKeyword",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeTSNumberKeyword(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "TSNumberKeyword",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeTSNeverKeyword(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "TSNeverKeyword",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeTSIntrinsicKeyword(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "TSIntrinsicKeyword",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeTSUnknownKeyword(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "TSUnknownKeyword",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeTSNullKeyword(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "TSNullKeyword",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeTSUndefinedKeyword(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "TSUndefinedKeyword",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeTSVoidKeyword(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "TSVoidKeyword",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeTSSymbolKeyword(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "TSSymbolKeyword",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeTSThisType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "TSThisType",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeTSObjectKeyword(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "TSObjectKeyword",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeTSBigIntKeyword(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "TSBigIntKeyword",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeTSTypeReference(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSTypeReference",
		typeName: null,
		typeArguments: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.typeName = deserializeTSTypeName(pos + 8), node.typeArguments = deserializeOptionBoxTSTypeParameterInstantiation(pos + 24), parent = previousParent, node;
}
function deserializeTSTypeName(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxIdentifierReference(pos + 8);
		case 1: return deserializeBoxTSQualifiedName(pos + 8);
		case 2: return deserializeBoxThisExpression(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for TSTypeName`);
	}
}
function deserializeTSQualifiedName(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSQualifiedName",
		left: null,
		right: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.left = deserializeTSTypeName(pos + 8), node.right = deserializeIdentifierName(pos + 24), parent = previousParent, node;
}
function deserializeTSTypeParameterInstantiation(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSTypeParameterInstantiation",
		params: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.params = deserializeVecTSType(pos + 8), parent = previousParent, node;
}
function deserializeTSTypeParameter(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSTypeParameter",
		name: null,
		constraint: null,
		default: null,
		in: deserializeBool(pos + 72),
		out: deserializeBool(pos + 73),
		const: deserializeBool(pos + 74),
		start,
		end,
		range: [start, end],
		parent
	};
	return node.name = deserializeBindingIdentifier(pos + 8), node.constraint = deserializeOptionTSType(pos + 40), node.default = deserializeOptionTSType(pos + 56), parent = previousParent, node;
}
function deserializeTSTypeParameterDeclaration(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSTypeParameterDeclaration",
		params: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.params = deserializeVecTSTypeParameter(pos + 8), parent = previousParent, node;
}
function deserializeTSTypeAliasDeclaration(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSTypeAliasDeclaration",
		id: null,
		typeParameters: null,
		typeAnnotation: null,
		declare: deserializeBool(pos + 68),
		start,
		end,
		range: [start, end],
		parent
	};
	return node.id = deserializeBindingIdentifier(pos + 8), node.typeParameters = deserializeOptionBoxTSTypeParameterDeclaration(pos + 40), node.typeAnnotation = deserializeTSType(pos + 48), parent = previousParent, node;
}
function deserializeTSAccessibility(pos) {
	switch (uint8[pos]) {
		case 0: return "private";
		case 1: return "protected";
		case 2: return "public";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for TSAccessibility`);
	}
}
function deserializeTSClassImplements(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSClassImplements",
		expression: null,
		typeArguments: null,
		start,
		end,
		range: [start, end],
		parent
	}, expression = deserializeTSTypeName(pos + 8);
	if (expression.type === "TSQualifiedName") {
		let object = expression.left, { right } = expression, start$1, end$1, previous = expression = {
			__proto__: NodeProto,
			type: "MemberExpression",
			object,
			property: right,
			optional: !1,
			computed: !1,
			start: start$1 = expression.start,
			end: end$1 = expression.end,
			range: [start$1, end$1],
			parent
		};
		for (right.parent = previous;;) {
			if (object.type !== "TSQualifiedName") {
				object.parent = previous;
				break;
			}
			let { left, right: right$1 } = object;
			previous = previous.object = {
				__proto__: NodeProto,
				type: "MemberExpression",
				object: left,
				property: right$1,
				optional: !1,
				computed: !1,
				start: start$1 = object.start,
				end: end$1 = object.end,
				range: [start$1, end$1],
				parent: previous
			}, right$1.parent = previous, object = left;
		}
	}
	return node.expression = expression, node.typeArguments = deserializeOptionBoxTSTypeParameterInstantiation(pos + 24), parent = previousParent, node;
}
function deserializeTSInterfaceDeclaration(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSInterfaceDeclaration",
		id: null,
		typeParameters: null,
		extends: null,
		body: null,
		declare: deserializeBool(pos + 84),
		start,
		end,
		range: [start, end],
		parent
	};
	return node.id = deserializeBindingIdentifier(pos + 8), node.typeParameters = deserializeOptionBoxTSTypeParameterDeclaration(pos + 40), node.extends = deserializeVecTSInterfaceHeritage(pos + 48), node.body = deserializeBoxTSInterfaceBody(pos + 72), parent = previousParent, node;
}
function deserializeTSInterfaceBody(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSInterfaceBody",
		body: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.body = deserializeVecTSSignature(pos + 8), parent = previousParent, node;
}
function deserializeTSPropertySignature(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSPropertySignature",
		computed: deserializeBool(pos + 32),
		optional: deserializeBool(pos + 33),
		readonly: deserializeBool(pos + 34),
		key: null,
		typeAnnotation: null,
		accessibility: null,
		static: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.key = deserializePropertyKey(pos + 8), node.typeAnnotation = deserializeOptionBoxTSTypeAnnotation(pos + 24), node.static = !1, parent = previousParent, node;
}
function deserializeTSSignature(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxTSIndexSignature(pos + 8);
		case 1: return deserializeBoxTSPropertySignature(pos + 8);
		case 2: return deserializeBoxTSCallSignatureDeclaration(pos + 8);
		case 3: return deserializeBoxTSConstructSignatureDeclaration(pos + 8);
		case 4: return deserializeBoxTSMethodSignature(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for TSSignature`);
	}
}
function deserializeTSIndexSignature(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSIndexSignature",
		parameters: null,
		typeAnnotation: null,
		readonly: deserializeBool(pos + 40),
		static: deserializeBool(pos + 41),
		accessibility: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.parameters = deserializeVecTSIndexSignatureName(pos + 8), node.typeAnnotation = deserializeBoxTSTypeAnnotation(pos + 32), parent = previousParent, node;
}
function deserializeTSCallSignatureDeclaration(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSCallSignatureDeclaration",
		typeParameters: null,
		params: null,
		returnType: null,
		start,
		end,
		range: [start, end],
		parent
	}, params = deserializeBoxFormalParameters(pos + 24), thisParam = deserializeOptionBoxTSThisParameter(pos + 16);
	return thisParam !== null && params.unshift(thisParam), node.typeParameters = deserializeOptionBoxTSTypeParameterDeclaration(pos + 8), node.params = params, node.returnType = deserializeOptionBoxTSTypeAnnotation(pos + 32), parent = previousParent, node;
}
function deserializeTSMethodSignatureKind(pos) {
	switch (uint8[pos]) {
		case 0: return "method";
		case 1: return "get";
		case 2: return "set";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for TSMethodSignatureKind`);
	}
}
function deserializeTSMethodSignature(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSMethodSignature",
		key: null,
		computed: deserializeBool(pos + 60),
		optional: deserializeBool(pos + 61),
		kind: deserializeTSMethodSignatureKind(pos + 62),
		typeParameters: null,
		params: null,
		returnType: null,
		accessibility: null,
		readonly: null,
		static: null,
		start,
		end,
		range: [start, end],
		parent
	}, params = deserializeBoxFormalParameters(pos + 40), thisParam = deserializeOptionBoxTSThisParameter(pos + 32);
	return thisParam !== null && params.unshift(thisParam), node.key = deserializePropertyKey(pos + 8), node.typeParameters = deserializeOptionBoxTSTypeParameterDeclaration(pos + 24), node.params = params, node.returnType = deserializeOptionBoxTSTypeAnnotation(pos + 48), node.readonly = !1, node.static = !1, parent = previousParent, node;
}
function deserializeTSConstructSignatureDeclaration(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSConstructSignatureDeclaration",
		typeParameters: null,
		params: null,
		returnType: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.typeParameters = deserializeOptionBoxTSTypeParameterDeclaration(pos + 8), node.params = deserializeBoxFormalParameters(pos + 16), node.returnType = deserializeOptionBoxTSTypeAnnotation(pos + 24), parent = previousParent, node;
}
function deserializeTSIndexSignatureName(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "Identifier",
		decorators: null,
		name: deserializeStr(pos + 8),
		optional: null,
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.decorators = [], node.optional = !1, node.typeAnnotation = deserializeBoxTSTypeAnnotation(pos + 24), parent = previousParent, node;
}
function deserializeTSInterfaceHeritage(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSInterfaceHeritage",
		expression: null,
		typeArguments: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.expression = deserializeExpression(pos + 8), node.typeArguments = deserializeOptionBoxTSTypeParameterInstantiation(pos + 24), parent = previousParent, node;
}
function deserializeTSTypePredicate(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSTypePredicate",
		parameterName: null,
		asserts: deserializeBool(pos + 32),
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.parameterName = deserializeTSTypePredicateName(pos + 8), node.typeAnnotation = deserializeOptionBoxTSTypeAnnotation(pos + 24), parent = previousParent, node;
}
function deserializeTSTypePredicateName(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxIdentifierName(pos + 8);
		case 1: return deserializeTSThisType(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for TSTypePredicateName`);
	}
}
function deserializeTSModuleDeclaration(pos) {
	let kind = deserializeTSModuleDeclarationKind(pos + 84), start = deserializeU32(pos), end = deserializeU32(pos + 4), declare = deserializeBool(pos + 85), node, previousParent = parent, body = deserializeOptionTSModuleDeclarationBody(pos + 64);
	if (body === null) node = parent = {
		__proto__: NodeProto,
		type: "TSModuleDeclaration",
		id: null,
		kind,
		declare,
		global: !1,
		start,
		end,
		range: [start, end],
		parent
	}, node.id = deserializeTSModuleDeclarationName(pos + 8);
	else {
		node = parent = {
			__proto__: NodeProto,
			type: "TSModuleDeclaration",
			id: null,
			body,
			kind,
			declare,
			global: !1,
			start,
			end,
			range: [start, end],
			parent
		};
		let id = deserializeTSModuleDeclarationName(pos + 8);
		if (body.type === "TSModuleBlock") node.id = id, body.parent = node;
		else {
			let innerId = body.id;
			if (innerId.type === "Identifier") {
				let start$1, end$1;
				id.parent = innerId.parent = node.id = parent = {
					__proto__: NodeProto,
					type: "TSQualifiedName",
					left: id,
					right: innerId,
					start: start$1 = id.start,
					end: end$1 = innerId.end,
					range: [start$1, end$1],
					parent: node
				};
			} else {
				node.id = innerId, innerId.parent = node;
				let { start: start$1 } = id;
				for (; innerId.start = innerId.range[0] = start$1, innerId.left.type !== "Identifier";) innerId = innerId.left;
				let end$1, right = innerId.left;
				id.parent = right.parent = innerId.left = {
					__proto__: NodeProto,
					type: "TSQualifiedName",
					left: id,
					right,
					start: start$1,
					end: end$1 = right.end,
					range: [start$1, end$1],
					parent: innerId
				};
			}
			Object.hasOwn(body, "body") ? (body = body.body, node.body = body, body.parent = node) : body = null;
		}
	}
	return parent = previousParent, node;
}
function deserializeTSModuleDeclarationKind(pos) {
	switch (uint8[pos]) {
		case 0: return "module";
		case 1: return "namespace";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for TSModuleDeclarationKind`);
	}
}
function deserializeTSModuleDeclarationName(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBindingIdentifier(pos + 8);
		case 1: return deserializeStringLiteral(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for TSModuleDeclarationName`);
	}
}
function deserializeTSModuleDeclarationBody(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxTSModuleDeclaration(pos + 8);
		case 1: return deserializeBoxTSModuleBlock(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for TSModuleDeclarationBody`);
	}
}
function deserializeTSGlobalDeclaration(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSModuleDeclaration",
		id: null,
		body: null,
		kind: null,
		declare: deserializeBool(pos + 76),
		global: null,
		start,
		end,
		range: [start, end],
		parent
	}, keywordStart, keywordEnd;
	return node.id = {
		__proto__: NodeProto,
		type: "Identifier",
		decorators: [],
		name: "global",
		optional: !1,
		typeAnnotation: null,
		start: keywordStart = deserializeU32(pos + 8),
		end: keywordEnd = deserializeU32(pos + 12),
		range: [keywordStart, keywordEnd],
		parent
	}, node.body = deserializeTSModuleBlock(pos + 16), node.kind = "global", node.global = !0, parent = previousParent, node;
}
function deserializeTSModuleBlock(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSModuleBlock",
		body: null,
		start,
		end,
		range: [start, end],
		parent
	}, body = deserializeVecDirective(pos + 8);
	return body.push(...deserializeVecStatement(pos + 32)), node.body = body, parent = previousParent, node;
}
function deserializeTSTypeLiteral(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSTypeLiteral",
		members: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.members = deserializeVecTSSignature(pos + 8), parent = previousParent, node;
}
function deserializeTSInferType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSInferType",
		typeParameter: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.typeParameter = deserializeBoxTSTypeParameter(pos + 8), parent = previousParent, node;
}
function deserializeTSTypeQuery(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSTypeQuery",
		exprName: null,
		typeArguments: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.exprName = deserializeTSTypeQueryExprName(pos + 8), node.typeArguments = deserializeOptionBoxTSTypeParameterInstantiation(pos + 24), parent = previousParent, node;
}
function deserializeTSTypeQueryExprName(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxIdentifierReference(pos + 8);
		case 1: return deserializeBoxTSQualifiedName(pos + 8);
		case 2: return deserializeBoxThisExpression(pos + 8);
		case 3: return deserializeBoxTSImportType(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for TSTypeQueryExprName`);
	}
}
function deserializeTSImportType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSImportType",
		source: null,
		options: null,
		qualifier: null,
		typeArguments: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.source = deserializeStringLiteral(pos + 8), node.options = deserializeOptionBoxObjectExpression(pos + 56), node.qualifier = deserializeOptionTSImportTypeQualifier(pos + 64), node.typeArguments = deserializeOptionBoxTSTypeParameterInstantiation(pos + 80), parent = previousParent, node;
}
function deserializeTSImportTypeQualifier(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxIdentifierName(pos + 8);
		case 1: return deserializeBoxTSImportTypeQualifiedName(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for TSImportTypeQualifier`);
	}
}
function deserializeTSImportTypeQualifiedName(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSQualifiedName",
		left: null,
		right: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.left = deserializeTSImportTypeQualifier(pos + 8), node.right = deserializeIdentifierName(pos + 24), parent = previousParent, node;
}
function deserializeTSFunctionType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSFunctionType",
		typeParameters: null,
		params: null,
		returnType: null,
		start,
		end,
		range: [start, end],
		parent
	}, params = deserializeBoxFormalParameters(pos + 24), thisParam = deserializeOptionBoxTSThisParameter(pos + 16);
	return thisParam !== null && params.unshift(thisParam), node.typeParameters = deserializeOptionBoxTSTypeParameterDeclaration(pos + 8), node.params = params, node.returnType = deserializeBoxTSTypeAnnotation(pos + 32), parent = previousParent, node;
}
function deserializeTSConstructorType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSConstructorType",
		abstract: deserializeBool(pos + 36),
		typeParameters: null,
		params: null,
		returnType: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.typeParameters = deserializeOptionBoxTSTypeParameterDeclaration(pos + 8), node.params = deserializeBoxFormalParameters(pos + 16), node.returnType = deserializeBoxTSTypeAnnotation(pos + 24), parent = previousParent, node;
}
function deserializeTSMappedType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSMappedType",
		key: null,
		constraint: null,
		nameType: null,
		typeAnnotation: null,
		optional: null,
		readonly: deserializeOptionTSMappedTypeModifierOperator(pos + 53),
		start,
		end,
		range: [start, end],
		parent
	}, typeParameter = deserializeBoxTSTypeParameter(pos + 8), key = typeParameter.name;
	key.parent = parent;
	let { constraint } = typeParameter;
	constraint !== null && (constraint.parent = parent);
	let optional = deserializeOptionTSMappedTypeModifierOperator(pos + 52);
	return optional === null && (optional = !1), node.key = key, node.constraint = constraint, node.nameType = deserializeOptionTSType(pos + 16), node.typeAnnotation = deserializeOptionTSType(pos + 32), node.optional = optional, parent = previousParent, node;
}
function deserializeTSMappedTypeModifierOperator(pos) {
	switch (uint8[pos]) {
		case 0: return !0;
		case 1: return "+";
		case 2: return "-";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for TSMappedTypeModifierOperator`);
	}
}
function deserializeTSTemplateLiteralType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSTemplateLiteralType",
		quasis: null,
		types: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.quasis = deserializeVecTemplateElement(pos + 8), node.types = deserializeVecTSType(pos + 32), parent = previousParent, node;
}
function deserializeTSAsExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSAsExpression",
		expression: null,
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.expression = deserializeExpression(pos + 8), node.typeAnnotation = deserializeTSType(pos + 24), parent = previousParent, node;
}
function deserializeTSSatisfiesExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSSatisfiesExpression",
		expression: null,
		typeAnnotation: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.expression = deserializeExpression(pos + 8), node.typeAnnotation = deserializeTSType(pos + 24), parent = previousParent, node;
}
function deserializeTSTypeAssertion(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSTypeAssertion",
		typeAnnotation: null,
		expression: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.typeAnnotation = deserializeTSType(pos + 8), node.expression = deserializeExpression(pos + 24), parent = previousParent, node;
}
function deserializeTSImportEqualsDeclaration(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSImportEqualsDeclaration",
		id: null,
		moduleReference: null,
		importKind: deserializeImportOrExportKind(pos + 56),
		start,
		end,
		range: [start, end],
		parent
	};
	return node.id = deserializeBindingIdentifier(pos + 8), node.moduleReference = deserializeTSModuleReference(pos + 40), parent = previousParent, node;
}
function deserializeTSModuleReference(pos) {
	switch (uint8[pos]) {
		case 0: return deserializeBoxIdentifierReference(pos + 8);
		case 1: return deserializeBoxTSQualifiedName(pos + 8);
		case 2: return deserializeBoxThisExpression(pos + 8);
		case 3: return deserializeBoxTSExternalModuleReference(pos + 8);
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for TSModuleReference`);
	}
}
function deserializeTSExternalModuleReference(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSExternalModuleReference",
		expression: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.expression = deserializeStringLiteral(pos + 8), parent = previousParent, node;
}
function deserializeTSNonNullExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSNonNullExpression",
		expression: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.expression = deserializeExpression(pos + 8), parent = previousParent, node;
}
function deserializeDecorator(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "Decorator",
		expression: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.expression = deserializeExpression(pos + 8), parent = previousParent, node;
}
function deserializeTSExportAssignment(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSExportAssignment",
		expression: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.expression = deserializeExpression(pos + 8), parent = previousParent, node;
}
function deserializeTSNamespaceExportDeclaration(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSNamespaceExportDeclaration",
		id: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.id = deserializeIdentifierName(pos + 8), parent = previousParent, node;
}
function deserializeTSInstantiationExpression(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSInstantiationExpression",
		expression: null,
		typeArguments: null,
		start,
		end,
		range: [start, end],
		parent
	};
	return node.expression = deserializeExpression(pos + 8), node.typeArguments = deserializeBoxTSTypeParameterInstantiation(pos + 24), parent = previousParent, node;
}
function deserializeImportOrExportKind(pos) {
	switch (uint8[pos]) {
		case 0: return "value";
		case 1: return "type";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for ImportOrExportKind`);
	}
}
function deserializeJSDocNullableType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSJSDocNullableType",
		typeAnnotation: null,
		postfix: deserializeBool(pos + 24),
		start,
		end,
		range: [start, end],
		parent
	};
	return node.typeAnnotation = deserializeTSType(pos + 8), parent = previousParent, node;
}
function deserializeJSDocNonNullableType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4), previousParent = parent, node = parent = {
		__proto__: NodeProto,
		type: "TSJSDocNonNullableType",
		typeAnnotation: null,
		postfix: deserializeBool(pos + 24),
		start,
		end,
		range: [start, end],
		parent
	};
	return node.typeAnnotation = deserializeTSType(pos + 8), parent = previousParent, node;
}
function deserializeJSDocUnknownType(pos) {
	let start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type: "TSJSDocUnknownType",
		start,
		end,
		range: [start, end],
		parent
	};
}
function deserializeCommentKind(pos) {
	switch (uint8[pos]) {
		case 0: return "Line";
		case 1: return "Block";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for CommentKind`);
	}
}
function deserializeComment(pos) {
	let type = deserializeCommentKind(pos + 12), start = deserializeU32(pos), end = deserializeU32(pos + 4);
	return {
		__proto__: NodeProto,
		type,
		value: sourceText$1.slice(start + 2, end - (type === "Line" ? 0 : 2)),
		start,
		end,
		range: [start, end]
	};
}
function deserializeAssignmentOperator(pos) {
	switch (uint8[pos]) {
		case 0: return "=";
		case 1: return "+=";
		case 2: return "-=";
		case 3: return "*=";
		case 4: return "/=";
		case 5: return "%=";
		case 6: return "**=";
		case 7: return "<<=";
		case 8: return ">>=";
		case 9: return ">>>=";
		case 10: return "|=";
		case 11: return "^=";
		case 12: return "&=";
		case 13: return "||=";
		case 14: return "&&=";
		case 15: return "??=";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for AssignmentOperator`);
	}
}
function deserializeBinaryOperator(pos) {
	switch (uint8[pos]) {
		case 0: return "==";
		case 1: return "!=";
		case 2: return "===";
		case 3: return "!==";
		case 4: return "<";
		case 5: return "<=";
		case 6: return ">";
		case 7: return ">=";
		case 8: return "+";
		case 9: return "-";
		case 10: return "*";
		case 11: return "/";
		case 12: return "%";
		case 13: return "**";
		case 14: return "<<";
		case 15: return ">>";
		case 16: return ">>>";
		case 17: return "|";
		case 18: return "^";
		case 19: return "&";
		case 20: return "in";
		case 21: return "instanceof";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for BinaryOperator`);
	}
}
function deserializeLogicalOperator(pos) {
	switch (uint8[pos]) {
		case 0: return "||";
		case 1: return "&&";
		case 2: return "??";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for LogicalOperator`);
	}
}
function deserializeUnaryOperator(pos) {
	switch (uint8[pos]) {
		case 0: return "+";
		case 1: return "-";
		case 2: return "!";
		case 3: return "~";
		case 4: return "typeof";
		case 5: return "void";
		case 6: return "delete";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for UnaryOperator`);
	}
}
function deserializeUpdateOperator(pos) {
	switch (uint8[pos]) {
		case 0: return "++";
		case 1: return "--";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for UpdateOperator`);
	}
}
function deserializeModuleKind(pos) {
	switch (uint8[pos]) {
		case 0: return "script";
		case 1: return "module";
		default: throw Error(`Unexpected discriminant ${uint8[pos]} for ModuleKind`);
	}
}
function deserializeU32(pos) {
	return uint32[pos >> 2];
}
function deserializeU8(pos) {
	return uint8[pos];
}
function deserializeStr(pos) {
	let pos32 = pos >> 2, len = uint32[pos32 + 2];
	if (len === 0) return "";
	if (pos = uint32[pos32], sourceIsAscii && pos < sourceByteLen$1) return sourceText$1.substr(pos, len);
	let end = pos + len;
	if (len > 50) return decodeStr(uint8.subarray(pos, end));
	let out = "", c;
	do
		if (c = uint8[pos++], c < 128) out += fromCodePoint(c);
		else {
			out += decodeStr(uint8.subarray(pos - 1, end));
			break;
		}
	while (pos < end);
	return out;
}
function deserializeVecComment(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 16;
	for (; pos !== endPos;) arr.push(deserializeComment(pos)), pos += 16;
	return arr;
}
function deserializeOptionHashbang(pos) {
	return uint32[pos + 8 >> 2] === 0 && uint32[pos + 12 >> 2] === 0 ? null : deserializeHashbang(pos);
}
function deserializeVecDirective(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 72;
	for (; pos !== endPos;) arr.push(deserializeDirective(pos)), pos += 72;
	return arr;
}
function deserializeVecStatement(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 16;
	for (; pos !== endPos;) arr.push(deserializeStatement(pos)), pos += 16;
	return arr;
}
function deserializeBoxBooleanLiteral(pos) {
	return deserializeBooleanLiteral(uint32[pos >> 2]);
}
function deserializeBoxNullLiteral(pos) {
	return deserializeNullLiteral(uint32[pos >> 2]);
}
function deserializeBoxNumericLiteral(pos) {
	return deserializeNumericLiteral(uint32[pos >> 2]);
}
function deserializeBoxBigIntLiteral(pos) {
	return deserializeBigIntLiteral(uint32[pos >> 2]);
}
function deserializeBoxRegExpLiteral(pos) {
	return deserializeRegExpLiteral(uint32[pos >> 2]);
}
function deserializeBoxStringLiteral(pos) {
	return deserializeStringLiteral(uint32[pos >> 2]);
}
function deserializeBoxTemplateLiteral(pos) {
	return deserializeTemplateLiteral(uint32[pos >> 2]);
}
function deserializeBoxIdentifierReference(pos) {
	return deserializeIdentifierReference(uint32[pos >> 2]);
}
function deserializeBoxMetaProperty(pos) {
	return deserializeMetaProperty(uint32[pos >> 2]);
}
function deserializeBoxSuper(pos) {
	return deserializeSuper(uint32[pos >> 2]);
}
function deserializeBoxArrayExpression(pos) {
	return deserializeArrayExpression(uint32[pos >> 2]);
}
function deserializeBoxArrowFunctionExpression(pos) {
	return deserializeArrowFunctionExpression(uint32[pos >> 2]);
}
function deserializeBoxAssignmentExpression(pos) {
	return deserializeAssignmentExpression(uint32[pos >> 2]);
}
function deserializeBoxAwaitExpression(pos) {
	return deserializeAwaitExpression(uint32[pos >> 2]);
}
function deserializeBoxBinaryExpression(pos) {
	return deserializeBinaryExpression(uint32[pos >> 2]);
}
function deserializeBoxCallExpression(pos) {
	return deserializeCallExpression(uint32[pos >> 2]);
}
function deserializeBoxChainExpression(pos) {
	return deserializeChainExpression(uint32[pos >> 2]);
}
function deserializeBoxClass(pos) {
	return deserializeClass(uint32[pos >> 2]);
}
function deserializeBoxConditionalExpression(pos) {
	return deserializeConditionalExpression(uint32[pos >> 2]);
}
function deserializeBoxFunction(pos) {
	return deserializeFunction(uint32[pos >> 2]);
}
function deserializeBoxImportExpression(pos) {
	return deserializeImportExpression(uint32[pos >> 2]);
}
function deserializeBoxLogicalExpression(pos) {
	return deserializeLogicalExpression(uint32[pos >> 2]);
}
function deserializeBoxNewExpression(pos) {
	return deserializeNewExpression(uint32[pos >> 2]);
}
function deserializeBoxObjectExpression(pos) {
	return deserializeObjectExpression(uint32[pos >> 2]);
}
function deserializeBoxParenthesizedExpression(pos) {
	return deserializeParenthesizedExpression(uint32[pos >> 2]);
}
function deserializeBoxSequenceExpression(pos) {
	return deserializeSequenceExpression(uint32[pos >> 2]);
}
function deserializeBoxTaggedTemplateExpression(pos) {
	return deserializeTaggedTemplateExpression(uint32[pos >> 2]);
}
function deserializeBoxThisExpression(pos) {
	return deserializeThisExpression(uint32[pos >> 2]);
}
function deserializeBoxUnaryExpression(pos) {
	return deserializeUnaryExpression(uint32[pos >> 2]);
}
function deserializeBoxUpdateExpression(pos) {
	return deserializeUpdateExpression(uint32[pos >> 2]);
}
function deserializeBoxYieldExpression(pos) {
	return deserializeYieldExpression(uint32[pos >> 2]);
}
function deserializeBoxPrivateInExpression(pos) {
	return deserializePrivateInExpression(uint32[pos >> 2]);
}
function deserializeBoxJSXElement(pos) {
	return deserializeJSXElement(uint32[pos >> 2]);
}
function deserializeBoxJSXFragment(pos) {
	return deserializeJSXFragment(uint32[pos >> 2]);
}
function deserializeBoxTSAsExpression(pos) {
	return deserializeTSAsExpression(uint32[pos >> 2]);
}
function deserializeBoxTSSatisfiesExpression(pos) {
	return deserializeTSSatisfiesExpression(uint32[pos >> 2]);
}
function deserializeBoxTSTypeAssertion(pos) {
	return deserializeTSTypeAssertion(uint32[pos >> 2]);
}
function deserializeBoxTSNonNullExpression(pos) {
	return deserializeTSNonNullExpression(uint32[pos >> 2]);
}
function deserializeBoxTSInstantiationExpression(pos) {
	return deserializeTSInstantiationExpression(uint32[pos >> 2]);
}
function deserializeBoxV8IntrinsicExpression(pos) {
	return deserializeV8IntrinsicExpression(uint32[pos >> 2]);
}
function deserializeVecArrayExpressionElement(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 16;
	for (; pos !== endPos;) arr.push(deserializeArrayExpressionElement(pos)), pos += 16;
	return arr;
}
function deserializeBoxSpreadElement(pos) {
	return deserializeSpreadElement(uint32[pos >> 2]);
}
function deserializeVecObjectPropertyKind(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 16;
	for (; pos !== endPos;) arr.push(deserializeObjectPropertyKind(pos)), pos += 16;
	return arr;
}
function deserializeBoxObjectProperty(pos) {
	return deserializeObjectProperty(uint32[pos >> 2]);
}
function deserializeBool(pos) {
	return uint8[pos] === 1;
}
function deserializeBoxIdentifierName(pos) {
	return deserializeIdentifierName(uint32[pos >> 2]);
}
function deserializeBoxPrivateIdentifier(pos) {
	return deserializePrivateIdentifier(uint32[pos >> 2]);
}
function deserializeVecTemplateElement(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 48;
	for (; pos !== endPos;) arr.push(deserializeTemplateElement(pos)), pos += 48;
	return arr;
}
function deserializeVecExpression(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 16;
	for (; pos !== endPos;) arr.push(deserializeExpression(pos)), pos += 16;
	return arr;
}
function deserializeBoxTSTypeParameterInstantiation(pos) {
	return deserializeTSTypeParameterInstantiation(uint32[pos >> 2]);
}
function deserializeOptionBoxTSTypeParameterInstantiation(pos) {
	return uint32[pos >> 2] === 0 && uint32[pos + 4 >> 2] === 0 ? null : deserializeBoxTSTypeParameterInstantiation(pos);
}
function deserializeOptionStr(pos) {
	return uint32[pos >> 2] === 0 && uint32[pos + 4 >> 2] === 0 ? null : deserializeStr(pos);
}
function deserializeBoxComputedMemberExpression(pos) {
	return deserializeComputedMemberExpression(uint32[pos >> 2]);
}
function deserializeBoxStaticMemberExpression(pos) {
	return deserializeStaticMemberExpression(uint32[pos >> 2]);
}
function deserializeBoxPrivateFieldExpression(pos) {
	return deserializePrivateFieldExpression(uint32[pos >> 2]);
}
function deserializeVecArgument(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 16;
	for (; pos !== endPos;) arr.push(deserializeArgument(pos)), pos += 16;
	return arr;
}
function deserializeBoxArrayAssignmentTarget(pos) {
	return deserializeArrayAssignmentTarget(uint32[pos >> 2]);
}
function deserializeBoxObjectAssignmentTarget(pos) {
	return deserializeObjectAssignmentTarget(uint32[pos >> 2]);
}
function deserializeOptionAssignmentTargetMaybeDefault(pos) {
	return uint8[pos] === 51 ? null : deserializeAssignmentTargetMaybeDefault(pos);
}
function deserializeVecOptionAssignmentTargetMaybeDefault(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 16;
	for (; pos !== endPos;) arr.push(deserializeOptionAssignmentTargetMaybeDefault(pos)), pos += 16;
	return arr;
}
function deserializeBoxAssignmentTargetRest(pos) {
	return deserializeAssignmentTargetRest(uint32[pos >> 2]);
}
function deserializeOptionBoxAssignmentTargetRest(pos) {
	return uint32[pos >> 2] === 0 && uint32[pos + 4 >> 2] === 0 ? null : deserializeBoxAssignmentTargetRest(pos);
}
function deserializeVecAssignmentTargetProperty(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 16;
	for (; pos !== endPos;) arr.push(deserializeAssignmentTargetProperty(pos)), pos += 16;
	return arr;
}
function deserializeBoxAssignmentTargetWithDefault(pos) {
	return deserializeAssignmentTargetWithDefault(uint32[pos >> 2]);
}
function deserializeBoxAssignmentTargetPropertyIdentifier(pos) {
	return deserializeAssignmentTargetPropertyIdentifier(uint32[pos >> 2]);
}
function deserializeBoxAssignmentTargetPropertyProperty(pos) {
	return deserializeAssignmentTargetPropertyProperty(uint32[pos >> 2]);
}
function deserializeOptionExpression(pos) {
	return uint8[pos] === 51 ? null : deserializeExpression(pos);
}
function deserializeBoxBlockStatement(pos) {
	return deserializeBlockStatement(uint32[pos >> 2]);
}
function deserializeBoxBreakStatement(pos) {
	return deserializeBreakStatement(uint32[pos >> 2]);
}
function deserializeBoxContinueStatement(pos) {
	return deserializeContinueStatement(uint32[pos >> 2]);
}
function deserializeBoxDebuggerStatement(pos) {
	return deserializeDebuggerStatement(uint32[pos >> 2]);
}
function deserializeBoxDoWhileStatement(pos) {
	return deserializeDoWhileStatement(uint32[pos >> 2]);
}
function deserializeBoxEmptyStatement(pos) {
	return deserializeEmptyStatement(uint32[pos >> 2]);
}
function deserializeBoxExpressionStatement(pos) {
	return deserializeExpressionStatement(uint32[pos >> 2]);
}
function deserializeBoxForInStatement(pos) {
	return deserializeForInStatement(uint32[pos >> 2]);
}
function deserializeBoxForOfStatement(pos) {
	return deserializeForOfStatement(uint32[pos >> 2]);
}
function deserializeBoxForStatement(pos) {
	return deserializeForStatement(uint32[pos >> 2]);
}
function deserializeBoxIfStatement(pos) {
	return deserializeIfStatement(uint32[pos >> 2]);
}
function deserializeBoxLabeledStatement(pos) {
	return deserializeLabeledStatement(uint32[pos >> 2]);
}
function deserializeBoxReturnStatement(pos) {
	return deserializeReturnStatement(uint32[pos >> 2]);
}
function deserializeBoxSwitchStatement(pos) {
	return deserializeSwitchStatement(uint32[pos >> 2]);
}
function deserializeBoxThrowStatement(pos) {
	return deserializeThrowStatement(uint32[pos >> 2]);
}
function deserializeBoxTryStatement(pos) {
	return deserializeTryStatement(uint32[pos >> 2]);
}
function deserializeBoxWhileStatement(pos) {
	return deserializeWhileStatement(uint32[pos >> 2]);
}
function deserializeBoxWithStatement(pos) {
	return deserializeWithStatement(uint32[pos >> 2]);
}
function deserializeBoxVariableDeclaration(pos) {
	return deserializeVariableDeclaration(uint32[pos >> 2]);
}
function deserializeBoxTSTypeAliasDeclaration(pos) {
	return deserializeTSTypeAliasDeclaration(uint32[pos >> 2]);
}
function deserializeBoxTSInterfaceDeclaration(pos) {
	return deserializeTSInterfaceDeclaration(uint32[pos >> 2]);
}
function deserializeBoxTSEnumDeclaration(pos) {
	return deserializeTSEnumDeclaration(uint32[pos >> 2]);
}
function deserializeBoxTSModuleDeclaration(pos) {
	return deserializeTSModuleDeclaration(uint32[pos >> 2]);
}
function deserializeBoxTSGlobalDeclaration(pos) {
	return deserializeTSGlobalDeclaration(uint32[pos >> 2]);
}
function deserializeBoxTSImportEqualsDeclaration(pos) {
	return deserializeTSImportEqualsDeclaration(uint32[pos >> 2]);
}
function deserializeVecVariableDeclarator(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 64;
	for (; pos !== endPos;) arr.push(deserializeVariableDeclarator(pos)), pos += 64;
	return arr;
}
function deserializeOptionStatement(pos) {
	return uint8[pos] === 70 ? null : deserializeStatement(pos);
}
function deserializeOptionForStatementInit(pos) {
	return uint8[pos] === 65 ? null : deserializeForStatementInit(pos);
}
function deserializeOptionLabelIdentifier(pos) {
	return uint32[pos + 8 >> 2] === 0 && uint32[pos + 12 >> 2] === 0 ? null : deserializeLabelIdentifier(pos);
}
function deserializeVecSwitchCase(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 48;
	for (; pos !== endPos;) arr.push(deserializeSwitchCase(pos)), pos += 48;
	return arr;
}
function deserializeBoxCatchClause(pos) {
	return deserializeCatchClause(uint32[pos >> 2]);
}
function deserializeOptionBoxCatchClause(pos) {
	return uint32[pos >> 2] === 0 && uint32[pos + 4 >> 2] === 0 ? null : deserializeBoxCatchClause(pos);
}
function deserializeOptionBoxBlockStatement(pos) {
	return uint32[pos >> 2] === 0 && uint32[pos + 4 >> 2] === 0 ? null : deserializeBoxBlockStatement(pos);
}
function deserializeOptionCatchParameter(pos) {
	return uint8[pos + 32] === 2 ? null : deserializeCatchParameter(pos);
}
function deserializeBoxTSTypeAnnotation(pos) {
	return deserializeTSTypeAnnotation(uint32[pos >> 2]);
}
function deserializeOptionBoxTSTypeAnnotation(pos) {
	return uint32[pos >> 2] === 0 && uint32[pos + 4 >> 2] === 0 ? null : deserializeBoxTSTypeAnnotation(pos);
}
function deserializeBoxBindingIdentifier(pos) {
	return deserializeBindingIdentifier(uint32[pos >> 2]);
}
function deserializeBoxObjectPattern(pos) {
	return deserializeObjectPattern(uint32[pos >> 2]);
}
function deserializeBoxArrayPattern(pos) {
	return deserializeArrayPattern(uint32[pos >> 2]);
}
function deserializeBoxAssignmentPattern(pos) {
	return deserializeAssignmentPattern(uint32[pos >> 2]);
}
function deserializeVecBindingProperty(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 64;
	for (; pos !== endPos;) arr.push(deserializeBindingProperty(pos)), pos += 64;
	return arr;
}
function deserializeBoxBindingRestElement(pos) {
	return deserializeBindingRestElement(uint32[pos >> 2]);
}
function deserializeOptionBoxBindingRestElement(pos) {
	return uint32[pos >> 2] === 0 && uint32[pos + 4 >> 2] === 0 ? null : deserializeBoxBindingRestElement(pos);
}
function deserializeOptionBindingPattern(pos) {
	return uint8[pos + 24] === 2 ? null : deserializeBindingPattern(pos);
}
function deserializeVecOptionBindingPattern(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 32;
	for (; pos !== endPos;) arr.push(deserializeOptionBindingPattern(pos)), pos += 32;
	return arr;
}
function deserializeOptionBindingIdentifier(pos) {
	return uint32[pos + 8 >> 2] === 0 && uint32[pos + 12 >> 2] === 0 ? null : deserializeBindingIdentifier(pos);
}
function deserializeBoxTSTypeParameterDeclaration(pos) {
	return deserializeTSTypeParameterDeclaration(uint32[pos >> 2]);
}
function deserializeOptionBoxTSTypeParameterDeclaration(pos) {
	return uint32[pos >> 2] === 0 && uint32[pos + 4 >> 2] === 0 ? null : deserializeBoxTSTypeParameterDeclaration(pos);
}
function deserializeBoxTSThisParameter(pos) {
	return deserializeTSThisParameter(uint32[pos >> 2]);
}
function deserializeOptionBoxTSThisParameter(pos) {
	return uint32[pos >> 2] === 0 && uint32[pos + 4 >> 2] === 0 ? null : deserializeBoxTSThisParameter(pos);
}
function deserializeBoxFormalParameters(pos) {
	return deserializeFormalParameters(uint32[pos >> 2]);
}
function deserializeBoxFunctionBody(pos) {
	return deserializeFunctionBody(uint32[pos >> 2]);
}
function deserializeOptionBoxFunctionBody(pos) {
	return uint32[pos >> 2] === 0 && uint32[pos + 4 >> 2] === 0 ? null : deserializeBoxFunctionBody(pos);
}
function deserializeVecFormalParameter(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 72;
	for (; pos !== endPos;) arr.push(deserializeFormalParameter(pos)), pos += 72;
	return arr;
}
function deserializeVecDecorator(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 24;
	for (; pos !== endPos;) arr.push(deserializeDecorator(pos)), pos += 24;
	return arr;
}
function deserializeOptionTSAccessibility(pos) {
	return uint8[pos] === 3 ? null : deserializeTSAccessibility(pos);
}
function deserializeVecTSClassImplements(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 32;
	for (; pos !== endPos;) arr.push(deserializeTSClassImplements(pos)), pos += 32;
	return arr;
}
function deserializeBoxClassBody(pos) {
	return deserializeClassBody(uint32[pos >> 2]);
}
function deserializeVecClassElement(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 16;
	for (; pos !== endPos;) arr.push(deserializeClassElement(pos)), pos += 16;
	return arr;
}
function deserializeBoxStaticBlock(pos) {
	return deserializeStaticBlock(uint32[pos >> 2]);
}
function deserializeBoxMethodDefinition(pos) {
	return deserializeMethodDefinition(uint32[pos >> 2]);
}
function deserializeBoxPropertyDefinition(pos) {
	return deserializePropertyDefinition(uint32[pos >> 2]);
}
function deserializeBoxAccessorProperty(pos) {
	return deserializeAccessorProperty(uint32[pos >> 2]);
}
function deserializeBoxTSIndexSignature(pos) {
	return deserializeTSIndexSignature(uint32[pos >> 2]);
}
function deserializeBoxImportDeclaration(pos) {
	return deserializeImportDeclaration(uint32[pos >> 2]);
}
function deserializeBoxExportAllDeclaration(pos) {
	return deserializeExportAllDeclaration(uint32[pos >> 2]);
}
function deserializeBoxExportDefaultDeclaration(pos) {
	return deserializeExportDefaultDeclaration(uint32[pos >> 2]);
}
function deserializeBoxExportNamedDeclaration(pos) {
	return deserializeExportNamedDeclaration(uint32[pos >> 2]);
}
function deserializeBoxTSExportAssignment(pos) {
	return deserializeTSExportAssignment(uint32[pos >> 2]);
}
function deserializeBoxTSNamespaceExportDeclaration(pos) {
	return deserializeTSNamespaceExportDeclaration(uint32[pos >> 2]);
}
function deserializeOptionImportPhase(pos) {
	return uint8[pos] === 2 ? null : deserializeImportPhase(pos);
}
function deserializeVecImportDeclarationSpecifier(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 16;
	for (; pos !== endPos;) arr.push(deserializeImportDeclarationSpecifier(pos)), pos += 16;
	return arr;
}
function deserializeOptionVecImportDeclarationSpecifier(pos) {
	return uint32[pos >> 2] === 0 && uint32[pos + 4 >> 2] === 0 ? null : deserializeVecImportDeclarationSpecifier(pos);
}
function deserializeBoxWithClause(pos) {
	return deserializeWithClause(uint32[pos >> 2]);
}
function deserializeOptionBoxWithClause(pos) {
	return uint32[pos >> 2] === 0 && uint32[pos + 4 >> 2] === 0 ? null : deserializeBoxWithClause(pos);
}
function deserializeBoxImportSpecifier(pos) {
	return deserializeImportSpecifier(uint32[pos >> 2]);
}
function deserializeBoxImportDefaultSpecifier(pos) {
	return deserializeImportDefaultSpecifier(uint32[pos >> 2]);
}
function deserializeBoxImportNamespaceSpecifier(pos) {
	return deserializeImportNamespaceSpecifier(uint32[pos >> 2]);
}
function deserializeVecImportAttribute(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 112;
	for (; pos !== endPos;) arr.push(deserializeImportAttribute(pos)), pos += 112;
	return arr;
}
function deserializeOptionDeclaration(pos) {
	return uint8[pos] === 31 ? null : deserializeDeclaration(pos);
}
function deserializeVecExportSpecifier(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 128;
	for (; pos !== endPos;) arr.push(deserializeExportSpecifier(pos)), pos += 128;
	return arr;
}
function deserializeOptionStringLiteral(pos) {
	return uint8[pos + 40] === 2 ? null : deserializeStringLiteral(pos);
}
function deserializeOptionModuleExportName(pos) {
	return uint8[pos] === 3 ? null : deserializeModuleExportName(pos);
}
function deserializeF64(pos) {
	return float64[pos >> 3];
}
function deserializeBoxJSXOpeningElement(pos) {
	return deserializeJSXOpeningElement(uint32[pos >> 2]);
}
function deserializeVecJSXChild(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 16;
	for (; pos !== endPos;) arr.push(deserializeJSXChild(pos)), pos += 16;
	return arr;
}
function deserializeBoxJSXClosingElement(pos) {
	return deserializeJSXClosingElement(uint32[pos >> 2]);
}
function deserializeOptionBoxJSXClosingElement(pos) {
	return uint32[pos >> 2] === 0 && uint32[pos + 4 >> 2] === 0 ? null : deserializeBoxJSXClosingElement(pos);
}
function deserializeVecJSXAttributeItem(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 16;
	for (; pos !== endPos;) arr.push(deserializeJSXAttributeItem(pos)), pos += 16;
	return arr;
}
function deserializeBoxJSXIdentifier(pos) {
	return deserializeJSXIdentifier(uint32[pos >> 2]);
}
function deserializeBoxJSXNamespacedName(pos) {
	return deserializeJSXNamespacedName(uint32[pos >> 2]);
}
function deserializeBoxJSXMemberExpression(pos) {
	return deserializeJSXMemberExpression(uint32[pos >> 2]);
}
function deserializeBoxJSXAttribute(pos) {
	return deserializeJSXAttribute(uint32[pos >> 2]);
}
function deserializeBoxJSXSpreadAttribute(pos) {
	return deserializeJSXSpreadAttribute(uint32[pos >> 2]);
}
function deserializeOptionJSXAttributeValue(pos) {
	return uint8[pos] === 4 ? null : deserializeJSXAttributeValue(pos);
}
function deserializeBoxJSXExpressionContainer(pos) {
	return deserializeJSXExpressionContainer(uint32[pos >> 2]);
}
function deserializeBoxJSXText(pos) {
	return deserializeJSXText(uint32[pos >> 2]);
}
function deserializeBoxJSXSpreadChild(pos) {
	return deserializeJSXSpreadChild(uint32[pos >> 2]);
}
function deserializeVecTSEnumMember(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 40;
	for (; pos !== endPos;) arr.push(deserializeTSEnumMember(pos)), pos += 40;
	return arr;
}
function deserializeBoxTSAnyKeyword(pos) {
	return deserializeTSAnyKeyword(uint32[pos >> 2]);
}
function deserializeBoxTSBigIntKeyword(pos) {
	return deserializeTSBigIntKeyword(uint32[pos >> 2]);
}
function deserializeBoxTSBooleanKeyword(pos) {
	return deserializeTSBooleanKeyword(uint32[pos >> 2]);
}
function deserializeBoxTSIntrinsicKeyword(pos) {
	return deserializeTSIntrinsicKeyword(uint32[pos >> 2]);
}
function deserializeBoxTSNeverKeyword(pos) {
	return deserializeTSNeverKeyword(uint32[pos >> 2]);
}
function deserializeBoxTSNullKeyword(pos) {
	return deserializeTSNullKeyword(uint32[pos >> 2]);
}
function deserializeBoxTSNumberKeyword(pos) {
	return deserializeTSNumberKeyword(uint32[pos >> 2]);
}
function deserializeBoxTSObjectKeyword(pos) {
	return deserializeTSObjectKeyword(uint32[pos >> 2]);
}
function deserializeBoxTSStringKeyword(pos) {
	return deserializeTSStringKeyword(uint32[pos >> 2]);
}
function deserializeBoxTSSymbolKeyword(pos) {
	return deserializeTSSymbolKeyword(uint32[pos >> 2]);
}
function deserializeBoxTSUndefinedKeyword(pos) {
	return deserializeTSUndefinedKeyword(uint32[pos >> 2]);
}
function deserializeBoxTSUnknownKeyword(pos) {
	return deserializeTSUnknownKeyword(uint32[pos >> 2]);
}
function deserializeBoxTSVoidKeyword(pos) {
	return deserializeTSVoidKeyword(uint32[pos >> 2]);
}
function deserializeBoxTSArrayType(pos) {
	return deserializeTSArrayType(uint32[pos >> 2]);
}
function deserializeBoxTSConditionalType(pos) {
	return deserializeTSConditionalType(uint32[pos >> 2]);
}
function deserializeBoxTSConstructorType(pos) {
	return deserializeTSConstructorType(uint32[pos >> 2]);
}
function deserializeBoxTSFunctionType(pos) {
	return deserializeTSFunctionType(uint32[pos >> 2]);
}
function deserializeBoxTSImportType(pos) {
	return deserializeTSImportType(uint32[pos >> 2]);
}
function deserializeBoxTSIndexedAccessType(pos) {
	return deserializeTSIndexedAccessType(uint32[pos >> 2]);
}
function deserializeBoxTSInferType(pos) {
	return deserializeTSInferType(uint32[pos >> 2]);
}
function deserializeBoxTSIntersectionType(pos) {
	return deserializeTSIntersectionType(uint32[pos >> 2]);
}
function deserializeBoxTSLiteralType(pos) {
	return deserializeTSLiteralType(uint32[pos >> 2]);
}
function deserializeBoxTSMappedType(pos) {
	return deserializeTSMappedType(uint32[pos >> 2]);
}
function deserializeBoxTSNamedTupleMember(pos) {
	return deserializeTSNamedTupleMember(uint32[pos >> 2]);
}
function deserializeBoxTSTemplateLiteralType(pos) {
	return deserializeTSTemplateLiteralType(uint32[pos >> 2]);
}
function deserializeBoxTSThisType(pos) {
	return deserializeTSThisType(uint32[pos >> 2]);
}
function deserializeBoxTSTupleType(pos) {
	return deserializeTSTupleType(uint32[pos >> 2]);
}
function deserializeBoxTSTypeLiteral(pos) {
	return deserializeTSTypeLiteral(uint32[pos >> 2]);
}
function deserializeBoxTSTypeOperator(pos) {
	return deserializeTSTypeOperator(uint32[pos >> 2]);
}
function deserializeBoxTSTypePredicate(pos) {
	return deserializeTSTypePredicate(uint32[pos >> 2]);
}
function deserializeBoxTSTypeQuery(pos) {
	return deserializeTSTypeQuery(uint32[pos >> 2]);
}
function deserializeBoxTSTypeReference(pos) {
	return deserializeTSTypeReference(uint32[pos >> 2]);
}
function deserializeBoxTSUnionType(pos) {
	return deserializeTSUnionType(uint32[pos >> 2]);
}
function deserializeBoxTSParenthesizedType(pos) {
	return deserializeTSParenthesizedType(uint32[pos >> 2]);
}
function deserializeBoxJSDocNullableType(pos) {
	return deserializeJSDocNullableType(uint32[pos >> 2]);
}
function deserializeBoxJSDocNonNullableType(pos) {
	return deserializeJSDocNonNullableType(uint32[pos >> 2]);
}
function deserializeBoxJSDocUnknownType(pos) {
	return deserializeJSDocUnknownType(uint32[pos >> 2]);
}
function deserializeVecTSType(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 16;
	for (; pos !== endPos;) arr.push(deserializeTSType(pos)), pos += 16;
	return arr;
}
function deserializeVecTSTupleElement(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 16;
	for (; pos !== endPos;) arr.push(deserializeTSTupleElement(pos)), pos += 16;
	return arr;
}
function deserializeBoxTSOptionalType(pos) {
	return deserializeTSOptionalType(uint32[pos >> 2]);
}
function deserializeBoxTSRestType(pos) {
	return deserializeTSRestType(uint32[pos >> 2]);
}
function deserializeBoxTSQualifiedName(pos) {
	return deserializeTSQualifiedName(uint32[pos >> 2]);
}
function deserializeOptionTSType(pos) {
	return uint8[pos] === 38 ? null : deserializeTSType(pos);
}
function deserializeVecTSTypeParameter(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 80;
	for (; pos !== endPos;) arr.push(deserializeTSTypeParameter(pos)), pos += 80;
	return arr;
}
function deserializeVecTSInterfaceHeritage(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 32;
	for (; pos !== endPos;) arr.push(deserializeTSInterfaceHeritage(pos)), pos += 32;
	return arr;
}
function deserializeBoxTSInterfaceBody(pos) {
	return deserializeTSInterfaceBody(uint32[pos >> 2]);
}
function deserializeVecTSSignature(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 16;
	for (; pos !== endPos;) arr.push(deserializeTSSignature(pos)), pos += 16;
	return arr;
}
function deserializeBoxTSPropertySignature(pos) {
	return deserializeTSPropertySignature(uint32[pos >> 2]);
}
function deserializeBoxTSCallSignatureDeclaration(pos) {
	return deserializeTSCallSignatureDeclaration(uint32[pos >> 2]);
}
function deserializeBoxTSConstructSignatureDeclaration(pos) {
	return deserializeTSConstructSignatureDeclaration(uint32[pos >> 2]);
}
function deserializeBoxTSMethodSignature(pos) {
	return deserializeTSMethodSignature(uint32[pos >> 2]);
}
function deserializeVecTSIndexSignatureName(pos) {
	let arr = [], pos32 = pos >> 2;
	pos = uint32[pos32];
	let endPos = pos + uint32[pos32 + 2] * 32;
	for (; pos !== endPos;) arr.push(deserializeTSIndexSignatureName(pos)), pos += 32;
	return arr;
}
function deserializeOptionTSModuleDeclarationBody(pos) {
	return uint8[pos] === 2 ? null : deserializeTSModuleDeclarationBody(pos);
}
function deserializeBoxTSModuleBlock(pos) {
	return deserializeTSModuleBlock(uint32[pos >> 2]);
}
function deserializeBoxTSTypeParameter(pos) {
	return deserializeTSTypeParameter(uint32[pos >> 2]);
}
function deserializeOptionBoxObjectExpression(pos) {
	return uint32[pos >> 2] === 0 && uint32[pos + 4 >> 2] === 0 ? null : deserializeBoxObjectExpression(pos);
}
function deserializeOptionTSImportTypeQualifier(pos) {
	return uint8[pos] === 2 ? null : deserializeTSImportTypeQualifier(pos);
}
function deserializeBoxTSImportTypeQualifiedName(pos) {
	return deserializeTSImportTypeQualifiedName(uint32[pos >> 2]);
}
function deserializeOptionTSMappedTypeModifierOperator(pos) {
	return uint8[pos] === 3 ? null : deserializeTSMappedTypeModifierOperator(pos);
}
function deserializeBoxTSExternalModuleReference(pos) {
	return deserializeTSExternalModuleReference(uint32[pos >> 2]);
}
const { freeze: freeze$3 } = Object, $EMPTY = freeze$3([]), DECORATORS__KEY__TYPE_ANNOTATION__VALUE = freeze$3([
	"decorators",
	"key",
	"typeAnnotation",
	"value"
]), LEFT__RIGHT = freeze$3(["left", "right"]), ARGUMENT = freeze$3(["argument"]), BODY = freeze$3(["body"]), LABEL = freeze$3(["label"]), CALLEE__TYPE_ARGUMENTS__ARGUMENTS = freeze$3([
	"callee",
	"typeArguments",
	"arguments"
]), EXPRESSION = freeze$3(["expression"]), DECORATORS__ID__TYPE_PARAMETERS__SUPER_CLASS__SUPER_TYPE_ARGUMENTS__IMPLEMENTS__BODY = freeze$3([
	"decorators",
	"id",
	"typeParameters",
	"superClass",
	"superTypeArguments",
	"implements",
	"body"
]), TEST__CONSEQUENT__ALTERNATE = freeze$3([
	"test",
	"consequent",
	"alternate"
]), LEFT__RIGHT__BODY = freeze$3([
	"left",
	"right",
	"body"
]), ID__TYPE_PARAMETERS__PARAMS__RETURN_TYPE__BODY = freeze$3([
	"id",
	"typeParameters",
	"params",
	"returnType",
	"body"
]), KEY__VALUE = freeze$3(["key", "value"]), LOCAL = freeze$3(["local"]), OBJECT__PROPERTY = freeze$3(["object", "property"]), DECORATORS__KEY__TYPE_ANNOTATION = freeze$3([
	"decorators",
	"key",
	"typeAnnotation"
]), EXPRESSION__TYPE_ANNOTATION = freeze$3(["expression", "typeAnnotation"]), TYPE_PARAMETERS__PARAMS__RETURN_TYPE = freeze$3([
	"typeParameters",
	"params",
	"returnType"
]), EXPRESSION__TYPE_ARGUMENTS = freeze$3(["expression", "typeArguments"]), MEMBERS = freeze$3(["members"]), ID__BODY = freeze$3(["id", "body"]), TYPES = freeze$3(["types"]), TYPE_ANNOTATION = freeze$3(["typeAnnotation"]), PARAMS = freeze$3(["params"]);
var keys_default = freeze$3({
	DebuggerStatement: $EMPTY,
	EmptyStatement: $EMPTY,
	Literal: $EMPTY,
	PrivateIdentifier: $EMPTY,
	Super: $EMPTY,
	TemplateElement: $EMPTY,
	ThisExpression: $EMPTY,
	JSXClosingFragment: $EMPTY,
	JSXEmptyExpression: $EMPTY,
	JSXIdentifier: $EMPTY,
	JSXOpeningFragment: $EMPTY,
	JSXText: $EMPTY,
	TSAnyKeyword: $EMPTY,
	TSBigIntKeyword: $EMPTY,
	TSBooleanKeyword: $EMPTY,
	TSIntrinsicKeyword: $EMPTY,
	TSJSDocUnknownType: $EMPTY,
	TSNeverKeyword: $EMPTY,
	TSNullKeyword: $EMPTY,
	TSNumberKeyword: $EMPTY,
	TSObjectKeyword: $EMPTY,
	TSStringKeyword: $EMPTY,
	TSSymbolKeyword: $EMPTY,
	TSThisType: $EMPTY,
	TSUndefinedKeyword: $EMPTY,
	TSUnknownKeyword: $EMPTY,
	TSVoidKeyword: $EMPTY,
	AccessorProperty: DECORATORS__KEY__TYPE_ANNOTATION__VALUE,
	ArrayExpression: freeze$3(["elements"]),
	ArrayPattern: freeze$3([
		"decorators",
		"elements",
		"typeAnnotation"
	]),
	ArrowFunctionExpression: freeze$3([
		"typeParameters",
		"params",
		"returnType",
		"body"
	]),
	AssignmentExpression: LEFT__RIGHT,
	AssignmentPattern: freeze$3([
		"decorators",
		"left",
		"right",
		"typeAnnotation"
	]),
	AwaitExpression: ARGUMENT,
	BinaryExpression: LEFT__RIGHT,
	BlockStatement: BODY,
	BreakStatement: LABEL,
	CallExpression: CALLEE__TYPE_ARGUMENTS__ARGUMENTS,
	CatchClause: freeze$3(["param", "body"]),
	ChainExpression: EXPRESSION,
	ClassBody: BODY,
	ClassDeclaration: DECORATORS__ID__TYPE_PARAMETERS__SUPER_CLASS__SUPER_TYPE_ARGUMENTS__IMPLEMENTS__BODY,
	ClassExpression: DECORATORS__ID__TYPE_PARAMETERS__SUPER_CLASS__SUPER_TYPE_ARGUMENTS__IMPLEMENTS__BODY,
	ConditionalExpression: TEST__CONSEQUENT__ALTERNATE,
	ContinueStatement: LABEL,
	Decorator: EXPRESSION,
	DoWhileStatement: freeze$3(["body", "test"]),
	ExportAllDeclaration: freeze$3([
		"exported",
		"source",
		"attributes"
	]),
	ExportDefaultDeclaration: freeze$3(["declaration"]),
	ExportNamedDeclaration: freeze$3([
		"declaration",
		"specifiers",
		"source",
		"attributes"
	]),
	ExportSpecifier: freeze$3(["local", "exported"]),
	ExpressionStatement: EXPRESSION,
	ForInStatement: LEFT__RIGHT__BODY,
	ForOfStatement: LEFT__RIGHT__BODY,
	ForStatement: freeze$3([
		"init",
		"test",
		"update",
		"body"
	]),
	FunctionDeclaration: ID__TYPE_PARAMETERS__PARAMS__RETURN_TYPE__BODY,
	FunctionExpression: ID__TYPE_PARAMETERS__PARAMS__RETURN_TYPE__BODY,
	Identifier: freeze$3(["decorators", "typeAnnotation"]),
	IfStatement: TEST__CONSEQUENT__ALTERNATE,
	ImportAttribute: KEY__VALUE,
	ImportDeclaration: freeze$3([
		"specifiers",
		"source",
		"attributes"
	]),
	ImportDefaultSpecifier: LOCAL,
	ImportExpression: freeze$3(["source", "options"]),
	ImportNamespaceSpecifier: LOCAL,
	ImportSpecifier: freeze$3(["imported", "local"]),
	LabeledStatement: freeze$3(["label", "body"]),
	LogicalExpression: LEFT__RIGHT,
	MemberExpression: OBJECT__PROPERTY,
	MetaProperty: freeze$3(["meta", "property"]),
	MethodDefinition: freeze$3([
		"decorators",
		"key",
		"value"
	]),
	NewExpression: CALLEE__TYPE_ARGUMENTS__ARGUMENTS,
	ObjectExpression: freeze$3(["properties"]),
	ObjectPattern: freeze$3([
		"decorators",
		"properties",
		"typeAnnotation"
	]),
	ParenthesizedExpression: EXPRESSION,
	Program: BODY,
	Property: KEY__VALUE,
	PropertyDefinition: DECORATORS__KEY__TYPE_ANNOTATION__VALUE,
	RestElement: freeze$3([
		"decorators",
		"argument",
		"typeAnnotation"
	]),
	ReturnStatement: ARGUMENT,
	SequenceExpression: freeze$3(["expressions"]),
	SpreadElement: ARGUMENT,
	StaticBlock: BODY,
	SwitchCase: freeze$3(["test", "consequent"]),
	SwitchStatement: freeze$3(["discriminant", "cases"]),
	TaggedTemplateExpression: freeze$3([
		"tag",
		"typeArguments",
		"quasi"
	]),
	TemplateLiteral: freeze$3(["quasis", "expressions"]),
	ThrowStatement: ARGUMENT,
	TryStatement: freeze$3([
		"block",
		"handler",
		"finalizer"
	]),
	UnaryExpression: ARGUMENT,
	UpdateExpression: ARGUMENT,
	V8IntrinsicExpression: freeze$3(["name", "arguments"]),
	VariableDeclaration: freeze$3(["declarations"]),
	VariableDeclarator: freeze$3(["id", "init"]),
	WhileStatement: freeze$3(["test", "body"]),
	WithStatement: freeze$3(["object", "body"]),
	YieldExpression: ARGUMENT,
	JSXAttribute: freeze$3(["name", "value"]),
	JSXClosingElement: freeze$3(["name"]),
	JSXElement: freeze$3([
		"openingElement",
		"children",
		"closingElement"
	]),
	JSXExpressionContainer: EXPRESSION,
	JSXFragment: freeze$3([
		"openingFragment",
		"children",
		"closingFragment"
	]),
	JSXMemberExpression: OBJECT__PROPERTY,
	JSXNamespacedName: freeze$3(["namespace", "name"]),
	JSXOpeningElement: freeze$3([
		"name",
		"typeArguments",
		"attributes"
	]),
	JSXSpreadAttribute: ARGUMENT,
	JSXSpreadChild: EXPRESSION,
	TSAbstractAccessorProperty: DECORATORS__KEY__TYPE_ANNOTATION,
	TSAbstractMethodDefinition: KEY__VALUE,
	TSAbstractPropertyDefinition: DECORATORS__KEY__TYPE_ANNOTATION,
	TSArrayType: freeze$3(["elementType"]),
	TSAsExpression: EXPRESSION__TYPE_ANNOTATION,
	TSCallSignatureDeclaration: TYPE_PARAMETERS__PARAMS__RETURN_TYPE,
	TSClassImplements: EXPRESSION__TYPE_ARGUMENTS,
	TSConditionalType: freeze$3([
		"checkType",
		"extendsType",
		"trueType",
		"falseType"
	]),
	TSConstructSignatureDeclaration: TYPE_PARAMETERS__PARAMS__RETURN_TYPE,
	TSConstructorType: TYPE_PARAMETERS__PARAMS__RETURN_TYPE,
	TSDeclareFunction: ID__TYPE_PARAMETERS__PARAMS__RETURN_TYPE__BODY,
	TSEmptyBodyFunctionExpression: freeze$3([
		"id",
		"typeParameters",
		"params",
		"returnType"
	]),
	TSEnumBody: MEMBERS,
	TSEnumDeclaration: ID__BODY,
	TSEnumMember: freeze$3(["id", "initializer"]),
	TSExportAssignment: EXPRESSION,
	TSExternalModuleReference: EXPRESSION,
	TSFunctionType: TYPE_PARAMETERS__PARAMS__RETURN_TYPE,
	TSImportEqualsDeclaration: freeze$3(["id", "moduleReference"]),
	TSImportType: freeze$3([
		"argument",
		"options",
		"qualifier",
		"typeArguments"
	]),
	TSIndexSignature: freeze$3(["parameters", "typeAnnotation"]),
	TSIndexedAccessType: freeze$3(["objectType", "indexType"]),
	TSInferType: freeze$3(["typeParameter"]),
	TSInstantiationExpression: EXPRESSION__TYPE_ARGUMENTS,
	TSInterfaceBody: BODY,
	TSInterfaceDeclaration: freeze$3([
		"id",
		"typeParameters",
		"extends",
		"body"
	]),
	TSInterfaceHeritage: EXPRESSION__TYPE_ARGUMENTS,
	TSIntersectionType: TYPES,
	TSJSDocNonNullableType: TYPE_ANNOTATION,
	TSJSDocNullableType: TYPE_ANNOTATION,
	TSLiteralType: freeze$3(["literal"]),
	TSMappedType: freeze$3([
		"key",
		"constraint",
		"nameType",
		"typeAnnotation"
	]),
	TSMethodSignature: freeze$3([
		"key",
		"typeParameters",
		"params",
		"returnType"
	]),
	TSModuleBlock: BODY,
	TSModuleDeclaration: ID__BODY,
	TSNamedTupleMember: freeze$3(["label", "elementType"]),
	TSNamespaceExportDeclaration: freeze$3(["id"]),
	TSNonNullExpression: EXPRESSION,
	TSOptionalType: TYPE_ANNOTATION,
	TSParameterProperty: freeze$3(["decorators", "parameter"]),
	TSParenthesizedType: TYPE_ANNOTATION,
	TSPropertySignature: freeze$3(["key", "typeAnnotation"]),
	TSQualifiedName: LEFT__RIGHT,
	TSRestType: TYPE_ANNOTATION,
	TSSatisfiesExpression: EXPRESSION__TYPE_ANNOTATION,
	TSTemplateLiteralType: freeze$3(["quasis", "types"]),
	TSTupleType: freeze$3(["elementTypes"]),
	TSTypeAliasDeclaration: freeze$3([
		"id",
		"typeParameters",
		"typeAnnotation"
	]),
	TSTypeAnnotation: TYPE_ANNOTATION,
	TSTypeAssertion: freeze$3(["typeAnnotation", "expression"]),
	TSTypeLiteral: MEMBERS,
	TSTypeOperator: TYPE_ANNOTATION,
	TSTypeParameter: freeze$3([
		"name",
		"constraint",
		"default"
	]),
	TSTypeParameterDeclaration: PARAMS,
	TSTypeParameterInstantiation: PARAMS,
	TSTypePredicate: freeze$3(["parameterName", "typeAnnotation"]),
	TSTypeQuery: freeze$3(["exprName", "typeArguments"]),
	TSTypeReference: freeze$3(["typeName", "typeArguments"]),
	TSUnionType: TYPES
});
const WHITESPACE_ONLY_REGEXP = /^\s*$/;
function getAllComments() {
	return ast === null && initAst(), ast.comments;
}
function getCommentsBefore(nodeOrToken) {
	ast === null && initAst();
	let { comments: comments$1 } = ast, commentsLength = comments$1.length, targetStart = nodeOrToken.range[0], sliceStart = commentsLength, sliceEnd = 0;
	for (let lo = 0, hi = commentsLength; lo < hi;) {
		let mid = lo + hi >> 1;
		comments$1[mid].end <= targetStart ? sliceEnd = lo = mid + 1 : hi = mid;
	}
	for (let i = sliceEnd - 1; i >= 0; i--) {
		let comment = comments$1[i], gap = sourceText.slice(comment.end, targetStart);
		if (WHITESPACE_ONLY_REGEXP.test(gap)) sliceStart = i, targetStart = comment.start;
		else break;
	}
	return comments$1.slice(sliceStart, sliceEnd);
}
function getCommentsAfter(nodeOrToken) {
	ast === null && initAst();
	let { comments: comments$1 } = ast, commentsLength = comments$1.length, targetEnd = nodeOrToken.range[1], sliceStart = commentsLength, sliceEnd = 0;
	for (let lo = 0, hi = commentsLength; lo < hi;) {
		let mid = lo + hi >> 1;
		comments$1[mid].start < targetEnd ? lo = mid + 1 : sliceStart = hi = mid;
	}
	for (let i = sliceStart; i < commentsLength; i++) {
		let comment = comments$1[i], gap = sourceText.slice(targetEnd, comment.start);
		if (WHITESPACE_ONLY_REGEXP.test(gap)) sliceEnd = i + 1, targetEnd = comment.end;
		else break;
	}
	return comments$1.slice(sliceStart, sliceEnd);
}
function getCommentsInside(node) {
	ast === null && initAst();
	let { comments: comments$1 } = ast, commentsLength = comments$1.length, sliceStart = commentsLength, sliceEnd, { range } = node, rangeStart = range[0], rangeEnd = range[1];
	for (let lo = 0, hi = commentsLength; lo < hi;) {
		let mid = lo + hi >> 1;
		comments$1[mid].start < rangeStart ? lo = mid + 1 : sliceStart = hi = mid;
	}
	for (let lo = sliceStart, hi = commentsLength; lo < hi;) {
		let mid = lo + hi >> 1;
		comments$1[mid].start < rangeEnd ? lo = mid + 1 : sliceEnd = hi = mid;
	}
	return comments$1.slice(sliceStart, sliceEnd);
}
function commentsExistBetween(nodeOrToken1, nodeOrToken2) {
	ast === null && initAst();
	let { comments: comments$1 } = ast, commentsLength = comments$1.length, betweenRangeStart = nodeOrToken1.range[1], firstCommentBetween = -1;
	for (let lo = 0, hi = commentsLength; lo < hi;) {
		let mid = lo + hi >> 1;
		comments$1[mid].start < betweenRangeStart ? lo = mid + 1 : firstCommentBetween = hi = mid;
	}
	return 0 <= firstCommentBetween && firstCommentBetween < commentsLength && comments$1[firstCommentBetween].end <= nodeOrToken2.range[0];
}
function getJSDocComment(node) {
	throw Error("`sourceCode.getJSDocComment` is not supported at present (and deprecated)");
}
const { defineProperty } = Object, { isArray: isArray$5 } = Array, LINE_BREAK_PATTERN = /\r\n|[\r\n\u2028\u2029]/gu, lines = [], lineStartOffsets = [0];
function initLines() {
	sourceText === null && initSourceText();
	let lastOffset = 0, offset, match;
	for (; (match = LINE_BREAK_PATTERN.exec(sourceText)) !== null;) offset = match.index, lines.push(sourceText.slice(lastOffset, offset)), lineStartOffsets.push(lastOffset = offset + match[0].length);
	lines.push(sourceText.slice(lastOffset));
}
function resetLines() {
	lines.length = 0, lineStartOffsets.length = 1;
}
function getLineColumnFromOffset(offset) {
	if (typeof offset != "number" || offset < 0 || (offset | 0) !== offset) throw TypeError("Expected `offset` to be a non-negative integer.");
	if (lines.length === 0 && initLines(), offset > sourceText.length) throw RangeError(`Index out of range (requested index ${offset}, but source text has length ${sourceText.length}).`);
	return getLineColumnFromOffsetUnchecked(offset);
}
function getLineColumnFromOffsetUnchecked(offset) {
	let low = 0, high = lineStartOffsets.length, mid;
	do
		mid = (low + high) / 2 | 0, offset < lineStartOffsets[mid] ? high = mid : low = mid + 1;
	while (low < high);
	return {
		line: low,
		column: offset - lineStartOffsets[low - 1]
	};
}
function getOffsetFromLineColumn(loc) {
	if (typeof loc == "object" && loc) {
		let { line, column } = loc;
		if (typeof line == "number" && typeof column == "number" && (line | 0) === line && (column | 0) === column) {
			lines.length === 0 && initLines();
			let linesCount = lineStartOffsets.length;
			if (line <= 0 || line > linesCount) throw RangeError(`Line number out of range (line ${line} requested). Line numbers should be 1-based, and less than or equal to number of lines in file (${linesCount}).`);
			if (column < 0) throw RangeError(`Invalid column number (column ${column} requested).`);
			let lineOffset = lineStartOffsets[line - 1], offset = lineOffset + column, nextLineOffset;
			if (line === linesCount) {
				if (nextLineOffset = sourceText.length, offset <= nextLineOffset) return offset;
			} else if (nextLineOffset = lineStartOffsets[line], offset < nextLineOffset) return offset;
			throw RangeError(`Column number out of range (column ${column} requested, but the length of line ${line} is ${nextLineOffset - lineOffset}).`);
		}
	}
	throw TypeError("Expected `loc` to be an object with integer `line` and `column` properties.");
}
function getNodeLoc(node) {
	lines.length === 0 && initLines();
	let loc = {
		start: getLineColumnFromOffsetUnchecked(node.start),
		end: getLineColumnFromOffsetUnchecked(node.end)
	};
	return defineProperty(node, "loc", {
		value: loc,
		writable: !0
	}), loc;
}
function getNodeByRangeIndex(offset) {
	return ast === null && initAst(), offset < ast.start || offset >= ast.end ? null : (index = offset, traverse(ast));
}
let index = 0;
function traverse(node) {
	let keys = keys_default[node.type];
	for (let keyIndex = 0, keysLen = keys.length; keyIndex < keysLen; keyIndex++) {
		let child = node[keys[keyIndex]];
		if (isArray$5(child)) for (let arrIndex = 0, arrLen = child.length; arrIndex < arrLen; arrIndex++) {
			let entry = child[arrIndex];
			if (entry !== null) {
				if (entry.start > index) break;
				if (entry.end > index) return traverse(entry);
			}
		}
		else if (child !== null) {
			if (child.start > index) break;
			if (child.end > index) return traverse(child);
		}
	}
	return node;
}
var require_eslint_visitor_keys = /* @__PURE__ */ __commonJSMin(((exports) => {
	let KEYS = {
		ArrayExpression: ["elements"],
		ArrayPattern: ["elements"],
		ArrowFunctionExpression: ["params", "body"],
		AssignmentExpression: ["left", "right"],
		AssignmentPattern: ["left", "right"],
		AwaitExpression: ["argument"],
		BinaryExpression: ["left", "right"],
		BlockStatement: ["body"],
		BreakStatement: ["label"],
		CallExpression: ["callee", "arguments"],
		CatchClause: ["param", "body"],
		ChainExpression: ["expression"],
		ClassBody: ["body"],
		ClassDeclaration: [
			"id",
			"superClass",
			"body"
		],
		ClassExpression: [
			"id",
			"superClass",
			"body"
		],
		ConditionalExpression: [
			"test",
			"consequent",
			"alternate"
		],
		ContinueStatement: ["label"],
		DebuggerStatement: [],
		DoWhileStatement: ["body", "test"],
		EmptyStatement: [],
		ExperimentalRestProperty: ["argument"],
		ExperimentalSpreadProperty: ["argument"],
		ExportAllDeclaration: [
			"exported",
			"source",
			"attributes"
		],
		ExportDefaultDeclaration: ["declaration"],
		ExportNamedDeclaration: [
			"declaration",
			"specifiers",
			"source",
			"attributes"
		],
		ExportSpecifier: ["local", "exported"],
		ExpressionStatement: ["expression"],
		ForInStatement: [
			"left",
			"right",
			"body"
		],
		ForOfStatement: [
			"left",
			"right",
			"body"
		],
		ForStatement: [
			"init",
			"test",
			"update",
			"body"
		],
		FunctionDeclaration: [
			"id",
			"params",
			"body"
		],
		FunctionExpression: [
			"id",
			"params",
			"body"
		],
		Identifier: [],
		IfStatement: [
			"test",
			"consequent",
			"alternate"
		],
		ImportAttribute: ["key", "value"],
		ImportDeclaration: [
			"specifiers",
			"source",
			"attributes"
		],
		ImportDefaultSpecifier: ["local"],
		ImportExpression: ["source", "options"],
		ImportNamespaceSpecifier: ["local"],
		ImportSpecifier: ["imported", "local"],
		JSXAttribute: ["name", "value"],
		JSXClosingElement: ["name"],
		JSXClosingFragment: [],
		JSXElement: [
			"openingElement",
			"children",
			"closingElement"
		],
		JSXEmptyExpression: [],
		JSXExpressionContainer: ["expression"],
		JSXFragment: [
			"openingFragment",
			"children",
			"closingFragment"
		],
		JSXIdentifier: [],
		JSXMemberExpression: ["object", "property"],
		JSXNamespacedName: ["namespace", "name"],
		JSXOpeningElement: ["name", "attributes"],
		JSXOpeningFragment: [],
		JSXSpreadAttribute: ["argument"],
		JSXSpreadChild: ["expression"],
		JSXText: [],
		LabeledStatement: ["label", "body"],
		Literal: [],
		LogicalExpression: ["left", "right"],
		MemberExpression: ["object", "property"],
		MetaProperty: ["meta", "property"],
		MethodDefinition: ["key", "value"],
		NewExpression: ["callee", "arguments"],
		ObjectExpression: ["properties"],
		ObjectPattern: ["properties"],
		PrivateIdentifier: [],
		Program: ["body"],
		Property: ["key", "value"],
		PropertyDefinition: ["key", "value"],
		RestElement: ["argument"],
		ReturnStatement: ["argument"],
		SequenceExpression: ["expressions"],
		SpreadElement: ["argument"],
		StaticBlock: ["body"],
		Super: [],
		SwitchCase: ["test", "consequent"],
		SwitchStatement: ["discriminant", "cases"],
		TaggedTemplateExpression: ["tag", "quasi"],
		TemplateElement: [],
		TemplateLiteral: ["quasis", "expressions"],
		ThisExpression: [],
		ThrowStatement: ["argument"],
		TryStatement: [
			"block",
			"handler",
			"finalizer"
		],
		UnaryExpression: ["argument"],
		UpdateExpression: ["argument"],
		VariableDeclaration: ["declarations"],
		VariableDeclarator: ["id", "init"],
		WhileStatement: ["test", "body"],
		WithStatement: ["object", "body"],
		YieldExpression: ["argument"]
	}, NODE_TYPES = Object.keys(KEYS);
	for (let type of NODE_TYPES) Object.freeze(KEYS[type]);
	Object.freeze(KEYS);
	let KEY_BLACKLIST = new Set([
		"parent",
		"leadingComments",
		"trailingComments"
	]);
	function filterKey$1(key) {
		return !KEY_BLACKLIST.has(key) && key[0] !== "_";
	}
	function getKeys(node) {
		return Object.keys(node).filter(filterKey$1);
	}
	function unionWith(additionalKeys$1) {
		let retv = Object.assign({}, KEYS);
		for (let type of Object.keys(additionalKeys$1)) if (Object.hasOwn(retv, type)) {
			let keys = new Set(additionalKeys$1[type]);
			for (let key of retv[type]) keys.add(key);
			retv[type] = Object.freeze(Array.from(keys));
		} else retv[type] = Object.freeze(Array.from(additionalKeys$1[type]));
		return Object.freeze(retv);
	}
	exports.KEYS = KEYS, exports.getKeys = getKeys, exports.unionWith = unionWith;
})), require_get_keys = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.getKeys = void 0, exports.getKeys = require_eslint_visitor_keys().getKeys;
})), require_visitor_keys = /* @__PURE__ */ __commonJSMin(((exports) => {
	var __createBinding$5 = exports && exports.__createBinding || (Object.create ? (function(o, m, k, k2) {
		k2 === void 0 && (k2 = k);
		var desc = Object.getOwnPropertyDescriptor(m, k);
		(!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) && (desc = {
			enumerable: !0,
			get: function() {
				return m[k];
			}
		}), Object.defineProperty(o, k2, desc);
	}) : (function(o, m, k, k2) {
		k2 === void 0 && (k2 = k), o[k2] = m[k];
	})), __setModuleDefault$1 = exports && exports.__setModuleDefault || (Object.create ? (function(o, v) {
		Object.defineProperty(o, "default", {
			enumerable: !0,
			value: v
		});
	}) : function(o, v) {
		o.default = v;
	}), __importStar$1 = exports && exports.__importStar || (function() {
		var ownKeys$1 = function(o) {
			return ownKeys$1 = Object.getOwnPropertyNames || function(o$1) {
				var ar = [];
				for (var k in o$1) Object.prototype.hasOwnProperty.call(o$1, k) && (ar[ar.length] = k);
				return ar;
			}, ownKeys$1(o);
		};
		return function(mod) {
			if (mod && mod.__esModule) return mod;
			var result = {};
			if (mod != null) for (var k = ownKeys$1(mod), i = 0; i < k.length; i++) k[i] !== "default" && __createBinding$5(result, mod, k[i]);
			return __setModuleDefault$1(result, mod), result;
		};
	})();
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.visitorKeys = void 0;
	let eslintVisitorKeys = __importStar$1(require_eslint_visitor_keys()), SharedVisitorKeys = (() => {
		let FunctionType = [
			"typeParameters",
			"params",
			"returnType"
		], AnonymousFunction = [...FunctionType, "body"], AbstractPropertyDefinition = [
			"decorators",
			"key",
			"typeAnnotation"
		];
		return {
			AbstractPropertyDefinition: [
				"decorators",
				"key",
				"typeAnnotation"
			],
			AnonymousFunction,
			AsExpression: ["expression", "typeAnnotation"],
			ClassDeclaration: [
				"decorators",
				"id",
				"typeParameters",
				"superClass",
				"superTypeArguments",
				"implements",
				"body"
			],
			Function: ["id", ...AnonymousFunction],
			FunctionType,
			PropertyDefinition: [...AbstractPropertyDefinition, "value"]
		};
	})(), additionalKeys = {
		AccessorProperty: SharedVisitorKeys.PropertyDefinition,
		ArrayPattern: [
			"decorators",
			"elements",
			"typeAnnotation"
		],
		ArrowFunctionExpression: SharedVisitorKeys.AnonymousFunction,
		AssignmentPattern: [
			"decorators",
			"left",
			"right",
			"typeAnnotation"
		],
		CallExpression: [
			"callee",
			"typeArguments",
			"arguments"
		],
		ClassDeclaration: SharedVisitorKeys.ClassDeclaration,
		ClassExpression: SharedVisitorKeys.ClassDeclaration,
		Decorator: ["expression"],
		ExportAllDeclaration: [
			"exported",
			"source",
			"attributes"
		],
		ExportNamedDeclaration: [
			"declaration",
			"specifiers",
			"source",
			"attributes"
		],
		FunctionDeclaration: SharedVisitorKeys.Function,
		FunctionExpression: SharedVisitorKeys.Function,
		Identifier: ["decorators", "typeAnnotation"],
		ImportAttribute: ["key", "value"],
		ImportDeclaration: [
			"specifiers",
			"source",
			"attributes"
		],
		ImportExpression: ["source", "options"],
		JSXClosingFragment: [],
		JSXOpeningElement: [
			"name",
			"typeArguments",
			"attributes"
		],
		JSXOpeningFragment: [],
		JSXSpreadChild: ["expression"],
		MethodDefinition: [
			"decorators",
			"key",
			"value"
		],
		NewExpression: [
			"callee",
			"typeArguments",
			"arguments"
		],
		ObjectPattern: [
			"decorators",
			"properties",
			"typeAnnotation"
		],
		PropertyDefinition: SharedVisitorKeys.PropertyDefinition,
		RestElement: [
			"decorators",
			"argument",
			"typeAnnotation"
		],
		StaticBlock: ["body"],
		TaggedTemplateExpression: [
			"tag",
			"typeArguments",
			"quasi"
		],
		TSAbstractAccessorProperty: SharedVisitorKeys.AbstractPropertyDefinition,
		TSAbstractKeyword: [],
		TSAbstractMethodDefinition: ["key", "value"],
		TSAbstractPropertyDefinition: SharedVisitorKeys.AbstractPropertyDefinition,
		TSAnyKeyword: [],
		TSArrayType: ["elementType"],
		TSAsExpression: SharedVisitorKeys.AsExpression,
		TSAsyncKeyword: [],
		TSBigIntKeyword: [],
		TSBooleanKeyword: [],
		TSCallSignatureDeclaration: SharedVisitorKeys.FunctionType,
		TSClassImplements: ["expression", "typeArguments"],
		TSConditionalType: [
			"checkType",
			"extendsType",
			"trueType",
			"falseType"
		],
		TSConstructorType: SharedVisitorKeys.FunctionType,
		TSConstructSignatureDeclaration: SharedVisitorKeys.FunctionType,
		TSDeclareFunction: SharedVisitorKeys.Function,
		TSDeclareKeyword: [],
		TSEmptyBodyFunctionExpression: ["id", ...SharedVisitorKeys.FunctionType],
		TSEnumBody: ["members"],
		TSEnumDeclaration: ["id", "body"],
		TSEnumMember: ["id", "initializer"],
		TSExportAssignment: ["expression"],
		TSExportKeyword: [],
		TSExternalModuleReference: ["expression"],
		TSFunctionType: SharedVisitorKeys.FunctionType,
		TSImportEqualsDeclaration: ["id", "moduleReference"],
		TSImportType: [
			"argument",
			"options",
			"qualifier",
			"typeArguments"
		],
		TSIndexedAccessType: ["objectType", "indexType"],
		TSIndexSignature: ["parameters", "typeAnnotation"],
		TSInferType: ["typeParameter"],
		TSInstantiationExpression: ["expression", "typeArguments"],
		TSInterfaceBody: ["body"],
		TSInterfaceDeclaration: [
			"id",
			"typeParameters",
			"extends",
			"body"
		],
		TSInterfaceHeritage: ["expression", "typeArguments"],
		TSIntersectionType: ["types"],
		TSIntrinsicKeyword: [],
		TSLiteralType: ["literal"],
		TSMappedType: [
			"key",
			"constraint",
			"nameType",
			"typeAnnotation"
		],
		TSMethodSignature: [
			"key",
			"typeParameters",
			"params",
			"returnType"
		],
		TSModuleBlock: ["body"],
		TSModuleDeclaration: ["id", "body"],
		TSNamedTupleMember: ["label", "elementType"],
		TSNamespaceExportDeclaration: ["id"],
		TSNeverKeyword: [],
		TSNonNullExpression: ["expression"],
		TSNullKeyword: [],
		TSNumberKeyword: [],
		TSObjectKeyword: [],
		TSOptionalType: ["typeAnnotation"],
		TSParameterProperty: ["decorators", "parameter"],
		TSPrivateKeyword: [],
		TSPropertySignature: ["key", "typeAnnotation"],
		TSProtectedKeyword: [],
		TSPublicKeyword: [],
		TSQualifiedName: ["left", "right"],
		TSReadonlyKeyword: [],
		TSRestType: ["typeAnnotation"],
		TSSatisfiesExpression: SharedVisitorKeys.AsExpression,
		TSStaticKeyword: [],
		TSStringKeyword: [],
		TSSymbolKeyword: [],
		TSTemplateLiteralType: ["quasis", "types"],
		TSThisType: [],
		TSTupleType: ["elementTypes"],
		TSTypeAliasDeclaration: [
			"id",
			"typeParameters",
			"typeAnnotation"
		],
		TSTypeAnnotation: ["typeAnnotation"],
		TSTypeAssertion: ["typeAnnotation", "expression"],
		TSTypeLiteral: ["members"],
		TSTypeOperator: ["typeAnnotation"],
		TSTypeParameter: [
			"name",
			"constraint",
			"default"
		],
		TSTypeParameterDeclaration: ["params"],
		TSTypeParameterInstantiation: ["params"],
		TSTypePredicate: ["parameterName", "typeAnnotation"],
		TSTypeQuery: ["exprName", "typeArguments"],
		TSTypeReference: ["typeName", "typeArguments"],
		TSUndefinedKeyword: [],
		TSUnionType: ["types"],
		TSUnknownKeyword: [],
		TSVoidKeyword: []
	};
	exports.visitorKeys = eslintVisitorKeys.unionWith(additionalKeys);
})), require_dist$2 = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.visitorKeys = exports.getKeys = void 0;
	var get_keys_1 = require_get_keys();
	Object.defineProperty(exports, "getKeys", {
		enumerable: !0,
		get: function() {
			return get_keys_1.getKeys;
		}
	});
	var visitor_keys_1$2 = require_visitor_keys();
	Object.defineProperty(exports, "visitorKeys", {
		enumerable: !0,
		get: function() {
			return visitor_keys_1$2.visitorKeys;
		}
	});
})), require_ast_spec = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.AST_TOKEN_TYPES = exports.AST_NODE_TYPES = void 0;
	var AST_NODE_TYPES;
	(function(AST_NODE_TYPES$1) {
		AST_NODE_TYPES$1.AccessorProperty = "AccessorProperty", AST_NODE_TYPES$1.ArrayExpression = "ArrayExpression", AST_NODE_TYPES$1.ArrayPattern = "ArrayPattern", AST_NODE_TYPES$1.ArrowFunctionExpression = "ArrowFunctionExpression", AST_NODE_TYPES$1.AssignmentExpression = "AssignmentExpression", AST_NODE_TYPES$1.AssignmentPattern = "AssignmentPattern", AST_NODE_TYPES$1.AwaitExpression = "AwaitExpression", AST_NODE_TYPES$1.BinaryExpression = "BinaryExpression", AST_NODE_TYPES$1.BlockStatement = "BlockStatement", AST_NODE_TYPES$1.BreakStatement = "BreakStatement", AST_NODE_TYPES$1.CallExpression = "CallExpression", AST_NODE_TYPES$1.CatchClause = "CatchClause", AST_NODE_TYPES$1.ChainExpression = "ChainExpression", AST_NODE_TYPES$1.ClassBody = "ClassBody", AST_NODE_TYPES$1.ClassDeclaration = "ClassDeclaration", AST_NODE_TYPES$1.ClassExpression = "ClassExpression", AST_NODE_TYPES$1.ConditionalExpression = "ConditionalExpression", AST_NODE_TYPES$1.ContinueStatement = "ContinueStatement", AST_NODE_TYPES$1.DebuggerStatement = "DebuggerStatement", AST_NODE_TYPES$1.Decorator = "Decorator", AST_NODE_TYPES$1.DoWhileStatement = "DoWhileStatement", AST_NODE_TYPES$1.EmptyStatement = "EmptyStatement", AST_NODE_TYPES$1.ExportAllDeclaration = "ExportAllDeclaration", AST_NODE_TYPES$1.ExportDefaultDeclaration = "ExportDefaultDeclaration", AST_NODE_TYPES$1.ExportNamedDeclaration = "ExportNamedDeclaration", AST_NODE_TYPES$1.ExportSpecifier = "ExportSpecifier", AST_NODE_TYPES$1.ExpressionStatement = "ExpressionStatement", AST_NODE_TYPES$1.ForInStatement = "ForInStatement", AST_NODE_TYPES$1.ForOfStatement = "ForOfStatement", AST_NODE_TYPES$1.ForStatement = "ForStatement", AST_NODE_TYPES$1.FunctionDeclaration = "FunctionDeclaration", AST_NODE_TYPES$1.FunctionExpression = "FunctionExpression", AST_NODE_TYPES$1.Identifier = "Identifier", AST_NODE_TYPES$1.IfStatement = "IfStatement", AST_NODE_TYPES$1.ImportAttribute = "ImportAttribute", AST_NODE_TYPES$1.ImportDeclaration = "ImportDeclaration", AST_NODE_TYPES$1.ImportDefaultSpecifier = "ImportDefaultSpecifier", AST_NODE_TYPES$1.ImportExpression = "ImportExpression", AST_NODE_TYPES$1.ImportNamespaceSpecifier = "ImportNamespaceSpecifier", AST_NODE_TYPES$1.ImportSpecifier = "ImportSpecifier", AST_NODE_TYPES$1.JSXAttribute = "JSXAttribute", AST_NODE_TYPES$1.JSXClosingElement = "JSXClosingElement", AST_NODE_TYPES$1.JSXClosingFragment = "JSXClosingFragment", AST_NODE_TYPES$1.JSXElement = "JSXElement", AST_NODE_TYPES$1.JSXEmptyExpression = "JSXEmptyExpression", AST_NODE_TYPES$1.JSXExpressionContainer = "JSXExpressionContainer", AST_NODE_TYPES$1.JSXFragment = "JSXFragment", AST_NODE_TYPES$1.JSXIdentifier = "JSXIdentifier", AST_NODE_TYPES$1.JSXMemberExpression = "JSXMemberExpression", AST_NODE_TYPES$1.JSXNamespacedName = "JSXNamespacedName", AST_NODE_TYPES$1.JSXOpeningElement = "JSXOpeningElement", AST_NODE_TYPES$1.JSXOpeningFragment = "JSXOpeningFragment", AST_NODE_TYPES$1.JSXSpreadAttribute = "JSXSpreadAttribute", AST_NODE_TYPES$1.JSXSpreadChild = "JSXSpreadChild", AST_NODE_TYPES$1.JSXText = "JSXText", AST_NODE_TYPES$1.LabeledStatement = "LabeledStatement", AST_NODE_TYPES$1.Literal = "Literal", AST_NODE_TYPES$1.LogicalExpression = "LogicalExpression", AST_NODE_TYPES$1.MemberExpression = "MemberExpression", AST_NODE_TYPES$1.MetaProperty = "MetaProperty", AST_NODE_TYPES$1.MethodDefinition = "MethodDefinition", AST_NODE_TYPES$1.NewExpression = "NewExpression", AST_NODE_TYPES$1.ObjectExpression = "ObjectExpression", AST_NODE_TYPES$1.ObjectPattern = "ObjectPattern", AST_NODE_TYPES$1.PrivateIdentifier = "PrivateIdentifier", AST_NODE_TYPES$1.Program = "Program", AST_NODE_TYPES$1.Property = "Property", AST_NODE_TYPES$1.PropertyDefinition = "PropertyDefinition", AST_NODE_TYPES$1.RestElement = "RestElement", AST_NODE_TYPES$1.ReturnStatement = "ReturnStatement", AST_NODE_TYPES$1.SequenceExpression = "SequenceExpression", AST_NODE_TYPES$1.SpreadElement = "SpreadElement", AST_NODE_TYPES$1.StaticBlock = "StaticBlock", AST_NODE_TYPES$1.Super = "Super", AST_NODE_TYPES$1.SwitchCase = "SwitchCase", AST_NODE_TYPES$1.SwitchStatement = "SwitchStatement", AST_NODE_TYPES$1.TaggedTemplateExpression = "TaggedTemplateExpression", AST_NODE_TYPES$1.TemplateElement = "TemplateElement", AST_NODE_TYPES$1.TemplateLiteral = "TemplateLiteral", AST_NODE_TYPES$1.ThisExpression = "ThisExpression", AST_NODE_TYPES$1.ThrowStatement = "ThrowStatement", AST_NODE_TYPES$1.TryStatement = "TryStatement", AST_NODE_TYPES$1.UnaryExpression = "UnaryExpression", AST_NODE_TYPES$1.UpdateExpression = "UpdateExpression", AST_NODE_TYPES$1.VariableDeclaration = "VariableDeclaration", AST_NODE_TYPES$1.VariableDeclarator = "VariableDeclarator", AST_NODE_TYPES$1.WhileStatement = "WhileStatement", AST_NODE_TYPES$1.WithStatement = "WithStatement", AST_NODE_TYPES$1.YieldExpression = "YieldExpression", AST_NODE_TYPES$1.TSAbstractAccessorProperty = "TSAbstractAccessorProperty", AST_NODE_TYPES$1.TSAbstractKeyword = "TSAbstractKeyword", AST_NODE_TYPES$1.TSAbstractMethodDefinition = "TSAbstractMethodDefinition", AST_NODE_TYPES$1.TSAbstractPropertyDefinition = "TSAbstractPropertyDefinition", AST_NODE_TYPES$1.TSAnyKeyword = "TSAnyKeyword", AST_NODE_TYPES$1.TSArrayType = "TSArrayType", AST_NODE_TYPES$1.TSAsExpression = "TSAsExpression", AST_NODE_TYPES$1.TSAsyncKeyword = "TSAsyncKeyword", AST_NODE_TYPES$1.TSBigIntKeyword = "TSBigIntKeyword", AST_NODE_TYPES$1.TSBooleanKeyword = "TSBooleanKeyword", AST_NODE_TYPES$1.TSCallSignatureDeclaration = "TSCallSignatureDeclaration", AST_NODE_TYPES$1.TSClassImplements = "TSClassImplements", AST_NODE_TYPES$1.TSConditionalType = "TSConditionalType", AST_NODE_TYPES$1.TSConstructorType = "TSConstructorType", AST_NODE_TYPES$1.TSConstructSignatureDeclaration = "TSConstructSignatureDeclaration", AST_NODE_TYPES$1.TSDeclareFunction = "TSDeclareFunction", AST_NODE_TYPES$1.TSDeclareKeyword = "TSDeclareKeyword", AST_NODE_TYPES$1.TSEmptyBodyFunctionExpression = "TSEmptyBodyFunctionExpression", AST_NODE_TYPES$1.TSEnumBody = "TSEnumBody", AST_NODE_TYPES$1.TSEnumDeclaration = "TSEnumDeclaration", AST_NODE_TYPES$1.TSEnumMember = "TSEnumMember", AST_NODE_TYPES$1.TSExportAssignment = "TSExportAssignment", AST_NODE_TYPES$1.TSExportKeyword = "TSExportKeyword", AST_NODE_TYPES$1.TSExternalModuleReference = "TSExternalModuleReference", AST_NODE_TYPES$1.TSFunctionType = "TSFunctionType", AST_NODE_TYPES$1.TSImportEqualsDeclaration = "TSImportEqualsDeclaration", AST_NODE_TYPES$1.TSImportType = "TSImportType", AST_NODE_TYPES$1.TSIndexedAccessType = "TSIndexedAccessType", AST_NODE_TYPES$1.TSIndexSignature = "TSIndexSignature", AST_NODE_TYPES$1.TSInferType = "TSInferType", AST_NODE_TYPES$1.TSInstantiationExpression = "TSInstantiationExpression", AST_NODE_TYPES$1.TSInterfaceBody = "TSInterfaceBody", AST_NODE_TYPES$1.TSInterfaceDeclaration = "TSInterfaceDeclaration", AST_NODE_TYPES$1.TSInterfaceHeritage = "TSInterfaceHeritage", AST_NODE_TYPES$1.TSIntersectionType = "TSIntersectionType", AST_NODE_TYPES$1.TSIntrinsicKeyword = "TSIntrinsicKeyword", AST_NODE_TYPES$1.TSLiteralType = "TSLiteralType", AST_NODE_TYPES$1.TSMappedType = "TSMappedType", AST_NODE_TYPES$1.TSMethodSignature = "TSMethodSignature", AST_NODE_TYPES$1.TSModuleBlock = "TSModuleBlock", AST_NODE_TYPES$1.TSModuleDeclaration = "TSModuleDeclaration", AST_NODE_TYPES$1.TSNamedTupleMember = "TSNamedTupleMember", AST_NODE_TYPES$1.TSNamespaceExportDeclaration = "TSNamespaceExportDeclaration", AST_NODE_TYPES$1.TSNeverKeyword = "TSNeverKeyword", AST_NODE_TYPES$1.TSNonNullExpression = "TSNonNullExpression", AST_NODE_TYPES$1.TSNullKeyword = "TSNullKeyword", AST_NODE_TYPES$1.TSNumberKeyword = "TSNumberKeyword", AST_NODE_TYPES$1.TSObjectKeyword = "TSObjectKeyword", AST_NODE_TYPES$1.TSOptionalType = "TSOptionalType", AST_NODE_TYPES$1.TSParameterProperty = "TSParameterProperty", AST_NODE_TYPES$1.TSPrivateKeyword = "TSPrivateKeyword", AST_NODE_TYPES$1.TSPropertySignature = "TSPropertySignature", AST_NODE_TYPES$1.TSProtectedKeyword = "TSProtectedKeyword", AST_NODE_TYPES$1.TSPublicKeyword = "TSPublicKeyword", AST_NODE_TYPES$1.TSQualifiedName = "TSQualifiedName", AST_NODE_TYPES$1.TSReadonlyKeyword = "TSReadonlyKeyword", AST_NODE_TYPES$1.TSRestType = "TSRestType", AST_NODE_TYPES$1.TSSatisfiesExpression = "TSSatisfiesExpression", AST_NODE_TYPES$1.TSStaticKeyword = "TSStaticKeyword", AST_NODE_TYPES$1.TSStringKeyword = "TSStringKeyword", AST_NODE_TYPES$1.TSSymbolKeyword = "TSSymbolKeyword", AST_NODE_TYPES$1.TSTemplateLiteralType = "TSTemplateLiteralType", AST_NODE_TYPES$1.TSThisType = "TSThisType", AST_NODE_TYPES$1.TSTupleType = "TSTupleType", AST_NODE_TYPES$1.TSTypeAliasDeclaration = "TSTypeAliasDeclaration", AST_NODE_TYPES$1.TSTypeAnnotation = "TSTypeAnnotation", AST_NODE_TYPES$1.TSTypeAssertion = "TSTypeAssertion", AST_NODE_TYPES$1.TSTypeLiteral = "TSTypeLiteral", AST_NODE_TYPES$1.TSTypeOperator = "TSTypeOperator", AST_NODE_TYPES$1.TSTypeParameter = "TSTypeParameter", AST_NODE_TYPES$1.TSTypeParameterDeclaration = "TSTypeParameterDeclaration", AST_NODE_TYPES$1.TSTypeParameterInstantiation = "TSTypeParameterInstantiation", AST_NODE_TYPES$1.TSTypePredicate = "TSTypePredicate", AST_NODE_TYPES$1.TSTypeQuery = "TSTypeQuery", AST_NODE_TYPES$1.TSTypeReference = "TSTypeReference", AST_NODE_TYPES$1.TSUndefinedKeyword = "TSUndefinedKeyword", AST_NODE_TYPES$1.TSUnionType = "TSUnionType", AST_NODE_TYPES$1.TSUnknownKeyword = "TSUnknownKeyword", AST_NODE_TYPES$1.TSVoidKeyword = "TSVoidKeyword";
	})(AST_NODE_TYPES || (exports.AST_NODE_TYPES = AST_NODE_TYPES = {}));
	var AST_TOKEN_TYPES;
	(function(AST_TOKEN_TYPES$1) {
		AST_TOKEN_TYPES$1.Boolean = "Boolean", AST_TOKEN_TYPES$1.Identifier = "Identifier", AST_TOKEN_TYPES$1.JSXIdentifier = "JSXIdentifier", AST_TOKEN_TYPES$1.PrivateIdentifier = "PrivateIdentifier", AST_TOKEN_TYPES$1.JSXText = "JSXText", AST_TOKEN_TYPES$1.Keyword = "Keyword", AST_TOKEN_TYPES$1.Null = "Null", AST_TOKEN_TYPES$1.Numeric = "Numeric", AST_TOKEN_TYPES$1.Punctuator = "Punctuator", AST_TOKEN_TYPES$1.RegularExpression = "RegularExpression", AST_TOKEN_TYPES$1.String = "String", AST_TOKEN_TYPES$1.Template = "Template", AST_TOKEN_TYPES$1.Block = "Block", AST_TOKEN_TYPES$1.Line = "Line";
	})(AST_TOKEN_TYPES || (exports.AST_TOKEN_TYPES = AST_TOKEN_TYPES = {}));
})), require_lib$2 = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 });
})), require_parser_options = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 });
})), require_ts_estree = /* @__PURE__ */ __commonJSMin(((exports) => {
	var __createBinding$4 = exports && exports.__createBinding || (Object.create ? (function(o, m, k, k2) {
		k2 === void 0 && (k2 = k);
		var desc = Object.getOwnPropertyDescriptor(m, k);
		(!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) && (desc = {
			enumerable: !0,
			get: function() {
				return m[k];
			}
		}), Object.defineProperty(o, k2, desc);
	}) : (function(o, m, k, k2) {
		k2 === void 0 && (k2 = k), o[k2] = m[k];
	})), __setModuleDefault = exports && exports.__setModuleDefault || (Object.create ? (function(o, v) {
		Object.defineProperty(o, "default", {
			enumerable: !0,
			value: v
		});
	}) : function(o, v) {
		o.default = v;
	}), __importStar = exports && exports.__importStar || (function() {
		var ownKeys$1 = function(o) {
			return ownKeys$1 = Object.getOwnPropertyNames || function(o$1) {
				var ar = [];
				for (var k in o$1) Object.prototype.hasOwnProperty.call(o$1, k) && (ar[ar.length] = k);
				return ar;
			}, ownKeys$1(o);
		};
		return function(mod) {
			if (mod && mod.__esModule) return mod;
			var result = {};
			if (mod != null) for (var k = ownKeys$1(mod), i = 0; i < k.length; i++) k[i] !== "default" && __createBinding$4(result, mod, k[i]);
			return __setModuleDefault(result, mod), result;
		};
	})();
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.TSESTree = void 0, exports.TSESTree = __importStar(require_ast_spec());
})), require_dist$1 = /* @__PURE__ */ __commonJSMin(((exports) => {
	var __createBinding$3 = exports && exports.__createBinding || (Object.create ? (function(o, m, k, k2) {
		k2 === void 0 && (k2 = k);
		var desc = Object.getOwnPropertyDescriptor(m, k);
		(!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) && (desc = {
			enumerable: !0,
			get: function() {
				return m[k];
			}
		}), Object.defineProperty(o, k2, desc);
	}) : (function(o, m, k, k2) {
		k2 === void 0 && (k2 = k), o[k2] = m[k];
	})), __exportStar$3 = exports && exports.__exportStar || function(m, exports$1) {
		for (var p in m) p !== "default" && !Object.prototype.hasOwnProperty.call(exports$1, p) && __createBinding$3(exports$1, m, p);
	};
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.AST_TOKEN_TYPES = exports.AST_NODE_TYPES = void 0;
	var ast_spec_1 = require_ast_spec();
	Object.defineProperty(exports, "AST_NODE_TYPES", {
		enumerable: !0,
		get: function() {
			return ast_spec_1.AST_NODE_TYPES;
		}
	}), Object.defineProperty(exports, "AST_TOKEN_TYPES", {
		enumerable: !0,
		get: function() {
			return ast_spec_1.AST_TOKEN_TYPES;
		}
	}), __exportStar$3(require_lib$2(), exports), __exportStar$3(require_parser_options(), exports), __exportStar$3(require_ts_estree(), exports);
})), require_assert = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.assert = assert;
	function assert(value, message) {
		if (value == null) throw Error(message);
	}
})), require_ID = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.createIdGenerator = createIdGenerator, exports.resetIds = resetIds;
	let ID_CACHE = /* @__PURE__ */ new Map(), NEXT_KEY = 0;
	function createIdGenerator() {
		let key = NEXT_KEY += 1;
		return ID_CACHE.set(key, 0), () => {
			let next = (ID_CACHE.get(key) ?? 0) + 1;
			return ID_CACHE.set(key, next), next;
		};
	}
	function resetIds() {
		ID_CACHE.clear();
	}
})), require_DefinitionBase = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.DefinitionBase = void 0;
	let generator$3 = (0, require_ID().createIdGenerator)();
	var DefinitionBase = class {
		$id = generator$3();
		type;
		name;
		node;
		parent;
		constructor(type, name, node, parent$1) {
			this.type = type, this.name = name, this.node = node, this.parent = parent$1;
		}
	};
	exports.DefinitionBase = DefinitionBase;
})), require_DefinitionType = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.DefinitionType = void 0;
	var DefinitionType;
	(function(DefinitionType$1) {
		DefinitionType$1.CatchClause = "CatchClause", DefinitionType$1.ClassName = "ClassName", DefinitionType$1.FunctionName = "FunctionName", DefinitionType$1.ImplicitGlobalVariable = "ImplicitGlobalVariable", DefinitionType$1.ImportBinding = "ImportBinding", DefinitionType$1.Parameter = "Parameter", DefinitionType$1.TSEnumName = "TSEnumName", DefinitionType$1.TSEnumMember = "TSEnumMemberName", DefinitionType$1.TSModuleName = "TSModuleName", DefinitionType$1.Type = "Type", DefinitionType$1.Variable = "Variable";
	})(DefinitionType || (exports.DefinitionType = DefinitionType = {}));
})), require_CatchClauseDefinition = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.CatchClauseDefinition = void 0;
	let DefinitionBase_1$10 = require_DefinitionBase(), DefinitionType_1$10 = require_DefinitionType();
	var CatchClauseDefinition = class extends DefinitionBase_1$10.DefinitionBase {
		isTypeDefinition = !1;
		isVariableDefinition = !0;
		constructor(name, node) {
			super(DefinitionType_1$10.DefinitionType.CatchClause, name, node, null);
		}
	};
	exports.CatchClauseDefinition = CatchClauseDefinition;
})), require_ClassNameDefinition = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ClassNameDefinition = void 0;
	let DefinitionBase_1$9 = require_DefinitionBase(), DefinitionType_1$9 = require_DefinitionType();
	var ClassNameDefinition = class extends DefinitionBase_1$9.DefinitionBase {
		isTypeDefinition = !0;
		isVariableDefinition = !0;
		constructor(name, node) {
			super(DefinitionType_1$9.DefinitionType.ClassName, name, node, null);
		}
	};
	exports.ClassNameDefinition = ClassNameDefinition;
})), require_Definition = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 });
})), require_FunctionNameDefinition = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.FunctionNameDefinition = void 0;
	let DefinitionBase_1$8 = require_DefinitionBase(), DefinitionType_1$8 = require_DefinitionType();
	var FunctionNameDefinition = class extends DefinitionBase_1$8.DefinitionBase {
		isTypeDefinition = !1;
		isVariableDefinition = !0;
		constructor(name, node) {
			super(DefinitionType_1$8.DefinitionType.FunctionName, name, node, null);
		}
	};
	exports.FunctionNameDefinition = FunctionNameDefinition;
})), require_ImplicitGlobalVariableDefinition = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ImplicitGlobalVariableDefinition = void 0;
	let DefinitionBase_1$7 = require_DefinitionBase(), DefinitionType_1$7 = require_DefinitionType();
	var ImplicitGlobalVariableDefinition = class extends DefinitionBase_1$7.DefinitionBase {
		isTypeDefinition = !1;
		isVariableDefinition = !0;
		constructor(name, node) {
			super(DefinitionType_1$7.DefinitionType.ImplicitGlobalVariable, name, node, null);
		}
	};
	exports.ImplicitGlobalVariableDefinition = ImplicitGlobalVariableDefinition;
})), require_ImportBindingDefinition = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ImportBindingDefinition = void 0;
	let DefinitionBase_1$6 = require_DefinitionBase(), DefinitionType_1$6 = require_DefinitionType();
	var ImportBindingDefinition = class extends DefinitionBase_1$6.DefinitionBase {
		isTypeDefinition = !0;
		isVariableDefinition = !0;
		constructor(name, node, decl) {
			super(DefinitionType_1$6.DefinitionType.ImportBinding, name, node, decl);
		}
	};
	exports.ImportBindingDefinition = ImportBindingDefinition;
})), require_ParameterDefinition = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ParameterDefinition = void 0;
	let DefinitionBase_1$5 = require_DefinitionBase(), DefinitionType_1$5 = require_DefinitionType();
	var ParameterDefinition = class extends DefinitionBase_1$5.DefinitionBase {
		isTypeDefinition = !1;
		isVariableDefinition = !0;
		rest;
		constructor(name, node, rest) {
			super(DefinitionType_1$5.DefinitionType.Parameter, name, node, null), this.rest = rest;
		}
	};
	exports.ParameterDefinition = ParameterDefinition;
})), require_TSEnumMemberDefinition = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.TSEnumMemberDefinition = void 0;
	let DefinitionBase_1$4 = require_DefinitionBase(), DefinitionType_1$4 = require_DefinitionType();
	var TSEnumMemberDefinition = class extends DefinitionBase_1$4.DefinitionBase {
		isTypeDefinition = !0;
		isVariableDefinition = !0;
		constructor(name, node) {
			super(DefinitionType_1$4.DefinitionType.TSEnumMember, name, node, null);
		}
	};
	exports.TSEnumMemberDefinition = TSEnumMemberDefinition;
})), require_TSEnumNameDefinition = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.TSEnumNameDefinition = void 0;
	let DefinitionBase_1$3 = require_DefinitionBase(), DefinitionType_1$3 = require_DefinitionType();
	var TSEnumNameDefinition = class extends DefinitionBase_1$3.DefinitionBase {
		isTypeDefinition = !0;
		isVariableDefinition = !0;
		constructor(name, node) {
			super(DefinitionType_1$3.DefinitionType.TSEnumName, name, node, null);
		}
	};
	exports.TSEnumNameDefinition = TSEnumNameDefinition;
})), require_TSModuleNameDefinition = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.TSModuleNameDefinition = void 0;
	let DefinitionBase_1$2 = require_DefinitionBase(), DefinitionType_1$2 = require_DefinitionType();
	var TSModuleNameDefinition = class extends DefinitionBase_1$2.DefinitionBase {
		isTypeDefinition = !0;
		isVariableDefinition = !0;
		constructor(name, node) {
			super(DefinitionType_1$2.DefinitionType.TSModuleName, name, node, null);
		}
	};
	exports.TSModuleNameDefinition = TSModuleNameDefinition;
})), require_TypeDefinition = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.TypeDefinition = void 0;
	let DefinitionBase_1$1 = require_DefinitionBase(), DefinitionType_1$1 = require_DefinitionType();
	var TypeDefinition = class extends DefinitionBase_1$1.DefinitionBase {
		isTypeDefinition = !0;
		isVariableDefinition = !1;
		constructor(name, node) {
			super(DefinitionType_1$1.DefinitionType.Type, name, node, null);
		}
	};
	exports.TypeDefinition = TypeDefinition;
})), require_VariableDefinition = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.VariableDefinition = void 0;
	let DefinitionBase_1 = require_DefinitionBase(), DefinitionType_1 = require_DefinitionType();
	var VariableDefinition = class extends DefinitionBase_1.DefinitionBase {
		isTypeDefinition = !1;
		isVariableDefinition = !0;
		constructor(name, node, decl) {
			super(DefinitionType_1.DefinitionType.Variable, name, node, decl);
		}
	};
	exports.VariableDefinition = VariableDefinition;
})), require_definition = /* @__PURE__ */ __commonJSMin(((exports) => {
	var __createBinding$2 = exports && exports.__createBinding || (Object.create ? (function(o, m, k, k2) {
		k2 === void 0 && (k2 = k);
		var desc = Object.getOwnPropertyDescriptor(m, k);
		(!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) && (desc = {
			enumerable: !0,
			get: function() {
				return m[k];
			}
		}), Object.defineProperty(o, k2, desc);
	}) : (function(o, m, k, k2) {
		k2 === void 0 && (k2 = k), o[k2] = m[k];
	})), __exportStar$2 = exports && exports.__exportStar || function(m, exports$1) {
		for (var p in m) p !== "default" && !Object.prototype.hasOwnProperty.call(exports$1, p) && __createBinding$2(exports$1, m, p);
	};
	Object.defineProperty(exports, "__esModule", { value: !0 }), __exportStar$2(require_CatchClauseDefinition(), exports), __exportStar$2(require_ClassNameDefinition(), exports), __exportStar$2(require_Definition(), exports), __exportStar$2(require_DefinitionType(), exports), __exportStar$2(require_FunctionNameDefinition(), exports), __exportStar$2(require_ImplicitGlobalVariableDefinition(), exports), __exportStar$2(require_ImportBindingDefinition(), exports), __exportStar$2(require_ParameterDefinition(), exports), __exportStar$2(require_TSEnumMemberDefinition(), exports), __exportStar$2(require_TSEnumNameDefinition(), exports), __exportStar$2(require_TSModuleNameDefinition(), exports), __exportStar$2(require_TypeDefinition(), exports), __exportStar$2(require_VariableDefinition(), exports);
})), require_base_config = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.TYPE_VALUE = exports.VALUE = exports.TYPE = void 0, exports.TYPE = Object.freeze({
		eslintImplicitGlobalSetting: "readonly",
		isTypeVariable: !0,
		isValueVariable: !1
	}), exports.VALUE = Object.freeze({
		eslintImplicitGlobalSetting: "readonly",
		isTypeVariable: !1,
		isValueVariable: !0
	}), exports.TYPE_VALUE = Object.freeze({
		eslintImplicitGlobalSetting: "readonly",
		isTypeVariable: !0,
		isValueVariable: !0
	});
})), require_decorators = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.decorators = void 0;
	let base_config_1$82 = require_base_config();
	exports.decorators = {
		libs: [],
		variables: [
			["ClassMemberDecoratorContext", base_config_1$82.TYPE],
			["DecoratorContext", base_config_1$82.TYPE],
			["DecoratorMetadataObject", base_config_1$82.TYPE],
			["DecoratorMetadata", base_config_1$82.TYPE],
			["ClassDecoratorContext", base_config_1$82.TYPE],
			["ClassMethodDecoratorContext", base_config_1$82.TYPE],
			["ClassGetterDecoratorContext", base_config_1$82.TYPE],
			["ClassSetterDecoratorContext", base_config_1$82.TYPE],
			["ClassAccessorDecoratorContext", base_config_1$82.TYPE],
			["ClassAccessorDecoratorTarget", base_config_1$82.TYPE],
			["ClassAccessorDecoratorResult", base_config_1$82.TYPE],
			["ClassFieldDecoratorContext", base_config_1$82.TYPE]
		]
	};
})), require_decorators_legacy = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.decorators_legacy = void 0;
	let base_config_1$81 = require_base_config();
	exports.decorators_legacy = {
		libs: [],
		variables: [
			["ClassDecorator", base_config_1$81.TYPE],
			["PropertyDecorator", base_config_1$81.TYPE],
			["MethodDecorator", base_config_1$81.TYPE],
			["ParameterDecorator", base_config_1$81.TYPE]
		]
	};
})), require_dom = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.dom = void 0;
	let base_config_1$80 = require_base_config();
	exports.dom = {
		libs: [],
		variables: [
			["AddEventListenerOptions", base_config_1$80.TYPE],
			["AddressErrors", base_config_1$80.TYPE],
			["AesCbcParams", base_config_1$80.TYPE],
			["AesCtrParams", base_config_1$80.TYPE],
			["AesDerivedKeyParams", base_config_1$80.TYPE],
			["AesGcmParams", base_config_1$80.TYPE],
			["AesKeyAlgorithm", base_config_1$80.TYPE],
			["AesKeyGenParams", base_config_1$80.TYPE],
			["Algorithm", base_config_1$80.TYPE],
			["AnalyserOptions", base_config_1$80.TYPE],
			["AnimationEventInit", base_config_1$80.TYPE],
			["AnimationPlaybackEventInit", base_config_1$80.TYPE],
			["AssignedNodesOptions", base_config_1$80.TYPE],
			["AudioBufferOptions", base_config_1$80.TYPE],
			["AudioBufferSourceOptions", base_config_1$80.TYPE],
			["AudioConfiguration", base_config_1$80.TYPE],
			["AudioContextOptions", base_config_1$80.TYPE],
			["AudioDataCopyToOptions", base_config_1$80.TYPE],
			["AudioDataInit", base_config_1$80.TYPE],
			["AudioDecoderConfig", base_config_1$80.TYPE],
			["AudioDecoderInit", base_config_1$80.TYPE],
			["AudioDecoderSupport", base_config_1$80.TYPE],
			["AudioEncoderConfig", base_config_1$80.TYPE],
			["AudioEncoderInit", base_config_1$80.TYPE],
			["AudioEncoderSupport", base_config_1$80.TYPE],
			["AudioNodeOptions", base_config_1$80.TYPE],
			["AudioProcessingEventInit", base_config_1$80.TYPE],
			["AudioTimestamp", base_config_1$80.TYPE],
			["AudioWorkletNodeOptions", base_config_1$80.TYPE],
			["AuthenticationExtensionsClientInputs", base_config_1$80.TYPE],
			["AuthenticationExtensionsClientInputsJSON", base_config_1$80.TYPE],
			["AuthenticationExtensionsClientOutputs", base_config_1$80.TYPE],
			["AuthenticationExtensionsLargeBlobInputs", base_config_1$80.TYPE],
			["AuthenticationExtensionsLargeBlobInputsJSON", base_config_1$80.TYPE],
			["AuthenticationExtensionsLargeBlobOutputs", base_config_1$80.TYPE],
			["AuthenticationExtensionsPRFInputs", base_config_1$80.TYPE],
			["AuthenticationExtensionsPRFInputsJSON", base_config_1$80.TYPE],
			["AuthenticationExtensionsPRFOutputs", base_config_1$80.TYPE],
			["AuthenticationExtensionsPRFValues", base_config_1$80.TYPE],
			["AuthenticationExtensionsPRFValuesJSON", base_config_1$80.TYPE],
			["AuthenticatorSelectionCriteria", base_config_1$80.TYPE],
			["AvcEncoderConfig", base_config_1$80.TYPE],
			["BiquadFilterOptions", base_config_1$80.TYPE],
			["BlobEventInit", base_config_1$80.TYPE],
			["BlobPropertyBag", base_config_1$80.TYPE],
			["CSSMatrixComponentOptions", base_config_1$80.TYPE],
			["CSSNumericType", base_config_1$80.TYPE],
			["CSSStyleSheetInit", base_config_1$80.TYPE],
			["CacheQueryOptions", base_config_1$80.TYPE],
			["CanvasRenderingContext2DSettings", base_config_1$80.TYPE],
			["CaretPositionFromPointOptions", base_config_1$80.TYPE],
			["ChannelMergerOptions", base_config_1$80.TYPE],
			["ChannelSplitterOptions", base_config_1$80.TYPE],
			["CheckVisibilityOptions", base_config_1$80.TYPE],
			["ClientQueryOptions", base_config_1$80.TYPE],
			["ClipboardEventInit", base_config_1$80.TYPE],
			["ClipboardItemOptions", base_config_1$80.TYPE],
			["CloseEventInit", base_config_1$80.TYPE],
			["CompositionEventInit", base_config_1$80.TYPE],
			["ComputedEffectTiming", base_config_1$80.TYPE],
			["ComputedKeyframe", base_config_1$80.TYPE],
			["ConstantSourceOptions", base_config_1$80.TYPE],
			["ConstrainBooleanParameters", base_config_1$80.TYPE],
			["ConstrainDOMStringParameters", base_config_1$80.TYPE],
			["ConstrainDoubleRange", base_config_1$80.TYPE],
			["ConstrainULongRange", base_config_1$80.TYPE],
			["ContentVisibilityAutoStateChangeEventInit", base_config_1$80.TYPE],
			["ConvolverOptions", base_config_1$80.TYPE],
			["CookieChangeEventInit", base_config_1$80.TYPE],
			["CookieInit", base_config_1$80.TYPE],
			["CookieListItem", base_config_1$80.TYPE],
			["CookieStoreDeleteOptions", base_config_1$80.TYPE],
			["CookieStoreGetOptions", base_config_1$80.TYPE],
			["CredentialCreationOptions", base_config_1$80.TYPE],
			["CredentialPropertiesOutput", base_config_1$80.TYPE],
			["CredentialRequestOptions", base_config_1$80.TYPE],
			["CryptoKeyPair", base_config_1$80.TYPE],
			["CustomEventInit", base_config_1$80.TYPE],
			["DOMMatrix2DInit", base_config_1$80.TYPE],
			["DOMMatrixInit", base_config_1$80.TYPE],
			["DOMPointInit", base_config_1$80.TYPE],
			["DOMQuadInit", base_config_1$80.TYPE],
			["DOMRectInit", base_config_1$80.TYPE],
			["DelayOptions", base_config_1$80.TYPE],
			["DeviceMotionEventAccelerationInit", base_config_1$80.TYPE],
			["DeviceMotionEventInit", base_config_1$80.TYPE],
			["DeviceMotionEventRotationRateInit", base_config_1$80.TYPE],
			["DeviceOrientationEventInit", base_config_1$80.TYPE],
			["DisplayMediaStreamOptions", base_config_1$80.TYPE],
			["DocumentTimelineOptions", base_config_1$80.TYPE],
			["DoubleRange", base_config_1$80.TYPE],
			["DragEventInit", base_config_1$80.TYPE],
			["DynamicsCompressorOptions", base_config_1$80.TYPE],
			["EcKeyAlgorithm", base_config_1$80.TYPE],
			["EcKeyGenParams", base_config_1$80.TYPE],
			["EcKeyImportParams", base_config_1$80.TYPE],
			["EcdhKeyDeriveParams", base_config_1$80.TYPE],
			["EcdsaParams", base_config_1$80.TYPE],
			["EffectTiming", base_config_1$80.TYPE],
			["ElementCreationOptions", base_config_1$80.TYPE],
			["ElementDefinitionOptions", base_config_1$80.TYPE],
			["EncodedAudioChunkInit", base_config_1$80.TYPE],
			["EncodedAudioChunkMetadata", base_config_1$80.TYPE],
			["EncodedVideoChunkInit", base_config_1$80.TYPE],
			["EncodedVideoChunkMetadata", base_config_1$80.TYPE],
			["ErrorEventInit", base_config_1$80.TYPE],
			["EventInit", base_config_1$80.TYPE],
			["EventListenerOptions", base_config_1$80.TYPE],
			["EventModifierInit", base_config_1$80.TYPE],
			["EventSourceInit", base_config_1$80.TYPE],
			["FilePropertyBag", base_config_1$80.TYPE],
			["FileSystemCreateWritableOptions", base_config_1$80.TYPE],
			["FileSystemFlags", base_config_1$80.TYPE],
			["FileSystemGetDirectoryOptions", base_config_1$80.TYPE],
			["FileSystemGetFileOptions", base_config_1$80.TYPE],
			["FileSystemRemoveOptions", base_config_1$80.TYPE],
			["FocusEventInit", base_config_1$80.TYPE],
			["FocusOptions", base_config_1$80.TYPE],
			["FontFaceDescriptors", base_config_1$80.TYPE],
			["FontFaceSetLoadEventInit", base_config_1$80.TYPE],
			["FormDataEventInit", base_config_1$80.TYPE],
			["FullscreenOptions", base_config_1$80.TYPE],
			["GainOptions", base_config_1$80.TYPE],
			["GamepadEffectParameters", base_config_1$80.TYPE],
			["GamepadEventInit", base_config_1$80.TYPE],
			["GetAnimationsOptions", base_config_1$80.TYPE],
			["GetComposedRangesOptions", base_config_1$80.TYPE],
			["GetHTMLOptions", base_config_1$80.TYPE],
			["GetNotificationOptions", base_config_1$80.TYPE],
			["GetRootNodeOptions", base_config_1$80.TYPE],
			["HashChangeEventInit", base_config_1$80.TYPE],
			["HkdfParams", base_config_1$80.TYPE],
			["HmacImportParams", base_config_1$80.TYPE],
			["HmacKeyAlgorithm", base_config_1$80.TYPE],
			["HmacKeyGenParams", base_config_1$80.TYPE],
			["IDBDatabaseInfo", base_config_1$80.TYPE],
			["IDBIndexParameters", base_config_1$80.TYPE],
			["IDBObjectStoreParameters", base_config_1$80.TYPE],
			["IDBTransactionOptions", base_config_1$80.TYPE],
			["IDBVersionChangeEventInit", base_config_1$80.TYPE],
			["IIRFilterOptions", base_config_1$80.TYPE],
			["IdleRequestOptions", base_config_1$80.TYPE],
			["ImageBitmapOptions", base_config_1$80.TYPE],
			["ImageBitmapRenderingContextSettings", base_config_1$80.TYPE],
			["ImageDataSettings", base_config_1$80.TYPE],
			["ImageDecodeOptions", base_config_1$80.TYPE],
			["ImageDecodeResult", base_config_1$80.TYPE],
			["ImageDecoderInit", base_config_1$80.TYPE],
			["ImageEncodeOptions", base_config_1$80.TYPE],
			["ImportNodeOptions", base_config_1$80.TYPE],
			["InputEventInit", base_config_1$80.TYPE],
			["IntersectionObserverInit", base_config_1$80.TYPE],
			["JsonWebKey", base_config_1$80.TYPE],
			["KeyAlgorithm", base_config_1$80.TYPE],
			["KeySystemTrackConfiguration", base_config_1$80.TYPE],
			["KeyboardEventInit", base_config_1$80.TYPE],
			["Keyframe", base_config_1$80.TYPE],
			["KeyframeAnimationOptions", base_config_1$80.TYPE],
			["KeyframeEffectOptions", base_config_1$80.TYPE],
			["LockInfo", base_config_1$80.TYPE],
			["LockManagerSnapshot", base_config_1$80.TYPE],
			["LockOptions", base_config_1$80.TYPE],
			["MIDIConnectionEventInit", base_config_1$80.TYPE],
			["MIDIMessageEventInit", base_config_1$80.TYPE],
			["MIDIOptions", base_config_1$80.TYPE],
			["MediaCapabilitiesDecodingInfo", base_config_1$80.TYPE],
			["MediaCapabilitiesEncodingInfo", base_config_1$80.TYPE],
			["MediaCapabilitiesInfo", base_config_1$80.TYPE],
			["MediaCapabilitiesKeySystemConfiguration", base_config_1$80.TYPE],
			["MediaConfiguration", base_config_1$80.TYPE],
			["MediaDecodingConfiguration", base_config_1$80.TYPE],
			["MediaElementAudioSourceOptions", base_config_1$80.TYPE],
			["MediaEncodingConfiguration", base_config_1$80.TYPE],
			["MediaEncryptedEventInit", base_config_1$80.TYPE],
			["MediaImage", base_config_1$80.TYPE],
			["MediaKeyMessageEventInit", base_config_1$80.TYPE],
			["MediaKeySystemConfiguration", base_config_1$80.TYPE],
			["MediaKeySystemMediaCapability", base_config_1$80.TYPE],
			["MediaKeysPolicy", base_config_1$80.TYPE],
			["MediaMetadataInit", base_config_1$80.TYPE],
			["MediaPositionState", base_config_1$80.TYPE],
			["MediaQueryListEventInit", base_config_1$80.TYPE],
			["MediaRecorderOptions", base_config_1$80.TYPE],
			["MediaSessionActionDetails", base_config_1$80.TYPE],
			["MediaSettingsRange", base_config_1$80.TYPE],
			["MediaStreamAudioSourceOptions", base_config_1$80.TYPE],
			["MediaStreamConstraints", base_config_1$80.TYPE],
			["MediaStreamTrackEventInit", base_config_1$80.TYPE],
			["MediaTrackCapabilities", base_config_1$80.TYPE],
			["MediaTrackConstraintSet", base_config_1$80.TYPE],
			["MediaTrackConstraints", base_config_1$80.TYPE],
			["MediaTrackSettings", base_config_1$80.TYPE],
			["MediaTrackSupportedConstraints", base_config_1$80.TYPE],
			["MessageEventInit", base_config_1$80.TYPE],
			["MouseEventInit", base_config_1$80.TYPE],
			["MultiCacheQueryOptions", base_config_1$80.TYPE],
			["MutationObserverInit", base_config_1$80.TYPE],
			["NavigationPreloadState", base_config_1$80.TYPE],
			["NotificationOptions", base_config_1$80.TYPE],
			["OfflineAudioCompletionEventInit", base_config_1$80.TYPE],
			["OfflineAudioContextOptions", base_config_1$80.TYPE],
			["OptionalEffectTiming", base_config_1$80.TYPE],
			["OpusEncoderConfig", base_config_1$80.TYPE],
			["OscillatorOptions", base_config_1$80.TYPE],
			["PageRevealEventInit", base_config_1$80.TYPE],
			["PageSwapEventInit", base_config_1$80.TYPE],
			["PageTransitionEventInit", base_config_1$80.TYPE],
			["PannerOptions", base_config_1$80.TYPE],
			["PayerErrors", base_config_1$80.TYPE],
			["PaymentCurrencyAmount", base_config_1$80.TYPE],
			["PaymentDetailsBase", base_config_1$80.TYPE],
			["PaymentDetailsInit", base_config_1$80.TYPE],
			["PaymentDetailsModifier", base_config_1$80.TYPE],
			["PaymentDetailsUpdate", base_config_1$80.TYPE],
			["PaymentItem", base_config_1$80.TYPE],
			["PaymentMethodChangeEventInit", base_config_1$80.TYPE],
			["PaymentMethodData", base_config_1$80.TYPE],
			["PaymentOptions", base_config_1$80.TYPE],
			["PaymentRequestUpdateEventInit", base_config_1$80.TYPE],
			["PaymentShippingOption", base_config_1$80.TYPE],
			["PaymentValidationErrors", base_config_1$80.TYPE],
			["Pbkdf2Params", base_config_1$80.TYPE],
			["PerformanceMarkOptions", base_config_1$80.TYPE],
			["PerformanceMeasureOptions", base_config_1$80.TYPE],
			["PerformanceObserverInit", base_config_1$80.TYPE],
			["PeriodicWaveConstraints", base_config_1$80.TYPE],
			["PeriodicWaveOptions", base_config_1$80.TYPE],
			["PermissionDescriptor", base_config_1$80.TYPE],
			["PhotoCapabilities", base_config_1$80.TYPE],
			["PhotoSettings", base_config_1$80.TYPE],
			["PictureInPictureEventInit", base_config_1$80.TYPE],
			["PlaneLayout", base_config_1$80.TYPE],
			["PointerEventInit", base_config_1$80.TYPE],
			["PointerLockOptions", base_config_1$80.TYPE],
			["PopStateEventInit", base_config_1$80.TYPE],
			["PositionOptions", base_config_1$80.TYPE],
			["ProgressEventInit", base_config_1$80.TYPE],
			["PromiseRejectionEventInit", base_config_1$80.TYPE],
			["PropertyDefinition", base_config_1$80.TYPE],
			["PropertyIndexedKeyframes", base_config_1$80.TYPE],
			["PublicKeyCredentialCreationOptions", base_config_1$80.TYPE],
			["PublicKeyCredentialCreationOptionsJSON", base_config_1$80.TYPE],
			["PublicKeyCredentialDescriptor", base_config_1$80.TYPE],
			["PublicKeyCredentialDescriptorJSON", base_config_1$80.TYPE],
			["PublicKeyCredentialEntity", base_config_1$80.TYPE],
			["PublicKeyCredentialParameters", base_config_1$80.TYPE],
			["PublicKeyCredentialRequestOptions", base_config_1$80.TYPE],
			["PublicKeyCredentialRequestOptionsJSON", base_config_1$80.TYPE],
			["PublicKeyCredentialRpEntity", base_config_1$80.TYPE],
			["PublicKeyCredentialUserEntity", base_config_1$80.TYPE],
			["PublicKeyCredentialUserEntityJSON", base_config_1$80.TYPE],
			["PushSubscriptionJSON", base_config_1$80.TYPE],
			["PushSubscriptionOptionsInit", base_config_1$80.TYPE],
			["QueuingStrategy", base_config_1$80.TYPE],
			["QueuingStrategyInit", base_config_1$80.TYPE],
			["RTCAnswerOptions", base_config_1$80.TYPE],
			["RTCCertificateExpiration", base_config_1$80.TYPE],
			["RTCConfiguration", base_config_1$80.TYPE],
			["RTCDTMFToneChangeEventInit", base_config_1$80.TYPE],
			["RTCDataChannelEventInit", base_config_1$80.TYPE],
			["RTCDataChannelInit", base_config_1$80.TYPE],
			["RTCDtlsFingerprint", base_config_1$80.TYPE],
			["RTCEncodedAudioFrameMetadata", base_config_1$80.TYPE],
			["RTCEncodedFrameMetadata", base_config_1$80.TYPE],
			["RTCEncodedVideoFrameMetadata", base_config_1$80.TYPE],
			["RTCErrorEventInit", base_config_1$80.TYPE],
			["RTCErrorInit", base_config_1$80.TYPE],
			["RTCIceCandidateInit", base_config_1$80.TYPE],
			["RTCIceCandidatePairStats", base_config_1$80.TYPE],
			["RTCIceServer", base_config_1$80.TYPE],
			["RTCInboundRtpStreamStats", base_config_1$80.TYPE],
			["RTCLocalIceCandidateInit", base_config_1$80.TYPE],
			["RTCLocalSessionDescriptionInit", base_config_1$80.TYPE],
			["RTCOfferAnswerOptions", base_config_1$80.TYPE],
			["RTCOfferOptions", base_config_1$80.TYPE],
			["RTCOutboundRtpStreamStats", base_config_1$80.TYPE],
			["RTCPeerConnectionIceErrorEventInit", base_config_1$80.TYPE],
			["RTCPeerConnectionIceEventInit", base_config_1$80.TYPE],
			["RTCReceivedRtpStreamStats", base_config_1$80.TYPE],
			["RTCRtcpParameters", base_config_1$80.TYPE],
			["RTCRtpCapabilities", base_config_1$80.TYPE],
			["RTCRtpCodec", base_config_1$80.TYPE],
			["RTCRtpCodecParameters", base_config_1$80.TYPE],
			["RTCRtpCodingParameters", base_config_1$80.TYPE],
			["RTCRtpContributingSource", base_config_1$80.TYPE],
			["RTCRtpEncodingParameters", base_config_1$80.TYPE],
			["RTCRtpHeaderExtensionCapability", base_config_1$80.TYPE],
			["RTCRtpHeaderExtensionParameters", base_config_1$80.TYPE],
			["RTCRtpParameters", base_config_1$80.TYPE],
			["RTCRtpReceiveParameters", base_config_1$80.TYPE],
			["RTCRtpSendParameters", base_config_1$80.TYPE],
			["RTCRtpStreamStats", base_config_1$80.TYPE],
			["RTCRtpSynchronizationSource", base_config_1$80.TYPE],
			["RTCRtpTransceiverInit", base_config_1$80.TYPE],
			["RTCSentRtpStreamStats", base_config_1$80.TYPE],
			["RTCSessionDescriptionInit", base_config_1$80.TYPE],
			["RTCSetParameterOptions", base_config_1$80.TYPE],
			["RTCStats", base_config_1$80.TYPE],
			["RTCTrackEventInit", base_config_1$80.TYPE],
			["RTCTransportStats", base_config_1$80.TYPE],
			["ReadableStreamGetReaderOptions", base_config_1$80.TYPE],
			["ReadableStreamIteratorOptions", base_config_1$80.TYPE],
			["ReadableStreamReadDoneResult", base_config_1$80.TYPE],
			["ReadableStreamReadValueResult", base_config_1$80.TYPE],
			["ReadableWritablePair", base_config_1$80.TYPE],
			["RegistrationOptions", base_config_1$80.TYPE],
			["ReportingObserverOptions", base_config_1$80.TYPE],
			["RequestInit", base_config_1$80.TYPE],
			["ResizeObserverOptions", base_config_1$80.TYPE],
			["ResponseInit", base_config_1$80.TYPE],
			["RsaHashedImportParams", base_config_1$80.TYPE],
			["RsaHashedKeyAlgorithm", base_config_1$80.TYPE],
			["RsaHashedKeyGenParams", base_config_1$80.TYPE],
			["RsaKeyAlgorithm", base_config_1$80.TYPE],
			["RsaKeyGenParams", base_config_1$80.TYPE],
			["RsaOaepParams", base_config_1$80.TYPE],
			["RsaOtherPrimesInfo", base_config_1$80.TYPE],
			["RsaPssParams", base_config_1$80.TYPE],
			["SVGBoundingBoxOptions", base_config_1$80.TYPE],
			["ScrollIntoViewOptions", base_config_1$80.TYPE],
			["ScrollOptions", base_config_1$80.TYPE],
			["ScrollToOptions", base_config_1$80.TYPE],
			["SecurityPolicyViolationEventInit", base_config_1$80.TYPE],
			["ShadowRootInit", base_config_1$80.TYPE],
			["ShareData", base_config_1$80.TYPE],
			["SpeechSynthesisErrorEventInit", base_config_1$80.TYPE],
			["SpeechSynthesisEventInit", base_config_1$80.TYPE],
			["StartViewTransitionOptions", base_config_1$80.TYPE],
			["StaticRangeInit", base_config_1$80.TYPE],
			["StereoPannerOptions", base_config_1$80.TYPE],
			["StorageEstimate", base_config_1$80.TYPE],
			["StorageEventInit", base_config_1$80.TYPE],
			["StreamPipeOptions", base_config_1$80.TYPE],
			["StructuredSerializeOptions", base_config_1$80.TYPE],
			["SubmitEventInit", base_config_1$80.TYPE],
			["TextDecodeOptions", base_config_1$80.TYPE],
			["TextDecoderOptions", base_config_1$80.TYPE],
			["TextEncoderEncodeIntoResult", base_config_1$80.TYPE],
			["ToggleEventInit", base_config_1$80.TYPE],
			["TouchEventInit", base_config_1$80.TYPE],
			["TouchInit", base_config_1$80.TYPE],
			["TrackEventInit", base_config_1$80.TYPE],
			["Transformer", base_config_1$80.TYPE],
			["TransitionEventInit", base_config_1$80.TYPE],
			["UIEventInit", base_config_1$80.TYPE],
			["ULongRange", base_config_1$80.TYPE],
			["UnderlyingByteSource", base_config_1$80.TYPE],
			["UnderlyingDefaultSource", base_config_1$80.TYPE],
			["UnderlyingSink", base_config_1$80.TYPE],
			["UnderlyingSource", base_config_1$80.TYPE],
			["ValidityStateFlags", base_config_1$80.TYPE],
			["VideoColorSpaceInit", base_config_1$80.TYPE],
			["VideoConfiguration", base_config_1$80.TYPE],
			["VideoDecoderConfig", base_config_1$80.TYPE],
			["VideoDecoderInit", base_config_1$80.TYPE],
			["VideoDecoderSupport", base_config_1$80.TYPE],
			["VideoEncoderConfig", base_config_1$80.TYPE],
			["VideoEncoderEncodeOptions", base_config_1$80.TYPE],
			["VideoEncoderEncodeOptionsForAvc", base_config_1$80.TYPE],
			["VideoEncoderInit", base_config_1$80.TYPE],
			["VideoEncoderSupport", base_config_1$80.TYPE],
			["VideoFrameBufferInit", base_config_1$80.TYPE],
			["VideoFrameCallbackMetadata", base_config_1$80.TYPE],
			["VideoFrameCopyToOptions", base_config_1$80.TYPE],
			["VideoFrameInit", base_config_1$80.TYPE],
			["WaveShaperOptions", base_config_1$80.TYPE],
			["WebGLContextAttributes", base_config_1$80.TYPE],
			["WebGLContextEventInit", base_config_1$80.TYPE],
			["WebTransportCloseInfo", base_config_1$80.TYPE],
			["WebTransportErrorOptions", base_config_1$80.TYPE],
			["WebTransportHash", base_config_1$80.TYPE],
			["WebTransportOptions", base_config_1$80.TYPE],
			["WebTransportSendOptions", base_config_1$80.TYPE],
			["WebTransportSendStreamOptions", base_config_1$80.TYPE],
			["WheelEventInit", base_config_1$80.TYPE],
			["WindowPostMessageOptions", base_config_1$80.TYPE],
			["WorkerOptions", base_config_1$80.TYPE],
			["WorkletOptions", base_config_1$80.TYPE],
			["WriteParams", base_config_1$80.TYPE],
			["NodeFilter", base_config_1$80.TYPE_VALUE],
			["XPathNSResolver", base_config_1$80.TYPE],
			["ANGLE_instanced_arrays", base_config_1$80.TYPE],
			["ARIAMixin", base_config_1$80.TYPE],
			["AbortController", base_config_1$80.TYPE_VALUE],
			["AbortSignalEventMap", base_config_1$80.TYPE],
			["AbortSignal", base_config_1$80.TYPE_VALUE],
			["AbstractRange", base_config_1$80.TYPE_VALUE],
			["AbstractWorkerEventMap", base_config_1$80.TYPE],
			["AbstractWorker", base_config_1$80.TYPE],
			["AnalyserNode", base_config_1$80.TYPE_VALUE],
			["Animatable", base_config_1$80.TYPE],
			["AnimationEventMap", base_config_1$80.TYPE],
			["Animation", base_config_1$80.TYPE_VALUE],
			["AnimationEffect", base_config_1$80.TYPE_VALUE],
			["AnimationEvent", base_config_1$80.TYPE_VALUE],
			["AnimationFrameProvider", base_config_1$80.TYPE],
			["AnimationPlaybackEvent", base_config_1$80.TYPE_VALUE],
			["AnimationTimeline", base_config_1$80.TYPE_VALUE],
			["Attr", base_config_1$80.TYPE_VALUE],
			["AudioBuffer", base_config_1$80.TYPE_VALUE],
			["AudioBufferSourceNode", base_config_1$80.TYPE_VALUE],
			["AudioContext", base_config_1$80.TYPE_VALUE],
			["AudioData", base_config_1$80.TYPE_VALUE],
			["AudioDecoderEventMap", base_config_1$80.TYPE],
			["AudioDecoder", base_config_1$80.TYPE_VALUE],
			["AudioDestinationNode", base_config_1$80.TYPE_VALUE],
			["AudioEncoderEventMap", base_config_1$80.TYPE],
			["AudioEncoder", base_config_1$80.TYPE_VALUE],
			["AudioListener", base_config_1$80.TYPE_VALUE],
			["AudioNode", base_config_1$80.TYPE_VALUE],
			["AudioParam", base_config_1$80.TYPE_VALUE],
			["AudioParamMap", base_config_1$80.TYPE_VALUE],
			["AudioProcessingEvent", base_config_1$80.TYPE_VALUE],
			["AudioScheduledSourceNodeEventMap", base_config_1$80.TYPE],
			["AudioScheduledSourceNode", base_config_1$80.TYPE_VALUE],
			["AudioWorklet", base_config_1$80.TYPE_VALUE],
			["AudioWorkletNodeEventMap", base_config_1$80.TYPE],
			["AudioWorkletNode", base_config_1$80.TYPE_VALUE],
			["AuthenticatorAssertionResponse", base_config_1$80.TYPE_VALUE],
			["AuthenticatorAttestationResponse", base_config_1$80.TYPE_VALUE],
			["AuthenticatorResponse", base_config_1$80.TYPE_VALUE],
			["BarProp", base_config_1$80.TYPE_VALUE],
			["BaseAudioContextEventMap", base_config_1$80.TYPE],
			["BaseAudioContext", base_config_1$80.TYPE_VALUE],
			["BeforeUnloadEvent", base_config_1$80.TYPE_VALUE],
			["BiquadFilterNode", base_config_1$80.TYPE_VALUE],
			["Blob", base_config_1$80.TYPE_VALUE],
			["BlobEvent", base_config_1$80.TYPE_VALUE],
			["Body", base_config_1$80.TYPE],
			["BroadcastChannelEventMap", base_config_1$80.TYPE],
			["BroadcastChannel", base_config_1$80.TYPE_VALUE],
			["ByteLengthQueuingStrategy", base_config_1$80.TYPE_VALUE],
			["CDATASection", base_config_1$80.TYPE_VALUE],
			["CSPViolationReportBody", base_config_1$80.TYPE_VALUE],
			["CSSAnimation", base_config_1$80.TYPE_VALUE],
			["CSSConditionRule", base_config_1$80.TYPE_VALUE],
			["CSSContainerRule", base_config_1$80.TYPE_VALUE],
			["CSSCounterStyleRule", base_config_1$80.TYPE_VALUE],
			["CSSFontFaceRule", base_config_1$80.TYPE_VALUE],
			["CSSFontFeatureValuesRule", base_config_1$80.TYPE_VALUE],
			["CSSFontPaletteValuesRule", base_config_1$80.TYPE_VALUE],
			["CSSGroupingRule", base_config_1$80.TYPE_VALUE],
			["CSSImageValue", base_config_1$80.TYPE_VALUE],
			["CSSImportRule", base_config_1$80.TYPE_VALUE],
			["CSSKeyframeRule", base_config_1$80.TYPE_VALUE],
			["CSSKeyframesRule", base_config_1$80.TYPE_VALUE],
			["CSSKeywordValue", base_config_1$80.TYPE_VALUE],
			["CSSLayerBlockRule", base_config_1$80.TYPE_VALUE],
			["CSSLayerStatementRule", base_config_1$80.TYPE_VALUE],
			["CSSMathClamp", base_config_1$80.TYPE_VALUE],
			["CSSMathInvert", base_config_1$80.TYPE_VALUE],
			["CSSMathMax", base_config_1$80.TYPE_VALUE],
			["CSSMathMin", base_config_1$80.TYPE_VALUE],
			["CSSMathNegate", base_config_1$80.TYPE_VALUE],
			["CSSMathProduct", base_config_1$80.TYPE_VALUE],
			["CSSMathSum", base_config_1$80.TYPE_VALUE],
			["CSSMathValue", base_config_1$80.TYPE_VALUE],
			["CSSMatrixComponent", base_config_1$80.TYPE_VALUE],
			["CSSMediaRule", base_config_1$80.TYPE_VALUE],
			["CSSNamespaceRule", base_config_1$80.TYPE_VALUE],
			["CSSNestedDeclarations", base_config_1$80.TYPE_VALUE],
			["CSSNumericArray", base_config_1$80.TYPE_VALUE],
			["CSSNumericValue", base_config_1$80.TYPE_VALUE],
			["CSSPageRule", base_config_1$80.TYPE_VALUE],
			["CSSPerspective", base_config_1$80.TYPE_VALUE],
			["CSSPropertyRule", base_config_1$80.TYPE_VALUE],
			["CSSRotate", base_config_1$80.TYPE_VALUE],
			["CSSRule", base_config_1$80.TYPE_VALUE],
			["CSSRuleList", base_config_1$80.TYPE_VALUE],
			["CSSScale", base_config_1$80.TYPE_VALUE],
			["CSSScopeRule", base_config_1$80.TYPE_VALUE],
			["CSSSkew", base_config_1$80.TYPE_VALUE],
			["CSSSkewX", base_config_1$80.TYPE_VALUE],
			["CSSSkewY", base_config_1$80.TYPE_VALUE],
			["CSSStartingStyleRule", base_config_1$80.TYPE_VALUE],
			["CSSStyleDeclaration", base_config_1$80.TYPE_VALUE],
			["CSSStyleRule", base_config_1$80.TYPE_VALUE],
			["CSSStyleSheet", base_config_1$80.TYPE_VALUE],
			["CSSStyleValue", base_config_1$80.TYPE_VALUE],
			["CSSSupportsRule", base_config_1$80.TYPE_VALUE],
			["CSSTransformComponent", base_config_1$80.TYPE_VALUE],
			["CSSTransformValue", base_config_1$80.TYPE_VALUE],
			["CSSTransition", base_config_1$80.TYPE_VALUE],
			["CSSTranslate", base_config_1$80.TYPE_VALUE],
			["CSSUnitValue", base_config_1$80.TYPE_VALUE],
			["CSSUnparsedValue", base_config_1$80.TYPE_VALUE],
			["CSSVariableReferenceValue", base_config_1$80.TYPE_VALUE],
			["CSSViewTransitionRule", base_config_1$80.TYPE_VALUE],
			["Cache", base_config_1$80.TYPE_VALUE],
			["CacheStorage", base_config_1$80.TYPE_VALUE],
			["CanvasCaptureMediaStreamTrack", base_config_1$80.TYPE_VALUE],
			["CanvasCompositing", base_config_1$80.TYPE],
			["CanvasDrawImage", base_config_1$80.TYPE],
			["CanvasDrawPath", base_config_1$80.TYPE],
			["CanvasFillStrokeStyles", base_config_1$80.TYPE],
			["CanvasFilters", base_config_1$80.TYPE],
			["CanvasGradient", base_config_1$80.TYPE_VALUE],
			["CanvasImageData", base_config_1$80.TYPE],
			["CanvasImageSmoothing", base_config_1$80.TYPE],
			["CanvasPath", base_config_1$80.TYPE],
			["CanvasPathDrawingStyles", base_config_1$80.TYPE],
			["CanvasPattern", base_config_1$80.TYPE_VALUE],
			["CanvasRect", base_config_1$80.TYPE],
			["CanvasRenderingContext2D", base_config_1$80.TYPE_VALUE],
			["CanvasSettings", base_config_1$80.TYPE],
			["CanvasShadowStyles", base_config_1$80.TYPE],
			["CanvasState", base_config_1$80.TYPE],
			["CanvasText", base_config_1$80.TYPE],
			["CanvasTextDrawingStyles", base_config_1$80.TYPE],
			["CanvasTransform", base_config_1$80.TYPE],
			["CanvasUserInterface", base_config_1$80.TYPE],
			["CaretPosition", base_config_1$80.TYPE_VALUE],
			["ChannelMergerNode", base_config_1$80.TYPE_VALUE],
			["ChannelSplitterNode", base_config_1$80.TYPE_VALUE],
			["CharacterData", base_config_1$80.TYPE_VALUE],
			["ChildNode", base_config_1$80.TYPE],
			["ClientRect", base_config_1$80.TYPE],
			["Clipboard", base_config_1$80.TYPE_VALUE],
			["ClipboardEvent", base_config_1$80.TYPE_VALUE],
			["ClipboardItem", base_config_1$80.TYPE_VALUE],
			["CloseEvent", base_config_1$80.TYPE_VALUE],
			["Comment", base_config_1$80.TYPE_VALUE],
			["CompositionEvent", base_config_1$80.TYPE_VALUE],
			["CompressionStream", base_config_1$80.TYPE_VALUE],
			["ConstantSourceNode", base_config_1$80.TYPE_VALUE],
			["ContentVisibilityAutoStateChangeEvent", base_config_1$80.TYPE_VALUE],
			["ConvolverNode", base_config_1$80.TYPE_VALUE],
			["CookieChangeEvent", base_config_1$80.TYPE_VALUE],
			["CookieStoreEventMap", base_config_1$80.TYPE],
			["CookieStore", base_config_1$80.TYPE_VALUE],
			["CookieStoreManager", base_config_1$80.TYPE_VALUE],
			["CountQueuingStrategy", base_config_1$80.TYPE_VALUE],
			["Credential", base_config_1$80.TYPE_VALUE],
			["CredentialsContainer", base_config_1$80.TYPE_VALUE],
			["Crypto", base_config_1$80.TYPE_VALUE],
			["CryptoKey", base_config_1$80.TYPE_VALUE],
			["CustomElementRegistry", base_config_1$80.TYPE_VALUE],
			["CustomEvent", base_config_1$80.TYPE_VALUE],
			["CustomStateSet", base_config_1$80.TYPE_VALUE],
			["DOMException", base_config_1$80.TYPE_VALUE],
			["DOMImplementation", base_config_1$80.TYPE_VALUE],
			["DOMMatrix", base_config_1$80.TYPE_VALUE],
			["SVGMatrix", base_config_1$80.TYPE_VALUE],
			["WebKitCSSMatrix", base_config_1$80.TYPE_VALUE],
			["DOMMatrixReadOnly", base_config_1$80.TYPE_VALUE],
			["DOMParser", base_config_1$80.TYPE_VALUE],
			["DOMPoint", base_config_1$80.TYPE_VALUE],
			["SVGPoint", base_config_1$80.TYPE_VALUE],
			["DOMPointReadOnly", base_config_1$80.TYPE_VALUE],
			["DOMQuad", base_config_1$80.TYPE_VALUE],
			["DOMRect", base_config_1$80.TYPE_VALUE],
			["SVGRect", base_config_1$80.TYPE_VALUE],
			["DOMRectList", base_config_1$80.TYPE_VALUE],
			["DOMRectReadOnly", base_config_1$80.TYPE_VALUE],
			["DOMStringList", base_config_1$80.TYPE_VALUE],
			["DOMStringMap", base_config_1$80.TYPE_VALUE],
			["DOMTokenList", base_config_1$80.TYPE_VALUE],
			["DataTransfer", base_config_1$80.TYPE_VALUE],
			["DataTransferItem", base_config_1$80.TYPE_VALUE],
			["DataTransferItemList", base_config_1$80.TYPE_VALUE],
			["DecompressionStream", base_config_1$80.TYPE_VALUE],
			["DelayNode", base_config_1$80.TYPE_VALUE],
			["DeviceMotionEvent", base_config_1$80.TYPE_VALUE],
			["DeviceMotionEventAcceleration", base_config_1$80.TYPE],
			["DeviceMotionEventRotationRate", base_config_1$80.TYPE],
			["DeviceOrientationEvent", base_config_1$80.TYPE_VALUE],
			["DocumentEventMap", base_config_1$80.TYPE],
			["Document", base_config_1$80.TYPE_VALUE],
			["DocumentFragment", base_config_1$80.TYPE_VALUE],
			["DocumentOrShadowRoot", base_config_1$80.TYPE],
			["DocumentTimeline", base_config_1$80.TYPE_VALUE],
			["DocumentType", base_config_1$80.TYPE_VALUE],
			["DragEvent", base_config_1$80.TYPE_VALUE],
			["DynamicsCompressorNode", base_config_1$80.TYPE_VALUE],
			["EXT_blend_minmax", base_config_1$80.TYPE],
			["EXT_color_buffer_float", base_config_1$80.TYPE],
			["EXT_color_buffer_half_float", base_config_1$80.TYPE],
			["EXT_float_blend", base_config_1$80.TYPE],
			["EXT_frag_depth", base_config_1$80.TYPE],
			["EXT_sRGB", base_config_1$80.TYPE],
			["EXT_shader_texture_lod", base_config_1$80.TYPE],
			["EXT_texture_compression_bptc", base_config_1$80.TYPE],
			["EXT_texture_compression_rgtc", base_config_1$80.TYPE],
			["EXT_texture_filter_anisotropic", base_config_1$80.TYPE],
			["EXT_texture_norm16", base_config_1$80.TYPE],
			["ElementEventMap", base_config_1$80.TYPE],
			["Element", base_config_1$80.TYPE_VALUE],
			["ElementCSSInlineStyle", base_config_1$80.TYPE],
			["ElementContentEditable", base_config_1$80.TYPE],
			["ElementInternals", base_config_1$80.TYPE_VALUE],
			["EncodedAudioChunk", base_config_1$80.TYPE_VALUE],
			["EncodedVideoChunk", base_config_1$80.TYPE_VALUE],
			["ErrorEvent", base_config_1$80.TYPE_VALUE],
			["Event", base_config_1$80.TYPE_VALUE],
			["EventCounts", base_config_1$80.TYPE_VALUE],
			["EventListener", base_config_1$80.TYPE],
			["EventListenerObject", base_config_1$80.TYPE],
			["EventSourceEventMap", base_config_1$80.TYPE],
			["EventSource", base_config_1$80.TYPE_VALUE],
			["EventTarget", base_config_1$80.TYPE_VALUE],
			["External", base_config_1$80.TYPE_VALUE],
			["File", base_config_1$80.TYPE_VALUE],
			["FileList", base_config_1$80.TYPE_VALUE],
			["FileReaderEventMap", base_config_1$80.TYPE],
			["FileReader", base_config_1$80.TYPE_VALUE],
			["FileSystem", base_config_1$80.TYPE_VALUE],
			["FileSystemDirectoryEntry", base_config_1$80.TYPE_VALUE],
			["FileSystemDirectoryHandle", base_config_1$80.TYPE_VALUE],
			["FileSystemDirectoryReader", base_config_1$80.TYPE_VALUE],
			["FileSystemEntry", base_config_1$80.TYPE_VALUE],
			["FileSystemFileEntry", base_config_1$80.TYPE_VALUE],
			["FileSystemFileHandle", base_config_1$80.TYPE_VALUE],
			["FileSystemHandle", base_config_1$80.TYPE_VALUE],
			["FileSystemWritableFileStream", base_config_1$80.TYPE_VALUE],
			["FocusEvent", base_config_1$80.TYPE_VALUE],
			["FontFace", base_config_1$80.TYPE_VALUE],
			["FontFaceSetEventMap", base_config_1$80.TYPE],
			["FontFaceSet", base_config_1$80.TYPE_VALUE],
			["FontFaceSetLoadEvent", base_config_1$80.TYPE_VALUE],
			["FontFaceSource", base_config_1$80.TYPE],
			["FormData", base_config_1$80.TYPE_VALUE],
			["FormDataEvent", base_config_1$80.TYPE_VALUE],
			["FragmentDirective", base_config_1$80.TYPE_VALUE],
			["GPUError", base_config_1$80.TYPE],
			["GainNode", base_config_1$80.TYPE_VALUE],
			["Gamepad", base_config_1$80.TYPE_VALUE],
			["GamepadButton", base_config_1$80.TYPE_VALUE],
			["GamepadEvent", base_config_1$80.TYPE_VALUE],
			["GamepadHapticActuator", base_config_1$80.TYPE_VALUE],
			["GenericTransformStream", base_config_1$80.TYPE],
			["Geolocation", base_config_1$80.TYPE_VALUE],
			["GeolocationCoordinates", base_config_1$80.TYPE_VALUE],
			["GeolocationPosition", base_config_1$80.TYPE_VALUE],
			["GeolocationPositionError", base_config_1$80.TYPE_VALUE],
			["GlobalEventHandlersEventMap", base_config_1$80.TYPE],
			["GlobalEventHandlers", base_config_1$80.TYPE],
			["HTMLAllCollection", base_config_1$80.TYPE_VALUE],
			["HTMLAnchorElement", base_config_1$80.TYPE_VALUE],
			["HTMLAreaElement", base_config_1$80.TYPE_VALUE],
			["HTMLAudioElement", base_config_1$80.TYPE_VALUE],
			["HTMLBRElement", base_config_1$80.TYPE_VALUE],
			["HTMLBaseElement", base_config_1$80.TYPE_VALUE],
			["HTMLBodyElementEventMap", base_config_1$80.TYPE],
			["HTMLBodyElement", base_config_1$80.TYPE_VALUE],
			["HTMLButtonElement", base_config_1$80.TYPE_VALUE],
			["HTMLCanvasElement", base_config_1$80.TYPE_VALUE],
			["HTMLCollectionBase", base_config_1$80.TYPE],
			["HTMLCollection", base_config_1$80.TYPE_VALUE],
			["HTMLCollectionOf", base_config_1$80.TYPE],
			["HTMLDListElement", base_config_1$80.TYPE_VALUE],
			["HTMLDataElement", base_config_1$80.TYPE_VALUE],
			["HTMLDataListElement", base_config_1$80.TYPE_VALUE],
			["HTMLDetailsElement", base_config_1$80.TYPE_VALUE],
			["HTMLDialogElement", base_config_1$80.TYPE_VALUE],
			["HTMLDirectoryElement", base_config_1$80.TYPE_VALUE],
			["HTMLDivElement", base_config_1$80.TYPE_VALUE],
			["HTMLDocument", base_config_1$80.TYPE_VALUE],
			["HTMLElementEventMap", base_config_1$80.TYPE],
			["HTMLElement", base_config_1$80.TYPE_VALUE],
			["HTMLEmbedElement", base_config_1$80.TYPE_VALUE],
			["HTMLFieldSetElement", base_config_1$80.TYPE_VALUE],
			["HTMLFontElement", base_config_1$80.TYPE_VALUE],
			["HTMLFormControlsCollection", base_config_1$80.TYPE_VALUE],
			["HTMLFormElement", base_config_1$80.TYPE_VALUE],
			["HTMLFrameElement", base_config_1$80.TYPE_VALUE],
			["HTMLFrameSetElementEventMap", base_config_1$80.TYPE],
			["HTMLFrameSetElement", base_config_1$80.TYPE_VALUE],
			["HTMLHRElement", base_config_1$80.TYPE_VALUE],
			["HTMLHeadElement", base_config_1$80.TYPE_VALUE],
			["HTMLHeadingElement", base_config_1$80.TYPE_VALUE],
			["HTMLHtmlElement", base_config_1$80.TYPE_VALUE],
			["HTMLHyperlinkElementUtils", base_config_1$80.TYPE],
			["HTMLIFrameElement", base_config_1$80.TYPE_VALUE],
			["HTMLImageElement", base_config_1$80.TYPE_VALUE],
			["HTMLInputElement", base_config_1$80.TYPE_VALUE],
			["HTMLLIElement", base_config_1$80.TYPE_VALUE],
			["HTMLLabelElement", base_config_1$80.TYPE_VALUE],
			["HTMLLegendElement", base_config_1$80.TYPE_VALUE],
			["HTMLLinkElement", base_config_1$80.TYPE_VALUE],
			["HTMLMapElement", base_config_1$80.TYPE_VALUE],
			["HTMLMarqueeElement", base_config_1$80.TYPE_VALUE],
			["HTMLMediaElementEventMap", base_config_1$80.TYPE],
			["HTMLMediaElement", base_config_1$80.TYPE_VALUE],
			["HTMLMenuElement", base_config_1$80.TYPE_VALUE],
			["HTMLMetaElement", base_config_1$80.TYPE_VALUE],
			["HTMLMeterElement", base_config_1$80.TYPE_VALUE],
			["HTMLModElement", base_config_1$80.TYPE_VALUE],
			["HTMLOListElement", base_config_1$80.TYPE_VALUE],
			["HTMLObjectElement", base_config_1$80.TYPE_VALUE],
			["HTMLOptGroupElement", base_config_1$80.TYPE_VALUE],
			["HTMLOptionElement", base_config_1$80.TYPE_VALUE],
			["HTMLOptionsCollection", base_config_1$80.TYPE_VALUE],
			["HTMLOrSVGElement", base_config_1$80.TYPE],
			["HTMLOutputElement", base_config_1$80.TYPE_VALUE],
			["HTMLParagraphElement", base_config_1$80.TYPE_VALUE],
			["HTMLParamElement", base_config_1$80.TYPE_VALUE],
			["HTMLPictureElement", base_config_1$80.TYPE_VALUE],
			["HTMLPreElement", base_config_1$80.TYPE_VALUE],
			["HTMLProgressElement", base_config_1$80.TYPE_VALUE],
			["HTMLQuoteElement", base_config_1$80.TYPE_VALUE],
			["HTMLScriptElement", base_config_1$80.TYPE_VALUE],
			["HTMLSelectElement", base_config_1$80.TYPE_VALUE],
			["HTMLSlotElement", base_config_1$80.TYPE_VALUE],
			["HTMLSourceElement", base_config_1$80.TYPE_VALUE],
			["HTMLSpanElement", base_config_1$80.TYPE_VALUE],
			["HTMLStyleElement", base_config_1$80.TYPE_VALUE],
			["HTMLTableCaptionElement", base_config_1$80.TYPE_VALUE],
			["HTMLTableCellElement", base_config_1$80.TYPE_VALUE],
			["HTMLTableColElement", base_config_1$80.TYPE_VALUE],
			["HTMLTableDataCellElement", base_config_1$80.TYPE],
			["HTMLTableElement", base_config_1$80.TYPE_VALUE],
			["HTMLTableHeaderCellElement", base_config_1$80.TYPE],
			["HTMLTableRowElement", base_config_1$80.TYPE_VALUE],
			["HTMLTableSectionElement", base_config_1$80.TYPE_VALUE],
			["HTMLTemplateElement", base_config_1$80.TYPE_VALUE],
			["HTMLTextAreaElement", base_config_1$80.TYPE_VALUE],
			["HTMLTimeElement", base_config_1$80.TYPE_VALUE],
			["HTMLTitleElement", base_config_1$80.TYPE_VALUE],
			["HTMLTrackElement", base_config_1$80.TYPE_VALUE],
			["HTMLUListElement", base_config_1$80.TYPE_VALUE],
			["HTMLUnknownElement", base_config_1$80.TYPE_VALUE],
			["HTMLVideoElementEventMap", base_config_1$80.TYPE],
			["HTMLVideoElement", base_config_1$80.TYPE_VALUE],
			["HashChangeEvent", base_config_1$80.TYPE_VALUE],
			["Headers", base_config_1$80.TYPE_VALUE],
			["Highlight", base_config_1$80.TYPE_VALUE],
			["HighlightRegistry", base_config_1$80.TYPE_VALUE],
			["History", base_config_1$80.TYPE_VALUE],
			["IDBCursor", base_config_1$80.TYPE_VALUE],
			["IDBCursorWithValue", base_config_1$80.TYPE_VALUE],
			["IDBDatabaseEventMap", base_config_1$80.TYPE],
			["IDBDatabase", base_config_1$80.TYPE_VALUE],
			["IDBFactory", base_config_1$80.TYPE_VALUE],
			["IDBIndex", base_config_1$80.TYPE_VALUE],
			["IDBKeyRange", base_config_1$80.TYPE_VALUE],
			["IDBObjectStore", base_config_1$80.TYPE_VALUE],
			["IDBOpenDBRequestEventMap", base_config_1$80.TYPE],
			["IDBOpenDBRequest", base_config_1$80.TYPE_VALUE],
			["IDBRequestEventMap", base_config_1$80.TYPE],
			["IDBRequest", base_config_1$80.TYPE_VALUE],
			["IDBTransactionEventMap", base_config_1$80.TYPE],
			["IDBTransaction", base_config_1$80.TYPE_VALUE],
			["IDBVersionChangeEvent", base_config_1$80.TYPE_VALUE],
			["IIRFilterNode", base_config_1$80.TYPE_VALUE],
			["IdleDeadline", base_config_1$80.TYPE_VALUE],
			["ImageBitmap", base_config_1$80.TYPE_VALUE],
			["ImageBitmapRenderingContext", base_config_1$80.TYPE_VALUE],
			["ImageCapture", base_config_1$80.TYPE_VALUE],
			["ImageData", base_config_1$80.TYPE_VALUE],
			["ImageDecoder", base_config_1$80.TYPE_VALUE],
			["ImageTrack", base_config_1$80.TYPE_VALUE],
			["ImageTrackList", base_config_1$80.TYPE_VALUE],
			["ImportMeta", base_config_1$80.TYPE],
			["InputDeviceInfo", base_config_1$80.TYPE_VALUE],
			["InputEvent", base_config_1$80.TYPE_VALUE],
			["IntersectionObserver", base_config_1$80.TYPE_VALUE],
			["IntersectionObserverEntry", base_config_1$80.TYPE_VALUE],
			["KHR_parallel_shader_compile", base_config_1$80.TYPE],
			["KeyboardEvent", base_config_1$80.TYPE_VALUE],
			["KeyframeEffect", base_config_1$80.TYPE_VALUE],
			["LargestContentfulPaint", base_config_1$80.TYPE_VALUE],
			["LinkStyle", base_config_1$80.TYPE],
			["Location", base_config_1$80.TYPE_VALUE],
			["Lock", base_config_1$80.TYPE_VALUE],
			["LockManager", base_config_1$80.TYPE_VALUE],
			["MIDIAccessEventMap", base_config_1$80.TYPE],
			["MIDIAccess", base_config_1$80.TYPE_VALUE],
			["MIDIConnectionEvent", base_config_1$80.TYPE_VALUE],
			["MIDIInputEventMap", base_config_1$80.TYPE],
			["MIDIInput", base_config_1$80.TYPE_VALUE],
			["MIDIInputMap", base_config_1$80.TYPE_VALUE],
			["MIDIMessageEvent", base_config_1$80.TYPE_VALUE],
			["MIDIOutput", base_config_1$80.TYPE_VALUE],
			["MIDIOutputMap", base_config_1$80.TYPE_VALUE],
			["MIDIPortEventMap", base_config_1$80.TYPE],
			["MIDIPort", base_config_1$80.TYPE_VALUE],
			["MathMLElementEventMap", base_config_1$80.TYPE],
			["MathMLElement", base_config_1$80.TYPE_VALUE],
			["MediaCapabilities", base_config_1$80.TYPE_VALUE],
			["MediaDeviceInfo", base_config_1$80.TYPE_VALUE],
			["MediaDevicesEventMap", base_config_1$80.TYPE],
			["MediaDevices", base_config_1$80.TYPE_VALUE],
			["MediaElementAudioSourceNode", base_config_1$80.TYPE_VALUE],
			["MediaEncryptedEvent", base_config_1$80.TYPE_VALUE],
			["MediaError", base_config_1$80.TYPE_VALUE],
			["MediaKeyMessageEvent", base_config_1$80.TYPE_VALUE],
			["MediaKeySessionEventMap", base_config_1$80.TYPE],
			["MediaKeySession", base_config_1$80.TYPE_VALUE],
			["MediaKeyStatusMap", base_config_1$80.TYPE_VALUE],
			["MediaKeySystemAccess", base_config_1$80.TYPE_VALUE],
			["MediaKeys", base_config_1$80.TYPE_VALUE],
			["MediaList", base_config_1$80.TYPE_VALUE],
			["MediaMetadata", base_config_1$80.TYPE_VALUE],
			["MediaQueryListEventMap", base_config_1$80.TYPE],
			["MediaQueryList", base_config_1$80.TYPE_VALUE],
			["MediaQueryListEvent", base_config_1$80.TYPE_VALUE],
			["MediaRecorderEventMap", base_config_1$80.TYPE],
			["MediaRecorder", base_config_1$80.TYPE_VALUE],
			["MediaSession", base_config_1$80.TYPE_VALUE],
			["MediaSourceEventMap", base_config_1$80.TYPE],
			["MediaSource", base_config_1$80.TYPE_VALUE],
			["MediaSourceHandle", base_config_1$80.TYPE_VALUE],
			["MediaStreamEventMap", base_config_1$80.TYPE],
			["MediaStream", base_config_1$80.TYPE_VALUE],
			["MediaStreamAudioDestinationNode", base_config_1$80.TYPE_VALUE],
			["MediaStreamAudioSourceNode", base_config_1$80.TYPE_VALUE],
			["MediaStreamTrackEventMap", base_config_1$80.TYPE],
			["MediaStreamTrack", base_config_1$80.TYPE_VALUE],
			["MediaStreamTrackEvent", base_config_1$80.TYPE_VALUE],
			["MessageChannel", base_config_1$80.TYPE_VALUE],
			["MessageEvent", base_config_1$80.TYPE_VALUE],
			["MessageEventTargetEventMap", base_config_1$80.TYPE],
			["MessageEventTarget", base_config_1$80.TYPE],
			["MessagePortEventMap", base_config_1$80.TYPE],
			["MessagePort", base_config_1$80.TYPE_VALUE],
			["MimeType", base_config_1$80.TYPE_VALUE],
			["MimeTypeArray", base_config_1$80.TYPE_VALUE],
			["MouseEvent", base_config_1$80.TYPE_VALUE],
			["MutationObserver", base_config_1$80.TYPE_VALUE],
			["MutationRecord", base_config_1$80.TYPE_VALUE],
			["NamedNodeMap", base_config_1$80.TYPE_VALUE],
			["NavigationActivation", base_config_1$80.TYPE_VALUE],
			["NavigationHistoryEntryEventMap", base_config_1$80.TYPE],
			["NavigationHistoryEntry", base_config_1$80.TYPE_VALUE],
			["NavigationPreloadManager", base_config_1$80.TYPE_VALUE],
			["Navigator", base_config_1$80.TYPE_VALUE],
			["NavigatorAutomationInformation", base_config_1$80.TYPE],
			["NavigatorBadge", base_config_1$80.TYPE],
			["NavigatorConcurrentHardware", base_config_1$80.TYPE],
			["NavigatorContentUtils", base_config_1$80.TYPE],
			["NavigatorCookies", base_config_1$80.TYPE],
			["NavigatorID", base_config_1$80.TYPE],
			["NavigatorLanguage", base_config_1$80.TYPE],
			["NavigatorLocks", base_config_1$80.TYPE],
			["NavigatorLogin", base_config_1$80.TYPE_VALUE],
			["NavigatorOnLine", base_config_1$80.TYPE],
			["NavigatorPlugins", base_config_1$80.TYPE],
			["NavigatorStorage", base_config_1$80.TYPE],
			["Node", base_config_1$80.TYPE_VALUE],
			["NodeIterator", base_config_1$80.TYPE_VALUE],
			["NodeList", base_config_1$80.TYPE_VALUE],
			["NodeListOf", base_config_1$80.TYPE],
			["NonDocumentTypeChildNode", base_config_1$80.TYPE],
			["NonElementParentNode", base_config_1$80.TYPE],
			["NotificationEventMap", base_config_1$80.TYPE],
			["Notification", base_config_1$80.TYPE_VALUE],
			["OES_draw_buffers_indexed", base_config_1$80.TYPE],
			["OES_element_index_uint", base_config_1$80.TYPE],
			["OES_fbo_render_mipmap", base_config_1$80.TYPE],
			["OES_standard_derivatives", base_config_1$80.TYPE],
			["OES_texture_float", base_config_1$80.TYPE],
			["OES_texture_float_linear", base_config_1$80.TYPE],
			["OES_texture_half_float", base_config_1$80.TYPE],
			["OES_texture_half_float_linear", base_config_1$80.TYPE],
			["OES_vertex_array_object", base_config_1$80.TYPE],
			["OVR_multiview2", base_config_1$80.TYPE],
			["OfflineAudioCompletionEvent", base_config_1$80.TYPE_VALUE],
			["OfflineAudioContextEventMap", base_config_1$80.TYPE],
			["OfflineAudioContext", base_config_1$80.TYPE_VALUE],
			["OffscreenCanvasEventMap", base_config_1$80.TYPE],
			["OffscreenCanvas", base_config_1$80.TYPE_VALUE],
			["OffscreenCanvasRenderingContext2D", base_config_1$80.TYPE_VALUE],
			["OscillatorNode", base_config_1$80.TYPE_VALUE],
			["OverconstrainedError", base_config_1$80.TYPE_VALUE],
			["PageRevealEvent", base_config_1$80.TYPE_VALUE],
			["PageSwapEvent", base_config_1$80.TYPE_VALUE],
			["PageTransitionEvent", base_config_1$80.TYPE_VALUE],
			["PannerNode", base_config_1$80.TYPE_VALUE],
			["ParentNode", base_config_1$80.TYPE],
			["Path2D", base_config_1$80.TYPE_VALUE],
			["PaymentAddress", base_config_1$80.TYPE_VALUE],
			["PaymentMethodChangeEvent", base_config_1$80.TYPE_VALUE],
			["PaymentRequestEventMap", base_config_1$80.TYPE],
			["PaymentRequest", base_config_1$80.TYPE_VALUE],
			["PaymentRequestUpdateEvent", base_config_1$80.TYPE_VALUE],
			["PaymentResponseEventMap", base_config_1$80.TYPE],
			["PaymentResponse", base_config_1$80.TYPE_VALUE],
			["PerformanceEventMap", base_config_1$80.TYPE],
			["Performance", base_config_1$80.TYPE_VALUE],
			["PerformanceEntry", base_config_1$80.TYPE_VALUE],
			["PerformanceEventTiming", base_config_1$80.TYPE_VALUE],
			["PerformanceMark", base_config_1$80.TYPE_VALUE],
			["PerformanceMeasure", base_config_1$80.TYPE_VALUE],
			["PerformanceNavigation", base_config_1$80.TYPE_VALUE],
			["PerformanceNavigationTiming", base_config_1$80.TYPE_VALUE],
			["PerformanceObserver", base_config_1$80.TYPE_VALUE],
			["PerformanceObserverEntryList", base_config_1$80.TYPE_VALUE],
			["PerformancePaintTiming", base_config_1$80.TYPE_VALUE],
			["PerformanceResourceTiming", base_config_1$80.TYPE_VALUE],
			["PerformanceServerTiming", base_config_1$80.TYPE_VALUE],
			["PerformanceTiming", base_config_1$80.TYPE_VALUE],
			["PeriodicWave", base_config_1$80.TYPE_VALUE],
			["PermissionStatusEventMap", base_config_1$80.TYPE],
			["PermissionStatus", base_config_1$80.TYPE_VALUE],
			["Permissions", base_config_1$80.TYPE_VALUE],
			["PictureInPictureEvent", base_config_1$80.TYPE_VALUE],
			["PictureInPictureWindowEventMap", base_config_1$80.TYPE],
			["PictureInPictureWindow", base_config_1$80.TYPE_VALUE],
			["Plugin", base_config_1$80.TYPE_VALUE],
			["PluginArray", base_config_1$80.TYPE_VALUE],
			["PointerEvent", base_config_1$80.TYPE_VALUE],
			["PopStateEvent", base_config_1$80.TYPE_VALUE],
			["PopoverInvokerElement", base_config_1$80.TYPE],
			["ProcessingInstruction", base_config_1$80.TYPE_VALUE],
			["ProgressEvent", base_config_1$80.TYPE_VALUE],
			["PromiseRejectionEvent", base_config_1$80.TYPE_VALUE],
			["PublicKeyCredential", base_config_1$80.TYPE_VALUE],
			["PushManager", base_config_1$80.TYPE_VALUE],
			["PushSubscription", base_config_1$80.TYPE_VALUE],
			["PushSubscriptionOptions", base_config_1$80.TYPE_VALUE],
			["RTCCertificate", base_config_1$80.TYPE_VALUE],
			["RTCDTMFSenderEventMap", base_config_1$80.TYPE],
			["RTCDTMFSender", base_config_1$80.TYPE_VALUE],
			["RTCDTMFToneChangeEvent", base_config_1$80.TYPE_VALUE],
			["RTCDataChannelEventMap", base_config_1$80.TYPE],
			["RTCDataChannel", base_config_1$80.TYPE_VALUE],
			["RTCDataChannelEvent", base_config_1$80.TYPE_VALUE],
			["RTCDtlsTransportEventMap", base_config_1$80.TYPE],
			["RTCDtlsTransport", base_config_1$80.TYPE_VALUE],
			["RTCEncodedAudioFrame", base_config_1$80.TYPE_VALUE],
			["RTCEncodedVideoFrame", base_config_1$80.TYPE_VALUE],
			["RTCError", base_config_1$80.TYPE_VALUE],
			["RTCErrorEvent", base_config_1$80.TYPE_VALUE],
			["RTCIceCandidate", base_config_1$80.TYPE_VALUE],
			["RTCIceCandidatePair", base_config_1$80.TYPE],
			["RTCIceTransportEventMap", base_config_1$80.TYPE],
			["RTCIceTransport", base_config_1$80.TYPE_VALUE],
			["RTCPeerConnectionEventMap", base_config_1$80.TYPE],
			["RTCPeerConnection", base_config_1$80.TYPE_VALUE],
			["RTCPeerConnectionIceErrorEvent", base_config_1$80.TYPE_VALUE],
			["RTCPeerConnectionIceEvent", base_config_1$80.TYPE_VALUE],
			["RTCRtpReceiver", base_config_1$80.TYPE_VALUE],
			["RTCRtpScriptTransform", base_config_1$80.TYPE_VALUE],
			["RTCRtpSender", base_config_1$80.TYPE_VALUE],
			["RTCRtpTransceiver", base_config_1$80.TYPE_VALUE],
			["RTCSctpTransportEventMap", base_config_1$80.TYPE],
			["RTCSctpTransport", base_config_1$80.TYPE_VALUE],
			["RTCSessionDescription", base_config_1$80.TYPE_VALUE],
			["RTCStatsReport", base_config_1$80.TYPE_VALUE],
			["RTCTrackEvent", base_config_1$80.TYPE_VALUE],
			["RadioNodeList", base_config_1$80.TYPE_VALUE],
			["Range", base_config_1$80.TYPE_VALUE],
			["ReadableByteStreamController", base_config_1$80.TYPE_VALUE],
			["ReadableStream", base_config_1$80.TYPE_VALUE],
			["ReadableStreamBYOBReader", base_config_1$80.TYPE_VALUE],
			["ReadableStreamBYOBRequest", base_config_1$80.TYPE_VALUE],
			["ReadableStreamDefaultController", base_config_1$80.TYPE_VALUE],
			["ReadableStreamDefaultReader", base_config_1$80.TYPE_VALUE],
			["ReadableStreamGenericReader", base_config_1$80.TYPE],
			["RemotePlaybackEventMap", base_config_1$80.TYPE],
			["RemotePlayback", base_config_1$80.TYPE_VALUE],
			["Report", base_config_1$80.TYPE_VALUE],
			["ReportBody", base_config_1$80.TYPE_VALUE],
			["ReportingObserver", base_config_1$80.TYPE_VALUE],
			["Request", base_config_1$80.TYPE_VALUE],
			["ResizeObserver", base_config_1$80.TYPE_VALUE],
			["ResizeObserverEntry", base_config_1$80.TYPE_VALUE],
			["ResizeObserverSize", base_config_1$80.TYPE_VALUE],
			["Response", base_config_1$80.TYPE_VALUE],
			["SVGAElement", base_config_1$80.TYPE_VALUE],
			["SVGAngle", base_config_1$80.TYPE_VALUE],
			["SVGAnimateElement", base_config_1$80.TYPE_VALUE],
			["SVGAnimateMotionElement", base_config_1$80.TYPE_VALUE],
			["SVGAnimateTransformElement", base_config_1$80.TYPE_VALUE],
			["SVGAnimatedAngle", base_config_1$80.TYPE_VALUE],
			["SVGAnimatedBoolean", base_config_1$80.TYPE_VALUE],
			["SVGAnimatedEnumeration", base_config_1$80.TYPE_VALUE],
			["SVGAnimatedInteger", base_config_1$80.TYPE_VALUE],
			["SVGAnimatedLength", base_config_1$80.TYPE_VALUE],
			["SVGAnimatedLengthList", base_config_1$80.TYPE_VALUE],
			["SVGAnimatedNumber", base_config_1$80.TYPE_VALUE],
			["SVGAnimatedNumberList", base_config_1$80.TYPE_VALUE],
			["SVGAnimatedPoints", base_config_1$80.TYPE],
			["SVGAnimatedPreserveAspectRatio", base_config_1$80.TYPE_VALUE],
			["SVGAnimatedRect", base_config_1$80.TYPE_VALUE],
			["SVGAnimatedString", base_config_1$80.TYPE_VALUE],
			["SVGAnimatedTransformList", base_config_1$80.TYPE_VALUE],
			["SVGAnimationElement", base_config_1$80.TYPE_VALUE],
			["SVGCircleElement", base_config_1$80.TYPE_VALUE],
			["SVGClipPathElement", base_config_1$80.TYPE_VALUE],
			["SVGComponentTransferFunctionElement", base_config_1$80.TYPE_VALUE],
			["SVGDefsElement", base_config_1$80.TYPE_VALUE],
			["SVGDescElement", base_config_1$80.TYPE_VALUE],
			["SVGElementEventMap", base_config_1$80.TYPE],
			["SVGElement", base_config_1$80.TYPE_VALUE],
			["SVGEllipseElement", base_config_1$80.TYPE_VALUE],
			["SVGFEBlendElement", base_config_1$80.TYPE_VALUE],
			["SVGFEColorMatrixElement", base_config_1$80.TYPE_VALUE],
			["SVGFEComponentTransferElement", base_config_1$80.TYPE_VALUE],
			["SVGFECompositeElement", base_config_1$80.TYPE_VALUE],
			["SVGFEConvolveMatrixElement", base_config_1$80.TYPE_VALUE],
			["SVGFEDiffuseLightingElement", base_config_1$80.TYPE_VALUE],
			["SVGFEDisplacementMapElement", base_config_1$80.TYPE_VALUE],
			["SVGFEDistantLightElement", base_config_1$80.TYPE_VALUE],
			["SVGFEDropShadowElement", base_config_1$80.TYPE_VALUE],
			["SVGFEFloodElement", base_config_1$80.TYPE_VALUE],
			["SVGFEFuncAElement", base_config_1$80.TYPE_VALUE],
			["SVGFEFuncBElement", base_config_1$80.TYPE_VALUE],
			["SVGFEFuncGElement", base_config_1$80.TYPE_VALUE],
			["SVGFEFuncRElement", base_config_1$80.TYPE_VALUE],
			["SVGFEGaussianBlurElement", base_config_1$80.TYPE_VALUE],
			["SVGFEImageElement", base_config_1$80.TYPE_VALUE],
			["SVGFEMergeElement", base_config_1$80.TYPE_VALUE],
			["SVGFEMergeNodeElement", base_config_1$80.TYPE_VALUE],
			["SVGFEMorphologyElement", base_config_1$80.TYPE_VALUE],
			["SVGFEOffsetElement", base_config_1$80.TYPE_VALUE],
			["SVGFEPointLightElement", base_config_1$80.TYPE_VALUE],
			["SVGFESpecularLightingElement", base_config_1$80.TYPE_VALUE],
			["SVGFESpotLightElement", base_config_1$80.TYPE_VALUE],
			["SVGFETileElement", base_config_1$80.TYPE_VALUE],
			["SVGFETurbulenceElement", base_config_1$80.TYPE_VALUE],
			["SVGFilterElement", base_config_1$80.TYPE_VALUE],
			["SVGFilterPrimitiveStandardAttributes", base_config_1$80.TYPE],
			["SVGFitToViewBox", base_config_1$80.TYPE],
			["SVGForeignObjectElement", base_config_1$80.TYPE_VALUE],
			["SVGGElement", base_config_1$80.TYPE_VALUE],
			["SVGGeometryElement", base_config_1$80.TYPE_VALUE],
			["SVGGradientElement", base_config_1$80.TYPE_VALUE],
			["SVGGraphicsElement", base_config_1$80.TYPE_VALUE],
			["SVGImageElement", base_config_1$80.TYPE_VALUE],
			["SVGLength", base_config_1$80.TYPE_VALUE],
			["SVGLengthList", base_config_1$80.TYPE_VALUE],
			["SVGLineElement", base_config_1$80.TYPE_VALUE],
			["SVGLinearGradientElement", base_config_1$80.TYPE_VALUE],
			["SVGMPathElement", base_config_1$80.TYPE_VALUE],
			["SVGMarkerElement", base_config_1$80.TYPE_VALUE],
			["SVGMaskElement", base_config_1$80.TYPE_VALUE],
			["SVGMetadataElement", base_config_1$80.TYPE_VALUE],
			["SVGNumber", base_config_1$80.TYPE_VALUE],
			["SVGNumberList", base_config_1$80.TYPE_VALUE],
			["SVGPathElement", base_config_1$80.TYPE_VALUE],
			["SVGPatternElement", base_config_1$80.TYPE_VALUE],
			["SVGPointList", base_config_1$80.TYPE_VALUE],
			["SVGPolygonElement", base_config_1$80.TYPE_VALUE],
			["SVGPolylineElement", base_config_1$80.TYPE_VALUE],
			["SVGPreserveAspectRatio", base_config_1$80.TYPE_VALUE],
			["SVGRadialGradientElement", base_config_1$80.TYPE_VALUE],
			["SVGRectElement", base_config_1$80.TYPE_VALUE],
			["SVGSVGElementEventMap", base_config_1$80.TYPE],
			["SVGSVGElement", base_config_1$80.TYPE_VALUE],
			["SVGScriptElement", base_config_1$80.TYPE_VALUE],
			["SVGSetElement", base_config_1$80.TYPE_VALUE],
			["SVGStopElement", base_config_1$80.TYPE_VALUE],
			["SVGStringList", base_config_1$80.TYPE_VALUE],
			["SVGStyleElement", base_config_1$80.TYPE_VALUE],
			["SVGSwitchElement", base_config_1$80.TYPE_VALUE],
			["SVGSymbolElement", base_config_1$80.TYPE_VALUE],
			["SVGTSpanElement", base_config_1$80.TYPE_VALUE],
			["SVGTests", base_config_1$80.TYPE],
			["SVGTextContentElement", base_config_1$80.TYPE_VALUE],
			["SVGTextElement", base_config_1$80.TYPE_VALUE],
			["SVGTextPathElement", base_config_1$80.TYPE_VALUE],
			["SVGTextPositioningElement", base_config_1$80.TYPE_VALUE],
			["SVGTitleElement", base_config_1$80.TYPE_VALUE],
			["SVGTransform", base_config_1$80.TYPE_VALUE],
			["SVGTransformList", base_config_1$80.TYPE_VALUE],
			["SVGURIReference", base_config_1$80.TYPE],
			["SVGUnitTypes", base_config_1$80.TYPE_VALUE],
			["SVGUseElement", base_config_1$80.TYPE_VALUE],
			["SVGViewElement", base_config_1$80.TYPE_VALUE],
			["Screen", base_config_1$80.TYPE_VALUE],
			["ScreenOrientationEventMap", base_config_1$80.TYPE],
			["ScreenOrientation", base_config_1$80.TYPE_VALUE],
			["ScriptProcessorNodeEventMap", base_config_1$80.TYPE],
			["ScriptProcessorNode", base_config_1$80.TYPE_VALUE],
			["SecurityPolicyViolationEvent", base_config_1$80.TYPE_VALUE],
			["Selection", base_config_1$80.TYPE_VALUE],
			["ServiceWorkerEventMap", base_config_1$80.TYPE],
			["ServiceWorker", base_config_1$80.TYPE_VALUE],
			["ServiceWorkerContainerEventMap", base_config_1$80.TYPE],
			["ServiceWorkerContainer", base_config_1$80.TYPE_VALUE],
			["ServiceWorkerRegistrationEventMap", base_config_1$80.TYPE],
			["ServiceWorkerRegistration", base_config_1$80.TYPE_VALUE],
			["ShadowRootEventMap", base_config_1$80.TYPE],
			["ShadowRoot", base_config_1$80.TYPE_VALUE],
			["SharedWorker", base_config_1$80.TYPE_VALUE],
			["Slottable", base_config_1$80.TYPE],
			["SourceBufferEventMap", base_config_1$80.TYPE],
			["SourceBuffer", base_config_1$80.TYPE_VALUE],
			["SourceBufferListEventMap", base_config_1$80.TYPE],
			["SourceBufferList", base_config_1$80.TYPE_VALUE],
			["SpeechRecognitionAlternative", base_config_1$80.TYPE_VALUE],
			["SpeechRecognitionResult", base_config_1$80.TYPE_VALUE],
			["SpeechRecognitionResultList", base_config_1$80.TYPE_VALUE],
			["SpeechSynthesisEventMap", base_config_1$80.TYPE],
			["SpeechSynthesis", base_config_1$80.TYPE_VALUE],
			["SpeechSynthesisErrorEvent", base_config_1$80.TYPE_VALUE],
			["SpeechSynthesisEvent", base_config_1$80.TYPE_VALUE],
			["SpeechSynthesisUtteranceEventMap", base_config_1$80.TYPE],
			["SpeechSynthesisUtterance", base_config_1$80.TYPE_VALUE],
			["SpeechSynthesisVoice", base_config_1$80.TYPE_VALUE],
			["StaticRange", base_config_1$80.TYPE_VALUE],
			["StereoPannerNode", base_config_1$80.TYPE_VALUE],
			["Storage", base_config_1$80.TYPE_VALUE],
			["StorageEvent", base_config_1$80.TYPE_VALUE],
			["StorageManager", base_config_1$80.TYPE_VALUE],
			["StyleMedia", base_config_1$80.TYPE],
			["StylePropertyMap", base_config_1$80.TYPE_VALUE],
			["StylePropertyMapReadOnly", base_config_1$80.TYPE_VALUE],
			["StyleSheet", base_config_1$80.TYPE_VALUE],
			["StyleSheetList", base_config_1$80.TYPE_VALUE],
			["SubmitEvent", base_config_1$80.TYPE_VALUE],
			["SubtleCrypto", base_config_1$80.TYPE_VALUE],
			["Text", base_config_1$80.TYPE_VALUE],
			["TextDecoder", base_config_1$80.TYPE_VALUE],
			["TextDecoderCommon", base_config_1$80.TYPE],
			["TextDecoderStream", base_config_1$80.TYPE_VALUE],
			["TextEncoder", base_config_1$80.TYPE_VALUE],
			["TextEncoderCommon", base_config_1$80.TYPE],
			["TextEncoderStream", base_config_1$80.TYPE_VALUE],
			["TextEvent", base_config_1$80.TYPE_VALUE],
			["TextMetrics", base_config_1$80.TYPE_VALUE],
			["TextTrackEventMap", base_config_1$80.TYPE],
			["TextTrack", base_config_1$80.TYPE_VALUE],
			["TextTrackCueEventMap", base_config_1$80.TYPE],
			["TextTrackCue", base_config_1$80.TYPE_VALUE],
			["TextTrackCueList", base_config_1$80.TYPE_VALUE],
			["TextTrackListEventMap", base_config_1$80.TYPE],
			["TextTrackList", base_config_1$80.TYPE_VALUE],
			["TimeRanges", base_config_1$80.TYPE_VALUE],
			["ToggleEvent", base_config_1$80.TYPE_VALUE],
			["Touch", base_config_1$80.TYPE_VALUE],
			["TouchEvent", base_config_1$80.TYPE_VALUE],
			["TouchList", base_config_1$80.TYPE_VALUE],
			["TrackEvent", base_config_1$80.TYPE_VALUE],
			["TransformStream", base_config_1$80.TYPE_VALUE],
			["TransformStreamDefaultController", base_config_1$80.TYPE_VALUE],
			["TransitionEvent", base_config_1$80.TYPE_VALUE],
			["TreeWalker", base_config_1$80.TYPE_VALUE],
			["UIEvent", base_config_1$80.TYPE_VALUE],
			["URL", base_config_1$80.TYPE_VALUE],
			["webkitURL", base_config_1$80.TYPE_VALUE],
			["URLSearchParams", base_config_1$80.TYPE_VALUE],
			["UserActivation", base_config_1$80.TYPE_VALUE],
			["VTTCue", base_config_1$80.TYPE_VALUE],
			["VTTRegion", base_config_1$80.TYPE_VALUE],
			["ValidityState", base_config_1$80.TYPE_VALUE],
			["VideoColorSpace", base_config_1$80.TYPE_VALUE],
			["VideoDecoderEventMap", base_config_1$80.TYPE],
			["VideoDecoder", base_config_1$80.TYPE_VALUE],
			["VideoEncoderEventMap", base_config_1$80.TYPE],
			["VideoEncoder", base_config_1$80.TYPE_VALUE],
			["VideoFrame", base_config_1$80.TYPE_VALUE],
			["VideoPlaybackQuality", base_config_1$80.TYPE_VALUE],
			["ViewTransition", base_config_1$80.TYPE_VALUE],
			["ViewTransitionTypeSet", base_config_1$80.TYPE_VALUE],
			["VisualViewportEventMap", base_config_1$80.TYPE],
			["VisualViewport", base_config_1$80.TYPE_VALUE],
			["WEBGL_color_buffer_float", base_config_1$80.TYPE],
			["WEBGL_compressed_texture_astc", base_config_1$80.TYPE],
			["WEBGL_compressed_texture_etc", base_config_1$80.TYPE],
			["WEBGL_compressed_texture_etc1", base_config_1$80.TYPE],
			["WEBGL_compressed_texture_pvrtc", base_config_1$80.TYPE],
			["WEBGL_compressed_texture_s3tc", base_config_1$80.TYPE],
			["WEBGL_compressed_texture_s3tc_srgb", base_config_1$80.TYPE],
			["WEBGL_debug_renderer_info", base_config_1$80.TYPE],
			["WEBGL_debug_shaders", base_config_1$80.TYPE],
			["WEBGL_depth_texture", base_config_1$80.TYPE],
			["WEBGL_draw_buffers", base_config_1$80.TYPE],
			["WEBGL_lose_context", base_config_1$80.TYPE],
			["WEBGL_multi_draw", base_config_1$80.TYPE],
			["WakeLock", base_config_1$80.TYPE_VALUE],
			["WakeLockSentinelEventMap", base_config_1$80.TYPE],
			["WakeLockSentinel", base_config_1$80.TYPE_VALUE],
			["WaveShaperNode", base_config_1$80.TYPE_VALUE],
			["WebGL2RenderingContext", base_config_1$80.TYPE_VALUE],
			["WebGL2RenderingContextBase", base_config_1$80.TYPE],
			["WebGL2RenderingContextOverloads", base_config_1$80.TYPE],
			["WebGLActiveInfo", base_config_1$80.TYPE_VALUE],
			["WebGLBuffer", base_config_1$80.TYPE_VALUE],
			["WebGLContextEvent", base_config_1$80.TYPE_VALUE],
			["WebGLFramebuffer", base_config_1$80.TYPE_VALUE],
			["WebGLProgram", base_config_1$80.TYPE_VALUE],
			["WebGLQuery", base_config_1$80.TYPE_VALUE],
			["WebGLRenderbuffer", base_config_1$80.TYPE_VALUE],
			["WebGLRenderingContext", base_config_1$80.TYPE_VALUE],
			["WebGLRenderingContextBase", base_config_1$80.TYPE],
			["WebGLRenderingContextOverloads", base_config_1$80.TYPE],
			["WebGLSampler", base_config_1$80.TYPE_VALUE],
			["WebGLShader", base_config_1$80.TYPE_VALUE],
			["WebGLShaderPrecisionFormat", base_config_1$80.TYPE_VALUE],
			["WebGLSync", base_config_1$80.TYPE_VALUE],
			["WebGLTexture", base_config_1$80.TYPE_VALUE],
			["WebGLTransformFeedback", base_config_1$80.TYPE_VALUE],
			["WebGLUniformLocation", base_config_1$80.TYPE_VALUE],
			["WebGLVertexArrayObject", base_config_1$80.TYPE_VALUE],
			["WebGLVertexArrayObjectOES", base_config_1$80.TYPE],
			["WebSocketEventMap", base_config_1$80.TYPE],
			["WebSocket", base_config_1$80.TYPE_VALUE],
			["WebTransport", base_config_1$80.TYPE_VALUE],
			["WebTransportBidirectionalStream", base_config_1$80.TYPE_VALUE],
			["WebTransportDatagramDuplexStream", base_config_1$80.TYPE_VALUE],
			["WebTransportError", base_config_1$80.TYPE_VALUE],
			["WheelEvent", base_config_1$80.TYPE_VALUE],
			["WindowEventMap", base_config_1$80.TYPE],
			["Window", base_config_1$80.TYPE_VALUE],
			["WindowEventHandlersEventMap", base_config_1$80.TYPE],
			["WindowEventHandlers", base_config_1$80.TYPE],
			["WindowLocalStorage", base_config_1$80.TYPE],
			["WindowOrWorkerGlobalScope", base_config_1$80.TYPE],
			["WindowSessionStorage", base_config_1$80.TYPE],
			["WorkerEventMap", base_config_1$80.TYPE],
			["Worker", base_config_1$80.TYPE_VALUE],
			["Worklet", base_config_1$80.TYPE_VALUE],
			["WritableStream", base_config_1$80.TYPE_VALUE],
			["WritableStreamDefaultController", base_config_1$80.TYPE_VALUE],
			["WritableStreamDefaultWriter", base_config_1$80.TYPE_VALUE],
			["XMLDocument", base_config_1$80.TYPE_VALUE],
			["XMLHttpRequestEventMap", base_config_1$80.TYPE],
			["XMLHttpRequest", base_config_1$80.TYPE_VALUE],
			["XMLHttpRequestEventTargetEventMap", base_config_1$80.TYPE],
			["XMLHttpRequestEventTarget", base_config_1$80.TYPE_VALUE],
			["XMLHttpRequestUpload", base_config_1$80.TYPE_VALUE],
			["XMLSerializer", base_config_1$80.TYPE_VALUE],
			["XPathEvaluator", base_config_1$80.TYPE_VALUE],
			["XPathEvaluatorBase", base_config_1$80.TYPE],
			["XPathExpression", base_config_1$80.TYPE_VALUE],
			["XPathResult", base_config_1$80.TYPE_VALUE],
			["XSLTProcessor", base_config_1$80.TYPE_VALUE],
			["CSS", base_config_1$80.TYPE_VALUE],
			["WebAssembly", base_config_1$80.TYPE_VALUE],
			["Console", base_config_1$80.TYPE],
			["AudioDataOutputCallback", base_config_1$80.TYPE],
			["BlobCallback", base_config_1$80.TYPE],
			["CustomElementConstructor", base_config_1$80.TYPE],
			["DecodeErrorCallback", base_config_1$80.TYPE],
			["DecodeSuccessCallback", base_config_1$80.TYPE],
			["EncodedAudioChunkOutputCallback", base_config_1$80.TYPE],
			["EncodedVideoChunkOutputCallback", base_config_1$80.TYPE],
			["ErrorCallback", base_config_1$80.TYPE],
			["FileCallback", base_config_1$80.TYPE],
			["FileSystemEntriesCallback", base_config_1$80.TYPE],
			["FileSystemEntryCallback", base_config_1$80.TYPE],
			["FrameRequestCallback", base_config_1$80.TYPE],
			["FunctionStringCallback", base_config_1$80.TYPE],
			["IdleRequestCallback", base_config_1$80.TYPE],
			["IntersectionObserverCallback", base_config_1$80.TYPE],
			["LockGrantedCallback", base_config_1$80.TYPE],
			["MediaSessionActionHandler", base_config_1$80.TYPE],
			["MutationCallback", base_config_1$80.TYPE],
			["NotificationPermissionCallback", base_config_1$80.TYPE],
			["OnBeforeUnloadEventHandlerNonNull", base_config_1$80.TYPE],
			["OnErrorEventHandlerNonNull", base_config_1$80.TYPE],
			["PerformanceObserverCallback", base_config_1$80.TYPE],
			["PositionCallback", base_config_1$80.TYPE],
			["PositionErrorCallback", base_config_1$80.TYPE],
			["QueuingStrategySize", base_config_1$80.TYPE],
			["RTCPeerConnectionErrorCallback", base_config_1$80.TYPE],
			["RTCSessionDescriptionCallback", base_config_1$80.TYPE],
			["RemotePlaybackAvailabilityCallback", base_config_1$80.TYPE],
			["ReportingObserverCallback", base_config_1$80.TYPE],
			["ResizeObserverCallback", base_config_1$80.TYPE],
			["TransformerFlushCallback", base_config_1$80.TYPE],
			["TransformerStartCallback", base_config_1$80.TYPE],
			["TransformerTransformCallback", base_config_1$80.TYPE],
			["UnderlyingSinkAbortCallback", base_config_1$80.TYPE],
			["UnderlyingSinkCloseCallback", base_config_1$80.TYPE],
			["UnderlyingSinkStartCallback", base_config_1$80.TYPE],
			["UnderlyingSinkWriteCallback", base_config_1$80.TYPE],
			["UnderlyingSourceCancelCallback", base_config_1$80.TYPE],
			["UnderlyingSourcePullCallback", base_config_1$80.TYPE],
			["UnderlyingSourceStartCallback", base_config_1$80.TYPE],
			["VideoFrameOutputCallback", base_config_1$80.TYPE],
			["VideoFrameRequestCallback", base_config_1$80.TYPE],
			["ViewTransitionUpdateCallback", base_config_1$80.TYPE],
			["VoidFunction", base_config_1$80.TYPE],
			["WebCodecsErrorCallback", base_config_1$80.TYPE],
			["HTMLElementTagNameMap", base_config_1$80.TYPE],
			["HTMLElementDeprecatedTagNameMap", base_config_1$80.TYPE],
			["SVGElementTagNameMap", base_config_1$80.TYPE],
			["MathMLElementTagNameMap", base_config_1$80.TYPE],
			["ElementTagNameMap", base_config_1$80.TYPE],
			["AlgorithmIdentifier", base_config_1$80.TYPE],
			["AllowSharedBufferSource", base_config_1$80.TYPE],
			["AutoFill", base_config_1$80.TYPE],
			["AutoFillField", base_config_1$80.TYPE],
			["AutoFillSection", base_config_1$80.TYPE],
			["Base64URLString", base_config_1$80.TYPE],
			["BigInteger", base_config_1$80.TYPE],
			["BlobPart", base_config_1$80.TYPE],
			["BodyInit", base_config_1$80.TYPE],
			["BufferSource", base_config_1$80.TYPE],
			["COSEAlgorithmIdentifier", base_config_1$80.TYPE],
			["CSSKeywordish", base_config_1$80.TYPE],
			["CSSNumberish", base_config_1$80.TYPE],
			["CSSPerspectiveValue", base_config_1$80.TYPE],
			["CSSUnparsedSegment", base_config_1$80.TYPE],
			["CanvasImageSource", base_config_1$80.TYPE],
			["ClipboardItemData", base_config_1$80.TYPE],
			["ClipboardItems", base_config_1$80.TYPE],
			["ConstrainBoolean", base_config_1$80.TYPE],
			["ConstrainDOMString", base_config_1$80.TYPE],
			["ConstrainDouble", base_config_1$80.TYPE],
			["ConstrainULong", base_config_1$80.TYPE],
			["CookieList", base_config_1$80.TYPE],
			["DOMHighResTimeStamp", base_config_1$80.TYPE],
			["EpochTimeStamp", base_config_1$80.TYPE],
			["EventListenerOrEventListenerObject", base_config_1$80.TYPE],
			["FileSystemWriteChunkType", base_config_1$80.TYPE],
			["Float32List", base_config_1$80.TYPE],
			["FormDataEntryValue", base_config_1$80.TYPE],
			["GLbitfield", base_config_1$80.TYPE],
			["GLboolean", base_config_1$80.TYPE],
			["GLclampf", base_config_1$80.TYPE],
			["GLenum", base_config_1$80.TYPE],
			["GLfloat", base_config_1$80.TYPE],
			["GLint", base_config_1$80.TYPE],
			["GLint64", base_config_1$80.TYPE],
			["GLintptr", base_config_1$80.TYPE],
			["GLsizei", base_config_1$80.TYPE],
			["GLsizeiptr", base_config_1$80.TYPE],
			["GLuint", base_config_1$80.TYPE],
			["GLuint64", base_config_1$80.TYPE],
			["HTMLOrSVGImageElement", base_config_1$80.TYPE],
			["HTMLOrSVGScriptElement", base_config_1$80.TYPE],
			["HashAlgorithmIdentifier", base_config_1$80.TYPE],
			["HeadersInit", base_config_1$80.TYPE],
			["IDBValidKey", base_config_1$80.TYPE],
			["ImageBitmapSource", base_config_1$80.TYPE],
			["ImageBufferSource", base_config_1$80.TYPE],
			["ImageDataArray", base_config_1$80.TYPE],
			["Int32List", base_config_1$80.TYPE],
			["LineAndPositionSetting", base_config_1$80.TYPE],
			["MediaProvider", base_config_1$80.TYPE],
			["MessageEventSource", base_config_1$80.TYPE],
			["MutationRecordType", base_config_1$80.TYPE],
			["NamedCurve", base_config_1$80.TYPE],
			["OffscreenRenderingContext", base_config_1$80.TYPE],
			["OnBeforeUnloadEventHandler", base_config_1$80.TYPE],
			["OnErrorEventHandler", base_config_1$80.TYPE],
			["OptionalPostfixToken", base_config_1$80.TYPE],
			["OptionalPrefixToken", base_config_1$80.TYPE],
			["PerformanceEntryList", base_config_1$80.TYPE],
			["PublicKeyCredentialClientCapabilities", base_config_1$80.TYPE],
			["PublicKeyCredentialJSON", base_config_1$80.TYPE],
			["RTCRtpTransform", base_config_1$80.TYPE],
			["ReadableStreamController", base_config_1$80.TYPE],
			["ReadableStreamReadResult", base_config_1$80.TYPE],
			["ReadableStreamReader", base_config_1$80.TYPE],
			["RenderingContext", base_config_1$80.TYPE],
			["ReportList", base_config_1$80.TYPE],
			["RequestInfo", base_config_1$80.TYPE],
			["TexImageSource", base_config_1$80.TYPE],
			["TimerHandler", base_config_1$80.TYPE],
			["Transferable", base_config_1$80.TYPE],
			["Uint32List", base_config_1$80.TYPE],
			["VibratePattern", base_config_1$80.TYPE],
			["WindowProxy", base_config_1$80.TYPE],
			["XMLHttpRequestBodyInit", base_config_1$80.TYPE],
			["AlignSetting", base_config_1$80.TYPE],
			["AlphaOption", base_config_1$80.TYPE],
			["AnimationPlayState", base_config_1$80.TYPE],
			["AnimationReplaceState", base_config_1$80.TYPE],
			["AppendMode", base_config_1$80.TYPE],
			["AttestationConveyancePreference", base_config_1$80.TYPE],
			["AudioContextLatencyCategory", base_config_1$80.TYPE],
			["AudioContextState", base_config_1$80.TYPE],
			["AudioSampleFormat", base_config_1$80.TYPE],
			["AuthenticatorAttachment", base_config_1$80.TYPE],
			["AuthenticatorTransport", base_config_1$80.TYPE],
			["AutoFillAddressKind", base_config_1$80.TYPE],
			["AutoFillBase", base_config_1$80.TYPE],
			["AutoFillContactField", base_config_1$80.TYPE],
			["AutoFillContactKind", base_config_1$80.TYPE],
			["AutoFillCredentialField", base_config_1$80.TYPE],
			["AutoFillNormalField", base_config_1$80.TYPE],
			["AutoKeyword", base_config_1$80.TYPE],
			["AutomationRate", base_config_1$80.TYPE],
			["AvcBitstreamFormat", base_config_1$80.TYPE],
			["BinaryType", base_config_1$80.TYPE],
			["BiquadFilterType", base_config_1$80.TYPE],
			["BitrateMode", base_config_1$80.TYPE],
			["CSSMathOperator", base_config_1$80.TYPE],
			["CSSNumericBaseType", base_config_1$80.TYPE],
			["CanPlayTypeResult", base_config_1$80.TYPE],
			["CanvasDirection", base_config_1$80.TYPE],
			["CanvasFillRule", base_config_1$80.TYPE],
			["CanvasFontKerning", base_config_1$80.TYPE],
			["CanvasFontStretch", base_config_1$80.TYPE],
			["CanvasFontVariantCaps", base_config_1$80.TYPE],
			["CanvasLineCap", base_config_1$80.TYPE],
			["CanvasLineJoin", base_config_1$80.TYPE],
			["CanvasTextAlign", base_config_1$80.TYPE],
			["CanvasTextBaseline", base_config_1$80.TYPE],
			["CanvasTextRendering", base_config_1$80.TYPE],
			["ChannelCountMode", base_config_1$80.TYPE],
			["ChannelInterpretation", base_config_1$80.TYPE],
			["ClientTypes", base_config_1$80.TYPE],
			["CodecState", base_config_1$80.TYPE],
			["ColorGamut", base_config_1$80.TYPE],
			["ColorSpaceConversion", base_config_1$80.TYPE],
			["CompositeOperation", base_config_1$80.TYPE],
			["CompositeOperationOrAuto", base_config_1$80.TYPE],
			["CompressionFormat", base_config_1$80.TYPE],
			["CookieSameSite", base_config_1$80.TYPE],
			["CredentialMediationRequirement", base_config_1$80.TYPE],
			["DOMParserSupportedType", base_config_1$80.TYPE],
			["DirectionSetting", base_config_1$80.TYPE],
			["DisplayCaptureSurfaceType", base_config_1$80.TYPE],
			["DistanceModelType", base_config_1$80.TYPE],
			["DocumentReadyState", base_config_1$80.TYPE],
			["DocumentVisibilityState", base_config_1$80.TYPE],
			["EncodedAudioChunkType", base_config_1$80.TYPE],
			["EncodedVideoChunkType", base_config_1$80.TYPE],
			["EndOfStreamError", base_config_1$80.TYPE],
			["EndingType", base_config_1$80.TYPE],
			["FileSystemHandleKind", base_config_1$80.TYPE],
			["FillLightMode", base_config_1$80.TYPE],
			["FillMode", base_config_1$80.TYPE],
			["FontDisplay", base_config_1$80.TYPE],
			["FontFaceLoadStatus", base_config_1$80.TYPE],
			["FontFaceSetLoadStatus", base_config_1$80.TYPE],
			["FullscreenNavigationUI", base_config_1$80.TYPE],
			["GamepadHapticEffectType", base_config_1$80.TYPE],
			["GamepadHapticsResult", base_config_1$80.TYPE],
			["GamepadMappingType", base_config_1$80.TYPE],
			["GlobalCompositeOperation", base_config_1$80.TYPE],
			["HardwareAcceleration", base_config_1$80.TYPE],
			["HdrMetadataType", base_config_1$80.TYPE],
			["HighlightType", base_config_1$80.TYPE],
			["IDBCursorDirection", base_config_1$80.TYPE],
			["IDBRequestReadyState", base_config_1$80.TYPE],
			["IDBTransactionDurability", base_config_1$80.TYPE],
			["IDBTransactionMode", base_config_1$80.TYPE],
			["ImageOrientation", base_config_1$80.TYPE],
			["ImageSmoothingQuality", base_config_1$80.TYPE],
			["InsertPosition", base_config_1$80.TYPE],
			["IterationCompositeOperation", base_config_1$80.TYPE],
			["KeyFormat", base_config_1$80.TYPE],
			["KeyType", base_config_1$80.TYPE],
			["KeyUsage", base_config_1$80.TYPE],
			["LatencyMode", base_config_1$80.TYPE],
			["LineAlignSetting", base_config_1$80.TYPE],
			["LockMode", base_config_1$80.TYPE],
			["LoginStatus", base_config_1$80.TYPE],
			["MIDIPortConnectionState", base_config_1$80.TYPE],
			["MIDIPortDeviceState", base_config_1$80.TYPE],
			["MIDIPortType", base_config_1$80.TYPE],
			["MediaDecodingType", base_config_1$80.TYPE],
			["MediaDeviceKind", base_config_1$80.TYPE],
			["MediaEncodingType", base_config_1$80.TYPE],
			["MediaKeyMessageType", base_config_1$80.TYPE],
			["MediaKeySessionClosedReason", base_config_1$80.TYPE],
			["MediaKeySessionType", base_config_1$80.TYPE],
			["MediaKeyStatus", base_config_1$80.TYPE],
			["MediaKeysRequirement", base_config_1$80.TYPE],
			["MediaSessionAction", base_config_1$80.TYPE],
			["MediaSessionPlaybackState", base_config_1$80.TYPE],
			["MediaStreamTrackState", base_config_1$80.TYPE],
			["NavigationTimingType", base_config_1$80.TYPE],
			["NavigationType", base_config_1$80.TYPE],
			["NotificationDirection", base_config_1$80.TYPE],
			["NotificationPermission", base_config_1$80.TYPE],
			["OffscreenRenderingContextId", base_config_1$80.TYPE],
			["OpusBitstreamFormat", base_config_1$80.TYPE],
			["OrientationType", base_config_1$80.TYPE],
			["OscillatorType", base_config_1$80.TYPE],
			["OverSampleType", base_config_1$80.TYPE],
			["PanningModelType", base_config_1$80.TYPE],
			["PaymentComplete", base_config_1$80.TYPE],
			["PaymentShippingType", base_config_1$80.TYPE],
			["PermissionName", base_config_1$80.TYPE],
			["PermissionState", base_config_1$80.TYPE],
			["PlaybackDirection", base_config_1$80.TYPE],
			["PositionAlignSetting", base_config_1$80.TYPE],
			["PredefinedColorSpace", base_config_1$80.TYPE],
			["PremultiplyAlpha", base_config_1$80.TYPE],
			["PresentationStyle", base_config_1$80.TYPE],
			["PublicKeyCredentialType", base_config_1$80.TYPE],
			["PushEncryptionKeyName", base_config_1$80.TYPE],
			["RTCBundlePolicy", base_config_1$80.TYPE],
			["RTCDataChannelState", base_config_1$80.TYPE],
			["RTCDegradationPreference", base_config_1$80.TYPE],
			["RTCDtlsRole", base_config_1$80.TYPE],
			["RTCDtlsTransportState", base_config_1$80.TYPE],
			["RTCEncodedVideoFrameType", base_config_1$80.TYPE],
			["RTCErrorDetailType", base_config_1$80.TYPE],
			["RTCIceCandidateType", base_config_1$80.TYPE],
			["RTCIceComponent", base_config_1$80.TYPE],
			["RTCIceConnectionState", base_config_1$80.TYPE],
			["RTCIceGathererState", base_config_1$80.TYPE],
			["RTCIceGatheringState", base_config_1$80.TYPE],
			["RTCIceProtocol", base_config_1$80.TYPE],
			["RTCIceRole", base_config_1$80.TYPE],
			["RTCIceTcpCandidateType", base_config_1$80.TYPE],
			["RTCIceTransportPolicy", base_config_1$80.TYPE],
			["RTCIceTransportState", base_config_1$80.TYPE],
			["RTCPeerConnectionState", base_config_1$80.TYPE],
			["RTCPriorityType", base_config_1$80.TYPE],
			["RTCQualityLimitationReason", base_config_1$80.TYPE],
			["RTCRtcpMuxPolicy", base_config_1$80.TYPE],
			["RTCRtpTransceiverDirection", base_config_1$80.TYPE],
			["RTCSctpTransportState", base_config_1$80.TYPE],
			["RTCSdpType", base_config_1$80.TYPE],
			["RTCSignalingState", base_config_1$80.TYPE],
			["RTCStatsIceCandidatePairState", base_config_1$80.TYPE],
			["RTCStatsType", base_config_1$80.TYPE],
			["ReadableStreamReaderMode", base_config_1$80.TYPE],
			["ReadableStreamType", base_config_1$80.TYPE],
			["ReadyState", base_config_1$80.TYPE],
			["RecordingState", base_config_1$80.TYPE],
			["RedEyeReduction", base_config_1$80.TYPE],
			["ReferrerPolicy", base_config_1$80.TYPE],
			["RemotePlaybackState", base_config_1$80.TYPE],
			["RequestCache", base_config_1$80.TYPE],
			["RequestCredentials", base_config_1$80.TYPE],
			["RequestDestination", base_config_1$80.TYPE],
			["RequestMode", base_config_1$80.TYPE],
			["RequestPriority", base_config_1$80.TYPE],
			["RequestRedirect", base_config_1$80.TYPE],
			["ResidentKeyRequirement", base_config_1$80.TYPE],
			["ResizeObserverBoxOptions", base_config_1$80.TYPE],
			["ResizeQuality", base_config_1$80.TYPE],
			["ResponseType", base_config_1$80.TYPE],
			["ScrollBehavior", base_config_1$80.TYPE],
			["ScrollLogicalPosition", base_config_1$80.TYPE],
			["ScrollRestoration", base_config_1$80.TYPE],
			["ScrollSetting", base_config_1$80.TYPE],
			["SecurityPolicyViolationEventDisposition", base_config_1$80.TYPE],
			["SelectionMode", base_config_1$80.TYPE],
			["ServiceWorkerState", base_config_1$80.TYPE],
			["ServiceWorkerUpdateViaCache", base_config_1$80.TYPE],
			["ShadowRootMode", base_config_1$80.TYPE],
			["SlotAssignmentMode", base_config_1$80.TYPE],
			["SpeechSynthesisErrorCode", base_config_1$80.TYPE],
			["TextTrackKind", base_config_1$80.TYPE],
			["TextTrackMode", base_config_1$80.TYPE],
			["TouchType", base_config_1$80.TYPE],
			["TransferFunction", base_config_1$80.TYPE],
			["UserVerificationRequirement", base_config_1$80.TYPE],
			["VideoColorPrimaries", base_config_1$80.TYPE],
			["VideoEncoderBitrateMode", base_config_1$80.TYPE],
			["VideoFacingModeEnum", base_config_1$80.TYPE],
			["VideoMatrixCoefficients", base_config_1$80.TYPE],
			["VideoPixelFormat", base_config_1$80.TYPE],
			["VideoTransferCharacteristics", base_config_1$80.TYPE],
			["WakeLockType", base_config_1$80.TYPE],
			["WebGLPowerPreference", base_config_1$80.TYPE],
			["WebTransportCongestionControl", base_config_1$80.TYPE],
			["WebTransportErrorSource", base_config_1$80.TYPE],
			["WorkerType", base_config_1$80.TYPE],
			["WriteCommandType", base_config_1$80.TYPE],
			["XMLHttpRequestResponseType", base_config_1$80.TYPE]
		]
	};
})), require_dom_asynciterable = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.dom_asynciterable = void 0;
	let base_config_1$79 = require_base_config();
	exports.dom_asynciterable = {
		libs: [],
		variables: [
			["FileSystemDirectoryHandleAsyncIterator", base_config_1$79.TYPE],
			["FileSystemDirectoryHandle", base_config_1$79.TYPE],
			["ReadableStreamAsyncIterator", base_config_1$79.TYPE],
			["ReadableStream", base_config_1$79.TYPE]
		]
	};
})), require_dom_iterable = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.dom_iterable = void 0;
	let base_config_1$78 = require_base_config();
	exports.dom_iterable = {
		libs: [],
		variables: [
			["AudioParam", base_config_1$78.TYPE],
			["AudioParamMap", base_config_1$78.TYPE],
			["BaseAudioContext", base_config_1$78.TYPE],
			["CSSKeyframesRule", base_config_1$78.TYPE],
			["CSSNumericArray", base_config_1$78.TYPE],
			["CSSRuleList", base_config_1$78.TYPE],
			["CSSStyleDeclaration", base_config_1$78.TYPE],
			["CSSTransformValue", base_config_1$78.TYPE],
			["CSSUnparsedValue", base_config_1$78.TYPE],
			["Cache", base_config_1$78.TYPE],
			["CanvasPath", base_config_1$78.TYPE],
			["CanvasPathDrawingStyles", base_config_1$78.TYPE],
			["CookieStoreManager", base_config_1$78.TYPE],
			["CustomStateSet", base_config_1$78.TYPE],
			["DOMRectList", base_config_1$78.TYPE],
			["DOMStringList", base_config_1$78.TYPE],
			["DOMTokenList", base_config_1$78.TYPE],
			["DataTransferItemList", base_config_1$78.TYPE],
			["EventCounts", base_config_1$78.TYPE],
			["FileList", base_config_1$78.TYPE],
			["FontFaceSet", base_config_1$78.TYPE],
			["FormDataIterator", base_config_1$78.TYPE],
			["FormData", base_config_1$78.TYPE],
			["HTMLAllCollection", base_config_1$78.TYPE],
			["HTMLCollectionBase", base_config_1$78.TYPE],
			["HTMLCollectionOf", base_config_1$78.TYPE],
			["HTMLFormElement", base_config_1$78.TYPE],
			["HTMLSelectElement", base_config_1$78.TYPE],
			["HeadersIterator", base_config_1$78.TYPE],
			["Headers", base_config_1$78.TYPE],
			["Highlight", base_config_1$78.TYPE],
			["HighlightRegistry", base_config_1$78.TYPE],
			["IDBDatabase", base_config_1$78.TYPE],
			["IDBObjectStore", base_config_1$78.TYPE],
			["ImageTrackList", base_config_1$78.TYPE],
			["MIDIInputMap", base_config_1$78.TYPE],
			["MIDIOutput", base_config_1$78.TYPE],
			["MIDIOutputMap", base_config_1$78.TYPE],
			["MediaKeyStatusMapIterator", base_config_1$78.TYPE],
			["MediaKeyStatusMap", base_config_1$78.TYPE],
			["MediaList", base_config_1$78.TYPE],
			["MessageEvent", base_config_1$78.TYPE],
			["MimeTypeArray", base_config_1$78.TYPE],
			["NamedNodeMap", base_config_1$78.TYPE],
			["Navigator", base_config_1$78.TYPE],
			["NodeList", base_config_1$78.TYPE],
			["NodeListOf", base_config_1$78.TYPE],
			["Plugin", base_config_1$78.TYPE],
			["PluginArray", base_config_1$78.TYPE],
			["RTCRtpTransceiver", base_config_1$78.TYPE],
			["RTCStatsReport", base_config_1$78.TYPE],
			["SVGLengthList", base_config_1$78.TYPE],
			["SVGNumberList", base_config_1$78.TYPE],
			["SVGPointList", base_config_1$78.TYPE],
			["SVGStringList", base_config_1$78.TYPE],
			["SVGTransformList", base_config_1$78.TYPE],
			["SourceBufferList", base_config_1$78.TYPE],
			["SpeechRecognitionResult", base_config_1$78.TYPE],
			["SpeechRecognitionResultList", base_config_1$78.TYPE],
			["StylePropertyMapReadOnlyIterator", base_config_1$78.TYPE],
			["StylePropertyMapReadOnly", base_config_1$78.TYPE],
			["StyleSheetList", base_config_1$78.TYPE],
			["SubtleCrypto", base_config_1$78.TYPE],
			["TextTrackCueList", base_config_1$78.TYPE],
			["TextTrackList", base_config_1$78.TYPE],
			["TouchList", base_config_1$78.TYPE],
			["URLSearchParamsIterator", base_config_1$78.TYPE],
			["URLSearchParams", base_config_1$78.TYPE],
			["ViewTransitionTypeSet", base_config_1$78.TYPE],
			["WEBGL_draw_buffers", base_config_1$78.TYPE],
			["WEBGL_multi_draw", base_config_1$78.TYPE],
			["WebGL2RenderingContextBase", base_config_1$78.TYPE],
			["WebGL2RenderingContextOverloads", base_config_1$78.TYPE],
			["WebGLRenderingContextBase", base_config_1$78.TYPE],
			["WebGLRenderingContextOverloads", base_config_1$78.TYPE]
		]
	};
})), require_es5 = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es5 = void 0;
	let base_config_1$77 = require_base_config(), decorators_1$2 = require_decorators(), decorators_legacy_1$1 = require_decorators_legacy();
	exports.es5 = {
		libs: [decorators_1$2.decorators, decorators_legacy_1$1.decorators_legacy],
		variables: [
			["Symbol", base_config_1$77.TYPE],
			["PropertyKey", base_config_1$77.TYPE],
			["PropertyDescriptor", base_config_1$77.TYPE],
			["PropertyDescriptorMap", base_config_1$77.TYPE],
			["Object", base_config_1$77.TYPE_VALUE],
			["ObjectConstructor", base_config_1$77.TYPE],
			["Function", base_config_1$77.TYPE_VALUE],
			["FunctionConstructor", base_config_1$77.TYPE],
			["ThisParameterType", base_config_1$77.TYPE],
			["OmitThisParameter", base_config_1$77.TYPE],
			["CallableFunction", base_config_1$77.TYPE],
			["NewableFunction", base_config_1$77.TYPE],
			["IArguments", base_config_1$77.TYPE],
			["String", base_config_1$77.TYPE_VALUE],
			["StringConstructor", base_config_1$77.TYPE],
			["Boolean", base_config_1$77.TYPE_VALUE],
			["BooleanConstructor", base_config_1$77.TYPE],
			["Number", base_config_1$77.TYPE_VALUE],
			["NumberConstructor", base_config_1$77.TYPE],
			["TemplateStringsArray", base_config_1$77.TYPE],
			["ImportMeta", base_config_1$77.TYPE],
			["ImportCallOptions", base_config_1$77.TYPE],
			["ImportAssertions", base_config_1$77.TYPE],
			["ImportAttributes", base_config_1$77.TYPE],
			["Math", base_config_1$77.TYPE_VALUE],
			["Date", base_config_1$77.TYPE_VALUE],
			["DateConstructor", base_config_1$77.TYPE],
			["RegExpMatchArray", base_config_1$77.TYPE],
			["RegExpExecArray", base_config_1$77.TYPE],
			["RegExp", base_config_1$77.TYPE_VALUE],
			["RegExpConstructor", base_config_1$77.TYPE],
			["Error", base_config_1$77.TYPE_VALUE],
			["ErrorConstructor", base_config_1$77.TYPE],
			["EvalError", base_config_1$77.TYPE_VALUE],
			["EvalErrorConstructor", base_config_1$77.TYPE],
			["RangeError", base_config_1$77.TYPE_VALUE],
			["RangeErrorConstructor", base_config_1$77.TYPE],
			["ReferenceError", base_config_1$77.TYPE_VALUE],
			["ReferenceErrorConstructor", base_config_1$77.TYPE],
			["SyntaxError", base_config_1$77.TYPE_VALUE],
			["SyntaxErrorConstructor", base_config_1$77.TYPE],
			["TypeError", base_config_1$77.TYPE_VALUE],
			["TypeErrorConstructor", base_config_1$77.TYPE],
			["URIError", base_config_1$77.TYPE_VALUE],
			["URIErrorConstructor", base_config_1$77.TYPE],
			["JSON", base_config_1$77.TYPE_VALUE],
			["ReadonlyArray", base_config_1$77.TYPE],
			["ConcatArray", base_config_1$77.TYPE],
			["Array", base_config_1$77.TYPE_VALUE],
			["ArrayConstructor", base_config_1$77.TYPE],
			["TypedPropertyDescriptor", base_config_1$77.TYPE],
			["PromiseConstructorLike", base_config_1$77.TYPE],
			["PromiseLike", base_config_1$77.TYPE],
			["Promise", base_config_1$77.TYPE],
			["Awaited", base_config_1$77.TYPE],
			["ArrayLike", base_config_1$77.TYPE],
			["Partial", base_config_1$77.TYPE],
			["Required", base_config_1$77.TYPE],
			["Readonly", base_config_1$77.TYPE],
			["Pick", base_config_1$77.TYPE],
			["Record", base_config_1$77.TYPE],
			["Exclude", base_config_1$77.TYPE],
			["Extract", base_config_1$77.TYPE],
			["Omit", base_config_1$77.TYPE],
			["NonNullable", base_config_1$77.TYPE],
			["Parameters", base_config_1$77.TYPE],
			["ConstructorParameters", base_config_1$77.TYPE],
			["ReturnType", base_config_1$77.TYPE],
			["InstanceType", base_config_1$77.TYPE],
			["Uppercase", base_config_1$77.TYPE],
			["Lowercase", base_config_1$77.TYPE],
			["Capitalize", base_config_1$77.TYPE],
			["Uncapitalize", base_config_1$77.TYPE],
			["NoInfer", base_config_1$77.TYPE],
			["ThisType", base_config_1$77.TYPE],
			["WeakKeyTypes", base_config_1$77.TYPE],
			["WeakKey", base_config_1$77.TYPE],
			["ArrayBuffer", base_config_1$77.TYPE_VALUE],
			["ArrayBufferTypes", base_config_1$77.TYPE],
			["ArrayBufferLike", base_config_1$77.TYPE],
			["ArrayBufferConstructor", base_config_1$77.TYPE],
			["ArrayBufferView", base_config_1$77.TYPE],
			["DataView", base_config_1$77.TYPE_VALUE],
			["DataViewConstructor", base_config_1$77.TYPE],
			["Int8Array", base_config_1$77.TYPE_VALUE],
			["Int8ArrayConstructor", base_config_1$77.TYPE],
			["Uint8Array", base_config_1$77.TYPE_VALUE],
			["Uint8ArrayConstructor", base_config_1$77.TYPE],
			["Uint8ClampedArray", base_config_1$77.TYPE_VALUE],
			["Uint8ClampedArrayConstructor", base_config_1$77.TYPE],
			["Int16Array", base_config_1$77.TYPE_VALUE],
			["Int16ArrayConstructor", base_config_1$77.TYPE],
			["Uint16Array", base_config_1$77.TYPE_VALUE],
			["Uint16ArrayConstructor", base_config_1$77.TYPE],
			["Int32Array", base_config_1$77.TYPE_VALUE],
			["Int32ArrayConstructor", base_config_1$77.TYPE],
			["Uint32Array", base_config_1$77.TYPE_VALUE],
			["Uint32ArrayConstructor", base_config_1$77.TYPE],
			["Float32Array", base_config_1$77.TYPE_VALUE],
			["Float32ArrayConstructor", base_config_1$77.TYPE],
			["Float64Array", base_config_1$77.TYPE_VALUE],
			["Float64ArrayConstructor", base_config_1$77.TYPE],
			["Intl", base_config_1$77.TYPE_VALUE]
		]
	};
})), require_es2015_collection = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2015_collection = void 0;
	let base_config_1$76 = require_base_config();
	exports.es2015_collection = {
		libs: [],
		variables: [
			["Map", base_config_1$76.TYPE_VALUE],
			["MapConstructor", base_config_1$76.TYPE],
			["ReadonlyMap", base_config_1$76.TYPE],
			["WeakMap", base_config_1$76.TYPE_VALUE],
			["WeakMapConstructor", base_config_1$76.TYPE],
			["Set", base_config_1$76.TYPE_VALUE],
			["SetConstructor", base_config_1$76.TYPE],
			["ReadonlySet", base_config_1$76.TYPE],
			["WeakSet", base_config_1$76.TYPE_VALUE],
			["WeakSetConstructor", base_config_1$76.TYPE]
		]
	};
})), require_es2015_core = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2015_core = void 0;
	let base_config_1$75 = require_base_config();
	exports.es2015_core = {
		libs: [],
		variables: [
			["Array", base_config_1$75.TYPE],
			["ArrayConstructor", base_config_1$75.TYPE],
			["DateConstructor", base_config_1$75.TYPE],
			["Function", base_config_1$75.TYPE],
			["Math", base_config_1$75.TYPE],
			["NumberConstructor", base_config_1$75.TYPE],
			["ObjectConstructor", base_config_1$75.TYPE],
			["ReadonlyArray", base_config_1$75.TYPE],
			["RegExp", base_config_1$75.TYPE],
			["RegExpConstructor", base_config_1$75.TYPE],
			["String", base_config_1$75.TYPE],
			["StringConstructor", base_config_1$75.TYPE],
			["Int8Array", base_config_1$75.TYPE],
			["Uint8Array", base_config_1$75.TYPE],
			["Uint8ClampedArray", base_config_1$75.TYPE],
			["Int16Array", base_config_1$75.TYPE],
			["Uint16Array", base_config_1$75.TYPE],
			["Int32Array", base_config_1$75.TYPE],
			["Uint32Array", base_config_1$75.TYPE],
			["Float32Array", base_config_1$75.TYPE],
			["Float64Array", base_config_1$75.TYPE]
		]
	};
})), require_es2015_symbol = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2015_symbol = void 0, exports.es2015_symbol = {
		libs: [],
		variables: [["SymbolConstructor", require_base_config().TYPE]]
	};
})), require_es2015_iterable = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2015_iterable = void 0;
	let base_config_1$73 = require_base_config();
	exports.es2015_iterable = {
		libs: [require_es2015_symbol().es2015_symbol],
		variables: [
			["SymbolConstructor", base_config_1$73.TYPE],
			["IteratorYieldResult", base_config_1$73.TYPE],
			["IteratorReturnResult", base_config_1$73.TYPE],
			["IteratorResult", base_config_1$73.TYPE],
			["Iterator", base_config_1$73.TYPE],
			["Iterable", base_config_1$73.TYPE],
			["IterableIterator", base_config_1$73.TYPE],
			["IteratorObject", base_config_1$73.TYPE],
			["BuiltinIteratorReturn", base_config_1$73.TYPE],
			["ArrayIterator", base_config_1$73.TYPE],
			["Array", base_config_1$73.TYPE],
			["ArrayConstructor", base_config_1$73.TYPE],
			["ReadonlyArray", base_config_1$73.TYPE],
			["IArguments", base_config_1$73.TYPE],
			["MapIterator", base_config_1$73.TYPE],
			["Map", base_config_1$73.TYPE],
			["ReadonlyMap", base_config_1$73.TYPE],
			["MapConstructor", base_config_1$73.TYPE],
			["WeakMap", base_config_1$73.TYPE],
			["WeakMapConstructor", base_config_1$73.TYPE],
			["SetIterator", base_config_1$73.TYPE],
			["Set", base_config_1$73.TYPE],
			["ReadonlySet", base_config_1$73.TYPE],
			["SetConstructor", base_config_1$73.TYPE],
			["WeakSet", base_config_1$73.TYPE],
			["WeakSetConstructor", base_config_1$73.TYPE],
			["Promise", base_config_1$73.TYPE],
			["PromiseConstructor", base_config_1$73.TYPE],
			["StringIterator", base_config_1$73.TYPE],
			["String", base_config_1$73.TYPE],
			["Int8Array", base_config_1$73.TYPE],
			["Int8ArrayConstructor", base_config_1$73.TYPE],
			["Uint8Array", base_config_1$73.TYPE],
			["Uint8ArrayConstructor", base_config_1$73.TYPE],
			["Uint8ClampedArray", base_config_1$73.TYPE],
			["Uint8ClampedArrayConstructor", base_config_1$73.TYPE],
			["Int16Array", base_config_1$73.TYPE],
			["Int16ArrayConstructor", base_config_1$73.TYPE],
			["Uint16Array", base_config_1$73.TYPE],
			["Uint16ArrayConstructor", base_config_1$73.TYPE],
			["Int32Array", base_config_1$73.TYPE],
			["Int32ArrayConstructor", base_config_1$73.TYPE],
			["Uint32Array", base_config_1$73.TYPE],
			["Uint32ArrayConstructor", base_config_1$73.TYPE],
			["Float32Array", base_config_1$73.TYPE],
			["Float32ArrayConstructor", base_config_1$73.TYPE],
			["Float64Array", base_config_1$73.TYPE],
			["Float64ArrayConstructor", base_config_1$73.TYPE]
		]
	};
})), require_es2015_generator = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2015_generator = void 0;
	let base_config_1$72 = require_base_config();
	exports.es2015_generator = {
		libs: [require_es2015_iterable().es2015_iterable],
		variables: [
			["Generator", base_config_1$72.TYPE],
			["GeneratorFunction", base_config_1$72.TYPE],
			["GeneratorFunctionConstructor", base_config_1$72.TYPE]
		]
	};
})), require_es2015_promise = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2015_promise = void 0, exports.es2015_promise = {
		libs: [],
		variables: [["PromiseConstructor", require_base_config().TYPE]]
	};
})), require_es2015_proxy = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2015_proxy = void 0;
	let base_config_1$70 = require_base_config();
	exports.es2015_proxy = {
		libs: [],
		variables: [["ProxyHandler", base_config_1$70.TYPE], ["ProxyConstructor", base_config_1$70.TYPE]]
	};
})), require_es2015_reflect = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2015_reflect = void 0, exports.es2015_reflect = {
		libs: [],
		variables: [["Reflect", require_base_config().TYPE_VALUE]]
	};
})), require_es2015_symbol_wellknown = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2015_symbol_wellknown = void 0;
	let base_config_1$68 = require_base_config();
	exports.es2015_symbol_wellknown = {
		libs: [require_es2015_symbol().es2015_symbol],
		variables: [
			["SymbolConstructor", base_config_1$68.TYPE],
			["Symbol", base_config_1$68.TYPE],
			["Array", base_config_1$68.TYPE],
			["ReadonlyArray", base_config_1$68.TYPE],
			["Date", base_config_1$68.TYPE],
			["Map", base_config_1$68.TYPE],
			["WeakMap", base_config_1$68.TYPE],
			["Set", base_config_1$68.TYPE],
			["WeakSet", base_config_1$68.TYPE],
			["JSON", base_config_1$68.TYPE],
			["Function", base_config_1$68.TYPE],
			["GeneratorFunction", base_config_1$68.TYPE],
			["Math", base_config_1$68.TYPE],
			["Promise", base_config_1$68.TYPE],
			["PromiseConstructor", base_config_1$68.TYPE],
			["RegExp", base_config_1$68.TYPE],
			["RegExpConstructor", base_config_1$68.TYPE],
			["String", base_config_1$68.TYPE],
			["ArrayBuffer", base_config_1$68.TYPE],
			["DataView", base_config_1$68.TYPE],
			["Int8Array", base_config_1$68.TYPE],
			["Uint8Array", base_config_1$68.TYPE],
			["Uint8ClampedArray", base_config_1$68.TYPE],
			["Int16Array", base_config_1$68.TYPE],
			["Uint16Array", base_config_1$68.TYPE],
			["Int32Array", base_config_1$68.TYPE],
			["Uint32Array", base_config_1$68.TYPE],
			["Float32Array", base_config_1$68.TYPE],
			["Float64Array", base_config_1$68.TYPE],
			["ArrayConstructor", base_config_1$68.TYPE],
			["MapConstructor", base_config_1$68.TYPE],
			["SetConstructor", base_config_1$68.TYPE],
			["ArrayBufferConstructor", base_config_1$68.TYPE]
		]
	};
})), require_es6 = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es6 = void 0;
	let es5_1$3 = require_es5(), es2015_collection_1$2 = require_es2015_collection(), es2015_core_1$2 = require_es2015_core(), es2015_generator_1$2 = require_es2015_generator(), es2015_iterable_1$10 = require_es2015_iterable(), es2015_promise_1$2 = require_es2015_promise(), es2015_proxy_1$2 = require_es2015_proxy(), es2015_reflect_1$2 = require_es2015_reflect(), es2015_symbol_1$9 = require_es2015_symbol(), es2015_symbol_wellknown_1$5 = require_es2015_symbol_wellknown();
	exports.es6 = {
		libs: [
			es5_1$3.es5,
			es2015_core_1$2.es2015_core,
			es2015_collection_1$2.es2015_collection,
			es2015_iterable_1$10.es2015_iterable,
			es2015_generator_1$2.es2015_generator,
			es2015_promise_1$2.es2015_promise,
			es2015_proxy_1$2.es2015_proxy,
			es2015_reflect_1$2.es2015_reflect,
			es2015_symbol_1$9.es2015_symbol,
			es2015_symbol_wellknown_1$5.es2015_symbol_wellknown
		],
		variables: []
	};
})), require_es2015 = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2015 = void 0;
	let es5_1$2 = require_es5(), es2015_collection_1$1 = require_es2015_collection(), es2015_core_1$1 = require_es2015_core(), es2015_generator_1$1 = require_es2015_generator(), es2015_iterable_1$9 = require_es2015_iterable(), es2015_promise_1$1 = require_es2015_promise(), es2015_proxy_1$1 = require_es2015_proxy(), es2015_reflect_1$1 = require_es2015_reflect(), es2015_symbol_1$8 = require_es2015_symbol(), es2015_symbol_wellknown_1$4 = require_es2015_symbol_wellknown();
	exports.es2015 = {
		libs: [
			es5_1$2.es5,
			es2015_core_1$1.es2015_core,
			es2015_collection_1$1.es2015_collection,
			es2015_iterable_1$9.es2015_iterable,
			es2015_generator_1$1.es2015_generator,
			es2015_promise_1$1.es2015_promise,
			es2015_proxy_1$1.es2015_proxy,
			es2015_reflect_1$1.es2015_reflect,
			es2015_symbol_1$8.es2015_symbol,
			es2015_symbol_wellknown_1$4.es2015_symbol_wellknown
		],
		variables: []
	};
})), require_es2016_array_include = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2016_array_include = void 0;
	let base_config_1$67 = require_base_config();
	exports.es2016_array_include = {
		libs: [],
		variables: [
			["Array", base_config_1$67.TYPE],
			["ReadonlyArray", base_config_1$67.TYPE],
			["Int8Array", base_config_1$67.TYPE],
			["Uint8Array", base_config_1$67.TYPE],
			["Uint8ClampedArray", base_config_1$67.TYPE],
			["Int16Array", base_config_1$67.TYPE],
			["Uint16Array", base_config_1$67.TYPE],
			["Int32Array", base_config_1$67.TYPE],
			["Uint32Array", base_config_1$67.TYPE],
			["Float32Array", base_config_1$67.TYPE],
			["Float64Array", base_config_1$67.TYPE]
		]
	};
})), require_es2016_intl = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2016_intl = void 0, exports.es2016_intl = {
		libs: [],
		variables: [["Intl", require_base_config().TYPE_VALUE]]
	};
})), require_es7 = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es7 = void 0;
	let es2015_1$2 = require_es2015(), es2016_array_include_1$2 = require_es2016_array_include(), es2016_intl_1$2 = require_es2016_intl();
	exports.es7 = {
		libs: [
			es2015_1$2.es2015,
			es2016_array_include_1$2.es2016_array_include,
			es2016_intl_1$2.es2016_intl
		],
		variables: []
	};
})), require_es2016 = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2016 = void 0;
	let es2015_1$1 = require_es2015(), es2016_array_include_1$1 = require_es2016_array_include(), es2016_intl_1$1 = require_es2016_intl();
	exports.es2016 = {
		libs: [
			es2015_1$1.es2015,
			es2016_array_include_1$1.es2016_array_include,
			es2016_intl_1$1.es2016_intl
		],
		variables: []
	};
})), require_scripthost = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.scripthost = void 0;
	let base_config_1$65 = require_base_config();
	exports.scripthost = {
		libs: [],
		variables: [
			["ActiveXObject", base_config_1$65.TYPE_VALUE],
			["ITextWriter", base_config_1$65.TYPE],
			["TextStreamBase", base_config_1$65.TYPE],
			["TextStreamWriter", base_config_1$65.TYPE],
			["TextStreamReader", base_config_1$65.TYPE],
			["SafeArray", base_config_1$65.TYPE_VALUE],
			["Enumerator", base_config_1$65.TYPE_VALUE],
			["EnumeratorConstructor", base_config_1$65.TYPE],
			["VBArray", base_config_1$65.TYPE_VALUE],
			["VBArrayConstructor", base_config_1$65.TYPE],
			["VarDate", base_config_1$65.TYPE_VALUE],
			["DateConstructor", base_config_1$65.TYPE],
			["Date", base_config_1$65.TYPE]
		]
	};
})), require_webworker_importscripts = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.webworker_importscripts = void 0, exports.webworker_importscripts = {
		libs: [],
		variables: []
	};
})), require_es2016_full = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2016_full = void 0;
	let dom_1$11 = require_dom(), dom_iterable_1$10 = require_dom_iterable(), es2016_1$2 = require_es2016(), scripthost_1$11 = require_scripthost(), webworker_importscripts_1$11 = require_webworker_importscripts();
	exports.es2016_full = {
		libs: [
			es2016_1$2.es2016,
			dom_1$11.dom,
			webworker_importscripts_1$11.webworker_importscripts,
			scripthost_1$11.scripthost,
			dom_iterable_1$10.dom_iterable
		],
		variables: []
	};
})), require_es2017_arraybuffer = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2017_arraybuffer = void 0, exports.es2017_arraybuffer = {
		libs: [],
		variables: [["ArrayBufferConstructor", require_base_config().TYPE]]
	};
})), require_es2017_date = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2017_date = void 0, exports.es2017_date = {
		libs: [],
		variables: [["DateConstructor", require_base_config().TYPE]]
	};
})), require_es2017_intl = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2017_intl = void 0, exports.es2017_intl = {
		libs: [],
		variables: [["Intl", require_base_config().TYPE_VALUE]]
	};
})), require_es2017_object = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2017_object = void 0, exports.es2017_object = {
		libs: [],
		variables: [["ObjectConstructor", require_base_config().TYPE]]
	};
})), require_es2017_sharedmemory = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2017_sharedmemory = void 0;
	let base_config_1$60 = require_base_config(), es2015_symbol_1$7 = require_es2015_symbol(), es2015_symbol_wellknown_1$3 = require_es2015_symbol_wellknown();
	exports.es2017_sharedmemory = {
		libs: [es2015_symbol_1$7.es2015_symbol, es2015_symbol_wellknown_1$3.es2015_symbol_wellknown],
		variables: [
			["SharedArrayBuffer", base_config_1$60.TYPE_VALUE],
			["SharedArrayBufferConstructor", base_config_1$60.TYPE],
			["ArrayBufferTypes", base_config_1$60.TYPE],
			["Atomics", base_config_1$60.TYPE_VALUE]
		]
	};
})), require_es2017_string = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2017_string = void 0, exports.es2017_string = {
		libs: [],
		variables: [["String", require_base_config().TYPE]]
	};
})), require_es2017_typedarrays = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2017_typedarrays = void 0;
	let base_config_1$58 = require_base_config();
	exports.es2017_typedarrays = {
		libs: [],
		variables: [
			["Int8ArrayConstructor", base_config_1$58.TYPE],
			["Uint8ArrayConstructor", base_config_1$58.TYPE],
			["Uint8ClampedArrayConstructor", base_config_1$58.TYPE],
			["Int16ArrayConstructor", base_config_1$58.TYPE],
			["Uint16ArrayConstructor", base_config_1$58.TYPE],
			["Int32ArrayConstructor", base_config_1$58.TYPE],
			["Uint32ArrayConstructor", base_config_1$58.TYPE],
			["Float32ArrayConstructor", base_config_1$58.TYPE],
			["Float64ArrayConstructor", base_config_1$58.TYPE]
		]
	};
})), require_es2017 = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2017 = void 0;
	let es2016_1$1 = require_es2016(), es2017_arraybuffer_1$1 = require_es2017_arraybuffer(), es2017_date_1$1 = require_es2017_date(), es2017_intl_1$1 = require_es2017_intl(), es2017_object_1$1 = require_es2017_object(), es2017_sharedmemory_1$1 = require_es2017_sharedmemory(), es2017_string_1$1 = require_es2017_string(), es2017_typedarrays_1$1 = require_es2017_typedarrays();
	exports.es2017 = {
		libs: [
			es2016_1$1.es2016,
			es2017_arraybuffer_1$1.es2017_arraybuffer,
			es2017_date_1$1.es2017_date,
			es2017_intl_1$1.es2017_intl,
			es2017_object_1$1.es2017_object,
			es2017_sharedmemory_1$1.es2017_sharedmemory,
			es2017_string_1$1.es2017_string,
			es2017_typedarrays_1$1.es2017_typedarrays
		],
		variables: []
	};
})), require_es2017_full = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2017_full = void 0;
	let dom_1$10 = require_dom(), dom_iterable_1$9 = require_dom_iterable(), es2017_1$2 = require_es2017(), scripthost_1$10 = require_scripthost(), webworker_importscripts_1$10 = require_webworker_importscripts();
	exports.es2017_full = {
		libs: [
			es2017_1$2.es2017,
			dom_1$10.dom,
			webworker_importscripts_1$10.webworker_importscripts,
			scripthost_1$10.scripthost,
			dom_iterable_1$9.dom_iterable
		],
		variables: []
	};
})), require_es2018_asynciterable = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2018_asynciterable = void 0;
	let base_config_1$57 = require_base_config(), es2015_iterable_1$8 = require_es2015_iterable();
	exports.es2018_asynciterable = {
		libs: [require_es2015_symbol().es2015_symbol, es2015_iterable_1$8.es2015_iterable],
		variables: [
			["SymbolConstructor", base_config_1$57.TYPE],
			["AsyncIterator", base_config_1$57.TYPE],
			["AsyncIterable", base_config_1$57.TYPE],
			["AsyncIterableIterator", base_config_1$57.TYPE],
			["AsyncIteratorObject", base_config_1$57.TYPE]
		]
	};
})), require_es2018_asyncgenerator = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2018_asyncgenerator = void 0;
	let base_config_1$56 = require_base_config();
	exports.es2018_asyncgenerator = {
		libs: [require_es2018_asynciterable().es2018_asynciterable],
		variables: [
			["AsyncGenerator", base_config_1$56.TYPE],
			["AsyncGeneratorFunction", base_config_1$56.TYPE],
			["AsyncGeneratorFunctionConstructor", base_config_1$56.TYPE]
		]
	};
})), require_es2018_intl = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2018_intl = void 0, exports.es2018_intl = {
		libs: [],
		variables: [["Intl", require_base_config().TYPE_VALUE]]
	};
})), require_es2018_promise = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2018_promise = void 0, exports.es2018_promise = {
		libs: [],
		variables: [["Promise", require_base_config().TYPE]]
	};
})), require_es2018_regexp = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2018_regexp = void 0;
	let base_config_1$53 = require_base_config();
	exports.es2018_regexp = {
		libs: [],
		variables: [
			["RegExpMatchArray", base_config_1$53.TYPE],
			["RegExpExecArray", base_config_1$53.TYPE],
			["RegExp", base_config_1$53.TYPE]
		]
	};
})), require_es2018 = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2018 = void 0;
	let es2017_1$1 = require_es2017(), es2018_asyncgenerator_1$1 = require_es2018_asyncgenerator(), es2018_asynciterable_1$2 = require_es2018_asynciterable(), es2018_intl_1$2 = require_es2018_intl(), es2018_promise_1$1 = require_es2018_promise(), es2018_regexp_1$1 = require_es2018_regexp();
	exports.es2018 = {
		libs: [
			es2017_1$1.es2017,
			es2018_asynciterable_1$2.es2018_asynciterable,
			es2018_asyncgenerator_1$1.es2018_asyncgenerator,
			es2018_promise_1$1.es2018_promise,
			es2018_regexp_1$1.es2018_regexp,
			es2018_intl_1$2.es2018_intl
		],
		variables: []
	};
})), require_es2018_full = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2018_full = void 0;
	let dom_1$9 = require_dom(), dom_asynciterable_1$8 = require_dom_asynciterable(), dom_iterable_1$8 = require_dom_iterable(), es2018_1$2 = require_es2018(), scripthost_1$9 = require_scripthost(), webworker_importscripts_1$9 = require_webworker_importscripts();
	exports.es2018_full = {
		libs: [
			es2018_1$2.es2018,
			dom_1$9.dom,
			webworker_importscripts_1$9.webworker_importscripts,
			scripthost_1$9.scripthost,
			dom_iterable_1$8.dom_iterable,
			dom_asynciterable_1$8.dom_asynciterable
		],
		variables: []
	};
})), require_es2019_array = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2019_array = void 0;
	let base_config_1$52 = require_base_config();
	exports.es2019_array = {
		libs: [],
		variables: [
			["FlatArray", base_config_1$52.TYPE],
			["ReadonlyArray", base_config_1$52.TYPE],
			["Array", base_config_1$52.TYPE]
		]
	};
})), require_es2019_intl = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2019_intl = void 0, exports.es2019_intl = {
		libs: [],
		variables: [["Intl", require_base_config().TYPE_VALUE]]
	};
})), require_es2019_object = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2019_object = void 0;
	let base_config_1$50 = require_base_config();
	exports.es2019_object = {
		libs: [require_es2015_iterable().es2015_iterable],
		variables: [["ObjectConstructor", base_config_1$50.TYPE]]
	};
})), require_es2019_string = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2019_string = void 0, exports.es2019_string = {
		libs: [],
		variables: [["String", require_base_config().TYPE]]
	};
})), require_es2019_symbol = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2019_symbol = void 0, exports.es2019_symbol = {
		libs: [],
		variables: [["Symbol", require_base_config().TYPE]]
	};
})), require_es2019 = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2019 = void 0;
	let es2018_1$1 = require_es2018(), es2019_array_1$1 = require_es2019_array(), es2019_intl_1$1 = require_es2019_intl(), es2019_object_1$1 = require_es2019_object(), es2019_string_1$1 = require_es2019_string(), es2019_symbol_1$1 = require_es2019_symbol();
	exports.es2019 = {
		libs: [
			es2018_1$1.es2018,
			es2019_array_1$1.es2019_array,
			es2019_object_1$1.es2019_object,
			es2019_string_1$1.es2019_string,
			es2019_symbol_1$1.es2019_symbol,
			es2019_intl_1$1.es2019_intl
		],
		variables: []
	};
})), require_es2019_full = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2019_full = void 0;
	let dom_1$8 = require_dom(), dom_asynciterable_1$7 = require_dom_asynciterable(), dom_iterable_1$7 = require_dom_iterable(), es2019_1$2 = require_es2019(), scripthost_1$8 = require_scripthost(), webworker_importscripts_1$8 = require_webworker_importscripts();
	exports.es2019_full = {
		libs: [
			es2019_1$2.es2019,
			dom_1$8.dom,
			webworker_importscripts_1$8.webworker_importscripts,
			scripthost_1$8.scripthost,
			dom_iterable_1$7.dom_iterable,
			dom_asynciterable_1$7.dom_asynciterable
		],
		variables: []
	};
})), require_es2020_intl = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2020_intl = void 0;
	let base_config_1$47 = require_base_config();
	exports.es2020_intl = {
		libs: [require_es2018_intl().es2018_intl],
		variables: [["Intl", base_config_1$47.TYPE_VALUE]]
	};
})), require_es2020_bigint = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2020_bigint = void 0;
	let base_config_1$46 = require_base_config();
	exports.es2020_bigint = {
		libs: [require_es2020_intl().es2020_intl],
		variables: [
			["BigIntToLocaleStringOptions", base_config_1$46.TYPE],
			["BigInt", base_config_1$46.TYPE_VALUE],
			["BigIntConstructor", base_config_1$46.TYPE],
			["BigInt64Array", base_config_1$46.TYPE_VALUE],
			["BigInt64ArrayConstructor", base_config_1$46.TYPE],
			["BigUint64Array", base_config_1$46.TYPE_VALUE],
			["BigUint64ArrayConstructor", base_config_1$46.TYPE],
			["DataView", base_config_1$46.TYPE],
			["Intl", base_config_1$46.TYPE_VALUE]
		]
	};
})), require_es2020_date = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2020_date = void 0;
	let base_config_1$45 = require_base_config();
	exports.es2020_date = {
		libs: [require_es2020_intl().es2020_intl],
		variables: [["Date", base_config_1$45.TYPE]]
	};
})), require_es2020_number = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2020_number = void 0;
	let base_config_1$44 = require_base_config();
	exports.es2020_number = {
		libs: [require_es2020_intl().es2020_intl],
		variables: [["Number", base_config_1$44.TYPE]]
	};
})), require_es2020_promise = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2020_promise = void 0;
	let base_config_1$43 = require_base_config();
	exports.es2020_promise = {
		libs: [],
		variables: [
			["PromiseFulfilledResult", base_config_1$43.TYPE],
			["PromiseRejectedResult", base_config_1$43.TYPE],
			["PromiseSettledResult", base_config_1$43.TYPE],
			["PromiseConstructor", base_config_1$43.TYPE]
		]
	};
})), require_es2020_sharedmemory = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2020_sharedmemory = void 0;
	let base_config_1$42 = require_base_config();
	exports.es2020_sharedmemory = {
		libs: [require_es2020_bigint().es2020_bigint],
		variables: [["Atomics", base_config_1$42.TYPE]]
	};
})), require_es2020_symbol_wellknown = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2020_symbol_wellknown = void 0;
	let base_config_1$41 = require_base_config(), es2015_iterable_1$6 = require_es2015_iterable(), es2015_symbol_1$5 = require_es2015_symbol();
	exports.es2020_symbol_wellknown = {
		libs: [es2015_iterable_1$6.es2015_iterable, es2015_symbol_1$5.es2015_symbol],
		variables: [
			["SymbolConstructor", base_config_1$41.TYPE],
			["RegExpStringIterator", base_config_1$41.TYPE],
			["RegExp", base_config_1$41.TYPE]
		]
	};
})), require_es2020_string = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2020_string = void 0;
	let base_config_1$40 = require_base_config(), es2015_iterable_1$5 = require_es2015_iterable(), es2020_intl_1$3 = require_es2020_intl(), es2020_symbol_wellknown_1$2 = require_es2020_symbol_wellknown();
	exports.es2020_string = {
		libs: [
			es2015_iterable_1$5.es2015_iterable,
			es2020_intl_1$3.es2020_intl,
			es2020_symbol_wellknown_1$2.es2020_symbol_wellknown
		],
		variables: [["String", base_config_1$40.TYPE]]
	};
})), require_es2020 = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2020 = void 0;
	let es2019_1$1 = require_es2019(), es2020_bigint_1$2 = require_es2020_bigint(), es2020_date_1$1 = require_es2020_date(), es2020_intl_1$2 = require_es2020_intl(), es2020_number_1$1 = require_es2020_number(), es2020_promise_1$1 = require_es2020_promise(), es2020_sharedmemory_1$1 = require_es2020_sharedmemory(), es2020_string_1$1 = require_es2020_string(), es2020_symbol_wellknown_1$1 = require_es2020_symbol_wellknown();
	exports.es2020 = {
		libs: [
			es2019_1$1.es2019,
			es2020_bigint_1$2.es2020_bigint,
			es2020_date_1$1.es2020_date,
			es2020_number_1$1.es2020_number,
			es2020_promise_1$1.es2020_promise,
			es2020_sharedmemory_1$1.es2020_sharedmemory,
			es2020_string_1$1.es2020_string,
			es2020_symbol_wellknown_1$1.es2020_symbol_wellknown,
			es2020_intl_1$2.es2020_intl
		],
		variables: []
	};
})), require_es2020_full = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2020_full = void 0;
	let dom_1$7 = require_dom(), dom_asynciterable_1$6 = require_dom_asynciterable(), dom_iterable_1$6 = require_dom_iterable(), es2020_1$2 = require_es2020(), scripthost_1$7 = require_scripthost(), webworker_importscripts_1$7 = require_webworker_importscripts();
	exports.es2020_full = {
		libs: [
			es2020_1$2.es2020,
			dom_1$7.dom,
			webworker_importscripts_1$7.webworker_importscripts,
			scripthost_1$7.scripthost,
			dom_iterable_1$6.dom_iterable,
			dom_asynciterable_1$6.dom_asynciterable
		],
		variables: []
	};
})), require_es2021_intl = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2021_intl = void 0, exports.es2021_intl = {
		libs: [],
		variables: [["Intl", require_base_config().TYPE_VALUE]]
	};
})), require_es2021_promise = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2021_promise = void 0;
	let base_config_1$38 = require_base_config();
	exports.es2021_promise = {
		libs: [],
		variables: [
			["AggregateError", base_config_1$38.TYPE_VALUE],
			["AggregateErrorConstructor", base_config_1$38.TYPE],
			["PromiseConstructor", base_config_1$38.TYPE]
		]
	};
})), require_es2021_string = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2021_string = void 0, exports.es2021_string = {
		libs: [],
		variables: [["String", require_base_config().TYPE]]
	};
})), require_es2021_weakref = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2021_weakref = void 0;
	let base_config_1$36 = require_base_config();
	exports.es2021_weakref = {
		libs: [require_es2015_symbol_wellknown().es2015_symbol_wellknown],
		variables: [
			["WeakRef", base_config_1$36.TYPE_VALUE],
			["WeakRefConstructor", base_config_1$36.TYPE],
			["FinalizationRegistry", base_config_1$36.TYPE_VALUE],
			["FinalizationRegistryConstructor", base_config_1$36.TYPE]
		]
	};
})), require_es2021 = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2021 = void 0;
	let es2020_1$1 = require_es2020(), es2021_intl_1$1 = require_es2021_intl(), es2021_promise_1$2 = require_es2021_promise(), es2021_string_1$1 = require_es2021_string(), es2021_weakref_1$1 = require_es2021_weakref();
	exports.es2021 = {
		libs: [
			es2020_1$1.es2020,
			es2021_promise_1$2.es2021_promise,
			es2021_string_1$1.es2021_string,
			es2021_weakref_1$1.es2021_weakref,
			es2021_intl_1$1.es2021_intl
		],
		variables: []
	};
})), require_es2021_full = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2021_full = void 0;
	let dom_1$6 = require_dom(), dom_asynciterable_1$5 = require_dom_asynciterable(), dom_iterable_1$5 = require_dom_iterable(), es2021_1$2 = require_es2021(), scripthost_1$6 = require_scripthost(), webworker_importscripts_1$6 = require_webworker_importscripts();
	exports.es2021_full = {
		libs: [
			es2021_1$2.es2021,
			dom_1$6.dom,
			webworker_importscripts_1$6.webworker_importscripts,
			scripthost_1$6.scripthost,
			dom_iterable_1$5.dom_iterable,
			dom_asynciterable_1$5.dom_asynciterable
		],
		variables: []
	};
})), require_es2022_array = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2022_array = void 0;
	let base_config_1$35 = require_base_config();
	exports.es2022_array = {
		libs: [],
		variables: [
			["Array", base_config_1$35.TYPE],
			["ReadonlyArray", base_config_1$35.TYPE],
			["Int8Array", base_config_1$35.TYPE],
			["Uint8Array", base_config_1$35.TYPE],
			["Uint8ClampedArray", base_config_1$35.TYPE],
			["Int16Array", base_config_1$35.TYPE],
			["Uint16Array", base_config_1$35.TYPE],
			["Int32Array", base_config_1$35.TYPE],
			["Uint32Array", base_config_1$35.TYPE],
			["Float32Array", base_config_1$35.TYPE],
			["Float64Array", base_config_1$35.TYPE],
			["BigInt64Array", base_config_1$35.TYPE],
			["BigUint64Array", base_config_1$35.TYPE]
		]
	};
})), require_es2022_error = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2022_error = void 0;
	let base_config_1$34 = require_base_config();
	exports.es2022_error = {
		libs: [require_es2021_promise().es2021_promise],
		variables: [
			["ErrorOptions", base_config_1$34.TYPE],
			["Error", base_config_1$34.TYPE],
			["ErrorConstructor", base_config_1$34.TYPE],
			["EvalErrorConstructor", base_config_1$34.TYPE],
			["RangeErrorConstructor", base_config_1$34.TYPE],
			["ReferenceErrorConstructor", base_config_1$34.TYPE],
			["SyntaxErrorConstructor", base_config_1$34.TYPE],
			["TypeErrorConstructor", base_config_1$34.TYPE],
			["URIErrorConstructor", base_config_1$34.TYPE],
			["AggregateErrorConstructor", base_config_1$34.TYPE]
		]
	};
})), require_es2022_intl = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2022_intl = void 0, exports.es2022_intl = {
		libs: [],
		variables: [["Intl", require_base_config().TYPE_VALUE]]
	};
})), require_es2022_object = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2022_object = void 0, exports.es2022_object = {
		libs: [],
		variables: [["ObjectConstructor", require_base_config().TYPE]]
	};
})), require_es2022_regexp = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2022_regexp = void 0;
	let base_config_1$31 = require_base_config();
	exports.es2022_regexp = {
		libs: [],
		variables: [
			["RegExpMatchArray", base_config_1$31.TYPE],
			["RegExpExecArray", base_config_1$31.TYPE],
			["RegExpIndicesArray", base_config_1$31.TYPE],
			["RegExp", base_config_1$31.TYPE]
		]
	};
})), require_es2022_string = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2022_string = void 0, exports.es2022_string = {
		libs: [],
		variables: [["String", require_base_config().TYPE]]
	};
})), require_es2022 = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2022 = void 0;
	let es2021_1$1 = require_es2021(), es2022_array_1$1 = require_es2022_array(), es2022_error_1$1 = require_es2022_error(), es2022_intl_1$1 = require_es2022_intl(), es2022_object_1$1 = require_es2022_object(), es2022_regexp_1$1 = require_es2022_regexp(), es2022_string_1$1 = require_es2022_string();
	exports.es2022 = {
		libs: [
			es2021_1$1.es2021,
			es2022_array_1$1.es2022_array,
			es2022_error_1$1.es2022_error,
			es2022_intl_1$1.es2022_intl,
			es2022_object_1$1.es2022_object,
			es2022_regexp_1$1.es2022_regexp,
			es2022_string_1$1.es2022_string
		],
		variables: []
	};
})), require_es2022_full = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2022_full = void 0;
	let dom_1$5 = require_dom(), dom_asynciterable_1$4 = require_dom_asynciterable(), dom_iterable_1$4 = require_dom_iterable(), es2022_1$2 = require_es2022(), scripthost_1$5 = require_scripthost(), webworker_importscripts_1$5 = require_webworker_importscripts();
	exports.es2022_full = {
		libs: [
			es2022_1$2.es2022,
			dom_1$5.dom,
			webworker_importscripts_1$5.webworker_importscripts,
			scripthost_1$5.scripthost,
			dom_iterable_1$4.dom_iterable,
			dom_asynciterable_1$4.dom_asynciterable
		],
		variables: []
	};
})), require_es2023_array = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2023_array = void 0;
	let base_config_1$29 = require_base_config();
	exports.es2023_array = {
		libs: [],
		variables: [
			["Array", base_config_1$29.TYPE],
			["ReadonlyArray", base_config_1$29.TYPE],
			["Int8Array", base_config_1$29.TYPE],
			["Uint8Array", base_config_1$29.TYPE],
			["Uint8ClampedArray", base_config_1$29.TYPE],
			["Int16Array", base_config_1$29.TYPE],
			["Uint16Array", base_config_1$29.TYPE],
			["Int32Array", base_config_1$29.TYPE],
			["Uint32Array", base_config_1$29.TYPE],
			["Float32Array", base_config_1$29.TYPE],
			["Float64Array", base_config_1$29.TYPE],
			["BigInt64Array", base_config_1$29.TYPE],
			["BigUint64Array", base_config_1$29.TYPE]
		]
	};
})), require_es2023_collection = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2023_collection = void 0, exports.es2023_collection = {
		libs: [],
		variables: [["WeakKeyTypes", require_base_config().TYPE]]
	};
})), require_es2023_intl = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2023_intl = void 0, exports.es2023_intl = {
		libs: [],
		variables: [["Intl", require_base_config().TYPE_VALUE]]
	};
})), require_es2023 = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2023 = void 0;
	let es2022_1$1 = require_es2022(), es2023_array_1$1 = require_es2023_array(), es2023_collection_1$1 = require_es2023_collection(), es2023_intl_1$1 = require_es2023_intl();
	exports.es2023 = {
		libs: [
			es2022_1$1.es2022,
			es2023_array_1$1.es2023_array,
			es2023_collection_1$1.es2023_collection,
			es2023_intl_1$1.es2023_intl
		],
		variables: []
	};
})), require_es2023_full = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2023_full = void 0;
	let dom_1$4 = require_dom(), dom_asynciterable_1$3 = require_dom_asynciterable(), dom_iterable_1$3 = require_dom_iterable(), es2023_1$2 = require_es2023(), scripthost_1$4 = require_scripthost(), webworker_importscripts_1$4 = require_webworker_importscripts();
	exports.es2023_full = {
		libs: [
			es2023_1$2.es2023,
			dom_1$4.dom,
			webworker_importscripts_1$4.webworker_importscripts,
			scripthost_1$4.scripthost,
			dom_iterable_1$3.dom_iterable,
			dom_asynciterable_1$3.dom_asynciterable
		],
		variables: []
	};
})), require_es2024_arraybuffer = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2024_arraybuffer = void 0;
	let base_config_1$26 = require_base_config();
	exports.es2024_arraybuffer = {
		libs: [],
		variables: [["ArrayBuffer", base_config_1$26.TYPE], ["ArrayBufferConstructor", base_config_1$26.TYPE]]
	};
})), require_es2024_collection = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2024_collection = void 0, exports.es2024_collection = {
		libs: [],
		variables: [["MapConstructor", require_base_config().TYPE]]
	};
})), require_es2024_object = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2024_object = void 0, exports.es2024_object = {
		libs: [],
		variables: [["ObjectConstructor", require_base_config().TYPE]]
	};
})), require_es2024_promise = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2024_promise = void 0;
	let base_config_1$23 = require_base_config();
	exports.es2024_promise = {
		libs: [],
		variables: [["PromiseWithResolvers", base_config_1$23.TYPE], ["PromiseConstructor", base_config_1$23.TYPE]]
	};
})), require_es2024_regexp = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2024_regexp = void 0, exports.es2024_regexp = {
		libs: [],
		variables: [["RegExp", require_base_config().TYPE]]
	};
})), require_es2024_sharedmemory = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2024_sharedmemory = void 0;
	let base_config_1$21 = require_base_config();
	exports.es2024_sharedmemory = {
		libs: [require_es2020_bigint().es2020_bigint],
		variables: [
			["Atomics", base_config_1$21.TYPE],
			["SharedArrayBuffer", base_config_1$21.TYPE],
			["SharedArrayBufferConstructor", base_config_1$21.TYPE]
		]
	};
})), require_es2024_string = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2024_string = void 0, exports.es2024_string = {
		libs: [],
		variables: [["String", require_base_config().TYPE]]
	};
})), require_es2024 = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2024 = void 0;
	let es2023_1$1 = require_es2023(), es2024_arraybuffer_1$1 = require_es2024_arraybuffer(), es2024_collection_1$2 = require_es2024_collection(), es2024_object_1$1 = require_es2024_object(), es2024_promise_1$1 = require_es2024_promise(), es2024_regexp_1$1 = require_es2024_regexp(), es2024_sharedmemory_1$1 = require_es2024_sharedmemory(), es2024_string_1$1 = require_es2024_string();
	exports.es2024 = {
		libs: [
			es2023_1$1.es2023,
			es2024_arraybuffer_1$1.es2024_arraybuffer,
			es2024_collection_1$2.es2024_collection,
			es2024_object_1$1.es2024_object,
			es2024_promise_1$1.es2024_promise,
			es2024_regexp_1$1.es2024_regexp,
			es2024_sharedmemory_1$1.es2024_sharedmemory,
			es2024_string_1$1.es2024_string
		],
		variables: []
	};
})), require_es2024_full = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.es2024_full = void 0;
	let dom_1$3 = require_dom(), dom_asynciterable_1$2 = require_dom_asynciterable(), dom_iterable_1$2 = require_dom_iterable(), es2024_1$2 = require_es2024(), scripthost_1$3 = require_scripthost(), webworker_importscripts_1$3 = require_webworker_importscripts();
	exports.es2024_full = {
		libs: [
			es2024_1$2.es2024,
			dom_1$3.dom,
			webworker_importscripts_1$3.webworker_importscripts,
			scripthost_1$3.scripthost,
			dom_iterable_1$2.dom_iterable,
			dom_asynciterable_1$2.dom_asynciterable
		],
		variables: []
	};
})), require_esnext_array = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext_array = void 0, exports.esnext_array = {
		libs: [],
		variables: [["ArrayConstructor", require_base_config().TYPE]]
	};
})), require_esnext_collection = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext_collection = void 0;
	let base_config_1$18 = require_base_config();
	exports.esnext_collection = {
		libs: [require_es2024_collection().es2024_collection],
		variables: [
			["ReadonlySetLike", base_config_1$18.TYPE],
			["Set", base_config_1$18.TYPE],
			["ReadonlySet", base_config_1$18.TYPE]
		]
	};
})), require_esnext_decorators = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext_decorators = void 0;
	let base_config_1$17 = require_base_config(), decorators_1$1 = require_decorators();
	exports.esnext_decorators = {
		libs: [require_es2015_symbol().es2015_symbol, decorators_1$1.decorators],
		variables: [["SymbolConstructor", base_config_1$17.TYPE], ["Function", base_config_1$17.TYPE]]
	};
})), require_esnext_disposable = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext_disposable = void 0;
	let base_config_1$16 = require_base_config(), es2015_iterable_1$4 = require_es2015_iterable(), es2015_symbol_1$3 = require_es2015_symbol(), es2018_asynciterable_1$1 = require_es2018_asynciterable();
	exports.esnext_disposable = {
		libs: [
			es2015_symbol_1$3.es2015_symbol,
			es2015_iterable_1$4.es2015_iterable,
			es2018_asynciterable_1$1.es2018_asynciterable
		],
		variables: [
			["SymbolConstructor", base_config_1$16.TYPE],
			["Disposable", base_config_1$16.TYPE],
			["AsyncDisposable", base_config_1$16.TYPE],
			["SuppressedError", base_config_1$16.TYPE_VALUE],
			["SuppressedErrorConstructor", base_config_1$16.TYPE],
			["DisposableStack", base_config_1$16.TYPE_VALUE],
			["DisposableStackConstructor", base_config_1$16.TYPE],
			["AsyncDisposableStack", base_config_1$16.TYPE_VALUE],
			["AsyncDisposableStackConstructor", base_config_1$16.TYPE],
			["IteratorObject", base_config_1$16.TYPE],
			["AsyncIteratorObject", base_config_1$16.TYPE]
		]
	};
})), require_esnext_error = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext_error = void 0, exports.esnext_error = {
		libs: [],
		variables: [["ErrorConstructor", require_base_config().TYPE]]
	};
})), require_esnext_float16 = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext_float16 = void 0;
	let base_config_1$14 = require_base_config(), es2015_iterable_1$3 = require_es2015_iterable();
	exports.esnext_float16 = {
		libs: [require_es2015_symbol().es2015_symbol, es2015_iterable_1$3.es2015_iterable],
		variables: [
			["Float16Array", base_config_1$14.TYPE_VALUE],
			["Float16ArrayConstructor", base_config_1$14.TYPE],
			["Math", base_config_1$14.TYPE],
			["DataView", base_config_1$14.TYPE]
		]
	};
})), require_esnext_intl = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext_intl = void 0, exports.esnext_intl = {
		libs: [],
		variables: [["Intl", require_base_config().TYPE_VALUE]]
	};
})), require_esnext_iterator = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext_iterator = void 0;
	let base_config_1$12 = require_base_config();
	exports.esnext_iterator = {
		libs: [require_es2015_iterable().es2015_iterable],
		variables: [["Iterator", base_config_1$12.TYPE_VALUE], ["IteratorObjectConstructor", base_config_1$12.TYPE]]
	};
})), require_esnext_promise = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext_promise = void 0, exports.esnext_promise = {
		libs: [],
		variables: [["PromiseConstructor", require_base_config().TYPE]]
	};
})), require_esnext_sharedmemory = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext_sharedmemory = void 0, exports.esnext_sharedmemory = {
		libs: [],
		variables: [["Atomics", require_base_config().TYPE]]
	};
})), require_esnext = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext = void 0;
	let es2024_1$1 = require_es2024(), esnext_array_1$1 = require_esnext_array(), esnext_collection_1$1 = require_esnext_collection(), esnext_decorators_1$1 = require_esnext_decorators(), esnext_disposable_1$1 = require_esnext_disposable(), esnext_error_1$1 = require_esnext_error(), esnext_float16_1$1 = require_esnext_float16(), esnext_intl_1$1 = require_esnext_intl(), esnext_iterator_1$1 = require_esnext_iterator(), esnext_promise_1$1 = require_esnext_promise(), esnext_sharedmemory_1$1 = require_esnext_sharedmemory();
	exports.esnext = {
		libs: [
			es2024_1$1.es2024,
			esnext_intl_1$1.esnext_intl,
			esnext_decorators_1$1.esnext_decorators,
			esnext_disposable_1$1.esnext_disposable,
			esnext_collection_1$1.esnext_collection,
			esnext_array_1$1.esnext_array,
			esnext_iterator_1$1.esnext_iterator,
			esnext_promise_1$1.esnext_promise,
			esnext_float16_1$1.esnext_float16,
			esnext_error_1$1.esnext_error,
			esnext_sharedmemory_1$1.esnext_sharedmemory
		],
		variables: []
	};
})), require_esnext_asynciterable = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext_asynciterable = void 0;
	let base_config_1$9 = require_base_config(), es2015_iterable_1$1 = require_es2015_iterable();
	exports.esnext_asynciterable = {
		libs: [require_es2015_symbol().es2015_symbol, es2015_iterable_1$1.es2015_iterable],
		variables: [
			["SymbolConstructor", base_config_1$9.TYPE],
			["AsyncIterator", base_config_1$9.TYPE],
			["AsyncIterable", base_config_1$9.TYPE],
			["AsyncIterableIterator", base_config_1$9.TYPE],
			["AsyncIteratorObject", base_config_1$9.TYPE]
		]
	};
})), require_esnext_bigint = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext_bigint = void 0;
	let base_config_1$8 = require_base_config();
	exports.esnext_bigint = {
		libs: [require_es2020_intl().es2020_intl],
		variables: [
			["BigIntToLocaleStringOptions", base_config_1$8.TYPE],
			["BigInt", base_config_1$8.TYPE_VALUE],
			["BigIntConstructor", base_config_1$8.TYPE],
			["BigInt64Array", base_config_1$8.TYPE_VALUE],
			["BigInt64ArrayConstructor", base_config_1$8.TYPE],
			["BigUint64Array", base_config_1$8.TYPE_VALUE],
			["BigUint64ArrayConstructor", base_config_1$8.TYPE],
			["DataView", base_config_1$8.TYPE],
			["Intl", base_config_1$8.TYPE_VALUE]
		]
	};
})), require_esnext_full = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext_full = void 0;
	let dom_1$2 = require_dom(), dom_asynciterable_1$1 = require_dom_asynciterable(), dom_iterable_1$1 = require_dom_iterable(), esnext_1$1 = require_esnext(), scripthost_1$2 = require_scripthost(), webworker_importscripts_1$2 = require_webworker_importscripts();
	exports.esnext_full = {
		libs: [
			esnext_1$1.esnext,
			dom_1$2.dom,
			webworker_importscripts_1$2.webworker_importscripts,
			scripthost_1$2.scripthost,
			dom_iterable_1$1.dom_iterable,
			dom_asynciterable_1$1.dom_asynciterable
		],
		variables: []
	};
})), require_esnext_object = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext_object = void 0, exports.esnext_object = {
		libs: [],
		variables: [["ObjectConstructor", require_base_config().TYPE]]
	};
})), require_esnext_regexp = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext_regexp = void 0, exports.esnext_regexp = {
		libs: [],
		variables: [["RegExp", require_base_config().TYPE]]
	};
})), require_esnext_string = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext_string = void 0, exports.esnext_string = {
		libs: [],
		variables: [["String", require_base_config().TYPE]]
	};
})), require_esnext_symbol = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext_symbol = void 0, exports.esnext_symbol = {
		libs: [],
		variables: [["Symbol", require_base_config().TYPE]]
	};
})), require_esnext_weakref = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.esnext_weakref = void 0;
	let base_config_1$3 = require_base_config();
	exports.esnext_weakref = {
		libs: [require_es2015_symbol_wellknown().es2015_symbol_wellknown],
		variables: [
			["WeakRef", base_config_1$3.TYPE_VALUE],
			["WeakRefConstructor", base_config_1$3.TYPE],
			["FinalizationRegistry", base_config_1$3.TYPE_VALUE],
			["FinalizationRegistryConstructor", base_config_1$3.TYPE]
		]
	};
})), require_lib$1 = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.lib = void 0;
	let dom_1$1 = require_dom(), es5_1$1 = require_es5(), scripthost_1$1 = require_scripthost(), webworker_importscripts_1$1 = require_webworker_importscripts();
	exports.lib = {
		libs: [
			es5_1$1.es5,
			dom_1$1.dom,
			webworker_importscripts_1$1.webworker_importscripts,
			scripthost_1$1.scripthost
		],
		variables: []
	};
})), require_webworker = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.webworker = void 0;
	let base_config_1$2 = require_base_config();
	exports.webworker = {
		libs: [],
		variables: [
			["AddEventListenerOptions", base_config_1$2.TYPE],
			["AesCbcParams", base_config_1$2.TYPE],
			["AesCtrParams", base_config_1$2.TYPE],
			["AesDerivedKeyParams", base_config_1$2.TYPE],
			["AesGcmParams", base_config_1$2.TYPE],
			["AesKeyAlgorithm", base_config_1$2.TYPE],
			["AesKeyGenParams", base_config_1$2.TYPE],
			["Algorithm", base_config_1$2.TYPE],
			["AudioConfiguration", base_config_1$2.TYPE],
			["AudioDataCopyToOptions", base_config_1$2.TYPE],
			["AudioDataInit", base_config_1$2.TYPE],
			["AudioDecoderConfig", base_config_1$2.TYPE],
			["AudioDecoderInit", base_config_1$2.TYPE],
			["AudioDecoderSupport", base_config_1$2.TYPE],
			["AudioEncoderConfig", base_config_1$2.TYPE],
			["AudioEncoderInit", base_config_1$2.TYPE],
			["AudioEncoderSupport", base_config_1$2.TYPE],
			["AvcEncoderConfig", base_config_1$2.TYPE],
			["BlobPropertyBag", base_config_1$2.TYPE],
			["CSSMatrixComponentOptions", base_config_1$2.TYPE],
			["CSSNumericType", base_config_1$2.TYPE],
			["CacheQueryOptions", base_config_1$2.TYPE],
			["ClientQueryOptions", base_config_1$2.TYPE],
			["CloseEventInit", base_config_1$2.TYPE],
			["CookieInit", base_config_1$2.TYPE],
			["CookieListItem", base_config_1$2.TYPE],
			["CookieStoreDeleteOptions", base_config_1$2.TYPE],
			["CookieStoreGetOptions", base_config_1$2.TYPE],
			["CryptoKeyPair", base_config_1$2.TYPE],
			["CustomEventInit", base_config_1$2.TYPE],
			["DOMMatrix2DInit", base_config_1$2.TYPE],
			["DOMMatrixInit", base_config_1$2.TYPE],
			["DOMPointInit", base_config_1$2.TYPE],
			["DOMQuadInit", base_config_1$2.TYPE],
			["DOMRectInit", base_config_1$2.TYPE],
			["EcKeyGenParams", base_config_1$2.TYPE],
			["EcKeyImportParams", base_config_1$2.TYPE],
			["EcdhKeyDeriveParams", base_config_1$2.TYPE],
			["EcdsaParams", base_config_1$2.TYPE],
			["EncodedAudioChunkInit", base_config_1$2.TYPE],
			["EncodedAudioChunkMetadata", base_config_1$2.TYPE],
			["EncodedVideoChunkInit", base_config_1$2.TYPE],
			["EncodedVideoChunkMetadata", base_config_1$2.TYPE],
			["ErrorEventInit", base_config_1$2.TYPE],
			["EventInit", base_config_1$2.TYPE],
			["EventListenerOptions", base_config_1$2.TYPE],
			["EventSourceInit", base_config_1$2.TYPE],
			["ExtendableCookieChangeEventInit", base_config_1$2.TYPE],
			["ExtendableEventInit", base_config_1$2.TYPE],
			["ExtendableMessageEventInit", base_config_1$2.TYPE],
			["FetchEventInit", base_config_1$2.TYPE],
			["FilePropertyBag", base_config_1$2.TYPE],
			["FileSystemCreateWritableOptions", base_config_1$2.TYPE],
			["FileSystemGetDirectoryOptions", base_config_1$2.TYPE],
			["FileSystemGetFileOptions", base_config_1$2.TYPE],
			["FileSystemReadWriteOptions", base_config_1$2.TYPE],
			["FileSystemRemoveOptions", base_config_1$2.TYPE],
			["FontFaceDescriptors", base_config_1$2.TYPE],
			["FontFaceSetLoadEventInit", base_config_1$2.TYPE],
			["GetNotificationOptions", base_config_1$2.TYPE],
			["HkdfParams", base_config_1$2.TYPE],
			["HmacImportParams", base_config_1$2.TYPE],
			["HmacKeyGenParams", base_config_1$2.TYPE],
			["IDBDatabaseInfo", base_config_1$2.TYPE],
			["IDBIndexParameters", base_config_1$2.TYPE],
			["IDBObjectStoreParameters", base_config_1$2.TYPE],
			["IDBTransactionOptions", base_config_1$2.TYPE],
			["IDBVersionChangeEventInit", base_config_1$2.TYPE],
			["ImageBitmapOptions", base_config_1$2.TYPE],
			["ImageBitmapRenderingContextSettings", base_config_1$2.TYPE],
			["ImageDataSettings", base_config_1$2.TYPE],
			["ImageDecodeOptions", base_config_1$2.TYPE],
			["ImageDecodeResult", base_config_1$2.TYPE],
			["ImageDecoderInit", base_config_1$2.TYPE],
			["ImageEncodeOptions", base_config_1$2.TYPE],
			["JsonWebKey", base_config_1$2.TYPE],
			["KeyAlgorithm", base_config_1$2.TYPE],
			["KeySystemTrackConfiguration", base_config_1$2.TYPE],
			["LockInfo", base_config_1$2.TYPE],
			["LockManagerSnapshot", base_config_1$2.TYPE],
			["LockOptions", base_config_1$2.TYPE],
			["MediaCapabilitiesDecodingInfo", base_config_1$2.TYPE],
			["MediaCapabilitiesEncodingInfo", base_config_1$2.TYPE],
			["MediaCapabilitiesInfo", base_config_1$2.TYPE],
			["MediaCapabilitiesKeySystemConfiguration", base_config_1$2.TYPE],
			["MediaConfiguration", base_config_1$2.TYPE],
			["MediaDecodingConfiguration", base_config_1$2.TYPE],
			["MediaEncodingConfiguration", base_config_1$2.TYPE],
			["MediaStreamTrackProcessorInit", base_config_1$2.TYPE],
			["MessageEventInit", base_config_1$2.TYPE],
			["MultiCacheQueryOptions", base_config_1$2.TYPE],
			["NavigationPreloadState", base_config_1$2.TYPE],
			["NotificationEventInit", base_config_1$2.TYPE],
			["NotificationOptions", base_config_1$2.TYPE],
			["OpusEncoderConfig", base_config_1$2.TYPE],
			["Pbkdf2Params", base_config_1$2.TYPE],
			["PerformanceMarkOptions", base_config_1$2.TYPE],
			["PerformanceMeasureOptions", base_config_1$2.TYPE],
			["PerformanceObserverInit", base_config_1$2.TYPE],
			["PermissionDescriptor", base_config_1$2.TYPE],
			["PlaneLayout", base_config_1$2.TYPE],
			["ProgressEventInit", base_config_1$2.TYPE],
			["PromiseRejectionEventInit", base_config_1$2.TYPE],
			["PushEventInit", base_config_1$2.TYPE],
			["PushSubscriptionChangeEventInit", base_config_1$2.TYPE],
			["PushSubscriptionJSON", base_config_1$2.TYPE],
			["PushSubscriptionOptionsInit", base_config_1$2.TYPE],
			["QueuingStrategy", base_config_1$2.TYPE],
			["QueuingStrategyInit", base_config_1$2.TYPE],
			["RTCEncodedAudioFrameMetadata", base_config_1$2.TYPE],
			["RTCEncodedFrameMetadata", base_config_1$2.TYPE],
			["RTCEncodedVideoFrameMetadata", base_config_1$2.TYPE],
			["ReadableStreamGetReaderOptions", base_config_1$2.TYPE],
			["ReadableStreamIteratorOptions", base_config_1$2.TYPE],
			["ReadableStreamReadDoneResult", base_config_1$2.TYPE],
			["ReadableStreamReadValueResult", base_config_1$2.TYPE],
			["ReadableWritablePair", base_config_1$2.TYPE],
			["RegistrationOptions", base_config_1$2.TYPE],
			["ReportingObserverOptions", base_config_1$2.TYPE],
			["RequestInit", base_config_1$2.TYPE],
			["ResponseInit", base_config_1$2.TYPE],
			["RsaHashedImportParams", base_config_1$2.TYPE],
			["RsaHashedKeyGenParams", base_config_1$2.TYPE],
			["RsaKeyGenParams", base_config_1$2.TYPE],
			["RsaOaepParams", base_config_1$2.TYPE],
			["RsaOtherPrimesInfo", base_config_1$2.TYPE],
			["RsaPssParams", base_config_1$2.TYPE],
			["SecurityPolicyViolationEventInit", base_config_1$2.TYPE],
			["StorageEstimate", base_config_1$2.TYPE],
			["StreamPipeOptions", base_config_1$2.TYPE],
			["StructuredSerializeOptions", base_config_1$2.TYPE],
			["TextDecodeOptions", base_config_1$2.TYPE],
			["TextDecoderOptions", base_config_1$2.TYPE],
			["TextEncoderEncodeIntoResult", base_config_1$2.TYPE],
			["Transformer", base_config_1$2.TYPE],
			["UnderlyingByteSource", base_config_1$2.TYPE],
			["UnderlyingDefaultSource", base_config_1$2.TYPE],
			["UnderlyingSink", base_config_1$2.TYPE],
			["UnderlyingSource", base_config_1$2.TYPE],
			["VideoColorSpaceInit", base_config_1$2.TYPE],
			["VideoConfiguration", base_config_1$2.TYPE],
			["VideoDecoderConfig", base_config_1$2.TYPE],
			["VideoDecoderInit", base_config_1$2.TYPE],
			["VideoDecoderSupport", base_config_1$2.TYPE],
			["VideoEncoderConfig", base_config_1$2.TYPE],
			["VideoEncoderEncodeOptions", base_config_1$2.TYPE],
			["VideoEncoderEncodeOptionsForAvc", base_config_1$2.TYPE],
			["VideoEncoderInit", base_config_1$2.TYPE],
			["VideoEncoderSupport", base_config_1$2.TYPE],
			["VideoFrameBufferInit", base_config_1$2.TYPE],
			["VideoFrameCopyToOptions", base_config_1$2.TYPE],
			["VideoFrameInit", base_config_1$2.TYPE],
			["WebGLContextAttributes", base_config_1$2.TYPE],
			["WebGLContextEventInit", base_config_1$2.TYPE],
			["WebTransportCloseInfo", base_config_1$2.TYPE],
			["WebTransportErrorOptions", base_config_1$2.TYPE],
			["WebTransportHash", base_config_1$2.TYPE],
			["WebTransportOptions", base_config_1$2.TYPE],
			["WebTransportSendOptions", base_config_1$2.TYPE],
			["WebTransportSendStreamOptions", base_config_1$2.TYPE],
			["WorkerOptions", base_config_1$2.TYPE],
			["WriteParams", base_config_1$2.TYPE],
			["ANGLE_instanced_arrays", base_config_1$2.TYPE],
			["AbortController", base_config_1$2.TYPE_VALUE],
			["AbortSignalEventMap", base_config_1$2.TYPE],
			["AbortSignal", base_config_1$2.TYPE_VALUE],
			["AbstractWorkerEventMap", base_config_1$2.TYPE],
			["AbstractWorker", base_config_1$2.TYPE],
			["AnimationFrameProvider", base_config_1$2.TYPE],
			["AudioData", base_config_1$2.TYPE_VALUE],
			["AudioDecoderEventMap", base_config_1$2.TYPE],
			["AudioDecoder", base_config_1$2.TYPE_VALUE],
			["AudioEncoderEventMap", base_config_1$2.TYPE],
			["AudioEncoder", base_config_1$2.TYPE_VALUE],
			["Blob", base_config_1$2.TYPE_VALUE],
			["Body", base_config_1$2.TYPE],
			["BroadcastChannelEventMap", base_config_1$2.TYPE],
			["BroadcastChannel", base_config_1$2.TYPE_VALUE],
			["ByteLengthQueuingStrategy", base_config_1$2.TYPE_VALUE],
			["CSSImageValue", base_config_1$2.TYPE_VALUE],
			["CSSKeywordValue", base_config_1$2.TYPE_VALUE],
			["CSSMathClamp", base_config_1$2.TYPE_VALUE],
			["CSSMathInvert", base_config_1$2.TYPE_VALUE],
			["CSSMathMax", base_config_1$2.TYPE_VALUE],
			["CSSMathMin", base_config_1$2.TYPE_VALUE],
			["CSSMathNegate", base_config_1$2.TYPE_VALUE],
			["CSSMathProduct", base_config_1$2.TYPE_VALUE],
			["CSSMathSum", base_config_1$2.TYPE_VALUE],
			["CSSMathValue", base_config_1$2.TYPE_VALUE],
			["CSSMatrixComponent", base_config_1$2.TYPE_VALUE],
			["CSSNumericArray", base_config_1$2.TYPE_VALUE],
			["CSSNumericValue", base_config_1$2.TYPE_VALUE],
			["CSSPerspective", base_config_1$2.TYPE_VALUE],
			["CSSRotate", base_config_1$2.TYPE_VALUE],
			["CSSScale", base_config_1$2.TYPE_VALUE],
			["CSSSkew", base_config_1$2.TYPE_VALUE],
			["CSSSkewX", base_config_1$2.TYPE_VALUE],
			["CSSSkewY", base_config_1$2.TYPE_VALUE],
			["CSSStyleValue", base_config_1$2.TYPE_VALUE],
			["CSSTransformComponent", base_config_1$2.TYPE_VALUE],
			["CSSTransformValue", base_config_1$2.TYPE_VALUE],
			["CSSTranslate", base_config_1$2.TYPE_VALUE],
			["CSSUnitValue", base_config_1$2.TYPE_VALUE],
			["CSSUnparsedValue", base_config_1$2.TYPE_VALUE],
			["CSSVariableReferenceValue", base_config_1$2.TYPE_VALUE],
			["Cache", base_config_1$2.TYPE_VALUE],
			["CacheStorage", base_config_1$2.TYPE_VALUE],
			["CanvasCompositing", base_config_1$2.TYPE],
			["CanvasDrawImage", base_config_1$2.TYPE],
			["CanvasDrawPath", base_config_1$2.TYPE],
			["CanvasFillStrokeStyles", base_config_1$2.TYPE],
			["CanvasFilters", base_config_1$2.TYPE],
			["CanvasGradient", base_config_1$2.TYPE_VALUE],
			["CanvasImageData", base_config_1$2.TYPE],
			["CanvasImageSmoothing", base_config_1$2.TYPE],
			["CanvasPath", base_config_1$2.TYPE],
			["CanvasPathDrawingStyles", base_config_1$2.TYPE],
			["CanvasPattern", base_config_1$2.TYPE_VALUE],
			["CanvasRect", base_config_1$2.TYPE],
			["CanvasShadowStyles", base_config_1$2.TYPE],
			["CanvasState", base_config_1$2.TYPE],
			["CanvasText", base_config_1$2.TYPE],
			["CanvasTextDrawingStyles", base_config_1$2.TYPE],
			["CanvasTransform", base_config_1$2.TYPE],
			["Client", base_config_1$2.TYPE_VALUE],
			["Clients", base_config_1$2.TYPE_VALUE],
			["CloseEvent", base_config_1$2.TYPE_VALUE],
			["CompressionStream", base_config_1$2.TYPE_VALUE],
			["CookieStore", base_config_1$2.TYPE_VALUE],
			["CookieStoreManager", base_config_1$2.TYPE_VALUE],
			["CountQueuingStrategy", base_config_1$2.TYPE_VALUE],
			["Crypto", base_config_1$2.TYPE_VALUE],
			["CryptoKey", base_config_1$2.TYPE_VALUE],
			["CustomEvent", base_config_1$2.TYPE_VALUE],
			["DOMException", base_config_1$2.TYPE_VALUE],
			["DOMMatrix", base_config_1$2.TYPE_VALUE],
			["DOMMatrixReadOnly", base_config_1$2.TYPE_VALUE],
			["DOMPoint", base_config_1$2.TYPE_VALUE],
			["DOMPointReadOnly", base_config_1$2.TYPE_VALUE],
			["DOMQuad", base_config_1$2.TYPE_VALUE],
			["DOMRect", base_config_1$2.TYPE_VALUE],
			["DOMRectReadOnly", base_config_1$2.TYPE_VALUE],
			["DOMStringList", base_config_1$2.TYPE_VALUE],
			["DecompressionStream", base_config_1$2.TYPE_VALUE],
			["DedicatedWorkerGlobalScopeEventMap", base_config_1$2.TYPE],
			["DedicatedWorkerGlobalScope", base_config_1$2.TYPE_VALUE],
			["EXT_blend_minmax", base_config_1$2.TYPE],
			["EXT_color_buffer_float", base_config_1$2.TYPE],
			["EXT_color_buffer_half_float", base_config_1$2.TYPE],
			["EXT_float_blend", base_config_1$2.TYPE],
			["EXT_frag_depth", base_config_1$2.TYPE],
			["EXT_sRGB", base_config_1$2.TYPE],
			["EXT_shader_texture_lod", base_config_1$2.TYPE],
			["EXT_texture_compression_bptc", base_config_1$2.TYPE],
			["EXT_texture_compression_rgtc", base_config_1$2.TYPE],
			["EXT_texture_filter_anisotropic", base_config_1$2.TYPE],
			["EXT_texture_norm16", base_config_1$2.TYPE],
			["EncodedAudioChunk", base_config_1$2.TYPE_VALUE],
			["EncodedVideoChunk", base_config_1$2.TYPE_VALUE],
			["ErrorEvent", base_config_1$2.TYPE_VALUE],
			["Event", base_config_1$2.TYPE_VALUE],
			["EventListener", base_config_1$2.TYPE],
			["EventListenerObject", base_config_1$2.TYPE],
			["EventSourceEventMap", base_config_1$2.TYPE],
			["EventSource", base_config_1$2.TYPE_VALUE],
			["EventTarget", base_config_1$2.TYPE_VALUE],
			["ExtendableCookieChangeEvent", base_config_1$2.TYPE_VALUE],
			["ExtendableEvent", base_config_1$2.TYPE_VALUE],
			["ExtendableMessageEvent", base_config_1$2.TYPE_VALUE],
			["FetchEvent", base_config_1$2.TYPE_VALUE],
			["File", base_config_1$2.TYPE_VALUE],
			["FileList", base_config_1$2.TYPE_VALUE],
			["FileReaderEventMap", base_config_1$2.TYPE],
			["FileReader", base_config_1$2.TYPE_VALUE],
			["FileReaderSync", base_config_1$2.TYPE_VALUE],
			["FileSystemDirectoryHandle", base_config_1$2.TYPE_VALUE],
			["FileSystemFileHandle", base_config_1$2.TYPE_VALUE],
			["FileSystemHandle", base_config_1$2.TYPE_VALUE],
			["FileSystemSyncAccessHandle", base_config_1$2.TYPE_VALUE],
			["FileSystemWritableFileStream", base_config_1$2.TYPE_VALUE],
			["FontFace", base_config_1$2.TYPE_VALUE],
			["FontFaceSetEventMap", base_config_1$2.TYPE],
			["FontFaceSet", base_config_1$2.TYPE_VALUE],
			["FontFaceSetLoadEvent", base_config_1$2.TYPE_VALUE],
			["FontFaceSource", base_config_1$2.TYPE],
			["FormData", base_config_1$2.TYPE_VALUE],
			["GPUError", base_config_1$2.TYPE],
			["GenericTransformStream", base_config_1$2.TYPE],
			["Headers", base_config_1$2.TYPE_VALUE],
			["IDBCursor", base_config_1$2.TYPE_VALUE],
			["IDBCursorWithValue", base_config_1$2.TYPE_VALUE],
			["IDBDatabaseEventMap", base_config_1$2.TYPE],
			["IDBDatabase", base_config_1$2.TYPE_VALUE],
			["IDBFactory", base_config_1$2.TYPE_VALUE],
			["IDBIndex", base_config_1$2.TYPE_VALUE],
			["IDBKeyRange", base_config_1$2.TYPE_VALUE],
			["IDBObjectStore", base_config_1$2.TYPE_VALUE],
			["IDBOpenDBRequestEventMap", base_config_1$2.TYPE],
			["IDBOpenDBRequest", base_config_1$2.TYPE_VALUE],
			["IDBRequestEventMap", base_config_1$2.TYPE],
			["IDBRequest", base_config_1$2.TYPE_VALUE],
			["IDBTransactionEventMap", base_config_1$2.TYPE],
			["IDBTransaction", base_config_1$2.TYPE_VALUE],
			["IDBVersionChangeEvent", base_config_1$2.TYPE_VALUE],
			["ImageBitmap", base_config_1$2.TYPE_VALUE],
			["ImageBitmapRenderingContext", base_config_1$2.TYPE_VALUE],
			["ImageData", base_config_1$2.TYPE_VALUE],
			["ImageDecoder", base_config_1$2.TYPE_VALUE],
			["ImageTrack", base_config_1$2.TYPE_VALUE],
			["ImageTrackList", base_config_1$2.TYPE_VALUE],
			["ImportMeta", base_config_1$2.TYPE],
			["KHR_parallel_shader_compile", base_config_1$2.TYPE],
			["Lock", base_config_1$2.TYPE_VALUE],
			["LockManager", base_config_1$2.TYPE_VALUE],
			["MediaCapabilities", base_config_1$2.TYPE_VALUE],
			["MediaSourceHandle", base_config_1$2.TYPE_VALUE],
			["MediaStreamTrackProcessor", base_config_1$2.TYPE_VALUE],
			["MessageChannel", base_config_1$2.TYPE_VALUE],
			["MessageEvent", base_config_1$2.TYPE_VALUE],
			["MessageEventTargetEventMap", base_config_1$2.TYPE],
			["MessageEventTarget", base_config_1$2.TYPE],
			["MessagePortEventMap", base_config_1$2.TYPE],
			["MessagePort", base_config_1$2.TYPE_VALUE],
			["NavigationPreloadManager", base_config_1$2.TYPE_VALUE],
			["NavigatorBadge", base_config_1$2.TYPE],
			["NavigatorConcurrentHardware", base_config_1$2.TYPE],
			["NavigatorID", base_config_1$2.TYPE],
			["NavigatorLanguage", base_config_1$2.TYPE],
			["NavigatorLocks", base_config_1$2.TYPE],
			["NavigatorOnLine", base_config_1$2.TYPE],
			["NavigatorStorage", base_config_1$2.TYPE],
			["NotificationEventMap", base_config_1$2.TYPE],
			["Notification", base_config_1$2.TYPE_VALUE],
			["NotificationEvent", base_config_1$2.TYPE_VALUE],
			["OES_draw_buffers_indexed", base_config_1$2.TYPE],
			["OES_element_index_uint", base_config_1$2.TYPE],
			["OES_fbo_render_mipmap", base_config_1$2.TYPE],
			["OES_standard_derivatives", base_config_1$2.TYPE],
			["OES_texture_float", base_config_1$2.TYPE],
			["OES_texture_float_linear", base_config_1$2.TYPE],
			["OES_texture_half_float", base_config_1$2.TYPE],
			["OES_texture_half_float_linear", base_config_1$2.TYPE],
			["OES_vertex_array_object", base_config_1$2.TYPE],
			["OVR_multiview2", base_config_1$2.TYPE],
			["OffscreenCanvasEventMap", base_config_1$2.TYPE],
			["OffscreenCanvas", base_config_1$2.TYPE_VALUE],
			["OffscreenCanvasRenderingContext2D", base_config_1$2.TYPE_VALUE],
			["Path2D", base_config_1$2.TYPE_VALUE],
			["PerformanceEventMap", base_config_1$2.TYPE],
			["Performance", base_config_1$2.TYPE_VALUE],
			["PerformanceEntry", base_config_1$2.TYPE_VALUE],
			["PerformanceMark", base_config_1$2.TYPE_VALUE],
			["PerformanceMeasure", base_config_1$2.TYPE_VALUE],
			["PerformanceObserver", base_config_1$2.TYPE_VALUE],
			["PerformanceObserverEntryList", base_config_1$2.TYPE_VALUE],
			["PerformanceResourceTiming", base_config_1$2.TYPE_VALUE],
			["PerformanceServerTiming", base_config_1$2.TYPE_VALUE],
			["PermissionStatusEventMap", base_config_1$2.TYPE],
			["PermissionStatus", base_config_1$2.TYPE_VALUE],
			["Permissions", base_config_1$2.TYPE_VALUE],
			["ProgressEvent", base_config_1$2.TYPE_VALUE],
			["PromiseRejectionEvent", base_config_1$2.TYPE_VALUE],
			["PushEvent", base_config_1$2.TYPE_VALUE],
			["PushManager", base_config_1$2.TYPE_VALUE],
			["PushMessageData", base_config_1$2.TYPE_VALUE],
			["PushSubscription", base_config_1$2.TYPE_VALUE],
			["PushSubscriptionChangeEvent", base_config_1$2.TYPE_VALUE],
			["PushSubscriptionOptions", base_config_1$2.TYPE_VALUE],
			["RTCDataChannelEventMap", base_config_1$2.TYPE],
			["RTCDataChannel", base_config_1$2.TYPE_VALUE],
			["RTCEncodedAudioFrame", base_config_1$2.TYPE_VALUE],
			["RTCEncodedVideoFrame", base_config_1$2.TYPE_VALUE],
			["RTCRtpScriptTransformer", base_config_1$2.TYPE_VALUE],
			["RTCTransformEvent", base_config_1$2.TYPE_VALUE],
			["ReadableByteStreamController", base_config_1$2.TYPE_VALUE],
			["ReadableStream", base_config_1$2.TYPE_VALUE],
			["ReadableStreamBYOBReader", base_config_1$2.TYPE_VALUE],
			["ReadableStreamBYOBRequest", base_config_1$2.TYPE_VALUE],
			["ReadableStreamDefaultController", base_config_1$2.TYPE_VALUE],
			["ReadableStreamDefaultReader", base_config_1$2.TYPE_VALUE],
			["ReadableStreamGenericReader", base_config_1$2.TYPE],
			["Report", base_config_1$2.TYPE_VALUE],
			["ReportBody", base_config_1$2.TYPE_VALUE],
			["ReportingObserver", base_config_1$2.TYPE_VALUE],
			["Request", base_config_1$2.TYPE_VALUE],
			["Response", base_config_1$2.TYPE_VALUE],
			["SecurityPolicyViolationEvent", base_config_1$2.TYPE_VALUE],
			["ServiceWorkerEventMap", base_config_1$2.TYPE],
			["ServiceWorker", base_config_1$2.TYPE_VALUE],
			["ServiceWorkerContainerEventMap", base_config_1$2.TYPE],
			["ServiceWorkerContainer", base_config_1$2.TYPE_VALUE],
			["ServiceWorkerGlobalScopeEventMap", base_config_1$2.TYPE],
			["ServiceWorkerGlobalScope", base_config_1$2.TYPE_VALUE],
			["ServiceWorkerRegistrationEventMap", base_config_1$2.TYPE],
			["ServiceWorkerRegistration", base_config_1$2.TYPE_VALUE],
			["SharedWorkerGlobalScopeEventMap", base_config_1$2.TYPE],
			["SharedWorkerGlobalScope", base_config_1$2.TYPE_VALUE],
			["StorageManager", base_config_1$2.TYPE_VALUE],
			["StylePropertyMapReadOnly", base_config_1$2.TYPE_VALUE],
			["SubtleCrypto", base_config_1$2.TYPE_VALUE],
			["TextDecoder", base_config_1$2.TYPE_VALUE],
			["TextDecoderCommon", base_config_1$2.TYPE],
			["TextDecoderStream", base_config_1$2.TYPE_VALUE],
			["TextEncoder", base_config_1$2.TYPE_VALUE],
			["TextEncoderCommon", base_config_1$2.TYPE],
			["TextEncoderStream", base_config_1$2.TYPE_VALUE],
			["TextMetrics", base_config_1$2.TYPE_VALUE],
			["TransformStream", base_config_1$2.TYPE_VALUE],
			["TransformStreamDefaultController", base_config_1$2.TYPE_VALUE],
			["URL", base_config_1$2.TYPE_VALUE],
			["URLSearchParams", base_config_1$2.TYPE_VALUE],
			["VideoColorSpace", base_config_1$2.TYPE_VALUE],
			["VideoDecoderEventMap", base_config_1$2.TYPE],
			["VideoDecoder", base_config_1$2.TYPE_VALUE],
			["VideoEncoderEventMap", base_config_1$2.TYPE],
			["VideoEncoder", base_config_1$2.TYPE_VALUE],
			["VideoFrame", base_config_1$2.TYPE_VALUE],
			["WEBGL_color_buffer_float", base_config_1$2.TYPE],
			["WEBGL_compressed_texture_astc", base_config_1$2.TYPE],
			["WEBGL_compressed_texture_etc", base_config_1$2.TYPE],
			["WEBGL_compressed_texture_etc1", base_config_1$2.TYPE],
			["WEBGL_compressed_texture_pvrtc", base_config_1$2.TYPE],
			["WEBGL_compressed_texture_s3tc", base_config_1$2.TYPE],
			["WEBGL_compressed_texture_s3tc_srgb", base_config_1$2.TYPE],
			["WEBGL_debug_renderer_info", base_config_1$2.TYPE],
			["WEBGL_debug_shaders", base_config_1$2.TYPE],
			["WEBGL_depth_texture", base_config_1$2.TYPE],
			["WEBGL_draw_buffers", base_config_1$2.TYPE],
			["WEBGL_lose_context", base_config_1$2.TYPE],
			["WEBGL_multi_draw", base_config_1$2.TYPE],
			["WebGL2RenderingContext", base_config_1$2.TYPE_VALUE],
			["WebGL2RenderingContextBase", base_config_1$2.TYPE],
			["WebGL2RenderingContextOverloads", base_config_1$2.TYPE],
			["WebGLActiveInfo", base_config_1$2.TYPE_VALUE],
			["WebGLBuffer", base_config_1$2.TYPE_VALUE],
			["WebGLContextEvent", base_config_1$2.TYPE_VALUE],
			["WebGLFramebuffer", base_config_1$2.TYPE_VALUE],
			["WebGLProgram", base_config_1$2.TYPE_VALUE],
			["WebGLQuery", base_config_1$2.TYPE_VALUE],
			["WebGLRenderbuffer", base_config_1$2.TYPE_VALUE],
			["WebGLRenderingContext", base_config_1$2.TYPE_VALUE],
			["WebGLRenderingContextBase", base_config_1$2.TYPE],
			["WebGLRenderingContextOverloads", base_config_1$2.TYPE],
			["WebGLSampler", base_config_1$2.TYPE_VALUE],
			["WebGLShader", base_config_1$2.TYPE_VALUE],
			["WebGLShaderPrecisionFormat", base_config_1$2.TYPE_VALUE],
			["WebGLSync", base_config_1$2.TYPE_VALUE],
			["WebGLTexture", base_config_1$2.TYPE_VALUE],
			["WebGLTransformFeedback", base_config_1$2.TYPE_VALUE],
			["WebGLUniformLocation", base_config_1$2.TYPE_VALUE],
			["WebGLVertexArrayObject", base_config_1$2.TYPE_VALUE],
			["WebGLVertexArrayObjectOES", base_config_1$2.TYPE],
			["WebSocketEventMap", base_config_1$2.TYPE],
			["WebSocket", base_config_1$2.TYPE_VALUE],
			["WebTransport", base_config_1$2.TYPE_VALUE],
			["WebTransportBidirectionalStream", base_config_1$2.TYPE_VALUE],
			["WebTransportDatagramDuplexStream", base_config_1$2.TYPE_VALUE],
			["WebTransportError", base_config_1$2.TYPE_VALUE],
			["WindowClient", base_config_1$2.TYPE_VALUE],
			["WindowOrWorkerGlobalScope", base_config_1$2.TYPE],
			["WorkerEventMap", base_config_1$2.TYPE],
			["Worker", base_config_1$2.TYPE_VALUE],
			["WorkerGlobalScopeEventMap", base_config_1$2.TYPE],
			["WorkerGlobalScope", base_config_1$2.TYPE_VALUE],
			["WorkerLocation", base_config_1$2.TYPE_VALUE],
			["WorkerNavigator", base_config_1$2.TYPE_VALUE],
			["WritableStream", base_config_1$2.TYPE_VALUE],
			["WritableStreamDefaultController", base_config_1$2.TYPE_VALUE],
			["WritableStreamDefaultWriter", base_config_1$2.TYPE_VALUE],
			["XMLHttpRequestEventMap", base_config_1$2.TYPE],
			["XMLHttpRequest", base_config_1$2.TYPE_VALUE],
			["XMLHttpRequestEventTargetEventMap", base_config_1$2.TYPE],
			["XMLHttpRequestEventTarget", base_config_1$2.TYPE_VALUE],
			["XMLHttpRequestUpload", base_config_1$2.TYPE_VALUE],
			["WebAssembly", base_config_1$2.TYPE_VALUE],
			["Console", base_config_1$2.TYPE],
			["AudioDataOutputCallback", base_config_1$2.TYPE],
			["EncodedAudioChunkOutputCallback", base_config_1$2.TYPE],
			["EncodedVideoChunkOutputCallback", base_config_1$2.TYPE],
			["FrameRequestCallback", base_config_1$2.TYPE],
			["LockGrantedCallback", base_config_1$2.TYPE],
			["OnErrorEventHandlerNonNull", base_config_1$2.TYPE],
			["PerformanceObserverCallback", base_config_1$2.TYPE],
			["QueuingStrategySize", base_config_1$2.TYPE],
			["ReportingObserverCallback", base_config_1$2.TYPE],
			["TransformerFlushCallback", base_config_1$2.TYPE],
			["TransformerStartCallback", base_config_1$2.TYPE],
			["TransformerTransformCallback", base_config_1$2.TYPE],
			["UnderlyingSinkAbortCallback", base_config_1$2.TYPE],
			["UnderlyingSinkCloseCallback", base_config_1$2.TYPE],
			["UnderlyingSinkStartCallback", base_config_1$2.TYPE],
			["UnderlyingSinkWriteCallback", base_config_1$2.TYPE],
			["UnderlyingSourceCancelCallback", base_config_1$2.TYPE],
			["UnderlyingSourcePullCallback", base_config_1$2.TYPE],
			["UnderlyingSourceStartCallback", base_config_1$2.TYPE],
			["VideoFrameOutputCallback", base_config_1$2.TYPE],
			["VoidFunction", base_config_1$2.TYPE],
			["WebCodecsErrorCallback", base_config_1$2.TYPE],
			["AlgorithmIdentifier", base_config_1$2.TYPE],
			["AllowSharedBufferSource", base_config_1$2.TYPE],
			["BigInteger", base_config_1$2.TYPE],
			["BlobPart", base_config_1$2.TYPE],
			["BodyInit", base_config_1$2.TYPE],
			["BufferSource", base_config_1$2.TYPE],
			["CSSKeywordish", base_config_1$2.TYPE],
			["CSSNumberish", base_config_1$2.TYPE],
			["CSSPerspectiveValue", base_config_1$2.TYPE],
			["CSSUnparsedSegment", base_config_1$2.TYPE],
			["CanvasImageSource", base_config_1$2.TYPE],
			["CookieList", base_config_1$2.TYPE],
			["DOMHighResTimeStamp", base_config_1$2.TYPE],
			["EpochTimeStamp", base_config_1$2.TYPE],
			["EventListenerOrEventListenerObject", base_config_1$2.TYPE],
			["FileSystemWriteChunkType", base_config_1$2.TYPE],
			["Float32List", base_config_1$2.TYPE],
			["FormDataEntryValue", base_config_1$2.TYPE],
			["GLbitfield", base_config_1$2.TYPE],
			["GLboolean", base_config_1$2.TYPE],
			["GLclampf", base_config_1$2.TYPE],
			["GLenum", base_config_1$2.TYPE],
			["GLfloat", base_config_1$2.TYPE],
			["GLint", base_config_1$2.TYPE],
			["GLint64", base_config_1$2.TYPE],
			["GLintptr", base_config_1$2.TYPE],
			["GLsizei", base_config_1$2.TYPE],
			["GLsizeiptr", base_config_1$2.TYPE],
			["GLuint", base_config_1$2.TYPE],
			["GLuint64", base_config_1$2.TYPE],
			["HashAlgorithmIdentifier", base_config_1$2.TYPE],
			["HeadersInit", base_config_1$2.TYPE],
			["IDBValidKey", base_config_1$2.TYPE],
			["ImageBitmapSource", base_config_1$2.TYPE],
			["ImageBufferSource", base_config_1$2.TYPE],
			["ImageDataArray", base_config_1$2.TYPE],
			["Int32List", base_config_1$2.TYPE],
			["MessageEventSource", base_config_1$2.TYPE],
			["NamedCurve", base_config_1$2.TYPE],
			["OffscreenRenderingContext", base_config_1$2.TYPE],
			["OnErrorEventHandler", base_config_1$2.TYPE],
			["PerformanceEntryList", base_config_1$2.TYPE],
			["PushMessageDataInit", base_config_1$2.TYPE],
			["ReadableStreamController", base_config_1$2.TYPE],
			["ReadableStreamReadResult", base_config_1$2.TYPE],
			["ReadableStreamReader", base_config_1$2.TYPE],
			["ReportList", base_config_1$2.TYPE],
			["RequestInfo", base_config_1$2.TYPE],
			["TexImageSource", base_config_1$2.TYPE],
			["TimerHandler", base_config_1$2.TYPE],
			["Transferable", base_config_1$2.TYPE],
			["Uint32List", base_config_1$2.TYPE],
			["XMLHttpRequestBodyInit", base_config_1$2.TYPE],
			["AlphaOption", base_config_1$2.TYPE],
			["AudioSampleFormat", base_config_1$2.TYPE],
			["AvcBitstreamFormat", base_config_1$2.TYPE],
			["BinaryType", base_config_1$2.TYPE],
			["BitrateMode", base_config_1$2.TYPE],
			["CSSMathOperator", base_config_1$2.TYPE],
			["CSSNumericBaseType", base_config_1$2.TYPE],
			["CanvasDirection", base_config_1$2.TYPE],
			["CanvasFillRule", base_config_1$2.TYPE],
			["CanvasFontKerning", base_config_1$2.TYPE],
			["CanvasFontStretch", base_config_1$2.TYPE],
			["CanvasFontVariantCaps", base_config_1$2.TYPE],
			["CanvasLineCap", base_config_1$2.TYPE],
			["CanvasLineJoin", base_config_1$2.TYPE],
			["CanvasTextAlign", base_config_1$2.TYPE],
			["CanvasTextBaseline", base_config_1$2.TYPE],
			["CanvasTextRendering", base_config_1$2.TYPE],
			["ClientTypes", base_config_1$2.TYPE],
			["CodecState", base_config_1$2.TYPE],
			["ColorGamut", base_config_1$2.TYPE],
			["ColorSpaceConversion", base_config_1$2.TYPE],
			["CompressionFormat", base_config_1$2.TYPE],
			["CookieSameSite", base_config_1$2.TYPE],
			["DocumentVisibilityState", base_config_1$2.TYPE],
			["EncodedAudioChunkType", base_config_1$2.TYPE],
			["EncodedVideoChunkType", base_config_1$2.TYPE],
			["EndingType", base_config_1$2.TYPE],
			["FileSystemHandleKind", base_config_1$2.TYPE],
			["FontDisplay", base_config_1$2.TYPE],
			["FontFaceLoadStatus", base_config_1$2.TYPE],
			["FontFaceSetLoadStatus", base_config_1$2.TYPE],
			["FrameType", base_config_1$2.TYPE],
			["GlobalCompositeOperation", base_config_1$2.TYPE],
			["HardwareAcceleration", base_config_1$2.TYPE],
			["HdrMetadataType", base_config_1$2.TYPE],
			["IDBCursorDirection", base_config_1$2.TYPE],
			["IDBRequestReadyState", base_config_1$2.TYPE],
			["IDBTransactionDurability", base_config_1$2.TYPE],
			["IDBTransactionMode", base_config_1$2.TYPE],
			["ImageOrientation", base_config_1$2.TYPE],
			["ImageSmoothingQuality", base_config_1$2.TYPE],
			["KeyFormat", base_config_1$2.TYPE],
			["KeyType", base_config_1$2.TYPE],
			["KeyUsage", base_config_1$2.TYPE],
			["LatencyMode", base_config_1$2.TYPE],
			["LockMode", base_config_1$2.TYPE],
			["MediaDecodingType", base_config_1$2.TYPE],
			["MediaEncodingType", base_config_1$2.TYPE],
			["MediaKeysRequirement", base_config_1$2.TYPE],
			["NotificationDirection", base_config_1$2.TYPE],
			["NotificationPermission", base_config_1$2.TYPE],
			["OffscreenRenderingContextId", base_config_1$2.TYPE],
			["OpusBitstreamFormat", base_config_1$2.TYPE],
			["PermissionName", base_config_1$2.TYPE],
			["PermissionState", base_config_1$2.TYPE],
			["PredefinedColorSpace", base_config_1$2.TYPE],
			["PremultiplyAlpha", base_config_1$2.TYPE],
			["PushEncryptionKeyName", base_config_1$2.TYPE],
			["RTCDataChannelState", base_config_1$2.TYPE],
			["RTCEncodedVideoFrameType", base_config_1$2.TYPE],
			["ReadableStreamReaderMode", base_config_1$2.TYPE],
			["ReadableStreamType", base_config_1$2.TYPE],
			["ReferrerPolicy", base_config_1$2.TYPE],
			["RequestCache", base_config_1$2.TYPE],
			["RequestCredentials", base_config_1$2.TYPE],
			["RequestDestination", base_config_1$2.TYPE],
			["RequestMode", base_config_1$2.TYPE],
			["RequestPriority", base_config_1$2.TYPE],
			["RequestRedirect", base_config_1$2.TYPE],
			["ResizeQuality", base_config_1$2.TYPE],
			["ResponseType", base_config_1$2.TYPE],
			["SecurityPolicyViolationEventDisposition", base_config_1$2.TYPE],
			["ServiceWorkerState", base_config_1$2.TYPE],
			["ServiceWorkerUpdateViaCache", base_config_1$2.TYPE],
			["TransferFunction", base_config_1$2.TYPE],
			["VideoColorPrimaries", base_config_1$2.TYPE],
			["VideoEncoderBitrateMode", base_config_1$2.TYPE],
			["VideoMatrixCoefficients", base_config_1$2.TYPE],
			["VideoPixelFormat", base_config_1$2.TYPE],
			["VideoTransferCharacteristics", base_config_1$2.TYPE],
			["WebGLPowerPreference", base_config_1$2.TYPE],
			["WebTransportCongestionControl", base_config_1$2.TYPE],
			["WebTransportErrorSource", base_config_1$2.TYPE],
			["WorkerType", base_config_1$2.TYPE],
			["WriteCommandType", base_config_1$2.TYPE],
			["XMLHttpRequestResponseType", base_config_1$2.TYPE]
		]
	};
})), require_webworker_asynciterable = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.webworker_asynciterable = void 0;
	let base_config_1$1 = require_base_config();
	exports.webworker_asynciterable = {
		libs: [],
		variables: [
			["FileSystemDirectoryHandleAsyncIterator", base_config_1$1.TYPE],
			["FileSystemDirectoryHandle", base_config_1$1.TYPE],
			["ReadableStreamAsyncIterator", base_config_1$1.TYPE],
			["ReadableStream", base_config_1$1.TYPE]
		]
	};
})), require_webworker_iterable = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.webworker_iterable = void 0;
	let base_config_1 = require_base_config();
	exports.webworker_iterable = {
		libs: [],
		variables: [
			["CSSNumericArray", base_config_1.TYPE],
			["CSSTransformValue", base_config_1.TYPE],
			["CSSUnparsedValue", base_config_1.TYPE],
			["Cache", base_config_1.TYPE],
			["CanvasPath", base_config_1.TYPE],
			["CanvasPathDrawingStyles", base_config_1.TYPE],
			["CookieStoreManager", base_config_1.TYPE],
			["DOMStringList", base_config_1.TYPE],
			["FileList", base_config_1.TYPE],
			["FontFaceSet", base_config_1.TYPE],
			["FormDataIterator", base_config_1.TYPE],
			["FormData", base_config_1.TYPE],
			["HeadersIterator", base_config_1.TYPE],
			["Headers", base_config_1.TYPE],
			["IDBDatabase", base_config_1.TYPE],
			["IDBObjectStore", base_config_1.TYPE],
			["ImageTrackList", base_config_1.TYPE],
			["MessageEvent", base_config_1.TYPE],
			["StylePropertyMapReadOnlyIterator", base_config_1.TYPE],
			["StylePropertyMapReadOnly", base_config_1.TYPE],
			["SubtleCrypto", base_config_1.TYPE],
			["URLSearchParamsIterator", base_config_1.TYPE],
			["URLSearchParams", base_config_1.TYPE],
			["WEBGL_draw_buffers", base_config_1.TYPE],
			["WEBGL_multi_draw", base_config_1.TYPE],
			["WebGL2RenderingContextBase", base_config_1.TYPE],
			["WebGL2RenderingContextOverloads", base_config_1.TYPE],
			["WebGLRenderingContextBase", base_config_1.TYPE],
			["WebGLRenderingContextOverloads", base_config_1.TYPE]
		]
	};
})), require_lib = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.lib = void 0;
	let decorators_1 = require_decorators(), decorators_legacy_1 = require_decorators_legacy(), dom_1 = require_dom(), dom_asynciterable_1 = require_dom_asynciterable(), dom_iterable_1 = require_dom_iterable(), es5_1 = require_es5(), es6_1 = require_es6(), es7_1 = require_es7(), es2015_1 = require_es2015(), es2015_collection_1 = require_es2015_collection(), es2015_core_1 = require_es2015_core(), es2015_generator_1 = require_es2015_generator(), es2015_iterable_1 = require_es2015_iterable(), es2015_promise_1 = require_es2015_promise(), es2015_proxy_1 = require_es2015_proxy(), es2015_reflect_1 = require_es2015_reflect(), es2015_symbol_1 = require_es2015_symbol(), es2015_symbol_wellknown_1 = require_es2015_symbol_wellknown(), es2016_1 = require_es2016(), es2016_array_include_1 = require_es2016_array_include(), es2016_full_1 = require_es2016_full(), es2016_intl_1 = require_es2016_intl(), es2017_1 = require_es2017(), es2017_arraybuffer_1 = require_es2017_arraybuffer(), es2017_date_1 = require_es2017_date(), es2017_full_1 = require_es2017_full(), es2017_intl_1 = require_es2017_intl(), es2017_object_1 = require_es2017_object(), es2017_sharedmemory_1 = require_es2017_sharedmemory(), es2017_string_1 = require_es2017_string(), es2017_typedarrays_1 = require_es2017_typedarrays(), es2018_1 = require_es2018(), es2018_asyncgenerator_1 = require_es2018_asyncgenerator(), es2018_asynciterable_1 = require_es2018_asynciterable(), es2018_full_1 = require_es2018_full(), es2018_intl_1 = require_es2018_intl(), es2018_promise_1 = require_es2018_promise(), es2018_regexp_1 = require_es2018_regexp(), es2019_1 = require_es2019(), es2019_array_1 = require_es2019_array(), es2019_full_1 = require_es2019_full(), es2019_intl_1 = require_es2019_intl(), es2019_object_1 = require_es2019_object(), es2019_string_1 = require_es2019_string(), es2019_symbol_1 = require_es2019_symbol(), es2020_1 = require_es2020(), es2020_bigint_1 = require_es2020_bigint(), es2020_date_1 = require_es2020_date(), es2020_full_1 = require_es2020_full(), es2020_intl_1 = require_es2020_intl(), es2020_number_1 = require_es2020_number(), es2020_promise_1 = require_es2020_promise(), es2020_sharedmemory_1 = require_es2020_sharedmemory(), es2020_string_1 = require_es2020_string(), es2020_symbol_wellknown_1 = require_es2020_symbol_wellknown(), es2021_1 = require_es2021(), es2021_full_1 = require_es2021_full(), es2021_intl_1 = require_es2021_intl(), es2021_promise_1 = require_es2021_promise(), es2021_string_1 = require_es2021_string(), es2021_weakref_1 = require_es2021_weakref(), es2022_1 = require_es2022(), es2022_array_1 = require_es2022_array(), es2022_error_1 = require_es2022_error(), es2022_full_1 = require_es2022_full(), es2022_intl_1 = require_es2022_intl(), es2022_object_1 = require_es2022_object(), es2022_regexp_1 = require_es2022_regexp(), es2022_string_1 = require_es2022_string(), es2023_1 = require_es2023(), es2023_array_1 = require_es2023_array(), es2023_collection_1 = require_es2023_collection(), es2023_full_1 = require_es2023_full(), es2023_intl_1 = require_es2023_intl(), es2024_1 = require_es2024(), es2024_arraybuffer_1 = require_es2024_arraybuffer(), es2024_collection_1 = require_es2024_collection(), es2024_full_1 = require_es2024_full(), es2024_object_1 = require_es2024_object(), es2024_promise_1 = require_es2024_promise(), es2024_regexp_1 = require_es2024_regexp(), es2024_sharedmemory_1 = require_es2024_sharedmemory(), es2024_string_1 = require_es2024_string(), esnext_1 = require_esnext(), esnext_array_1 = require_esnext_array(), esnext_asynciterable_1 = require_esnext_asynciterable(), esnext_bigint_1 = require_esnext_bigint(), esnext_collection_1 = require_esnext_collection(), esnext_decorators_1 = require_esnext_decorators(), esnext_disposable_1 = require_esnext_disposable(), esnext_error_1 = require_esnext_error(), esnext_float16_1 = require_esnext_float16(), esnext_full_1 = require_esnext_full(), esnext_intl_1 = require_esnext_intl(), esnext_iterator_1 = require_esnext_iterator(), esnext_object_1 = require_esnext_object(), esnext_promise_1 = require_esnext_promise(), esnext_regexp_1 = require_esnext_regexp(), esnext_sharedmemory_1 = require_esnext_sharedmemory(), esnext_string_1 = require_esnext_string(), esnext_symbol_1 = require_esnext_symbol(), esnext_weakref_1 = require_esnext_weakref(), lib_1$1 = require_lib$1(), scripthost_1 = require_scripthost(), webworker_1 = require_webworker(), webworker_asynciterable_1 = require_webworker_asynciterable(), webworker_importscripts_1 = require_webworker_importscripts(), webworker_iterable_1 = require_webworker_iterable();
	exports.lib = new Map([
		["es5", es5_1.es5],
		["es6", es6_1.es6],
		["es2015", es2015_1.es2015],
		["es7", es7_1.es7],
		["es2016", es2016_1.es2016],
		["es2017", es2017_1.es2017],
		["es2018", es2018_1.es2018],
		["es2019", es2019_1.es2019],
		["es2020", es2020_1.es2020],
		["es2021", es2021_1.es2021],
		["es2022", es2022_1.es2022],
		["es2023", es2023_1.es2023],
		["es2024", es2024_1.es2024],
		["esnext", esnext_1.esnext],
		["dom", dom_1.dom],
		["dom.iterable", dom_iterable_1.dom_iterable],
		["dom.asynciterable", dom_asynciterable_1.dom_asynciterable],
		["webworker", webworker_1.webworker],
		["webworker.importscripts", webworker_importscripts_1.webworker_importscripts],
		["webworker.iterable", webworker_iterable_1.webworker_iterable],
		["webworker.asynciterable", webworker_asynciterable_1.webworker_asynciterable],
		["scripthost", scripthost_1.scripthost],
		["es2015.core", es2015_core_1.es2015_core],
		["es2015.collection", es2015_collection_1.es2015_collection],
		["es2015.generator", es2015_generator_1.es2015_generator],
		["es2015.iterable", es2015_iterable_1.es2015_iterable],
		["es2015.promise", es2015_promise_1.es2015_promise],
		["es2015.proxy", es2015_proxy_1.es2015_proxy],
		["es2015.reflect", es2015_reflect_1.es2015_reflect],
		["es2015.symbol", es2015_symbol_1.es2015_symbol],
		["es2015.symbol.wellknown", es2015_symbol_wellknown_1.es2015_symbol_wellknown],
		["es2016.array.include", es2016_array_include_1.es2016_array_include],
		["es2016.intl", es2016_intl_1.es2016_intl],
		["es2017.arraybuffer", es2017_arraybuffer_1.es2017_arraybuffer],
		["es2017.date", es2017_date_1.es2017_date],
		["es2017.object", es2017_object_1.es2017_object],
		["es2017.sharedmemory", es2017_sharedmemory_1.es2017_sharedmemory],
		["es2017.string", es2017_string_1.es2017_string],
		["es2017.intl", es2017_intl_1.es2017_intl],
		["es2017.typedarrays", es2017_typedarrays_1.es2017_typedarrays],
		["es2018.asyncgenerator", es2018_asyncgenerator_1.es2018_asyncgenerator],
		["es2018.asynciterable", es2018_asynciterable_1.es2018_asynciterable],
		["es2018.intl", es2018_intl_1.es2018_intl],
		["es2018.promise", es2018_promise_1.es2018_promise],
		["es2018.regexp", es2018_regexp_1.es2018_regexp],
		["es2019.array", es2019_array_1.es2019_array],
		["es2019.object", es2019_object_1.es2019_object],
		["es2019.string", es2019_string_1.es2019_string],
		["es2019.symbol", es2019_symbol_1.es2019_symbol],
		["es2019.intl", es2019_intl_1.es2019_intl],
		["es2020.bigint", es2020_bigint_1.es2020_bigint],
		["es2020.date", es2020_date_1.es2020_date],
		["es2020.promise", es2020_promise_1.es2020_promise],
		["es2020.sharedmemory", es2020_sharedmemory_1.es2020_sharedmemory],
		["es2020.string", es2020_string_1.es2020_string],
		["es2020.symbol.wellknown", es2020_symbol_wellknown_1.es2020_symbol_wellknown],
		["es2020.intl", es2020_intl_1.es2020_intl],
		["es2020.number", es2020_number_1.es2020_number],
		["es2021.promise", es2021_promise_1.es2021_promise],
		["es2021.string", es2021_string_1.es2021_string],
		["es2021.weakref", es2021_weakref_1.es2021_weakref],
		["es2021.intl", es2021_intl_1.es2021_intl],
		["es2022.array", es2022_array_1.es2022_array],
		["es2022.error", es2022_error_1.es2022_error],
		["es2022.intl", es2022_intl_1.es2022_intl],
		["es2022.object", es2022_object_1.es2022_object],
		["es2022.string", es2022_string_1.es2022_string],
		["es2022.regexp", es2022_regexp_1.es2022_regexp],
		["es2023.array", es2023_array_1.es2023_array],
		["es2023.collection", es2023_collection_1.es2023_collection],
		["es2023.intl", es2023_intl_1.es2023_intl],
		["es2024.arraybuffer", es2024_arraybuffer_1.es2024_arraybuffer],
		["es2024.collection", es2024_collection_1.es2024_collection],
		["es2024.object", es2024_object_1.es2024_object],
		["es2024.promise", es2024_promise_1.es2024_promise],
		["es2024.regexp", es2024_regexp_1.es2024_regexp],
		["es2024.sharedmemory", es2024_sharedmemory_1.es2024_sharedmemory],
		["es2024.string", es2024_string_1.es2024_string],
		["esnext.array", esnext_array_1.esnext_array],
		["esnext.collection", esnext_collection_1.esnext_collection],
		["esnext.symbol", esnext_symbol_1.esnext_symbol],
		["esnext.asynciterable", esnext_asynciterable_1.esnext_asynciterable],
		["esnext.intl", esnext_intl_1.esnext_intl],
		["esnext.disposable", esnext_disposable_1.esnext_disposable],
		["esnext.bigint", esnext_bigint_1.esnext_bigint],
		["esnext.string", esnext_string_1.esnext_string],
		["esnext.promise", esnext_promise_1.esnext_promise],
		["esnext.weakref", esnext_weakref_1.esnext_weakref],
		["esnext.decorators", esnext_decorators_1.esnext_decorators],
		["esnext.object", esnext_object_1.esnext_object],
		["esnext.regexp", esnext_regexp_1.esnext_regexp],
		["esnext.iterator", esnext_iterator_1.esnext_iterator],
		["esnext.float16", esnext_float16_1.esnext_float16],
		["esnext.error", esnext_error_1.esnext_error],
		["esnext.sharedmemory", esnext_sharedmemory_1.esnext_sharedmemory],
		["decorators", decorators_1.decorators],
		["decorators.legacy", decorators_legacy_1.decorators_legacy],
		["es2016.full", es2016_full_1.es2016_full],
		["es2017.full", es2017_full_1.es2017_full],
		["es2018.full", es2018_full_1.es2018_full],
		["es2019.full", es2019_full_1.es2019_full],
		["es2020.full", es2020_full_1.es2020_full],
		["es2021.full", es2021_full_1.es2021_full],
		["es2022.full", es2022_full_1.es2022_full],
		["es2023.full", es2023_full_1.es2023_full],
		["es2024.full", es2024_full_1.es2024_full],
		["esnext.full", esnext_full_1.esnext_full],
		["lib", lib_1$1.lib]
	]);
})), require_Reference = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.Reference = exports.ReferenceTypeFlag = exports.ReferenceFlag = void 0;
	let ID_1$1 = require_ID();
	var ReferenceFlag;
	(function(ReferenceFlag$1) {
		ReferenceFlag$1[ReferenceFlag$1.Read = 1] = "Read", ReferenceFlag$1[ReferenceFlag$1.Write = 2] = "Write", ReferenceFlag$1[ReferenceFlag$1.ReadWrite = 3] = "ReadWrite";
	})(ReferenceFlag || (exports.ReferenceFlag = ReferenceFlag = {}));
	let generator$2 = (0, ID_1$1.createIdGenerator)();
	var ReferenceTypeFlag;
	(function(ReferenceTypeFlag$1) {
		ReferenceTypeFlag$1[ReferenceTypeFlag$1.Value = 1] = "Value", ReferenceTypeFlag$1[ReferenceTypeFlag$1.Type = 2] = "Type";
	})(ReferenceTypeFlag || (exports.ReferenceTypeFlag = ReferenceTypeFlag = {}));
	var Reference = class {
		$id = generator$2();
		#flag;
		from;
		identifier;
		init;
		maybeImplicitGlobal;
		resolved;
		writeExpr;
		#referenceType;
		constructor(identifier, scope, flag, writeExpr, maybeImplicitGlobal, init, referenceType = ReferenceTypeFlag.Value) {
			this.identifier = identifier, this.from = scope, this.resolved = null, this.#flag = flag, this.isWrite() && (this.writeExpr = writeExpr, this.init = init), this.maybeImplicitGlobal = maybeImplicitGlobal, this.#referenceType = referenceType;
		}
		get isTypeReference() {
			return (this.#referenceType & ReferenceTypeFlag.Type) !== 0;
		}
		get isValueReference() {
			return (this.#referenceType & ReferenceTypeFlag.Value) !== 0;
		}
		isWrite() {
			return !!(this.#flag & ReferenceFlag.Write);
		}
		isRead() {
			return !!(this.#flag & ReferenceFlag.Read);
		}
		isReadOnly() {
			return this.#flag === ReferenceFlag.Read;
		}
		isWriteOnly() {
			return this.#flag === ReferenceFlag.Write;
		}
		isReadWrite() {
			return this.#flag === ReferenceFlag.ReadWrite;
		}
	};
	exports.Reference = Reference;
})), require_VariableBase = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.VariableBase = void 0;
	let generator$1 = (0, require_ID().createIdGenerator)();
	var VariableBase = class {
		$id = generator$1();
		defs = [];
		eslintUsed = !1;
		identifiers = [];
		name;
		references = [];
		scope;
		constructor(name, scope) {
			this.name = name, this.scope = scope;
		}
	};
	exports.VariableBase = VariableBase;
})), require_ESLintScopeVariable = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ESLintScopeVariable = void 0;
	let VariableBase_1$1 = require_VariableBase();
	var ESLintScopeVariable = class extends VariableBase_1$1.VariableBase {
		writeable;
		eslintExplicitGlobal;
		eslintImplicitGlobalSetting;
		eslintExplicitGlobalComments;
	};
	exports.ESLintScopeVariable = ESLintScopeVariable;
})), require_ImplicitLibVariable = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ImplicitLibVariable = void 0;
	let ESLintScopeVariable_1$1 = require_ESLintScopeVariable();
	var ImplicitLibVariable = class extends ESLintScopeVariable_1$1.ESLintScopeVariable {
		isTypeVariable;
		isValueVariable;
		constructor(scope, name, { eslintImplicitGlobalSetting, isTypeVariable, isValueVariable, writeable }) {
			super(name, scope), this.isTypeVariable = isTypeVariable ?? !1, this.isValueVariable = isValueVariable ?? !1, this.writeable = writeable ?? !1, this.eslintImplicitGlobalSetting = eslintImplicitGlobalSetting ?? "readonly";
		}
	};
	exports.ImplicitLibVariable = ImplicitLibVariable;
})), require_Variable = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.Variable = void 0;
	let VariableBase_1 = require_VariableBase();
	var Variable = class extends VariableBase_1.VariableBase {
		get isTypeVariable() {
			return this.defs.length === 0 ? !0 : this.defs.some((def) => def.isTypeDefinition);
		}
		get isValueVariable() {
			return this.defs.length === 0 ? !0 : this.defs.some((def) => def.isVariableDefinition);
		}
	};
	exports.Variable = Variable;
})), require_variable = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.Variable = exports.ImplicitLibVariable = exports.ESLintScopeVariable = void 0;
	var ESLintScopeVariable_1 = require_ESLintScopeVariable();
	Object.defineProperty(exports, "ESLintScopeVariable", {
		enumerable: !0,
		get: function() {
			return ESLintScopeVariable_1.ESLintScopeVariable;
		}
	});
	var ImplicitLibVariable_1$1 = require_ImplicitLibVariable();
	Object.defineProperty(exports, "ImplicitLibVariable", {
		enumerable: !0,
		get: function() {
			return ImplicitLibVariable_1$1.ImplicitLibVariable;
		}
	});
	var Variable_1 = require_Variable();
	Object.defineProperty(exports, "Variable", {
		enumerable: !0,
		get: function() {
			return Variable_1.Variable;
		}
	});
})), require_ScopeType = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ScopeType = void 0;
	var ScopeType;
	(function(ScopeType$1) {
		ScopeType$1.block = "block", ScopeType$1.catch = "catch", ScopeType$1.class = "class", ScopeType$1.classFieldInitializer = "class-field-initializer", ScopeType$1.classStaticBlock = "class-static-block", ScopeType$1.conditionalType = "conditionalType", ScopeType$1.for = "for", ScopeType$1.function = "function", ScopeType$1.functionExpressionName = "function-expression-name", ScopeType$1.functionType = "functionType", ScopeType$1.global = "global", ScopeType$1.mappedType = "mappedType", ScopeType$1.module = "module", ScopeType$1.switch = "switch", ScopeType$1.tsEnum = "tsEnum", ScopeType$1.tsModule = "tsModule", ScopeType$1.type = "type", ScopeType$1.with = "with";
	})(ScopeType || (exports.ScopeType = ScopeType = {}));
})), require_ScopeBase = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ScopeBase = void 0;
	let types_1$7 = require_dist$1(), assert_1$4 = require_assert(), definition_1$5 = require_definition(), ID_1 = require_ID(), Reference_1$2 = require_Reference(), variable_1$1 = require_variable(), ScopeType_1$18 = require_ScopeType(), ImplicitLibVariable_1 = require_ImplicitLibVariable();
	function isStrictScope(scope, block, isMethodDefinition) {
		let body;
		if (scope.upper?.isStrict || isMethodDefinition || scope.type === ScopeType_1$18.ScopeType.class || scope.type === ScopeType_1$18.ScopeType.conditionalType || scope.type === ScopeType_1$18.ScopeType.functionType || scope.type === ScopeType_1$18.ScopeType.mappedType || scope.type === ScopeType_1$18.ScopeType.module || scope.type === ScopeType_1$18.ScopeType.tsEnum || scope.type === ScopeType_1$18.ScopeType.tsModule || scope.type === ScopeType_1$18.ScopeType.type) return !0;
		if (scope.type === ScopeType_1$18.ScopeType.block || scope.type === ScopeType_1$18.ScopeType.switch) return !1;
		if (scope.type === ScopeType_1$18.ScopeType.function) {
			let functionBody = block;
			switch (functionBody.type) {
				case types_1$7.AST_NODE_TYPES.ArrowFunctionExpression:
					if (functionBody.body.type !== types_1$7.AST_NODE_TYPES.BlockStatement) return !1;
					body = functionBody.body;
					break;
				case types_1$7.AST_NODE_TYPES.Program:
					body = functionBody;
					break;
				default: body = functionBody.body;
			}
			if (!body) return !1;
		} else if (scope.type === ScopeType_1$18.ScopeType.global) body = block;
		else return !1;
		for (let stmt of body.body) {
			if (stmt.type !== types_1$7.AST_NODE_TYPES.ExpressionStatement) break;
			if (stmt.directive === "use strict") return !0;
			let expr = stmt.expression;
			if (expr.type !== types_1$7.AST_NODE_TYPES.Literal) break;
			if (expr.raw === "\"use strict\"" || expr.raw === "'use strict'" || expr.value === "use strict") return !0;
		}
		return !1;
	}
	function registerScope(scopeManager, scope) {
		scopeManager.scopes.push(scope);
		let scopes = scopeManager.nodeToScope.get(scope.block);
		scopes ? scopes.push(scope) : scopeManager.nodeToScope.set(scope.block, [scope]);
	}
	let generator = (0, ID_1.createIdGenerator)(), VARIABLE_SCOPE_TYPES = new Set([
		ScopeType_1$18.ScopeType.classFieldInitializer,
		ScopeType_1$18.ScopeType.classStaticBlock,
		ScopeType_1$18.ScopeType.function,
		ScopeType_1$18.ScopeType.global,
		ScopeType_1$18.ScopeType.module,
		ScopeType_1$18.ScopeType.tsModule
	]);
	var ScopeBase = class {
		$id = generator();
		block;
		childScopes = [];
		#declaredVariables;
		#dynamic;
		functionExpressionScope = !1;
		isStrict;
		leftToResolve = [];
		references = [];
		set = /* @__PURE__ */ new Map();
		through = [];
		type;
		upper;
		variables = [];
		#dynamicCloseRef = (ref) => {
			let current = this;
			do
				current.through.push(ref), current = current.upper;
			while (current);
		};
		#globalCloseRef = (ref, scopeManager) => {
			this.shouldStaticallyCloseForGlobal(ref, scopeManager) ? this.#staticCloseRef(ref) : this.#dynamicCloseRef(ref);
		};
		#staticCloseRef = (ref) => {
			let resolve = () => {
				let name = ref.identifier.name, variable = this.set.get(name);
				if (!variable || !this.isValidResolution(ref, variable)) return !1;
				let isValidTypeReference = ref.isTypeReference && variable.isTypeVariable, isValidValueReference = ref.isValueReference && variable.isValueVariable;
				return !isValidTypeReference && !isValidValueReference ? !1 : (variable.references.push(ref), ref.resolved = variable, !0);
			};
			resolve() || this.delegateToUpperScope(ref);
		};
		variableScope;
		constructor(scopeManager, type, upperScope, block, isMethodDefinition) {
			let upperScopeAsScopeBase = upperScope;
			this.type = type, this.#dynamic = this.type === ScopeType_1$18.ScopeType.global || this.type === ScopeType_1$18.ScopeType.with, this.block = block, this.variableScope = this.isVariableScope() ? this : upperScopeAsScopeBase.variableScope, this.upper = upperScope, this.isStrict = isStrictScope(this, block, isMethodDefinition), upperScopeAsScopeBase?.childScopes.push(this), this.#declaredVariables = scopeManager.declaredVariables, registerScope(scopeManager, this);
		}
		isVariableScope() {
			return VARIABLE_SCOPE_TYPES.has(this.type);
		}
		shouldStaticallyCloseForGlobal(ref, scopeManager) {
			let name = ref.identifier.name, variable = this.set.get(name);
			if (!variable) return !1;
			if (variable instanceof ImplicitLibVariable_1.ImplicitLibVariable || scopeManager.isModule()) return !0;
			let defs = variable.defs;
			return defs.length > 0 && defs.every((def) => !(def.type === definition_1$5.DefinitionType.Variable && def.parent.kind === "var"));
		}
		close(scopeManager) {
			let closeRef;
			return closeRef = this.shouldStaticallyClose() ? this.#staticCloseRef : this.type === "global" ? this.#globalCloseRef : this.#dynamicCloseRef, (0, assert_1$4.assert)(this.leftToResolve), this.leftToResolve.forEach((ref) => closeRef(ref, scopeManager)), this.leftToResolve = null, this.upper;
		}
		shouldStaticallyClose() {
			return !this.#dynamic;
		}
		defineVariable(nameOrVariable, set, variables, node, def) {
			let name = typeof nameOrVariable == "string" ? nameOrVariable : nameOrVariable.name, variable = set.get(name);
			variable ? variable instanceof ImplicitLibVariable_1.ImplicitLibVariable && nameOrVariable instanceof ImplicitLibVariable_1.ImplicitLibVariable && (variable.isTypeVariable ||= nameOrVariable.isTypeVariable, variable.isValueVariable ||= nameOrVariable.isValueVariable) : (variable = typeof nameOrVariable == "string" ? new variable_1$1.Variable(name, this) : nameOrVariable, set.set(name, variable), variables.push(variable)), def && (variable.defs.push(def), this.addDeclaredVariablesOfNode(variable, def.node), this.addDeclaredVariablesOfNode(variable, def.parent)), node && variable.identifiers.push(node);
		}
		delegateToUpperScope(ref) {
			this.upper?.leftToResolve?.push(ref), this.through.push(ref);
		}
		isValidResolution(_ref, _variable) {
			return !0;
		}
		addDeclaredVariablesOfNode(variable, node) {
			if (node == null) return;
			let variables = this.#declaredVariables.get(node);
			variables ?? (variables = [], this.#declaredVariables.set(node, variables)), variables.includes(variable) || variables.push(variable);
		}
		defineIdentifier(node, def) {
			this.defineVariable(node.name, this.set, this.variables, node, def);
		}
		defineLiteralIdentifier(node, def) {
			this.defineVariable(node.value, this.set, this.variables, null, def);
		}
		referenceDualValueType(node) {
			let ref = new Reference_1$2.Reference(node, this, Reference_1$2.ReferenceFlag.Read, null, null, !1, Reference_1$2.ReferenceTypeFlag.Type | Reference_1$2.ReferenceTypeFlag.Value);
			this.references.push(ref), this.leftToResolve?.push(ref);
		}
		referenceType(node) {
			let ref = new Reference_1$2.Reference(node, this, Reference_1$2.ReferenceFlag.Read, null, null, !1, Reference_1$2.ReferenceTypeFlag.Type);
			this.references.push(ref), this.leftToResolve?.push(ref);
		}
		referenceValue(node, assign = Reference_1$2.ReferenceFlag.Read, writeExpr, maybeImplicitGlobal, init = !1) {
			let ref = new Reference_1$2.Reference(node, this, assign, writeExpr, maybeImplicitGlobal, init, Reference_1$2.ReferenceTypeFlag.Value);
			this.references.push(ref), this.leftToResolve?.push(ref);
		}
	};
	exports.ScopeBase = ScopeBase;
})), require_BlockScope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.BlockScope = void 0;
	let ScopeBase_1$17 = require_ScopeBase(), ScopeType_1$17 = require_ScopeType();
	var BlockScope = class extends ScopeBase_1$17.ScopeBase {
		constructor(scopeManager, upperScope, block) {
			super(scopeManager, ScopeType_1$17.ScopeType.block, upperScope, block, !1);
		}
	};
	exports.BlockScope = BlockScope;
})), require_CatchScope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.CatchScope = void 0;
	let ScopeBase_1$16 = require_ScopeBase(), ScopeType_1$16 = require_ScopeType();
	var CatchScope = class extends ScopeBase_1$16.ScopeBase {
		constructor(scopeManager, upperScope, block) {
			super(scopeManager, ScopeType_1$16.ScopeType.catch, upperScope, block, !1);
		}
	};
	exports.CatchScope = CatchScope;
})), require_ClassFieldInitializerScope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ClassFieldInitializerScope = void 0;
	let ScopeBase_1$15 = require_ScopeBase(), ScopeType_1$15 = require_ScopeType();
	var ClassFieldInitializerScope = class extends ScopeBase_1$15.ScopeBase {
		constructor(scopeManager, upperScope, block) {
			super(scopeManager, ScopeType_1$15.ScopeType.classFieldInitializer, upperScope, block, !1);
		}
	};
	exports.ClassFieldInitializerScope = ClassFieldInitializerScope;
})), require_ClassScope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ClassScope = void 0;
	let ScopeBase_1$14 = require_ScopeBase(), ScopeType_1$14 = require_ScopeType();
	var ClassScope = class extends ScopeBase_1$14.ScopeBase {
		constructor(scopeManager, upperScope, block) {
			super(scopeManager, ScopeType_1$14.ScopeType.class, upperScope, block, !1);
		}
	};
	exports.ClassScope = ClassScope;
})), require_ConditionalTypeScope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ConditionalTypeScope = void 0;
	let ScopeBase_1$13 = require_ScopeBase(), ScopeType_1$13 = require_ScopeType();
	var ConditionalTypeScope = class extends ScopeBase_1$13.ScopeBase {
		constructor(scopeManager, upperScope, block) {
			super(scopeManager, ScopeType_1$13.ScopeType.conditionalType, upperScope, block, !1);
		}
	};
	exports.ConditionalTypeScope = ConditionalTypeScope;
})), require_ForScope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ForScope = void 0;
	let ScopeBase_1$12 = require_ScopeBase(), ScopeType_1$12 = require_ScopeType();
	var ForScope = class extends ScopeBase_1$12.ScopeBase {
		constructor(scopeManager, upperScope, block) {
			super(scopeManager, ScopeType_1$12.ScopeType.for, upperScope, block, !1);
		}
	};
	exports.ForScope = ForScope;
})), require_FunctionExpressionNameScope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.FunctionExpressionNameScope = void 0;
	let definition_1$4 = require_definition(), ScopeBase_1$11 = require_ScopeBase(), ScopeType_1$11 = require_ScopeType();
	var FunctionExpressionNameScope = class extends ScopeBase_1$11.ScopeBase {
		functionExpressionScope;
		constructor(scopeManager, upperScope, block) {
			super(scopeManager, ScopeType_1$11.ScopeType.functionExpressionName, upperScope, block, !1), block.id && this.defineIdentifier(block.id, new definition_1$4.FunctionNameDefinition(block.id, block)), this.functionExpressionScope = !0;
		}
	};
	exports.FunctionExpressionNameScope = FunctionExpressionNameScope;
})), require_FunctionScope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.FunctionScope = void 0;
	let types_1$6 = require_dist$1(), ScopeBase_1$10 = require_ScopeBase(), ScopeType_1$10 = require_ScopeType();
	var FunctionScope = class extends ScopeBase_1$10.ScopeBase {
		constructor(scopeManager, upperScope, block, isMethodDefinition) {
			super(scopeManager, ScopeType_1$10.ScopeType.function, upperScope, block, isMethodDefinition), this.block.type !== types_1$6.AST_NODE_TYPES.ArrowFunctionExpression && this.defineVariable("arguments", this.set, this.variables, null, null);
		}
		isValidResolution(ref, variable) {
			if (this.block.type === types_1$6.AST_NODE_TYPES.Program) return !0;
			let bodyStart = this.block.body?.range[0] ?? -1;
			return !(variable.scope === this && ref.identifier.range[0] < bodyStart && variable.defs.every((d) => d.name.range[0] >= bodyStart));
		}
	};
	exports.FunctionScope = FunctionScope;
})), require_FunctionTypeScope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.FunctionTypeScope = void 0;
	let ScopeBase_1$9 = require_ScopeBase(), ScopeType_1$9 = require_ScopeType();
	var FunctionTypeScope = class extends ScopeBase_1$9.ScopeBase {
		constructor(scopeManager, upperScope, block) {
			super(scopeManager, ScopeType_1$9.ScopeType.functionType, upperScope, block, !1);
		}
	};
	exports.FunctionTypeScope = FunctionTypeScope;
})), require_GlobalScope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.GlobalScope = void 0;
	let types_1$5 = require_dist$1(), assert_1$3 = require_assert(), ImplicitGlobalVariableDefinition_1 = require_ImplicitGlobalVariableDefinition(), variable_1 = require_variable(), ScopeBase_1$8 = require_ScopeBase(), ScopeType_1$8 = require_ScopeType();
	var GlobalScope = class extends ScopeBase_1$8.ScopeBase {
		implicit;
		constructor(scopeManager, block) {
			super(scopeManager, ScopeType_1$8.ScopeType.global, null, block, !1), this.implicit = {
				leftToBeResolved: [],
				set: /* @__PURE__ */ new Map(),
				variables: []
			};
		}
		close(scopeManager) {
			(0, assert_1$3.assert)(this.leftToResolve);
			for (let ref of this.leftToResolve) if (ref.maybeImplicitGlobal && !this.set.has(ref.identifier.name)) {
				let info = ref.maybeImplicitGlobal, node = info.pattern;
				node.type === types_1$5.AST_NODE_TYPES.Identifier && this.defineVariable(node.name, this.implicit.set, this.implicit.variables, node, new ImplicitGlobalVariableDefinition_1.ImplicitGlobalVariableDefinition(info.pattern, info.node));
			}
			return this.implicit.leftToBeResolved = this.leftToResolve, super.close(scopeManager);
		}
		defineImplicitVariable(name, options) {
			this.defineVariable(new variable_1.ImplicitLibVariable(this, name, options), this.set, this.variables, null, null);
		}
	};
	exports.GlobalScope = GlobalScope;
})), require_MappedTypeScope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.MappedTypeScope = void 0;
	let ScopeBase_1$7 = require_ScopeBase(), ScopeType_1$7 = require_ScopeType();
	var MappedTypeScope = class extends ScopeBase_1$7.ScopeBase {
		constructor(scopeManager, upperScope, block) {
			super(scopeManager, ScopeType_1$7.ScopeType.mappedType, upperScope, block, !1);
		}
	};
	exports.MappedTypeScope = MappedTypeScope;
})), require_ModuleScope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ModuleScope = void 0;
	let ScopeBase_1$6 = require_ScopeBase(), ScopeType_1$6 = require_ScopeType();
	var ModuleScope = class extends ScopeBase_1$6.ScopeBase {
		constructor(scopeManager, upperScope, block) {
			super(scopeManager, ScopeType_1$6.ScopeType.module, upperScope, block, !1);
		}
	};
	exports.ModuleScope = ModuleScope;
})), require_Scope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 });
})), require_SwitchScope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.SwitchScope = void 0;
	let ScopeBase_1$5 = require_ScopeBase(), ScopeType_1$5 = require_ScopeType();
	var SwitchScope = class extends ScopeBase_1$5.ScopeBase {
		constructor(scopeManager, upperScope, block) {
			super(scopeManager, ScopeType_1$5.ScopeType.switch, upperScope, block, !1);
		}
	};
	exports.SwitchScope = SwitchScope;
})), require_TSEnumScope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.TSEnumScope = void 0;
	let ScopeBase_1$4 = require_ScopeBase(), ScopeType_1$4 = require_ScopeType();
	var TSEnumScope = class extends ScopeBase_1$4.ScopeBase {
		constructor(scopeManager, upperScope, block) {
			super(scopeManager, ScopeType_1$4.ScopeType.tsEnum, upperScope, block, !1);
		}
	};
	exports.TSEnumScope = TSEnumScope;
})), require_TSModuleScope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.TSModuleScope = void 0;
	let ScopeBase_1$3 = require_ScopeBase(), ScopeType_1$3 = require_ScopeType();
	var TSModuleScope = class extends ScopeBase_1$3.ScopeBase {
		constructor(scopeManager, upperScope, block) {
			super(scopeManager, ScopeType_1$3.ScopeType.tsModule, upperScope, block, !1);
		}
	};
	exports.TSModuleScope = TSModuleScope;
})), require_TypeScope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.TypeScope = void 0;
	let ScopeBase_1$2 = require_ScopeBase(), ScopeType_1$2 = require_ScopeType();
	var TypeScope = class extends ScopeBase_1$2.ScopeBase {
		constructor(scopeManager, upperScope, block) {
			super(scopeManager, ScopeType_1$2.ScopeType.type, upperScope, block, !1);
		}
	};
	exports.TypeScope = TypeScope;
})), require_WithScope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.WithScope = void 0;
	let assert_1$2 = require_assert(), ScopeBase_1$1 = require_ScopeBase(), ScopeType_1$1 = require_ScopeType();
	var WithScope = class extends ScopeBase_1$1.ScopeBase {
		constructor(scopeManager, upperScope, block) {
			super(scopeManager, ScopeType_1$1.ScopeType.with, upperScope, block, !1);
		}
		close(scopeManager) {
			return this.shouldStaticallyClose() ? super.close(scopeManager) : ((0, assert_1$2.assert)(this.leftToResolve), this.leftToResolve.forEach((ref) => this.delegateToUpperScope(ref)), this.leftToResolve = null, this.upper);
		}
	};
	exports.WithScope = WithScope;
})), require_scope = /* @__PURE__ */ __commonJSMin(((exports) => {
	var __createBinding$1 = exports && exports.__createBinding || (Object.create ? (function(o, m, k, k2) {
		k2 === void 0 && (k2 = k);
		var desc = Object.getOwnPropertyDescriptor(m, k);
		(!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) && (desc = {
			enumerable: !0,
			get: function() {
				return m[k];
			}
		}), Object.defineProperty(o, k2, desc);
	}) : (function(o, m, k, k2) {
		k2 === void 0 && (k2 = k), o[k2] = m[k];
	})), __exportStar$1 = exports && exports.__exportStar || function(m, exports$1) {
		for (var p in m) p !== "default" && !Object.prototype.hasOwnProperty.call(exports$1, p) && __createBinding$1(exports$1, m, p);
	};
	Object.defineProperty(exports, "__esModule", { value: !0 }), __exportStar$1(require_BlockScope(), exports), __exportStar$1(require_CatchScope(), exports), __exportStar$1(require_ClassFieldInitializerScope(), exports), __exportStar$1(require_ClassScope(), exports), __exportStar$1(require_ConditionalTypeScope(), exports), __exportStar$1(require_ForScope(), exports), __exportStar$1(require_FunctionExpressionNameScope(), exports), __exportStar$1(require_FunctionScope(), exports), __exportStar$1(require_FunctionTypeScope(), exports), __exportStar$1(require_GlobalScope(), exports), __exportStar$1(require_MappedTypeScope(), exports), __exportStar$1(require_ModuleScope(), exports), __exportStar$1(require_Scope(), exports), __exportStar$1(require_ScopeType(), exports), __exportStar$1(require_SwitchScope(), exports), __exportStar$1(require_TSEnumScope(), exports), __exportStar$1(require_TSModuleScope(), exports), __exportStar$1(require_TypeScope(), exports), __exportStar$1(require_WithScope(), exports);
})), require_VisitorBase = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.VisitorBase = void 0;
	let visitor_keys_1$1 = require_dist$2();
	function isObject(obj) {
		return typeof obj == "object" && !!obj;
	}
	function isNode(node) {
		return isObject(node) && typeof node.type == "string";
	}
	var VisitorBase = class {
		#childVisitorKeys;
		#visitChildrenEvenIfSelectorExists;
		constructor(options) {
			this.#childVisitorKeys = options.childVisitorKeys ?? visitor_keys_1$1.visitorKeys, this.#visitChildrenEvenIfSelectorExists = options.visitChildrenEvenIfSelectorExists ?? !1;
		}
		visitChildren(node, excludeArr = []) {
			if (node?.type == null) return;
			let exclude = new Set([...excludeArr, "parent"]), children = this.#childVisitorKeys[node.type] ?? Object.keys(node);
			for (let key of children) {
				if (exclude.has(key)) continue;
				let child = node[key];
				if (child) if (Array.isArray(child)) for (let subChild of child) isNode(subChild) && this.visit(subChild);
				else isNode(child) && this.visit(child);
			}
		}
		visit(node) {
			if (node?.type == null) return;
			let visitor = this[node.type];
			visitor && (visitor.call(this, node), !this.#visitChildrenEvenIfSelectorExists) || this.visitChildren(node);
		}
	};
	exports.VisitorBase = VisitorBase;
})), require_PatternVisitor = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.PatternVisitor = void 0;
	let types_1$4 = require_dist$1(), VisitorBase_1$1 = require_VisitorBase();
	var PatternVisitor = class extends VisitorBase_1$1.VisitorBase {
		#assignments = [];
		#callback;
		#restElements = [];
		#rootPattern;
		rightHandNodes = [];
		constructor(options, rootPattern, callback) {
			super(options), this.#rootPattern = rootPattern, this.#callback = callback;
		}
		static isPattern(node) {
			let nodeType = node.type;
			return nodeType === types_1$4.AST_NODE_TYPES.Identifier || nodeType === types_1$4.AST_NODE_TYPES.ObjectPattern || nodeType === types_1$4.AST_NODE_TYPES.ArrayPattern || nodeType === types_1$4.AST_NODE_TYPES.SpreadElement || nodeType === types_1$4.AST_NODE_TYPES.RestElement || nodeType === types_1$4.AST_NODE_TYPES.AssignmentPattern;
		}
		ArrayExpression(node) {
			node.elements.forEach(this.visit, this);
		}
		ArrayPattern(pattern) {
			for (let element of pattern.elements) this.visit(element);
		}
		AssignmentExpression(node) {
			this.#assignments.push(node), this.visit(node.left), this.rightHandNodes.push(node.right), this.#assignments.pop();
		}
		AssignmentPattern(pattern) {
			this.#assignments.push(pattern), this.visit(pattern.left), this.rightHandNodes.push(pattern.right), this.#assignments.pop();
		}
		CallExpression(node) {
			node.arguments.forEach((a) => {
				this.rightHandNodes.push(a);
			}), this.visit(node.callee);
		}
		Decorator() {}
		Identifier(pattern) {
			let lastRestElement = this.#restElements.at(-1);
			this.#callback(pattern, {
				assignments: this.#assignments,
				rest: lastRestElement?.argument === pattern,
				topLevel: pattern === this.#rootPattern
			});
		}
		MemberExpression(node) {
			node.computed && this.rightHandNodes.push(node.property), this.rightHandNodes.push(node.object);
		}
		Property(property) {
			property.computed && this.rightHandNodes.push(property.key), this.visit(property.value);
		}
		RestElement(pattern) {
			this.#restElements.push(pattern), this.visit(pattern.argument), this.#restElements.pop();
		}
		SpreadElement(node) {
			this.visit(node.argument);
		}
		TSTypeAnnotation() {}
	};
	exports.PatternVisitor = PatternVisitor;
})), require_Visitor = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.VisitorBase = exports.Visitor = void 0;
	let PatternVisitor_1$2 = require_PatternVisitor(), VisitorBase_1 = require_VisitorBase();
	exports.Visitor = class Visitor extends VisitorBase_1.VisitorBase {
		#options;
		constructor(optionsOrVisitor) {
			super(optionsOrVisitor instanceof Visitor ? optionsOrVisitor.#options : optionsOrVisitor), this.#options = optionsOrVisitor instanceof Visitor ? optionsOrVisitor.#options : optionsOrVisitor;
		}
		visitPattern(node, callback, options = { processRightHandNodes: !1 }) {
			let visitor = new PatternVisitor_1$2.PatternVisitor(this.#options, node, callback);
			visitor.visit(node), options.processRightHandNodes && visitor.rightHandNodes.forEach(this.visit, this);
		}
	};
	var VisitorBase_2 = require_VisitorBase();
	Object.defineProperty(exports, "VisitorBase", {
		enumerable: !0,
		get: function() {
			return VisitorBase_2.VisitorBase;
		}
	});
})), require_TypeVisitor = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.TypeVisitor = void 0;
	let types_1$3 = require_dist$1(), definition_1$3 = require_definition(), scope_1$1 = require_scope(), Visitor_1$5 = require_Visitor();
	exports.TypeVisitor = class TypeVisitor extends Visitor_1$5.Visitor {
		#referencer;
		constructor(referencer) {
			super(referencer), this.#referencer = referencer;
		}
		static visit(referencer, node) {
			new TypeVisitor(referencer).visit(node);
		}
		visitFunctionType(node) {
			this.#referencer.scopeManager.nestFunctionTypeScope(node), this.visit(node.typeParameters);
			for (let param of node.params) {
				let didVisitAnnotation = !1;
				this.visitPattern(param, (pattern, info) => {
					this.#referencer.currentScope().defineIdentifier(pattern, new definition_1$3.ParameterDefinition(pattern, node, info.rest)), pattern.typeAnnotation && (this.visit(pattern.typeAnnotation), didVisitAnnotation = !0);
				}), !didVisitAnnotation && "typeAnnotation" in param && this.visit(param.typeAnnotation);
			}
			this.visit(node.returnType), this.#referencer.close(node);
		}
		visitPropertyKey(node) {
			node.computed && this.#referencer.visit(node.key);
		}
		Identifier(node) {
			this.#referencer.currentScope().referenceType(node);
		}
		MemberExpression(node) {
			this.visit(node.object);
		}
		TSCallSignatureDeclaration(node) {
			this.visitFunctionType(node);
		}
		TSConditionalType(node) {
			this.#referencer.scopeManager.nestConditionalTypeScope(node), this.visitChildren(node, ["falseType"]), this.#referencer.close(node), this.visit(node.falseType);
		}
		TSConstructorType(node) {
			this.visitFunctionType(node);
		}
		TSConstructSignatureDeclaration(node) {
			this.visitFunctionType(node);
		}
		TSFunctionType(node) {
			this.visitFunctionType(node);
		}
		TSImportType(node) {
			this.visit(node.typeArguments);
		}
		TSIndexSignature(node) {
			for (let param of node.parameters) param.type === types_1$3.AST_NODE_TYPES.Identifier && this.visit(param.typeAnnotation);
			this.visit(node.typeAnnotation);
		}
		TSInferType(node) {
			let typeParameter = node.typeParameter, scope = this.#referencer.currentScope();
			if (scope.type === scope_1$1.ScopeType.functionType || scope.type === scope_1$1.ScopeType.mappedType) {
				let currentScope = scope.upper;
				for (; currentScope;) {
					if (currentScope.type === scope_1$1.ScopeType.functionType || currentScope.type === scope_1$1.ScopeType.mappedType) {
						currentScope = currentScope.upper;
						continue;
					}
					if (currentScope.type === scope_1$1.ScopeType.conditionalType) {
						scope = currentScope;
						break;
					}
					break;
				}
			}
			scope.defineIdentifier(typeParameter.name, new definition_1$3.TypeDefinition(typeParameter.name, typeParameter)), this.visit(typeParameter.constraint);
		}
		TSInterfaceDeclaration(node) {
			this.#referencer.currentScope().defineIdentifier(node.id, new definition_1$3.TypeDefinition(node.id, node)), node.typeParameters && (this.#referencer.scopeManager.nestTypeScope(node), this.visit(node.typeParameters)), node.extends.forEach(this.visit, this), this.visit(node.body), node.typeParameters && this.#referencer.close(node);
		}
		TSMappedType(node) {
			this.#referencer.scopeManager.nestMappedTypeScope(node), this.#referencer.currentScope().defineIdentifier(node.key, new definition_1$3.TypeDefinition(node.key, node)), this.visit(node.constraint), this.visit(node.nameType), this.visit(node.typeAnnotation), this.#referencer.close(node);
		}
		TSMethodSignature(node) {
			this.visitPropertyKey(node), this.visitFunctionType(node);
		}
		TSNamedTupleMember(node) {
			this.visit(node.elementType);
		}
		TSPropertySignature(node) {
			this.visitPropertyKey(node), this.visit(node.typeAnnotation);
		}
		TSQualifiedName(node) {
			this.visit(node.left);
		}
		TSTypeAliasDeclaration(node) {
			this.#referencer.currentScope().defineIdentifier(node.id, new definition_1$3.TypeDefinition(node.id, node)), node.typeParameters && (this.#referencer.scopeManager.nestTypeScope(node), this.visit(node.typeParameters)), this.visit(node.typeAnnotation), node.typeParameters && this.#referencer.close(node);
		}
		TSTypeParameter(node) {
			this.#referencer.currentScope().defineIdentifier(node.name, new definition_1$3.TypeDefinition(node.name, node)), this.visit(node.constraint), this.visit(node.default);
		}
		TSTypePredicate(node) {
			node.parameterName.type !== types_1$3.AST_NODE_TYPES.TSThisType && this.#referencer.currentScope().referenceValue(node.parameterName), this.visit(node.typeAnnotation);
		}
		TSTypeAnnotation(node) {
			this.visitChildren(node);
		}
		TSTypeQuery(node) {
			let entityName;
			if (node.exprName.type === types_1$3.AST_NODE_TYPES.TSQualifiedName) {
				let iter = node.exprName;
				for (; iter.left.type === types_1$3.AST_NODE_TYPES.TSQualifiedName;) iter = iter.left;
				entityName = iter.left;
			} else entityName = node.exprName, node.exprName.type === types_1$3.AST_NODE_TYPES.TSImportType && this.visit(node.exprName);
			entityName.type === types_1$3.AST_NODE_TYPES.Identifier && this.#referencer.currentScope().referenceValue(entityName), this.visit(node.typeArguments);
		}
	};
})), require_ClassVisitor = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ClassVisitor = void 0;
	let types_1$2 = require_dist$1(), definition_1$2 = require_definition(), TypeVisitor_1$1 = require_TypeVisitor(), Visitor_1$4 = require_Visitor();
	exports.ClassVisitor = class ClassVisitor extends Visitor_1$4.Visitor {
		#referencer;
		constructor(referencer) {
			super(referencer), this.#referencer = referencer;
		}
		static visit(referencer, node) {
			new ClassVisitor(referencer).visitClass(node);
		}
		visit(node) {
			node && node.type in this ? super.visit(node) : this.#referencer.visit(node);
		}
		visitClass(node) {
			node.type === types_1$2.AST_NODE_TYPES.ClassDeclaration && node.id && this.#referencer.currentScope().defineIdentifier(node.id, new definition_1$2.ClassNameDefinition(node.id, node)), node.decorators.forEach((d) => this.#referencer.visit(d)), this.#referencer.scopeManager.nestClassScope(node), node.id && this.#referencer.currentScope().defineIdentifier(node.id, new definition_1$2.ClassNameDefinition(node.id, node)), this.#referencer.visit(node.superClass), this.visitType(node.typeParameters), this.visitType(node.superTypeArguments), node.implements.forEach((imp) => this.visitType(imp)), this.visit(node.body), this.#referencer.close(node);
		}
		visitFunctionParameterTypeAnnotation(node) {
			switch (node.type) {
				case types_1$2.AST_NODE_TYPES.AssignmentPattern:
					this.visitType(node.left.typeAnnotation);
					break;
				case types_1$2.AST_NODE_TYPES.TSParameterProperty:
					this.visitFunctionParameterTypeAnnotation(node.parameter);
					break;
				default: this.visitType(node.typeAnnotation);
			}
		}
		visitMethod(node) {
			node.computed && this.#referencer.visit(node.key), node.value.type === types_1$2.AST_NODE_TYPES.FunctionExpression ? this.visitMethodFunction(node.value) : this.#referencer.visit(node.value), node.decorators.forEach((d) => this.#referencer.visit(d));
		}
		visitMethodFunction(node) {
			node.id && this.#referencer.scopeManager.nestFunctionExpressionNameScope(node), node.params.forEach((param) => {
				param.decorators.forEach((d) => this.visit(d));
			}), this.#referencer.scopeManager.nestFunctionScope(node, !0);
			for (let param of node.params) this.visitPattern(param, (pattern, info) => {
				this.#referencer.currentScope().defineIdentifier(pattern, new definition_1$2.ParameterDefinition(pattern, node, info.rest)), this.#referencer.referencingDefaultValue(pattern, info.assignments, null, !0);
			}, { processRightHandNodes: !0 }), this.visitFunctionParameterTypeAnnotation(param);
			this.visitType(node.returnType), this.visitType(node.typeParameters), this.#referencer.visitChildren(node.body), this.#referencer.close(node);
		}
		visitPropertyBase(node) {
			node.computed && this.#referencer.visit(node.key), node.value && ((node.type === types_1$2.AST_NODE_TYPES.PropertyDefinition || node.type === types_1$2.AST_NODE_TYPES.AccessorProperty) && this.#referencer.scopeManager.nestClassFieldInitializerScope(node.value), this.#referencer.visit(node.value), (node.type === types_1$2.AST_NODE_TYPES.PropertyDefinition || node.type === types_1$2.AST_NODE_TYPES.AccessorProperty) && this.#referencer.close(node.value)), node.decorators.forEach((d) => this.#referencer.visit(d));
		}
		visitPropertyDefinition(node) {
			this.visitPropertyBase(node), this.visitType(node.typeAnnotation);
		}
		visitType(node) {
			node && TypeVisitor_1$1.TypeVisitor.visit(this.#referencer, node);
		}
		AccessorProperty(node) {
			this.visitPropertyDefinition(node);
		}
		ClassBody(node) {
			this.visitChildren(node);
		}
		Identifier(node) {
			this.#referencer.visit(node);
		}
		MethodDefinition(node) {
			this.visitMethod(node);
		}
		PrivateIdentifier() {}
		PropertyDefinition(node) {
			this.visitPropertyDefinition(node);
		}
		StaticBlock(node) {
			this.#referencer.scopeManager.nestClassStaticBlockScope(node), node.body.forEach((b) => this.visit(b)), this.#referencer.close(node);
		}
		TSAbstractAccessorProperty(node) {
			this.visitPropertyDefinition(node);
		}
		TSAbstractMethodDefinition(node) {
			this.visitPropertyBase(node);
		}
		TSAbstractPropertyDefinition(node) {
			this.visitPropertyDefinition(node);
		}
		TSIndexSignature(node) {
			this.visitType(node);
		}
	};
})), require_ExportVisitor = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ExportVisitor = void 0;
	let types_1$1 = require_dist$1(), Visitor_1$3 = require_Visitor();
	exports.ExportVisitor = class ExportVisitor extends Visitor_1$3.Visitor {
		#exportNode;
		#referencer;
		constructor(node, referencer) {
			super(referencer), this.#exportNode = node, this.#referencer = referencer;
		}
		static visit(referencer, node) {
			new ExportVisitor(node, referencer).visit(node);
		}
		ExportDefaultDeclaration(node) {
			node.declaration.type === types_1$1.AST_NODE_TYPES.Identifier && this.visit(node.declaration);
		}
		ExportNamedDeclaration(node) {
			node.source || node.declaration || this.visitChildren(node);
		}
		ExportSpecifier(node) {
			node.exportKind === "type" && node.local.type === types_1$1.AST_NODE_TYPES.Identifier ? this.#referencer.currentScope().referenceType(node.local) : this.visit(node.local);
		}
		Identifier(node) {
			this.#exportNode.exportKind === "type" ? this.#referencer.currentScope().referenceType(node) : this.#referencer.currentScope().referenceDualValueType(node);
		}
	};
})), require_ImportVisitor = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ImportVisitor = void 0;
	let definition_1$1 = require_definition(), Visitor_1$2 = require_Visitor();
	exports.ImportVisitor = class ImportVisitor extends Visitor_1$2.Visitor {
		#declaration;
		#referencer;
		constructor(declaration, referencer) {
			super(referencer), this.#declaration = declaration, this.#referencer = referencer;
		}
		static visit(referencer, declaration) {
			new ImportVisitor(declaration, referencer).visit(declaration);
		}
		ImportDefaultSpecifier(node) {
			let local = node.local;
			this.visitImport(local, node);
		}
		ImportNamespaceSpecifier(node) {
			let local = node.local;
			this.visitImport(local, node);
		}
		ImportSpecifier(node) {
			let local = node.local;
			this.visitImport(local, node);
		}
		visitImport(id, specifier) {
			this.#referencer.currentScope().defineIdentifier(id, new definition_1$1.ImportBindingDefinition(id, specifier, this.#declaration));
		}
	};
})), require_Referencer = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.Referencer = void 0;
	let types_1 = require_dist$1(), assert_1$1 = require_assert(), definition_1 = require_definition(), lib_1 = require_lib(), ClassVisitor_1 = require_ClassVisitor(), ExportVisitor_1 = require_ExportVisitor(), ImportVisitor_1 = require_ImportVisitor(), PatternVisitor_1$1 = require_PatternVisitor(), Reference_1$1 = require_Reference(), TypeVisitor_1 = require_TypeVisitor(), Visitor_1$1 = require_Visitor();
	var Referencer = class extends Visitor_1$1.Visitor {
		#hasReferencedJsxFactory = !1;
		#hasReferencedJsxFragmentFactory = !1;
		#jsxFragmentName;
		#jsxPragma;
		#lib;
		scopeManager;
		constructor(options, scopeManager) {
			super(options), this.scopeManager = scopeManager, this.#jsxPragma = options.jsxPragma, this.#jsxFragmentName = options.jsxFragmentName, this.#lib = options.lib;
		}
		populateGlobalsFromLib(globalScope) {
			let flattenedLibs = /* @__PURE__ */ new Set();
			for (let lib of this.#lib) {
				let definition = lib_1.lib.get(lib);
				if (!definition) throw Error(`Invalid value for lib provided: ${lib}`);
				flattenedLibs.add(definition);
			}
			for (let lib of flattenedLibs) {
				for (let referencedLib of lib.libs) flattenedLibs.add(referencedLib);
				for (let [name, variable] of lib.variables) globalScope.defineImplicitVariable(name, variable);
			}
			globalScope.defineImplicitVariable("const", {
				eslintImplicitGlobalSetting: "readonly",
				isTypeVariable: !0,
				isValueVariable: !1
			});
		}
		close(node) {
			for (; this.currentScope(!0) && node === this.currentScope().block;) this.scopeManager.currentScope = this.currentScope().close(this.scopeManager);
		}
		currentScope(dontThrowOnNull) {
			return dontThrowOnNull || (0, assert_1$1.assert)(this.scopeManager.currentScope, "aaa"), this.scopeManager.currentScope;
		}
		referencingDefaultValue(pattern, assignments, maybeImplicitGlobal, init) {
			assignments.forEach((assignment) => {
				this.currentScope().referenceValue(pattern, Reference_1$1.ReferenceFlag.Write, assignment.right, maybeImplicitGlobal, init);
			});
		}
		referenceInSomeUpperScope(name) {
			let scope = this.scopeManager.currentScope;
			for (; scope;) {
				let variable = scope.set.get(name);
				if (!variable) {
					scope = scope.upper;
					continue;
				}
				return scope.referenceValue(variable.identifiers[0]), !0;
			}
			return !1;
		}
		referenceJsxFragment() {
			this.#jsxFragmentName == null || this.#hasReferencedJsxFragmentFactory || (this.#hasReferencedJsxFragmentFactory = this.referenceInSomeUpperScope(this.#jsxFragmentName));
		}
		referenceJsxPragma() {
			this.#jsxPragma == null || this.#hasReferencedJsxFactory || (this.#hasReferencedJsxFactory = this.referenceInSomeUpperScope(this.#jsxPragma));
		}
		visitClass(node) {
			ClassVisitor_1.ClassVisitor.visit(this, node);
		}
		visitForIn(node) {
			node.left.type === types_1.AST_NODE_TYPES.VariableDeclaration && node.left.kind !== "var" && this.scopeManager.nestForScope(node), node.left.type === types_1.AST_NODE_TYPES.VariableDeclaration ? (this.visit(node.left), this.visitPattern(node.left.declarations[0].id, (pattern) => {
				this.currentScope().referenceValue(pattern, Reference_1$1.ReferenceFlag.Write, node.right, null, !0);
			})) : this.visitPattern(node.left, (pattern, info) => {
				let maybeImplicitGlobal = this.currentScope().isStrict ? null : {
					node,
					pattern
				};
				this.referencingDefaultValue(pattern, info.assignments, maybeImplicitGlobal, !1), this.currentScope().referenceValue(pattern, Reference_1$1.ReferenceFlag.Write, node.right, maybeImplicitGlobal, !1);
			}, { processRightHandNodes: !0 }), this.visit(node.right), this.visit(node.body), this.close(node);
		}
		visitFunction(node) {
			node.type === types_1.AST_NODE_TYPES.FunctionExpression ? node.id && this.scopeManager.nestFunctionExpressionNameScope(node) : node.id && this.currentScope().defineIdentifier(node.id, new definition_1.FunctionNameDefinition(node.id, node)), this.scopeManager.nestFunctionScope(node, !1);
			for (let param of node.params) this.visitPattern(param, (pattern, info) => {
				this.currentScope().defineIdentifier(pattern, new definition_1.ParameterDefinition(pattern, node, info.rest)), this.referencingDefaultValue(pattern, info.assignments, null, !0);
			}, { processRightHandNodes: !0 }), this.visitFunctionParameterTypeAnnotation(param), param.decorators.forEach((d) => this.visit(d));
			this.visitType(node.returnType), this.visitType(node.typeParameters), node.body && (node.body.type === types_1.AST_NODE_TYPES.BlockStatement ? this.visitChildren(node.body) : this.visit(node.body)), this.close(node);
		}
		visitFunctionParameterTypeAnnotation(node) {
			switch (node.type) {
				case types_1.AST_NODE_TYPES.AssignmentPattern:
					this.visitType(node.left.typeAnnotation);
					break;
				case types_1.AST_NODE_TYPES.TSParameterProperty:
					this.visitFunctionParameterTypeAnnotation(node.parameter);
					break;
				default:
					this.visitType(node.typeAnnotation);
					break;
			}
		}
		visitJSXElement(node) {
			node.name.type === types_1.AST_NODE_TYPES.JSXIdentifier ? (node.name.name[0].toUpperCase() === node.name.name[0] || node.name.name === "this") && this.visit(node.name) : this.visit(node.name);
		}
		visitProperty(node) {
			node.computed && this.visit(node.key), this.visit(node.value);
		}
		visitType(node) {
			node && TypeVisitor_1.TypeVisitor.visit(this, node);
		}
		visitTypeAssertion(node) {
			this.visit(node.expression), this.visitType(node.typeAnnotation);
		}
		ArrowFunctionExpression(node) {
			this.visitFunction(node);
		}
		AssignmentExpression(node) {
			let left = this.visitExpressionTarget(node.left);
			PatternVisitor_1$1.PatternVisitor.isPattern(left) ? node.operator === "=" ? this.visitPattern(left, (pattern, info) => {
				let maybeImplicitGlobal = this.currentScope().isStrict ? null : {
					node,
					pattern
				};
				this.referencingDefaultValue(pattern, info.assignments, maybeImplicitGlobal, !1), this.currentScope().referenceValue(pattern, Reference_1$1.ReferenceFlag.Write, node.right, maybeImplicitGlobal, !1);
			}, { processRightHandNodes: !0 }) : left.type === types_1.AST_NODE_TYPES.Identifier && this.currentScope().referenceValue(left, Reference_1$1.ReferenceFlag.ReadWrite, node.right) : this.visit(left), this.visit(node.right);
		}
		BlockStatement(node) {
			this.scopeManager.nestBlockScope(node), this.visitChildren(node), this.close(node);
		}
		BreakStatement() {}
		CallExpression(node) {
			this.visitChildren(node, ["typeArguments"]), this.visitType(node.typeArguments);
		}
		CatchClause(node) {
			if (this.scopeManager.nestCatchScope(node), node.param) {
				let param = node.param;
				this.visitPattern(param, (pattern, info) => {
					this.currentScope().defineIdentifier(pattern, new definition_1.CatchClauseDefinition(param, node)), this.referencingDefaultValue(pattern, info.assignments, null, !0);
				}, { processRightHandNodes: !0 });
			}
			this.visit(node.body), this.close(node);
		}
		ClassDeclaration(node) {
			this.visitClass(node);
		}
		ClassExpression(node) {
			this.visitClass(node);
		}
		ContinueStatement() {}
		ExportAllDeclaration() {}
		ExportDefaultDeclaration(node) {
			node.declaration.type === types_1.AST_NODE_TYPES.Identifier ? ExportVisitor_1.ExportVisitor.visit(this, node) : this.visit(node.declaration);
		}
		ExportNamedDeclaration(node) {
			node.declaration ? this.visit(node.declaration) : ExportVisitor_1.ExportVisitor.visit(this, node);
		}
		ForInStatement(node) {
			this.visitForIn(node);
		}
		ForOfStatement(node) {
			this.visitForIn(node);
		}
		ForStatement(node) {
			node.init && node.init.type === types_1.AST_NODE_TYPES.VariableDeclaration && node.init.kind !== "var" && this.scopeManager.nestForScope(node), this.visitChildren(node), this.close(node);
		}
		FunctionDeclaration(node) {
			this.visitFunction(node);
		}
		FunctionExpression(node) {
			this.visitFunction(node);
		}
		Identifier(node) {
			this.currentScope().referenceValue(node), this.visitType(node.typeAnnotation);
		}
		ImportAttribute() {}
		ImportDeclaration(node) {
			(0, assert_1$1.assert)(this.scopeManager.isModule(), "ImportDeclaration should appear when the mode is ES6 and in the module context."), ImportVisitor_1.ImportVisitor.visit(this, node);
		}
		JSXAttribute(node) {
			this.visit(node.value);
		}
		JSXClosingElement(node) {
			this.visitJSXElement(node);
		}
		JSXFragment(node) {
			this.referenceJsxPragma(), this.referenceJsxFragment(), this.visitChildren(node);
		}
		JSXIdentifier(node) {
			this.currentScope().referenceValue(node);
		}
		JSXMemberExpression(node) {
			(node.object.type !== types_1.AST_NODE_TYPES.JSXIdentifier || node.object.name !== "this") && this.visit(node.object);
		}
		JSXOpeningElement(node) {
			this.referenceJsxPragma(), this.visitJSXElement(node), this.visitType(node.typeArguments);
			for (let attr of node.attributes) this.visit(attr);
		}
		LabeledStatement(node) {
			this.visit(node.body);
		}
		MemberExpression(node) {
			this.visit(node.object), node.computed && this.visit(node.property);
		}
		MetaProperty() {}
		NewExpression(node) {
			this.visitChildren(node, ["typeArguments"]), this.visitType(node.typeArguments);
		}
		PrivateIdentifier() {}
		Program(node) {
			let globalScope = this.scopeManager.nestGlobalScope(node);
			this.populateGlobalsFromLib(globalScope), this.scopeManager.isGlobalReturn() && (this.currentScope().isStrict = !1, this.scopeManager.nestFunctionScope(node, !1)), this.scopeManager.isModule() && this.scopeManager.nestModuleScope(node), this.scopeManager.isImpliedStrict() && (this.currentScope().isStrict = !0), this.visitChildren(node), this.close(node);
		}
		Property(node) {
			this.visitProperty(node);
		}
		SwitchStatement(node) {
			this.visit(node.discriminant), this.scopeManager.nestSwitchScope(node);
			for (let switchCase of node.cases) this.visit(switchCase);
			this.close(node);
		}
		TaggedTemplateExpression(node) {
			this.visit(node.tag), this.visit(node.quasi), this.visitType(node.typeArguments);
		}
		TSAsExpression(node) {
			this.visitTypeAssertion(node);
		}
		TSDeclareFunction(node) {
			this.visitFunction(node);
		}
		TSEmptyBodyFunctionExpression(node) {
			this.visitFunction(node);
		}
		TSEnumDeclaration(node) {
			this.currentScope().defineIdentifier(node.id, new definition_1.TSEnumNameDefinition(node.id, node)), this.scopeManager.nestTSEnumScope(node);
			for (let member of node.body.members) {
				if (member.id.type === types_1.AST_NODE_TYPES.Literal && typeof member.id.value == "string") {
					let name = member.id;
					this.currentScope().defineLiteralIdentifier(name, new definition_1.TSEnumMemberDefinition(name, member));
				} else member.id.type === types_1.AST_NODE_TYPES.Identifier && this.currentScope().defineIdentifier(member.id, new definition_1.TSEnumMemberDefinition(member.id, member));
				this.visit(member.initializer);
			}
			this.close(node);
		}
		TSExportAssignment(node) {
			node.expression.type === types_1.AST_NODE_TYPES.Identifier ? this.currentScope().referenceDualValueType(node.expression) : this.visit(node.expression);
		}
		TSImportEqualsDeclaration(node) {
			if (this.currentScope().defineIdentifier(node.id, new definition_1.ImportBindingDefinition(node.id, node, node)), node.moduleReference.type === types_1.AST_NODE_TYPES.TSQualifiedName) {
				let moduleIdentifier = node.moduleReference.left;
				for (; moduleIdentifier.type === types_1.AST_NODE_TYPES.TSQualifiedName;) moduleIdentifier = moduleIdentifier.left;
				this.visit(moduleIdentifier);
			} else this.visit(node.moduleReference);
		}
		TSInstantiationExpression(node) {
			this.visitChildren(node, ["typeArguments"]), this.visitType(node.typeArguments);
		}
		TSInterfaceDeclaration(node) {
			this.visitType(node);
		}
		TSModuleDeclaration(node) {
			node.id.type === types_1.AST_NODE_TYPES.Identifier && node.kind !== "global" && this.currentScope().defineIdentifier(node.id, new definition_1.TSModuleNameDefinition(node.id, node)), this.scopeManager.nestTSModuleScope(node), this.visit(node.body), this.close(node);
		}
		TSSatisfiesExpression(node) {
			this.visitTypeAssertion(node);
		}
		TSTypeAliasDeclaration(node) {
			this.visitType(node);
		}
		TSTypeAssertion(node) {
			this.visitTypeAssertion(node);
		}
		UpdateExpression(node) {
			let argument = this.visitExpressionTarget(node.argument);
			PatternVisitor_1$1.PatternVisitor.isPattern(argument) ? this.visitPattern(argument, (pattern) => {
				this.currentScope().referenceValue(pattern, Reference_1$1.ReferenceFlag.ReadWrite, null);
			}) : this.visitChildren(node);
		}
		VariableDeclaration(node) {
			let variableTargetScope = node.kind === "var" ? this.currentScope().variableScope : this.currentScope();
			for (let decl of node.declarations) {
				let init = decl.init;
				this.visitPattern(decl.id, (pattern, info) => {
					variableTargetScope.defineIdentifier(pattern, new definition_1.VariableDefinition(pattern, decl, node)), this.referencingDefaultValue(pattern, info.assignments, null, !0), init && this.currentScope().referenceValue(pattern, Reference_1$1.ReferenceFlag.Write, init, null, !0);
				}, { processRightHandNodes: !0 }), this.visit(decl.init), this.visitType(decl.id.typeAnnotation);
			}
		}
		WithStatement(node) {
			this.visit(node.object), this.scopeManager.nestWithScope(node), this.visit(node.body), this.close(node);
		}
		visitExpressionTarget(left) {
			switch (left.type) {
				case types_1.AST_NODE_TYPES.TSAsExpression:
				case types_1.AST_NODE_TYPES.TSTypeAssertion: this.visitType(left.typeAnnotation);
				case types_1.AST_NODE_TYPES.TSNonNullExpression: left = left.expression;
			}
			return left;
		}
	};
	exports.Referencer = Referencer;
})), require_referencer = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.Referencer = void 0;
	var Referencer_1 = require_Referencer();
	Object.defineProperty(exports, "Referencer", {
		enumerable: !0,
		get: function() {
			return Referencer_1.Referencer;
		}
	});
})), require_ClassStaticBlockScope = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ClassStaticBlockScope = void 0;
	let ScopeBase_1 = require_ScopeBase(), ScopeType_1 = require_ScopeType();
	var ClassStaticBlockScope = class extends ScopeBase_1.ScopeBase {
		constructor(scopeManager, upperScope, block) {
			super(scopeManager, ScopeType_1.ScopeType.classStaticBlock, upperScope, block, !1);
		}
	};
	exports.ClassStaticBlockScope = ClassStaticBlockScope;
})), require_ScopeManager = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ScopeManager = void 0;
	let assert_1 = require_assert(), scope_1 = require_scope(), ClassFieldInitializerScope_1 = require_ClassFieldInitializerScope(), ClassStaticBlockScope_1 = require_ClassStaticBlockScope();
	var ScopeManager = class {
		#options;
		currentScope;
		declaredVariables;
		globalScope;
		nodeToScope;
		scopes;
		constructor(options) {
			this.scopes = [], this.globalScope = null, this.nodeToScope = /* @__PURE__ */ new WeakMap(), this.currentScope = null, this.#options = options, this.declaredVariables = /* @__PURE__ */ new WeakMap();
		}
		isES6() {
			return !0;
		}
		isGlobalReturn() {
			return this.#options.globalReturn === !0;
		}
		isImpliedStrict() {
			return this.#options.impliedStrict === !0;
		}
		isModule() {
			return this.#options.sourceType === "module";
		}
		isStrictModeSupported() {
			return !0;
		}
		get variables() {
			let variables = /* @__PURE__ */ new Set();
			function recurse(scope) {
				scope.variables.forEach((v) => variables.add(v)), scope.childScopes.forEach(recurse);
			}
			return this.scopes.forEach(recurse), [...variables].sort((a, b) => a.$id - b.$id);
		}
		getDeclaredVariables(node) {
			return this.declaredVariables.get(node) ?? [];
		}
		acquire(node, inner = !1) {
			function predicate(testScope) {
				return !(testScope.type === scope_1.ScopeType.function && testScope.functionExpressionScope);
			}
			let scopes = this.nodeToScope.get(node);
			if (!scopes || scopes.length === 0) return null;
			if (scopes.length === 1) return scopes[0];
			if (inner) {
				for (let i = scopes.length - 1; i >= 0; --i) {
					let scope = scopes[i];
					if (predicate(scope)) return scope;
				}
				return null;
			}
			return scopes.find(predicate) ?? null;
		}
		nestBlockScope(node) {
			return (0, assert_1.assert)(this.currentScope), this.nestScope(new scope_1.BlockScope(this, this.currentScope, node));
		}
		nestCatchScope(node) {
			return (0, assert_1.assert)(this.currentScope), this.nestScope(new scope_1.CatchScope(this, this.currentScope, node));
		}
		nestClassFieldInitializerScope(node) {
			return (0, assert_1.assert)(this.currentScope), this.nestScope(new ClassFieldInitializerScope_1.ClassFieldInitializerScope(this, this.currentScope, node));
		}
		nestClassScope(node) {
			return (0, assert_1.assert)(this.currentScope), this.nestScope(new scope_1.ClassScope(this, this.currentScope, node));
		}
		nestClassStaticBlockScope(node) {
			return (0, assert_1.assert)(this.currentScope), this.nestScope(new ClassStaticBlockScope_1.ClassStaticBlockScope(this, this.currentScope, node));
		}
		nestConditionalTypeScope(node) {
			return (0, assert_1.assert)(this.currentScope), this.nestScope(new scope_1.ConditionalTypeScope(this, this.currentScope, node));
		}
		nestForScope(node) {
			return (0, assert_1.assert)(this.currentScope), this.nestScope(new scope_1.ForScope(this, this.currentScope, node));
		}
		nestFunctionExpressionNameScope(node) {
			return (0, assert_1.assert)(this.currentScope), this.nestScope(new scope_1.FunctionExpressionNameScope(this, this.currentScope, node));
		}
		nestFunctionScope(node, isMethodDefinition) {
			return (0, assert_1.assert)(this.currentScope), this.nestScope(new scope_1.FunctionScope(this, this.currentScope, node, isMethodDefinition));
		}
		nestFunctionTypeScope(node) {
			return (0, assert_1.assert)(this.currentScope), this.nestScope(new scope_1.FunctionTypeScope(this, this.currentScope, node));
		}
		nestGlobalScope(node) {
			return this.nestScope(new scope_1.GlobalScope(this, node));
		}
		nestMappedTypeScope(node) {
			return (0, assert_1.assert)(this.currentScope), this.nestScope(new scope_1.MappedTypeScope(this, this.currentScope, node));
		}
		nestModuleScope(node) {
			return (0, assert_1.assert)(this.currentScope), this.nestScope(new scope_1.ModuleScope(this, this.currentScope, node));
		}
		nestSwitchScope(node) {
			return (0, assert_1.assert)(this.currentScope), this.nestScope(new scope_1.SwitchScope(this, this.currentScope, node));
		}
		nestTSEnumScope(node) {
			return (0, assert_1.assert)(this.currentScope), this.nestScope(new scope_1.TSEnumScope(this, this.currentScope, node));
		}
		nestTSModuleScope(node) {
			return (0, assert_1.assert)(this.currentScope), this.nestScope(new scope_1.TSModuleScope(this, this.currentScope, node));
		}
		nestTypeScope(node) {
			return (0, assert_1.assert)(this.currentScope), this.nestScope(new scope_1.TypeScope(this, this.currentScope, node));
		}
		nestWithScope(node) {
			return (0, assert_1.assert)(this.currentScope), this.nestScope(new scope_1.WithScope(this, this.currentScope, node));
		}
		nestScope(scope) {
			return scope instanceof scope_1.GlobalScope && ((0, assert_1.assert)(this.currentScope == null), this.globalScope = scope), this.currentScope = scope, scope;
		}
	};
	exports.ScopeManager = ScopeManager;
})), require_analyze = /* @__PURE__ */ __commonJSMin(((exports) => {
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.analyze = analyze$1;
	let visitor_keys_1 = require_dist$2(), referencer_1 = require_referencer(), ScopeManager_1$1 = require_ScopeManager(), DEFAULT_OPTIONS$1 = {
		childVisitorKeys: visitor_keys_1.visitorKeys,
		emitDecoratorMetadata: !1,
		globalReturn: !1,
		impliedStrict: !1,
		jsxFragmentName: null,
		jsxPragma: "React",
		lib: ["es2018"],
		sourceType: "script"
	};
	function analyze$1(tree, providedOptions) {
		let options = {
			childVisitorKeys: providedOptions?.childVisitorKeys ?? DEFAULT_OPTIONS$1.childVisitorKeys,
			emitDecoratorMetadata: !1,
			globalReturn: providedOptions?.globalReturn ?? DEFAULT_OPTIONS$1.globalReturn,
			impliedStrict: providedOptions?.impliedStrict ?? DEFAULT_OPTIONS$1.impliedStrict,
			jsxFragmentName: providedOptions?.jsxFragmentName ?? DEFAULT_OPTIONS$1.jsxFragmentName,
			jsxPragma: providedOptions?.jsxPragma === void 0 ? DEFAULT_OPTIONS$1.jsxPragma : providedOptions.jsxPragma,
			lib: providedOptions?.lib ?? ["esnext"],
			sourceType: providedOptions?.sourceType ?? DEFAULT_OPTIONS$1.sourceType
		};
		options.lib = options.lib.map((l) => l.toLowerCase());
		let scopeManager = new ScopeManager_1$1.ScopeManager(options);
		return new referencer_1.Referencer(options, scopeManager).visit(tree), scopeManager;
	}
})), import_dist = (/* @__PURE__ */ __commonJSMin(((exports) => {
	var __createBinding = exports && exports.__createBinding || (Object.create ? (function(o, m, k, k2) {
		k2 === void 0 && (k2 = k);
		var desc = Object.getOwnPropertyDescriptor(m, k);
		(!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) && (desc = {
			enumerable: !0,
			get: function() {
				return m[k];
			}
		}), Object.defineProperty(o, k2, desc);
	}) : (function(o, m, k, k2) {
		k2 === void 0 && (k2 = k), o[k2] = m[k];
	})), __exportStar = exports && exports.__exportStar || function(m, exports$1) {
		for (var p in m) p !== "default" && !Object.prototype.hasOwnProperty.call(exports$1, p) && __createBinding(exports$1, m, p);
	};
	Object.defineProperty(exports, "__esModule", { value: !0 }), exports.ScopeManager = exports.Visitor = exports.Reference = exports.PatternVisitor = exports.analyze = void 0;
	var analyze_1 = require_analyze();
	Object.defineProperty(exports, "analyze", {
		enumerable: !0,
		get: function() {
			return analyze_1.analyze;
		}
	}), __exportStar(require_definition(), exports);
	var PatternVisitor_1 = require_PatternVisitor();
	Object.defineProperty(exports, "PatternVisitor", {
		enumerable: !0,
		get: function() {
			return PatternVisitor_1.PatternVisitor;
		}
	});
	var Reference_1 = require_Reference();
	Object.defineProperty(exports, "Reference", {
		enumerable: !0,
		get: function() {
			return Reference_1.Reference;
		}
	});
	var Visitor_1 = require_Visitor();
	Object.defineProperty(exports, "Visitor", {
		enumerable: !0,
		get: function() {
			return Visitor_1.Visitor;
		}
	}), __exportStar(require_scope(), exports);
	var ScopeManager_1 = require_ScopeManager();
	Object.defineProperty(exports, "ScopeManager", {
		enumerable: !0,
		get: function() {
			return ScopeManager_1.ScopeManager;
		}
	}), __exportStar(require_variable(), exports);
})))();
let tsScopeManager = null;
const analyzeOptions = {
	globalReturn: !1,
	jsxFragmentName: null,
	jsxPragma: "React",
	lib: ["esnext"],
	sourceType: null
};
function initTsScopeManager() {
	ast === null && initAst(), analyzeOptions.sourceType = ast.sourceType, tsScopeManager = (0, import_dist.analyze)(ast, analyzeOptions);
}
function resetScopeManager() {
	tsScopeManager = null;
}
const SCOPE_MANAGER = Object.freeze({
	get scopes() {
		return tsScopeManager === null && initTsScopeManager(), tsScopeManager.scopes;
	},
	get globalScope() {
		return tsScopeManager === null && initTsScopeManager(), tsScopeManager.globalScope;
	},
	getDeclaredVariables(node) {
		return tsScopeManager === null && initTsScopeManager(), tsScopeManager.getDeclaredVariables(node);
	},
	acquire(node, inner) {
		return tsScopeManager === null && initTsScopeManager(), tsScopeManager.acquire(node, inner);
	}
});
function isGlobalReference(node) {
	if (!node) throw TypeError("Missing required argument: `node`");
	if (node.type !== "Identifier") return !1;
	tsScopeManager === null && initTsScopeManager();
	let { scopes } = tsScopeManager;
	if (scopes.length === 0) return !1;
	let variable = scopes[0].set.get(node.name);
	if (variable === void 0 || variable.defs.length > 0) return !1;
	let { references } = variable;
	for (let i = 0, len = references.length; i < len; i++) if (references[i].identifier === node) return !0;
	return !1;
}
function getDeclaredVariables(node) {
	return tsScopeManager === null && initTsScopeManager(), tsScopeManager.getDeclaredVariables(node);
}
function getScope(node) {
	if (!node) throw TypeError("Missing required argument: `node`");
	tsScopeManager === null && initTsScopeManager();
	let inner = node.type !== "Program";
	do {
		let scope = tsScopeManager.acquire(node, inner);
		if (scope !== null) return scope.type === "function-expression-name" ? scope.childScopes[0] : scope;
		node = node.parent;
	} while (node !== null);
	return tsScopeManager.scopes[0];
}
function markVariableAsUsed(name, refNode) {
	throw Error("`context.markVariableAsUsed` not implemented yet");
}
const { max } = Math, textDecoder = new TextDecoder("utf-8", { ignoreBOM: !0 });
let buffer = null, hasBOM = !1, sourceText = null, sourceByteLen = 0, ast = null, parserServices = null;
function setupSourceForFile(bufferInput, hasBOMInput, parserServicesInput) {
	buffer = bufferInput, hasBOM = hasBOMInput, parserServices = parserServicesInput;
}
function initSourceText() {
	let { uint32: uint32$1 } = buffer;
	sourceByteLen = uint32$1[uint32$1[DATA_POINTER_POS_32] + 16 >> 2], sourceText = textDecoder.decode(buffer.subarray(0, sourceByteLen));
}
function initAst() {
	sourceText === null && initSourceText(), ast = deserializeProgramOnly(buffer, sourceText, sourceByteLen, getNodeLoc);
}
function resetSourceAndAst() {
	buffer = null, sourceText = null, ast = null, parserServices = null, resetBuffer(), resetLines(), resetScopeManager(), resetTokens();
}
const SOURCE_CODE = Object.freeze({
	get text() {
		return sourceText === null && initSourceText(), sourceText;
	},
	get hasBOM() {
		return hasBOM;
	},
	get ast() {
		return ast === null && initAst(), ast;
	},
	get scopeManager() {
		return SCOPE_MANAGER;
	},
	get visitorKeys() {
		return keys_default;
	},
	get parserServices() {
		return parserServices;
	},
	get lines() {
		return lines.length === 0 && initLines(), lines;
	},
	getText(node, beforeCount, afterCount) {
		if (sourceText === null && initSourceText(), !node) return sourceText;
		let { range } = node, start = range[0], end = range[1];
		return beforeCount && (start = max(start - beforeCount, 0)), afterCount && (end += afterCount), sourceText.slice(start, end);
	},
	getAncestors(node) {
		let ancestors$1 = [];
		for (; node = node.parent, node !== null;) ancestors$1.push(node);
		return ancestors$1.reverse();
	},
	getNodeByRangeIndex,
	getLocFromIndex: getLineColumnFromOffset,
	getIndexFromLoc: getOffsetFromLineColumn,
	getAllComments,
	getCommentsBefore,
	getCommentsAfter,
	getCommentsInside,
	commentsExistBetween,
	getJSDocComment,
	isGlobalReference,
	getDeclaredVariables,
	getScope,
	markVariableAsUsed,
	getTokens,
	getFirstToken,
	getFirstTokens,
	getLastToken,
	getLastTokens,
	getTokenBefore,
	getTokenOrCommentBefore,
	getTokensBefore,
	getTokenAfter,
	getTokenOrCommentAfter,
	getTokensAfter,
	getTokensBetween,
	getFirstTokenBetween,
	getFirstTokensBetween,
	getLastTokenBetween,
	getLastTokensBetween,
	getTokenByRangeStart,
	isSpaceBetween,
	isSpaceBetweenTokens
}), { prototype: ArrayPrototype, from: ArrayFrom } = Array, { getPrototypeOf, hasOwn: hasOwn$1, prototype: ObjectPrototype } = Object, { ownKeys } = Reflect, IteratorSymbol = Symbol.iterator, FIXER = Object.freeze({
	insertTextBefore(nodeOrToken, text) {
		let start = nodeOrToken.range[0];
		return {
			range: [start, start],
			text
		};
	},
	insertTextBeforeRange(range, text) {
		let start = range[0];
		return {
			range: [start, start],
			text
		};
	},
	insertTextAfter(nodeOrToken, text) {
		let end = nodeOrToken.range[1];
		return {
			range: [end, end],
			text
		};
	},
	insertTextAfterRange(range, text) {
		let end = range[1];
		return {
			range: [end, end],
			text
		};
	},
	remove(nodeOrToken) {
		return {
			range: nodeOrToken.range,
			text: ""
		};
	},
	removeRange(range) {
		return {
			range,
			text: ""
		};
	},
	replaceText(nodeOrToken, text) {
		return {
			range: nodeOrToken.range,
			text
		};
	},
	replaceTextRange(range, text) {
		return {
			range,
			text
		};
	}
});
function getFixes(diagnostic, ruleDetails) {
	let { fix } = diagnostic;
	if (typeof fix != "function") return null;
	let fixes = fix.call(diagnostic, FIXER);
	if (!fixes) return null;
	if (IteratorSymbol in fixes) {
		let isCloned = !1;
		(getPrototypeOf(fixes) !== ArrayPrototype || hasOwn$1(fixes, "toJSON")) && (fixes = ArrayFrom(fixes), isCloned = !0);
		let fixesLen = fixes.length;
		if (fixesLen === 0) return null;
		for (let i = 0; i < fixesLen; i++) {
			let fix$1 = fixes[i];
			if (!fix$1) {
				if (fixes = fixes.filter(Boolean), fixes.length === 0) return null;
				isCloned = !0, i--;
				continue;
			}
			let conformedFix = validateAndConformFix(fix$1);
			conformedFix !== fix$1 && (isCloned === !1 && (fixes = fixes.slice(), isCloned = !0), fixes[i] = conformedFix);
		}
	} else fixes = [validateAndConformFix(fixes)];
	if (ruleDetails.isFixable === !1) throw Error("Fixable rules must set the `meta.fixable` property to \"code\" or \"whitespace\".");
	return fixes;
}
function validateAndConformFix(fix) {
	let { range, text } = fix;
	if (!range || typeof range[0] != "number" || typeof range[1] != "number") throw Error(`Fix has invalid range: ${JSON.stringify(fix, null, 2)}`);
	let fixPrototype = getPrototypeOf(fix);
	return (fixPrototype === ObjectPrototype || fixPrototype === null) && ownKeys(fix).length === 2 && getPrototypeOf(range) === ArrayPrototype && !hasOwn$1(range, "toJSON") && range.length === 2 && typeof text == "string" ? fix : {
		range: [range[0], range[1]],
		text: String(text)
	};
}
const { hasOwn, keys: ObjectKeys$3 } = Object, diagnostics = [], PLACEHOLDER_REGEX = /\{\{([^{}]+)\}\}/gu;
function report(diagnostic, ruleDetails) {
	if (filePath === null) throw Error("Cannot report errors in `createOnce`");
	let { message, messageId } = getMessage(diagnostic, ruleDetails);
	if (hasOwn(diagnostic, "data")) {
		let { data } = diagnostic;
		data != null && (message = replacePlaceholders(message, data));
	}
	let start, end, loc;
	if (hasOwn(diagnostic, "loc") && (loc = diagnostic.loc) != null) {
		if (typeof loc != "object") throw TypeError("`loc` must be an object");
		start = getOffsetFromLineColumn(loc.start), end = getOffsetFromLineColumn(loc.end);
	} else {
		let { node } = diagnostic;
		if (node == null) throw TypeError("Either `node` or `loc` is required");
		if (typeof node != "object") throw TypeError("`node` must be an object");
		let { range } = node;
		if (typeof range != "object" || !range) throw TypeError("`node.range` must be present");
		if (start = range[0], end = range[1], typeof start != "number" || typeof end != "number" || start < 0 || end < 0 || (start | 0) !== start || (end | 0) !== end) throw TypeError("`node.range[0]` and `node.range[1]` must be non-negative integers");
	}
	diagnostics.push({
		message,
		messageId,
		start,
		end,
		ruleIndex: ruleDetails.ruleIndex,
		fixes: getFixes(diagnostic, ruleDetails)
	});
}
function getMessage(diagnostic, ruleDetails) {
	if (hasOwn(diagnostic, "messageId")) {
		let { messageId } = diagnostic;
		if (messageId != null) return {
			message: resolveMessageFromMessageId(messageId, ruleDetails),
			messageId
		};
	}
	if (hasOwn(diagnostic, "message")) {
		let { message } = diagnostic;
		if (typeof message == "string") return {
			message,
			messageId: null
		};
		if (message != null) throw TypeError("`message` must be a string");
	}
	throw Error("Either `message` or `messageId` is required");
}
function resolveMessageFromMessageId(messageId, ruleDetails) {
	let { messages } = ruleDetails;
	if (messages === null) throw Error(`Cannot use messageId '${messageId}' - rule does not define any messages in \`meta.messages\``);
	if (!hasOwn(messages, messageId)) throw Error(`Unknown messageId '${messageId}'. Available \`messageIds\`: ${ObjectKeys$3(messages).map((msg) => `'${msg}'`).join(", ")}`);
	return messages[messageId];
}
function replacePlaceholders(message, data) {
	return message.replace(PLACEHOLDER_REGEX, (match, key) => {
		key = key.trim();
		let value = data[key];
		return value === void 0 ? match : value;
	});
}
const { isArray: isArray$4 } = Array, { freeze: freeze$2 } = Object;
function deepFreezeJsonValue(value) {
	typeof value != "object" || !value || (isArray$4(value) ? deepFreezeJsonArray(value) : deepFreezeJsonObject(value));
}
function deepFreezeJsonObject(obj) {
	for (let key in obj) deepFreezeJsonValue(obj[key]);
	freeze$2(obj);
}
function deepFreezeJsonArray(arr) {
	for (let i = 0, len = arr.length; i !== len; i++) deepFreezeJsonValue(arr[i]);
	freeze$2(arr);
}
let settingsJSON = null, settings = null;
function setSettingsForFile(settingsJSONInput) {
	settingsJSON = settingsJSONInput;
}
function initSettings() {
	settings = JSON.parse(settingsJSON), deepFreezeJsonValue(settings);
}
function resetSettings() {
	settings = null, settingsJSON = null;
}
const { freeze: freeze$1, assign: ObjectAssign, create: ObjectCreate } = Object;
let cwd = null, filePath = null;
function setupFileContext(filePathInput) {
	filePath = filePathInput;
}
function resetFileContext() {
	filePath = null;
}
const SUPPORTED_ECMA_VERSIONS = freeze$1([
	3,
	5,
	6,
	7,
	8,
	9,
	10,
	11,
	12,
	13,
	14,
	15,
	16,
	17
]);
let Syntax = null;
const PARSER = freeze$1({
	name: "oxc",
	version: "0.0.0",
	parse(code, options) {
		throw Error("`context.languageOptions.parser.parse` not implemented yet.");
	},
	VisitorKeys: keys_default,
	get Syntax() {
		if (Syntax === null) {
			for (let key in Syntax = ObjectCreate(null), keys_default) Syntax[key] = key;
			freeze$1(Syntax);
		}
		return Syntax;
	},
	latestEcmaVersion: 17,
	supportedEcmaVersions: SUPPORTED_ECMA_VERSIONS
}), PARSER_OPTIONS = freeze$1({ get sourceType() {
	return ast === null && initAst(), ast.sourceType;
} }), LANGUAGE_OPTIONS = freeze$1({
	get sourceType() {
		return ast === null && initAst(), ast.sourceType;
	},
	ecmaVersion: 2026,
	parser: PARSER,
	parserOptions: PARSER_OPTIONS,
	get globals() {
		return null;
	}
}), FILE_CONTEXT = freeze$1({
	get filename() {
		if (filePath === null) throw Error("Cannot access `context.filename` in `createOnce`");
		return filePath;
	},
	getFilename() {
		if (filePath === null) throw Error("Cannot call `context.getFilename` in `createOnce`");
		return filePath;
	},
	get physicalFilename() {
		if (filePath === null) throw Error("Cannot access `context.physicalFilename` in `createOnce`");
		return filePath;
	},
	getPhysicalFilename() {
		if (filePath === null) throw Error("Cannot call `context.getPhysicalFilename` in `createOnce`");
		return filePath;
	},
	get cwd() {
		return cwd === null && (cwd = process.cwd()), cwd;
	},
	getCwd() {
		return cwd === null && (cwd = process.cwd()), cwd;
	},
	get sourceCode() {
		if (filePath === null) throw Error("Cannot access `context.sourceCode` in `createOnce`");
		return SOURCE_CODE;
	},
	getSourceCode() {
		if (filePath === null) throw Error("Cannot call `context.getSourceCode` in `createOnce`");
		return SOURCE_CODE;
	},
	get languageOptions() {
		if (filePath === null) throw Error("Cannot access `context.languageOptions` in `createOnce`");
		return LANGUAGE_OPTIONS;
	},
	get settings() {
		if (filePath === null) throw Error("Cannot access `context.settings` in `createOnce`");
		return settings === null && initSettings(), settings;
	},
	extend(extension) {
		return freeze$1(ObjectAssign(ObjectCreate(this), extension));
	},
	get parserOptions() {
		if (filePath === null) throw Error("Cannot access `context.parserOptions` in `createOnce`");
		return PARSER_OPTIONS;
	},
	get parserPath() {
		throw Error("`context.parserPath` is unsupported at present (and deprecated)");
	}
});
function createContext(fullRuleName, ruleDetails) {
	return freeze$1({
		__proto__: FILE_CONTEXT,
		get id() {
			if (filePath === null) throw Error("Cannot access `context.id` in `createOnce`");
			return fullRuleName;
		},
		get options() {
			if (filePath === null) throw Error("Cannot access `context.options` in `createOnce`");
			return ruleDetails.options;
		},
		report(diagnostic) {
			report(diagnostic, ruleDetails);
		}
	});
}
const { freeze } = Object, { isArray: isArray$3 } = Array, { min } = Math, DEFAULT_OPTIONS = Object.freeze([]);
let allOptions = [DEFAULT_OPTIONS];
function mergeOptions(configOptions, defaultOptions) {
	if (configOptions === null) return defaultOptions === null ? DEFAULT_OPTIONS : defaultOptions;
	if (defaultOptions === null) return deepFreezeJsonArray(configOptions), configOptions;
	let merged = [], defaultOptionsLength = defaultOptions.length, ruleOptionsLength = configOptions.length, bothLength = min(defaultOptionsLength, ruleOptionsLength), i = 0;
	for (; i < bothLength; i++) merged.push(mergeValues(configOptions[i], defaultOptions[i]));
	if (defaultOptionsLength > ruleOptionsLength) for (; i < defaultOptionsLength; i++) merged.push(defaultOptions[i]);
	else for (; i < ruleOptionsLength; i++) {
		let prop = configOptions[i];
		deepFreezeJsonValue(prop), merged.push(prop);
	}
	return freeze(merged);
}
function mergeValues(configValue, defaultValue) {
	if (typeof configValue != "object" || !configValue) return configValue;
	if (isArray$3(configValue)) return deepFreezeJsonArray(configValue), configValue;
	if (typeof defaultValue != "object" || !defaultValue || isArray$3(defaultValue)) return deepFreezeJsonObject(configValue), configValue;
	let merged = {
		...defaultValue,
		...configValue
	};
	for (let key in configValue) key in defaultValue ? merged[key] = mergeValues(configValue[key], defaultValue[key]) : deepFreezeJsonValue(configValue[key]);
	return freeze(merged);
}
function setOptions(optionsJson) {
	allOptions = JSON.parse(optionsJson), deepFreezeJsonArray(allOptions);
}
function getErrorMessage(err) {
	try {
		if (err instanceof Error) {
			let { stack } = err;
			if (typeof stack == "string" && stack !== "") return stack;
		}
		let { message } = err;
		if (typeof message == "string" && message !== "") return message;
	} catch {}
	return "Unknown error";
}
const ObjectKeys$2 = Object.keys, { isArray: isArray$2 } = Array, registeredRules = [], neverRunBeforeHook = () => !1;
async function loadPlugin(url, packageName) {
	try {
		let plugin = (await import(url)).default, res = registerPlugin(plugin, packageName);
		return JSON.stringify({ Success: res });
	} catch (err) {
		return JSON.stringify({ Failure: getErrorMessage(err) });
	}
}
function registerPlugin(plugin, packageName) {
	let pluginName = getPluginName(plugin, packageName), offset = registeredRules.length, { rules } = plugin, ruleNames = ObjectKeys$2(rules), ruleNamesLen = ruleNames.length;
	for (let i = 0; i < ruleNamesLen; i++) {
		let ruleName = ruleNames[i], rule = rules[ruleName], isFixable = !1, messages = null, defaultOptions = DEFAULT_OPTIONS, ruleMeta = rule.meta;
		if (ruleMeta != null) {
			if (typeof ruleMeta != "object") throw TypeError("Invalid `rule.meta`");
			let { fixable } = ruleMeta;
			if (fixable != null) {
				if (fixable !== "code" && fixable !== "whitespace") throw TypeError("Invalid `rule.meta.fixable`");
				isFixable = !0;
			}
			let inputDefaultOptions = ruleMeta.defaultOptions;
			if (inputDefaultOptions != null) {
				if (!isArray$2(inputDefaultOptions)) throw TypeError("`rule.meta.defaultOptions` must be an array if provided");
				deepFreezeJsonArray(inputDefaultOptions), defaultOptions = inputDefaultOptions;
			}
			let inputMessages = ruleMeta.messages;
			if (inputMessages != null) {
				if (typeof inputMessages != "object") throw TypeError("`rule.meta.messages` must be an object if provided");
				messages = inputMessages;
			}
		}
		let ruleDetails = {
			rule,
			context: null,
			isFixable,
			messages,
			defaultOptions,
			ruleIndex: 0,
			options: null,
			visitor: null,
			beforeHook: null,
			afterHook: null
		}, context = createContext(`${pluginName}/${ruleName}`, ruleDetails);
		if (ruleDetails.context = context, "createOnce" in rule) {
			let visitorWithHooks = rule.createOnce(context);
			if (typeof visitorWithHooks != "object" || !visitorWithHooks) throw TypeError("`createOnce` must return an object");
			let { before: beforeHook, after: afterHook, ...visitor } = visitorWithHooks;
			beforeHook = conformHookFn(beforeHook, "before"), afterHook = conformHookFn(afterHook, "after"), ObjectKeys$2(visitor).length === 0 && (beforeHook = neverRunBeforeHook, afterHook = null), ruleDetails.visitor = visitor, ruleDetails.beforeHook = beforeHook, ruleDetails.afterHook = afterHook;
		}
		registeredRules.push(ruleDetails);
	}
	return {
		name: pluginName,
		offset,
		ruleNames
	};
}
function getPluginName(plugin, packageName) {
	let pluginMeta = plugin.meta;
	if (pluginMeta != null) {
		let pluginMetaName = pluginMeta.name;
		if (pluginMetaName != null) {
			if (typeof pluginMetaName != "string") throw TypeError("`plugin.meta.name` must be a string if defined");
			return pluginMetaName;
		}
	}
	if (packageName !== null) return packageName;
	throw Error("Plugin must either define `meta.name`, or be loaded from an NPM package with a `name` field in `package.json`");
}
function conformHookFn(hookFn, hookName) {
	if (hookFn == null) return null;
	if (typeof hookFn != "function") throw TypeError(`\`${hookName}\` hook must be a function if provided`);
	return hookFn;
}
const NODE_TYPE_IDS_MAP = new Map([
	["DebuggerStatement", 0],
	["EmptyStatement", 1],
	["Literal", 2],
	["PrivateIdentifier", 3],
	["Super", 4],
	["TemplateElement", 5],
	["ThisExpression", 6],
	["JSXClosingFragment", 7],
	["JSXEmptyExpression", 8],
	["JSXIdentifier", 9],
	["JSXOpeningFragment", 10],
	["JSXText", 11],
	["TSAnyKeyword", 12],
	["TSBigIntKeyword", 13],
	["TSBooleanKeyword", 14],
	["TSIntrinsicKeyword", 15],
	["TSJSDocUnknownType", 16],
	["TSNeverKeyword", 17],
	["TSNullKeyword", 18],
	["TSNumberKeyword", 19],
	["TSObjectKeyword", 20],
	["TSStringKeyword", 21],
	["TSSymbolKeyword", 22],
	["TSThisType", 23],
	["TSUndefinedKeyword", 24],
	["TSUnknownKeyword", 25],
	["TSVoidKeyword", 26],
	["AccessorProperty", 27],
	["ArrayExpression", 28],
	["ArrayPattern", 29],
	["ArrowFunctionExpression", 30],
	["AssignmentExpression", 31],
	["AssignmentPattern", 32],
	["AwaitExpression", 33],
	["BinaryExpression", 34],
	["BlockStatement", 35],
	["BreakStatement", 36],
	["CallExpression", 37],
	["CatchClause", 38],
	["ChainExpression", 39],
	["ClassBody", 40],
	["ClassDeclaration", 41],
	["ClassExpression", 42],
	["ConditionalExpression", 43],
	["ContinueStatement", 44],
	["Decorator", 45],
	["DoWhileStatement", 46],
	["ExportAllDeclaration", 47],
	["ExportDefaultDeclaration", 48],
	["ExportNamedDeclaration", 49],
	["ExportSpecifier", 50],
	["ExpressionStatement", 51],
	["ForInStatement", 52],
	["ForOfStatement", 53],
	["ForStatement", 54],
	["FunctionDeclaration", 55],
	["FunctionExpression", 56],
	["Identifier", 57],
	["IfStatement", 58],
	["ImportAttribute", 59],
	["ImportDeclaration", 60],
	["ImportDefaultSpecifier", 61],
	["ImportExpression", 62],
	["ImportNamespaceSpecifier", 63],
	["ImportSpecifier", 64],
	["LabeledStatement", 65],
	["LogicalExpression", 66],
	["MemberExpression", 67],
	["MetaProperty", 68],
	["MethodDefinition", 69],
	["NewExpression", 70],
	["ObjectExpression", 71],
	["ObjectPattern", 72],
	["ParenthesizedExpression", 73],
	["Program", 74],
	["Property", 75],
	["PropertyDefinition", 76],
	["RestElement", 77],
	["ReturnStatement", 78],
	["SequenceExpression", 79],
	["SpreadElement", 80],
	["StaticBlock", 81],
	["SwitchCase", 82],
	["SwitchStatement", 83],
	["TaggedTemplateExpression", 84],
	["TemplateLiteral", 85],
	["ThrowStatement", 86],
	["TryStatement", 87],
	["UnaryExpression", 88],
	["UpdateExpression", 89],
	["V8IntrinsicExpression", 90],
	["VariableDeclaration", 91],
	["VariableDeclarator", 92],
	["WhileStatement", 93],
	["WithStatement", 94],
	["YieldExpression", 95],
	["JSXAttribute", 96],
	["JSXClosingElement", 97],
	["JSXElement", 98],
	["JSXExpressionContainer", 99],
	["JSXFragment", 100],
	["JSXMemberExpression", 101],
	["JSXNamespacedName", 102],
	["JSXOpeningElement", 103],
	["JSXSpreadAttribute", 104],
	["JSXSpreadChild", 105],
	["TSAbstractAccessorProperty", 106],
	["TSAbstractMethodDefinition", 107],
	["TSAbstractPropertyDefinition", 108],
	["TSArrayType", 109],
	["TSAsExpression", 110],
	["TSCallSignatureDeclaration", 111],
	["TSClassImplements", 112],
	["TSConditionalType", 113],
	["TSConstructSignatureDeclaration", 114],
	["TSConstructorType", 115],
	["TSDeclareFunction", 116],
	["TSEmptyBodyFunctionExpression", 117],
	["TSEnumBody", 118],
	["TSEnumDeclaration", 119],
	["TSEnumMember", 120],
	["TSExportAssignment", 121],
	["TSExternalModuleReference", 122],
	["TSFunctionType", 123],
	["TSImportEqualsDeclaration", 124],
	["TSImportType", 125],
	["TSIndexSignature", 126],
	["TSIndexedAccessType", 127],
	["TSInferType", 128],
	["TSInstantiationExpression", 129],
	["TSInterfaceBody", 130],
	["TSInterfaceDeclaration", 131],
	["TSInterfaceHeritage", 132],
	["TSIntersectionType", 133],
	["TSJSDocNonNullableType", 134],
	["TSJSDocNullableType", 135],
	["TSLiteralType", 136],
	["TSMappedType", 137],
	["TSMethodSignature", 138],
	["TSModuleBlock", 139],
	["TSModuleDeclaration", 140],
	["TSNamedTupleMember", 141],
	["TSNamespaceExportDeclaration", 142],
	["TSNonNullExpression", 143],
	["TSOptionalType", 144],
	["TSParameterProperty", 145],
	["TSParenthesizedType", 146],
	["TSPropertySignature", 147],
	["TSQualifiedName", 148],
	["TSRestType", 149],
	["TSSatisfiesExpression", 150],
	["TSTemplateLiteralType", 151],
	["TSTupleType", 152],
	["TSTypeAliasDeclaration", 153],
	["TSTypeAnnotation", 154],
	["TSTypeAssertion", 155],
	["TSTypeLiteral", 156],
	["TSTypeOperator", 157],
	["TSTypeParameter", 158],
	["TSTypeParameterDeclaration", 159],
	["TSTypeParameterInstantiation", 160],
	["TSTypePredicate", 161],
	["TSTypeQuery", 162],
	["TSTypeReference", 163],
	["TSUnionType", 164]
]), FUNCTION_NODE_TYPE_IDS = [
	30,
	55,
	56
];
var require_esquery_min = /* @__PURE__ */ __commonJSMin(((exports, module) => {
	(function(e, t) {
		typeof exports == "object" && module !== void 0 ? module.exports = t() : typeof define == "function" && define.amd ? define(t) : (e ||= self).esquery = t();
	})(exports, (function() {
		function e(t$1) {
			return (e = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(e$1) {
				return typeof e$1;
			} : function(e$1) {
				return e$1 && typeof Symbol == "function" && e$1.constructor === Symbol && e$1 !== Symbol.prototype ? "symbol" : typeof e$1;
			})(t$1);
		}
		function t(e$1, t$1) {
			return function(e$2) {
				if (Array.isArray(e$2)) return e$2;
			}(e$1) || function(e$2, t$2) {
				var r$1 = e$2 == null ? null : typeof Symbol < "u" && e$2[Symbol.iterator] || e$2["@@iterator"];
				if (r$1 != null) {
					var n$1, o$1, a$1, i$1, s$1 = [], u$1 = !0, l$1 = !1;
					try {
						if (a$1 = (r$1 = r$1.call(e$2)).next, t$2 === 0) {
							if (Object(r$1) !== r$1) return;
							u$1 = !1;
						} else for (; !(u$1 = (n$1 = a$1.call(r$1)).done) && (s$1.push(n$1.value), s$1.length !== t$2); u$1 = !0);
					} catch (e$3) {
						l$1 = !0, o$1 = e$3;
					} finally {
						try {
							if (!u$1 && r$1.return != null && (i$1 = r$1.return(), Object(i$1) !== i$1)) return;
						} finally {
							if (l$1) throw o$1;
						}
					}
					return s$1;
				}
			}(e$1, t$1) || n(e$1, t$1) || function() {
				throw TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
			}();
		}
		function r(e$1) {
			return function(e$2) {
				if (Array.isArray(e$2)) return o(e$2);
			}(e$1) || function(e$2) {
				if (typeof Symbol < "u" && e$2[Symbol.iterator] != null || e$2["@@iterator"] != null) return Array.from(e$2);
			}(e$1) || n(e$1) || function() {
				throw TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
			}();
		}
		function n(e$1, t$1) {
			if (e$1) {
				if (typeof e$1 == "string") return o(e$1, t$1);
				var r$1 = Object.prototype.toString.call(e$1).slice(8, -1);
				return r$1 === "Object" && e$1.constructor && (r$1 = e$1.constructor.name), r$1 === "Map" || r$1 === "Set" ? Array.from(e$1) : r$1 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r$1) ? o(e$1, t$1) : void 0;
			}
		}
		function o(e$1, t$1) {
			(t$1 == null || t$1 > e$1.length) && (t$1 = e$1.length);
			for (var r$1 = 0, n$1 = Array(t$1); r$1 < t$1; r$1++) n$1[r$1] = e$1[r$1];
			return n$1;
		}
		function a(e$1, t$1) {
			return e$1(t$1 = { exports: {} }, t$1.exports), t$1.exports;
		}
		var i = a((function(e$1, t$1) {
			(function e$2(t$2) {
				var r$1, n$1, o$1, a$1, i$1, s$1;
				function u$1(e$3) {
					var t$3, r$2, n$2 = {};
					for (t$3 in e$3) e$3.hasOwnProperty(t$3) && (r$2 = e$3[t$3], n$2[t$3] = typeof r$2 == "object" && r$2 ? u$1(r$2) : r$2);
					return n$2;
				}
				function l$1(e$3, t$3) {
					this.parent = e$3, this.key = t$3;
				}
				function c$1(e$3, t$3, r$2, n$2) {
					this.node = e$3, this.path = t$3, this.wrap = r$2, this.ref = n$2;
				}
				function f$1() {}
				function p$1(e$3) {
					return typeof e$3 == "object" && !!e$3 && typeof e$3.type == "string";
				}
				function h$1(e$3, t$3) {
					return (e$3 === r$1.ObjectExpression || e$3 === r$1.ObjectPattern) && t$3 === "properties";
				}
				function y$1(e$3, t$3) {
					for (var r$2 = e$3.length - 1; r$2 >= 0; --r$2) if (e$3[r$2].node === t$3) return !0;
					return !1;
				}
				function d$1(e$3, t$3) {
					return new f$1().traverse(e$3, t$3);
				}
				function m$1(e$3, t$3) {
					var r$2;
					return r$2 = function(e$4, t$4) {
						var r$3, n$2, o$2, a$2;
						for (n$2 = e$4.length, o$2 = 0; n$2;) t$4(e$4[a$2 = o$2 + (r$3 = n$2 >>> 1)]) ? n$2 = r$3 : (o$2 = a$2 + 1, n$2 -= r$3 + 1);
						return o$2;
					}(t$3, (function(t$4) {
						return t$4.range[0] > e$3.range[0];
					})), e$3.extendedRange = [e$3.range[0], e$3.range[1]], r$2 !== t$3.length && (e$3.extendedRange[1] = t$3[r$2].range[0]), --r$2 >= 0 && (e$3.extendedRange[0] = t$3[r$2].range[1]), e$3;
				}
				return r$1 = {
					AssignmentExpression: "AssignmentExpression",
					AssignmentPattern: "AssignmentPattern",
					ArrayExpression: "ArrayExpression",
					ArrayPattern: "ArrayPattern",
					ArrowFunctionExpression: "ArrowFunctionExpression",
					AwaitExpression: "AwaitExpression",
					BlockStatement: "BlockStatement",
					BinaryExpression: "BinaryExpression",
					BreakStatement: "BreakStatement",
					CallExpression: "CallExpression",
					CatchClause: "CatchClause",
					ChainExpression: "ChainExpression",
					ClassBody: "ClassBody",
					ClassDeclaration: "ClassDeclaration",
					ClassExpression: "ClassExpression",
					ComprehensionBlock: "ComprehensionBlock",
					ComprehensionExpression: "ComprehensionExpression",
					ConditionalExpression: "ConditionalExpression",
					ContinueStatement: "ContinueStatement",
					DebuggerStatement: "DebuggerStatement",
					DirectiveStatement: "DirectiveStatement",
					DoWhileStatement: "DoWhileStatement",
					EmptyStatement: "EmptyStatement",
					ExportAllDeclaration: "ExportAllDeclaration",
					ExportDefaultDeclaration: "ExportDefaultDeclaration",
					ExportNamedDeclaration: "ExportNamedDeclaration",
					ExportSpecifier: "ExportSpecifier",
					ExpressionStatement: "ExpressionStatement",
					ForStatement: "ForStatement",
					ForInStatement: "ForInStatement",
					ForOfStatement: "ForOfStatement",
					FunctionDeclaration: "FunctionDeclaration",
					FunctionExpression: "FunctionExpression",
					GeneratorExpression: "GeneratorExpression",
					Identifier: "Identifier",
					IfStatement: "IfStatement",
					ImportExpression: "ImportExpression",
					ImportDeclaration: "ImportDeclaration",
					ImportDefaultSpecifier: "ImportDefaultSpecifier",
					ImportNamespaceSpecifier: "ImportNamespaceSpecifier",
					ImportSpecifier: "ImportSpecifier",
					Literal: "Literal",
					LabeledStatement: "LabeledStatement",
					LogicalExpression: "LogicalExpression",
					MemberExpression: "MemberExpression",
					MetaProperty: "MetaProperty",
					MethodDefinition: "MethodDefinition",
					ModuleSpecifier: "ModuleSpecifier",
					NewExpression: "NewExpression",
					ObjectExpression: "ObjectExpression",
					ObjectPattern: "ObjectPattern",
					PrivateIdentifier: "PrivateIdentifier",
					Program: "Program",
					Property: "Property",
					PropertyDefinition: "PropertyDefinition",
					RestElement: "RestElement",
					ReturnStatement: "ReturnStatement",
					SequenceExpression: "SequenceExpression",
					SpreadElement: "SpreadElement",
					Super: "Super",
					SwitchStatement: "SwitchStatement",
					SwitchCase: "SwitchCase",
					TaggedTemplateExpression: "TaggedTemplateExpression",
					TemplateElement: "TemplateElement",
					TemplateLiteral: "TemplateLiteral",
					ThisExpression: "ThisExpression",
					ThrowStatement: "ThrowStatement",
					TryStatement: "TryStatement",
					UnaryExpression: "UnaryExpression",
					UpdateExpression: "UpdateExpression",
					VariableDeclaration: "VariableDeclaration",
					VariableDeclarator: "VariableDeclarator",
					WhileStatement: "WhileStatement",
					WithStatement: "WithStatement",
					YieldExpression: "YieldExpression"
				}, o$1 = {
					AssignmentExpression: ["left", "right"],
					AssignmentPattern: ["left", "right"],
					ArrayExpression: ["elements"],
					ArrayPattern: ["elements"],
					ArrowFunctionExpression: ["params", "body"],
					AwaitExpression: ["argument"],
					BlockStatement: ["body"],
					BinaryExpression: ["left", "right"],
					BreakStatement: ["label"],
					CallExpression: ["callee", "arguments"],
					CatchClause: ["param", "body"],
					ChainExpression: ["expression"],
					ClassBody: ["body"],
					ClassDeclaration: [
						"id",
						"superClass",
						"body"
					],
					ClassExpression: [
						"id",
						"superClass",
						"body"
					],
					ComprehensionBlock: ["left", "right"],
					ComprehensionExpression: [
						"blocks",
						"filter",
						"body"
					],
					ConditionalExpression: [
						"test",
						"consequent",
						"alternate"
					],
					ContinueStatement: ["label"],
					DebuggerStatement: [],
					DirectiveStatement: [],
					DoWhileStatement: ["body", "test"],
					EmptyStatement: [],
					ExportAllDeclaration: ["source"],
					ExportDefaultDeclaration: ["declaration"],
					ExportNamedDeclaration: [
						"declaration",
						"specifiers",
						"source"
					],
					ExportSpecifier: ["exported", "local"],
					ExpressionStatement: ["expression"],
					ForStatement: [
						"init",
						"test",
						"update",
						"body"
					],
					ForInStatement: [
						"left",
						"right",
						"body"
					],
					ForOfStatement: [
						"left",
						"right",
						"body"
					],
					FunctionDeclaration: [
						"id",
						"params",
						"body"
					],
					FunctionExpression: [
						"id",
						"params",
						"body"
					],
					GeneratorExpression: [
						"blocks",
						"filter",
						"body"
					],
					Identifier: [],
					IfStatement: [
						"test",
						"consequent",
						"alternate"
					],
					ImportExpression: ["source"],
					ImportDeclaration: ["specifiers", "source"],
					ImportDefaultSpecifier: ["local"],
					ImportNamespaceSpecifier: ["local"],
					ImportSpecifier: ["imported", "local"],
					Literal: [],
					LabeledStatement: ["label", "body"],
					LogicalExpression: ["left", "right"],
					MemberExpression: ["object", "property"],
					MetaProperty: ["meta", "property"],
					MethodDefinition: ["key", "value"],
					ModuleSpecifier: [],
					NewExpression: ["callee", "arguments"],
					ObjectExpression: ["properties"],
					ObjectPattern: ["properties"],
					PrivateIdentifier: [],
					Program: ["body"],
					Property: ["key", "value"],
					PropertyDefinition: ["key", "value"],
					RestElement: ["argument"],
					ReturnStatement: ["argument"],
					SequenceExpression: ["expressions"],
					SpreadElement: ["argument"],
					Super: [],
					SwitchStatement: ["discriminant", "cases"],
					SwitchCase: ["test", "consequent"],
					TaggedTemplateExpression: ["tag", "quasi"],
					TemplateElement: [],
					TemplateLiteral: ["quasis", "expressions"],
					ThisExpression: [],
					ThrowStatement: ["argument"],
					TryStatement: [
						"block",
						"handler",
						"finalizer"
					],
					UnaryExpression: ["argument"],
					UpdateExpression: ["argument"],
					VariableDeclaration: ["declarations"],
					VariableDeclarator: ["id", "init"],
					WhileStatement: ["test", "body"],
					WithStatement: ["object", "body"],
					YieldExpression: ["argument"]
				}, n$1 = {
					Break: a$1 = {},
					Skip: i$1 = {},
					Remove: s$1 = {}
				}, l$1.prototype.replace = function(e$3) {
					this.parent[this.key] = e$3;
				}, l$1.prototype.remove = function() {
					return Array.isArray(this.parent) ? (this.parent.splice(this.key, 1), !0) : (this.replace(null), !1);
				}, f$1.prototype.path = function() {
					var e$3, t$3, r$2, n$2, o$2;
					function a$2(e$4, t$4) {
						if (Array.isArray(t$4)) for (r$2 = 0, n$2 = t$4.length; r$2 < n$2; ++r$2) e$4.push(t$4[r$2]);
						else e$4.push(t$4);
					}
					if (!this.__current.path) return null;
					for (o$2 = [], e$3 = 2, t$3 = this.__leavelist.length; e$3 < t$3; ++e$3) a$2(o$2, this.__leavelist[e$3].path);
					return a$2(o$2, this.__current.path), o$2;
				}, f$1.prototype.type = function() {
					return this.current().type || this.__current.wrap;
				}, f$1.prototype.parents = function() {
					var e$3, t$3, r$2;
					for (r$2 = [], e$3 = 1, t$3 = this.__leavelist.length; e$3 < t$3; ++e$3) r$2.push(this.__leavelist[e$3].node);
					return r$2;
				}, f$1.prototype.current = function() {
					return this.__current.node;
				}, f$1.prototype.__execute = function(e$3, t$3) {
					var r$2, n$2;
					return n$2 = void 0, r$2 = this.__current, this.__current = t$3, this.__state = null, e$3 && (n$2 = e$3.call(this, t$3.node, this.__leavelist[this.__leavelist.length - 1].node)), this.__current = r$2, n$2;
				}, f$1.prototype.notify = function(e$3) {
					this.__state = e$3;
				}, f$1.prototype.skip = function() {
					this.notify(i$1);
				}, f$1.prototype.break = function() {
					this.notify(a$1);
				}, f$1.prototype.remove = function() {
					this.notify(s$1);
				}, f$1.prototype.__initialize = function(e$3, t$3) {
					this.visitor = t$3, this.root = e$3, this.__worklist = [], this.__leavelist = [], this.__current = null, this.__state = null, this.__fallback = null, t$3.fallback === "iteration" ? this.__fallback = Object.keys : typeof t$3.fallback == "function" && (this.__fallback = t$3.fallback), this.__keys = o$1, t$3.keys && (this.__keys = Object.assign(Object.create(this.__keys), t$3.keys));
				}, f$1.prototype.traverse = function(e$3, t$3) {
					var r$2, n$2, o$2, s$2, u$2, l$2, f$2, d$2, m$2, x$1, v$1, g$1;
					for (this.__initialize(e$3, t$3), g$1 = {}, r$2 = this.__worklist, n$2 = this.__leavelist, r$2.push(new c$1(e$3, null, null, null)), n$2.push(new c$1(null, null, null, null)); r$2.length;) if ((o$2 = r$2.pop()) !== g$1) {
						if (o$2.node) {
							if (l$2 = this.__execute(t$3.enter, o$2), this.__state === a$1 || l$2 === a$1) return;
							if (r$2.push(g$1), n$2.push(o$2), this.__state === i$1 || l$2 === i$1) continue;
							if (u$2 = (s$2 = o$2.node).type || o$2.wrap, !(x$1 = this.__keys[u$2])) {
								if (!this.__fallback) throw Error("Unknown node type " + u$2 + ".");
								x$1 = this.__fallback(s$2);
							}
							for (d$2 = x$1.length; --d$2 >= 0;) if (v$1 = s$2[f$2 = x$1[d$2]]) {
								if (Array.isArray(v$1)) {
									for (m$2 = v$1.length; --m$2 >= 0;) if (v$1[m$2] && !y$1(n$2, v$1[m$2])) {
										if (h$1(u$2, x$1[d$2])) o$2 = new c$1(v$1[m$2], [f$2, m$2], "Property", null);
										else {
											if (!p$1(v$1[m$2])) continue;
											o$2 = new c$1(v$1[m$2], [f$2, m$2], null, null);
										}
										r$2.push(o$2);
									}
								} else if (p$1(v$1)) {
									if (y$1(n$2, v$1)) continue;
									r$2.push(new c$1(v$1, f$2, null, null));
								}
							}
						}
					} else if (o$2 = n$2.pop(), l$2 = this.__execute(t$3.leave, o$2), this.__state === a$1 || l$2 === a$1) return;
				}, f$1.prototype.replace = function(e$3, t$3) {
					var r$2, n$2, o$2, u$2, f$2, y$2, d$2, m$2, x$1, v$1, g$1, A$1, E;
					function b(e$4) {
						var t$4, n$3, o$3, a$2;
						if (e$4.ref.remove()) {
							for (n$3 = e$4.ref.key, a$2 = e$4.ref.parent, t$4 = r$2.length; t$4--;) if ((o$3 = r$2[t$4]).ref && o$3.ref.parent === a$2) {
								if (o$3.ref.key < n$3) break;
								--o$3.ref.key;
							}
						}
					}
					for (this.__initialize(e$3, t$3), g$1 = {}, r$2 = this.__worklist, n$2 = this.__leavelist, y$2 = new c$1(e$3, null, null, new l$1(A$1 = { root: e$3 }, "root")), r$2.push(y$2), n$2.push(y$2); r$2.length;) if ((y$2 = r$2.pop()) !== g$1) {
						if ((f$2 = this.__execute(t$3.enter, y$2)) !== void 0 && f$2 !== a$1 && f$2 !== i$1 && f$2 !== s$1 && (y$2.ref.replace(f$2), y$2.node = f$2), this.__state !== s$1 && f$2 !== s$1 || (b(y$2), y$2.node = null), this.__state === a$1 || f$2 === a$1) return A$1.root;
						if ((o$2 = y$2.node) && (r$2.push(g$1), n$2.push(y$2), this.__state !== i$1 && f$2 !== i$1)) {
							if (u$2 = o$2.type || y$2.wrap, !(x$1 = this.__keys[u$2])) {
								if (!this.__fallback) throw Error("Unknown node type " + u$2 + ".");
								x$1 = this.__fallback(o$2);
							}
							for (d$2 = x$1.length; --d$2 >= 0;) if (v$1 = o$2[E = x$1[d$2]]) if (Array.isArray(v$1)) {
								for (m$2 = v$1.length; --m$2 >= 0;) if (v$1[m$2]) {
									if (h$1(u$2, x$1[d$2])) y$2 = new c$1(v$1[m$2], [E, m$2], "Property", new l$1(v$1, m$2));
									else {
										if (!p$1(v$1[m$2])) continue;
										y$2 = new c$1(v$1[m$2], [E, m$2], null, new l$1(v$1, m$2));
									}
									r$2.push(y$2);
								}
							} else p$1(v$1) && r$2.push(new c$1(v$1, E, null, new l$1(o$2, E)));
						}
					} else if (y$2 = n$2.pop(), (f$2 = this.__execute(t$3.leave, y$2)) !== void 0 && f$2 !== a$1 && f$2 !== i$1 && f$2 !== s$1 && y$2.ref.replace(f$2), this.__state !== s$1 && f$2 !== s$1 || b(y$2), this.__state === a$1 || f$2 === a$1) return A$1.root;
					return A$1.root;
				}, t$2.Syntax = r$1, t$2.traverse = d$1, t$2.replace = function(e$3, t$3) {
					return new f$1().replace(e$3, t$3);
				}, t$2.attachComments = function(e$3, t$3, r$2) {
					var o$2, a$2, i$2, s$2, l$2 = [];
					if (!e$3.range) throw Error("attachComments needs range information");
					if (!r$2.length) {
						if (t$3.length) {
							for (i$2 = 0, a$2 = t$3.length; i$2 < a$2; i$2 += 1) (o$2 = u$1(t$3[i$2])).extendedRange = [0, e$3.range[0]], l$2.push(o$2);
							e$3.leadingComments = l$2;
						}
						return e$3;
					}
					for (i$2 = 0, a$2 = t$3.length; i$2 < a$2; i$2 += 1) l$2.push(m$1(u$1(t$3[i$2]), r$2));
					return s$2 = 0, d$1(e$3, { enter: function(e$4) {
						for (var t$4; s$2 < l$2.length && !((t$4 = l$2[s$2]).extendedRange[1] > e$4.range[0]);) t$4.extendedRange[1] === e$4.range[0] ? (e$4.leadingComments ||= [], e$4.leadingComments.push(t$4), l$2.splice(s$2, 1)) : s$2 += 1;
						return s$2 === l$2.length ? n$1.Break : l$2[s$2].extendedRange[0] > e$4.range[1] ? n$1.Skip : void 0;
					} }), s$2 = 0, d$1(e$3, { leave: function(e$4) {
						for (var t$4; s$2 < l$2.length && (t$4 = l$2[s$2], !(e$4.range[1] < t$4.extendedRange[0]));) e$4.range[1] === t$4.extendedRange[0] ? (e$4.trailingComments ||= [], e$4.trailingComments.push(t$4), l$2.splice(s$2, 1)) : s$2 += 1;
						return s$2 === l$2.length ? n$1.Break : l$2[s$2].extendedRange[0] > e$4.range[1] ? n$1.Skip : void 0;
					} }), e$3;
				}, t$2.VisitorKeys = o$1, t$2.VisitorOption = n$1, t$2.Controller = f$1, t$2.cloneEnvironment = function() {
					return e$2({});
				}, t$2;
			})(t$1);
		})), s = a((function(e$1) {
			e$1.exports &&= function() {
				function e$2(t$1, r$1, n$1, o$1) {
					this.message = t$1, this.expected = r$1, this.found = n$1, this.location = o$1, this.name = "SyntaxError", typeof Error.captureStackTrace == "function" && Error.captureStackTrace(this, e$2);
				}
				return function(e$3, t$1) {
					function r$1() {
						this.constructor = e$3;
					}
					r$1.prototype = t$1.prototype, e$3.prototype = new r$1();
				}(e$2, Error), e$2.buildMessage = function(e$3, t$1) {
					var r$1 = {
						literal: function(e$4) {
							return "\"" + o$1(e$4.text) + "\"";
						},
						class: function(e$4) {
							var t$2, r$2 = "";
							for (t$2 = 0; t$2 < e$4.parts.length; t$2++) r$2 += e$4.parts[t$2] instanceof Array ? a$1(e$4.parts[t$2][0]) + "-" + a$1(e$4.parts[t$2][1]) : a$1(e$4.parts[t$2]);
							return "[" + (e$4.inverted ? "^" : "") + r$2 + "]";
						},
						any: function(e$4) {
							return "any character";
						},
						end: function(e$4) {
							return "end of input";
						},
						other: function(e$4) {
							return e$4.description;
						}
					};
					function n$1(e$4) {
						return e$4.charCodeAt(0).toString(16).toUpperCase();
					}
					function o$1(e$4) {
						return e$4.replace(/\\/g, "\\\\").replace(/"/g, "\\\"").replace(/\0/g, "\\0").replace(/\t/g, "\\t").replace(/\n/g, "\\n").replace(/\r/g, "\\r").replace(/[\x00-\x0F]/g, (function(e$5) {
							return "\\x0" + n$1(e$5);
						})).replace(/[\x10-\x1F\x7F-\x9F]/g, (function(e$5) {
							return "\\x" + n$1(e$5);
						}));
					}
					function a$1(e$4) {
						return e$4.replace(/\\/g, "\\\\").replace(/\]/g, "\\]").replace(/\^/g, "\\^").replace(/-/g, "\\-").replace(/\0/g, "\\0").replace(/\t/g, "\\t").replace(/\n/g, "\\n").replace(/\r/g, "\\r").replace(/[\x00-\x0F]/g, (function(e$5) {
							return "\\x0" + n$1(e$5);
						})).replace(/[\x10-\x1F\x7F-\x9F]/g, (function(e$5) {
							return "\\x" + n$1(e$5);
						}));
					}
					return "Expected " + function(e$4) {
						var t$2, n$2, o$2, a$2 = Array(e$4.length);
						for (t$2 = 0; t$2 < e$4.length; t$2++) a$2[t$2] = (o$2 = e$4[t$2], r$1[o$2.type](o$2));
						if (a$2.sort(), a$2.length > 0) {
							for (t$2 = 1, n$2 = 1; t$2 < a$2.length; t$2++) a$2[t$2 - 1] !== a$2[t$2] && (a$2[n$2] = a$2[t$2], n$2++);
							a$2.length = n$2;
						}
						switch (a$2.length) {
							case 1: return a$2[0];
							case 2: return a$2[0] + " or " + a$2[1];
							default: return a$2.slice(0, -1).join(", ") + ", or " + a$2[a$2.length - 1];
						}
					}(e$3) + " but " + function(e$4) {
						return e$4 ? "\"" + o$1(e$4) + "\"" : "end of input";
					}(t$1) + " found.";
				}, {
					SyntaxError: e$2,
					parse: function(t$1, r$1) {
						r$1 = r$1 === void 0 ? {} : r$1;
						var n$1, o$1, a$1, i$1, s$1 = {}, u$1 = { start: me }, l$1 = me, c$1 = fe(" ", !1), f$1 = /^[^ [\],():#!=><~+.]/, p$1 = pe([
							" ",
							"[",
							"]",
							",",
							"(",
							")",
							":",
							"#",
							"!",
							"=",
							">",
							"<",
							"~",
							"+",
							"."
						], !0, !1), h$1 = fe(">", !1), y$1 = fe("~", !1), d$1 = fe("+", !1), m$1 = fe(",", !1), x$1 = function(e$3, t$2) {
							return [e$3].concat(t$2.map((function(e$4) {
								return e$4[3];
							})));
						}, v$1 = fe("!", !1), g$1 = fe("*", !1), A$1 = fe("#", !1), E = fe("[", !1), b = fe("]", !1), S = /^[><!]/, _ = pe([
							">",
							"<",
							"!"
						], !1, !1), C = fe("=", !1), w = function(e$3) {
							return (e$3 || "") + "=";
						}, P = /^[><]/, k = pe([">", "<"], !1, !1), D = fe(".", !1), I = function(e$3, t$2, r$2) {
							return {
								type: "attribute",
								name: e$3,
								operator: t$2,
								value: r$2
							};
						}, j = fe("\"", !1), T = /^[^\\"]/, F = pe(["\\", "\""], !0, !1), R = fe("\\", !1), O = { type: "any" }, L = function(e$3, t$2) {
							return e$3 + t$2;
						}, M = function(e$3) {
							return {
								type: "literal",
								value: (t$2 = e$3.join(""), t$2.replace(/\\(.)/g, (function(e$4, t$3) {
									switch (t$3) {
										case "b": return "\b";
										case "f": return "\f";
										case "n": return "\n";
										case "r": return "\r";
										case "t": return "	";
										case "v": return "\v";
										default: return t$3;
									}
								})))
							};
							var t$2;
						}, B = fe("'", !1), U = /^[^\\']/, K = pe(["\\", "'"], !0, !1), N = /^[0-9]/, W = pe([["0", "9"]], !1, !1), q = fe("type(", !1), V = /^[^ )]/, G = pe([" ", ")"], !0, !1), z = fe(")", !1), H = /^[imsu]/, Y = pe([
							"i",
							"m",
							"s",
							"u"
						], !1, !1), $ = fe("/", !1), J = /^[^\/]/, Q = pe(["/"], !0, !1), X = fe(":not(", !1), Z = fe(":matches(", !1), ee = fe(":has(", !1), te = fe(":first-child", !1), re = fe(":last-child", !1), ne = fe(":nth-child(", !1), oe = fe(":nth-last-child(", !1), ae = fe(":", !1), ie = 0, se = [{
							line: 1,
							column: 1
						}], ue = 0, le = [], ce = {};
						if ("startRule" in r$1) {
							if (!(r$1.startRule in u$1)) throw Error("Can't start parsing from rule \"" + r$1.startRule + "\".");
							l$1 = u$1[r$1.startRule];
						}
						function fe(e$3, t$2) {
							return {
								type: "literal",
								text: e$3,
								ignoreCase: t$2
							};
						}
						function pe(e$3, t$2, r$2) {
							return {
								type: "class",
								parts: e$3,
								inverted: t$2,
								ignoreCase: r$2
							};
						}
						function he(e$3) {
							var r$2, n$2 = se[e$3];
							if (n$2) return n$2;
							for (r$2 = e$3 - 1; !se[r$2];) r$2--;
							for (n$2 = {
								line: (n$2 = se[r$2]).line,
								column: n$2.column
							}; r$2 < e$3;) t$1.charCodeAt(r$2) === 10 ? (n$2.line++, n$2.column = 1) : n$2.column++, r$2++;
							return se[e$3] = n$2, n$2;
						}
						function ye(e$3, t$2) {
							var r$2 = he(e$3), n$2 = he(t$2);
							return {
								start: {
									offset: e$3,
									line: r$2.line,
									column: r$2.column
								},
								end: {
									offset: t$2,
									line: n$2.line,
									column: n$2.column
								}
							};
						}
						function de(e$3) {
							ie < ue || (ie > ue && (ue = ie, le = []), le.push(e$3));
						}
						function me() {
							var e$3, t$2, r$2, n$2, o$2 = 32 * ie + 0, a$2 = ce[o$2];
							return a$2 ? (ie = a$2.nextPos, a$2.result) : (e$3 = ie, (t$2 = xe()) !== s$1 && (r$2 = Ae()) !== s$1 && xe() !== s$1 ? e$3 = t$2 = (n$2 = r$2).length === 1 ? n$2[0] : {
								type: "matches",
								selectors: n$2
							} : (ie = e$3, e$3 = s$1), e$3 === s$1 && (e$3 = ie, (t$2 = xe()) !== s$1 && (t$2 = void 0), e$3 = t$2), ce[o$2] = {
								nextPos: ie,
								result: e$3
							}, e$3);
						}
						function xe() {
							var e$3, r$2, n$2 = 32 * ie + 1, o$2 = ce[n$2];
							if (o$2) return ie = o$2.nextPos, o$2.result;
							for (e$3 = [], t$1.charCodeAt(ie) === 32 ? (r$2 = " ", ie++) : (r$2 = s$1, de(c$1)); r$2 !== s$1;) e$3.push(r$2), t$1.charCodeAt(ie) === 32 ? (r$2 = " ", ie++) : (r$2 = s$1, de(c$1));
							return ce[n$2] = {
								nextPos: ie,
								result: e$3
							}, e$3;
						}
						function ve() {
							var e$3, r$2, n$2, o$2 = 32 * ie + 2, a$2 = ce[o$2];
							if (a$2) return ie = a$2.nextPos, a$2.result;
							if (r$2 = [], f$1.test(t$1.charAt(ie)) ? (n$2 = t$1.charAt(ie), ie++) : (n$2 = s$1, de(p$1)), n$2 !== s$1) for (; n$2 !== s$1;) r$2.push(n$2), f$1.test(t$1.charAt(ie)) ? (n$2 = t$1.charAt(ie), ie++) : (n$2 = s$1, de(p$1));
							else r$2 = s$1;
							return r$2 !== s$1 && (r$2 = r$2.join("")), e$3 = r$2, ce[o$2] = {
								nextPos: ie,
								result: e$3
							}, e$3;
						}
						function ge() {
							var e$3, r$2, n$2, o$2 = 32 * ie + 3, a$2 = ce[o$2];
							return a$2 ? (ie = a$2.nextPos, a$2.result) : (e$3 = ie, (r$2 = xe()) === s$1 ? (ie = e$3, e$3 = s$1) : (t$1.charCodeAt(ie) === 62 ? (n$2 = ">", ie++) : (n$2 = s$1, de(h$1)), n$2 !== s$1 && xe() !== s$1 ? e$3 = r$2 = "child" : (ie = e$3, e$3 = s$1)), e$3 === s$1 && (e$3 = ie, (r$2 = xe()) === s$1 ? (ie = e$3, e$3 = s$1) : (t$1.charCodeAt(ie) === 126 ? (n$2 = "~", ie++) : (n$2 = s$1, de(y$1)), n$2 !== s$1 && xe() !== s$1 ? e$3 = r$2 = "sibling" : (ie = e$3, e$3 = s$1)), e$3 === s$1 && (e$3 = ie, (r$2 = xe()) === s$1 ? (ie = e$3, e$3 = s$1) : (t$1.charCodeAt(ie) === 43 ? (n$2 = "+", ie++) : (n$2 = s$1, de(d$1)), n$2 !== s$1 && xe() !== s$1 ? e$3 = r$2 = "adjacent" : (ie = e$3, e$3 = s$1)), e$3 === s$1 && (e$3 = ie, t$1.charCodeAt(ie) === 32 ? (r$2 = " ", ie++) : (r$2 = s$1, de(c$1)), r$2 !== s$1 && (n$2 = xe()) !== s$1 ? e$3 = r$2 = "descendant" : (ie = e$3, e$3 = s$1)))), ce[o$2] = {
								nextPos: ie,
								result: e$3
							}, e$3);
						}
						function Ae() {
							var e$3, r$2, n$2, o$2, a$2, i$2, u$2, l$2, c$2 = 32 * ie + 5, f$2 = ce[c$2];
							if (f$2) return ie = f$2.nextPos, f$2.result;
							if (e$3 = ie, (r$2 = be()) !== s$1) {
								for (n$2 = [], o$2 = ie, (a$2 = xe()) === s$1 ? (ie = o$2, o$2 = s$1) : (t$1.charCodeAt(ie) === 44 ? (i$2 = ",", ie++) : (i$2 = s$1, de(m$1)), i$2 !== s$1 && (u$2 = xe()) !== s$1 && (l$2 = be()) !== s$1 ? o$2 = a$2 = [
									a$2,
									i$2,
									u$2,
									l$2
								] : (ie = o$2, o$2 = s$1)); o$2 !== s$1;) n$2.push(o$2), o$2 = ie, (a$2 = xe()) === s$1 ? (ie = o$2, o$2 = s$1) : (t$1.charCodeAt(ie) === 44 ? (i$2 = ",", ie++) : (i$2 = s$1, de(m$1)), i$2 !== s$1 && (u$2 = xe()) !== s$1 && (l$2 = be()) !== s$1 ? o$2 = a$2 = [
									a$2,
									i$2,
									u$2,
									l$2
								] : (ie = o$2, o$2 = s$1));
								n$2 === s$1 ? (ie = e$3, e$3 = s$1) : e$3 = r$2 = x$1(r$2, n$2);
							} else ie = e$3, e$3 = s$1;
							return ce[c$2] = {
								nextPos: ie,
								result: e$3
							}, e$3;
						}
						function Ee() {
							var e$3, t$2, r$2, n$2, o$2, a$2 = 32 * ie + 6, i$2 = ce[a$2];
							return i$2 ? (ie = i$2.nextPos, i$2.result) : (e$3 = ie, (t$2 = ge()) === s$1 && (t$2 = null), t$2 !== s$1 && (r$2 = be()) !== s$1 ? (o$2 = r$2, e$3 = t$2 = (n$2 = t$2) ? {
								type: n$2,
								left: { type: "exactNode" },
								right: o$2
							} : o$2) : (ie = e$3, e$3 = s$1), ce[a$2] = {
								nextPos: ie,
								result: e$3
							}, e$3);
						}
						function be() {
							var e$3, t$2, r$2, n$2, o$2, a$2, i$2, u$2 = 32 * ie + 7, l$2 = ce[u$2];
							if (l$2) return ie = l$2.nextPos, l$2.result;
							if (e$3 = ie, (t$2 = Se()) !== s$1) {
								for (r$2 = [], n$2 = ie, (o$2 = ge()) !== s$1 && (a$2 = Se()) !== s$1 ? n$2 = o$2 = [o$2, a$2] : (ie = n$2, n$2 = s$1); n$2 !== s$1;) r$2.push(n$2), n$2 = ie, (o$2 = ge()) !== s$1 && (a$2 = Se()) !== s$1 ? n$2 = o$2 = [o$2, a$2] : (ie = n$2, n$2 = s$1);
								r$2 === s$1 ? (ie = e$3, e$3 = s$1) : (i$2 = t$2, e$3 = t$2 = r$2.reduce((function(e$4, t$3) {
									return {
										type: t$3[0],
										left: e$4,
										right: t$3[1]
									};
								}), i$2));
							} else ie = e$3, e$3 = s$1;
							return ce[u$2] = {
								nextPos: ie,
								result: e$3
							}, e$3;
						}
						function Se() {
							var e$3, r$2, n$2, o$2, a$2, i$2, u$2, l$2 = 32 * ie + 8, c$2 = ce[l$2];
							if (c$2) return ie = c$2.nextPos, c$2.result;
							if (e$3 = ie, t$1.charCodeAt(ie) === 33 ? (r$2 = "!", ie++) : (r$2 = s$1, de(v$1)), r$2 === s$1 && (r$2 = null), r$2 !== s$1) {
								if (n$2 = [], (o$2 = _e()) !== s$1) for (; o$2 !== s$1;) n$2.push(o$2), o$2 = _e();
								else n$2 = s$1;
								n$2 === s$1 ? (ie = e$3, e$3 = s$1) : (a$2 = r$2, u$2 = (i$2 = n$2).length === 1 ? i$2[0] : {
									type: "compound",
									selectors: i$2
								}, a$2 && (u$2.subject = !0), e$3 = r$2 = u$2);
							} else ie = e$3, e$3 = s$1;
							return ce[l$2] = {
								nextPos: ie,
								result: e$3
							}, e$3;
						}
						function _e() {
							var e$3, r$2 = 32 * ie + 9, n$2 = ce[r$2];
							return n$2 ? (ie = n$2.nextPos, n$2.result) : ((e$3 = function() {
								var e$4, r$3, n$3 = 32 * ie + 10, o$2 = ce[n$3];
								return o$2 ? (ie = o$2.nextPos, o$2.result) : (t$1.charCodeAt(ie) === 42 ? (r$3 = "*", ie++) : (r$3 = s$1, de(g$1)), r$3 !== s$1 && (r$3 = {
									type: "wildcard",
									value: r$3
								}), e$4 = r$3, ce[n$3] = {
									nextPos: ie,
									result: e$4
								}, e$4);
							}()) === s$1 && (e$3 = function() {
								var e$4, r$3, n$3, o$2 = 32 * ie + 11, a$2 = ce[o$2];
								return a$2 ? (ie = a$2.nextPos, a$2.result) : (e$4 = ie, t$1.charCodeAt(ie) === 35 ? (r$3 = "#", ie++) : (r$3 = s$1, de(A$1)), r$3 === s$1 && (r$3 = null), r$3 !== s$1 && (n$3 = ve()) !== s$1 ? e$4 = r$3 = {
									type: "identifier",
									value: n$3
								} : (ie = e$4, e$4 = s$1), ce[o$2] = {
									nextPos: ie,
									result: e$4
								}, e$4);
							}()) === s$1 && (e$3 = function() {
								var e$4, r$3, n$3, o$2, a$2 = 32 * ie + 12, i$2 = ce[a$2];
								return i$2 ? (ie = i$2.nextPos, i$2.result) : (e$4 = ie, t$1.charCodeAt(ie) === 91 ? (r$3 = "[", ie++) : (r$3 = s$1, de(E)), r$3 !== s$1 && xe() !== s$1 && (n$3 = function() {
									var e$5, r$4, n$4, o$3, a$3 = 32 * ie + 16, i$3 = ce[a$3];
									return i$3 ? (ie = i$3.nextPos, i$3.result) : (e$5 = ie, (r$4 = Ce()) !== s$1 && xe() !== s$1 && (n$4 = function() {
										var e$6, r$5, n$5, o$4 = 32 * ie + 14, a$4 = ce[o$4];
										return a$4 ? (ie = a$4.nextPos, a$4.result) : (e$6 = ie, t$1.charCodeAt(ie) === 33 ? (r$5 = "!", ie++) : (r$5 = s$1, de(v$1)), r$5 === s$1 && (r$5 = null), r$5 === s$1 ? (ie = e$6, e$6 = s$1) : (t$1.charCodeAt(ie) === 61 ? (n$5 = "=", ie++) : (n$5 = s$1, de(C)), n$5 === s$1 ? (ie = e$6, e$6 = s$1) : (r$5 = w(r$5), e$6 = r$5)), ce[o$4] = {
											nextPos: ie,
											result: e$6
										}, e$6);
									}()) !== s$1 && xe() !== s$1 ? ((o$3 = function() {
										var e$6, r$5, n$5, o$4, a$4, i$4 = 32 * ie + 20, u$2 = ce[i$4];
										if (u$2) return ie = u$2.nextPos, u$2.result;
										if (e$6 = ie, t$1.substr(ie, 5) === "type(" ? (r$5 = "type(", ie += 5) : (r$5 = s$1, de(q)), r$5 !== s$1) if (xe() !== s$1) {
											if (n$5 = [], V.test(t$1.charAt(ie)) ? (o$4 = t$1.charAt(ie), ie++) : (o$4 = s$1, de(G)), o$4 !== s$1) for (; o$4 !== s$1;) n$5.push(o$4), V.test(t$1.charAt(ie)) ? (o$4 = t$1.charAt(ie), ie++) : (o$4 = s$1, de(G));
											else n$5 = s$1;
											n$5 !== s$1 && (o$4 = xe()) !== s$1 ? (t$1.charCodeAt(ie) === 41 ? (a$4 = ")", ie++) : (a$4 = s$1, de(z)), a$4 === s$1 ? (ie = e$6, e$6 = s$1) : (r$5 = {
												type: "type",
												value: n$5.join("")
											}, e$6 = r$5)) : (ie = e$6, e$6 = s$1);
										} else ie = e$6, e$6 = s$1;
										else ie = e$6, e$6 = s$1;
										return ce[i$4] = {
											nextPos: ie,
											result: e$6
										}, e$6;
									}()) === s$1 && (o$3 = function() {
										var e$6, r$5, n$5, o$4, a$4, i$4, u$2 = 32 * ie + 22, l$2 = ce[u$2];
										if (l$2) return ie = l$2.nextPos, l$2.result;
										if (e$6 = ie, t$1.charCodeAt(ie) === 47 ? (r$5 = "/", ie++) : (r$5 = s$1, de($)), r$5 !== s$1) {
											if (n$5 = [], J.test(t$1.charAt(ie)) ? (o$4 = t$1.charAt(ie), ie++) : (o$4 = s$1, de(Q)), o$4 !== s$1) for (; o$4 !== s$1;) n$5.push(o$4), J.test(t$1.charAt(ie)) ? (o$4 = t$1.charAt(ie), ie++) : (o$4 = s$1, de(Q));
											else n$5 = s$1;
											n$5 === s$1 ? (ie = e$6, e$6 = s$1) : (t$1.charCodeAt(ie) === 47 ? (o$4 = "/", ie++) : (o$4 = s$1, de($)), o$4 === s$1 ? (ie = e$6, e$6 = s$1) : ((a$4 = function() {
												var e$7, r$6, n$6 = 32 * ie + 21, o$5 = ce[n$6];
												if (o$5) return ie = o$5.nextPos, o$5.result;
												if (e$7 = [], H.test(t$1.charAt(ie)) ? (r$6 = t$1.charAt(ie), ie++) : (r$6 = s$1, de(Y)), r$6 !== s$1) for (; r$6 !== s$1;) e$7.push(r$6), H.test(t$1.charAt(ie)) ? (r$6 = t$1.charAt(ie), ie++) : (r$6 = s$1, de(Y));
												else e$7 = s$1;
												return ce[n$6] = {
													nextPos: ie,
													result: e$7
												}, e$7;
											}()) === s$1 && (a$4 = null), a$4 === s$1 ? (ie = e$6, e$6 = s$1) : (i$4 = a$4, r$5 = {
												type: "regexp",
												value: new RegExp(n$5.join(""), i$4 ? i$4.join("") : "")
											}, e$6 = r$5)));
										} else ie = e$6, e$6 = s$1;
										return ce[u$2] = {
											nextPos: ie,
											result: e$6
										}, e$6;
									}()), o$3 === s$1 ? (ie = e$5, e$5 = s$1) : (r$4 = I(r$4, n$4, o$3), e$5 = r$4)) : (ie = e$5, e$5 = s$1), e$5 === s$1 && (e$5 = ie, (r$4 = Ce()) !== s$1 && xe() !== s$1 && (n$4 = function() {
										var e$6, r$5, n$5, o$4 = 32 * ie + 13, a$4 = ce[o$4];
										return a$4 ? (ie = a$4.nextPos, a$4.result) : (e$6 = ie, S.test(t$1.charAt(ie)) ? (r$5 = t$1.charAt(ie), ie++) : (r$5 = s$1, de(_)), r$5 === s$1 && (r$5 = null), r$5 === s$1 ? (ie = e$6, e$6 = s$1) : (t$1.charCodeAt(ie) === 61 ? (n$5 = "=", ie++) : (n$5 = s$1, de(C)), n$5 === s$1 ? (ie = e$6, e$6 = s$1) : (r$5 = w(r$5), e$6 = r$5)), e$6 === s$1 && (P.test(t$1.charAt(ie)) ? (e$6 = t$1.charAt(ie), ie++) : (e$6 = s$1, de(k))), ce[o$4] = {
											nextPos: ie,
											result: e$6
										}, e$6);
									}()) !== s$1 && xe() !== s$1 ? ((o$3 = function() {
										var e$6, r$5, n$5, o$4, a$4, i$4, u$2 = 32 * ie + 17, l$2 = ce[u$2];
										if (l$2) return ie = l$2.nextPos, l$2.result;
										if (e$6 = ie, t$1.charCodeAt(ie) === 34 ? (r$5 = "\"", ie++) : (r$5 = s$1, de(j)), r$5 !== s$1) {
											for (n$5 = [], T.test(t$1.charAt(ie)) ? (o$4 = t$1.charAt(ie), ie++) : (o$4 = s$1, de(F)), o$4 === s$1 && (o$4 = ie, t$1.charCodeAt(ie) === 92 ? (a$4 = "\\", ie++) : (a$4 = s$1, de(R)), a$4 === s$1 ? (ie = o$4, o$4 = s$1) : (t$1.length > ie ? (i$4 = t$1.charAt(ie), ie++) : (i$4 = s$1, de(O)), i$4 === s$1 ? (ie = o$4, o$4 = s$1) : (a$4 = L(a$4, i$4), o$4 = a$4))); o$4 !== s$1;) n$5.push(o$4), T.test(t$1.charAt(ie)) ? (o$4 = t$1.charAt(ie), ie++) : (o$4 = s$1, de(F)), o$4 === s$1 && (o$4 = ie, t$1.charCodeAt(ie) === 92 ? (a$4 = "\\", ie++) : (a$4 = s$1, de(R)), a$4 === s$1 ? (ie = o$4, o$4 = s$1) : (t$1.length > ie ? (i$4 = t$1.charAt(ie), ie++) : (i$4 = s$1, de(O)), i$4 === s$1 ? (ie = o$4, o$4 = s$1) : (a$4 = L(a$4, i$4), o$4 = a$4)));
											n$5 === s$1 ? (ie = e$6, e$6 = s$1) : (t$1.charCodeAt(ie) === 34 ? (o$4 = "\"", ie++) : (o$4 = s$1, de(j)), o$4 === s$1 ? (ie = e$6, e$6 = s$1) : (r$5 = M(n$5), e$6 = r$5));
										} else ie = e$6, e$6 = s$1;
										if (e$6 === s$1) if (e$6 = ie, t$1.charCodeAt(ie) === 39 ? (r$5 = "'", ie++) : (r$5 = s$1, de(B)), r$5 !== s$1) {
											for (n$5 = [], U.test(t$1.charAt(ie)) ? (o$4 = t$1.charAt(ie), ie++) : (o$4 = s$1, de(K)), o$4 === s$1 && (o$4 = ie, t$1.charCodeAt(ie) === 92 ? (a$4 = "\\", ie++) : (a$4 = s$1, de(R)), a$4 === s$1 ? (ie = o$4, o$4 = s$1) : (t$1.length > ie ? (i$4 = t$1.charAt(ie), ie++) : (i$4 = s$1, de(O)), i$4 === s$1 ? (ie = o$4, o$4 = s$1) : (a$4 = L(a$4, i$4), o$4 = a$4))); o$4 !== s$1;) n$5.push(o$4), U.test(t$1.charAt(ie)) ? (o$4 = t$1.charAt(ie), ie++) : (o$4 = s$1, de(K)), o$4 === s$1 && (o$4 = ie, t$1.charCodeAt(ie) === 92 ? (a$4 = "\\", ie++) : (a$4 = s$1, de(R)), a$4 === s$1 ? (ie = o$4, o$4 = s$1) : (t$1.length > ie ? (i$4 = t$1.charAt(ie), ie++) : (i$4 = s$1, de(O)), i$4 === s$1 ? (ie = o$4, o$4 = s$1) : (a$4 = L(a$4, i$4), o$4 = a$4)));
											n$5 === s$1 ? (ie = e$6, e$6 = s$1) : (t$1.charCodeAt(ie) === 39 ? (o$4 = "'", ie++) : (o$4 = s$1, de(B)), o$4 === s$1 ? (ie = e$6, e$6 = s$1) : (r$5 = M(n$5), e$6 = r$5));
										} else ie = e$6, e$6 = s$1;
										return ce[u$2] = {
											nextPos: ie,
											result: e$6
										}, e$6;
									}()) === s$1 && (o$3 = function() {
										var e$6, r$5, n$5, o$4, a$4, i$4, u$2, l$2 = 32 * ie + 18, c$2 = ce[l$2];
										if (c$2) return ie = c$2.nextPos, c$2.result;
										for (e$6 = ie, r$5 = ie, n$5 = [], N.test(t$1.charAt(ie)) ? (o$4 = t$1.charAt(ie), ie++) : (o$4 = s$1, de(W)); o$4 !== s$1;) n$5.push(o$4), N.test(t$1.charAt(ie)) ? (o$4 = t$1.charAt(ie), ie++) : (o$4 = s$1, de(W));
										if (n$5 === s$1 ? (ie = r$5, r$5 = s$1) : (t$1.charCodeAt(ie) === 46 ? (o$4 = ".", ie++) : (o$4 = s$1, de(D)), o$4 === s$1 ? (ie = r$5, r$5 = s$1) : r$5 = n$5 = [n$5, o$4]), r$5 === s$1 && (r$5 = null), r$5 !== s$1) {
											if (n$5 = [], N.test(t$1.charAt(ie)) ? (o$4 = t$1.charAt(ie), ie++) : (o$4 = s$1, de(W)), o$4 !== s$1) for (; o$4 !== s$1;) n$5.push(o$4), N.test(t$1.charAt(ie)) ? (o$4 = t$1.charAt(ie), ie++) : (o$4 = s$1, de(W));
											else n$5 = s$1;
											n$5 === s$1 ? (ie = e$6, e$6 = s$1) : (i$4 = n$5, u$2 = (a$4 = r$5) ? [].concat.apply([], a$4).join("") : "", r$5 = {
												type: "literal",
												value: parseFloat(u$2 + i$4.join(""))
											}, e$6 = r$5);
										} else ie = e$6, e$6 = s$1;
										return ce[l$2] = {
											nextPos: ie,
											result: e$6
										}, e$6;
									}()) === s$1 && (o$3 = function() {
										var e$6, t$2, r$5 = 32 * ie + 19, n$5 = ce[r$5];
										return n$5 ? (ie = n$5.nextPos, n$5.result) : ((t$2 = ve()) !== s$1 && (t$2 = {
											type: "literal",
											value: t$2
										}), e$6 = t$2, ce[r$5] = {
											nextPos: ie,
											result: e$6
										}, e$6);
									}()), o$3 === s$1 ? (ie = e$5, e$5 = s$1) : (r$4 = I(r$4, n$4, o$3), e$5 = r$4)) : (ie = e$5, e$5 = s$1), e$5 === s$1 && (e$5 = ie, (r$4 = Ce()) !== s$1 && (r$4 = {
										type: "attribute",
										name: r$4
									}), e$5 = r$4)), ce[a$3] = {
										nextPos: ie,
										result: e$5
									}, e$5);
								}()) !== s$1 && xe() !== s$1 ? (t$1.charCodeAt(ie) === 93 ? (o$2 = "]", ie++) : (o$2 = s$1, de(b)), o$2 === s$1 ? (ie = e$4, e$4 = s$1) : e$4 = r$3 = n$3) : (ie = e$4, e$4 = s$1), ce[a$2] = {
									nextPos: ie,
									result: e$4
								}, e$4);
							}()) === s$1 && (e$3 = function() {
								var e$4, r$3, n$3, o$2, a$2, i$2, u$2, l$2, c$2 = 32 * ie + 23, f$2 = ce[c$2];
								if (f$2) return ie = f$2.nextPos, f$2.result;
								if (e$4 = ie, t$1.charCodeAt(ie) === 46 ? (r$3 = ".", ie++) : (r$3 = s$1, de(D)), r$3 !== s$1) if ((n$3 = ve()) !== s$1) {
									for (o$2 = [], a$2 = ie, t$1.charCodeAt(ie) === 46 ? (i$2 = ".", ie++) : (i$2 = s$1, de(D)), i$2 !== s$1 && (u$2 = ve()) !== s$1 ? a$2 = i$2 = [i$2, u$2] : (ie = a$2, a$2 = s$1); a$2 !== s$1;) o$2.push(a$2), a$2 = ie, t$1.charCodeAt(ie) === 46 ? (i$2 = ".", ie++) : (i$2 = s$1, de(D)), i$2 !== s$1 && (u$2 = ve()) !== s$1 ? a$2 = i$2 = [i$2, u$2] : (ie = a$2, a$2 = s$1);
									o$2 === s$1 ? (ie = e$4, e$4 = s$1) : (l$2 = n$3, r$3 = {
										type: "field",
										name: o$2.reduce((function(e$5, t$2) {
											return e$5 + t$2[0] + t$2[1];
										}), l$2)
									}, e$4 = r$3);
								} else ie = e$4, e$4 = s$1;
								else ie = e$4, e$4 = s$1;
								return ce[c$2] = {
									nextPos: ie,
									result: e$4
								}, e$4;
							}()) === s$1 && (e$3 = function() {
								var e$4, r$3, n$3, o$2, a$2 = 32 * ie + 24, i$2 = ce[a$2];
								return i$2 ? (ie = i$2.nextPos, i$2.result) : (e$4 = ie, t$1.substr(ie, 5) === ":not(" ? (r$3 = ":not(", ie += 5) : (r$3 = s$1, de(X)), r$3 !== s$1 && xe() !== s$1 && (n$3 = Ae()) !== s$1 && xe() !== s$1 ? (t$1.charCodeAt(ie) === 41 ? (o$2 = ")", ie++) : (o$2 = s$1, de(z)), o$2 === s$1 ? (ie = e$4, e$4 = s$1) : e$4 = r$3 = {
									type: "not",
									selectors: n$3
								}) : (ie = e$4, e$4 = s$1), ce[a$2] = {
									nextPos: ie,
									result: e$4
								}, e$4);
							}()) === s$1 && (e$3 = function() {
								var e$4, r$3, n$3, o$2, a$2 = 32 * ie + 25, i$2 = ce[a$2];
								return i$2 ? (ie = i$2.nextPos, i$2.result) : (e$4 = ie, t$1.substr(ie, 9) === ":matches(" ? (r$3 = ":matches(", ie += 9) : (r$3 = s$1, de(Z)), r$3 !== s$1 && xe() !== s$1 && (n$3 = Ae()) !== s$1 && xe() !== s$1 ? (t$1.charCodeAt(ie) === 41 ? (o$2 = ")", ie++) : (o$2 = s$1, de(z)), o$2 === s$1 ? (ie = e$4, e$4 = s$1) : e$4 = r$3 = {
									type: "matches",
									selectors: n$3
								}) : (ie = e$4, e$4 = s$1), ce[a$2] = {
									nextPos: ie,
									result: e$4
								}, e$4);
							}()) === s$1 && (e$3 = function() {
								var e$4, r$3, n$3, o$2, a$2 = 32 * ie + 26, i$2 = ce[a$2];
								return i$2 ? (ie = i$2.nextPos, i$2.result) : (e$4 = ie, t$1.substr(ie, 5) === ":has(" ? (r$3 = ":has(", ie += 5) : (r$3 = s$1, de(ee)), r$3 !== s$1 && xe() !== s$1 && (n$3 = function() {
									var e$5, r$4, n$4, o$3, a$3, i$3, u$2, l$2, c$2 = 32 * ie + 4, f$2 = ce[c$2];
									if (f$2) return ie = f$2.nextPos, f$2.result;
									if (e$5 = ie, (r$4 = Ee()) !== s$1) {
										for (n$4 = [], o$3 = ie, (a$3 = xe()) === s$1 ? (ie = o$3, o$3 = s$1) : (t$1.charCodeAt(ie) === 44 ? (i$3 = ",", ie++) : (i$3 = s$1, de(m$1)), i$3 !== s$1 && (u$2 = xe()) !== s$1 && (l$2 = Ee()) !== s$1 ? o$3 = a$3 = [
											a$3,
											i$3,
											u$2,
											l$2
										] : (ie = o$3, o$3 = s$1)); o$3 !== s$1;) n$4.push(o$3), o$3 = ie, (a$3 = xe()) === s$1 ? (ie = o$3, o$3 = s$1) : (t$1.charCodeAt(ie) === 44 ? (i$3 = ",", ie++) : (i$3 = s$1, de(m$1)), i$3 !== s$1 && (u$2 = xe()) !== s$1 && (l$2 = Ee()) !== s$1 ? o$3 = a$3 = [
											a$3,
											i$3,
											u$2,
											l$2
										] : (ie = o$3, o$3 = s$1));
										n$4 === s$1 ? (ie = e$5, e$5 = s$1) : e$5 = r$4 = x$1(r$4, n$4);
									} else ie = e$5, e$5 = s$1;
									return ce[c$2] = {
										nextPos: ie,
										result: e$5
									}, e$5;
								}()) !== s$1 && xe() !== s$1 ? (t$1.charCodeAt(ie) === 41 ? (o$2 = ")", ie++) : (o$2 = s$1, de(z)), o$2 === s$1 ? (ie = e$4, e$4 = s$1) : e$4 = r$3 = {
									type: "has",
									selectors: n$3
								}) : (ie = e$4, e$4 = s$1), ce[a$2] = {
									nextPos: ie,
									result: e$4
								}, e$4);
							}()) === s$1 && (e$3 = function() {
								var e$4, r$3, n$3 = 32 * ie + 27, o$2 = ce[n$3];
								return o$2 ? (ie = o$2.nextPos, o$2.result) : (t$1.substr(ie, 12) === ":first-child" ? (r$3 = ":first-child", ie += 12) : (r$3 = s$1, de(te)), r$3 !== s$1 && (r$3 = we(1)), e$4 = r$3, ce[n$3] = {
									nextPos: ie,
									result: e$4
								}, e$4);
							}()) === s$1 && (e$3 = function() {
								var e$4, r$3, n$3 = 32 * ie + 28, o$2 = ce[n$3];
								return o$2 ? (ie = o$2.nextPos, o$2.result) : (t$1.substr(ie, 11) === ":last-child" ? (r$3 = ":last-child", ie += 11) : (r$3 = s$1, de(re)), r$3 !== s$1 && (r$3 = Pe(1)), e$4 = r$3, ce[n$3] = {
									nextPos: ie,
									result: e$4
								}, e$4);
							}()) === s$1 && (e$3 = function() {
								var e$4, r$3, n$3, o$2, a$2, i$2 = 32 * ie + 29, u$2 = ce[i$2];
								if (u$2) return ie = u$2.nextPos, u$2.result;
								if (e$4 = ie, t$1.substr(ie, 11) === ":nth-child(" ? (r$3 = ":nth-child(", ie += 11) : (r$3 = s$1, de(ne)), r$3 !== s$1) if (xe() !== s$1) {
									if (n$3 = [], N.test(t$1.charAt(ie)) ? (o$2 = t$1.charAt(ie), ie++) : (o$2 = s$1, de(W)), o$2 !== s$1) for (; o$2 !== s$1;) n$3.push(o$2), N.test(t$1.charAt(ie)) ? (o$2 = t$1.charAt(ie), ie++) : (o$2 = s$1, de(W));
									else n$3 = s$1;
									n$3 !== s$1 && (o$2 = xe()) !== s$1 ? (t$1.charCodeAt(ie) === 41 ? (a$2 = ")", ie++) : (a$2 = s$1, de(z)), a$2 === s$1 ? (ie = e$4, e$4 = s$1) : (r$3 = we(parseInt(n$3.join(""), 10)), e$4 = r$3)) : (ie = e$4, e$4 = s$1);
								} else ie = e$4, e$4 = s$1;
								else ie = e$4, e$4 = s$1;
								return ce[i$2] = {
									nextPos: ie,
									result: e$4
								}, e$4;
							}()) === s$1 && (e$3 = function() {
								var e$4, r$3, n$3, o$2, a$2, i$2 = 32 * ie + 30, u$2 = ce[i$2];
								if (u$2) return ie = u$2.nextPos, u$2.result;
								if (e$4 = ie, t$1.substr(ie, 16) === ":nth-last-child(" ? (r$3 = ":nth-last-child(", ie += 16) : (r$3 = s$1, de(oe)), r$3 !== s$1) if (xe() !== s$1) {
									if (n$3 = [], N.test(t$1.charAt(ie)) ? (o$2 = t$1.charAt(ie), ie++) : (o$2 = s$1, de(W)), o$2 !== s$1) for (; o$2 !== s$1;) n$3.push(o$2), N.test(t$1.charAt(ie)) ? (o$2 = t$1.charAt(ie), ie++) : (o$2 = s$1, de(W));
									else n$3 = s$1;
									n$3 !== s$1 && (o$2 = xe()) !== s$1 ? (t$1.charCodeAt(ie) === 41 ? (a$2 = ")", ie++) : (a$2 = s$1, de(z)), a$2 === s$1 ? (ie = e$4, e$4 = s$1) : (r$3 = Pe(parseInt(n$3.join(""), 10)), e$4 = r$3)) : (ie = e$4, e$4 = s$1);
								} else ie = e$4, e$4 = s$1;
								else ie = e$4, e$4 = s$1;
								return ce[i$2] = {
									nextPos: ie,
									result: e$4
								}, e$4;
							}()) === s$1 && (e$3 = function() {
								var e$4, r$3, n$3, o$2 = 32 * ie + 31, a$2 = ce[o$2];
								return a$2 ? (ie = a$2.nextPos, a$2.result) : (e$4 = ie, t$1.charCodeAt(ie) === 58 ? (r$3 = ":", ie++) : (r$3 = s$1, de(ae)), r$3 !== s$1 && (n$3 = ve()) !== s$1 ? e$4 = r$3 = {
									type: "class",
									name: n$3
								} : (ie = e$4, e$4 = s$1), ce[o$2] = {
									nextPos: ie,
									result: e$4
								}, e$4);
							}()), ce[r$2] = {
								nextPos: ie,
								result: e$3
							}, e$3);
						}
						function Ce() {
							var e$3, r$2, n$2, o$2, a$2, i$2, u$2, l$2, c$2 = 32 * ie + 15, f$2 = ce[c$2];
							if (f$2) return ie = f$2.nextPos, f$2.result;
							if (e$3 = ie, (r$2 = ve()) !== s$1) {
								for (n$2 = [], o$2 = ie, t$1.charCodeAt(ie) === 46 ? (a$2 = ".", ie++) : (a$2 = s$1, de(D)), a$2 !== s$1 && (i$2 = ve()) !== s$1 ? o$2 = a$2 = [a$2, i$2] : (ie = o$2, o$2 = s$1); o$2 !== s$1;) n$2.push(o$2), o$2 = ie, t$1.charCodeAt(ie) === 46 ? (a$2 = ".", ie++) : (a$2 = s$1, de(D)), a$2 !== s$1 && (i$2 = ve()) !== s$1 ? o$2 = a$2 = [a$2, i$2] : (ie = o$2, o$2 = s$1);
								n$2 === s$1 ? (ie = e$3, e$3 = s$1) : (u$2 = r$2, l$2 = n$2, e$3 = r$2 = [].concat.apply([u$2], l$2).join(""));
							} else ie = e$3, e$3 = s$1;
							return ce[c$2] = {
								nextPos: ie,
								result: e$3
							}, e$3;
						}
						function we(e$3) {
							return {
								type: "nth-child",
								index: {
									type: "literal",
									value: e$3
								}
							};
						}
						function Pe(e$3) {
							return {
								type: "nth-last-child",
								index: {
									type: "literal",
									value: e$3
								}
							};
						}
						if ((n$1 = l$1()) !== s$1 && ie === t$1.length) return n$1;
						throw n$1 !== s$1 && ie < t$1.length && de({ type: "end" }), o$1 = le, a$1 = ue < t$1.length ? t$1.charAt(ue) : null, i$1 = ue < t$1.length ? ye(ue, ue + 1) : ye(ue, ue), new e$2(e$2.buildMessage(o$1, a$1), o$1, a$1, i$1);
					}
				};
			}();
		}));
		function u(e$1, t$1) {
			for (var r$1 = 0; r$1 < t$1.length; ++r$1) {
				if (e$1 == null) return e$1;
				e$1 = e$1[t$1[r$1]];
			}
			return e$1;
		}
		var l = typeof WeakMap == "function" ? /* @__PURE__ */ new WeakMap() : null;
		function c(e$1) {
			if (e$1 == null) return function() {
				return !0;
			};
			if (l != null) {
				var t$1 = l.get(e$1);
				return t$1 ?? (t$1 = f(e$1), l.set(e$1, t$1)), t$1;
			}
			return f(e$1);
		}
		function f(t$1) {
			switch (t$1.type) {
				case "wildcard": return function() {
					return !0;
				};
				case "identifier":
					var r$1 = t$1.value.toLowerCase();
					return function(e$1, t$2, n$2) {
						return r$1 === e$1[n$2 && n$2.nodeTypeKey || "type"].toLowerCase();
					};
				case "exactNode": return function(e$1, t$2) {
					return t$2.length === 0;
				};
				case "field":
					var n$1 = t$1.name.split(".");
					return function(e$1, t$2) {
						return function e$2(t$3, r$2, n$2, o$2) {
							for (var a$2 = r$2, i$1 = o$2; i$1 < n$2.length; ++i$1) {
								if (a$2 == null) return !1;
								var s$2 = a$2[n$2[i$1]];
								if (Array.isArray(s$2)) {
									for (var u$1 = 0; u$1 < s$2.length; ++u$1) if (e$2(t$3, s$2[u$1], n$2, i$1 + 1)) return !0;
									return !1;
								}
								a$2 = s$2;
							}
							return t$3 === a$2;
						}(e$1, t$2[n$1.length - 1], n$1, 0);
					};
				case "matches":
					var o$1 = t$1.selectors.map(c);
					return function(e$1, t$2, r$2) {
						for (var n$2 = 0; n$2 < o$1.length; ++n$2) if (o$1[n$2](e$1, t$2, r$2)) return !0;
						return !1;
					};
				case "compound":
					var a$1 = t$1.selectors.map(c);
					return function(e$1, t$2, r$2) {
						for (var n$2 = 0; n$2 < a$1.length; ++n$2) if (!a$1[n$2](e$1, t$2, r$2)) return !1;
						return !0;
					};
				case "not":
					var s$1 = t$1.selectors.map(c);
					return function(e$1, t$2, r$2) {
						for (var n$2 = 0; n$2 < s$1.length; ++n$2) if (s$1[n$2](e$1, t$2, r$2)) return !1;
						return !0;
					};
				case "has":
					var l$1 = t$1.selectors.map(c);
					return function(e$1, t$2, r$2) {
						var n$2 = !1, o$2 = [];
						return i.traverse(e$1, {
							enter: function(e$2, t$3) {
								t$3 != null && o$2.unshift(t$3);
								for (var a$2 = 0; a$2 < l$1.length; ++a$2) if (l$1[a$2](e$2, o$2, r$2)) return n$2 = !0, void this.break();
							},
							leave: function() {
								o$2.shift();
							},
							keys: r$2 && r$2.visitorKeys,
							fallback: r$2 && r$2.fallback || "iteration"
						}), n$2;
					};
				case "child":
					var f$1 = c(t$1.left), p$1 = c(t$1.right);
					return function(e$1, t$2, r$2) {
						return !!(t$2.length > 0 && p$1(e$1, t$2, r$2)) && f$1(t$2[0], t$2.slice(1), r$2);
					};
				case "descendant":
					var h$1 = c(t$1.left), x$1 = c(t$1.right);
					return function(e$1, t$2, r$2) {
						if (x$1(e$1, t$2, r$2)) {
							for (var n$2 = 0, o$2 = t$2.length; n$2 < o$2; ++n$2) if (h$1(t$2[n$2], t$2.slice(n$2 + 1), r$2)) return !0;
						}
						return !1;
					};
				case "attribute":
					var v$1 = t$1.name.split(".");
					switch (t$1.operator) {
						case void 0: return function(e$1) {
							return u(e$1, v$1) != null;
						};
						case "=":
							switch (t$1.value.type) {
								case "regexp": return function(e$1) {
									var r$2 = u(e$1, v$1);
									return typeof r$2 == "string" && t$1.value.value.test(r$2);
								};
								case "literal":
									var g$1 = `${t$1.value.value}`;
									return function(e$1) {
										return g$1 === `${u(e$1, v$1)}`;
									};
								case "type": return function(r$2) {
									return t$1.value.value === e(u(r$2, v$1));
								};
							}
							throw Error(`Unknown selector value type: ${t$1.value.type}`);
						case "!=":
							switch (t$1.value.type) {
								case "regexp": return function(e$1) {
									return !t$1.value.value.test(u(e$1, v$1));
								};
								case "literal":
									var A$1 = `${t$1.value.value}`;
									return function(e$1) {
										return A$1 !== `${u(e$1, v$1)}`;
									};
								case "type": return function(r$2) {
									return t$1.value.value !== e(u(r$2, v$1));
								};
							}
							throw Error(`Unknown selector value type: ${t$1.value.type}`);
						case "<=": return function(e$1) {
							return u(e$1, v$1) <= t$1.value.value;
						};
						case "<": return function(e$1) {
							return u(e$1, v$1) < t$1.value.value;
						};
						case ">": return function(e$1) {
							return u(e$1, v$1) > t$1.value.value;
						};
						case ">=": return function(e$1) {
							return u(e$1, v$1) >= t$1.value.value;
						};
					}
					throw Error(`Unknown operator: ${t$1.operator}`);
				case "sibling":
					var E = c(t$1.left), b = c(t$1.right);
					return function(e$1, r$2, n$2) {
						return b(e$1, r$2, n$2) && y(e$1, E, r$2, "LEFT_SIDE", n$2) || t$1.left.subject && E(e$1, r$2, n$2) && y(e$1, b, r$2, "RIGHT_SIDE", n$2);
					};
				case "adjacent":
					var S = c(t$1.left), _ = c(t$1.right);
					return function(e$1, r$2, n$2) {
						return _(e$1, r$2, n$2) && d(e$1, S, r$2, "LEFT_SIDE", n$2) || t$1.right.subject && S(e$1, r$2, n$2) && d(e$1, _, r$2, "RIGHT_SIDE", n$2);
					};
				case "nth-child":
					var C = t$1.index.value, w = c(t$1.right);
					return function(e$1, t$2, r$2) {
						return w(e$1, t$2, r$2) && m(e$1, t$2, C, r$2);
					};
				case "nth-last-child":
					var P = -t$1.index.value, k = c(t$1.right);
					return function(e$1, t$2, r$2) {
						return k(e$1, t$2, r$2) && m(e$1, t$2, P, r$2);
					};
				case "class":
					var D = t$1.name.toLowerCase();
					return function(e$1, r$2, n$2) {
						if (n$2 && n$2.matchClass) return n$2.matchClass(t$1.name, e$1, r$2);
						if (n$2 && n$2.nodeTypeKey) return !1;
						switch (D) {
							case "statement": if (e$1.type.slice(-9) === "Statement") return !0;
							case "declaration": return e$1.type.slice(-11) === "Declaration";
							case "pattern": if (e$1.type.slice(-7) === "Pattern") return !0;
							case "expression": return e$1.type.slice(-10) === "Expression" || e$1.type.slice(-7) === "Literal" || e$1.type === "Identifier" && (r$2.length === 0 || r$2[0].type !== "MetaProperty") || e$1.type === "MetaProperty";
							case "function": return e$1.type === "FunctionDeclaration" || e$1.type === "FunctionExpression" || e$1.type === "ArrowFunctionExpression";
						}
						throw Error(`Unknown class name: ${t$1.name}`);
					};
			}
			throw Error(`Unknown selector type: ${t$1.type}`);
		}
		function p(e$1, t$1) {
			var r$1 = t$1 && t$1.nodeTypeKey || "type", n$1 = e$1[r$1];
			return t$1 && t$1.visitorKeys && t$1.visitorKeys[n$1] ? t$1.visitorKeys[n$1] : i.VisitorKeys[n$1] ? i.VisitorKeys[n$1] : t$1 && typeof t$1.fallback == "function" ? t$1.fallback(e$1) : Object.keys(e$1).filter((function(e$2) {
				return e$2 !== r$1;
			}));
		}
		function h(t$1, r$1) {
			var n$1 = r$1 && r$1.nodeTypeKey || "type";
			return t$1 !== null && e(t$1) === "object" && typeof t$1[n$1] == "string";
		}
		function y(e$1, r$1, n$1, o$1, a$1) {
			var i$1 = t(n$1, 1)[0];
			if (!i$1) return !1;
			for (var s$1 = p(i$1, a$1), u$1 = 0; u$1 < s$1.length; ++u$1) {
				var l$1 = i$1[s$1[u$1]];
				if (Array.isArray(l$1)) {
					var c$1 = l$1.indexOf(e$1);
					if (c$1 < 0) continue;
					var f$1 = void 0, y$1 = void 0;
					o$1 === "LEFT_SIDE" ? (f$1 = 0, y$1 = c$1) : (f$1 = c$1 + 1, y$1 = l$1.length);
					for (var d$1 = f$1; d$1 < y$1; ++d$1) if (h(l$1[d$1], a$1) && r$1(l$1[d$1], n$1, a$1)) return !0;
				}
			}
			return !1;
		}
		function d(e$1, r$1, n$1, o$1, a$1) {
			var i$1 = t(n$1, 1)[0];
			if (!i$1) return !1;
			for (var s$1 = p(i$1, a$1), u$1 = 0; u$1 < s$1.length; ++u$1) {
				var l$1 = i$1[s$1[u$1]];
				if (Array.isArray(l$1)) {
					var c$1 = l$1.indexOf(e$1);
					if (c$1 < 0) continue;
					if (o$1 === "LEFT_SIDE" && c$1 > 0 && h(l$1[c$1 - 1], a$1) && r$1(l$1[c$1 - 1], n$1, a$1) || o$1 === "RIGHT_SIDE" && c$1 < l$1.length - 1 && h(l$1[c$1 + 1], a$1) && r$1(l$1[c$1 + 1], n$1, a$1)) return !0;
				}
			}
			return !1;
		}
		function m(e$1, r$1, n$1, o$1) {
			if (n$1 === 0) return !1;
			var a$1 = t(r$1, 1)[0];
			if (!a$1) return !1;
			for (var i$1 = p(a$1, o$1), s$1 = 0; s$1 < i$1.length; ++s$1) {
				var u$1 = a$1[i$1[s$1]];
				if (Array.isArray(u$1)) {
					var l$1 = n$1 < 0 ? u$1.length + n$1 : n$1 - 1;
					if (l$1 >= 0 && l$1 < u$1.length && u$1[l$1] === e$1) return !0;
				}
			}
			return !1;
		}
		function x(t$1, n$1, o$1, a$1) {
			if (n$1) {
				var s$1 = [], u$1 = c(n$1), l$1 = function t$2(n$2, o$2) {
					if (n$2 == null || e(n$2) != "object") return [];
					o$2 ??= n$2;
					for (var a$2 = n$2.subject ? [o$2] : [], i$1 = Object.keys(n$2), s$2 = 0; s$2 < i$1.length; ++s$2) {
						var u$2 = i$1[s$2], l$2 = n$2[u$2];
						a$2.push.apply(a$2, r(t$2(l$2, u$2 === "left" ? l$2 : o$2)));
					}
					return a$2;
				}(n$1).map(c);
				i.traverse(t$1, {
					enter: function(e$1, t$2) {
						if (t$2 != null && s$1.unshift(t$2), u$1(e$1, s$1, a$1)) if (l$1.length) for (var r$1 = 0, n$2 = l$1.length; r$1 < n$2; ++r$1) {
							l$1[r$1](e$1, s$1, a$1) && o$1(e$1, t$2, s$1);
							for (var i$1 = 0, c$1 = s$1.length; i$1 < c$1; ++i$1) {
								var f$1 = s$1.slice(i$1 + 1);
								l$1[r$1](s$1[i$1], f$1, a$1) && o$1(s$1[i$1], t$2, f$1);
							}
						}
						else o$1(e$1, t$2, s$1);
					},
					leave: function() {
						s$1.shift();
					},
					keys: a$1 && a$1.visitorKeys,
					fallback: a$1 && a$1.fallback || "iteration"
				});
			}
		}
		function v(e$1, t$1, r$1) {
			var n$1 = [];
			return x(e$1, t$1, (function(e$2) {
				n$1.push(e$2);
			}), r$1), n$1;
		}
		function g(e$1) {
			return s.parse(e$1);
		}
		function A(e$1, t$1, r$1) {
			return v(e$1, g(t$1), r$1);
		}
		return A.parse = g, A.match = v, A.traverse = x, A.matches = function(e$1, t$1, r$1, n$1) {
			return !t$1 || !!e$1 && (r$1 ||= [], c(t$1)(e$1, r$1, n$1));
		}, A.query = A, A;
	}));
}));
const ancestors = [], { isArray: isArray$1 } = Array;
function walkNode(node, visitors) {
	if (node != null) if (isArray$1(node)) {
		let len = node.length;
		for (let i = 0; i < len; i++) walkNode(node[i], visitors);
	} else switch (node.type) {
		case "DebuggerStatement":
			walkDebuggerStatement(node, visitors);
			break;
		case "EmptyStatement":
			walkEmptyStatement(node, visitors);
			break;
		case "Literal":
			walkLiteral(node, visitors);
			break;
		case "PrivateIdentifier":
			walkPrivateIdentifier(node, visitors);
			break;
		case "Super":
			walkSuper(node, visitors);
			break;
		case "TemplateElement":
			walkTemplateElement(node, visitors);
			break;
		case "ThisExpression":
			walkThisExpression(node, visitors);
			break;
		case "JSXClosingFragment":
			walkJSXClosingFragment(node, visitors);
			break;
		case "JSXEmptyExpression":
			walkJSXEmptyExpression(node, visitors);
			break;
		case "JSXIdentifier":
			walkJSXIdentifier(node, visitors);
			break;
		case "JSXOpeningFragment":
			walkJSXOpeningFragment(node, visitors);
			break;
		case "JSXText":
			walkJSXText(node, visitors);
			break;
		case "TSAnyKeyword":
			walkTSAnyKeyword(node, visitors);
			break;
		case "TSBigIntKeyword":
			walkTSBigIntKeyword(node, visitors);
			break;
		case "TSBooleanKeyword":
			walkTSBooleanKeyword(node, visitors);
			break;
		case "TSIntrinsicKeyword":
			walkTSIntrinsicKeyword(node, visitors);
			break;
		case "TSJSDocUnknownType":
			walkTSJSDocUnknownType(node, visitors);
			break;
		case "TSNeverKeyword":
			walkTSNeverKeyword(node, visitors);
			break;
		case "TSNullKeyword":
			walkTSNullKeyword(node, visitors);
			break;
		case "TSNumberKeyword":
			walkTSNumberKeyword(node, visitors);
			break;
		case "TSObjectKeyword":
			walkTSObjectKeyword(node, visitors);
			break;
		case "TSStringKeyword":
			walkTSStringKeyword(node, visitors);
			break;
		case "TSSymbolKeyword":
			walkTSSymbolKeyword(node, visitors);
			break;
		case "TSThisType":
			walkTSThisType(node, visitors);
			break;
		case "TSUndefinedKeyword":
			walkTSUndefinedKeyword(node, visitors);
			break;
		case "TSUnknownKeyword":
			walkTSUnknownKeyword(node, visitors);
			break;
		case "TSVoidKeyword":
			walkTSVoidKeyword(node, visitors);
			break;
		case "AccessorProperty":
			walkAccessorProperty(node, visitors);
			break;
		case "ArrayExpression":
			walkArrayExpression(node, visitors);
			break;
		case "ArrayPattern":
			walkArrayPattern(node, visitors);
			break;
		case "ArrowFunctionExpression":
			walkArrowFunctionExpression(node, visitors);
			break;
		case "AssignmentExpression":
			walkAssignmentExpression(node, visitors);
			break;
		case "AssignmentPattern":
			walkAssignmentPattern(node, visitors);
			break;
		case "AwaitExpression":
			walkAwaitExpression(node, visitors);
			break;
		case "BinaryExpression":
			walkBinaryExpression(node, visitors);
			break;
		case "BlockStatement":
			walkBlockStatement(node, visitors);
			break;
		case "BreakStatement":
			walkBreakStatement(node, visitors);
			break;
		case "CallExpression":
			walkCallExpression(node, visitors);
			break;
		case "CatchClause":
			walkCatchClause(node, visitors);
			break;
		case "ChainExpression":
			walkChainExpression(node, visitors);
			break;
		case "ClassBody":
			walkClassBody(node, visitors);
			break;
		case "ClassDeclaration":
			walkClassDeclaration(node, visitors);
			break;
		case "ClassExpression":
			walkClassExpression(node, visitors);
			break;
		case "ConditionalExpression":
			walkConditionalExpression(node, visitors);
			break;
		case "ContinueStatement":
			walkContinueStatement(node, visitors);
			break;
		case "Decorator":
			walkDecorator(node, visitors);
			break;
		case "DoWhileStatement":
			walkDoWhileStatement(node, visitors);
			break;
		case "ExportAllDeclaration":
			walkExportAllDeclaration(node, visitors);
			break;
		case "ExportDefaultDeclaration":
			walkExportDefaultDeclaration(node, visitors);
			break;
		case "ExportNamedDeclaration":
			walkExportNamedDeclaration(node, visitors);
			break;
		case "ExportSpecifier":
			walkExportSpecifier(node, visitors);
			break;
		case "ExpressionStatement":
			walkExpressionStatement(node, visitors);
			break;
		case "ForInStatement":
			walkForInStatement(node, visitors);
			break;
		case "ForOfStatement":
			walkForOfStatement(node, visitors);
			break;
		case "ForStatement":
			walkForStatement(node, visitors);
			break;
		case "FunctionDeclaration":
			walkFunctionDeclaration(node, visitors);
			break;
		case "FunctionExpression":
			walkFunctionExpression(node, visitors);
			break;
		case "Identifier":
			walkIdentifier(node, visitors);
			break;
		case "IfStatement":
			walkIfStatement(node, visitors);
			break;
		case "ImportAttribute":
			walkImportAttribute(node, visitors);
			break;
		case "ImportDeclaration":
			walkImportDeclaration(node, visitors);
			break;
		case "ImportDefaultSpecifier":
			walkImportDefaultSpecifier(node, visitors);
			break;
		case "ImportExpression":
			walkImportExpression(node, visitors);
			break;
		case "ImportNamespaceSpecifier":
			walkImportNamespaceSpecifier(node, visitors);
			break;
		case "ImportSpecifier":
			walkImportSpecifier(node, visitors);
			break;
		case "LabeledStatement":
			walkLabeledStatement(node, visitors);
			break;
		case "LogicalExpression":
			walkLogicalExpression(node, visitors);
			break;
		case "MemberExpression":
			walkMemberExpression(node, visitors);
			break;
		case "MetaProperty":
			walkMetaProperty(node, visitors);
			break;
		case "MethodDefinition":
			walkMethodDefinition(node, visitors);
			break;
		case "NewExpression":
			walkNewExpression(node, visitors);
			break;
		case "ObjectExpression":
			walkObjectExpression(node, visitors);
			break;
		case "ObjectPattern":
			walkObjectPattern(node, visitors);
			break;
		case "ParenthesizedExpression":
			walkParenthesizedExpression(node, visitors);
			break;
		case "Program":
			walkProgram(node, visitors);
			break;
		case "Property":
			walkProperty(node, visitors);
			break;
		case "PropertyDefinition":
			walkPropertyDefinition(node, visitors);
			break;
		case "RestElement":
			walkRestElement(node, visitors);
			break;
		case "ReturnStatement":
			walkReturnStatement(node, visitors);
			break;
		case "SequenceExpression":
			walkSequenceExpression(node, visitors);
			break;
		case "SpreadElement":
			walkSpreadElement(node, visitors);
			break;
		case "StaticBlock":
			walkStaticBlock(node, visitors);
			break;
		case "SwitchCase":
			walkSwitchCase(node, visitors);
			break;
		case "SwitchStatement":
			walkSwitchStatement(node, visitors);
			break;
		case "TaggedTemplateExpression":
			walkTaggedTemplateExpression(node, visitors);
			break;
		case "TemplateLiteral":
			walkTemplateLiteral(node, visitors);
			break;
		case "ThrowStatement":
			walkThrowStatement(node, visitors);
			break;
		case "TryStatement":
			walkTryStatement(node, visitors);
			break;
		case "UnaryExpression":
			walkUnaryExpression(node, visitors);
			break;
		case "UpdateExpression":
			walkUpdateExpression(node, visitors);
			break;
		case "V8IntrinsicExpression":
			walkV8IntrinsicExpression(node, visitors);
			break;
		case "VariableDeclaration":
			walkVariableDeclaration(node, visitors);
			break;
		case "VariableDeclarator":
			walkVariableDeclarator(node, visitors);
			break;
		case "WhileStatement":
			walkWhileStatement(node, visitors);
			break;
		case "WithStatement":
			walkWithStatement(node, visitors);
			break;
		case "YieldExpression":
			walkYieldExpression(node, visitors);
			break;
		case "JSXAttribute":
			walkJSXAttribute(node, visitors);
			break;
		case "JSXClosingElement":
			walkJSXClosingElement(node, visitors);
			break;
		case "JSXElement":
			walkJSXElement(node, visitors);
			break;
		case "JSXExpressionContainer":
			walkJSXExpressionContainer(node, visitors);
			break;
		case "JSXFragment":
			walkJSXFragment(node, visitors);
			break;
		case "JSXMemberExpression":
			walkJSXMemberExpression(node, visitors);
			break;
		case "JSXNamespacedName":
			walkJSXNamespacedName(node, visitors);
			break;
		case "JSXOpeningElement":
			walkJSXOpeningElement(node, visitors);
			break;
		case "JSXSpreadAttribute":
			walkJSXSpreadAttribute(node, visitors);
			break;
		case "JSXSpreadChild":
			walkJSXSpreadChild(node, visitors);
			break;
		case "TSAbstractAccessorProperty":
			walkTSAbstractAccessorProperty(node, visitors);
			break;
		case "TSAbstractMethodDefinition":
			walkTSAbstractMethodDefinition(node, visitors);
			break;
		case "TSAbstractPropertyDefinition":
			walkTSAbstractPropertyDefinition(node, visitors);
			break;
		case "TSArrayType":
			walkTSArrayType(node, visitors);
			break;
		case "TSAsExpression":
			walkTSAsExpression(node, visitors);
			break;
		case "TSCallSignatureDeclaration":
			walkTSCallSignatureDeclaration(node, visitors);
			break;
		case "TSClassImplements":
			walkTSClassImplements(node, visitors);
			break;
		case "TSConditionalType":
			walkTSConditionalType(node, visitors);
			break;
		case "TSConstructSignatureDeclaration":
			walkTSConstructSignatureDeclaration(node, visitors);
			break;
		case "TSConstructorType":
			walkTSConstructorType(node, visitors);
			break;
		case "TSDeclareFunction":
			walkTSDeclareFunction(node, visitors);
			break;
		case "TSEmptyBodyFunctionExpression":
			walkTSEmptyBodyFunctionExpression(node, visitors);
			break;
		case "TSEnumBody":
			walkTSEnumBody(node, visitors);
			break;
		case "TSEnumDeclaration":
			walkTSEnumDeclaration(node, visitors);
			break;
		case "TSEnumMember":
			walkTSEnumMember(node, visitors);
			break;
		case "TSExportAssignment":
			walkTSExportAssignment(node, visitors);
			break;
		case "TSExternalModuleReference":
			walkTSExternalModuleReference(node, visitors);
			break;
		case "TSFunctionType":
			walkTSFunctionType(node, visitors);
			break;
		case "TSImportEqualsDeclaration":
			walkTSImportEqualsDeclaration(node, visitors);
			break;
		case "TSImportType":
			walkTSImportType(node, visitors);
			break;
		case "TSIndexSignature":
			walkTSIndexSignature(node, visitors);
			break;
		case "TSIndexedAccessType":
			walkTSIndexedAccessType(node, visitors);
			break;
		case "TSInferType":
			walkTSInferType(node, visitors);
			break;
		case "TSInstantiationExpression":
			walkTSInstantiationExpression(node, visitors);
			break;
		case "TSInterfaceBody":
			walkTSInterfaceBody(node, visitors);
			break;
		case "TSInterfaceDeclaration":
			walkTSInterfaceDeclaration(node, visitors);
			break;
		case "TSInterfaceHeritage":
			walkTSInterfaceHeritage(node, visitors);
			break;
		case "TSIntersectionType":
			walkTSIntersectionType(node, visitors);
			break;
		case "TSJSDocNonNullableType":
			walkTSJSDocNonNullableType(node, visitors);
			break;
		case "TSJSDocNullableType":
			walkTSJSDocNullableType(node, visitors);
			break;
		case "TSLiteralType":
			walkTSLiteralType(node, visitors);
			break;
		case "TSMappedType":
			walkTSMappedType(node, visitors);
			break;
		case "TSMethodSignature":
			walkTSMethodSignature(node, visitors);
			break;
		case "TSModuleBlock":
			walkTSModuleBlock(node, visitors);
			break;
		case "TSModuleDeclaration":
			walkTSModuleDeclaration(node, visitors);
			break;
		case "TSNamedTupleMember":
			walkTSNamedTupleMember(node, visitors);
			break;
		case "TSNamespaceExportDeclaration":
			walkTSNamespaceExportDeclaration(node, visitors);
			break;
		case "TSNonNullExpression":
			walkTSNonNullExpression(node, visitors);
			break;
		case "TSOptionalType":
			walkTSOptionalType(node, visitors);
			break;
		case "TSParameterProperty":
			walkTSParameterProperty(node, visitors);
			break;
		case "TSParenthesizedType":
			walkTSParenthesizedType(node, visitors);
			break;
		case "TSPropertySignature":
			walkTSPropertySignature(node, visitors);
			break;
		case "TSQualifiedName":
			walkTSQualifiedName(node, visitors);
			break;
		case "TSRestType":
			walkTSRestType(node, visitors);
			break;
		case "TSSatisfiesExpression":
			walkTSSatisfiesExpression(node, visitors);
			break;
		case "TSTemplateLiteralType":
			walkTSTemplateLiteralType(node, visitors);
			break;
		case "TSTupleType":
			walkTSTupleType(node, visitors);
			break;
		case "TSTypeAliasDeclaration":
			walkTSTypeAliasDeclaration(node, visitors);
			break;
		case "TSTypeAnnotation":
			walkTSTypeAnnotation(node, visitors);
			break;
		case "TSTypeAssertion":
			walkTSTypeAssertion(node, visitors);
			break;
		case "TSTypeLiteral":
			walkTSTypeLiteral(node, visitors);
			break;
		case "TSTypeOperator":
			walkTSTypeOperator(node, visitors);
			break;
		case "TSTypeParameter":
			walkTSTypeParameter(node, visitors);
			break;
		case "TSTypeParameterDeclaration":
			walkTSTypeParameterDeclaration(node, visitors);
			break;
		case "TSTypeParameterInstantiation":
			walkTSTypeParameterInstantiation(node, visitors);
			break;
		case "TSTypePredicate":
			walkTSTypePredicate(node, visitors);
			break;
		case "TSTypeQuery":
			walkTSTypeQuery(node, visitors);
			break;
		case "TSTypeReference":
			walkTSTypeReference(node, visitors);
			break;
		case "TSUnionType":
			walkTSUnionType(node, visitors);
			break;
	}
}
function walkDebuggerStatement(node, visitors) {
	let visit = visitors[0];
	visit !== null && visit(node);
}
function walkEmptyStatement(node, visitors) {
	let visit = visitors[1];
	visit !== null && visit(node);
}
function walkLiteral(node, visitors) {
	let visit = visitors[2];
	visit !== null && visit(node);
}
function walkPrivateIdentifier(node, visitors) {
	let visit = visitors[3];
	visit !== null && visit(node);
}
function walkSuper(node, visitors) {
	let visit = visitors[4];
	visit !== null && visit(node);
}
function walkTemplateElement(node, visitors) {
	let visit = visitors[5];
	visit !== null && visit(node);
}
function walkThisExpression(node, visitors) {
	let visit = visitors[6];
	visit !== null && visit(node);
}
function walkJSXClosingFragment(node, visitors) {
	let visit = visitors[7];
	visit !== null && visit(node);
}
function walkJSXEmptyExpression(node, visitors) {
	let visit = visitors[8];
	visit !== null && visit(node);
}
function walkJSXIdentifier(node, visitors) {
	let visit = visitors[9];
	visit !== null && visit(node);
}
function walkJSXOpeningFragment(node, visitors) {
	let visit = visitors[10];
	visit !== null && visit(node);
}
function walkJSXText(node, visitors) {
	let visit = visitors[11];
	visit !== null && visit(node);
}
function walkTSAnyKeyword(node, visitors) {
	let visit = visitors[12];
	visit !== null && visit(node);
}
function walkTSBigIntKeyword(node, visitors) {
	let visit = visitors[13];
	visit !== null && visit(node);
}
function walkTSBooleanKeyword(node, visitors) {
	let visit = visitors[14];
	visit !== null && visit(node);
}
function walkTSIntrinsicKeyword(node, visitors) {
	let visit = visitors[15];
	visit !== null && visit(node);
}
function walkTSJSDocUnknownType(node, visitors) {
	let visit = visitors[16];
	visit !== null && visit(node);
}
function walkTSNeverKeyword(node, visitors) {
	let visit = visitors[17];
	visit !== null && visit(node);
}
function walkTSNullKeyword(node, visitors) {
	let visit = visitors[18];
	visit !== null && visit(node);
}
function walkTSNumberKeyword(node, visitors) {
	let visit = visitors[19];
	visit !== null && visit(node);
}
function walkTSObjectKeyword(node, visitors) {
	let visit = visitors[20];
	visit !== null && visit(node);
}
function walkTSStringKeyword(node, visitors) {
	let visit = visitors[21];
	visit !== null && visit(node);
}
function walkTSSymbolKeyword(node, visitors) {
	let visit = visitors[22];
	visit !== null && visit(node);
}
function walkTSThisType(node, visitors) {
	let visit = visitors[23];
	visit !== null && visit(node);
}
function walkTSUndefinedKeyword(node, visitors) {
	let visit = visitors[24];
	visit !== null && visit(node);
}
function walkTSUnknownKeyword(node, visitors) {
	let visit = visitors[25];
	visit !== null && visit(node);
}
function walkTSVoidKeyword(node, visitors) {
	let visit = visitors[26];
	visit !== null && visit(node);
}
function walkAccessorProperty(node, visitors) {
	let enterExit = visitors[27], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.decorators, visitors), walkNode(node.key, visitors), walkNode(node.typeAnnotation, visitors), walkNode(node.value, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkArrayExpression(node, visitors) {
	let enterExit = visitors[28], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.elements, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkArrayPattern(node, visitors) {
	let enterExit = visitors[29], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.decorators, visitors), walkNode(node.elements, visitors), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkArrowFunctionExpression(node, visitors) {
	let enterExit = visitors[30], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.typeParameters, visitors), walkNode(node.params, visitors), walkNode(node.returnType, visitors), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkAssignmentExpression(node, visitors) {
	let enterExit = visitors[31], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.left, visitors), walkNode(node.right, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkAssignmentPattern(node, visitors) {
	let enterExit = visitors[32], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.decorators, visitors), walkNode(node.left, visitors), walkNode(node.right, visitors), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkAwaitExpression(node, visitors) {
	let enterExit = visitors[33], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.argument, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkBinaryExpression(node, visitors) {
	let enterExit = visitors[34], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.left, visitors), walkNode(node.right, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkBlockStatement(node, visitors) {
	let enterExit = visitors[35], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkBreakStatement(node, visitors) {
	let enterExit = visitors[36], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.label, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkCallExpression(node, visitors) {
	let enterExit = visitors[37], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.callee, visitors), walkNode(node.typeArguments, visitors), walkNode(node.arguments, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkCatchClause(node, visitors) {
	let enterExit = visitors[38], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.param, visitors), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkChainExpression(node, visitors) {
	let enterExit = visitors[39], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.expression, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkClassBody(node, visitors) {
	let enterExit = visitors[40], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkClassDeclaration(node, visitors) {
	let enterExit = visitors[41], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.decorators, visitors), walkNode(node.id, visitors), walkNode(node.typeParameters, visitors), walkNode(node.superClass, visitors), walkNode(node.superTypeArguments, visitors), walkNode(node.implements, visitors), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkClassExpression(node, visitors) {
	let enterExit = visitors[42], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.decorators, visitors), walkNode(node.id, visitors), walkNode(node.typeParameters, visitors), walkNode(node.superClass, visitors), walkNode(node.superTypeArguments, visitors), walkNode(node.implements, visitors), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkConditionalExpression(node, visitors) {
	let enterExit = visitors[43], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.test, visitors), walkNode(node.consequent, visitors), walkNode(node.alternate, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkContinueStatement(node, visitors) {
	let enterExit = visitors[44], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.label, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkDecorator(node, visitors) {
	let enterExit = visitors[45], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.expression, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkDoWhileStatement(node, visitors) {
	let enterExit = visitors[46], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.body, visitors), walkNode(node.test, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkExportAllDeclaration(node, visitors) {
	let enterExit = visitors[47], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.exported, visitors), walkNode(node.source, visitors), walkNode(node.attributes, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkExportDefaultDeclaration(node, visitors) {
	let enterExit = visitors[48], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.declaration, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkExportNamedDeclaration(node, visitors) {
	let enterExit = visitors[49], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.declaration, visitors), walkNode(node.specifiers, visitors), walkNode(node.source, visitors), walkNode(node.attributes, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkExportSpecifier(node, visitors) {
	let enterExit = visitors[50], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.local, visitors), walkNode(node.exported, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkExpressionStatement(node, visitors) {
	let enterExit = visitors[51], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.expression, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkForInStatement(node, visitors) {
	let enterExit = visitors[52], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.left, visitors), walkNode(node.right, visitors), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkForOfStatement(node, visitors) {
	let enterExit = visitors[53], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.left, visitors), walkNode(node.right, visitors), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkForStatement(node, visitors) {
	let enterExit = visitors[54], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.init, visitors), walkNode(node.test, visitors), walkNode(node.update, visitors), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkFunctionDeclaration(node, visitors) {
	let enterExit = visitors[55], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.id, visitors), walkNode(node.typeParameters, visitors), walkNode(node.params, visitors), walkNode(node.returnType, visitors), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkFunctionExpression(node, visitors) {
	let enterExit = visitors[56], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.id, visitors), walkNode(node.typeParameters, visitors), walkNode(node.params, visitors), walkNode(node.returnType, visitors), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkIdentifier(node, visitors) {
	let enterExit = visitors[57], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.decorators, visitors), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkIfStatement(node, visitors) {
	let enterExit = visitors[58], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.test, visitors), walkNode(node.consequent, visitors), walkNode(node.alternate, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkImportAttribute(node, visitors) {
	let enterExit = visitors[59], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.key, visitors), walkNode(node.value, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkImportDeclaration(node, visitors) {
	let enterExit = visitors[60], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.specifiers, visitors), walkNode(node.source, visitors), walkNode(node.attributes, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkImportDefaultSpecifier(node, visitors) {
	let enterExit = visitors[61], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.local, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkImportExpression(node, visitors) {
	let enterExit = visitors[62], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.source, visitors), walkNode(node.options, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkImportNamespaceSpecifier(node, visitors) {
	let enterExit = visitors[63], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.local, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkImportSpecifier(node, visitors) {
	let enterExit = visitors[64], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.imported, visitors), walkNode(node.local, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkLabeledStatement(node, visitors) {
	let enterExit = visitors[65], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.label, visitors), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkLogicalExpression(node, visitors) {
	let enterExit = visitors[66], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.left, visitors), walkNode(node.right, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkMemberExpression(node, visitors) {
	let enterExit = visitors[67], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.object, visitors), walkNode(node.property, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkMetaProperty(node, visitors) {
	let enterExit = visitors[68], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.meta, visitors), walkNode(node.property, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkMethodDefinition(node, visitors) {
	let enterExit = visitors[69], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.decorators, visitors), walkNode(node.key, visitors), walkNode(node.value, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkNewExpression(node, visitors) {
	let enterExit = visitors[70], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.callee, visitors), walkNode(node.typeArguments, visitors), walkNode(node.arguments, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkObjectExpression(node, visitors) {
	let enterExit = visitors[71], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.properties, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkObjectPattern(node, visitors) {
	let enterExit = visitors[72], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.decorators, visitors), walkNode(node.properties, visitors), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkParenthesizedExpression(node, visitors) {
	let enterExit = visitors[73], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.expression, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkProgram(node, visitors) {
	let enterExit = visitors[74], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkProperty(node, visitors) {
	let enterExit = visitors[75], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.key, visitors), walkNode(node.value, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkPropertyDefinition(node, visitors) {
	let enterExit = visitors[76], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.decorators, visitors), walkNode(node.key, visitors), walkNode(node.typeAnnotation, visitors), walkNode(node.value, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkRestElement(node, visitors) {
	let enterExit = visitors[77], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.decorators, visitors), walkNode(node.argument, visitors), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkReturnStatement(node, visitors) {
	let enterExit = visitors[78], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.argument, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkSequenceExpression(node, visitors) {
	let enterExit = visitors[79], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.expressions, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkSpreadElement(node, visitors) {
	let enterExit = visitors[80], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.argument, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkStaticBlock(node, visitors) {
	let enterExit = visitors[81], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkSwitchCase(node, visitors) {
	let enterExit = visitors[82], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.test, visitors), walkNode(node.consequent, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkSwitchStatement(node, visitors) {
	let enterExit = visitors[83], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.discriminant, visitors), walkNode(node.cases, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTaggedTemplateExpression(node, visitors) {
	let enterExit = visitors[84], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.tag, visitors), walkNode(node.typeArguments, visitors), walkNode(node.quasi, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTemplateLiteral(node, visitors) {
	let enterExit = visitors[85], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.quasis, visitors), walkNode(node.expressions, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkThrowStatement(node, visitors) {
	let enterExit = visitors[86], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.argument, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTryStatement(node, visitors) {
	let enterExit = visitors[87], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.block, visitors), walkNode(node.handler, visitors), walkNode(node.finalizer, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkUnaryExpression(node, visitors) {
	let enterExit = visitors[88], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.argument, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkUpdateExpression(node, visitors) {
	let enterExit = visitors[89], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.argument, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkV8IntrinsicExpression(node, visitors) {
	let enterExit = visitors[90], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.name, visitors), walkNode(node.arguments, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkVariableDeclaration(node, visitors) {
	let enterExit = visitors[91], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.declarations, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkVariableDeclarator(node, visitors) {
	let enterExit = visitors[92], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.id, visitors), walkNode(node.init, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkWhileStatement(node, visitors) {
	let enterExit = visitors[93], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.test, visitors), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkWithStatement(node, visitors) {
	let enterExit = visitors[94], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.object, visitors), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkYieldExpression(node, visitors) {
	let enterExit = visitors[95], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.argument, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkJSXAttribute(node, visitors) {
	let enterExit = visitors[96], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.name, visitors), walkNode(node.value, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkJSXClosingElement(node, visitors) {
	let enterExit = visitors[97], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.name, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkJSXElement(node, visitors) {
	let enterExit = visitors[98], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.openingElement, visitors), walkNode(node.children, visitors), walkNode(node.closingElement, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkJSXExpressionContainer(node, visitors) {
	let enterExit = visitors[99], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.expression, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkJSXFragment(node, visitors) {
	let enterExit = visitors[100], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.openingFragment, visitors), walkNode(node.children, visitors), walkNode(node.closingFragment, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkJSXMemberExpression(node, visitors) {
	let enterExit = visitors[101], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.object, visitors), walkNode(node.property, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkJSXNamespacedName(node, visitors) {
	let enterExit = visitors[102], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.namespace, visitors), walkNode(node.name, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkJSXOpeningElement(node, visitors) {
	let enterExit = visitors[103], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.name, visitors), walkNode(node.typeArguments, visitors), walkNode(node.attributes, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkJSXSpreadAttribute(node, visitors) {
	let enterExit = visitors[104], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.argument, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkJSXSpreadChild(node, visitors) {
	let enterExit = visitors[105], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.expression, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSAbstractAccessorProperty(node, visitors) {
	let enterExit = visitors[106], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.decorators, visitors), walkNode(node.key, visitors), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSAbstractMethodDefinition(node, visitors) {
	let enterExit = visitors[107], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.key, visitors), walkNode(node.value, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSAbstractPropertyDefinition(node, visitors) {
	let enterExit = visitors[108], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.decorators, visitors), walkNode(node.key, visitors), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSArrayType(node, visitors) {
	let enterExit = visitors[109], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.elementType, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSAsExpression(node, visitors) {
	let enterExit = visitors[110], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.expression, visitors), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSCallSignatureDeclaration(node, visitors) {
	let enterExit = visitors[111], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.typeParameters, visitors), walkNode(node.params, visitors), walkNode(node.returnType, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSClassImplements(node, visitors) {
	let enterExit = visitors[112], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.expression, visitors), walkNode(node.typeArguments, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSConditionalType(node, visitors) {
	let enterExit = visitors[113], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.checkType, visitors), walkNode(node.extendsType, visitors), walkNode(node.trueType, visitors), walkNode(node.falseType, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSConstructSignatureDeclaration(node, visitors) {
	let enterExit = visitors[114], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.typeParameters, visitors), walkNode(node.params, visitors), walkNode(node.returnType, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSConstructorType(node, visitors) {
	let enterExit = visitors[115], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.typeParameters, visitors), walkNode(node.params, visitors), walkNode(node.returnType, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSDeclareFunction(node, visitors) {
	let enterExit = visitors[116], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.id, visitors), walkNode(node.typeParameters, visitors), walkNode(node.params, visitors), walkNode(node.returnType, visitors), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSEmptyBodyFunctionExpression(node, visitors) {
	let enterExit = visitors[117], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.id, visitors), walkNode(node.typeParameters, visitors), walkNode(node.params, visitors), walkNode(node.returnType, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSEnumBody(node, visitors) {
	let enterExit = visitors[118], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.members, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSEnumDeclaration(node, visitors) {
	let enterExit = visitors[119], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.id, visitors), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSEnumMember(node, visitors) {
	let enterExit = visitors[120], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.id, visitors), walkNode(node.initializer, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSExportAssignment(node, visitors) {
	let enterExit = visitors[121], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.expression, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSExternalModuleReference(node, visitors) {
	let enterExit = visitors[122], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.expression, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSFunctionType(node, visitors) {
	let enterExit = visitors[123], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.typeParameters, visitors), walkNode(node.params, visitors), walkNode(node.returnType, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSImportEqualsDeclaration(node, visitors) {
	let enterExit = visitors[124], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.id, visitors), walkNode(node.moduleReference, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSImportType(node, visitors) {
	let enterExit = visitors[125], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.argument, visitors), walkNode(node.options, visitors), walkNode(node.qualifier, visitors), walkNode(node.typeArguments, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSIndexSignature(node, visitors) {
	let enterExit = visitors[126], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.parameters, visitors), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSIndexedAccessType(node, visitors) {
	let enterExit = visitors[127], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.objectType, visitors), walkNode(node.indexType, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSInferType(node, visitors) {
	let enterExit = visitors[128], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.typeParameter, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSInstantiationExpression(node, visitors) {
	let enterExit = visitors[129], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.expression, visitors), walkNode(node.typeArguments, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSInterfaceBody(node, visitors) {
	let enterExit = visitors[130], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSInterfaceDeclaration(node, visitors) {
	let enterExit = visitors[131], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.id, visitors), walkNode(node.typeParameters, visitors), walkNode(node.extends, visitors), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSInterfaceHeritage(node, visitors) {
	let enterExit = visitors[132], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.expression, visitors), walkNode(node.typeArguments, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSIntersectionType(node, visitors) {
	let enterExit = visitors[133], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.types, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSJSDocNonNullableType(node, visitors) {
	let enterExit = visitors[134], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSJSDocNullableType(node, visitors) {
	let enterExit = visitors[135], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSLiteralType(node, visitors) {
	let enterExit = visitors[136], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.literal, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSMappedType(node, visitors) {
	let enterExit = visitors[137], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.key, visitors), walkNode(node.constraint, visitors), walkNode(node.nameType, visitors), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSMethodSignature(node, visitors) {
	let enterExit = visitors[138], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.key, visitors), walkNode(node.typeParameters, visitors), walkNode(node.params, visitors), walkNode(node.returnType, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSModuleBlock(node, visitors) {
	let enterExit = visitors[139], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSModuleDeclaration(node, visitors) {
	let enterExit = visitors[140], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.id, visitors), walkNode(node.body, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSNamedTupleMember(node, visitors) {
	let enterExit = visitors[141], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.label, visitors), walkNode(node.elementType, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSNamespaceExportDeclaration(node, visitors) {
	let enterExit = visitors[142], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.id, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSNonNullExpression(node, visitors) {
	let enterExit = visitors[143], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.expression, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSOptionalType(node, visitors) {
	let enterExit = visitors[144], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSParameterProperty(node, visitors) {
	let enterExit = visitors[145], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.decorators, visitors), walkNode(node.parameter, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSParenthesizedType(node, visitors) {
	let enterExit = visitors[146], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSPropertySignature(node, visitors) {
	let enterExit = visitors[147], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.key, visitors), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSQualifiedName(node, visitors) {
	let enterExit = visitors[148], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.left, visitors), walkNode(node.right, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSRestType(node, visitors) {
	let enterExit = visitors[149], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSSatisfiesExpression(node, visitors) {
	let enterExit = visitors[150], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.expression, visitors), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSTemplateLiteralType(node, visitors) {
	let enterExit = visitors[151], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.quasis, visitors), walkNode(node.types, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSTupleType(node, visitors) {
	let enterExit = visitors[152], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.elementTypes, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSTypeAliasDeclaration(node, visitors) {
	let enterExit = visitors[153], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.id, visitors), walkNode(node.typeParameters, visitors), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSTypeAnnotation(node, visitors) {
	let enterExit = visitors[154], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSTypeAssertion(node, visitors) {
	let enterExit = visitors[155], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.typeAnnotation, visitors), walkNode(node.expression, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSTypeLiteral(node, visitors) {
	let enterExit = visitors[156], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.members, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSTypeOperator(node, visitors) {
	let enterExit = visitors[157], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSTypeParameter(node, visitors) {
	let enterExit = visitors[158], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.name, visitors), walkNode(node.constraint, visitors), walkNode(node.default, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSTypeParameterDeclaration(node, visitors) {
	let enterExit = visitors[159], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.params, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSTypeParameterInstantiation(node, visitors) {
	let enterExit = visitors[160], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.params, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSTypePredicate(node, visitors) {
	let enterExit = visitors[161], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.parameterName, visitors), walkNode(node.typeAnnotation, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSTypeQuery(node, visitors) {
	let enterExit = visitors[162], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.exprName, visitors), walkNode(node.typeArguments, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSTypeReference(node, visitors) {
	let enterExit = visitors[163], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.typeName, visitors), walkNode(node.typeArguments, visitors), ancestors.shift(), exit !== null && exit(node);
}
function walkTSUnionType(node, visitors) {
	let enterExit = visitors[164], exit = null;
	if (enterExit !== null) {
		let enter;
		({enter, exit} = enterExit), enter !== null && enter(node);
	}
	ancestors.unshift(node), walkNode(node.types, visitors), ancestors.shift(), exit !== null && exit(node);
}
var import_esquery_min = /* @__PURE__ */ __toESM(require_esquery_min(), 1);
const ObjectKeys$1 = Object.keys, { matches: esqueryMatches, parse: esqueryParse } = import_esquery_min.default, ESQUERY_OPTIONS = {
	nodeTypeKey: "type",
	visitorKeys: keys_default,
	fallback: (node) => ObjectKeys$1(node).filter(filterKey),
	matchClass: (_className, _node, _ancestors) => !1
}, filterKey = (key) => key !== "parent" && key !== "range" && key !== "loc", cache = /* @__PURE__ */ new Map([]), EMPTY_TYPE_IDS_ARRAY = [];
function parseSelector(key) {
	let selector = cache.get(key);
	if (selector !== void 0) return selector;
	let esquerySelector = esqueryParse(key);
	return selector = {
		typeIds: null,
		esquerySelector,
		isComplex: !1,
		attributeCount: 0,
		identifierCount: 0
	}, selector.typeIds = analyzeSelector(esquerySelector, selector), cache.set(key, selector), selector;
}
function analyzeSelector(esquerySelector, selector) {
	switch (esquerySelector.type) {
		case "identifier": {
			selector.identifierCount++;
			let typeId = NODE_TYPE_IDS_MAP.get(esquerySelector.value);
			return typeId === void 0 ? EMPTY_TYPE_IDS_ARRAY : [typeId];
		}
		case "not":
			for (let i = 0, childSelectors = esquerySelector.selectors, len = childSelectors.length; i < len; i++) analyzeSelector(childSelectors[i], selector);
			return selector.isComplex = !0, null;
		case "matches": {
			let nodeTypes = [];
			for (let i = 0, childSelectors = esquerySelector.selectors, len = childSelectors.length; i < len; i++) {
				let childNodeTypes = analyzeSelector(childSelectors[i], selector);
				childNodeTypes === null ? nodeTypes = null : nodeTypes !== null && nodeTypes.push(...childNodeTypes);
			}
			return nodeTypes === null ? null : [...new Set(nodeTypes)];
		}
		case "compound": {
			let childSelectors = esquerySelector.selectors, len = childSelectors.length;
			if (len === 0) return [];
			let nodeTypes = null;
			for (let i = 0; i < len; i++) {
				let childNodeTypes = analyzeSelector(childSelectors[i], selector);
				childNodeTypes !== null && (nodeTypes = nodeTypes === null ? childNodeTypes : childNodeTypes.filter((nodeType) => nodeTypes.includes(nodeType)));
			}
			return nodeTypes;
		}
		case "attribute":
		case "field":
		case "nth-child":
		case "nth-last-child": return selector.isComplex = !0, selector.attributeCount++, null;
		case "child":
		case "descendant":
		case "sibling":
		case "adjacent": return selector.isComplex = !0, analyzeSelector(esquerySelector.left, selector), analyzeSelector(esquerySelector.right, selector);
		case "class": return esquerySelector.name === "function" ? FUNCTION_NODE_TYPE_IDS : (selector.isComplex = !0, null);
		case "wildcard": return null;
		default: return selector.isComplex = !0, null;
	}
}
function wrapVisitFnWithSelectorMatch(visitFn, esquerySelector) {
	return (node) => {
		esqueryMatches(node, esquerySelector, ancestors, ESQUERY_OPTIONS) && visitFn(node);
	};
}
const ObjectKeys = Object.keys, { isArray } = Array, compiledVisitor = [];
for (let i = 165; i !== 0; i--) compiledVisitor.push(null);
const mergedLeafVisitorTypeIds = [], mergedEnterVisitorTypeIds = [], mergedExitVisitorTypeIds = [];
for (let i = 27; i !== 0; i--) mergedLeafVisitorTypeIds.push(0);
for (let i = 138; i !== 0; i--) mergedEnterVisitorTypeIds.push(0), mergedExitVisitorTypeIds.push(0);
mergedLeafVisitorTypeIds.length = 0, mergedEnterVisitorTypeIds.length = 0, mergedExitVisitorTypeIds.length = 0;
let hasActiveVisitors = !1;
const enterExitObjectCache = [];
let enterExitObjectCacheNextIndex = 0;
function getEnterExitObject() {
	if (enterExitObjectCacheNextIndex < enterExitObjectCache.length) return enterExitObjectCache[enterExitObjectCacheNextIndex++];
	let enterExit = {
		enter: null,
		exit: null
	};
	return enterExitObjectCache.push(enterExit), enterExitObjectCacheNextIndex++, enterExit;
}
const visitFnArrayCache = [];
let visitFnArrayCacheNextIndex = 0;
function createVisitFnArray(visit1, visit2) {
	if (visitFnArrayCacheNextIndex < visitFnArrayCache.length) {
		let arr$1 = visitFnArrayCache[visitFnArrayCacheNextIndex++];
		return arr$1.push(visit1, visit2), arr$1;
	}
	let arr = [visit1, visit2];
	return visitFnArrayCache.push(arr), visitFnArrayCacheNextIndex++, arr;
}
function initCompiledVisitor() {
	for (let i = 0; i < 165; i++) compiledVisitor[i] = null;
	for (let i = 0; i < enterExitObjectCacheNextIndex; i++) {
		let enterExit = enterExitObjectCache[i];
		enterExit.enter = null, enterExit.exit = null;
	}
	enterExitObjectCacheNextIndex = 0;
}
function addVisitorToCompiled(visitor) {
	if (typeof visitor != "object" || !visitor) throw TypeError("Visitor returned from `create` method must be an object");
	let keys = ObjectKeys(visitor), keysLen = keys.length;
	if (keysLen !== 0) {
		hasActiveVisitors = !0;
		for (let i = 0; i < keysLen; i++) {
			let name = keys[i], visitFn = visitor[name];
			if (typeof visitFn != "function") throw TypeError(`'${name}' property of visitor object is not a function`);
			let isExit = name.endsWith(":exit");
			isExit && (name = name.slice(0, -5));
			let typeId = NODE_TYPE_IDS_MAP.get(name);
			if (typeId !== void 0) {
				addVisitFn(typeId, isExit, visitFn);
				continue;
			}
			if (name !== "*") {
				let selector = parseSelector(name);
				selector.isComplex && (visitFn = wrapVisitFnWithSelectorMatch(visitFn, selector.esquerySelector));
				let { typeIds } = selector;
				if (typeIds !== null) {
					for (let i$1 = 0, len = typeIds.length; i$1 < len; i$1++) addVisitFn(typeIds[i$1], isExit, visitFn);
					continue;
				}
			}
			for (typeId = 0; typeId < 27; typeId++) addLeafVisitFn(typeId, isExit, visitFn);
			for (; typeId < 165; typeId++) addNonLeafVisitFn(typeId, isExit, visitFn);
		}
	}
}
function addVisitFn(typeId, isExit, visitFn) {
	typeId < 27 ? addLeafVisitFn(typeId, isExit, visitFn) : addNonLeafVisitFn(typeId, isExit, visitFn);
}
function addLeafVisitFn(typeId, isExit, visitFn) {
	let existing = compiledVisitor[typeId];
	existing === null ? compiledVisitor[typeId] = visitFn : isArray(existing) ? isExit ? existing.push(visitFn) : existing.splice(existing.length - 1, 0, visitFn) : (compiledVisitor[typeId] = isExit ? createVisitFnArray(existing, visitFn) : createVisitFnArray(visitFn, existing), mergedLeafVisitorTypeIds.push(typeId));
}
function addNonLeafVisitFn(typeId, isExit, visitFn) {
	let existing = compiledVisitor[typeId];
	if (existing === null) {
		let enterExit = compiledVisitor[typeId] = getEnterExitObject();
		isExit ? enterExit.exit = visitFn : enterExit.enter = visitFn;
	} else if (isExit) {
		let { exit } = existing;
		exit === null ? existing.exit = visitFn : isArray(exit) ? exit.push(visitFn) : (existing.exit = createVisitFnArray(exit, visitFn), mergedExitVisitorTypeIds.push(typeId));
	} else {
		let { enter } = existing;
		enter === null ? existing.enter = visitFn : isArray(enter) ? enter.push(visitFn) : (existing.enter = createVisitFnArray(enter, visitFn), mergedEnterVisitorTypeIds.push(typeId));
	}
}
function finalizeCompiledVisitor() {
	if (hasActiveVisitors === !1) return !1;
	for (let i = mergedLeafVisitorTypeIds.length - 1; i >= 0; i--) {
		let typeId = mergedLeafVisitorTypeIds[i];
		compiledVisitor[typeId] = mergeVisitFns(compiledVisitor[typeId]);
	}
	for (let i = mergedEnterVisitorTypeIds.length - 1; i >= 0; i--) {
		let enterExit = compiledVisitor[mergedEnterVisitorTypeIds[i]];
		enterExit.enter = mergeVisitFns(enterExit.enter);
	}
	for (let i = mergedExitVisitorTypeIds.length - 1; i >= 0; i--) {
		let enterExit = compiledVisitor[mergedExitVisitorTypeIds[i]];
		enterExit.exit = mergeVisitFns(enterExit.exit);
	}
	return mergedLeafVisitorTypeIds.length = 0, mergedEnterVisitorTypeIds.length = 0, mergedExitVisitorTypeIds.length = 0, visitFnArrayCacheNextIndex = 0, hasActiveVisitors = !1, !0;
}
function mergeVisitFns(visitFns) {
	let numVisitFns = visitFns.length, merger;
	if (mergers.length <= numVisitFns) {
		for (; mergers.length < numVisitFns;) mergers.push(null);
		merger = createMerger(numVisitFns), mergers.push(merger);
	} else merger = mergers[numVisitFns], merger === null && (merger = mergers[numVisitFns] = createMerger(numVisitFns));
	let mergedFn = merger(...visitFns);
	return visitFns.length = 0, mergedFn;
}
function createMerger(fnCount) {
	let args = [], body = "return node=>{";
	for (let i = 1; i <= fnCount; i++) args.push(`visit${i}`), body += `visit${i}(node);`;
	return body += "}", args.push(body), Function(...args);
}
const mergers = [
	null,
	null,
	(visit1, visit2) => (node) => {
		visit1(node), visit2(node);
	},
	(visit1, visit2, visit3) => (node) => {
		visit1(node), visit2(node), visit3(node);
	},
	(visit1, visit2, visit3, visit4) => (node) => {
		visit1(node), visit2(node), visit3(node), visit4(node);
	},
	(visit1, visit2, visit3, visit4, visit5) => (node) => {
		visit1(node), visit2(node), visit3(node), visit4(node), visit5(node);
	}
], buffers = [], afterHooks = [], PARSER_SERVICES_DEFAULT = Object.freeze({});
function lintFile(filePath$1, bufferId, buffer$1, ruleIds, optionsIds, settingsJSON$1) {
	try {
		lintFileImpl(filePath$1, bufferId, buffer$1, ruleIds, optionsIds, settingsJSON$1);
		for (let i = 0, len = diagnostics.length; i < len; i++) diagnostics[i].messageId = void 0;
		return JSON.stringify({ Success: diagnostics });
	} catch (err) {
		return JSON.stringify({ Failure: getErrorMessage(err) });
	} finally {
		diagnostics.length = 0, resetFile();
	}
}
function lintFileImpl(filePath$1, bufferId, buffer$1, ruleIds, optionsIds, settingsJSON$1) {
	if (buffer$1 === null) buffer$1 = buffers[bufferId];
	else {
		let { buffer: arrayBuffer, byteOffset } = buffer$1;
		buffer$1.uint32 = new Uint32Array(arrayBuffer, byteOffset), buffer$1.float64 = new Float64Array(arrayBuffer, byteOffset);
		for (let i = bufferId - buffers.length; i >= 0; i--) buffers.push(null);
		buffers[bufferId] = buffer$1;
	}
	setupFileContext(filePath$1), setupSourceForFile(buffer$1, !1, PARSER_SERVICES_DEFAULT), setSettingsForFile(settingsJSON$1), initCompiledVisitor();
	for (let i = 0, len = ruleIds.length; i < len; i++) {
		let ruleDetails = registeredRules[ruleIds[i]];
		ruleDetails.ruleIndex = i;
		let optionsId = optionsIds[i];
		ruleDetails.options = optionsId === 0 ? ruleDetails.defaultOptions : allOptions[optionsId];
		let { visitor } = ruleDetails;
		if (visitor === null) visitor = ruleDetails.rule.create(ruleDetails.context);
		else {
			let { beforeHook, afterHook } = ruleDetails;
			if (beforeHook !== null && beforeHook() === !1) continue;
			afterHook !== null && afterHooks.push(afterHook);
		}
		addVisitorToCompiled(visitor);
	}
	finalizeCompiledVisitor() && (ast === null && initAst(), walkProgram(ast, compiledVisitor));
	let afterHooksLen = afterHooks.length;
	if (afterHooksLen !== 0) {
		for (let i = 0; i < afterHooksLen; i++) (0, afterHooks[i])();
		afterHooks.length = 0;
	}
}
function resetFile() {
	resetFileContext(), resetSourceAndAst(), resetSettings();
}
export { BUFFER_SIZE as _, loadPlugin as a, allOptions as c, PLACEHOLDER_REGEX as d, diagnostics as f, BUFFER_ALIGN as g, getNodeByRangeIndex as h, resetFile as i, mergeOptions as l, getLineColumnFromOffset as m, lintFile as n, registerPlugin as o, replacePlaceholders as p, lintFileImpl as r, registeredRules as s, buffers as t, setOptions as u, DATA_POINTER_POS_32 as v };
