import { r as __toESM, t as __commonJSMin } from "./chunk.js";
import { i as rawTransferSupported, r as parseRawSync, t as getBufferOffset } from "./bindings.js";
import { _ as BUFFER_SIZE, c as allOptions, d as PLACEHOLDER_REGEX, f as diagnostics, g as BUFFER_ALIGN, h as getNodeByRangeIndex, i as resetFile, l as mergeOptions, m as getLineColumnFromOffset, o as registerPlugin, p as replacePlaceholders, r as lintFileImpl, s as registeredRules, t as buffers, v as DATA_POINTER_POS_32 } from "./lint.js";
import assert, { AssertionError } from "node:assert";
import util from "node:util";
const { defineProperty, getPrototypeOf, hasOwn: hasOwn$1, setPrototypeOf, create: ObjectCreate, freeze, assign: ObjectAssign } = Object, EMPTY_VISITOR = {};
function definePlugin(plugin) {
	if (typeof plugin != "object" || !plugin) throw Error("Plugin must be an object");
	let { rules } = plugin;
	if (typeof rules != "object" || !rules) throw Error("Plugin must have an object as `rules` property");
	for (let ruleName in rules) hasOwn$1(rules, ruleName) && (rules[ruleName] = defineRule(rules[ruleName]));
	return plugin;
}
function defineRule(rule) {
	if (typeof rule != "object" || !rule) throw Error("Rule must be an object");
	if ("create" in rule) return rule;
	let context = null, visitor, beforeHook;
	return rule.create = (eslintContext) => (context === null && ({context, visitor, beforeHook} = createContextAndVisitor(rule)), defineProperty(context, "id", { value: eslintContext.id }), defineProperty(context, "options", { value: eslintContext.options }), defineProperty(context, "report", { value: eslintContext.report }), setPrototypeOf(context, getPrototypeOf(eslintContext)), beforeHook !== null && beforeHook() === !1 ? EMPTY_VISITOR : visitor), rule;
}
let cwd = null;
const FILE_CONTEXT = freeze({
	get filename() {
		throw Error("Cannot access `context.filename` in `createOnce`");
	},
	getFilename() {
		throw Error("Cannot call `context.getFilename` in `createOnce`");
	},
	get physicalFilename() {
		throw Error("Cannot access `context.physicalFilename` in `createOnce`");
	},
	getPhysicalFilename() {
		throw Error("Cannot call `context.getPhysicalFilename` in `createOnce`");
	},
	get cwd() {
		return cwd === null && (cwd = process.cwd()), cwd;
	},
	getCwd() {
		return cwd === null && (cwd = process.cwd()), cwd;
	},
	get sourceCode() {
		throw Error("Cannot access `context.sourceCode` in `createOnce`");
	},
	getSourceCode() {
		throw Error("Cannot call `context.getSourceCode` in `createOnce`");
	},
	get languageOptions() {
		throw Error("Cannot access `context.languageOptions` in `createOnce`");
	},
	get settings() {
		throw Error("Cannot access `context.settings` in `createOnce`");
	},
	extend(extension) {
		return freeze(ObjectAssign(ObjectCreate(this), extension));
	},
	get parserOptions() {
		throw Error("Cannot access `context.parserOptions` in `createOnce`");
	},
	get parserPath() {
		throw Error("Cannot access `context.parserPath` in `createOnce`");
	}
});
function createContextAndVisitor(rule) {
	let { createOnce } = rule;
	if (createOnce == null) throw Error("Rules must define either a `create` or `createOnce` method");
	if (typeof createOnce != "function") throw Error("Rule `createOnce` property must be a function");
	let context = ObjectCreate(FILE_CONTEXT, {
		id: {
			value: "",
			enumerable: !0,
			configurable: !0
		},
		options: {
			value: null,
			enumerable: !0,
			configurable: !0
		},
		report: {
			value: null,
			enumerable: !0,
			configurable: !0
		}
	}), { before: beforeHook, after: afterHook, ...visitor } = createOnce.call(rule, context);
	if (beforeHook === void 0) beforeHook = null;
	else if (beforeHook !== null && typeof beforeHook != "function") throw Error("`before` property of visitor must be a function if defined");
	if (afterHook != null) {
		if (typeof afterHook != "function") throw Error("`after` property of visitor must be a function if defined");
		let programExit = visitor["Program:exit"];
		visitor["Program:exit"] = programExit == null ? (_node) => afterHook() : (node) => {
			programExit(node), afterHook();
		};
	}
	return {
		context,
		visitor,
		beforeHook
	};
}
var import_json_stable_stringify_without_jsonify = /* @__PURE__ */ __toESM((/* @__PURE__ */ __commonJSMin(((exports, module) => {
	module.exports = function(obj, opts) {
		opts ||= {}, typeof opts == "function" && (opts = { cmp: opts });
		var space = opts.space || "";
		typeof space == "number" && (space = Array(space + 1).join(" "));
		var cycles = typeof opts.cycles == "boolean" ? opts.cycles : !1, replacer = opts.replacer || function(key, value) {
			return value;
		}, cmp = opts.cmp && (function(f) {
			return function(node) {
				return function(a, b) {
					return f({
						key: a,
						value: node[a]
					}, {
						key: b,
						value: node[b]
					});
				};
			};
		})(opts.cmp), seen = [];
		return (function stringify$1(parent, key, node, level) {
			var indent = space ? "\n" + Array(level + 1).join(space) : "", colonSeparator = space ? ": " : ":";
			if (node && node.toJSON && typeof node.toJSON == "function" && (node = node.toJSON()), node = replacer.call(parent, key, node), node !== void 0) {
				if (typeof node != "object" || !node) return JSON.stringify(node);
				if (isArray$1(node)) {
					for (var out = [], i = 0; i < node.length; i++) {
						var item = stringify$1(node, i, node[i], level + 1) || JSON.stringify(null);
						out.push(indent + space + item);
					}
					return "[" + out.join(",") + indent + "]";
				} else {
					if (seen.indexOf(node) !== -1) {
						if (cycles) return JSON.stringify("__cycle__");
						throw TypeError("Converting circular structure to JSON");
					} else seen.push(node);
					for (var keys = objectKeys(node).sort(cmp && cmp(node)), out = [], i = 0; i < keys.length; i++) {
						var key = keys[i], value = stringify$1(node, key, node[key], level + 1);
						if (value) {
							var keyValue = JSON.stringify(key) + colonSeparator + value;
							out.push(indent + space + keyValue);
						}
					}
					return seen.splice(seen.indexOf(node), 1), "{" + out.join(",") + indent + "}";
				}
			}
		})({ "": obj }, "", obj, 0);
	};
	var isArray$1 = Array.isArray || function(x) {
		return {}.toString.call(x) === "[object Array]";
	}, objectKeys = Object.keys || function(obj) {
		var has = Object.prototype.hasOwnProperty || function() {
			return !0;
		}, keys = [];
		for (var key in obj) has.call(obj, key) && keys.push(key);
		return keys;
	};
})))(), 1);
const ARRAY_BUFFER_SIZE = BUFFER_SIZE + BUFFER_ALIGN, textEncoder = new TextEncoder();
let buffer = null, rawTransferIsSupported = null;
function parse(path, sourceText) {
	if (!rawTransferSupported$1()) throw Error("`RuleTester` is not supported on 32-bit or big-endian systems, versions of NodeJS prior to v22.0.0, versions of Deno prior to v2.0.0, or other runtimes");
	buffer === null && initBuffer();
	let sourceBuffer = new Uint8Array(buffer.buffer, buffer.byteOffset, 1073741824), { read, written: sourceByteLen } = textEncoder.encodeInto(sourceText, sourceBuffer);
	if (read !== sourceText.length) throw Error("Failed to write source text into buffer");
	if (parseRawSync(path, buffer, sourceByteLen), buffer.uint32[DATA_POINTER_POS_32] === 0) throw Error("Parsing failed");
}
function initBuffer() {
	let arrayBuffer = new ArrayBuffer(ARRAY_BUFFER_SIZE), offset = getBufferOffset(new Uint8Array(arrayBuffer));
	buffer = new Uint8Array(arrayBuffer, offset, BUFFER_SIZE), buffer.uint32 = new Uint32Array(arrayBuffer, offset, BUFFER_SIZE / 4), buffer.float64 = new Float64Array(arrayBuffer, offset, BUFFER_SIZE / 8), buffers.push(buffer);
}
function rawTransferSupported$1() {
	return rawTransferIsSupported === null && (rawTransferIsSupported = rawTransferRuntimeSupported() && rawTransferSupported()), rawTransferIsSupported;
}
function rawTransferRuntimeSupported() {
	let global;
	try {
		global = globalThis;
	} catch {
		return !1;
	}
	if (global.Bun || global.process?.versions?.bun) return !1;
	if (global.Deno) {
		let match$1 = Deno.version?.deno?.match(/^(\d+)\./);
		return !!match$1 && +match$1[1] >= 2;
	}
	if (global.process?.release?.name !== "node") return !1;
	let match = process.version?.match(/^v(\d+)\./);
	return !!match && +match[1] >= 22;
}
const { hasOwn } = Object, { isArray } = Array;
function defaultDescribe(text, method) {
	return method.call(this);
}
const globalObj = globalThis;
let describe = typeof globalObj.describe == "function" ? globalObj.describe : defaultDescribe;
function defaultIt(text, method) {
	try {
		return method.call(this);
	} catch (err) {
		throw err instanceof AssertionError && (err.message += ` (${util.inspect(err.actual)} ${err.operator} ${util.inspect(err.expected)})`), err;
	}
}
let it = typeof globalObj.it == "function" ? globalObj.it : defaultIt, itOnly = it !== defaultIt && typeof it.only == "function" ? Function.bind.call(it.only, it) : null;
function getIt(only) {
	return only ? getItOnly() : it;
}
function getItOnly() {
	if (itOnly === null) throw Error("To use `only`, use `RuleTester` with a test framework that provides `it.only()` like Mocha, or provide a custom `it.only` function by assigning it to `RuleTester.itOnly`");
	return itOnly;
}
const DEFAULT_SHARED_CONFIG = {};
let sharedConfig = DEFAULT_SHARED_CONFIG;
var RuleTester = class {
	#config;
	constructor(config) {
		this.#config = config === void 0 ? null : config;
	}
	static setDefaultConfig(config) {
		if (typeof config != "object" || !config) throw TypeError("`config` must be an object");
		sharedConfig = config;
	}
	static getDefaultConfig() {
		return sharedConfig;
	}
	static resetDefaultConfig() {
		sharedConfig = DEFAULT_SHARED_CONFIG;
	}
	static get describe() {
		return describe;
	}
	static set describe(value) {
		describe = value;
	}
	static get it() {
		return it;
	}
	static set it(value) {
		it = value, itOnly = typeof it.only == "function" ? Function.bind.call(it.only, it) : null;
	}
	static get itOnly() {
		return getItOnly();
	}
	static set itOnly(value) {
		itOnly = value;
	}
	static only(item) {
		return typeof item == "string" ? {
			code: item,
			only: !0
		} : {
			...item,
			only: !0
		};
	}
	run(ruleName, rule, tests) {
		let plugin = {
			meta: { name: "rule-to-test" },
			rules: { [ruleName]: rule }
		};
		describe(ruleName, () => {
			tests.valid.length > 0 && describe("valid", () => {
				let seenTestCases = /* @__PURE__ */ new Set();
				for (let test of tests.valid) typeof test == "string" && (test = { code: test }), getIt(test.only)(getTestName(test), () => {
					runValidTestCase(test, plugin, this.#config, seenTestCases);
				});
			}), tests.invalid.length > 0 && describe("invalid", () => {
				let seenTestCases = /* @__PURE__ */ new Set();
				for (let test of tests.invalid) getIt(test.only)(getTestName(test), () => {
					runInvalidTestCase(test, plugin, this.#config, seenTestCases);
				});
			});
		});
	}
};
function runValidTestCase(test, plugin, config, seenTestCases) {
	try {
		runBeforeHook(test), assertValidTestCaseIsWellFormed(test, seenTestCases), assertValidTestCasePasses(test, plugin, config);
	} finally {
		runAfterHook(test);
	}
}
function assertValidTestCasePasses(test, plugin, config) {
	assertErrorCountIsCorrect(lint(test, plugin, config), 0);
}
function runInvalidTestCase(test, plugin, config, seenTestCases) {
	let ruleName = Object.keys(plugin.rules)[0];
	try {
		runBeforeHook(test), assertInvalidTestCaseIsWellFormed(test, seenTestCases, ruleName), assertInvalidTestCasePasses(test, plugin, config);
	} finally {
		runAfterHook(test);
	}
}
function assertInvalidTestCasePasses(test, plugin, config) {
	let diagnostics$1 = lint(test, plugin, config), { errors } = test;
	if (typeof errors == "number") assertErrorCountIsCorrect(diagnostics$1, errors);
	else {
		assertErrorCountIsCorrect(diagnostics$1, errors.length);
		let messages = Object.values(plugin.rules)[0].meta?.messages ?? null;
		for (let errorIndex = 0; errorIndex < errors.length; errorIndex++) {
			let error = errors[errorIndex], diagnostic = diagnostics$1[errorIndex];
			typeof error == "string" || error instanceof RegExp ? (assertMessageMatches(diagnostic.message, error), assert(diagnostic.suggestions === null, `Error at index ${errorIndex} has suggestions. Please convert the test error into an object and specify \`suggestions\` property on it to test suggestions`)) : (assertInvalidTestCaseMessageIsCorrect(diagnostic, error, messages), assertInvalidTestCaseLocationIsCorrect(diagnostic, error));
		}
	}
}
function assertInvalidTestCaseMessageIsCorrect(diagnostic, error, messages) {
	if (hasOwn(error, "message")) {
		assert(!hasOwn(error, "messageId"), "Error should not specify both `message` and a `messageId`"), assert(!hasOwn(error, "data"), "Error should not specify both `data` and `message`"), assertMessageMatches(diagnostic.message, error.message);
		return;
	}
	assert(hasOwn(error, "messageId"), "Test error must specify either a `messageId` or `message`"), assert(messages !== null, "Error can not use `messageId` if rule under test doesn't define `meta.messages`");
	let messageId = error.messageId;
	if (!hasOwn(messages, messageId)) {
		let legalMessageIds = `[${Object.keys(messages).map((key) => `'${key}'`).join(", ")}]`;
		assert.fail(`Invalid messageId '${messageId}'. Expected one of ${legalMessageIds}`);
	}
	assert.strictEqual(diagnostic.messageId, messageId, `messageId '${diagnostic.messageId}' does not match expected messageId '${messageId}'`);
	let reportedMessage = diagnostic.message, ruleMessage = messages[messageId], unsubstitutedPlaceholders = getUnsubstitutedMessagePlaceholders(reportedMessage, ruleMessage, error.data);
	if (unsubstitutedPlaceholders.length !== 0 && assert.fail("The reported message has " + (unsubstitutedPlaceholders.length > 1 ? `unsubstituted placeholders: ${unsubstitutedPlaceholders.map((name) => `'${name}'`).join(", ")}` : `an unsubstituted placeholder '${unsubstitutedPlaceholders[0]}'`) + `. Please provide the missing ${unsubstitutedPlaceholders.length > 1 ? "values" : "value"} via the \`data\` property on the error object.`), hasOwn(error, "data")) {
		let rehydratedMessage = replacePlaceholders(ruleMessage, error.data);
		assert.strictEqual(reportedMessage, rehydratedMessage, `Hydrated message "${rehydratedMessage}" does not match "${reportedMessage}"`);
	}
}
function assertInvalidTestCaseLocationIsCorrect(diagnostic, error) {
	let actualLocation = {}, expectedLocation = {};
	hasOwn(error, "line") && (actualLocation.line = diagnostic.line, expectedLocation.line = error.line), hasOwn(error, "column") && (actualLocation.column = diagnostic.column, expectedLocation.column = error.column), hasOwn(error, "endLine") && (actualLocation.endLine = diagnostic.endLine, expectedLocation.endLine = error.endLine), hasOwn(error, "endColumn") && (actualLocation.endColumn = diagnostic.endColumn, expectedLocation.endColumn = error.endColumn), Object.keys(expectedLocation).length > 0 && assert.deepStrictEqual(actualLocation, expectedLocation, "Actual error location does not match expected error location.");
}
function assertErrorCountIsCorrect(diagnostics$1, expectedErrorCount) {
	diagnostics$1.length !== expectedErrorCount && assert.strictEqual(diagnostics$1.length, expectedErrorCount, util.format("Should have %s error%s but had %d: %s", expectedErrorCount === 0 ? "no" : expectedErrorCount, expectedErrorCount === 1 ? "" : "s", diagnostics$1.length, util.inspect(diagnostics$1)));
}
function assertMessageMatches(message, matcher) {
	typeof matcher == "string" ? assert.strictEqual(message, matcher) : assert(matcher.test(message), `Expected '${message}' to match ${matcher}`);
}
function getUnsubstitutedMessagePlaceholders(message, raw, data) {
	let unsubstituted = getMessagePlaceholders(message);
	if (unsubstituted.length === 0) return [];
	let known = getMessagePlaceholders(raw), provided = data === void 0 ? [] : Object.keys(data);
	return unsubstituted.filter((name) => known.includes(name) && !provided.includes(name));
}
function getMessagePlaceholders(message) {
	return Array.from(message.matchAll(PLACEHOLDER_REGEX), ([, name]) => name.trim());
}
function lint(test, plugin, config) {
	try {
		registerPlugin(plugin, null);
		let testOptions = test.options, { defaultOptions } = registeredRules[0], options = testOptions == null ? defaultOptions : mergeOptions(testOptions, defaultOptions);
		allOptions.push(options);
		let path = test.filename ?? "file.js";
		parse(path, test.code), lintFileImpl(path, 0, null, [0], [1], "{}");
		let ruleId = `${plugin.meta.name}/${Object.keys(plugin.rules)[0]}`;
		return diagnostics.map((diagnostic) => {
			let { line, column } = getLineColumnFromOffset(diagnostic.start), { line: endLine, column: endColumn } = getLineColumnFromOffset(diagnostic.end), node = getNodeByRangeIndex(diagnostic.start);
			return {
				ruleId,
				message: diagnostic.message,
				messageId: diagnostic.messageId,
				severity: 1,
				nodeType: node === null ? null : node.type,
				line,
				column,
				endLine,
				endColumn,
				suggestions: null
			};
		});
	} finally {
		registeredRules.length = 0, allOptions.length = 1, diagnostics.length = 0, resetFile();
	}
}
function getTestName(test) {
	let name = test.name || test.code;
	return typeof name == "string" ? name.replace(/[\u0000-\u0009\u000b-\u001a]/gu, (c) => `\\u${c.codePointAt(0).toString(16).padStart(4, "0")}`) : "";
}
function runBeforeHook(test) {
	hasOwn(test, "before") && runHook(test, test.before, "before");
}
function runAfterHook(test) {
	hasOwn(test, "after") && runHook(test, test.after, "after");
}
function runHook(test, hook, name) {
	assert.strictEqual(typeof hook, "function", `Optional test case property \`${name}\` must be a function`), hook.call(test);
}
function assertValidTestCaseIsWellFormed(test, seenTestCases) {
	assertTestCaseCommonPropertiesAreWellFormed(test), assert(!("errors" in test) || test.errors === void 0, "Valid test case must not have `errors` property"), assert(!("output" in test) || test.output === void 0, "Valid test case must not have `output` property"), assertNotDuplicateTestCase(test, seenTestCases);
}
function assertInvalidTestCaseIsWellFormed(test, seenTestCases, ruleName) {
	assertTestCaseCommonPropertiesAreWellFormed(test);
	let { errors } = test;
	typeof errors == "number" ? assert(errors > 0, "Invalid cases must have `errors` value greater than 0") : (assert(errors !== void 0, `Did not specify errors for an invalid test of rule \`${ruleName}\``), assert(isArray(errors), `Invalid 'errors' property for invalid test of rule \`${ruleName}\`:expected a number or an array but got ${errors === null ? "null" : typeof errors}`), assert(errors.length !== 0, "Invalid cases must have at least one error")), hasOwn(test, "output") && assert(test.output === null || typeof test.output == "string", "Test property `output`, if specified, must be a string or null. If no autofix is expected, then omit the `output` property or set it to null."), assertNotDuplicateTestCase(test, seenTestCases);
}
function assertTestCaseCommonPropertiesAreWellFormed(test) {
	assert(typeof test.code == "string", "Test case must specify a string value for `code`"), test.name && assert(typeof test.name == "string", "Optional test case property `name` must be a string"), hasOwn(test, "only") && assert(typeof test.only == "boolean", "Optional test case property `only` must be a boolean"), hasOwn(test, "filename") && assert(typeof test.filename == "string", "Optional test case property `filename` must be a string"), hasOwn(test, "options") && assert(Array.isArray(test.options), "Optional test case property `options` must be an array");
}
const DUPLICATION_IGNORED_PROPS = new Set([
	"name",
	"errors",
	"output"
]);
function assertNotDuplicateTestCase(test, seenTestCases) {
	if (!isSerializable(test)) return;
	let serializedTestCase = (0, import_json_stable_stringify_without_jsonify.default)(test, { replacer(key, value) {
		return test !== this || !DUPLICATION_IGNORED_PROPS.has(key) ? value : void 0;
	} });
	assert(!seenTestCases.has(serializedTestCase), "Detected duplicate test case"), seenTestCases.add(serializedTestCase);
}
function isSerializable(value, seenObjects = /* @__PURE__ */ new Set()) {
	if (!isSerializablePrimitiveOrPlainObject(value)) return !1;
	if (typeof value != "object" || !value) return !0;
	if (seenObjects.has(value)) return !1;
	for (let property in value) {
		if (!Object.hasOwn(value, property)) continue;
		let prop = value[property];
		if (!isSerializablePrimitiveOrPlainObject(prop) || !(typeof prop != "object" || !prop) && !isSerializable(prop, new Set([...seenObjects, value]))) return !1;
	}
	return !0;
}
function isSerializablePrimitiveOrPlainObject(value) {
	return value === null || typeof value == "string" || typeof value == "boolean" || typeof value == "number" || typeof value == "object" && (value.constructor === Object || isArray(value));
}
export { RuleTester, definePlugin, defineRule };
