import { n as lint } from "./bindings.js";
let loadPlugin = null, setupConfigs = null, lintFile = null;
function loadPluginWrapper(path, packageName) {
	return loadPlugin === null ? import("./plugins.js").then((mod) => ({loadPlugin, lintFile, setupConfigs} = mod, loadPlugin(path, packageName))) : loadPlugin(path, packageName);
}
function setupConfigsWrapper(optionsJSON) {
	setupConfigs(optionsJSON);
}
function lintFileWrapper(filePath, bufferId, buffer, ruleIds, optionsIds, settingsJSON) {
	return lintFile(filePath, bufferId, buffer, ruleIds, optionsIds, settingsJSON);
}
await lint(process.argv.slice(2), loadPluginWrapper, setupConfigsWrapper, lintFileWrapper) || (process.exitCode = 1);
export {};
