import type { LocalUser } from "./LocalUser";
/**
 * Backup of user data. This struct should never be changed so that the data can be used as a
 * long-term backup in case the instance goes down unexpectedly. All fields are optional to allow
 * importing partial backups.
 *
 * This data should not be parsed by apps/clients, but directly downloaded as a file.
 *
 * Be careful with any changes to this struct, to avoid breaking changes which could prevent
 * importing older backups.
 */
export type UserSettingsBackup = {
    display_name?: string;
    bio?: string;
    avatar?: string;
    banner?: string;
    matrix_id?: string;
    bot_account?: boolean;
    settings?: LocalUser;
    followed_communities: Array<string>;
    saved_posts: Array<string>;
    saved_comments: Array<string>;
    blocked_communities: Array<string>;
    blocked_users: Array<string>;
    blocked_instances_communities: Array<string>;
    blocked_instances_persons: Array<string>;
    blocking_keywords: Array<string>;
    discussion_languages: Array<string>;
};
