import type { CommunityId } from "./CommunityId";
import type { DbUrl } from "./DbUrl";
import type { TagId } from "./TagId";
/**
 * A tag that is created by community moderators, and assigned to posts by the creator
 * or by mods.
 */
export type Tag = {
    id: TagId;
    ap_id: DbUrl;
    name: string;
    display_name?: string;
    description?: string;
    /**
     * The community that this tag belongs to
     */
    community_id: CommunityId;
    published_at: string;
    updated_at?: string;
    deleted: boolean;
};
