import type { DbUrl } from "./DbUrl";
import type { PersonId } from "./PersonId";
import type { PrivateMessageId } from "./PrivateMessageId";
/**
 * A private message.
 */
export type PrivateMessage = {
    id: PrivateMessageId;
    creator_id: PersonId;
    recipient_id: PersonId;
    content: string;
    deleted: boolean;
    published_at: string;
    updated_at?: string;
    ap_id: DbUrl;
    local: boolean;
    removed: boolean;
};
