import type { Community } from "./Community";
import type { CommunityActions } from "./CommunityActions";
import type { ImageDetails } from "./ImageDetails";
import type { Person } from "./Person";
import type { PersonActions } from "./PersonActions";
import type { Post } from "./Post";
import type { PostActions } from "./PostActions";
import type { TagsView } from "./TagsView";
/**
 * A post view.
 */
export type PostView = {
    post: Post;
    creator: Person;
    community: Community;
    image_details?: ImageDetails;
    community_actions?: CommunityActions;
    person_actions?: PersonActions;
    post_actions?: PostActions;
    creator_is_admin: boolean;
    tags: TagsView;
    can_mod: boolean;
    creator_banned: boolean;
    creator_ban_expires_at?: string;
    creator_is_moderator: boolean;
    creator_banned_from_community: boolean;
    creator_community_ban_expires_at?: string;
};
